/************************************************************************
* FILE:         fc_dataservices_DABClientHandler.h
* PROJECT:      G3g
* SW-COMPONENT: fc_dataservices
* ----------------------------------------------------------------------
*
* DESCRIPTION:  CCA, DBus Message Handler Class for 
*				fc_dataservices component
*
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:
* Date      | Author            | Modification
* 24.09.2014 | Raghavendra Nannuru Vutkuru (RBEI/ECV2)    | initial version
*************************************************************************/
#ifndef _FC_DATASERVICES_DBUSSTUB_H_
#define _FC_DATASERVICES_DBUSSTUB_H_

#include "org/bosch/cm/DataServicesStub.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "fc_dataservices_DSMHandler.h"

using namespace ::asf::core;
using namespace ::org::bosch::cm::DataServices;
using namespace std;

namespace fc_dataservices { namespace Server {

class fc_dataservices_DBusStub :public DAB_Singleton<fc_dataservices_DBusStub>,
	public DataServicesStub		 
	{
	public:
		fc_dataservices_DBusStub();
		~fc_dataservices_DBusStub();

		/*-----------------DBus Functions-----------------------*/
		virtual tVoid onFID_DAB_S_ENABLE_USERAPPRequest (const ::boost::shared_ptr< FID_DAB_S_ENABLE_USERAPPRequest >& request);

		virtual tVoid onFID_DAB_S_GET_USERAPP_EPGRequest (const ::boost::shared_ptr< FID_DAB_S_GET_USERAPP_EPGRequest >& request) ;

		virtual tVoid onFID_DAB_GET_LOGOLISTRequest (const ::boost::shared_ptr< FID_DAB_GET_LOGOLISTRequest >& request);	

		virtual tVoid onFID_DAB_GET_LOGORequest (const ::boost::shared_ptr< FID_DAB_GET_LOGORequest >& request) ;
		
		tVoid vUpdateStationLogoList(vector< ::com::dab::midw_ext_dabtuner_fi_types::T_DAB_LogoElement> rLogoData);		
		tVoid vUpdateStationLogo(tU32 u32ServiceId,string sLogoLink);

		tVoid vUpdateSlide(vector<tU8> u8VectorData , Dataservices_tenSlideState enSlideState);
		tVoid vSendUserAppStatus(tU32 u32SID, tU8 u8Status);
		
		tVoid vUpdateContentid(vector<tclDABServiceManager::tEPGContentIdDataType> m_CtIDList);
		
		tclDABServiceManager::tEPGContentIdDataType rGetContentId(tU32 u32Sid);
	private:
		vector<tclDABServiceManager::tEPGContentIdDataType> m_DSList;	
		fc_dataservices_DSMHandler* m_pDSMHandler;
	
	};
}}
#endif