/************************************************************************
* FILE:         DataservicesComponent.cpp
* PROJECT:      G3g
* SW-COMPONENT: fc_dataservices
* ----------------------------------------------------------------------
*
* DESCRIPTION:  Main Classs for fc_dataservices component
*
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:
* Date      | Author            | Modification
* 24.09.2014 | Raghavendra Nannuru Vutkuru (RBEI/ECV2)    | initial version
* 13.07.2015 | Raghavendra Nannuru Vutkuru (RBEI/ECV2)    | changed name
* to DataservicesComponent and moved out creation of CCA proxy to 
* fc_dataservices_DABClientHandle
* 15.09.2016 | Raghavendra Nannuru Vutkuru (RBEI/ECO)    
* added below optimizations for copying database 
* 1. from /var/opt/bosch/dynamic to /tmp during startup
* 2. from /tmp to /var/opt/bosch/dynamic during shutdown
*************************************************************************/

#include "DataservicesComponent.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#include <errno.h>
#include "fc_dataservices_defines.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DATASRVCS_SERVER_COMP
#include "trcGenProj/Header/DataservicesComponent.cpp.trc.h"
#endif

#include <iostream>
#include <fstream>
#include <sys/wait.h>

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"

namespace fc_dataservices { namespace Server {
	using namespace ::org::genivi::NodeStateManager::Consumer;
	using namespace ::org::genivi::NodeStateManager::LifeCycleConsumer;
	using namespace ::org::genivi::NodeStateManager::LifecycleControl;
	using namespace ::org::bosch::cm::lcm;
	using namespace ::org::bosch::cm::lcm::lcmbaseappcomponent;
	using namespace ::asf::core;	
	using namespace std;

	/*******************************************************************************
	*
	* FUNCTION: DataservicesComponent::DataservicesComponent() 
	*
	* DESCRIPTION: Constructor.
	*
	* PARAMETER: None
	*
	* RETURNVALUE: None.
	*
	*******************************************************************************/
	DataservicesComponent::DataservicesComponent() :	
		m_LcmAppComponent(/*busname*/ "fc_dataservices.Server.DataservicesApplication",		
		"/org/genivi/NodeStateManager/LifeCycleConsumer/DataservicesApplication",
		*this)
	{			
		ET_TRACE_OPEN;
		LOG_INFO("DataservicesComponent");
		ETG_TRACE_USR1(("DataservicesComponent"));
		m_LcmAppComponent.setAppStartReady();
		
		if(bAreDABDataServicesEnabled()){		
				ETG_TRACE_USR4(("Error no is : %d Desc: %s", errno,strerror(errno)));
				 /*if /var/opt/bosch/dynamic/dsmdb.done exits copy dsmdb.sqlite3 to /tmp else create dsmdb.done */
				 if(bFileExists("/var/opt/bosch/dynamic/dsmdb.done")){
					vCopyDatabase();
					ETG_TRACE_USR4(("Error no is : %d Desc: %s", errno,strerror(errno)));
				 }	
				 else{
					 vCreateFile("/var/opt/bosch/dynamic/dsmdb.done");
					 ETG_TRACE_USR4(("Created dsmdb.done in /var/opt/bosch/dynamic/"));
				 }
				 
				fc_dataservices_DABClientHandler::instance();
				fc_dataservices_DBusStub::instance();
		}
		else
		{
			ETG_TRACE_FATAL(("DAB is not enabled"));
		}
		
	}

	/*******************************************************************************
	*
	* FUNCTION: DataservicesComponent::~DataservicesComponent() 
	*
	* DESCRIPTION: Destructor.
	*
	* PARAMETER: None
	*
	* RETURNVALUE: None.
	*
	*******************************************************************************/
	DataservicesComponent::~DataservicesComponent() {
		ET_TRACE_CLOSE;	

	}
	/*******************************************************************************
	*
	* FUNCTION: DataservicesComponent::onAvailable 
	*
	* DESCRIPTION: This function is called from the ASF framework if proxy created 
	*			   for our service is available.
	*			   creates fc_dataservices_MessageHandler object.
	*
	* PARAMETER: const ::boost::shared_ptr< asf::core::Proxy >& proxy,
	*			 const ServiceStateChange &stateChange
	*
	* RETURNVALUE: void.
	*
	*******************************************************************************/
	tVoid DataservicesComponent::onAvailable(
		const ::boost::shared_ptr< asf::core::Proxy >& proxy,
		const ServiceStateChange &stateChange) {
			(tVoid)proxy;
			(tVoid)stateChange;
			LOG_INFO("Service is available");
			ETG_TRACE_USR1(("Service is available"));
			
			m_LcmAppComponent.setAppStartReady();
	}

	/*******************************************************************************
	*
	* FUNCTION: DataservicesComponent::onUnavailable 
	*
	* DESCRIPTION: This function is called from the ASF framework if proxy created 
	*			   for our service is available.
	*			   creates fc_dataservices_MessageHandler object.
	*
	* PARAMETER: const ::boost::shared_ptr< asf::core::Proxy >& proxy,
	*			 const ServiceStateChange &stateChange
	*
	* RETURNVALUE: void.
	*
	*******************************************************************************/
	tVoid DataservicesComponent::onUnavailable(
		const ::boost::shared_ptr< asf::core::Proxy >& proxy,
		const ServiceStateChange &stateChange) {

			LOG_INFO("Service is unavailable");
			//m_DbusStub.reset();	
			(tVoid)stateChange;
			(tVoid)proxy;
			ETG_TRACE_USR4(("Service is unavailable"));
	}
	/*******************************************************************************
	*
	* FUNCTION: DataservicesComponent::OnAppWatchdog 
	*
	* DESCRIPTION: This function is called from the LCMBaseApp if the application
	*			   watchdog timer has run out
	*
	* PARAMETER: None
	*
	* RETURNVALUE: bool.
	*
	*******************************************************************************/
	bool DataservicesComponent::OnAppWatchdog(){
		bool returnVal = false;
		LOG_INFO("OnAppWatchdog ...........");
		ETG_TRACE_USR1(("OnAppWatchdog"));

		// TBD :-check consistency of your app here

		returnVal = true; // only if all is OK
		return returnVal;
	}
	/*******************************************************************************
	*
	* FUNCTION: DataservicesComponent::OnLcmRegistered 
	*
	* DESCRIPTION: This function is called from the LCMBaseApp if LCM services have
	*			   been registered
	*
	* PARAMETER: None
	*
	* RETURNVALUE: void.
	*
	*******************************************************************************/
	tVoid DataservicesComponent::OnLcmRegistered()	{
		LOG_INFO("OnLcmRegistered ...........");
		ETG_TRACE_USR4(("OnLcmRegistered ..........."));
	}

	/*******************************************************************************
	*
	* FUNCTION: DataservicesComponent::onLoadPersistency 
	*
	* DESCRIPTION: This function is called from the LCMBaseApp before the App change
	*			   request to RunUp
	*
	* PARAMETER: None
	*
	* RETURNVALUE: void.
	*
	*******************************************************************************/	
	tVoid DataservicesComponent::onLoadPersistency() {
		LOG_INFO("onLoadPersistency ...........");
		ETG_TRACE_USR4(("onLoadPersistency ..........."));
		
	};

	/*******************************************************************************
	*
	* FUNCTION: DataservicesComponent::onSavePersistency 
	*
	* DESCRIPTION: This function is called from the LCMBaseApp after the App change
	*			   request to Shutdown
	*
	* PARAMETER: None
	*
	* RETURNVALUE: void.
	*
	*******************************************************************************/
	tVoid DataservicesComponent::onSavePersistency()	{
		LOG_INFO("onSavePersistency ...........");
		ETG_TRACE_USR4(("onSavePersistency ..........."));
		if(bAreDABDataServicesEnabled()){
				char  *copy_argv[10];
				copy_argv[0] = (char *)"rsync";
				copy_argv[1] = (char *)"--inplace";
				copy_argv[2] = (char *)"--no-whole-file";
				copy_argv[3] = (char *)"-c";
				copy_argv[4] = (char *)"-B=4096";
				copy_argv[5] = (char *)"/tmp/dsmdb.sqlite3";
				copy_argv[6]= (char *)"/var/opt/bosch/dynamic/dsmdb.sqlite3";
				copy_argv[7] = NULL;

				fc_dataservices_DABClientHandler::instance()->vCloseDataBase();
				ETG_TRACE_USR4(("Error no after close call is : %d Desc: %s", errno,strerror(errno)));
				if(bFileExists("/var/opt/bosch/dynamic/dsmdb.done")){	
					int rc = -1;
					 rc= rename("/var/opt/bosch/dynamic/dsmdb.done" , "/var/opt/bosch/dynamic/dsmdb.fail");
					 ETG_TRACE_USR4(("Error no after rename call is : %d ReturnVal %d Desc: %s", errno,rc, strerror(errno)));
				 }
				 if(bFileExists("/var/opt/bosch/dynamic/dsmdb.fail")){
					 ETG_TRACE_USR4((".FAIL FILE created"));
				 }
				 
				 int fileOpenCount =0 ;
				 while(bFileExists("/tmp/dsmdb.sqlite3-wal")){		
					 ETG_TRACE_USR4(("dsmdb.sqlite3-wal exists"));
					 fileOpenCount++;
					 if(fileOpenCount >= 50)
					 {
					 	ETG_TRACE_USR4(("fileOpenCount  is greater than 50"));
						 fc_dataservices_DABClientHandler::instance()->vCloseDataBase();
						 fileOpenCount =0;
						 sleep(1);
					 }					 
				 }
				 
				// Non root implementation starts
				pid_t  pid;
				int status;			
				int u8Result = 0;
				if ((pid = fork()) < 0) 
				{     /* fork a child process */
					  ETG_TRACE_USR4(("ERROR: forking child process failed\n"));
				}
				else if (pid == 0) 
				{ /* child process execution*/
				  u8Result = execvp(*copy_argv, copy_argv);
				  if (u8Result < 0) 
				  {     
					  ETG_TRACE_USR4(("*** ERROR: exec failed\n"));
					  exit(1);
				  }
				}
				else
				{
					while (wait(&status) != pid) // parent process wait for child process to complete
						;
				}
				// Non root implementation ends
				//int u8Result = -1;
				//u8Result = system("rsync --inplace --no-whole-file -c -B=4096 /tmp/dsmdb.sqlite3 /var/opt/bosch/dynamic/dsmdb.sqlite3");
				ETG_TRACE_USR4(("Rsync Result is %d", u8Result));
				ETG_TRACE_USR4(("Error no is after differential copy is : %d Desc: %s", errno,strerror(errno)));
				 if(bFileExists("/var/opt/bosch/dynamic/dsmdb.sqlite3")&& (u8Result==0)){
					 int rc = -1;
					 rc = rename("/var/opt/bosch/dynamic/dsmdb.fail","/var/opt/bosch/dynamic/dsmdb.done");			 
					 ETG_TRACE_USR4(("Error no after second rename call is : %d ReturnVal %d Desc: %s", errno,rc,strerror(errno)));
				 }
				 fc_dataservices_DABClientHandler::instance()->vFreeObjects();
				 /*if(m_pDABHandler != NULL)
				 {
					OSAL_DELETE m_pDABHandler;
					m_pDABHandler=OSAL_NULL;
					ETG_TRACE_USR4((" DELETED m_pDABHandler"));
				 }		*/
		}
	};
	/*******************************************************************************
	*
	* FUNCTION: DataservicesComponent::OnAppModeChange 
	*
	* DESCRIPTION: This function is called from the LcmBaseAppComponent if a new
	*			   application mode is requested from LCM,here the transition actions 
	*			   need to be done
	*
	* PARAMETER: _Nsm_Shutdown_Type_e newAppMode,
	*			 _Nsm_Shutdown_Type_e oldAppMode
	*
	* RETURNVALUE: _NsmErrorStatus_e.
	*
	*******************************************************************************/
	_NsmErrorStatus_e DataservicesComponent::OnAppModeChange(
		_Nsm_Shutdown_Type_e newAppMode,
		_Nsm_Shutdown_Type_e oldAppMode){

			(tVoid)oldAppMode;
			_NsmErrorStatus_e returnVal = _NsmErrorStatus_e__NsmErrorStatus_NotSet;

			LOG_INFO("OnAppModeChange - %i", newAppMode);
			ETG_TRACE_USR4(("OnAppModeChange - %d", newAppMode));

			if(newAppMode == _Nsm_Shutdown_Type_e__NSM_Shutdown_Type_Runup) 
			{
				// goto Normal Mode
				returnVal = _NsmErrorStatus_e__NsmErrorStatus_Ok; // if successfull
			}
			else if(newAppMode == _Nsm_Shutdown_Type_e__Nsm_Shutdown_Type_Normal)
			{
				
		ETG_TRACE_USR4(("Error no is : %d Desc: %s", errno,strerror(errno)));
					
				// goto OFF Mode
				returnVal = _NsmErrorStatus_e__NsmErrorStatus_Ok; // if successfull
			}

			return returnVal;
	} 
	/******************************************************************************
	*
	* FUNCTION: DataservicesComponent::onExpired 
	*
	* DESCRIPTION: This function is called from the ASF framework if any of timers 
	*			   has expired.
	*
	* PARAMETER: asf::core::Timer&
	*			 asf::core::TimerPayload
	*
	* RETURNVALUE: void.
	*
	*******************************************************************************/
	tVoid DataservicesComponent::onExpired(
		asf::core::Timer& timer,
		boost::shared_ptr<asf::core::TimerPayload> payload)	{

			LOG_INFO("onExpired ...........");
			(tVoid)timer;
			(tVoid)payload;
	}
	/******************************************************************************
	*
	* FUNCTION: DataservicesComponent::bFileExists 
	*
	* DESCRIPTION: This function checks if a file exists in path provided
	*
	* PARAMETER: string
	*
	* RETURNVALUE: bool.
	*
	*******************************************************************************/
	bool  DataservicesComponent::bFileExists(string path)
	{

		FILE * fp;
		fp = fopen(path.c_str(), "r");

		if(fp == NULL)
		{
			ETG_TRACE_USR2((  "%s doesnt exist ",path.c_str()));
			return false;
		}
		else
		{
			fclose(fp);
			return true;
		}
	}
	/******************************************************************************
	*
	* FUNCTION: DataservicesComponent::vCreateFile 
	*
	* DESCRIPTION: This function creates a file  in path provided
	*
	* PARAMETER: string
	*
	* RETURNVALUE: bool.
	*
	*******************************************************************************/
	tVoid DataservicesComponent::vCreateFile(string path){
			FILE * pFile;
			pFile = fopen (path.c_str() , "wb");
			if(pFile !=NULL)
				fclose (pFile);		
	}
	/******************************************************************************
	*
	* FUNCTION: DataservicesComponent::vCopyDatabase 
	*
	* DESCRIPTION: This function copies database from RAM to Flash
	*
	* PARAMETER: None
	*
	* RETURNVALUE: tVoid.
	*
	*******************************************************************************/
tVoid DataservicesComponent::vCopyDatabase(){
	std::ifstream in;
    in.open("/var/opt/bosch/dynamic/dsmdb.sqlite3",ios::in);

    std::ofstream out;
    out.open("/tmp/dsmdb.sqlite3",ios::out);
    char ch;
    
	while(in.get(ch)){
       out.put(ch);
    }
    in.close();
    out.close();
ETG_TRACE_USR2((  "FIle copied "));
    
}

tBool DataservicesComponent::bAreDABDataServicesEnabled(){
	tBool bDataservicesEnabled = FALSE;
	tBool bdabEnable = FALSE;
	tBool bSLSEnable = FALSE;
	tBool bEPGEnable = FALSE;
	#ifdef DP_U16_KDSADR_CMVARIANTCODING
				dp_tclKdsCMVariantCoding oVariantCoding;					
				oVariantCoding.u8GetDAB(bdabEnable);
	#endif
	ETG_TRACE_USR4(("bdabEnable - %d", bdabEnable));
	
	#ifdef DP_U16_KDSADR_DABPARAMETERSET
		dp_tclKdsDABParameterSet oDABParamSet;
		oDABParamSet.u8GetEPG(bEPGEnable);
		oDABParamSet.u8GetSLS(bSLSEnable);
	#endif
	
	ETG_TRACE_USR4(("bEPGEnable - %d bSLSEnable %d",bEPGEnable,bSLSEnable));
	
	if((bdabEnable)&&(bSLSEnable || bEPGEnable))
	{
		bDataservicesEnabled = TRUE;
	}
	/* For PSA as EPG is not enabled in KDS, this has to be forcefully set.
	   For Non DAB Variants , this would not be an issue as fc_dataservices is not started at all */
	#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
		bDataservicesEnabled = TRUE;
	#endif
	return bDataservicesEnabled;
}
	DEFINE_CLASS_LOGGER_AND_LEVEL ("DataServices", DataservicesComponent, Info);
}}