#ifndef AARSDABLIB_H
#define AARSDABLIB_H
/*!
*******************************************************************************
  @file         aarsDABLib.h

  @brief        <b>AaRS DAB message library</b>

*******************************************************************************
*/

#include "aarsLib.h"

namespace AaRSDABLib
{

namespace API
{

namespace DC
{

/*!
*******************************************************************************
  @brief        <b>class tR_DATACHANNEL_FRAME</b>
*******************************************************************************
*/
class tR_DATACHANNEL_FRAME : public AaRSLib::MSG::tDatachannelMessage
{
private:
    /* static memory buffer ...
     */

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xFFFF,R_DATACHANNEL_FRAME,"R_DATACHANNEL_FRAME",AaRSLib::MSG::tDatachannelMessage);

public:
    /* set/get functions ...
     */
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_d,tU8,0,1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_c,tU8,end__b_d(),1);

    typedef enum {
        b_api_source__SOURCE_API_UNDEFINED  = 0,
        b_api_source__SOURCE_API_DDM        = 1,
        b_api_source__SOURCE_API_DSM        = 2,
        b_api_source__SOURCE_API_EXP        = 3
    } t__b_api_source;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_api_source,b_api_source,tU8,end__b_c(),1);

    typedef enum {
        b_data_source__SOURCE_TYPE_UNDEFINED = 0,
        b_data_source__SOURCE_TYPE_SERV_COMP = 1,
        b_data_source__SOURCE_TYPE_SUBCH     = 2,
        b_data_source__SOURCE_TYPE_FIDC      = 3,
        b_data_source__SOURCE_TYPE_DABFIC    = 4
    } t__b_data_source;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_data_source,b_data_source,tU8,end__b_api_source(),1);

    typedef enum {
        b_data_type__DATA_TYPE_UNDEFINED         = 0,
        b_data_type__DATA_TYPE_PACKETS           = 1,
        b_data_type__DATA_TYPE_DATA_GROUPS       = 2 ,
        b_data_type__DATA_TYPE_STREAM            = 3,
        b_data_type__DATA_TYPE_MOT_HEADER        = 4,
        b_data_type__DATA_TYPE_MOT_BODY          = 5,
        b_data_type__DATA_TYPE_PAD               = 6,
        b_data_type__DATA_TYPE_PAD_DATA_GROUPS   = 7,
        b_data_type__DATA_TYPE_APP_TYPE_PAD      = 8,
        b_data_type__DATA_TYPE_FIB               = 9,
        b_data_type__DATA_TYPE_TMC_CURRENT       = 10,
        b_data_type__DATA_TYPE_TMC_SC            = 11,
        b_data_type__DATA_TYPE_TDC		         = 12,
        b_data_type__DATA_TYPE_RADIOTEXT_CURRENT = 13
    } t__b_data_type;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_data_type,b_data_type,tU8,end__b_data_source(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU32,l_header_size,tU32,end__b_data_type(),4);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tPU8,r_header,tPU8,end__l_header_size(),l_header_size());

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU32,l_body_size,tU32,end__r_header(),4);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tPU8,r_body,tPU8,end__l_body_size(),l_body_size());
}; /* ... class tR_DATACHANNEL_FRAME */

} /* ... namespace DC */

namespace RDM
{
/*!
*******************************************************************************
  @brief        <b>class tC_SET_AUTO_NOTIFICATION</b>
*******************************************************************************
*/
class tC_SET_AUTO_NOTIFICATION : public AaRSLib::MSG::tCommandMessage
{
private:
    /* static memory buffer ...
     */
    tU8 _msgbuf[3];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE34C,C_SET_AUTO_NOTIFICATION,"C_SET_AUTO_NOTIFICATION",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        b_notify_command__SET=0x01,
        b_notify_command__DELETE=0x02,
        b_notify_command__SET_ALL=0x03,
        b_notify_command__DELETE_ALL=0x04,
        b_notify_command__GET_SELECTED=0x05,
        b_notify_command__UNDEF=0
    } t__b_notify_command;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_notify_command,b_notify_command,tU8,0,1);

    typedef enum {
        b_notify_class__RDM=0x01,
        b_notify_class__TUNER=0x02,
        b_notify_class__DAB=0x03,
        b_notify_class__AUDIO=0x05,
    } t__b_notify_class;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_notify_class,b_notify_class,tU8,end__b_notify_command(),1);

    static const tU8 b_notify_message_mask__RDM__RDM_GET_RDM_STATUS = (1<<0);
    static const tU8 b_notify_message_mask__RDM__RDM_GET_RDM_INFO = (1<<1);
    static const tU8 b_notify_message_mask__RDM__RDM_GET_RDM_INFO1 = (1<<1);
    static const tU8 b_notify_message_mask__RDM__RDM_GET_RDM_INFO2 = (1<<2);
    static const tU8 b_notify_message_mask__TUNER__RDM_GET_SIGNAL_QUALITY_LEVEL__0 = (0<<0);
    static const tU8 b_notify_message_mask__TUNER__RDM_GET_SIGNAL_QUALITY_LEVEL__1 = (1<<0);
    static const tU8 b_notify_message_mask__TUNER__RDM_GET_SIGNAL_QUALITY_LEVEL__2 = (2<<0);
    static const tU8 b_notify_message_mask__TUNER__RDM_GET_SIGNAL_QUALITY_LEVEL__3 = (3<<0);
    static const tU8 b_notify_message_mask__TUNER__RDM_GET_SIGNAL_QUALITY_LEVEL__4 = (4<<0);
    static const tU8 b_notify_message_mask__TUNER__RDM_GET_SIGNAL_QUALITY_LEVEL__5 = (5<<0);
    static const tU8 b_notify_message_mask__TUNER__RDM_GET_SIGNAL_QUALITY_LEVEL__6 = (6<<0);
    static const tU8 b_notify_message_mask__TUNER__RDM_GET_SIGNAL_QUALITY_LEVEL__7 = (7<<0);
    static const tU8 b_notify_message_mask__TUNER__RDM_GET_FREQUENCY = (1<<3);
    static const tU8 b_notify_message_mask__TUNER__RDM_DAB_DECODER_STATUS = (1<<4);
    static const tU8 b_notify_message_mask__DAB__RDM_GET_EID = (1<<0);
    static const tU8 b_notify_message_mask__DAB__RDM_GET_DAB_FREQUENCY_LABEL = (1<<1);
    static const tU8 b_notify_message_mask__DAB__RDM_GET_DAB_FREQUENCY_TABLE = (1<<2);
    static const tU8 b_notify_message_mask__AUDIO__GET_DAB_AUDIO_QUALITY_LEVEL__0 = (0<<0);
    static const tU8 b_notify_message_mask__AUDIO__GET_DAB_AUDIO_QUALITY_LEVEL__1 = (1<<0);
    static const tU8 b_notify_message_mask__AUDIO__GET_DAB_AUDIO_QUALITY_LEVEL__2 = (2<<0);
    static const tU8 b_notify_message_mask__AUDIO__GET_DAB_AUDIO_QUALITY_LEVEL__3 = (3<<0);
    static const tU8 b_notify_message_mask__AUDIO__GET_DAB_AUDIO_QUALITY_LEVEL__4 = (4<<0);
    static const tU8 b_notify_message_mask__AUDIO__GET_DAB_AUDIO_QUALITY_LEVEL__5 = (5<<0);
    static const tU8 b_notify_message_mask__AUDIO__GET_DAB_AUDIO_QUALITY_LEVEL__6 = (6<<0);
    static const tU8 b_notify_message_mask__AUDIO__GET_DAB_AUDIO_QUALITY_LEVEL__7 = (7<<0);
    static const tU8 b_notify_message_mask__AUDIO__RDM_GET_DAB_AUDIO_STATUS = (1<<3);
    static const tU8 b_notify_message_mask__AUDIO__RDM_AUDIO_GET_SCIDI = (1<<4);
    static const tU8 b_notify_message_mask__AUDIO__RDM_AUDIO_GET_PSID = (1<<5);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_notify_message_mask,tU8,end__b_notify_class(),1);

public:
    /* custom constructor ...
     */
    tC_SET_AUTO_NOTIFICATION( t__b_notify_command b_notify_command, t__b_notify_class b_notify_class, tU8 b_notify_message_mask )
        : AaRSLib::MSG::tCommandMessage(OP_CODE, sizeof(_msgbuf), _msgbuf)
    {
        tU32 o = 0;
        o = set_tU8(o,b_notify_command);
        o = set_tU8(o,b_notify_class);
        o = set_tU8(o,b_notify_message_mask);
    }

}; /* ... class tC_SET_AUTO_NOTIFICATION */

/*!
*******************************************************************************
  @brief        <b>class tR_SET_AUTO_NOTIFICATION</b>
*******************************************************************************
*/
class tR_SET_AUTO_NOTIFICATION : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    tU8 _msgbuf[2];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE34D,R_SET_AUTO_NOTIFICATION,"R_SET_AUTO_NOTIFICATION",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        b_notify_class__RDM=0x01,
        b_notify_class__TUNER=0x02,
        b_notify_class__DAB=0x03,
        b_notify_class__AUDIO=0x05,
    } t__b_notify_class;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_notify_class,b_notify_class,tU8,0,1);

    static const tU8 b_notify_message_mask__RDM__RDM_SERV_FOLLOW_SET_MODE = (1<<0);
    static const tU8 b_notify_message_mask__RDM__RDM_GET_RDM_INFO = (1<<1);
    static const tU8 b_notify_message_mask__TUNER__RDM_GET_SIGNAL_QUALITY_LEVEL__0 = (0<<0);
    static const tU8 b_notify_message_mask__TUNER__RDM_GET_SIGNAL_QUALITY_LEVEL__1 = (1<<0);
    static const tU8 b_notify_message_mask__TUNER__RDM_GET_SIGNAL_QUALITY_LEVEL__2 = (2<<0);
    static const tU8 b_notify_message_mask__TUNER__RDM_GET_SIGNAL_QUALITY_LEVEL__3 = (3<<0);
    static const tU8 b_notify_message_mask__TUNER__RDM_GET_SIGNAL_QUALITY_LEVEL__4 = (4<<0);
    static const tU8 b_notify_message_mask__TUNER__RDM_GET_SIGNAL_QUALITY_LEVEL__5 = (5<<0);
    static const tU8 b_notify_message_mask__TUNER__RDM_GET_SIGNAL_QUALITY_LEVEL__6 = (6<<0);
    static const tU8 b_notify_message_mask__TUNER__RDM_GET_SIGNAL_QUALITY_LEVEL__7 = (7<<0);
    static const tU8 b_notify_message_mask__TUNER__RDM_GET_FREQUENCY = (1<<3);
    static const tU8 b_notify_message_mask__DAB__RDM_GET_EID = (1<<0);
    static const tU8 b_notify_message_mask__DAB__RDM_GET_DAB_FREQUENCY_LABEL = (1<<1);
    static const tU8 b_notify_message_mask__DAB__RDM_GET_DAB_FREQUENCY_TABLE = (1<<2);
    static const tU8 b_notify_message_mask__AUDIO__GET_DAB_AUDIO_QUALITY_LEVEL__0 = (0<<0);
    static const tU8 b_notify_message_mask__AUDIO__GET_DAB_AUDIO_QUALITY_LEVEL__1 = (1<<0);
    static const tU8 b_notify_message_mask__AUDIO__GET_DAB_AUDIO_QUALITY_LEVEL__2 = (2<<0);
    static const tU8 b_notify_message_mask__AUDIO__GET_DAB_AUDIO_QUALITY_LEVEL__3 = (3<<0);
    static const tU8 b_notify_message_mask__AUDIO__GET_DAB_AUDIO_QUALITY_LEVEL__4 = (4<<0);
    static const tU8 b_notify_message_mask__AUDIO__GET_DAB_AUDIO_QUALITY_LEVEL__5 = (5<<0);
    static const tU8 b_notify_message_mask__AUDIO__GET_DAB_AUDIO_QUALITY_LEVEL__6 = (6<<0);
    static const tU8 b_notify_message_mask__AUDIO__GET_DAB_AUDIO_QUALITY_LEVEL__7 = (7<<0);
    static const tU8 b_notify_message_mask__AUDIO__RDM_GET_DAB_AUDIO_STATUS = (1<<3);
    static const tU8 b_notify_message_mask__AUDIO__RDM_AUDIO_GET_SCIDI = (1<<4);
    static const tU8 b_notify_message_mask__AUDIO__RDM_AUDIO_GET_PSID = (1<<5);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_notify_message_mask,tU8,end__b_notify_class(),1);

}; /* ... class tR_SET_AUTO_NOTIFICATION */

/*!
*******************************************************************************
  @brief        <b>class tC_SET_DAB_FREQUENCY_TABLE</b>
*******************************************************************************
*/
class tC_SET_DAB_FREQUENCY_TABLE : public AaRSLib::MSG::tCommandMessage
{
    /* static memory buffer ...
     */
    tU8 _msgbuf[1];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE322,C_SET_DAB_FREQUENCY_TABLE,"C_SET_DAB_FREQUENCY_TABLE",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        b_frequency_table__FREQUENCY_TABLE_EUROPE=0x11,
        b_frequency_table__FREQUENCY_TABLE_CANADA=0x12,
        b_frequency_table__FREQUENCY_TABLE_EUROPE_NEW=0x13,
        b_frequency_table__FREQUENCY_TABLE_EUROPE_BAND3=0x14,
        b_frequency_table__FREQUENCY_TABLE_EUROPE_BAND3_NEW=0x15,
        b_frequency_table__FREQUENCY_TABLE_EUROPE_LBAND=0x16,
        b_frequency_table__FREQUENCY_TABLE_KOREA=0x17,
        b_frequency_table__FREQUENCY_TABLE_CHINA=0x18,
        b_frequency_table__FREQUENCY_TABLE_CHINA_BAND3=0x19,
        b_frequency_table__FREQUENCY_TABLE_CHINA_LBAND=0x1a,
        b_frequency_table__FREQUENCY_TABLE_NEWZEALAND=0x1b,
        b_frequency_table____FREQUENCY_TABLE_CUSTOM_0xF0=0xF0,
        b_frequency_table____FREQUENCY_TABLE_CUSTOM_0xF1=0xF1,
        b_frequency_table____FREQUENCY_TABLE_CUSTOM_0xF2=0xF2,
        b_frequency_table____FREQUENCY_TABLE_CUSTOM_0xF3=0xF3,
        b_frequency_table____FREQUENCY_TABLE_CUSTOM_0xF4=0xF4,
        b_frequency_table____FREQUENCY_TABLE_CUSTOM_0xF5=0xF5,
        b_frequency_table____FREQUENCY_TABLE_CUSTOM_0xF6=0xF6,
        b_frequency_table____FREQUENCY_TABLE_CUSTOM_0xF7=0xF7,
        b_frequency_table____FREQUENCY_TABLE_CUSTOM_0xF8=0xF8,
        b_frequency_table____FREQUENCY_TABLE_CUSTOM_0xF9=0xF9,
        b_frequency_table____FREQUENCY_TABLE_CUSTOM_0xFA=0xFa,
        b_frequency_table____FREQUENCY_TABLE_CUSTOM_0xFB=0xFb,
        b_frequency_table____FREQUENCY_TABLE_CUSTOM_0xFC=0xFc,
        b_frequency_table____FREQUENCY_TABLE_CUSTOM_0xFD=0Xfd,
        b_frequency_table____FREQUENCY_TABLE_CUSTOM_0xFE=0xFE,
        b_frequency_table____FREQUENCY_TABLE_CUSTOM_0xFF=0xFF,
    } t__b_frequency_table;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_frequency_table,b_frequency_table,tU8,0,1);

public:
    /* custom constructor ...
     */
    tC_SET_DAB_FREQUENCY_TABLE( t__b_frequency_table b_frequency_table )
        : AaRSLib::MSG::tCommandMessage(OP_CODE, sizeof(_msgbuf), _msgbuf)
    {
        tU32 o = 0;
        o = set_tU8(o,b_frequency_table);
    }

}; /* ... class tC_SET_DAB_FREQUENCY_TABLE */

/*!
*******************************************************************************
  @brief        <b>class tR_SET_DAB_FREQUENCY_TABLE</b>
*******************************************************************************
*/
class tR_SET_DAB_FREQUENCY_TABLE : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[5];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE323,R_SET_DAB_FREQUENCY_TABLE,"R_SET_DAB_FREQUENCY_TABLE",AaRSLib::MSG::tResponseMessage);

public:
    /* OP_CODE, methodname and default constructor ...
     */
    typedef enum {
        b_frequency_table__FREQUENCY_TABLE_EUROPE=0x11,
        b_frequency_table__FREQUENCY_TABLE_CANADA=0x12,
        b_frequency_table__FREQUENCY_TABLE_EUROPE_NEW=0x13,
        b_frequency_table__FREQUENCY_TABLE_EUROPE_BAND3=0x14,
        b_frequency_table__FREQUENCY_TABLE_EUROPE_BAND3_NEW=0x15,
        b_frequency_table__FREQUENCY_TABLE_EUROPE_LBAND=0x16,
        b_frequency_table__FREQUENCY_TABLE_KOREA=0x17,
        b_frequency_table__FREQUENCY_TABLE_CHINA=0x18,
        b_frequency_table__FREQUENCY_TABLE_CHINA_BAND3=0x19,
        b_frequency_table__FREQUENCY_TABLE_CHINA_LBAND=0x1a,
        b_frequency_table__FREQUENCY_TABLE_NEWZEALAND=0x1b,
        b_frequency_table____FREQUENCY_TABLE_CUSTOM_0xF0=0xF0,
        b_frequency_table____FREQUENCY_TABLE_CUSTOM_0xF1=0xF1,
        b_frequency_table____FREQUENCY_TABLE_CUSTOM_0xF2=0xF2,
        b_frequency_table____FREQUENCY_TABLE_CUSTOM_0xF3=0xF3,
        b_frequency_table____FREQUENCY_TABLE_CUSTOM_0xF4=0xF4,
        b_frequency_table____FREQUENCY_TABLE_CUSTOM_0xF5=0xF5,
        b_frequency_table____FREQUENCY_TABLE_CUSTOM_0xF6=0xF6,
        b_frequency_table____FREQUENCY_TABLE_CUSTOM_0xF7=0xF7,
        b_frequency_table____FREQUENCY_TABLE_CUSTOM_0xF8=0xF8,
        b_frequency_table____FREQUENCY_TABLE_CUSTOM_0xF9=0xF9,
        b_frequency_table____FREQUENCY_TABLE_CUSTOM_0xFA=0xFa,
        b_frequency_table____FREQUENCY_TABLE_CUSTOM_0xFB=0xFb,
        b_frequency_table____FREQUENCY_TABLE_CUSTOM_0xFC=0xFc,
        b_frequency_table____FREQUENCY_TABLE_CUSTOM_0xFD=0Xfd,
        b_frequency_table____FREQUENCY_TABLE_CUSTOM_0xFE=0xFE,
        b_frequency_table____FREQUENCY_TABLE_CUSTOM_0xFF=0xFF,
    } t__b_frequency_table;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_frequency_table,b_frequency_table,tU8,0,1);

}; /* ... class tR_SET_DAB_FREQUENCY_TABLE */

/*!
*******************************************************************************
  @brief        <b>class tC_GET_AUDIO_STATUS</b>
*******************************************************************************
*/
class tC_GET_AUDIO_STATUS : public AaRSLib::MSG::tCommandMessage
{
    /* static memory buffer ...
     */
    tU8 _msgbuf[1];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE342,C_GET_AUDIO_STATUS,"C_GET_AUDIO_STATUS",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        b_mode__UNDEF=0x00,
        b_mode__DAB=0x01,
        b_mode__DABDMB=0x02,
    } t__b_mode;

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_mode,b_mode,tU8,0,1);

public:
    /* custom constructor ...
     */
    tC_GET_AUDIO_STATUS( t__b_mode b_mode )
        : AaRSLib::MSG::tCommandMessage(OP_CODE, sizeof(_msgbuf), _msgbuf)
    {
        tU32 o = 0;
        o = set_tU8(o,b_mode);
    }
};

/*!
*******************************************************************************
  @brief        <b>class tR_GET_AUDIO_STATUS</b>
*******************************************************************************
*/
class tR_GET_AUDIO_STATUS : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[5];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE343,R_GET_AUDIO_STATUS,"R_GET_AUDIO_STATUS",AaRSLib::MSG::tResponseMessage);

public:
    /* OP_CODE, methodname and default constructor ...
     */
    typedef enum {
        b_mode__UNDEF=0x00,
        b_mode__DAB=0x01,
        b_mode__DABDMB=0x02,
    } t__b_mode;

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_mode,b_mode,tU8,0,1);

    // b_mode__DABDMB + b_mode__DAB
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_audio_state_1,tU8,end__b_mode(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_audio_state_2,tU8,end__b_audio_state_1(),1);

    // b_mode__DABDMB
    typedef enum {
        b_channel_type__DAB=0x01,
        b_channel_type__DABPLUS=0x02,
        b_channel_type__DMB=0x03,
    } t__b_channel_type;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_channel_type,b_channel_type,tU8,end__b_audio_state_2(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_subch_id,tU8,end__b_channel_type(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_audio_ber_level,tU8,end__b_subch_id(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_fec_corr_level,tU8,end__b_audio_ber_level(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_conc_level,tU8,end__b_fec_corr_level(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_prot_level,tU8,end__b_conc_level(),1);
    typedef enum {
        b_mute_flag__UNMUTE=0,
        b_mute_flag__MUTE=1,
    } t__b_mute_flag;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_mute_flag,b_mute_flag,tU8,end__b_prot_level(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_header_crc_err_cnt,tU8,end__b_mute_flag(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_scf_crc_err_cnt,tU8,end__b_header_crc_err_cnt(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_equalizer_level,tU8,end__b_scf_crc_err_cnt(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_ms_flag,tU8,end__b_equalizer_level(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_audio_mode,tU8,end__b_ms_flag(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_core_audio_decoding,tU8,end__b_audio_mode(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_drc_status,tU8,end__b_core_audio_decoding(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_drc_scaling,tU8,end__b_drc_status(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU16,w_audio_bitrate,tU16,end__b_drc_scaling(),2);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_orgional_flag,tU8,end__w_audio_bitrate(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_copyright_flag,tU8,end__b_orgional_flag(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_dac_rate,tU8,end__b_copyright_flag(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_sbr_flag,tU8,end__b_dac_rate(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_aac_channel_mode,tU8,end__b_sbr_flag(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_ps_flag,tU8,end__b_aac_channel_mode(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_mpeg_surround_config,tU8,end__b_ps_flag(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_rfu,tU8,end__b_mpeg_surround_config(),1);
};

/*!
*******************************************************************************
  @brief        <b>class tC_AUDIO_PLAY_SERVICE</b>
*******************************************************************************
*/
class tC_AUDIO_PLAY_SERVICE : public AaRSLib::MSG::tCommandMessage
{
    /* static memory buffer ...
     */
    tU8 _msgbuf[1];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE314,C_AUDIO_PLAY_SERVICE,"C_AUDIO_PLAY_SERVICE",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        b_service_command__PLAY_FIRST=0x01,
        b_service_command__PLAY_LAST=0x02,
        b_service_command__PLAY_PREVIOUS=0x03,
        b_service_command__PLAY_NEXT=0x04,
        b_service_command__UNDEF=0
    } t__b_service_command;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_service_command,b_service_command,tU8,0,1);

public:
    /* custom constructor ...
     */
    tC_AUDIO_PLAY_SERVICE( t__b_service_command b_service_command )
        : AaRSLib::MSG::tCommandMessage(OP_CODE, sizeof(_msgbuf), _msgbuf)
    {
        tU32 o = 0;
        o = set_tU8(o,b_service_command);
    }

}; /* ... class tC_AUDIO_PLAY_SERVICE */

/*!
*******************************************************************************
  @brief        <b>class tR_AUDIO_PLAY_SERVICE</b>
*******************************************************************************
*/
class tR_AUDIO_PLAY_SERVICE : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[5];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE315,R_AUDIO_PLAY_SERVICE,"R_AUDIO_PLAY_SERVICE",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU32,r_programme_service,tU32,0,4);

    typedef enum {
        b_service_state__SERVICE_INVALID=0x00,
        b_service_state__SERVICE_SELECTION_DONE=0x01,
        b_service_state__NO_NEXT_SERVICE=0x02,
        b_service_state__NO_PREVIOUS_SERVICE=0x03,
        b_service_state__WAITING_FOR_SERVICE=0x04
    } t__b_service_state;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_service_state,b_service_state,tU8,end__r_programme_service(),1);

}; /* ... class tR_AUDIO_PLAY_SERVICE */

/*!
*******************************************************************************
  @brief        <b>class tC_AUDIO_COMPONENT_PLAY</b>
*******************************************************************************
*/
class tC_AUDIO_COMPONENT_PLAY : public AaRSLib::MSG::tCommandMessage
{
    /* static memory buffer ...
     */
    tU8 _msgbuf[8];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE346,C_AUDIO_COMPONENT_PLAY,"C_AUDIO_COMPONENT_PLAY",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */
    static const tU16 w_scidi__INVALID = 0xffff;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU16,w_scidi,tU16,0,2);

    static const tU8 b_scids__INVALID = 0xff;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_scids,tU8,end__w_scidi(),1);

    typedef enum {
        b_service_type__AUDIO_SERVICE = 0x01,
        b_service_type__DAB_DATA_SERVICE = 0x02
    } t__b_service_type;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_service_type,b_service_type,tU8,end__b_scids(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU32,r_service,tU32,end__b_service_type(),4);

public:
    /* custom constructor ...
     */
    tC_AUDIO_COMPONENT_PLAY( tU16              w_scidi,
                             tU8               b_scids,
                             t__b_service_type b_service_type,
                             tU32              r_service)
        : AaRSLib::MSG::tCommandMessage(OP_CODE, sizeof(_msgbuf), _msgbuf)
    {
        tU32 o = 0;
        o = set_tU16(o,w_scidi);
        o = set_tU8(o,b_scids);
        o = set_tU8(o,b_service_type);
        o = set_tU32(o,r_service);
    }

    tC_AUDIO_COMPONENT_PLAY( tU16              w_scidi,
                             tU8               b_scids,
                             tU8               b_service_type,
                             tU32              r_service)
        : AaRSLib::MSG::tCommandMessage(OP_CODE, sizeof(_msgbuf), _msgbuf)
    {
        tU32 o = 0;
        o = set_tU16(o,w_scidi);
        o = set_tU8(o,b_scids);
        o = set_tU8(o,b_service_type);
        o = set_tU32(o,r_service);
    }
}; /* ... class tC_AUDIO_COMPONENT_PLAY */

/*!
*******************************************************************************
  @brief        <b>class tR_AUDIO_COMPONENT_PLAY</b>
*******************************************************************************
*/
class tR_AUDIO_COMPONENT_PLAY : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[5];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE347,R_AUDIO_COMPONENT_PLAY,"R_AUDIO_COMPONENT_PLAY",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        b_component_state__INVALID_COMPONENT = 0x00,
        b_component_state__COMPONENT_OK = 0x01
    } t__b_component_state;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_component_state,b_component_state,tU8,0,1);

}; /* ... class tR_AUDIO_COMPONENT_PLAY */

/*!
*******************************************************************************
  @brief        <b>class tC_PLAY_PSID</b>
*******************************************************************************
*/
class tC_PLAY_PSID : public AaRSLib::MSG::tCommandMessage
{
private:
    /* static memory buffer ...
     */
    tU8 _msgbuf[4];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE316,C_PLAY_PSID,"C_PLAY_PSID",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU32,r_audio_service,tU32,0,4);

public:
    /* custom constructor ...
     */
    tC_PLAY_PSID( tU32 r_audio_service )
        : AaRSLib::MSG::tCommandMessage(OP_CODE, sizeof(_msgbuf), _msgbuf)
    {
        tU32 o = 0;
        o = set_tU32(o,r_audio_service);
    }

}; /* ... class tC_PLAY_PSID */

/*!
*******************************************************************************
  @brief        <b>class tR_PLAY_PSID</b>
*******************************************************************************
*/
class tR_PLAY_PSID : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    tU8 _msgbuf[4];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE317,R_PLAY_PSID,"R_PLAY_PSID",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU32,r_audio_service,tU32,0,4);

    typedef enum {
        b_service_state__SERVICE_INVALID=0x00,
        b_service_state__SERVICE_SELECTION_DONE=0x01,
        b_service_state__WAITING_FOR_SERVICE=0x04,
        b_service_state__PSID_NOT_AVAILABLE=0x06
    } t__b_service_state;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_service_state,b_service_state,tU8,end__r_audio_service(),1);

}; /* ... class tR_PLAY_PSID */

/*!
*******************************************************************************
  @brief        <b>class tC_AUDIO_GET_PSID</b>
*******************************************************************************
*/
class tC_AUDIO_GET_PSID : public AaRSLib::MSG::tCommandMessage
{
private:
    /* static memory buffer ...
     */

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE310,C_AUDIO_GET_PSID,"C_AUDIO_GET_PSID",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */

public:
    /* custom constructor ...
     */
#if 0
    tC_AUDIO_GET_PSID( )
        : AaRSLib::MSG::tCommandMessage(OP_CODE, 0, NULL)
    {
    }
#endif

}; /* ... class tC_AUDIO_GET_PSID */

/*!
*******************************************************************************
  @brief        <b>class tR_AUDIO_GET_PSID</b>
*******************************************************************************
*/
class tR_AUDIO_GET_PSID : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE311,R_AUDIO_GET_PSID,"R_AUDIO_GET_PSID",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU32,r_audio_service,tU32,0,4);

}; /* ... class tR_AUDIO_GET_PSID */

/*!
*******************************************************************************
  @brief        <b>class tC_AUDIO_GET_SCIDI</b>
*******************************************************************************
*/
class tC_AUDIO_GET_SCIDI : public AaRSLib::MSG::tCommandMessage
{
private:
    /* static memory buffer ...
     */

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE312,C_AUDIO_GET_SCIDI,"C_AUDIO_GET_SCIDI",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */

public:
    /* custom constructor ...
     */
#if 0
    tC_AUDIO_GET_SCIDI( )
        : AaRSLib::MSG::tCommandMessage(OP_CODE, 0, NULL)
    {
    }
#endif

}; /* ... class tC_AUDIO_GET_SCIDI */

/*!
*******************************************************************************
  @brief        <b>class tR_AUDIO_GET_SCIDI</b>
*******************************************************************************
*/
class tR_AUDIO_GET_SCIDI : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE313,R_AUDIO_GET_SCIDI,"R_AUDIO_GET_SCIDI",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU16,w_scidi,tU16,0,2);

}; /* ... class tR_AUDIO_GET_SCIDI */

/*!
*******************************************************************************
  @brief        <b>class tC_GET_SIGNAL_QUALITY</b>
*******************************************************************************
*/
class tC_GET_SIGNAL_QUALITY : public AaRSLib::MSG::tCommandMessage
{
private:
  /* static memory buffer ...
   */
  tU8 _msgbuf[1];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE338,C_GET_SIGNAL_QUALITY,"C_GET_SIGNAL_QUALITY",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
      b_command__SIGNAL_QUALITY=0x00
    } t__b_command;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_command,b_command,tU8,0,1);

public:
    /* custom constructor ...
     */
    tC_GET_SIGNAL_QUALITY( t__b_command b_command )
        : AaRSLib::MSG::tCommandMessage(OP_CODE, sizeof(_msgbuf), _msgbuf)
    {
        tU32 o = 0;
        o = set_tU8(o,b_command);
    }

}; /* ... class tC_GET_SIGNAL_QUALITY */

/*!
*******************************************************************************
  @brief        <b>class tR_GET_SIGNAL_QUALITY</b>
*******************************************************************************
*/
class tR_GET_SIGNAL_QUALITY : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    tU8 _msgbuf[2];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE339,R_GET_SIGNAL_QUALITY,"R_GET_SIGNAL_QUALITY",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
      b_command__SIGNAL_QUALITY=0x00
    } t__b_command;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_command,b_command,tU8,0,1);

    typedef enum {
      b_signal_quality__SIGNAL_QUALITY__NO_SIGNAL=0x00,
      b_signal_quality__SIGNAL_QUALITY__SIGNAL_1=0x01,
      b_signal_quality__SIGNAL_QUALITY__SIGNAL_2=0x02,
      b_signal_quality__SIGNAL_QUALITY__SIGNAL_3=0x03,
      b_signal_quality__SIGNAL_QUALITY__SIGNAL_4=0x04,
      b_signal_quality__SIGNAL_QUALITY__SIGNAL_5=0x05,
      b_signal_quality__SIGNAL_QUALITY__SIGNAL_6=0x06
    } t__b_signal_quality;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_signal_quality,b_signal_quality,tU8,end__b_command(),1);

}; /* ... class tR_GET_SIGNAL_QUALITY */

/*!
*******************************************************************************
  @brief        <b>class tC_GET_DAB_DECODER_STATUS</b>
*******************************************************************************
*/
class tC_GET_DAB_DECODER_STATUS : public AaRSLib::MSG::tCommandMessage
{
private:
  /* static memory buffer ...
   */
  tU8 _msgbuf[1];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE31C,C_GET_DAB_DECODER_STATUS,"C_GET_DAB_DECODER_STATUS",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        b_tuner_id__FG=0,
        b_tuner_id__BG=1,
        b_tuner_id__ALL=0xff
    } t__b_tuner_id;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_tuner_id,b_tuner_id,tU8,0,1);

public:
    /* custom constructor ...
     */
    tC_GET_DAB_DECODER_STATUS( t__b_tuner_id b_tuner_id )
        : AaRSLib::MSG::tCommandMessage(OP_CODE, sizeof(_msgbuf), _msgbuf)
    {
        tU32 o = 0;
        o = set_tU8(o,b_tuner_id);
    }

}; /* ... class tC_GET_DAB_DECODER_STATUS */

/*!
*******************************************************************************
  @brief        <b>class tR_GET_DAB_DECODER_STATUS</b>
*******************************************************************************
*/
class tR_GET_DAB_DECODER_STATUS : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    tU8 _msgbuf[54];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE31D,R_GET_DAB_DECODER_STATUS,"R_GET_DAB_DECODER_STATUS",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        b_tuner_id__FG=0,
        b_tuner_id__BG=1
    } t__b_tuner_id;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_tuner_id,b_tuner_id,tU8,0,1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_flags,tU8,end__b_tuner_id(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU32,l_timestamp,tU32,end__b_flags(),4);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_opmode,tU32,end__l_timestamp(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_rfu1,tU8,end__b_opmode(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU16,w_jobid,tU16,end__b_rfu1(),2);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_tuner_resources,tU8,end__w_jobid(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_rfu2,tU8,end__b_tuner_resources(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU32,l_frequency,tU32,end__b_rfu2(),4);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_sync_state,tU8,end__l_frequency(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_transmission_mode,tU8,end__b_sync_state(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU16,w_eid,tU16,end__b_transmission_mode(),2);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU16,w_ens_cifcnt,tU16,end__w_eid(),2);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_reconf_flags,tU8,end__w_ens_cifcnt(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_reconf_cifcnt,tU8,end__b_reconf_flags(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU32,l_decoder_cifcnt,tU32,end__b_reconf_cifcnt(),4);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU32,l_fic_ber,tU32,end__l_decoder_cifcnt(),4);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_fic_ber_level,tU8,end__l_fic_ber(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_rfu3,tU8,end__b_fic_ber_level(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tS8,b_snr,tS8,end__b_rfu3(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tS8,b_snr1,tS8,end__b_snr(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tS8,b_snr2,tS8,end__b_snr1(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tS8,b_rssi,tS8,end__b_snr2(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tS8,b_rssi1,tS8,end__b_rssi(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tS8,b_rssi2,tS8,end__b_rssi1(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU16,b_bbssi,tU16,end__b_rssi2(),2);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU16,b_bbssi2,tU16,end__b_bbssi(),2);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU16,w_frequency_deviation,tU16,end__b_bbssi2(),2);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_mean_time_deviation,tU8,end__w_frequency_deviation(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_rfu4,tU8,end__b_mean_time_deviation(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_msc_audio_subchid,tU8,end__b_rfu4(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_msc_audio_protlevel,tU8,end__b_msc_audio_subchid(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU32,l_msc_audio_ber,tU32,end__b_msc_audio_protlevel(),4);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_msc_audio_rsdec_corr,tU8,end__l_msc_audio_ber(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_msc_audio_mute,tU8,end__b_msc_audio_rsdec_corr(),1);

}; /* ... class tR_GET_DAB_DECODER_STATUS */

/*!
*******************************************************************************
  @brief        <b>class tC_GET_DAB_AUDIO_QUALITY</b>
*******************************************************************************
*/
class tC_GET_DAB_AUDIO_QUALITY : public AaRSLib::MSG::tCommandMessage
{
private:
  /* static memory buffer ...
   */
  tU8 _msgbuf[1];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE318,C_GET_DAB_AUDIO_QUALITY,"C_GET_DAB_AUDIO_QUALITY",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
      b_command__ERROR_RATE = 0x00,
      b_command__ERROR_RATE_EQUALIZER = 0x01,
      b_command__EQUALIZER = 0x02,
      b_command__ERROR_RATE__CONTINUOUS_FLAG = 0x80,
      b_command__ERROR_RATE_EQUALIZER__CONTINUOUS_FLAG = 0x81,
      b_command__EQUALIZER__CONTINUOUS_FLAG = 0x82,
      b_command__UNDEF=0x00,
    } t__b_command;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_command,b_command,tU8,0,1);

public:
    /* custom constructor ...
     */
    tC_GET_DAB_AUDIO_QUALITY( t__b_command b_command )
        : AaRSLib::MSG::tCommandMessage(OP_CODE, sizeof(_msgbuf), _msgbuf)
    {
        tU32 o = 0;
        o = set_tU8(o,b_command);
    }

}; /* ... class tC_GET_DAB_AUDIO_QUALITY */

/*!
*******************************************************************************
  @brief        <b>class tR_GET_DAB_AUDIO_QUALITY</b>
*******************************************************************************
*/
class tR_GET_DAB_AUDIO_QUALITY : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[1];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE319,R_GET_DAB_AUDIO_QUALITY,"R_GET_DAB_AUDIO_QUALITY",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
      b_command__ERROR_RATE = 0x00,
      b_command__ERROR_RATE_EQUALIZER = 0x01,
      b_command__EQUALIZER = 0x02,
      b_command__ERROR_RATE__CONTINUOUS_FLAG = 0x80,
      b_command__ERROR_RATE_EQUALIZER__CONTINUOUS_FLAG = 0x81,
      b_command__EQUALIZER__CONTINUOUS_FLAG = 0x82,
      b_command__INVALID_QUALITY_TYPE=0xff,
      b_command__UNDEF=0x00,
    } t__b_command;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_command,b_command,tU8,0,1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_audio_quality,tU8,end__b_command(),1);

}; /* ... class tR_GET_DAB_AUDIO_QUALITY */

/*!
*******************************************************************************
  @brief        <b>class tC_AUDIO_PLAY_COMPONENT</b>
*******************************************************************************
*/
class tC_AUDIO_PLAY_COMPONENT : public AaRSLib::MSG::tCommandMessage
{
private:
    /* static memory buffer ...
     */
    tU8 _msgbuf[1];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE344,C_AUDIO_PLAY_COMPONENT,"C_AUDIO_PLAY_COMPONENT",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
      b_component_command__PLAY_FIRST_COMPONENT = 0x01,
      b_component_command__PLAY_NEXT = 0x02,
      b_component_command__PLAY_PREVIOUS = 0x03
    } t__b_component_command;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_component_command,b_component_command,tU8,0,1);

public:
    /* custom constructor ...
     */
    tC_AUDIO_PLAY_COMPONENT( t__b_component_command b_component_command )
        : AaRSLib::MSG::tCommandMessage(OP_CODE, sizeof(_msgbuf), _msgbuf)
    {
        tU32 o = 0;
        o = set_tU8(o,b_component_command);
    }

}; /* ... class tC_AUDIO_PLAY_COMPONENT */

/*!
*******************************************************************************
  @brief        <b>class tR_AUDIO_PLAY_COMPONENT</b>
*******************************************************************************
*/
class tR_AUDIO_PLAY_COMPONENT : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[1];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE345,R_AUDIO_PLAY_COMPONENT,"R_AUDIO_PLAY_COMPONENT",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
      b_component_state__NO_COMPONENT = 0x00,
      b_component_state__PRIMARY_COMPONENT_OK = 0x01,
      b_component_state__NO_PRIMARY = 0x02,
      b_component_state__SECONDARY_COMPONENT_OK = 0x03,
      b_component_state__NO_SECONDARY = 0x04
    } t__b_component_state;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_component_state,b_component_state,tU8,0,1);

}; /* ... class tR_AUDIO_PLAY_COMPONENT */

/*!
*******************************************************************************
  @brief        <b>class tC_SERV_FOLLOW_SET_MODE</b>
*******************************************************************************
*/
class tC_SERV_FOLLOW_SET_MODE : public AaRSLib::MSG::tCommandMessage
{
private:
    /* static memory buffer ...
     */
    tU8 _msgbuf[1];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE352,C_SERV_FOLLOW_SET_MODE,"C_SERV_FOLLOW_SET_MODE",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */
    static const tU8 b_serv_follow_mode__ALT_FREQUENCY      = (1<<0);
    static const tU8 b_serv_follow_mode__ALT_ENSEMBLE       = (1<<1);
    static const tU8 b_serv_follow_mode__ALT_HARD_LINKING   = (1<<2);
    static const tU8 b_serv_follow_mode__ALT_SEARCH         = (1<<3);
    static const tU8 b_serv_follow_mode__ALT_SOFT_LINKING   = (1<<4);
    static const tU8 b_serv_follow_mode__COMPONENTS         = (1<<5);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_serv_follow_mode,tU8,0,1);

public:
    /* custom constructor ...
     */
    tC_SERV_FOLLOW_SET_MODE( tU8 b_serv_follow_mode )
        : AaRSLib::MSG::tCommandMessage(OP_CODE, sizeof(_msgbuf), _msgbuf)
    {
        tU32 o = 0;
        o = set_tU8(o,b_serv_follow_mode);
    }

}; /* ... class tC_SERV_FOLLOW_SET_MODE */

/*!
*******************************************************************************
  @brief        <b>class tR_SERV_FOLLOW_SET_MODE</b>
*******************************************************************************
*/
class tR_SERV_FOLLOW_SET_MODE : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    tU8 _msgbuf[4];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE353,R_SERV_FOLLOW_SET_MODE,"R_SERV_FOLLOW_SET_MODE",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    static const tU8 b_serv_follow_mode__ALT_FREQUENCY      = (1<<0);
    static const tU8 b_serv_follow_mode__ALT_ENSEMBLE       = (1<<1);
    static const tU8 b_serv_follow_mode__ALT_HARD_LINKING   = (1<<2);
    static const tU8 b_serv_follow_mode__ALT_SEARCH         = (1<<3);
    static const tU8 b_serv_follow_mode__ALT_SOFT_LINKING   = (1<<4);
    static const tU8 b_serv_follow_mode__COMPONENTS         = (1<<5);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_serv_follow_mode,tU8,0,1);

}; /* ... class tR_SERV_FOLLOW_SET_MODE */

/*!
*******************************************************************************
  @brief        <b>class tC_SERV_FOLLOW_SET_ONESHOT_MODE</b>
*******************************************************************************
*/
class tC_SERV_FOLLOW_SET_ONESHOT_MODE : public AaRSLib::MSG::tCommandMessage
{
private:
    /* static memory buffer ...
     */
    tU8 _msgbuf[1];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE358,C_SERV_FOLLOW_SET_ONESHOT_MODE,"C_SERV_FOLLOW_SET_ONESHOT_MODE",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */
    static const tU8 b_serv_follow_mode__ALT_FREQUENCY      = (1<<0);
    static const tU8 b_serv_follow_mode__ALT_ENSEMBLE       = (1<<1);
    static const tU8 b_serv_follow_mode__ALT_HARD_LINKING   = (1<<2);
    static const tU8 b_serv_follow_mode__ALT_SEARCH         = (1<<3);
    static const tU8 b_serv_follow_mode__ALT_SOFT_LINKING   = (1<<4);
    static const tU8 b_serv_follow_mode__COMPONENTS         = (1<<5);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_serv_follow_mode,tU8,0,1);

    static const tU8 b_flags__FALLBACK_WITH_FIRST_AF        = (1<<0);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_flags,tU8,end__b_serv_follow_mode(),1);

    static const tU8 b_flags__ONESHOT_SF_START__SERVICE_CHANGE = (1<<0);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU16,w_start_tigger,tU16,end__b_flags(),2);

    static const tU8 b_flags__ONESHOT_SF_END__STATE_END = (1<<0);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU16,w_end_tigger,tU16,end__w_start_tigger(),2);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU16,w_rfu,tU16,end__w_end_tigger(),2);

public:
    /* custom constructor ...
     */
    tC_SERV_FOLLOW_SET_ONESHOT_MODE( tU8 b_oneshot_serv_follow_mode, tU8 b_flags, tU16 w_start_tigger, tU16 w_end_tigger, tU16 w_rfu )
        : AaRSLib::MSG::tCommandMessage(OP_CODE, sizeof(_msgbuf), _msgbuf)
    {
        tU32 o = 0;
        o = set_tU8(o,b_oneshot_serv_follow_mode);
        o = set_tU8(o,b_flags);
        o = set_tU16(o,w_start_tigger);
        o = set_tU16(o,w_end_tigger);
        o = set_tU16(o,w_rfu);
    }

}; /* ... class tC_SERV_FOLLOW_SET_ONESHOT_MODE */

/*!
*******************************************************************************
  @brief        <b>class tR_SERV_FOLLOW_SET_ONESHOT_MODE</b>
*******************************************************************************
*/
class tR_SERV_FOLLOW_SET_ONESHOT_MODE : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    tU8 _msgbuf[4];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE359,R_SERV_FOLLOW_SET_ONESHOT_MODE,"R_SERV_FOLLOW_SET_ONESHOT_MODE",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    static const tU8 b_serv_follow_mode__ALT_FREQUENCY      = (1<<0);
    static const tU8 b_serv_follow_mode__ALT_ENSEMBLE       = (1<<1);
    static const tU8 b_serv_follow_mode__ALT_HARD_LINKING   = (1<<2);
    static const tU8 b_serv_follow_mode__ALT_SEARCH         = (1<<3);
    static const tU8 b_serv_follow_mode__ALT_SOFT_LINKING   = (1<<4);
    static const tU8 b_serv_follow_mode__COMPONENTS         = (1<<5);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_serv_follow_mode,tU8,0,1);

    static const tU8 b_flags__FALLBACK_WITH_FIRST_AF        = (1<<0);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_flags,tU8,end__b_serv_follow_mode(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU16,w_start_tigger,tU16,end__b_flags(),2);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU16,w_end_tigger,tU16,end__w_start_tigger(),2);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU16,w_rfu,tU16,end__w_end_tigger(),2);

}; /* ... class tR_SERV_FOLLOW_SET_ONESHOT_MODE */

/*!
*******************************************************************************
  @brief        <b>class tR_SERV_FOLLOW_ACTIVE</b>
*******************************************************************************
*/
class tR_SERV_FOLLOW_ACTIVE : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    tU8 _msgbuf[4];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE355,R_SERV_FOLLOW_ACTIVE,"R_SERV_FOLLOW_ACTIVE",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    static const tU8 b_serv_follow_mode__ALT_FREQUENCY      = (1<<0);
    static const tU8 b_serv_follow_mode__ALT_ENSEMBLE       = (1<<1);
    static const tU8 b_serv_follow_mode__ALT_HARD_LINKING   = (1<<2);
    static const tU8 b_serv_follow_mode__ALT_SEARCH         = (1<<3);
    static const tU8 b_serv_follow_mode__ALT_SOFT_LINKING   = (1<<4);
    static const tU8 b_serv_follow_mode__COMPONENTS         = (1<<5);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_serv_follow_mode,tU8,0,1);

    typedef enum {
        b_serv_follow_state__STATE_START = 0x01,
        b_serv_follow_state__STATE_CHANGE = 0x02,
        b_serv_follow_state__STATE_END = 0x03
    } t__b_serv_follow_state;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_serv_follow_state,b_serv_follow_state,tU8,end__b_serv_follow_mode(),1);

}; /* ... class tR_SERV_FOLLOW_ACTIVE */

/*!
*******************************************************************************
  @brief        <b>class tC_QUALITY_CONFIG</b>
*******************************************************************************
*/
class tC_QUALITY_CONFIG : public AaRSLib::MSG::tCommandMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[1];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE33A,C_QUALITY_CONFIG,"C_QUALITY_CONFIG",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
      b_command__GET = 0x00,
      b_command__SET = 0x01,
    } t__b_command;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_command,b_command,tU8,0,1);

    static const tU8 b_quality_strategy__0x01 = 0x01;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_quality_strategy,tU8,end__b_command(),1);

    static const tU8 b_rfu__0x00 = 0x01;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_rfu,tU8,end__b_quality_strategy(),1);

    static const tU8 b_num_parameter_bytes__0x00 = 0x00;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_num_parameter_bytes,tU8,end__b_rfu(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tPU8,r_parameter_bytes,tPU8,end__b_num_parameter_bytes(),b_num_parameter_bytes());

public:
    /* custom constructor ...
     */
    tC_QUALITY_CONFIG( t__b_command b_command, tU8 b_quality_strategy, tU8 b_rfu, tU8 b_num_parameter_bytes, tPU8 r_parameter_bytes )
        : AaRSLib::MSG::tCommandMessage(OP_CODE, 0, AARSLIB_NULL)
    {
        tU32 o = 0;
        o = set_tU8(o,b_command);
        o = set_tU8(o,b_quality_strategy);
        o = set_tU8(o,b_rfu);
        o = set_tU8(o,b_num_parameter_bytes);
        o = set_tPU8(o,r_parameter_bytes,b_num_parameter_bytes);
    }

}; /* ... class tC_QUALITY_CONFIG */

/*!
*******************************************************************************
  @brief        <b>class tR_QUALITY_CONFIG</b>
*******************************************************************************
*/
class tR_QUALITY_CONFIG : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[4];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE33B,R_QUALITY_CONFIG,"R_QUALITY_CONFIG",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
      b_command__GET = 0x00,
      b_command__SET = 0x01,
    } t__b_command;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_command,b_command,tU8,0,1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_quality_strategy,tU8,end__b_command(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_rfu,tU8,end__b_quality_strategy(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_num_parameter_bytes,tU8,end__b_rfu(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tPU8,r_parameter_bytes,tPU8,end__b_num_parameter_bytes(),b_num_parameter_bytes());

}; /* ... class tR_QUALITY_CONFIG */

/*!
*******************************************************************************
  @brief        <b>class tC_LEARN</b>
*******************************************************************************
*/
class tC_LEARN : public AaRSLib::MSG::tCommandMessage
{
private:
    /* static memory buffer ...
     */
    tU8 _msgbuf[1];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE350,C_LEARN,"C_LEARN",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        b_learn_command__LEARN_NORMAL_START = 0x01,
        b_learn_command__LEARN_NORMAL_STOP = 0x02,
        b_learn_command__LEARN_UPDATE_START = 0x03,
        b_learn_command__LEARN_UPDATE_STOP = 0x04,
        b_learn_command__LEARN_FOREVER_START = 0x05,
        b_learn_command__LEARN_FOREVER_STOP = 0x06,
        b_learn_command__BGLEARN_NORMAL_START = 0x81,
        b_learn_command__BGLEARN_NORMAL_STOP = 0x82,
        b_learn_command__BGLEARN_UPDATE_START = 0x83,
        b_learn_command__BGLEARN_UPDATE_STOP = 0x84,
        b_learn_command__BGLEARN_FOREVER_START = 0x85,
        b_learn_command__BGLEARN_FOREVER_STOP = 0x86
    } t__b_learn_command;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_learn_command,b_learn_command,tU8,0,1);

public:
    /* custom constructor ...
     */
    tC_LEARN( t__b_learn_command b_learn_command )
        : AaRSLib::MSG::tCommandMessage(OP_CODE, sizeof(_msgbuf), _msgbuf)
    {
        tU32 o = 0;
        o = set_tU8(o,b_learn_command);
    }

}; /* ... class tC_LEARN */

/*!
*******************************************************************************
  @brief        <b>class tR_LEARN</b>
*******************************************************************************
*/
class tR_LEARN : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[4];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE351,R_LEARN,"R_LEARN",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        b_learn_state__LEARN_NORMAL_STARTED = 0x01,
        b_learn_state__LEARN_NORMAL_STOPED = 0x02,
        b_learn_state__LEARN_UPDATE_STARTED = 0x03,
        b_learn_state__LEARN_UPDATE_STOPED = 0x04,
        b_learn_state__LEARN_FOREVER_STARTED = 0x05,
        b_learn_state__LEARN_FOREVER_STOPED = 0x06,
        b_learn_state__BGLEARN_NORMAL_STARTED = 0x81,
        b_learn_state__BGLEARN_NORMAL_STOPED = 0x82,
        b_learn_state__BGLEARN_UPDATE_STARTED = 0x83,
        b_learn_state__BGLEARN_UPDATE_STOPED = 0x84,
        b_learn_state__BGLEARN_FOREVER_STARTED = 0x85,
        b_learn_state__BGLEARN_FOREVER_STOPED = 0x86
#define b_learn_state__BGLEARN_FOREVER_STOPEDED b_learn_state__BGLEARN_FOREVER_STOPED
    } t__b_learn_state;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_learn_state,b_learn_state,tU8,0,1);

}; /* ... class tR_LEARN */

/*!
*******************************************************************************
  @brief        <b>class tC_SCAN</b>
*******************************************************************************
*/
class tC_SCAN : public AaRSLib::MSG::tCommandMessage
{
private:
    /* static memory buffer ...
     */
    tU8 _msgbuf[8+256];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE356,C_SCAN,"C_SCAN",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        b_scan_command__SCAN_COMMAND_START = 0x01,
        b_scan_command__SCAN_COMMAND_STOP = 0x02,
        b_scan_command__SCAN_COMMAND_ABORT = 0x03,
        b_scan_command__SCAN_COMMAND_PAUSE = 0x04,
        b_scan_command__SCAN_COMMAND_RESUME = 0x05,
        b_scan_command__SCAN_COMMAND_NEXT = 0x06,
    } t__b_scan_command;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_scan_command,b_scan_command,tU8,0,1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_tag,tU8,end__b_scan_command(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU32,l_start_frequency,tU8,end__b_tag(),4);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_rfu,tU8,end__l_start_frequency(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_config_bytes,tU8,end__b_rfu(),1);

    static const tU16 w_scan_config__STRATEGY__SEARCH_UP = 0x1001;
    static const tU16 w_scan_config__OPTION__SUPPRESS_DOUBLE_SERVICES = 0x1101;
    static const tU16 w_scan_config__OPTION__SCAN_FOREVER = 0x1102;
    static const tU16 w_scan_config__OPTION__SELECT_LAST_SCANNED_SERVICE_WHEN_LSM_NRX = 0x1103;
    static const tU16 w_scan_config__OPTION__SCAN_SECONDARY_SERVICE_COMPONENTS = 0x1104;
    static const tU16 w_scan_config__OPTION__MIN_SIGNAL_QUALITY_LEVEL = 0x1201;
    static const tU16 w_scan_config__OPTION__MIN_AUDIO_QUALITY_LEVEL = 0x1301;
    static const tU16 w_scan_config__OPTION__SERVICE_PLAY_TIME = 0x1401;
    static const tU16 w_scan_config__OPTION__MAX_MUTE_GAP_TIME = 0x1501;

    //MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8*,r_config,tPChar,end__b_config_bytes(),b_config_bytes());
private:
    tU32  start__r_config() { return end__b_config_bytes(); }
    tU32  size__r_config() { return b_config_bytes(); }
    tU32  end__r_config() { return start__r_config() + size__r_config(); }
public:
    tVoid  set__r_config( tPU8 value, tU8 bytes )
    {
        if(( value == AARSLIB_NULL )||( bytes == 0 ))
        {
            set__b_config_bytes(0);
        }
        else
        {
            set__b_config_bytes(bytes);
        }
        set_tPU8(end__b_config_bytes(),value,b_config_bytes());
    }
    tU8* r_config( void )
    {
        return (tU8*)get_tPU8(end__b_config_bytes());
    }

public:
    /* custom constructor ...
     */
    tC_SCAN( t__b_scan_command b_scan_command, tU8 b_tag, tU32 l_start_frequency, tU8 b_rfu, tU8 b_config_bytes, tPU8 r_config )
        : AaRSLib::MSG::tCommandMessage(OP_CODE, ((size_t)(8+b_config_bytes)>sizeof(_msgbuf))?sizeof(_msgbuf):(tU32)(8+b_config_bytes), _msgbuf)
    {
        tU32 o = 0;
        o = set_tU8(o,b_scan_command);
        o = set_tU8(o,b_tag);
        o = set_tU32(o,l_start_frequency);
        o = set_tU8(o,b_rfu);
        o = set_tU8(o,b_config_bytes);
        o = set_tPU8(o,r_config,b_config_bytes);
        //set_MsgLength(o);
    }

}; /* ... class tC_SCAN */

/*!
*******************************************************************************
  @brief        <b>class tR_SCAN</b>
*******************************************************************************
*/
class tR_SCAN : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[4];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE357,R_SCAN,"R_SCAN",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        b_scan_state__SCAN_STATE_UNDEF = 0x00,
        b_scan_state__SCAN_STATE_STARTED = 0x01,
        b_scan_state__SCAN_STATE_DONE = 0x02,
        b_scan_state__SCAN_STATE_ABORT = 0x03,
        b_scan_state__SCAN_STATE_PAUSE = 0x04,
        b_scan_state__SCAN_STATE_RESUME = 0x05,
        b_scan_state__SCAN_STATE_SEARCHING_ENSEMBLE = 0x10,
        b_scan_state__SCAN_STATE_SCANNING_ENSEMBLE = 0x11,
        b_scan_state__SCAN_STATE_SKIPPING_ENSEMBLE = 0x12,
        b_scan_state__SCAN_STATE_PLAYING_SERVICE = 0x13,
        b_scan_state__SCAN_STATE_PLAYING_REJECTED = 0xff,
    } t__b_scan_state;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_scan_state,b_scan_state,tU8,0,1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_tag,tU8,end__b_scan_state(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_rfu,tU8,end__b_tag(),1);

}; /* ... class tR_SCAN */

/*!
*******************************************************************************
  @brief        <b>class tC_SET_MODE</b>
*******************************************************************************
*/
class tC_SET_MODE : public AaRSLib::MSG::tCommandMessage
{
private:
    /* static memory buffer ...
     */
    tU8 _msgbuf[1];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE320,C_SET_MODE,"C_SET_MODE",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        b_mode__GET = 0x00,
        b_mode__DAB_FG_AUDIO = 0x01,
        b_mode__DAB_BG_AUDIO = 0x03,
        b_mode__INACTIVE = 0x04,
        b_mode__DAB_BG_ANNO_SURVEILANCE = 0x05,
        b_mode__DAB_FG_ANNO_SURVEILANCE = 0x06,
    } t__b_mode;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_mode,b_mode,tU8,0,1);

public:
    /* custom constructor ...
     */
    tC_SET_MODE( tU8       b_mode )
        : AaRSLib::MSG::tCommandMessage(OP_CODE, sizeof(_msgbuf), _msgbuf)
    {
        tU32 o = 0;
        o = set_tU8(o,b_mode);
    }

}; /* ... class tC_SET_MODE */

/*!
*******************************************************************************
  @brief        <b>class tR_SET_MODE</b>
*******************************************************************************
*/
class tR_SET_MODE : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[2];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE321,R_SET_MODE,"R_SET_MODE",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        b_mode__GET = 0x00,
        b_mode__DAB_FG_AUDIO = 0x01,
        b_mode__DAB_BG_AUDIO = 0x03,
        b_mode__INACTIVE = 0x04,
        b_mode__DAB_BG_ANNO_SURVEILANCE = 0x05,
        b_mode__DAB_FG_ANNO_SURVEILANCE = 0x06,
    } t__b_mode;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_mode,b_mode,tU8,0,1);

public:
    /* custom constructor ...
     */

}; /* ... class tR_SET_MODE */

/*!
*******************************************************************************
  @brief        <b>class tC_SEQUENCE</b>
*******************************************************************************
*/
class tC_SEQUENCE : public AaRSLib::MSG::tCommandMessage
{
private:
    /* static memory buffer ...
     */
    tU8 _msgbuf[2];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE326,C_SEQUENCE,"C_SEQUENCE",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU16,w_sequence,tU16,0,2);

public:
    /* custom constructor ...
     */
    tC_SEQUENCE( tU16 w_sequence )
        : AaRSLib::MSG::tCommandMessage(OP_CODE, sizeof(_msgbuf), _msgbuf)
    {
        tU32 o = 0;
        o = set_tU16(o,w_sequence);
    }

}; /* ... class tC_SEQUENCE */

/*!
*******************************************************************************
  @brief        <b>class tR_SEQUENCE</b>
*******************************************************************************
*/
class tR_SEQUENCE : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE327,R_SEQUENCE,"R_SEQUENCE",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU16,w_sequence,tU16,0,2);

public:
    /* custom constructor ...
     */

}; /* ... class tR_SEQUENCE */

/*!
*******************************************************************************
  @brief        <b>class tC_GET_FREQUENCY</b>
*******************************************************************************
*/
class tC_GET_FREQUENCY : public AaRSLib::MSG::tCommandMessage
{
public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE308,C_GET_FREQUENCY,"C_GET_FREQUENCY",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */

public:
    /* custom constructor ...
     */

}; /* ... class tC_GET_FREQUENCY */

/*!
*******************************************************************************
  @brief        <b>class tR_GET_FREQUENCY</b>
*******************************************************************************
*/
class tR_GET_FREQUENCY : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[4];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE309,R_GET_FREQUENCY,"R_GET_FREQUENCY",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    typedef tU32 t__l_frequency;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__l_frequency,l_frequency,tU32,0,4);

}; /* ... class tR_GET_FREQUENCY */

/*!
*******************************************************************************
  @brief        <b>class tC_GET_FREQUENCY_LABEL</b>
*******************************************************************************
*/
class tC_GET_FREQUENCY_LABEL : public AaRSLib::MSG::tCommandMessage
{
public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE30A,C_GET_FREQUENCY_LABEL,"C_GET_FREQUENCY_LABEL",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */

public:
    /* custom constructor ...
     */

}; /* ... class tC_GET_FREQUENCY_LABEL */

/*!
*******************************************************************************
  @brief        <b>class tR_GET_FREQUENCY_LABEL</b>
*******************************************************************************
*/
class tR_GET_FREQUENCY_LABEL : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[4];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE30B,R_GET_FREQUENCY_LABEL,"R_GET_FREQUENCY_LABEL",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tPChar,r_frequency_label,tPChar,0,size());

}; /* ... class tR_GET_FREQUENCY_LABEL*/

/*!
*******************************************************************************
  @brief        <b>class tC_STATION_PLAY</b>
*******************************************************************************
*/
class tC_STATION_PLAY : public AaRSLib::MSG::tCommandMessage
{
private:
    /* static memory buffer ...
     */
    tU8 _msgbuf[1];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE370,C_STATION_PLAY,"C_STATION_PLAY",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */
    static const tU8 b_station_number__LSN_0x00 = 0;
    static const tU8 b_station_number__1 = 1;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_station_number,tU8,0,1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_option,tU8,end__b_station_number(),1);

public:
    /* custom constructor ...
     */
    tC_STATION_PLAY( tU8 b_station_number )
        : AaRSLib::MSG::tCommandMessage(OP_CODE, sizeof(_msgbuf), _msgbuf)
    {
        tU32 o = 0;
        o = set_tU8(o,b_station_number);
    }

    /* custom constructor ...
     */
    tC_STATION_PLAY( tU8 b_station_number, tU8 b_option )
        : AaRSLib::MSG::tCommandMessage(OP_CODE, sizeof(_msgbuf), _msgbuf)
    {
        tU32 o = 0;
        o = set_tU8(o,b_station_number);
        o = set_tU8(o,b_option);
    }

}; /* ... class tC_STATION_PLAY */

/*!
*******************************************************************************
  @brief        <b>class tR_STATION_PLAY</b>
*******************************************************************************
*/
class tR_STATION_PLAY : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[4];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE371,R_STATION_PLAY,"R_STATION_PLAY",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        b_station_state__STATION_NUMBER_INVALID = 0x00,
        b_station_state__STATION_FREE = 0x02,
        b_station_state__STATION_PLAY_OK = 0x03,
        b_station_state__STATION_PLAY_ERROR = 0x04,
        b_station_state__WAITING_FOR_STATION_PLAY = 0x06
    } t__b_station_state;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_station_state,b_station_state,tU8,0,1);

    static const tU8 b_station_number__LSN_0x00 = 0;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_station_number,tU8,end__b_station_state(),4);

}; /* ... class tR_STATION_PLAY */

/*!
*******************************************************************************
  @brief        <b>class tC_STATION_STORE</b>
*******************************************************************************
*/
class tC_STATION_STORE : public AaRSLib::MSG::tCommandMessage
{
private:
    /* static memory buffer ...
     */
    tU8 _msgbuf[1];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE372,C_STATION_STORE,"C_STATION_STORE",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */
    static const tU8 b_station_number__LSN_0x00 = 0;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_station_number,tU8,0,1);

public:
    /* custom constructor ...
     */
    tC_STATION_STORE( tU8 b_station_number )
        : AaRSLib::MSG::tCommandMessage(OP_CODE, sizeof(_msgbuf), _msgbuf)
    {
        tU32 o = 0;
        o = set_tU8(o,b_station_number);
    }

}; /* ... class tC_STATION_STORE */

/*!
*******************************************************************************
  @brief        <b>class tR_STATION_STORE</b>
*******************************************************************************
*/
class tR_STATION_STORE : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    tU8 _msgbuf[4];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE373,R_STATION_STORE,"R_STATION_STORE",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        b_station_state__STATION_NUMBER_INVALID = 0x00,
        b_station_state__STATION_INVALID = 0x01,
        b_station_state__STATION_STORE_OK = 0x05
    } t__b_station_state;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_station_state,b_station_state,tU8,0,1);

    static const tU8 b_station_number__LSN_0x00 = 0;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_station_number,tU8,end__b_station_state(),4);

}; /* ... class tR_STATION_STORE */

/*!
*******************************************************************************
  @brief        <b>class tC_STATION_SET_USER</b>
*******************************************************************************
*/
class tC_STATION_SET_USER : public AaRSLib::MSG::tCommandMessage
{
private:
    /* static memory buffer ...
     */
    tU8 _msgbuf[4];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE380,C_STATION_SET_USER,"C_STATION_SET_USER",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_user_id,tU8,0,1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_rfu1,tU8,end__b_user_id(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_number_of_user_presets,tU8,end__b_rfu1(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_rfu2,tU8,end__b_number_of_user_presets(),1);

public:
    /* custom constructor ...
     */
    tC_STATION_SET_USER( tU8 b_user_id, tU8 b_rfu1, tU8 b_number_of_user_presets, tU8 b_rfu2 )
        : AaRSLib::MSG::tCommandMessage(OP_CODE, sizeof(_msgbuf), _msgbuf)
    {
        tU32 o = 0;
        o = set_tU8(o,b_user_id);
        o = set_tU8(o,b_rfu1);
        o = set_tU8(o,b_number_of_user_presets);
        o = set_tU8(o,b_rfu2);
    }

}; /* ... class tC_STATION_SET_USER */

/*!
*******************************************************************************
  @brief        <b>class tR_STATION_SET_USER</b>
*******************************************************************************
*/
class tR_STATION_SET_USER : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[4];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE381,R_STATION_SET_USER,"R_STATION_SET_USER",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_user_id,tU8,0,1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_rfu1,tU8,end__b_user_id(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_number_of_user_presets,tU8,end__b_rfu1(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_rfu2,tU8,end__b_number_of_user_presets(),1);
}; /* ... class tR_STATION_SET_USER */

/*!
*******************************************************************************
  @brief        <b>class tC_STATION_AUTO_COMPARE</b>
*******************************************************************************
*/
class tC_STATION_AUTO_COMPARE : public AaRSLib::MSG::tCommandMessage
{
private:
    /* static memory buffer ...
     */
    tU8 _msgbuf[10];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE382,C_STATION_AUTO_COMPARE,"C_STATION_AUTO_COMPARE",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        b_command__UNDEF = 0x00,
        b_command__DISABLE = 0x01,
        b_command__ENABLE = 0x02,
        b_command__CLEAR_PRESET_HISTORY = 0x10
    } t__b_command;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_command,b_command,tU8,0,1);

    typedef enum {
        b_stragety__UNDEF = 0x00,
        b_stragety__0x01_SIMPLY_ONE_HISTORY_PRESET = 0x01
    } t__b_stragety;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_stragety,b_stragety,tU8,end__b_command(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_layer,tU8,end__b_stragety(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_layer_first_preset,tU8,end__b_layer(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_layer_last_preset,tU8,end__b_layer_first_preset(),1);

    static const tU8 b_preset_history_set_flags__RDM_STATION_PLAY                   = (1<<0);
    static const tU8 b_preset_history_set_flags__RDM_STATION_STORE                  = (1<<1);
    static const tU8 b_preset_history_set_flags__RDM_STATION_SET_PRESET_STATION     = (1<<2);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_preset_history_set_flags,tU8,end__b_layer_last_preset(),1);

    static const tU32 l_preset_history_clear_flags__RDM_STATION_SET_USER             = (1<<0);
    static const tU32 l_preset_history_clear_flags__RDM_STATION_PLAY                 = (1<<1);
    static const tU32 l_preset_history_clear_flags__RDM_STATION_STORE                = (1<<2);
    static const tU32 l_preset_history_clear_flags__RDM_STATION_SET_PRESET_STATION   = (1<<3);
    static const tU32 l_preset_history_clear_flags__RDM_STATION_AUTO_COMPARE         = (1<<4);
    static const tU32 l_preset_history_clear_flags__RDM_SET_MODE                     = (1<<5);
    static const tU32 l_preset_history_clear_flags__RDM_SCAN                         = (1<<6);
    static const tU32 l_preset_history_clear_flags__RDM_LEARN                        = (1<<7);
    static const tU32 l_preset_history_clear_flags__RDM_AUDIO_PLAY_PSID              = (1<<8);
    static const tU32 l_preset_history_clear_flags__RDM_AUDIO_PLAY_SERVICE           = (1<<9);
    static const tU32 l_preset_history_clear_flags__RDM_AUDIO_PLAY_COMPONENT         = (1<<10);
    static const tU32 l_preset_history_clear_flags__RDM_AUDIO_COMPONENT_PLAY         = (1<<11);
    static const tU32 l_preset_history_clear_flags__RDM_TUNE                         = (1<<12);
    static const tU32 l_preset_history_clear_flags__RDM_TUNE_FREQUENCY               = (1<<13);
    static const tU32 l_preset_history_clear_flags__RDM_TUNE_EID                     = (1<<14);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU32,l_preset_history_clear_flags,tU32,end__b_preset_history_set_flags(),4);

public:
    /* custom constructor ...
     */
    tC_STATION_AUTO_COMPARE( tU8 b_command, tU8 b_stragety, tU8 b_layer, tU8 b_layer_first_preset, tU8 b_layer_last_preset, tU8 b_preset_history_set_flags, tU32 l_preset_history_clear_flags )
        : AaRSLib::MSG::tCommandMessage(OP_CODE, sizeof(_msgbuf), _msgbuf)
    {
        tU32 o = 0;
        o = set_tU8(o,b_command);
        o = set_tU8(o,b_stragety);
        o = set_tU8(o,b_layer);
        o = set_tU8(o,b_layer_first_preset);
        o = set_tU8(o,b_layer_last_preset);
        o = set_tU8(o,b_preset_history_set_flags);
        o = set_tU32(o,l_preset_history_clear_flags);
    }

}; /* ... class tC_STATION_AUTO_COMPARE */

/*!
*******************************************************************************
  @brief        <b>class tR_STATION_AUTO_COMPARE</b>
*******************************************************************************
*/
class tR_STATION_AUTO_COMPARE : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[4];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE383,R_STATION_AUTO_COMPARE,"R_STATION_AUTO_COMPARE",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        b_response__UNDEF = 0x00,
        b_response__DISABLED = 0x01,
        b_response__ENABLED = 0x02,
        b_response__CHANGED = 0x20
    } t__b_response;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_response,b_response,tU8,0,1);

    typedef enum {
        b_stragety__UNDEF = 0x00,
        b_stragety__0x01_SIMPLY_ONE_HISTORY_PRESET = 0x01
    } t__b_stragety;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_stragety,b_stragety,tU8,end__b_response(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_layer,tU8,end__b_stragety(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_layer_first_preset,tU8,end__b_layer(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_layer_last_preset,tU8,end__b_layer_first_preset(),1);

    static const tU8 b_preset_history_set_flags__RDM_STATION_SET_USER               = (1<<0);
    static const tU8 b_preset_history_set_flags__RDM_STATION_PLAY                   = (1<<1);
    static const tU8 b_preset_history_set_flags__RDM_STATION_STORE                  = (1<<2);
    static const tU8 b_preset_history_set_flags__RDM_STATION_SET_PRESET_STATION     = (1<<3);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_preset_history_set_flags,tU8,end__b_layer_last_preset(),1);

    static const tU32 l_preset_history_clear_flags__RDM_STATION_SET_USER             = (1<<0);
    static const tU32 l_preset_history_clear_flags__RDM_STATION_PLAY                 = (1<<1);
    static const tU32 l_preset_history_clear_flags__RDM_STATION_STORE                = (1<<2);
    static const tU32 l_preset_history_clear_flags__RDM_STATION_SET_PRESET_STATION   = (1<<3);
    static const tU32 l_preset_history_clear_flags__RDM_SET_MODE                     = (1<<4);
    static const tU32 l_preset_history_clear_flags__RDM_SCAN                         = (1<<5);
    static const tU32 l_preset_history_clear_flags__RDM_LEARN                        = (1<<6);
    static const tU32 l_preset_history_clear_flags__RDM_AUDIO_PLAY_PSID              = (1<<7);
    static const tU32 l_preset_history_clear_flags__RDM_AUDIO_PLAY_SERVICE           = (1<<8);
    static const tU32 l_preset_history_clear_flags__RDM_AUDIO_PLAY_COMPONENT         = (1<<9);
    static const tU32 l_preset_history_clear_flags__RDM_AUDIO_COMPONENT_PLAY         = (1<<10);
    static const tU32 l_preset_history_clear_flags__RDM_TUNE                         = (1<<11);
    static const tU32 l_preset_history_clear_flags__RDM_TUNE_FREQUENCY               = (1<<12);
    static const tU32 l_preset_history_clear_flags__RDM_TUNE_EID                     = (1<<13);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU32,l_preset_history_clear_flags,tU32,end__b_preset_history_set_flags(),4);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tPU8,r_preset_auto_compare_flags,tPU8,end__l_preset_history_clear_flags(),(256/8));

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_preset_auto_compare_history,tU8,end__r_preset_auto_compare_flags(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_rfu,tU8,end__b_preset_auto_compare_history(),1);
}; /* ... class tR_STATION_AUTO_COMPARE */

/*!
*******************************************************************************
  @brief        <b>class tC_STATION_GET_PRESET_STATION</b>
*******************************************************************************
*/
class tC_STATION_GET_PRESET_STATION : public AaRSLib::MSG::tCommandMessage
{
private:
    /* static memory buffer ...
     */
    tU8 _msgbuf[1];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE378,C_STATION_GET_PRESET_STATION,"C_STATION_GET_PRESET_STATION",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */
    static const tU8 b_station_number__LSN_0x00 = 0;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_station_number,tU8,0,1);

public:
    /* custom constructor ...
     */
    tC_STATION_GET_PRESET_STATION( tU8 b_station_number )
        : AaRSLib::MSG::tCommandMessage(OP_CODE, sizeof(_msgbuf), _msgbuf)
    {
        tU32 o = 0;
        o = set_tU8(o,b_station_number);
    }

}; /* ... class tC_STATION_GET_PRESET_STATION */

/*!
*******************************************************************************
  @brief        <b>class tR_STATION_GET_PRESET_STATION</b>
*******************************************************************************
*/
class tR_STATION_GET_PRESET_STATION : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[4];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE379,R_STATION_GET_PRESET_STATION,"R_STATION_GET_PRESET_STATION",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    static const tU8 b_station_number__LSN_0x00 = 0;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_station_number,tU8,0,1);

    typedef enum {
        b_service_type__AUDIO_SERVICE = 0x01,
        b_service_type__DAB_DATA_SERVICE = 0x02
    } t__b_service_type;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_service_type,b_service_type,tU8,end__b_station_number(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU32,r_programme_service,tU8,end__b_service_type(),4);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU32,l_data_service_id,tU8,end__b_service_type(),4);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU32,l_frequency,tU8,end__r_programme_service(),4);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tPU8,r_label,tPU8,end__l_frequency(),20);

}; /* ... class tR_STATION_GET_PRESET_STATION */

/*!
*******************************************************************************
  @brief        <b>class tC_GET_RDM_STATUS</b>
*******************************************************************************
*/
class tC_GET_RDM_STATUS : public AaRSLib::MSG::tCommandMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[1];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE304,C_GET_RDM_STATUS,"C_GET_RDM_STATUS",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */

public:
    /* custom constructor ...
     */

}; /* ... class tC_GET_RDM_STATUS */

/*!
*******************************************************************************
  @brief        <b>class tR_GET_RDM_STATUS</b>
*******************************************************************************
*/
class tR_GET_RDM_STATUS : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[4];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE305,R_GET_RDM_STATUS,"R_GET_RDM_STATUS",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
      b_rdm_mode__DAB_MODE = 0x01,
      b_rdm_mode__UNDEF = 0x00
    } t__b_rdm_mode;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_rdm_mode,b_rdm_mode,tU8,0,1);

    static const tU8 b_rdm_status_dab__SYNC = (1<<0);
    static const tU8 b_rdm_status_dab_ENS_VALID = (1<<1);
    static const tU8 b_rdm_status_dab_AUDIO_SERVICE_VALID = (1<<2);
    static const tU8 b_rdm_status_dab_AUDIO_SERVICE_COMPONENT__VALID = (1<<3);
    static const tU8 b_rdm_status_dab_MUTE_ON = (1<<4);
    static const tU8 b_rdm_status_dab_TUNING = (1<<5);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_rdm_status_dab,tU8,end__b_rdm_mode(),1);

    static const tU8 b_rdm_events_SYNC_STATE_CHANGED = (1<<0);
    static const tU8 b_rdm_events_ENSEMBLE_CHANGED = (1<<1);
    static const tU8 b_rdm_events_AUDIO_SERVICE_CHANGED = (1<<2);
    static const tU8 b_rdm_events_AUDIO_SERVICE_COMPONENT__CHANGED = (1<<3);
    static const tU8 b_rdm_events_MUTE_STATE_CHANGED = (1<<4);
    static const tU8 b_rdm_events_TUNING_STATE_CHANGED = (1<<5);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_rdm_events_dab,tU8,end__b_rdm_status_dab(),1);

}; /* ... class tR_GET_RDM_STATUS */

/*!
*******************************************************************************
  @brief        <b>class tC_GET_RDM_INFO</b>
*******************************************************************************
*/
class tC_GET_RDM_INFO : public AaRSLib::MSG::tCommandMessage
{
private:
    /* static memory buffer ...
     */
    tU8 _msgbuf[1];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE34a,C_GET_RDM_INFO,"C_GET_RDM_INFO",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        b_info_type__INFO_DAB1 = 0x01,
        b_info_type__INFO_DAB2 = 0x02
    } t__b_info_type;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_info_type,b_info_type,tU8,0,1);

public:
    /* custom constructor ...
     */
    tC_GET_RDM_INFO( t__b_info_type b_info_type )
        : AaRSLib::MSG::tCommandMessage(OP_CODE, sizeof(_msgbuf), _msgbuf)
    {
        tU32 o = 0;
        o = set_tU8(o,b_info_type);
    }
}; /* ... class tC_GET_RDM_INFO */

/*!
*******************************************************************************
  @brief        <b>class tR_GET_RDM_INFO</b>
*******************************************************************************
*/
class tR_GET_RDM_INFO : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[26];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE34b,R_GET_RDM_INFO,"R_GET_RDM_INFO",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        b_info_type__INFO_DAB1 = 0x01,
        b_info_type__INFO_DAB2 = 0x02
    } t__b_info_type;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_info_type,b_info_type,tU8,0,1);

    typedef tU32 t__r_ensemble;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__r_ensemble,r_ensemble,tU32,end__b_info_type(),4);

    typedef tU32 t__r_programme_service;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__r_programme_service,r_programme_service,tU32,end__r_ensemble(),4);

    typedef tU32 t__w_internal_component_identifier;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_internal_component_identifier,w_internal_component_identifier,tU16,end__r_programme_service(),2);

    typedef tU32 t__b_scids;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_scids,b_scids,tU8,end__w_internal_component_identifier(),1);

    static const tU8 b_rdm_status_dab__SYNC = (1<<0);
    static const tU8 b_rdm_status_dab_ENS_VALID = (1<<1);
    static const tU8 b_rdm_status_dab_AUDIO_SERVICE_VALID = (1<<2);
    static const tU8 b_rdm_status_dab_AUDIO_SERVICE_COMPONENT__VALID = (1<<3);
    static const tU8 b_rdm_status_dab_MUTE_ON = (1<<4);
    static const tU8 b_rdm_status_dab_TUNING = (1<<5);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_rdm_status_dab,tU8,(b_info_type()==b_info_type__INFO_DAB2)?end__b_scids():end__w_internal_component_identifier(),1);

    static const tU8 b_rdm_events_SYNC_STATE_CHANGED = (1<<0);
    static const tU8 b_rdm_events_ENSEMBLE_CHANGED = (1<<1);
    static const tU8 b_rdm_events_AUDIO_SERVICE_CHANGED = (1<<2);
    static const tU8 b_rdm_events_AUDIO_SERVICE_COMPONENT__CHANGED = (1<<3);
    static const tU8 b_rdm_events_MUTE_STATE_CHANGED = (1<<4);
    static const tU8 b_rdm_events_TUNING_STATE_CHANGED = (1<<5);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_rdm_events_dab,tU8,end__b_rdm_status_dab(),1);

    static const tU8 b_rdm_mode_UNDEF = 0x00;
    static const tU8 b_rdm_mode_DAB_FG_AUDIO = 0x01;
    static const tU8 b_rdm_mode_DAB_BG_AUDIO = 0x03;
    static const tU8 b_rdm_mode_INACTIVE = 0x04;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_rdm_mode,tU8,end__b_rdm_events_dab(),1);

    typedef tU32 t__l_frequency;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__l_frequency,l_frequency,tU32,(b_info_type()==b_info_type__INFO_DAB2)?end__b_rdm_mode():end__b_rdm_status_dab(),4);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tPChar,t_band_label_string,tPChar,end__l_frequency(),4);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_audio_quality,tU8,end__t_band_label_string(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_signal_quality,tU8,end__b_audio_quality(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_rfu,tU8,end__b_signal_quality(),1);

}; /* ... class tR_GET_RDM_INFO */

/*!
*******************************************************************************
  @brief        <b>class tC_TUNE</b>
*******************************************************************************
*/
class tC_TUNE : public AaRSLib::MSG::tCommandMessage
{
private:
    /* static memory buffer ...
     */
    tU8 _msgbuf[1+1+4];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE330,C_TUNE,"C_TUNE",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        b_tune_command__STOP = 0x01,
        b_tune_command__TUNE_ONE_STEP = 0x02,
        b_tune_command__SEARCH = 0x03,
        b_tune_command__SEARCH_ENDLESS = 0x04,
        b_tune_command__ENS = 0x05,
        b_tune_command__UNDEF=0
    } t__b_tune_command;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_tune_command,b_tune_command,tU8,0,1);

    typedef enum {
        b_direction__DIR_UP = 0x01,
        b_direction__DIR_DOWN = 0x02,
        b_direction__UNDEF = 0x00
    } t__b_direction;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_direction,b_direction,tU8,end__b_tune_command(),1);

    typedef tU32 t__l_start_frequency;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__l_start_frequency,l_start_frequency,tU32,end__b_direction(),4);

public:
    /* custom constructor ...
     */
    tC_TUNE( t__b_tune_command b_tune_command, t__b_direction b_direction, t__l_start_frequency l_start_frequency )
        : AaRSLib::MSG::tCommandMessage(OP_CODE, sizeof(_msgbuf), _msgbuf)
    {
        tU32 o = 0;
        o = set_tU8(o,b_tune_command);
        o = set_tU8(o,b_direction);
        o = set_tU32(o,l_start_frequency);
    }

}; /* ... class tC_TUNE */

/*!
*******************************************************************************
  @brief        <b>class tR_TUNE</b>
*******************************************************************************
*/
class tR_TUNE : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    tU8 _msgbuf[1+1];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE331,R_TUNE,"R_TUNE",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        STOP = 0x01,
        TUNING = 0x02,
        SEARCHING = 0x03,
        SEARCHING_ENS = 0x04,
        NO_ENS_AVAILABLE = 0x10,
        SEARCHING_DONE = 0x12,
        TUNING_DONE = 0x12
    } t__b_tune_state;
    MACRO_AARSLIB_SIMPLE_RESPONSE_SETGET(t__b_tune_state,b_tune_state,tU8,0,1);

    typedef enum {
        DIR_UP = 0x01,
        DIR_DOWN = 0x02
    } t__b_direction;
    MACRO_AARSLIB_SIMPLE_RESPONSE_SETGET(t__b_direction,b_direction,tU8,end__b_tune_state(),1);

}; /* ... class tR_TUNE */

/*!
*******************************************************************************
  @brief        <b>class tC_TUNE_FREQUENCY</b>
*******************************************************************************
*/
class tC_TUNE_FREQUENCY : public AaRSLib::MSG::tCommandMessage
{
private:
    /* static memory buffer ...
     */
    tU8 _msgbuf[4];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE332,C_TUNE_FREQUENCY,"C_TUNE_FREQUENCY",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */
    typedef tU32 t__l_frequency;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__l_frequency,l_frequency,tU32,0,4);

public:
    /* custom constructor ...
     */
    tC_TUNE_FREQUENCY( t__l_frequency l_frequency )
        : AaRSLib::MSG::tCommandMessage(OP_CODE, sizeof(_msgbuf), _msgbuf)
    {
        tU32 o = 0;
        o = set_tU32(o,l_frequency);
    }

}; /* ... class tC_TUNE_FREQUENCY */

/*!
*******************************************************************************
  @brief        <b>class tR_TUNE_FREQUENCY</b>
*******************************************************************************
*/
class tR_TUNE_FREQUENCY : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    tU8 _msgbuf[4];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE333,R_TUNE_FREQUENCY,"R_TUNE_FREQUENCY",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    typedef tU32 t__l_frequency;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__l_frequency,l_frequency,tU32,0,4);

}; /* ... class tR_TUNE_FREQUENCY */

/*!
*******************************************************************************
  @brief        <b>class tC_TUNE_FREQUENCY_LABEL</b>
*******************************************************************************
*/
class tC_TUNE_FREQUENCY_LABEL : public AaRSLib::MSG::tCommandMessage
{
private:
    /* static memory buffer ...
     */

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE334,C_TUNE_FREQUENCY_LABEL,"C_TUNE_FREQUENCY_LABEL",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */
    tVoid  set__r_label_string( tPChar t_label_string )
    {
        set_tPChar(0,t_label_string,1+(tU32)AARSLIB_STRLEN(t_label_string));
    }

public:
    /* custom constructor ...
     */
    tC_TUNE_FREQUENCY_LABEL( tPChar t_label_string )
        : AaRSLib::MSG::tCommandMessage(OP_CODE, 0, NULL)
    {
        set__r_label_string(t_label_string);
    }

}; /* ... class tC_TUNE_FREQUENCY_LABEL */

/*!
*******************************************************************************
  @brief        <b>class tR_TUNE_FREQUENCY_LABEL</b>
*******************************************************************************
*/
class tR_TUNE_FREQUENCY_LABEL : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    tU8 _msgbuf[1];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE335,R_TUNE_FREQUENCY_LABEL,"R_TUNE_FREQUENCY_LABEL",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        FREQUENCY_INVALID = 0x00,
        FREQUENCY_OK = 0x01
    } t__b_frequency_state;
    MACRO_AARSLIB_SIMPLE_RESPONSE_SETGET(t__b_frequency_state,b_frequency_state,tU8,0,1);

}; /* ... class tR_TUNE_FREQUENCY_LABEL */

/*!
*******************************************************************************
  @brief        <b>class tC_TUNE_EID</b>
*******************************************************************************
*/
class tC_TUNE_EID : public AaRSLib::MSG::tCommandMessage
{
private:
    /* static memory buffer ...
     */
    tU8 _msgbuf[4];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE340,C_TUNE_EID,"C_TUNE_EID",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */
    typedef tU32 t__r_ensemble;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__r_ensemble,r_ensemble,tU32,0,4);

public:
    /* custom constructor ...
     */
    tC_TUNE_EID( t__r_ensemble r_ensemble )
        : AaRSLib::MSG::tCommandMessage(OP_CODE, sizeof(_msgbuf), _msgbuf)
    {
        tU32 o = 0;
        o = set_tU32(o,r_ensemble);
    }

}; /* ... class tC_TUNE_EID */

/*!
*******************************************************************************
  @brief        <b>class tR_TUNE_EID</b>
*******************************************************************************
*/
class tR_TUNE_EID : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    tU8 _msgbuf[4];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE341,R_TUNE_EID,"R_TUNE_EID",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        ENSEMBLE_INVALID = 0x00,
        TUNING_ENSEMBLE = 0x01,
        ENSEMBLE_NOT_FOUND = 0x02,
        TUNING_DONE = 0x12
    } t__b_ensemble_state;
    MACRO_AARSLIB_SIMPLE_RESPONSE_SETGET(t__b_ensemble_state,b_ensemble_state,tU8,0,1);

    typedef tU32 t__r_ensemble;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__r_ensemble,r_ensemble,tU32,end__b_ensemble_state(),4);

}; /* ... class tR_TUNE_EID */

/*!
*******************************************************************************
  @brief        <b>class tC_EXTJOB_CONFIGURE</b>
*******************************************************************************
*/
class tC_EXTJOB_CONFIGURE : public AaRSLib::MSG::tCommandMessage
{
private:
  /* static memory buffer ...
   */
  tU8 _msgbuf[22];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE390,C_EXTJOB_CONFIGURE,"C_EXTJOB_CONFIGURE",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_extjob_idx,tU8,0,1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_prio,tU8,end__b_extjob_idx(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU16,w_flags,tU16,end__b_prio(),2);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU32,l_resource_0,tU32,end__w_flags(),4);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU32,l_resource_1,tU32,end__l_resource_0(),4);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU32,l_resource_2,tU32,end__l_resource_1(),4);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU32,l_resource_3,tU32,end__l_resource_2(),4);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU16,w_jobid,tU16,end__l_resource_3(),2);

public:
    /* custom constructor ...
     */
    tC_EXTJOB_CONFIGURE( tU8 b_extjob_idx, tU8 b_prio, tU16 w_flags, tU32 l_resource_0, tU32 l_resource_1, tU32 l_resource_2, tU32 l_resource_3, tU16 w_jobid )
        : AaRSLib::MSG::tCommandMessage(OP_CODE, sizeof(_msgbuf), _msgbuf)
    {
        tU32 o = 0;
        o = set_tU8(o,b_extjob_idx);
        o = set_tU8(o,b_prio);
        o = set_tU16(o,w_flags);
        o = set_tU32(o,l_resource_0);
        o = set_tU32(o,l_resource_1);
        o = set_tU32(o,l_resource_2);
        o = set_tU32(o,l_resource_3);
        o = set_tU16(o,w_jobid);
    }

}; /* ... class tC_EXTJOB_CONFIGURE */

/*!
*******************************************************************************
  @brief        <b>class tR_EXTJOB_CONFIGURE</b>
*******************************************************************************
*/
class tR_EXTJOB_CONFIGURE : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    tU8 _msgbuf[23];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE391,R_EXTJOB_CONFIGURE,"R_EXTJOB_CONFIGURE",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_extjob_idx,tU8,0,1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_prio,tU8,end__b_extjob_idx(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU16,w_flags,tU16,end__b_prio(),2);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU32,l_resource_0,tU32,end__w_flags(),4);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU32,l_resource_1,tU32,end__l_resource_0(),4);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU32,l_resource_2,tU32,end__l_resource_1(),4);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU32,l_resource_3,tU32,end__l_resource_2(),4);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU16,w_jobid,tU16,end__l_resource_3(),2);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_decoder_id,tU8,end__w_jobid(),1);

}; /* ... class tR_EXTJOB_CONFIGURE */

/*!
*******************************************************************************
  @brief        <b>class tC_EXTJOB_TUNE</b>
*******************************************************************************
*/
class tC_EXTJOB_TUNE : public AaRSLib::MSG::tCommandMessage
{
private:
  /* static memory buffer ...
   */
  tU8 _msgbuf[10];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE392,C_EXTJOB_TUNE,"C_EXTJOB_TUNE",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_extjob_idx,tU8,0,1);
    typedef enum {
        b_tune_command__STOP                = 0x01,
        b_tune_command__TUNE_FREQUENCY      = 0x02,
        b_tune_command__TUNE_ONE_STEP_UP    = 0x03,
        b_tune_command__TUNE_ONE_STEP_DOWN  = 0x04,
        b_tune_command__SEARCH_UP           = 0x05,
        b_tune_command__SEARCH_DOWN         = 0x06,
        b_tune_command__SEARCH_UP_ENDLESS   = 0x07,
        b_tune_command__SEARCH_DOWN_ENDLESS = 0x08,
        b_tune_command__ENS_UP              = 0x09,
        b_tune_command__ENS_DOWN            = 0x0a,
        b_tune_command__UNDEF = 0
    } t__b_tune_command;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_tune_command,b_tune_command,tU8,end__b_extjob_idx(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU32,l_frequency_start,tU32,end__b_tune_command(),4);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU32,l_frequency_stop,tU32,end__l_frequency_start(),4);

public:
    /* custom constructor ...
     */
    tC_EXTJOB_TUNE( tU8 b_extjob_idx, tU8 b_tune_command, tU32 l_frequency_start, tU32 l_frequency_stop )
        : AaRSLib::MSG::tCommandMessage(OP_CODE, sizeof(_msgbuf), _msgbuf)
    {
        tU32 o = 0;
        o = set_tU8(o,b_extjob_idx);
        o = set_tU8(o,b_tune_command);
        o = set_tU32(o,l_frequency_start);
        o = set_tU32(o,l_frequency_stop);
    }

}; /* ... class tC_EXTJOB_TUNE */

/*!
*******************************************************************************
  @brief        <b>class tR_EXTJOB_TUNE</b>
*******************************************************************************
*/
class tR_EXTJOB_TUNE : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    tU8 _msgbuf[11];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE393,R_EXTJOB_TUNE,"R_EXTJOB_TUNE",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_extjob_idx,tU8,0,1);
    typedef enum {
        b_tune_command__STOP                = 0x01,
        b_tune_command__TUNE_FREQUENCY      = 0x02,
        b_tune_command__TUNE_ONE_STEP_UP    = 0x03,
        b_tune_command__TUNE_ONE_STEP_DOWN  = 0x04,
        b_tune_command__SEARCH_UP           = 0x05,
        b_tune_command__SEARCH_DOWN         = 0x06,
        b_tune_command__SEARCH_UP_ENDLESS   = 0x07,
        b_tune_command__SEARCH_DOWN_ENDLESS = 0x08,
        b_tune_command__ENS_UP              = 0x09,
        b_tune_command__ENS_DOWN            = 0x0a,
        b_tune_command__UNDEF = 0
    } t__b_tune_command;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_tune_command,b_tune_command,tU8,end__b_extjob_idx(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU32,l_frequency_start,tU32,end__b_tune_command(),4);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU32,l_frequency_stop,tU32,end__l_frequency_start(),4);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_state,tU8,end__l_frequency_stop(),1);

}; /* ... class tR_EXTJOB_TUNE */

/*!
*******************************************************************************
  @brief        <b>class tC_EXTJOB_SELECT_AUDIO</b>
*******************************************************************************
*/
class tC_EXTJOB_SELECT_AUDIO : public AaRSLib::MSG::tCommandMessage
{
private:
  /* static memory buffer ...
   */
  tU8 _msgbuf[10];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE394,C_EXTJOB_SELECT_AUDIO,"C_EXTJOB_SELECT_AUDIO",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_extjob_idx,tU8,0,1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_subchid,tU8,end__b_extjob_idx(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU16,w_scidi,tU16,end__b_subchid(),2);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_service_type,tU8,end__w_scidi(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU32,r_audio_service,tU32,end__b_service_type(),4);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_scids,tU8,end__r_audio_service(),1);

public:
    /* custom constructor ...
     */
    tC_EXTJOB_SELECT_AUDIO( tU8 b_extjob_idx, tU8 b_subchid, tU16 w_scidi, tU8 b_service_type, tU32 r_audio_service, tU8 b_scids )
        : AaRSLib::MSG::tCommandMessage(OP_CODE, sizeof(_msgbuf), _msgbuf)
    {
        tU32 o = 0;
        o = set_tU8(o,b_extjob_idx);
        o = set_tU8(o,b_subchid);
        o = set_tU16(o,w_scidi);
        o = set_tU8(o,b_service_type);
        o = set_tU32(o,r_audio_service);
        o = set_tU8(o,b_scids);
    }

}; /* ... class tC_EXTJOB_SELECT_AUDIO */

/*!
*******************************************************************************
  @brief        <b>class tR_EXTJOB_SELECT_AUDIO</b>
*******************************************************************************
*/
class tR_EXTJOB_SELECT_AUDIO : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    tU8 _msgbuf[23];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE395,R_EXTJOB_SELECT_AUDIO,"R_EXTJOB_SELECT_AUDIO",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_extjob_idx,tU8,0,1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_subchid,tU8,end__b_extjob_idx(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU16,w_scidi,tU16,end__b_subchid(),2);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_service_type,tU8,end__w_scidi(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU32,r_audio_service,tU32,end__b_service_type(),4);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_scids,tU8,end__r_audio_service(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_state,tU8,end__b_scids(),1);

}; /* ... class tR_EXTJOB_SELECT_AUDIO */

} /* ... namespace AaRSDABLib::API::RDM */

namespace DB
{

/*!
*******************************************************************************
  @brief        <b>class tC_CONFIG</b>
*******************************************************************************
*/
class tC_CONFIG : public AaRSLib::MSG::tCommandMessage
{
private:

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE166,C_CONFIG,"C_CONFIG",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        b_cmd__SET = 0x01,
        b_cmd__GET = 0x02
    } t__b_cmd;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_cmd,b_cmd,tU8,0,1);

    typedef enum {
        b_value_id__DELETE_ALL = 0x07,
        b_value_id__DELETE_PRESETS = 0x08,
    } t__b_value_id;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_value_id,b_value_id,tU8,end__b_cmd(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_rfu,tU8,end__b_value_id(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_para_field_length,tU8,end__b_rfu(),1);

private:
    tU32  start__r_para_field() { return end__b_para_field_length(); }
    tU32  size__r_para_field() { return b_para_field_length(); }
    tU32  end__r_para_field() { return start__r_para_field() + size__r_para_field(); }
public:
    tVoid  set__r_para_field( tPU8 value )
    {
        if( value == AARSLIB_NULL )
        {
            set__b_para_field_length(0);
        }
        set_tPU8(end__b_para_field_length(),value,b_para_field_length());
    }
    tPU8 r_para_field( void )
    {
        return (tPU8)get_tPU8(end__b_para_field_length());
    }

public:
    /* custom constructor ...
     */
    tC_CONFIG( t__b_cmd                  b_cmd,
              t__b_value_id              b_value_id,
              tU8                        b_rfu,
              tU8                        b_para_field_length,
              tU8*                       r_para_field)
        : AaRSLib::MSG::tCommandMessage(OP_CODE, 0, AARSLIB_NULL)
    {
        tU32 o = 0;
        o = set_tU8(o,b_cmd);
        o = set_tU8(o,b_value_id);
        o = set_tU8(o,b_rfu);
        if( r_para_field == AARSLIB_NULL )
        {
            b_para_field_length = 0;
        }
        if( b_para_field_length == 0 )
        {
            r_para_field = AARSLIB_NULL;
        }
        o = set_tU8(o,b_para_field_length);
        o = set_tPU8(o,(tPU8)r_para_field,b_para_field_length);
    }

}; /* ... class tC_CONFIG */

/*!
*******************************************************************************
  @brief        <b>class tR_CONFIG</b>
*******************************************************************************
*/
class tR_CONFIG : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[12...];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE167,R_CONFIG,"R_CONFIG",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        b_cmd__ERROR = 0x00,
        b_cmd__OK = 0x01
    } t__b_response;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_response,b_response,tU8,0,1);

    typedef enum {
        b_value_id__DELETE_ALL = 0x07,
        b_value_id__DELETE_PRESETS = 0x08,
    } t__b_value_id;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_value_id,b_value_id,tU8,end__b_response(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_rfu,tU8,end__b_value_id(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_para_field_length,tU8,end__b_rfu(),1);

private:
    tU32  start__r_para_field() { return end__b_para_field_length(); }
    tU32  size__r_para_field() { return b_para_field_length(); }
    tU32  end__r_para_field() { return start__r_para_field() + size__r_para_field(); }
public:
    tVoid  set__r_para_field( tPU8 value )
    {
        if( value == AARSLIB_NULL )
        {
            set__b_para_field_length(0);
        }
        set_tPU8(end__b_para_field_length(),value,b_para_field_length());
    }
    tPU8 r_para_field( void )
    {
        return (tPU8)get_tPU8(end__b_para_field_length());
    }
}; /* ... class tR_CONFIG */

/*!
*******************************************************************************
  @brief        <b>class tC_QUERY</b>
*******************************************************************************
*/
class tC_QUERY : public AaRSLib::MSG::tCommandMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[12...];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE168,C_QUERY,"C_QUERY",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        b_cmd__FREE = 0x00,
        b_cmd__EVALUATE = 0x01,
        b_cmd__PREPARE = 0x02,
        b_cmd__REOPEN_READWRITE = 0x03,
        b_cmd__REOPEN_READONLY = 0x04
    } t__b_cmd;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_cmd,b_cmd,tU8,0,1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_tag,tU8,end__b_cmd(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_stmt_id,tU8,end__b_tag(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_rfu1,tU8,end__b_stmt_id(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU16,w_sql_length,tU16,end__b_rfu1(),2);

    //MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tPChar,r_sql,tPChar,end__w_sql_length(),w_sql_length());
private:
    tU32  start__r_sql() { return end__w_sql_length(); }
    tU32  size__r_sql() { return w_sql_length(); }
    tU32  end__r_sql() { return start__r_sql() + size__r_sql(); }
public:
    tVoid  set__r_sql( tPChar value )
    {
        if( value == AARSLIB_NULL )
        {
            set__w_sql_length(0);
        }
        else
        {
            set__w_sql_length((tU16)(1+AARSLIB_STRLEN(value)));
        }
        set_tPChar(end__w_sql_length(),value,w_sql_length());
    }
    tPChar r_sql( void )
    {
        return (tPChar)get_tPChar(end__w_sql_length());
    }

    typedef enum {
        b_result_protocol__CSV_TABLE = 0x10,
        b_result_protocol__CSV_ROW = 0x20,
        b_result_protocol__SDXF_TABLE = 0x30,
        b_result_protocol__SDXF_ROW = 0x40,
        b_result_protocol__XML_TABLE = 0x50,
        b_result_protocol__XML_ROW = 0x60,
        b_result_protocol__UNDEF = 0x0
    } t__b_result_protocol;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_result_protocol,b_result_protocol,tU8,end__r_sql(),1);

    static const tU8 b_result_option__0x00 = 0x00;
    static const tU8 b_result_option__NUMERIC_IDS = (1<<0);
    static const tU8 b_result_option__TABLE_HEADER = (1<<1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_result_option,tU8,end__b_result_protocol(),1);

    typedef enum {
        b_parameter_protocol__UINT32ARRAY = 0x10,
        b_parameter_protocol__SDXF = 0x20,
        b_parameter_protocol__UNDEF = 0x00
    } t__b_parameter_protocol;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_parameter_protocol,b_parameter_protocol,tU8,end__b_result_option(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_rfu2,tU8,end__b_parameter_protocol(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU16,w_parameter_length,tU16,end__b_rfu2(),2);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tPU8,r_parameter,tPU8,end__w_parameter_length(),w_parameter_length());

public:
    /* custom constructor ...
     */
    tC_QUERY( t__b_cmd                  b_cmd,
              tU8                       b_tag,
              tU8                       b_stmt_id,
              tU8                       b_rfu1,
              tU16                      w_sql_length,
              char const*               r_sql,
              t__b_result_protocol      b_result_protocol,
              tU8                       b_result_option,
              t__b_parameter_protocol   b_parameter_protocol,
              tU8                       b_rfu2,
              tU16                      w_parameter_length,
              tPU8                      r_parameter)
        : AaRSLib::MSG::tCommandMessage(OP_CODE, 0, AARSLIB_NULL)
    {
        tU32 o = 0;
        o = set_tU8(o,b_cmd);
        o = set_tU8(o,b_tag);
        o = set_tU8(o,b_stmt_id);
        o = set_tU8(o,b_rfu1);
        if( r_sql == AARSLIB_NULL )
        {
            w_sql_length = 0;
        }
        else if( w_sql_length == 0 )
        {
            w_sql_length = (tU16)(1+AARSLIB_STRLEN(r_sql));
        }
        o = set_tU16(o,w_sql_length);
        o = set_tPChar(o,(tPChar)r_sql,w_sql_length);
        o = set_tU8(o,b_result_protocol);
        o = set_tU8(o,b_result_option);
        o = set_tU8(o,b_parameter_protocol);
        o = set_tU8(o,b_rfu2);
        o = set_tU16(o,w_parameter_length);
        o = set_tPU8(o,r_parameter,w_parameter_length);
    }

}; /* ... class tC_QUERY */

/*!
*******************************************************************************
  @brief        <b>class tR_QUERY</b>
*******************************************************************************
*/
class tR_QUERY : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[12...];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE169,R_QUERY,"R_QUERY",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        b_response__PARA_ERROR = 0x00,
        b_response__PARA_OK = 0x01
    } t__b_response;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_response,b_response,tU8,0,1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_tag,tU8,end__b_response(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_stmt_id,tU8,end__b_tag(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_rfu1,tU8,end__b_stmt_id(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU16,w_num_result_tables,tU16,end__b_rfu1(),2);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU16,w_num_result_rows,tU16,end__w_num_result_tables(),2);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU16,w_num_result_columns,tU16,end__w_num_result_rows(),2);

    typedef enum {
        b_result_protocol__CSV_TABLE = 0x10,
        b_result_protocol__CSV_ROW = 0x20,
        b_result_protocol__CSV_ROW_DONE = 0x21,
        b_result_protocol__SDXF_TABLE = 0x30,
        b_result_protocol__SDXF_ROW = 0x40,
        b_result_protocol__SDXF_ROW_DONE = 0x41,
        b_result_protocol__XML_TABLE = 0x50,
        b_result_protocol__XML_ROW = 0x60,
        b_result_protocol__XML_ROW_DONE = 0x61,
        b_result_protocol__UNDEF = 0x0
    } t__b_result_protocol;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_result_protocol,b_result_protocol,tU8,end__w_num_result_columns(),1);

    static const tU8 b_result_option__NUMERIC_IDS = (1<<0);
    static const tU8 b_result_option__TABLE_HEADER = (1<<1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_result_option,tU8,end__b_result_protocol(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU32,l_result_length,tU32,end__b_result_option(),4);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tPU8,r_result,tPU8,end__l_result_length(),l_result_length());

}; /* ... class tR_QUERY */

/*!
*******************************************************************************
  @brief        <b>class tC_QUERY_TRIGGER</b>
*******************************************************************************
*/
class tC_QUERY_TRIGGER : public AaRSLib::MSG::tCommandMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[4];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE16A,C_QUERY_TRIGGER,"C_QUERY_TRIGGER",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        b_cmd__NOP = 0,
        b_cmd__ADD = 1,
        b_cmd__DELETE = 2,
        b_cmd__DELETE_ALL = 3,
        b_cmd__UPDATE = 4,
        b_cmd__TRIGGER = 5
    } t__b_cmd;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_cmd,b_cmd,tU8,0,1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_tag,tU8,end__b_cmd(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_id,tU8,end__b_tag(),1);

    static const tU8 b_query_stmt_id__UNDEF = 0;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_query_stmt_id,tU8,end__b_id(),1);

    static const tU8 b_condition_stmt_id__UNDEF = 0;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_condition_stmt_id,tU8,end__b_query_stmt_id(),1);

    typedef enum {
        b_action__NOP = 0,
        b_action__SEND_R_DB_QUERY_TRIGGER_ONLY = 1,
        b_action__EXEC_DB_QUERY_AND_SEND_RESULT = 2,
        b_action__EXEC_DB_QUERY_AND_SEND_RESULT_WHEN_CHANGED = 3
    } t__b_action;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_action,b_action,tU8,end__b_condition_stmt_id(),1);

    static const tU8 w_rfu__UNDEF = 0;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU16,w_rfu,tU16,end__b_action(),2);

    static const tU8 w_trigger_list_size__UNDEF = 0;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU16,w_trigger_list_size,tU16,end__w_rfu(),2);

    static const tU16 TR__ADDED                                 = (0x0000+1);
    static const tU16 TR__SERVICE_DATA_COMPLETE                 = (0x1000+1);
    static const tU16 TR__CURR_RDM_ENS__CHANGED                 = (0x1000+2);
    static const tU16 TR__CURR_RDM_AUDIO_SERV__CHANGED          = (0x1000+3);
    static const tU16 TR__CURR_RDM_AUDIO_COMPONENT__CHANGED     = (0x1000+4);
    static const tU16 TR__RDM_PRESET_LIST__CHANGED              = (0x1000+5);
    static const tU16 TR__RDM_PRESET_USER__CHANGED              = (0x1000+6);
    static const tU16 TR__DAB_ENSEMBLE__QUALITY_WORD            = (0x2100+4);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tPU8,r_trigger_list,tPU8,end__w_trigger_list_size(),w_trigger_list_size());

public:
    /* custom constructor ...
     */
    tC_QUERY_TRIGGER( t__b_cmd                  b_cmd,
                      tU8                       b_tag,
                      tU8                       b_id,
                      tU8                       b_query_stmt_id,
                      tU8                       b_condition_stmt_id,
                      t__b_action               b_action,
                      tU16                      w_rfu,
                      tU16                      w_trigger_list_size,
                      tPU8                      r_trigger_list)
        : AaRSLib::MSG::tCommandMessage(OP_CODE, 0, AARSLIB_NULL)
    {
        tU32 o = 0;
        o = set_tU8(o,b_cmd);
        o = set_tU8(o,b_tag);
        o = set_tU8(o,b_id);
        o = set_tU8(o,b_query_stmt_id);
        o = set_tU8(o,b_condition_stmt_id);
        o = set_tU8(o,b_action);
        o = set_tU16(o,w_rfu);
        o = set_tU16(o,w_trigger_list_size);
        o = set_tPU8(o,r_trigger_list,w_trigger_list_size);
    }

    tC_QUERY_TRIGGER( t__b_cmd                  b_cmd,
                      tU8                       b_tag,
                      tU8                       b_id,
                      tU8                       b_query_stmt_id,
                      tU8                       b_condition_stmt_id,
                      t__b_action               b_action,
                      tU16                      w_rfu,
                      tU16                      trigger_0,
                      tU16                      trigger_1,
                      tU16                      trigger_2,
                      tU16                      trigger_3,
                      tU16                      trigger_4,
                      tU16                      trigger_5,
                      tU16                      trigger_6,
                      tU16                      trigger_7)
        : AaRSLib::MSG::tCommandMessage(OP_CODE, 0, AARSLIB_NULL)
    {
        tU32 o = 0;
        o = set_tU8(o,b_cmd);
        o = set_tU8(o,b_tag);
        o = set_tU8(o,b_id);
        o = set_tU8(o,b_query_stmt_id);
        o = set_tU8(o,b_condition_stmt_id);
        o = set_tU8(o,b_action);
        o = set_tU16(o,w_rfu);
        o = set_tU16(o,0);
        tU32 q = o;
        if( trigger_0 != 0 ) o = set_tU16(o,trigger_0);
        if( trigger_1 != 0 ) o = set_tU16(o,trigger_1);
        if( trigger_2 != 0 ) o = set_tU16(o,trigger_2);
        if( trigger_3 != 0 ) o = set_tU16(o,trigger_3);
        if( trigger_4 != 0 ) o = set_tU16(o,trigger_4);
        if( trigger_5 != 0 ) o = set_tU16(o,trigger_5);
        if( trigger_6 != 0 ) o = set_tU16(o,trigger_6);
        if( trigger_7 != 0 ) o = set_tU16(o,trigger_7);
        set__w_trigger_list_size((tU16)((o-q)/2));
    }

    tC_QUERY_TRIGGER( t__b_cmd                  b_cmd,
                      tU8                       b_tag,
                      tU8                       b_id,
                      tU8                       b_query_stmt_id,
                      tU8                       b_condition_stmt_id,
                      t__b_action               b_action,
                      tU16                      w_rfu,
                      tU16                      trigger_0,
                      tU16                      trigger_1,
                      tU16                      trigger_2,
                      tU16                      trigger_3,
                      tU16                      trigger_4,
                      tU16                      trigger_5,
                      tU16                      trigger_6)
        : AaRSLib::MSG::tCommandMessage(OP_CODE, 0, AARSLIB_NULL)
    {
        tU32 o = 0;
        o = set_tU8(o,b_cmd);
        o = set_tU8(o,b_tag);
        o = set_tU8(o,b_id);
        o = set_tU8(o,b_query_stmt_id);
        o = set_tU8(o,b_condition_stmt_id);
        o = set_tU8(o,b_action);
        o = set_tU16(o,w_rfu);
        o = set_tU16(o,0);
        tU32 q = o;
        if( trigger_0 != 0 ) o = set_tU16(o,trigger_0);
        if( trigger_1 != 0 ) o = set_tU16(o,trigger_1);
        if( trigger_2 != 0 ) o = set_tU16(o,trigger_2);
        if( trigger_3 != 0 ) o = set_tU16(o,trigger_3);
        if( trigger_4 != 0 ) o = set_tU16(o,trigger_4);
        if( trigger_5 != 0 ) o = set_tU16(o,trigger_5);
        if( trigger_6 != 0 ) o = set_tU16(o,trigger_6);
        set__w_trigger_list_size((tU16)((o-q)/2));
    }

    tC_QUERY_TRIGGER( t__b_cmd                  b_cmd,
                      tU8                       b_tag,
                      tU8                       b_id,
                      tU8                       b_query_stmt_id,
                      tU8                       b_condition_stmt_id,
                      t__b_action               b_action,
                      tU16                      w_rfu,
                      tU16                      trigger_0,
                      tU16                      trigger_1,
                      tU16                      trigger_2,
                      tU16                      trigger_3,
                      tU16                      trigger_4,
                      tU16                      trigger_5)
        : AaRSLib::MSG::tCommandMessage(OP_CODE, 0, AARSLIB_NULL)
    {
        tU32 o = 0;
        o = set_tU8(o,b_cmd);
        o = set_tU8(o,b_tag);
        o = set_tU8(o,b_id);
        o = set_tU8(o,b_query_stmt_id);
        o = set_tU8(o,b_condition_stmt_id);
        o = set_tU8(o,b_action);
        o = set_tU16(o,w_rfu);
        o = set_tU16(o,0);
        tU32 q = o;
        if( trigger_0 != 0 ) o = set_tU16(o,trigger_0);
        if( trigger_1 != 0 ) o = set_tU16(o,trigger_1);
        if( trigger_2 != 0 ) o = set_tU16(o,trigger_2);
        if( trigger_3 != 0 ) o = set_tU16(o,trigger_3);
        if( trigger_4 != 0 ) o = set_tU16(o,trigger_4);
        if( trigger_5 != 0 ) o = set_tU16(o,trigger_5);
        set__w_trigger_list_size((tU16)((o-q)/2));
    }

    tC_QUERY_TRIGGER( t__b_cmd                  b_cmd,
                      tU8                       b_tag,
                      tU8                       b_id,
                      tU8                       b_query_stmt_id,
                      tU8                       b_condition_stmt_id,
                      t__b_action               b_action,
                      tU16                      w_rfu,
                      tU16                      trigger_0,
                      tU16                      trigger_1,
                      tU16                      trigger_2,
                      tU16                      trigger_3,
                      tU16                      trigger_4)
        : AaRSLib::MSG::tCommandMessage(OP_CODE, 0, AARSLIB_NULL)
    {
        tU32 o = 0;
        o = set_tU8(o,b_cmd);
        o = set_tU8(o,b_tag);
        o = set_tU8(o,b_id);
        o = set_tU8(o,b_query_stmt_id);
        o = set_tU8(o,b_condition_stmt_id);
        o = set_tU8(o,b_action);
        o = set_tU16(o,w_rfu);
        o = set_tU16(o,0);
        tU32 q = o;
        if( trigger_0 != 0 ) o = set_tU16(o,trigger_0);
        if( trigger_1 != 0 ) o = set_tU16(o,trigger_1);
        if( trigger_2 != 0 ) o = set_tU16(o,trigger_2);
        if( trigger_3 != 0 ) o = set_tU16(o,trigger_3);
        if( trigger_4 != 0 ) o = set_tU16(o,trigger_4);
        set__w_trigger_list_size((tU16)((o-q)/2));
    }

    tC_QUERY_TRIGGER( t__b_cmd                  b_cmd,
                      tU8                       b_tag,
                      tU8                       b_id,
                      tU8                       b_query_stmt_id,
                      tU8                       b_condition_stmt_id,
                      t__b_action               b_action,
                      tU16                      w_rfu,
                      tU16                      trigger_0,
                      tU16                      trigger_1,
                      tU16                      trigger_2,
                      tU16                      trigger_3)
        : AaRSLib::MSG::tCommandMessage(OP_CODE, 0, AARSLIB_NULL)
    {
        tU32 o = 0;
        o = set_tU8(o,b_cmd);
        o = set_tU8(o,b_tag);
        o = set_tU8(o,b_id);
        o = set_tU8(o,b_query_stmt_id);
        o = set_tU8(o,b_condition_stmt_id);
        o = set_tU8(o,b_action);
        o = set_tU16(o,w_rfu);
        o = set_tU16(o,0);
        tU32 q = o;
        if( trigger_0 != 0 ) o = set_tU16(o,trigger_0);
        if( trigger_1 != 0 ) o = set_tU16(o,trigger_1);
        if( trigger_2 != 0 ) o = set_tU16(o,trigger_2);
        if( trigger_3 != 0 ) o = set_tU16(o,trigger_3);
        set__w_trigger_list_size((tU16)((o-q)/2));
    }

    tC_QUERY_TRIGGER( t__b_cmd                  b_cmd,
                      tU8                       b_tag,
                      tU8                       b_id,
                      tU8                       b_query_stmt_id,
                      tU8                       b_condition_stmt_id,
                      t__b_action               b_action,
                      tU16                      w_rfu,
                      tU16                      trigger_0,
                      tU16                      trigger_1,
                      tU16                      trigger_2)
        : AaRSLib::MSG::tCommandMessage(OP_CODE, 0, AARSLIB_NULL)
    {
        tU32 o = 0;
        o = set_tU8(o,b_cmd);
        o = set_tU8(o,b_tag);
        o = set_tU8(o,b_id);
        o = set_tU8(o,b_query_stmt_id);
        o = set_tU8(o,b_condition_stmt_id);
        o = set_tU8(o,b_action);
        o = set_tU16(o,w_rfu);
        o = set_tU16(o,0);
        tU32 q = o;
        if( trigger_0 != 0 ) o = set_tU16(o,trigger_0);
        if( trigger_1 != 0 ) o = set_tU16(o,trigger_1);
        if( trigger_2 != 0 ) o = set_tU16(o,trigger_2);
        set__w_trigger_list_size((tU16)((o-q)/2));
    }

    tC_QUERY_TRIGGER( t__b_cmd                  b_cmd,
                      tU8                       b_tag,
                      tU8                       b_id,
                      tU8                       b_query_stmt_id,
                      tU8                       b_condition_stmt_id,
                      t__b_action               b_action,
                      tU16                      w_rfu,
                      tU16                      trigger_0,
                      tU16                      trigger_1)
        : AaRSLib::MSG::tCommandMessage(OP_CODE, 0, AARSLIB_NULL)
    {
        tU32 o = 0;
        o = set_tU8(o,b_cmd);
        o = set_tU8(o,b_tag);
        o = set_tU8(o,b_id);
        o = set_tU8(o,b_query_stmt_id);
        o = set_tU8(o,b_condition_stmt_id);
        o = set_tU8(o,b_action);
        o = set_tU16(o,w_rfu);
        o = set_tU16(o,0);
        tU32 q = o;
        if( trigger_0 != 0 ) o = set_tU16(o,trigger_0);
        if( trigger_1 != 0 ) o = set_tU16(o,trigger_1);
        set__w_trigger_list_size((tU16)((o-q)/2));
    }

    tC_QUERY_TRIGGER( t__b_cmd                  b_cmd,
                      tU8                       b_tag,
                      tU8                       b_id,
                      tU8                       b_query_stmt_id,
                      tU8                       b_condition_stmt_id,
                      t__b_action               b_action,
                      tU16                      w_rfu,
                      tU16                      trigger_0)
        : AaRSLib::MSG::tCommandMessage(OP_CODE, 0, AARSLIB_NULL)
    {
        tU32 o = 0;
        o = set_tU8(o,b_cmd);
        o = set_tU8(o,b_tag);
        o = set_tU8(o,b_id);
        o = set_tU8(o,b_query_stmt_id);
        o = set_tU8(o,b_condition_stmt_id);
        o = set_tU8(o,b_action);
        o = set_tU16(o,w_rfu);
        o = set_tU16(o,0);
        tU32 q = o;
        if( trigger_0 != 0 ) o = set_tU16(o,trigger_0);
        set__w_trigger_list_size((tU16)((o-q)/2));
    }

}; /* ... class tC_QUERY_TRIGGER */

/*!
*******************************************************************************
  @brief        <b>class tR_QUERY_TRIGGER</b>
*******************************************************************************
*/
class tR_QUERY_TRIGGER : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[4];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE16B,R_QUERY_TRIGGER,"R_QUERY_TRIGGER",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        b_response__NOP = 0,
        b_response__ADD = 1,
        b_response__DELETE = 2,
        b_response__DELETE_ALL = 3,
        b_response__UPDATE = 4,
        b_response__ERROR = 255,
        b_response__ONEVENT = 0x10
    } t__b_response;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_response,b_response,tU8,0,1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_tag,tU8,end__b_response(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_id,tU8,end__b_tag(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_query_stmt_id,tU8,end__b_id(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_condition_stmt_id,tU8,end__b_query_stmt_id(),1);

    typedef enum {
        b_action__NOP = 0,
        b_action__SEND_R_DB_QUERY_TRIGGER_ONLY = 1,
        b_action__EXEC_DB_QUERY_AND_SEND_RESULT = 2,
        b_action__EXEC_DB_QUERY_AND_SEND_RESULT_WHEN_CHANGED = 3
    } t__b_action;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_action,b_action,tU8,end__b_condition_stmt_id(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU16,w_rfu,tU16,end__b_action(),2);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU16,w_trigger_list_size,tU16,end__w_rfu(),2);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tPU8,r_trigger_list,tPU8,end__w_trigger_list_size(),w_trigger_list_size());

}; /* ... class tR_QUERY_TRIGGER */

/*!
*******************************************************************************
  @brief        <b>class tC_SET_AUTO_NOTIFICATION</b>
*******************************************************************************
*/
class tC_SET_AUTO_NOTIFICATION : public AaRSLib::MSG::tCommandMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[4];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE110,C_SET_AUTO_NOTIFICATION,"C_SET_AUTO_NOTIFICATION",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */

public:
    /* custom constructor ...
     */

}; /* ... class tC_SET_AUTO_NOTIFICATION */

/*!
*******************************************************************************
  @brief        <b>class tR_SET_AUTO_NOTIFICATION</b>
*******************************************************************************
*/
class tR_SET_AUTO_NOTIFICATION : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[4];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE111,R_SET_AUTO_NOTIFICATION,"R_SET_AUTO_NOTIFICATION",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */

}; /* ... class tR_SET_AUTO_NOTIFICATION */

} /* ... namespace AaRSDABLib::API::DB */

namespace AUD
{

/*!
*******************************************************************************
  @brief        <b>class tC_SET_MODE</b>
*******************************************************************************
*/
class tC_SET_MODE : public AaRSLib::MSG::tCommandMessage
{
private:
    /* static memory buffer ...
     */
    tU8 _msgbuf[2];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE930,C_SET_MODE,"C_SET_MODE",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_mode,tU8,0,1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_rfu,tU8,end__b_mode(),1);

public:
    /* custom constructor ...
     */
    tC_SET_MODE( tU8       b_mode,
                 tU8       b_rfu)
        : AaRSLib::MSG::tCommandMessage(OP_CODE, sizeof(_msgbuf), _msgbuf)
    {
        tU32 o = 0;
        o = set_tU8(o,b_mode);
        o = set_tU8(o,b_rfu);
    }

}; /* ... class tC_SET_MODE */

/*!
*******************************************************************************
  @brief        <b>class tR_SET_MODE</b>
*******************************************************************************
*/
class tR_SET_MODE : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[2];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE931,R_SET_MODE,"R_SET_MODE",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_mode,tU8,0,1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_rfu,tU8,end__b_mode(),1);

public:
    /* custom constructor ...
     */

}; /* ... class tR_SET_MODE */

} /* ... namespace AaRSDABLib::API::AUD */

namespace EXP
{

/*!
*******************************************************************************
  @brief        <b>class tC_SELECT</b>
*******************************************************************************
*/
class tC_SELECT : public AaRSLib::MSG::tCommandMessage
{
private:
    /* static memory buffer ...
     */
    tU8 _msgbuf[3];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE900,C_SELECT,"C_SELECT",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        w_value_id__DIAG_EID            = 0x0201,
        w_value_id__DIAG_SID            = 0x0210,
        w_value_id__DIAG_EID_2          = 0x02B1,
        w_value_id__DIAG_FREQUENCY      = 0x0202,
        w_value_id__DIAG_FREQUENCY_2    = 0x02B2,
        w_value_id__DIAG_SYNC           = 0x0208,
        w_value_id__DIAG_SYNC_2         = 0x02B8,
        w_value_id__DIAG_FIC_BER        = 0x0207,
        w_value_id__DIAG_AUDIO_BER      = 0x0204,
        w_value_id__DIAG_FIC_BER_2      = 0x02B7,
        w_value_id__DIAG_SYS_STATISTIC  = 0x0407,
        w_value_id__UNDEF = 0
    } t__w_value_id;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_value_id,w_value_id,tU16,0,2);

    typedef enum {
        b_action__DISABLE                 = 0x01,
        b_action__ENABLE_MANUAL           = 0x02,
        b_action__ENABLE_AUTO_UPDATE      = 0x03,
        b_action__UPDATE_VALUE            = 0x04,
        b_action__UPDATE_DESCRIPTION      = 0x05,
        b_action__SET_POSTMSGID           = 0x06,
        b_action__SCANIDS                 = 0xff
    } t__b_action;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_action,b_action,tU8,end__w_value_id(),1);

public:
    /* custom constructor ...
     */
    tC_SELECT( t__w_value_id       w_value_id,
               t__b_action         b_action)
        : AaRSLib::MSG::tCommandMessage(OP_CODE, 0, AARSLIB_NULL)
    {
        tU32 o = 0;
        o = set_tU16(o,w_value_id);
        o = set_tU8(o,b_action);
    }

    tC_SELECT( tU16                w_value_id,
               t__b_action         b_action)
        : AaRSLib::MSG::tCommandMessage(OP_CODE, 0, AARSLIB_NULL)
    {
        tU32 o = 0;
        o = set_tU16(o,w_value_id);
        o = set_tU8(o,b_action);
    }

}; /* ... class tC_SELECT */

/*!
*******************************************************************************
  @brief        <b>class tR_SELECT</b>
*******************************************************************************
*/
class tR_SELECT : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[2];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE901,R_SELECT,"R_SELECT",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        w_value_id__DIAG_EID            = 0x0201,
        w_value_id__DIAG_SID            = 0x0210,
        w_value_id__DIAG_EID_2          = 0x02B1,
        w_value_id__DIAG_FREQUENCY      = 0x0202,
        w_value_id__DIAG_FREQUENCY_2    = 0x02B2,
        w_value_id__DIAG_FIC_BER        = 0x0207,
        w_value_id__DIAG_FIC_BER_2      = 0x02B7,
        w_value_id__DIAG_SYS_STATISTIC  = 0x0407,
        w_value_id__UNDEF = 0
    } t__w_value_id;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_value_id,w_value_id,tU16,0,2);

    typedef enum {
        b_action__DISABLE                 = 0x01,
        b_action__ENABLE_MANUAL           = 0x02,
        b_action__ENABLE_AUTO_UPDATE      = 0x03,
        b_action__UPDATE_VALUE            = 0x04,
        b_action__UPDATE_DESCRIPTION      = 0x05,
        b_action__SET_POSTMSGID           = 0x06,
        b_action__SCANIDS                 = 0xff
    } t__b_action;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_action,b_action,tU8,end__w_value_id(),1);

    typedef enum {
        b_value_type__UNDEFINED               = 0x00,
        b_value_type__LABEL                   = 0x01,
        b_value_type__UINT32                  = 0x02,
        b_value_type__UINT32_RW               = 0x03,
        b_value_type__BYTEARRAY               = 0x04,
        b_value_type__UINT32_FUNC             = 0x05,
        b_value_type__RW_MASK                 = 0x80,
        b_value_type__FUNC_MASK               = 0x40,
        b_value_type__TYPE_MASK               = 0x3f
    } t__b_value_type;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_value_type,b_value_type,tU8,end__b_action(),1);

public:
    /* custom constructor ...
     */

}; /* ... class tR_SELECT */

/*!
*******************************************************************************
  @brief        <b>class tC_ID_SET_VALUE_UINT32</b>
*******************************************************************************
*/
class tC_ID_SET_VALUE_UINT32 : public AaRSLib::MSG::tCommandMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[2];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE908,C_ID_SET_VALUE_UINT32,"C_ID_SET_VALUE_UINT32",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        w_value_id__DIAG_EID            = 0x0201,
        w_value_id__DIAG_SID            = 0x0210,
        w_value_id__DIAG_EID_2          = 0x02B1,
        w_value_id__DIAG_FREQUENCY      = 0x0202,
        w_value_id__DIAG_FREQUENCY_2    = 0x02B2,
        w_value_id__DIAG_FIC_BER        = 0x0207,
        w_value_id__DIAG_FIC_BER_2      = 0x02B7,
        w_value_id__DIAG_SYS_STATISTIC  = 0x0407,
        w_value_id__UNDEF = 0
    } t__w_value_id;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_value_id,w_value_id,tU16,0,2);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU32,l_value,tU32,end__w_value_id(),4);

public:
    /* custom constructor ...
     */
    tC_ID_SET_VALUE_UINT32( t__w_value_id       w_value_id,
                        tU32                l_value)
        : AaRSLib::MSG::tCommandMessage(OP_CODE, 0, AARSLIB_NULL)
    {
        tU32 o = 0;
        o = set_tU16(o,w_value_id);
        o = set_tU32(o,l_value);
    }

    tC_ID_SET_VALUE_UINT32( tU16                w_value_id,
                        tU32                l_value)
        : AaRSLib::MSG::tCommandMessage(OP_CODE, 0, AARSLIB_NULL)
    {
        tU32 o = 0;
        o = set_tU16(o,w_value_id);
        o = set_tU32(o,l_value);
    }

}; /* ... class tC_ID_SET_VALUE_UINT32 */

/*!
*******************************************************************************
  @brief        <b>class tR_ID_VALUE_UINT32</b>
*******************************************************************************
*/
class tR_ID_VALUE_UINT32 : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[2];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE907,R_ID_VALUE_UINT32,"R_ID_VALUE_UINT32",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        w_value_id__DIAG_EID            = 0x0201,
        w_value_id__DIAG_SID            = 0x0210,
        w_value_id__DIAG_EID_2          = 0x02B1,
        w_value_id__DIAG_FREQUENCY      = 0x0202,
        w_value_id__DIAG_FREQUENCY_2    = 0x02B2,
        w_value_id__DIAG_FIC_BER        = 0x0207,
        w_value_id__DIAG_FIC_BER_2      = 0x02B7,
        w_value_id__DIAG_SYS_STATISTIC  = 0x0407,
        w_value_id__UNDEF = 0
    } t__w_value_id;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_value_id,w_value_id,tU16,0,2);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU32,l_value,tU32,end__w_value_id(),4);

public:
    /* custom constructor ...
     */

}; /* ... class tR_ID_VALUE_UINT32 */

/*!
*******************************************************************************
  @brief        <b>class tR_ID_DESCRIPTION</b>
*******************************************************************************
*/
class tR_ID_DESCRIPTION : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[2];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE903,R_ID_DESCRIPTION,"R_ID_DESCRIPTION",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU16,w_value_id,tU16,0,2);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tPU8,r_description_label,tPU8,end__w_value_id(),20);

public:
    /* custom constructor ...
     */

}; /* ... class tR_ID_DESCRIPTION */

/*!
*******************************************************************************
  @brief        <b>class tR_ID_VALUE_LABEL</b>
*******************************************************************************
*/
class tR_ID_VALUE_LABEL : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[2];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE905,R_ID_VALUE_LABEL,"R_ID_VALUE_LABEL",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU16,w_value_id,tU16,0,2);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tPU8,r_value_label,tPU8,end__w_value_id(),20);

public:
    /* custom constructor ...
     */

}; /* ... class tR_ID_VALUE_LABEL */

/*!
*******************************************************************************
  @brief        <b>class tR_ID_VALUE_BYTEARRAY</b>
*******************************************************************************
*/      
class tR_ID_VALUE_BYTEARRAY : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[2];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE90d,R_ID_VALUE_BYTEARRAY,"R_ID_VALUE_BYTEARRAY",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU16,w_value_id,tU16,0,2);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU32,l_length,tU32,end__w_value_id(),4);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tPU8,r_data,tPU8,end__l_length(),l_length());

public:
    /* custom constructor ...
     */

}; /* ... class tR_ID_VALUE_BYTEARRAY */

} /* ... namespace AaRSDABLib::API::EXP */

namespace AUD
{

/*!
*******************************************************************************
  @brief        <b>class tC_SET_CONCEALMENT_LEVEL</b>
*******************************************************************************
*/
class tC_SET_CONCEALMENT_LEVEL : public AaRSLib::MSG::tCommandMessage
{
private:
    /* static memory buffer ...
     */
    tU8 _msgbuf[2];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE934,C_SET_CONCEALMENT_LEVEL,"C_SET_CONCEALMENT_LEVEL",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_concealment_level,tU8,0,1);

public:
    /* custom constructor ...
     */
    tC_SET_CONCEALMENT_LEVEL( tU8 b_concealment_level)
        : AaRSLib::MSG::tCommandMessage(OP_CODE, 0, AARSLIB_NULL)
    {
        tU32 o = 0;
        o = set_tU8(o,b_concealment_level);
    }

}; /* ... class tC_SET_CONCEALMENT_LEVEL */

/*!
*******************************************************************************
  @brief        <b>class tR_SET_CONCEALMENT_LEVEL</b>
*******************************************************************************
*/
class tR_SET_CONCEALMENT_LEVEL : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[2];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE935,R_SET_CONCEALMENT_LEVEL,"R_SET_CONCEALMENT_LEVEL",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_concealment_level,tU8,0,1);

}; /* ... class tR_SET_CONCEALMENT_LEVEL */

}

namespace SYS
{

/*!
*******************************************************************************
  @brief        <b>class tC_STORAGE_GET_FRAME</b>
*******************************************************************************
*/
class tC_STORAGE_GET_FRAME : public AaRSLib::MSG::tCommandMessage
{
private:
    /* static memory buffer ...
     */
    tU8 _msgbuf[2];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xEB06,C_STORAGE_GET_FRAME,"C_STORAGE_GET_FRAME",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        b_user_id__NO_USER = 0,
        b_user_id__USER_1 = 0,
        b_user_id__USER_2 = 0,
        b_user_id__USER_3 = 0,
        b_user_id__USER_4 = 0
    } t__b_user_id;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_user_id,b_user_id,tU8,0,1);

    typedef enum {
        b_device_id__PARAMETER_MEMORY = 0x01,
        b_device_id__WRITEONCE_MEMORY = 0x02,
        b_device_id__ERRORLOG_MEMORY = 0x03,
    } t__b_device_id;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_device_id,b_device_id,tU8,end__b_user_id(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU16,w_data_type,tU16,end__b_device_id(),2);

public:
    /* custom constructor ...
     */
    tC_STORAGE_GET_FRAME( t__b_user_id       b_user_id,
                          t__b_device_id     b_device_id,
                          tU16               w_data_type)
        : AaRSLib::MSG::tCommandMessage(OP_CODE, 0, AARSLIB_NULL)
    {
        tU32 o = 0;
        o = set_tU8(o,b_user_id);
        o = set_tU8(o,b_device_id);
        o = set_tU16(o,w_data_type);
    }

}; /* ... class tC_STORAGE_GET_FRAME */

/*!
*******************************************************************************
  @brief        <b>class tR_STORAGE_GET_FRAME</b>
*******************************************************************************
*/
class tR_STORAGE_GET_FRAME : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[4];

    tU8 longversion()
    {
        tU32 a = size();
        tU32 b = 10+(tU32)get_tU32(start__l_data_length());
        if( a == b )
        {
            return 1;
        }
        else
        {
            return 0;
        }
    }

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xEB07,R_STORAGE_GET_FRAME,"R_STORAGE_GET_FRAME",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        b_user_id__NO_USER = 0,
        b_user_id__USER_1 = 0,
        b_user_id__USER_2 = 0,
        b_user_id__USER_3 = 0,
        b_user_id__USER_4 = 0
    } t__b_user_id;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_user_id,b_user_id,tU8,0,1);

    typedef enum {
        b_device_id__PARAMETER_MEMORY = 0x01,
        b_device_id__WRITEONCE_MEMORY = 0x02,
        b_device_id__ERRORLOG_MEMORY = 0x03,
    } t__b_device_id;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_device_id,b_device_id,tU8,end__b_user_id(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU16,w_data_type,tU16,end__b_device_id(),2);

private:
    tU32  start__l_data_length() { return end__w_data_type(); }
    tU32  size__l_data_length() { return ((longversion()==1)?4:2); }
    tU32  end__l_data_length() { return start__l_data_length() + size__l_data_length(); }
public:
    tVoid  set__l_data_length( tU32 value )
    {
        if( size__l_data_length() == 2 )
        {
            set_tU16(start__l_data_length(),(tU16)value);
        }
        else
        {
            set_tU32(start__l_data_length(),value);
        }
    }
    tU32 l_data_length( void )
    {
        if( size__l_data_length() == 2 )
        {
            return (tU32)get_tU16(start__l_data_length());
        }
        else
        {
            return (tU32)get_tU32(start__l_data_length());
        }
    }

    //MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU32,l_data_length,tU32,end__w_data_type(),((longversion()==1)?4:2));

private:
    tU32  start__r_data() { return end__l_data_length(); }
    tU32  size__r_data() { return l_data_length(); }
    tU32  end__r_data() { return start__r_data() + size__r_data(); }
public:
    tVoid  set__r_data( tPU8 value )
    {
        if( value == AARSLIB_NULL )
        {
            set__l_data_length(0);
        }
        set_tPU8(end__l_data_length(),value,l_data_length());
    }
    tPU8 r_data( void )
    {
        return (tPU8)get_tPU8(end__l_data_length());
    }
}; /* ... class tR_STORAGE_GET_FRAME */

/*!
*******************************************************************************
  @brief        <b>class tC_STORAGE_PUT_FRAME</b>
*******************************************************************************
*/
class tC_STORAGE_PUT_FRAME : public AaRSLib::MSG::tCommandMessage
{
private:
    /* static memory buffer ...
     */
    tU8 _msgbuf[2];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xEB08,C_STORAGE_PUT_FRAME,"C_STORAGE_PUT_FRAME",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        b_user_id__NO_USER = 0,
        b_user_id__USER_1 = 0,
        b_user_id__USER_2 = 0,
        b_user_id__USER_3 = 0,
        b_user_id__USER_4 = 0
    } t__b_user_id;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_user_id,b_user_id,tU8,0,1);

    typedef enum {
        b_device_id__PARAMETER_MEMORY = 0x01,
        b_device_id__WRITEONCE_MEMORY = 0x02,
        b_device_id__ERRORLOG_MEMORY = 0x03,
    } t__b_device_id;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_device_id,b_device_id,tU8,end__b_user_id(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU16,w_data_type,tU16,end__b_device_id(),2);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU16,w_data_length,tU16,end__w_data_type(),2);

private:
    tU32  start__r_data() { return end__w_data_length(); }
    tU32  size__r_data() { return w_data_length(); }
    tU32  end__r_data() { return start__r_data() + size__r_data(); }
public:
    tVoid  set__r_data( tPU8 value )
    {
        if( value == AARSLIB_NULL )
        {
            set__w_data_length(0);
        }
        set_tPU8(end__w_data_length(),value,w_data_length());
    }
    tPU8 r_data( void )
    {
        return (tPU8)get_tPU8(end__w_data_length());
    }
public:
    /* custom constructor ...
     */
    tC_STORAGE_PUT_FRAME( t__b_user_id       b_user_id,
                          t__b_device_id     b_device_id,
                          tU16               w_data_type,
                          tU16               w_data_length,
                          tPU8               r_data)
        : AaRSLib::MSG::tCommandMessage(OP_CODE, 0, AARSLIB_NULL)
    {
        tU32 o = 0;
        o = set_tU8(o,b_user_id);
        o = set_tU8(o,b_device_id);
        o = set_tU16(o,w_data_type);
        if( r_data == AARSLIB_NULL )
        {
            w_data_length = 0;
        }
        if( w_data_length == 0 )
        {
            r_data = AARSLIB_NULL;
        }
        o = set_tU16(o,w_data_length);
        o = set_tPU8(o,(tPU8)r_data,w_data_length);
    }

}; /* ... class tC_STORAGE_PUT_FRAME */

/*!
*******************************************************************************
  @brief        <b>class tR_STORAGE_PUT_FRAME</b>
*******************************************************************************
*/
class tR_STORAGE_PUT_FRAME : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[4];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xEB09,R_STORAGE_PUT_FRAME,"R_STORAGE_PUT_FRAME",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        b_user_id__NO_USER = 0,
        b_user_id__USER_1 = 0,
        b_user_id__USER_2 = 0,
        b_user_id__USER_3 = 0,
        b_user_id__USER_4 = 0
    } t__b_user_id;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_user_id,b_user_id,tU8,0,1);

    typedef enum {
        b_device_id__PARAMETER_MEMORY = 0x01,
        b_device_id__WRITEONCE_MEMORY = 0x02,
        b_device_id__ERRORLOG_MEMORY = 0x03,
    } t__b_device_id;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_device_id,b_device_id,tU8,end__b_user_id(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU16,w_data_type,tU16,end__b_device_id(),2);

}; /* ... class tR_STORAGE_PUT_FRAME */

/*!
*******************************************************************************
  @brief        <b>class tC_STORAGE_GET_FRAME_SEGMENT</b>
*******************************************************************************
*/
class tC_STORAGE_GET_FRAME_SEGMENT : public AaRSLib::MSG::tCommandMessage
{
private:
    /* static memory buffer ...
     */
    tU8 _msgbuf[2];

    tU8 longversion()
    {
        tU32 a = size();
        tU32 b = 16+l_segment_length();
        if( a == b )
        {
            return 1;
        }
        else
        {
            return 0;
        }
    }

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xEB0E,C_STORAGE_GET_FRAME_SEGMENT,"C_STORAGE_GET_FRAME_SEGMENT",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */

    typedef enum {
        b_user_id__NO_USER = 0,
        b_user_id__USER_1 = 0,
        b_user_id__USER_2 = 0,
        b_user_id__USER_3 = 0,
        b_user_id__USER_4 = 0
    } t__b_user_id;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_user_id,b_user_id,tU8,0,1);

    typedef enum {
        b_device_id__PARAMETER_MEMORY = 0x01,
        b_device_id__WRITEONCE_MEMORY = 0x02,
        b_device_id__ERRORLOG_MEMORY = 0x03,
    } t__b_device_id;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_device_id,b_device_id,tU8,end__b_user_id(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU16,w_data_type,tU16,end__b_device_id(),2);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU32,l_start_addr,tU16,end__w_data_type(),((longversion()==1)?4:2));

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU32,l_segment_length,tU16,end__l_start_addr(),((longversion()==1)?4:2));

public:
    /* custom constructor ...
     */
    tC_STORAGE_GET_FRAME_SEGMENT( t__b_user_id       b_user_id,
                                  t__b_device_id     b_device_id,
                                  tU32               w_data_type,
                                  tU32               l_start_addr,
                                  tU32               l_segment_length)
        : AaRSLib::MSG::tCommandMessage(OP_CODE, 0, AARSLIB_NULL)
    {
        tU32 o = 0;
        o = set_tU8(o,b_user_id);
        o = set_tU8(o,b_device_id);
        o = set_tU16(o,(tU16)w_data_type);
        o = set_tU32(o,l_start_addr);
        o = set_tU32(o,l_segment_length);
    }

}; /* ... class tC_STORAGE_GET_FRAME_SEGMENT */

/*!
*******************************************************************************
  @brief        <b>class tR_STORAGE_GET_FRAME_SEGMENT</b>
*******************************************************************************
*/
class tR_STORAGE_GET_FRAME_SEGMENT : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[4];

    tU8 longversion()
    {
        tU32 a = size();
        tU32 b = 16+l_data_length();
        if( a == b )
        {
            return 1;
        }
        else
        {
            return 0;
        }
    }

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xEB0F,R_STORAGE_GET_FRAME_SEGMENT,"R_STORAGE_GET_FRAME_SEGMENT",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        b_user_id__NO_USER = 0,
        b_user_id__USER_1 = 0,
        b_user_id__USER_2 = 0,
        b_user_id__USER_3 = 0,
        b_user_id__USER_4 = 0
    } t__b_user_id;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_user_id,b_user_id,tU8,0,1);

    typedef enum {
        b_device_id__PARAMETER_MEMORY = 0x01,
        b_device_id__WRITEONCE_MEMORY = 0x02,
        b_device_id__ERRORLOG_MEMORY = 0x03,
    } t__b_device_id;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_device_id,b_device_id,tU8,end__b_user_id(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU16,w_data_type,tU16,end__b_device_id(),2);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU32,l_data_length,tU32,end__w_data_type(),((longversion()==1)?4:2));

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU32,l_start_addr,tU32,end__l_data_length(),((longversion()==1)?4:2));

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU32,l_bytes_after,tU32,end__l_start_addr(),((longversion()==1)?4:2));

private:
    tU32  start__r_data() { return end__l_bytes_after(); }
    tU32  size__r_data() { return l_data_length(); }
    tU32  end__r_data() { return start__r_data() + size__r_data(); }
public:
    tVoid  set__r_data( tPU8 value )
    {
        if( value == AARSLIB_NULL )
        {
            set__l_data_length(0);
        }
        set_tPU8(end__l_bytes_after(),value,l_data_length());
    }
    tPU8 r_data( void )
    {
        return (tPU8)get_tPU8(end__l_bytes_after());
    }
}; /* ... class tR_STORAGE_GET_FRAME_SEGMENT */

/*!
*******************************************************************************
  @brief        <b>class tC_STORAGE_PUT_FRAME_SEGMENT</b>
*******************************************************************************
*/
class tC_STORAGE_PUT_FRAME_SEGMENT : public AaRSLib::MSG::tCommandMessage
{
private:
    /* static memory buffer ...
     */
    tU8 _msgbuf[2];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xEB16,C_STORAGE_PUT_FRAME_SEGMENT,"C_STORAGE_PUT_FRAME_SEGMENT",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        b_user_id__NO_USER = 0,
        b_user_id__USER_1 = 0,
        b_user_id__USER_2 = 0,
        b_user_id__USER_3 = 0,
        b_user_id__USER_4 = 0
    } t__b_user_id;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_user_id,b_user_id,tU8,0,1);

    typedef enum {
        b_device_id__PARAMETER_MEMORY = 0x01,
        b_device_id__WRITEONCE_MEMORY = 0x02,
        b_device_id__ERRORLOG_MEMORY = 0x03,
    } t__b_device_id;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_device_id,b_device_id,tU8,end__b_user_id(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU16,w_data_type,tU16,end__b_device_id(),2);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU16,w_data_length,tU16,end__w_data_type(),2);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU16,w_start_addr,tU16,end__w_data_length(),2);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU16,w_bytes_after,tU16,end__w_start_addr(),2);

private:
    tU32  start__r_data() { return end__w_bytes_after(); }
    tU32  size__r_data() { return w_data_length(); }
    tU32  end__r_data() { return start__r_data() + size__r_data(); }
public:
    tVoid  set__r_data( tPU8 value )
    {
        if( value == AARSLIB_NULL )
        {
            set__w_data_length(0);
        }
        set_tPU8(end__w_bytes_after(),value,w_data_length());
    }
    tPU8 r_data( void )
    {
        return (tPU8)get_tPU8(end__w_bytes_after());
    }

public:
    /* custom constructor ...
     */
    tC_STORAGE_PUT_FRAME_SEGMENT( t__b_user_id       b_user_id,
                          t__b_device_id     b_device_id,
                          tU16               w_data_type,
                          tU16               w_data_length,
                          tU16               w_start_addr,
                          tU16               w_bytes_after,
                          tPU8               r_data)
        : AaRSLib::MSG::tCommandMessage(OP_CODE, 0, AARSLIB_NULL)
    {
        tU32 o = 0;
        o = set_tU8(o,b_user_id);
        o = set_tU8(o,b_device_id);
        o = set_tU16(o,w_data_type);
        if( r_data == AARSLIB_NULL )
        {
            w_data_length = 0;
        }
        if( w_data_length == 0 )
        {
            r_data = AARSLIB_NULL;
        }
        o = set_tU16(o,w_data_length);
        o = set_tU16(o,w_start_addr);
        o = set_tU16(o,w_bytes_after);
        o = set_tPU8(o,(tPU8)r_data,w_data_length);
    }

}; /* ... class tC_STORAGE_PUT_FRAME_SEGMENT */

/*!
*******************************************************************************
  @brief        <b>class tR_STORAGE_PUT_FRAME_SEGMENT</b>
*******************************************************************************
*/
class tR_STORAGE_PUT_FRAME_SEGMENT : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[4];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xEB17,R_STORAGE_PUT_FRAME_SEGMENT,"R_STORAGE_PUT_FRAME_SEGMENT",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        b_user_id__NO_USER = 0,
        b_user_id__USER_1 = 0,
        b_user_id__USER_2 = 0,
        b_user_id__USER_3 = 0,
        b_user_id__USER_4 = 0
    } t__b_user_id;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_user_id,b_user_id,tU8,0,1);

    typedef enum {
        b_device_id__PARAMETER_MEMORY = 0x01,
        b_device_id__WRITEONCE_MEMORY = 0x02,
        b_device_id__ERRORLOG_MEMORY = 0x03,
    } t__b_device_id;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_device_id,b_device_id,tU8,end__b_user_id(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU16,w_data_type,tU16,end__b_device_id(),2);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_status,tU8,end__w_data_type(),1);

}; /* ... class tR_STORAGE_PUT_FRAME_SEGMENT */

/*!
*******************************************************************************
  @brief        <b>class tC_GET_VERSION_INFO</b>
*******************************************************************************
*/
class tC_GET_VERSION_INFO : public AaRSLib::MSG::tCommandMessage
{
private:
    /* static memory buffer ...
     */
    tU8 _msgbuf[2];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xEB04,C_GET_VERSION_INFO,"C_GET_VERSION_INFO",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */

public:
    /* custom constructor ...
     */

}; /* ... class tC_GET_VERSION_INFO */

/*!
*******************************************************************************
  @brief        <b>class tR_GET_VERSION_INFO</b>
*******************************************************************************
*/
class tR_GET_VERSION_INFO : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[4];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xEB05,R_GET_VERSION_INFO,"R_GET_VERSION_INFO",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    tPU8 b_product_name( void )
    {
        return (tPU8)get_tPU8(0);
    }

    tPU8 b_version_tag( void )
    {
        return (tPU8)get_tPU8(32);
    }

    tPU8 b_version_date( void )
    {
        return (tPU8)get_tPU8(64);
    }

    tPU8 b_rfu( void )
    {
        return (tPU8)get_tPU8(96);
    }
}; /* ... class tR_GET_VERSION_INFO */

/*!
*******************************************************************************
  @brief        <b>class tC_STORE</b>
*******************************************************************************
*/
class tC_STORE : public AaRSLib::MSG::tCommandMessage
{
private:
    /* static memory buffer ...
     */
    tU8 _msgbuf[2];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xEB00,C_STORE,"C_STORE",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        b_user_id__NO_USER = 0,
        b_user_id__USER_1 = 0,
        b_user_id__USER_2 = 0,
        b_user_id__USER_3 = 0,
        b_user_id__USER_4 = 0
    } t__b_user_id;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_user_id,b_user_id,tU8,0,1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_rfu,tU8,end__b_user_id(),1);

public:
    /* custom constructor ...
     */
    tC_STORE( t__b_user_id       b_user_id,
              tU8                b_rfu)
        : AaRSLib::MSG::tCommandMessage(OP_CODE, 0, AARSLIB_NULL)
    {
        tU32 o = 0;
        o = set_tU8(o,b_user_id);
        o = set_tU8(o,b_rfu);
    }

}; /* ... class tC_STORE */

/*!
*******************************************************************************
  @brief        <b>class tR_STORE</b>
*******************************************************************************
*/
class tR_STORE : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[4];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xEB01,R_STORE,"R_STORE",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        b_status__STORE_ERROR = 0,
        b_status__STORE_DONE = 1,
        b_status__STORE_IN_PROGGESS = 2
    } t__b_status;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_status,b_status,tU8,0,1);

    typedef enum {
        b_user_id__NO_USER = 0,
        b_user_id__USER_1 = 0,
        b_user_id__USER_2 = 0,
        b_user_id__USER_3 = 0,
        b_user_id__USER_4 = 0
    } t__b_user_id;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_user_id,b_user_id,tU8,end__b_status(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_rfu,tU8,end__b_user_id(),1);

}; /* ... class tR_STORE */

/*!
*******************************************************************************
  @brief        <b>class tC_RESTORE</b>
*******************************************************************************
*/
class tC_RESTORE : public AaRSLib::MSG::tCommandMessage
{
private:
    /* static memory buffer ...
     */
    tU8 _msgbuf[2];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xEB02,C_RESTORE,"C_RESTORE",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        b_user_id__NO_USER = 0,
        b_user_id__USER_1 = 0,
        b_user_id__USER_2 = 0,
        b_user_id__USER_3 = 0,
        b_user_id__USER_4 = 0
    } t__b_user_id;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_user_id,b_user_id,tU8,0,1);

    static const tU8 b_option__SKIPRESTOREWHENNOTFIRSTTIME_RESET = (1<<0);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_option,tU8,end__b_user_id(),1);

public:
    /* custom constructor ...
     */
    tC_RESTORE( t__b_user_id       b_user_id,
                tU8                b_option)
        : AaRSLib::MSG::tCommandMessage(OP_CODE, 0, AARSLIB_NULL)
    {
        tU32 o = 0;
        o = set_tU8(o,b_user_id);
        o = set_tU8(o,b_option);
    }

}; /* ... class tC_RESTORE */

/*!
*******************************************************************************
  @brief        <b>class tR_RESTORE</b>
*******************************************************************************
*/
class tR_RESTORE : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[4];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xEB03,R_RESTORE,"R_RESTORE",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        b_status__RESTORE_ERROR = 0,
        b_status__RESTORE_DONE = 1
    } t__b_status;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_status,b_status,tU8,0,1);

    typedef enum {
        b_user_id__NO_USER = 0,
        b_user_id__USER_1 = 0,
        b_user_id__USER_2 = 0,
        b_user_id__USER_3 = 0,
        b_user_id__USER_4 = 0
    } t__b_user_id;
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_user_id,b_user_id,tU8,end__b_status(),1);

    static const tU8 b_option__SKIPRESTOREWHENNOTFIRSTTIME_RESET = (1<<0);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU8,b_option,tU8,end__b_user_id(),1);

}; /* ... class tR_RESTORE */

} /* ... namespace AaRSDABLib::API::SYS */

namespace DDM
{

/*!
*******************************************************************************
  @brief        <b>class tC_RADIOTEXT_CURRENT</b>
*******************************************************************************
*/
class tC_RADIOTEXT_CURRENT : public AaRSLib::MSG::tCommandMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[12...];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE752,C_RADIOTEXT_CURRENT,"C_RADIOTEXT_CURRENT",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        w_cmd__STOP  = 0x0000,
        w_cmd__START = 0x0001
    } t__w_cmd;

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_cmd,w_cmd,tU16,0,2);

    static const tU8 b_cmd_mask__DEFAULT       = 2;
    static const tU8 b_start__DEFAULT          = 0;
    static const tU8 b_segment_length__DEFAULT = 128;

    typedef tU8 t__b_cmd_mask;
    typedef tU8 t__b_start;
    typedef tU8 t__b_segment_lengt;

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_cmd_mask,b_cmd_mask,tU8,end__w_cmd(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_start,b_start,tU8,end__b_cmd_mask(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_segment_lengt,b_segment_length,tU8,end__b_start(),1);

public:
    /* custom constructor ...
     */
    tC_RADIOTEXT_CURRENT( t__w_cmd           w_cmd,
    		              t__b_cmd_mask      b_cmd_mask,
    		              t__b_start         b_start,
    		              t__b_segment_lengt b_segment_lengt)
        : AaRSLib::MSG::tCommandMessage(OP_CODE, 0, AARSLIB_NULL)
    {
        tU32 o = 0;
        o = set_tU16(o,w_cmd);
        o = set_tU8(o,b_cmd_mask);
        o = set_tU8(o,b_start);
        o = set_tU8(o,b_segment_lengt);
    }

}; /* ... class tC_RADIOTEXT_CURRENT */

/*!
*******************************************************************************
  @brief        <b>class tR_RADIOTEXT_CURRENT</b>
*******************************************************************************
*/
class tR_RADIOTEXT_CURRENT : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[12...];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE753,R_RADIOTEXT_CURRENT,"R_RADIOTEXT_CURRENT",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        w_cmd__STOP  = 0x0000,
        w_cmd__START = 0x0001
    } t__w_cmd;

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_cmd,w_cmd,tU16,0,2);

    typedef enum {
        b_cmd__PARA_OK                     = 0x0000,
        b_cmd__PARA_DATA_ALREADY_SELECTED  = 0x0011,
        b_cmd__PARA_DATA_NOT_SELECTED      = 0x0012
    } t__w_response;

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_response,w_response,tU16,end__w_cmd(),2);

    static const tU8 b_cmd_mask__DEFAULT       = 2;
    static const tU8 b_start__DEFAULT          = 0;
    static const tU8 b_segment_length__DEFAULT = 128;

    typedef tU8 t__b_cmd_mask;
    typedef tU8 t__b_status_mask;
    typedef tU8 t__b_start;
    typedef tU8 t__b_lengt;
    typedef tU8 t__b_segment_lengt;
    typedef tU8 t__b_charset;

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_cmd_mask,b_cmd_mask,tU8,end__w_response(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_status_mask,b_status_mask,tU8,end__b_cmd_mask(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_start,b_start,tU8,end__b_status_mask(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_lengt,b_length,tU8,end__b_start(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_segment_lengt,b_segment_length,tU8,end__b_length(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_charset,b_charset,tU8,end__b_segment_length(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tPU8,r_radiotext_segment,tPU8,end__b_charset(),b_segment_length());
}; /* ... class tR_RADIOTEXT_CURRENT */


/*!
*******************************************************************************
  @brief        <b>class tR_RADIOTEXT_CURRENT_COMMAND</b>
*******************************************************************************
*/
class tR_RADIOTEXT_CURRENT_COMMAND : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[12...];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE755,R_RADIOTEXT_CURRENT_COMMAND,"R_RADIOTEXT_CURRENT_COMMAND",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        w_dl_cmd_rfu     = 0x0000,
        w_dl_cmd_remove  = 0x0001,
        w_dl_cmd_dl_plus = 0x0002
    } t__w_dl_command;

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_dl_command,w_dl_command,tU16,0,2);

    typedef tU8  t__b_rfu;

    typedef enum {
        b_service_type_prog = 0x01,
        b_service_type_data = 0x02
    } t__b_service_type;

    typedef tU32 t__w_service_id;
    typedef tU16 t__w_scidi;
    typedef tU16 t__w_length;
    typedef tPU8 t__r_cmd;

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_rfu,b_rfu,tU8,end__w_dl_command(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_service_type,b_service_type,tU8,end__b_rfu(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_service_id,w_service_id,tU32,end__b_service_type(),4);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_scidi,w_scidi,tU16,end__w_service_id(),2);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_length,w_length,tU16,end__w_scidi(),2);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__r_cmd,r_cmd,tPU8,end__w_length(),w_length());
}; /* ... class tR_RADIOTEXT_CURRENT */

/*!
*******************************************************************************
  @brief        <b>class tC_SELECT_URI</b>
*******************************************************************************
*/
class tC_SELECT_URI : public AaRSLib::MSG::tCommandMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[12...];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xe7e0,C_SELECT_URI,"C_SELECT_URI",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        w_cmd__STOP      = 0x0000,
        w_cmd__START     = 0x0001,
        w_cmd__STOP_ALL  = 0x00ff
    } t__w_cmd;

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_cmd,w_cmd,tU16,0,2);

    typedef tU8  t__b_on;
    typedef tU8  t__b_pause;
    typedef tU8  t__b_priority;

    typedef enum {
        b_decode_level_packet = 0x00,
        b_decode_level_dg     = 0x01,
        b_decode_level_tdc    = 0x02,
        b_decode_level_auto   = 0x42
    } t__b_decode_level;

    typedef tU16 t__w_ua_type;
    typedef tU16 t__w_scidi;
    typedef tU16 t__w_uri_len;
    typedef tPChar t__r_uri;
    typedef tU16 t__w_rfu_len;
    typedef tPChar t__r_rfu;

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_on,b_on,tU8,end__w_cmd(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_pause,b_pause,tU8,end__b_on(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_priority,b_priority,tU8,end__b_pause(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_decode_level,b_decode_level,tU8,end__b_priority(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_ua_type,w_ua_type,tU16,end__b_decode_level(),2);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_scidi,w_scidi,tU16,end__w_ua_type(),2);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_uri_len,w_uri_len,tU16,end__w_scidi(),2);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__r_uri,r_uri,tPChar,end__w_uri_len(),w_uri_len());
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_rfu_len,w_rfu_len,tU16,end__r_uri(),2);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__r_rfu,r_rfu,tPChar,end__w_rfu_len(),w_rfu_len());

public:
    /* custom constructor ...
     */
    tC_SELECT_URI( t__w_cmd          w_cmd,
                   t__b_on           b_on,
                   t__b_pause        b_pause,
                   t__b_priority     b_priority,
                   t__b_decode_level b_decode_level,
                   t__w_ua_type      w_ua_type,
                   t__w_scidi        w_scidi,
                   t__w_uri_len      w_uri_len,
                   t__r_uri          r_uri,
                   t__w_rfu_len      w_rfu_len,
                   t__r_rfu          r_rfu)
        : AaRSLib::MSG::tCommandMessage(OP_CODE, 0, AARSLIB_NULL)
    {
        tU32 o = 0;
        o = set_tU16(o,w_cmd);
        o = set_tU8(o,b_on);
        o = set_tU8(o,b_pause);
        o = set_tU8(o,b_priority);
        o = set_tU8(o,b_decode_level);
        o = set_tU16(o,w_ua_type);
        o = set_tU16(o,w_scidi);
        o = set_tU16(o,w_uri_len);
        o = set_tPChar(o,r_uri,w_uri_len);
        o = set_tU16(o,w_rfu_len);
        o = set_tPChar(o,r_rfu,w_rfu_len);
    }

}; /* ... class tC_SELECT_URI */

/*!
*******************************************************************************
  @brief        <b>class tR_SELECT_URI</b>
*******************************************************************************
*/
class tR_SELECT_URI : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[12...];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xe7e1,R_SELECT_URI,"R_SELECT_URI",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        w_cmd__STOP     = 0x0000,
        w_cmd__START    = 0x0001,
        w_cmd__STOP_ALL = 0x00ff
    } t__w_cmd;

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_cmd,w_cmd,tU16,0,2);

    typedef enum {
        w_response__PARA_OK                      = 0x0000,
        w_response__COMMAND_NOT_VALID            = 0x0001,
        w_response__NO_RESOURCES                 = 0x0004,
        w_response__URI_NOT_VALID                = 0x0005,
        w_response__DATA_ALREADY_SELECTED        = 0x0011,
        w_response__DATA_NOT_SELECTED            = 0x0012,
        w_response__URI_PROCESSING_IN_PROGRESS   = 0x0020,
        w_response__URI_ACTIVATED                = 0x0021,
        w_response__URI_ACTIVATE_FAIL_SCHED      = 0x0022,
        w_response__URI_ACTIVATE_FAIL_RECEPT     = 0x0023,
        w_response__URI_DEACTIVATED_BY_SCHED     = 0x0024,
        w_response__URI_DEACTIVATED_BY_SYNC_LOSS = 0x0025,
        w_response__URI_ACTIVATE_FAIL_NO_SCIDI   = 0x0026,
        w_response__URI_ACTIVATE_FAIL_TDC_ENABLE = 0x0027,
        w_response__URI_ACTIVATE_FAIL_NO_DB_INFO = 0x0028,
        w_response__OTHER_ERROR                  = 0xffff
    } t__w_response;

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_response,w_response,tU16,end__w_cmd(),2);

    typedef tU8  t__b_on;
    typedef tU8  t__b_pause;
    typedef tU8  t__b_priority;
    typedef enum {
        b_decode_level_packet = 0x00,
        b_decode_level_dg     = 0x01,
        b_decode_level_tdc    = 0x02,
        b_decode_level_auto   = 0x42
    } t__b_decode_level;
    typedef tU16 t__w_ua_type;
    typedef tU16 t__w_scidi;
    typedef tU16 t__w_uri_len;
    typedef tPChar t__r_uri;
    typedef tU16 t__w_rfu_len;
    typedef tPChar t__r_rfu;

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_on,b_on,tU8,end__w_response(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_pause,b_pause,tU8,end__b_on(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_priority,b_priority,tU8,end__b_pause(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_decode_level,b_decode_level,tU8,end__b_priority(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_ua_type,w_ua_type,tU16,end__b_decode_level(),2);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_scidi,w_scidi,tU16,end__w_ua_type(),2);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_uri_len,w_uri_len,tU16,end__w_scidi(),2);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__r_uri,r_uri,tPChar,end__w_uri_len(),w_uri_len());
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_rfu_len,w_rfu_len,tU16,end__r_uri(),2);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__r_rfu,r_rfu,tPChar,end__w_rfu_len(),w_rfu_len());

    tR_SELECT_URI( t__w_cmd          w_cmd,
                   t__w_response     w_response,
                   t__b_on           b_on,
                   t__b_pause        b_pause,
                   t__b_priority     b_priority,
                   t__b_decode_level b_decode_level,
                   t__w_ua_type      w_ua_type,
                   t__w_scidi        w_scidi,
                   t__w_uri_len      w_uri_len,
                   t__r_uri          r_uri,
                   t__w_rfu_len      w_rfu_len,
                   t__r_rfu          r_rfu)
        : AaRSLib::MSG::tResponseMessage(OP_CODE, 0, AARSLIB_NULL)
    {
        tU32 o = 0;
        o = set_tU16(o,w_cmd);
        o = set_tU16(o,w_response);
        o = set_tU8(o,b_on);
        o = set_tU8(o,b_pause);
        o = set_tU8(o,b_priority);
        o = set_tU8(o,b_decode_level);
        o = set_tU16(o,w_ua_type);
        o = set_tU16(o,w_scidi);
        o = set_tU16(o,w_uri_len);
        o = set_tPChar(o,r_uri,w_uri_len);
        o = set_tU16(o,w_rfu_len);
        o = set_tPChar(o,r_rfu,w_rfu_len);
    }
}; /* ... class tR_SELECT_URI */

/*!
*******************************************************************************
  @brief        <b>class tR_TIMESTAMP</b>
*******************************************************************************
*/
class tR_TIMESTAMP : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[12...];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xe7e3,R_TIMESTAMP,"R_TIMESTAMP",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU16,w_scidi,tU16,0,2);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU32,d_internal_timestamp,tU32,end__w_scidi(),4);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU32,d_utc_comp_time,tU32,end__d_internal_timestamp(),4);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU32,d_mjd_comp_time,tU32,end__d_utc_comp_time(),4);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU32,d_utc_comp_time_uncorrected,tU32,end__d_mjd_comp_time(),4);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(tU32,d_mjd_comp_time_uncorrected,tU32,end__d_utc_comp_time_uncorrected(),4);
}; /* ... class tR_TIMESTAMP */

/*!
*******************************************************************************
  @brief        <b>class tC_DATAGROUP</b>
*******************************************************************************
*/
class tC_DATAGROUP : public AaRSLib::MSG::tCommandMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[12...];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE700,C_DATAGROUP,"C_DATAGROUP",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        w_cmd__STOP  = 0x0000,
        w_cmd__START = 0x0001
    } t__w_cmd;

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_cmd,w_cmd,tU16,0,2);

    static const tU16 w_datagroup_mask__DEFAULT   = 0xffff;
    static const tU16 w_eua_field_length__DEFAULT = 0;

    typedef tU16   t__w_scidi;
    typedef tU16   t__w_datagroup_mask;
    typedef tU16   t__w_eua_field_length;
    typedef tPChar t__r_eua_field;

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_scidi,w_scidi,tU16,end__w_cmd(),2);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_datagroup_mask,w_datagroup_mask,tU16,end__w_scidi(),2);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_eua_field_length,w_eua_field_length,tU16,end__w_datagroup_mask(),2);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__r_eua_field,r_eua_field,tPChar,end__w_eua_field_length(),w_eua_field_length());

public:
    /* custom constructor ...
     */
    tC_DATAGROUP( t__w_cmd              w_cmd,
    		      t__w_scidi            w_scidi,
    		      t__w_datagroup_mask   w_datagroup_mask,
    		      t__w_eua_field_length w_eua_field_length,
    		      t__r_eua_field        r_eua_field)
        : AaRSLib::MSG::tCommandMessage(OP_CODE, 0, AARSLIB_NULL)
    {
        tU32 o = 0;
        o = set_tU16(o,w_cmd);
        o = set_tU16(o,w_scidi);
        o = set_tU16(o,w_datagroup_mask);
        o = set_tU16(o,w_eua_field_length);
        o = set_tPChar(o,r_eua_field,w_eua_field_length);
    }

}; /* ... class tC_DATAGROUP */

/*!
*******************************************************************************
  @brief        <b>class tR_DATAGROUP</b>
*******************************************************************************
*/
class tR_DATAGROUP : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[12...];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE701,R_DATAGROUP,"R_DATAGROUP",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        w_cmd__STOP  = 0x0000,
        w_cmd__START = 0x0001
    } t__w_cmd;

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_cmd,w_cmd,tU16,0,2);

    typedef enum {
        b_cmd__PARA_OK                     = 0x0000,
        b_cmd__PARA_DATA_ALREADY_SELECTED  = 0x0011,
        b_cmd__PARA_DATA_NOT_SELECTED      = 0x0012
    } t__w_response;

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_response,w_response,tU16,end__w_cmd(),2);

    static const tU16 w_datagroup_mask__DEFAULT   = 0xffff;
    static const tU16 w_eua_field_length__DEFAULT = 0;

    typedef tU16   t__w_scidi;
    typedef tU16   t__w_datagroup_mask;
    typedef tU16   t__w_eua_field_length;
    typedef tPChar t__r_eua_field;

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_scidi,w_scidi,tU16,end__w_response(),2);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_datagroup_mask,w_datagroup_mask,tU16,end__w_scidi(),2);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_eua_field_length,w_eua_field_length,tU16,end__w_datagroup_mask(),2);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__r_eua_field,r_eua_field,tPChar,end__w_eua_field_length(),w_eua_field_length());
}; /* ... class tR_DATAGROUP */

/*!
*******************************************************************************
  @brief        <b>class tC_PAD_DATAGROUP</b>
*******************************************************************************
*/
class tC_PAD_DATAGROUP : public AaRSLib::MSG::tCommandMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[12...];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE724,C_PAD_DATAGROUP,"C_PAD_DATAGROUP",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        w_cmd__STOP  = 0x0000,
        w_cmd__START = 0x0001
    } t__w_cmd;

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_cmd,w_cmd,tU16,0,2);

    static const tU16 w_datagroup_mask__DEFAULT   = 0xffff;
    static const tU16 w_eua_field_length__DEFAULT = 0;

    typedef tU16   t__w_scidi;
    typedef tU16   t__w_xpad_app_type;
    typedef tU16   t__w_datagroup_mask;
    typedef tU16   t__w_eua_field_length;
    typedef tPChar t__r_eua_field;
    typedef tU16   t__w_rfu;

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_scidi,w_scidi,tU16,end__w_cmd(),2);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_xpad_app_type,w_xpad_app_type,tU16,end__w_scidi(),2);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_datagroup_mask,w_datagroup_mask,tU16,end__w_xpad_app_type(),2);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_eua_field_length,w_eua_field_length,tU16,end__w_datagroup_mask(),2);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__r_eua_field,r_eua_field,tPChar,end__w_eua_field_length(),w_eua_field_length());
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_rfu,w_rfu,tU16,end__r_eua_field(),2);

public:
    /* custom constructor ...
     */
    tC_PAD_DATAGROUP( t__w_cmd              w_cmd,
    		          t__w_scidi            w_scidi,
    		          t__w_xpad_app_type    w_xpad_app_type,
    		          t__w_datagroup_mask   w_datagroup_mask,
    		          t__w_eua_field_length w_eua_field_length,
    		          t__r_eua_field        r_eua_field,
    		          t__w_rfu              w_rfu)
        : AaRSLib::MSG::tCommandMessage(OP_CODE, 0, AARSLIB_NULL)
    {
        tU32 o = 0;
        o = set_tU16(o,w_cmd);
        o = set_tU16(o,w_scidi);
        o = set_tU16(o,w_xpad_app_type);
        o = set_tU16(o,w_datagroup_mask);
        o = set_tU16(o,w_eua_field_length);
        o = set_tPChar(o,r_eua_field,w_eua_field_length);
        o = set_tU16(o,w_rfu);
    }

}; /* ... class tC_PAD_DATAGROUP */

/*!
*******************************************************************************
  @brief        <b>class tR_DATAGROUP</b>
*******************************************************************************
*/
class tR_PAD_DATAGROUP : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[12...];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE725,R_PAD_DATAGROUP,"R_PAD_DATAGROUP",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        w_cmd__STOP  = 0x0000,
        w_cmd__START = 0x0001
    } t__w_cmd;

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_cmd,w_cmd,tU16,0,2);

    typedef enum {
        b_cmd__PARA_OK                     = 0x0000,
        b_cmd__PARA_DATA_ALREADY_SELECTED  = 0x0011,
        b_cmd__PARA_DATA_NOT_SELECTED      = 0x0012
    } t__w_response;

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_response,w_response,tU16,end__w_cmd(),2);

    static const tU16 w_datagroup_mask__DEFAULT   = 0xffff;
    static const tU16 w_eua_field_length__DEFAULT = 0;

    typedef tU16   t__w_scidi;
    typedef tU16   t__w_xpad_app_type;
    typedef tU16   t__w_datagroup_mask;
    typedef tU16   t__w_eua_field_length;
    typedef tPChar t__r_eua_field;
    typedef tU16   t__w_rfu;

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_scidi,w_scidi,tU16,end__w_response(),2);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_xpad_app_type,w_xpad_app_type,tU16,end__w_scidi(),2);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_datagroup_mask,w_datagroup_mask,tU16,end__w_xpad_app_type(),2);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_eua_field_length,w_eua_field_length,tU16,end__w_datagroup_mask(),2);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__r_eua_field,r_eua_field,tPChar,end__w_eua_field_length(),w_eua_field_length());
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_rfu,w_rfu,tU16,end__r_eua_field(),2);
}; /* ... class tR_DATAGROUP */

} /* ... namespace AaRSDABLib::API::DDM */

namespace ANS
{

/*!
*******************************************************************************
  @brief        <b>class tC_CONFIG_ANNO</b>
*******************************************************************************
*/
class tC_CONFIG_ANNO : public AaRSLib::MSG::tCommandMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[12...];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE50A,C_CONFIG_ANNO,"C_CONFIG_ANNO",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        b_command__SET = 0x01,
        b_command__GET = 0xff
    } t__b_command;

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_command,b_command,tU8,0,1);

    typedef tU8  t__b_rfu;
    typedef tU16 t__w_anno_type_mask;
    typedef tU16 t__w_anno_filter_mask;
    typedef tU16 t__w_rfu;

    static const tU16 b_rfu__DEFAULT           = 0x00;
    static const tU16 w_type_mask__DEFAULT_ON  = 0xffff;
    static const tU16 w_type_mask__DEFAULT_OFF = 0x0000;
    static const tU16 w_filter_mask__DEFAULT   = 0x0000;
    static const tU16 w_rfu__DEFAULT           = 0x0000;

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_rfu,b_rfu,tU8,end__b_command(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_anno_type_mask,w_anno_type_mask,tU16,end__b_rfu(),2);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_anno_filter_mask,w_anno_filter_mask,tU16,end__w_anno_type_mask(),2);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_rfu,w_rfu,tU16,end__w_anno_filter_mask(),2);

public:
    /* custom constructor ...
     */
    tC_CONFIG_ANNO ( t__b_command          b_command,
                     t__b_rfu              b_rfu,
                     t__w_anno_type_mask   w_anno_type_mask,
                     t__w_anno_filter_mask w_anno_filter_mask,
                     t__w_rfu              w_rfu)
        : AaRSLib::MSG::tCommandMessage(OP_CODE, 0, AARSLIB_NULL)
    {
        tU32 o = 0;
        o = set_tU8  (o,b_command);
        o = set_tU8  (o,b_rfu);
        o = set_tU16 (o,w_anno_type_mask);
        o = set_tU16 (o,w_anno_filter_mask);
        o = set_tU16 (o,w_rfu);
    }

}; /* ... class tC_CONFIG_ANNO*/

/*!
*******************************************************************************
  @brief        <b>class tR_CONFIG_ANNO</b>
*******************************************************************************
*/
class tR_CONFIG_ANNO : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[12...];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE50b,R_CONFIG_ANNO ,"R_CONFIG_ANNO",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    typedef tU16 t__w_anno_type_mask;
    typedef tU16 t__w_anno_filter_mask;
    typedef tU16 t__w_rfu;

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_anno_type_mask,w_anno_type_mask,tU16,0,2);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_anno_filter_mask,w_anno_filter_mask,tU16,end__w_anno_type_mask(),2);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_rfu,w_rfu,tU16,end__w_anno_filter_mask(),2);

}; /* ... class tR_CONFIG_ANNO*/


/*!
*******************************************************************************
  @brief        <b>class tC_SELECT_ANNO</b>
*******************************************************************************
*/
class tC_SELECT_ANNO : public AaRSLib::MSG::tCommandMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[12...];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE504,C_SELECT_ANNO,"C_SELECT_ANNO",AaRSLib::MSG::tCommandMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        b_deselect = 0x00,
        b_select   = 0x01
    } t__b_anno_select;

    typedef enum {
        b_CE = 0x00,
        b_OE = 0x01,
        b_FM = 0x02
    } t__b_source_info;

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_anno_select,b_anno_select,tU8,0,1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_source_info,b_source_info,tU8,end__b_anno_select(),1);

    typedef tU16 t__w_anno_type_mask;
    typedef tU8  t__b_anno_flags;
    typedef tU8  t__b_anno_cluster_id;
    typedef tU8  t__b_anno_sub_region_id;

    /*up to now only CE (e.g. current ensemble) is supported*/
    typedef tU8  t__b_subchid;
    typedef tU32 t__w_rfu;
    typedef tU8  t__b_rfu1;
    typedef tU8  t__b_rfu2;

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_anno_type_mask,w_anno_type_mask,tU16,end__b_source_info(),2);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_anno_flags,b_anno_flags,tU8,end__w_anno_type_mask(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_anno_cluster_id,b_anno_cluster_id,tU8,end__b_anno_flags(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_anno_sub_region_id,b_anno_sub_region_id,tU8,end__b_anno_cluster_id(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_subchid,b_subchid,tU8,end__b_anno_sub_region_id(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_rfu,w_rfu,tU8,end__b_subchid(),4);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_rfu1,b_rfu1,tU8,end__w_rfu(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_rfu2,b_rfu2,tU8,end__b_rfu1(),1);


public:
    /* custom constructor ...
     */
    tC_SELECT_ANNO ( t__b_anno_select        b_anno_select,
                     t__b_source_info        b_source_info,
                     t__w_anno_type_mask     w_anno_type_mask,
                     t__b_anno_flags         b_anno_flags,
                     t__b_anno_cluster_id    b_anno_cluster_id,
                     t__b_anno_sub_region_id b_anno_sub_region_id,
                     t__b_subchid            b_subchid,
                     t__w_rfu                w_rfu,
                     t__b_rfu1               b_rfu1,
                     t__b_rfu2               b_rfu2)
        : AaRSLib::MSG::tCommandMessage(OP_CODE, 0, AARSLIB_NULL)
    {
        tU32 o = 0;
        o = set_tU8  (o,b_anno_select);
        o = set_tU8  (o,b_source_info);
        o = set_tU16 (o,w_anno_type_mask);
        o = set_tU8  (o,b_anno_flags);
        o = set_tU8  (o,b_anno_cluster_id);
        o = set_tU8  (o,b_anno_sub_region_id);

        /*up to now only CE (e.g. current ensemble) is supported*/
        o = set_tU8  (o,b_subchid);
        o = set_tU32 (o,w_rfu);
        o = set_tU8  (o,b_rfu1);
        o = set_tU8  (o,b_rfu2);
    }

}; /* ... class tC_CONFIG_ANNO*/

/*!
*******************************************************************************
  @brief        <b>class tR_SELECT_ANNO</b>
*******************************************************************************
*/
class tR_SELECT_ANNO : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[12...];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE505,R_SELECT_ANNO ,"R_SELECT_ANNO",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        b_deselected    = 0x00,
        b_selected      = 0x01,
        b_no_active     = 0xe1,
        b_no_permission = 0xe2,
        b_select_error  = 0xef
    } t__b_anno_selected;

    typedef enum {
        b_CE = 0x00,
        b_OE = 0x01,
        b_FM = 0x02
    } t__b_source_info;

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_anno_selected,b_anno_selected,tU8,0,1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_source_info,b_source_info,tU8,end__b_anno_selected(),1);

    typedef tU16 t__w_anno_mask;
    typedef tU8  t__b_anno_flags;
    typedef tU8  t__b_anno_cluster_id;
    typedef tU8  t__b_anno_sub_region_id;

    /*up to now only CE (e.g. current ensemble) is supported*/
    typedef tU8  t__b_subchid;
    typedef tU32 t__w_rfu;
    typedef tU8  t__b_rfu1;
    typedef tU8  t__b_rfu2;

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_anno_mask,w_anno_mask,tU16,end__b_source_info(),2);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_anno_flags,b_anno_flags,tU8,end__w_anno_mask(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_anno_cluster_id,b_anno_cluster_id,tU8,end__b_anno_flags(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_anno_sub_region_id,b_anno_sub_region_id,tU8,end__b_anno_cluster_id(),1);

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_subchid,b_subchid,tU8,end__b_anno_sub_region_id(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_rfu,w_rfu,tU8,end__b_subchid(),4);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_rfu1,b_rfu1,tU8,end__w_rfu(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_rfu2,b_rfu2,tU8,end__b_rfu1(),1);

}; /* ... class tR_CONFIG_ANNO*/

/*!
*******************************************************************************
  @brief        <b>class tR_ANNO_ACTIVE_STATUS</b>
*******************************************************************************
*/
class tR_ANNO_ACTIVE_STATUS : public AaRSLib::MSG::tResponseMessage
{
private:
    /* static memory buffer ...
     */
    //tU8 _msgbuf[12...];

public:
    /* OP_CODE, methodname and default constructor ...
     */
    MACRO_AARSLIB_DEFINE_METHOD(0xE503,R_ANNO_ACTIVE_STATUS ,"R_ANNO_ACTIVE_STATUS",AaRSLib::MSG::tResponseMessage);

public:
    /* set/get functions ...
     */
    typedef enum {
        b_anno_start    = 0x01,
        b_anno_end      = 0x02,
        b_anno_escaped  = 0x03,
        b_anno_switched = 0x04
    } t__b_active_status;

    typedef enum {
        b_CE = 0x00,
        b_OE = 0x01,
        b_FM = 0x02
    } t__b_source_info;

    typedef enum
    {
      ANNO_TYPE_NONE         = 0x0000,
      ANNO_TYPE_ALARM        = 0x0001,
      ANNO_TYPE_ROAD_TRAFFIC = 0x0002,
      ANNO_TYPE_TRANSPORT    = 0x0004,
      ANNO_TYPE_WARNING      = 0x0008,
      ANNO_TYPE_NEWS         = 0x0010,
      ANNO_TYPE_WEATHER      = 0x0020,
      ANNO_TYPE_EVENT        = 0x0040,
      ANNO_TYPE_SPECIALEVENT = 0x0080,
      ANNO_TYPE_PROG_INFO    = 0x0100,
      ANNO_TYPE_SPORT        = 0x0200,
      ANNO_TYPE_FINANCIAL    = 0x0400,
      ANNO_TYPE_12           = 0x0800,
      ANNO_TYPE_13           = 0x1000,
      ANNO_TYPE_14           = 0x2000,
      ANNO_TYPE_15           = 0x4000,
      ANNO_TYPE_16           = 0x8000
    } t__w_anno_type;

    typedef tU16 t__w_mask;
    typedef tU8  t__b_flags;
    typedef tU8  t__b_cluster_id;
    typedef tU8  t__b_sub_region_id;

    /*in case of source_info == CE*/
    typedef tU8  t__CE_b_subchid;
    typedef tU32 t__CE_w_rfu;
    typedef tU8  t__CE_b_rfu1;
    typedef tU8  t__CE_b_rfu2;

    /*in case of source_info == OE*/
    typedef tU8  t__OE_b_rfu1;
    typedef tU16 t__OE_w_rfu;
    typedef tU16 t__OE_w_eid;
    typedef tU8  t__OE_b_cluster_id;
    typedef tU8  t__OE_b_sub_region_id;

    /*in case of source_info == FM*/
    typedef tU8  t__FM_b_rfu1;
    typedef tU16 t__FM_w_pi_code;
    typedef tU16 t__FM_w_rfu;
    typedef tU8  t__FM_b_rfu2;
    typedef tU8  t__FM_b_rfu3;

    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_active_status,b_active_status,tU8,0,1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_source_info,b_source_info,tU8,end__b_active_status(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__w_mask,w_mask,tU16,end__b_source_info(),2);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_flags,b_flags,tU8,end__w_mask(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_cluster_id,b_cluster_id,tU8,end__b_flags(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__b_sub_region_id,b_sub_region_id,tU8,end__b_cluster_id(),1);

    /*in case of source_info == CE*/
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__CE_b_subchid,CE_b_subchid,tU8,end__b_sub_region_id(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__CE_w_rfu,CE_w_rfu,tU16,end__CE_b_subchid(),2);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__CE_b_rfu1,CE_b_rfu1,tU8,end__CE_w_rfu(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__CE_b_rfu2,CE_b_rfu2,tU8,end__CE_b_rfu1(),1);

    /*in case of source_info == OE*/
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__OE_b_rfu1,OE_b_rfu1,tU8,end__b_sub_region_id(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__OE_w_rfu,OE_w_rfu,tU16,end__OE_b_rfu1(),2);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__OE_w_eid,OE_w_eid,tU16,end__OE_w_rfu(),2);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__OE_b_cluster_id,OE_b_cluster_id,tU8,end__OE_w_eid(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__OE_b_sub_region_id,OE_b_sub_region_id,tU8,end__OE_b_cluster_id(),1);

    /*in case of source_info == FM*/
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__FM_b_rfu1,FM_b_rfu1,tU8,end__b_sub_region_id(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__FM_w_pi_code,FM_w_pi_code,tU16,end__FM_b_rfu1(),2);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__FM_w_rfu,FM_w_rfu,tU16,end__FM_w_pi_code(),2);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__FM_b_rfu2,FM_b_rfu2,tU8,end__FM_w_rfu(),1);
    MACRO_AARSLIB_SIMPLE_COMMAND_SETGET(t__FM_b_rfu3,FM_b_rfu3,tU8,end__FM_b_rfu2(),1);

}; /* ... class tR_ANNO_ACTIVE_STATUS*/

} /* ... namespace AaRSDABLib::API::ANS */

} /* ... namespace AaRSDABLib::API */

/*!
*******************************************************************************
  @brief        <b>class tMsgFactory</b>
*******************************************************************************
*/
class tMsgDispatcher
{
public:
    /*!
    ***************************************************************************
      @brief        <b>function fromByteArray</b>
    ***************************************************************************
    */
    static AaRSLib::MSG::tMessage* fromByteArray( tU16 msgopcode, tU32 msglen, tU8* msgbody, tBool freemsgbodyflag = false )
    {
        switch(msgopcode)
        {
#define MACRO_AARSDABLIB_API_MSG_CREATOR(_api_,_msg_) case AaRSDABLib::API::_api_::_msg_::OP_CODE: return new AaRSDABLib::API::_api_::_msg_(msglen, msgbody, freemsgbodyflag)

        /*
         * DC
         */
        MACRO_AARSDABLIB_API_MSG_CREATOR(DC,tR_DATACHANNEL_FRAME);
        /*
         * RDM
         */
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tC_SET_AUTO_NOTIFICATION);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tR_SET_AUTO_NOTIFICATION);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tC_TUNE);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tR_TUNE);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tC_TUNE_FREQUENCY);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tR_TUNE_FREQUENCY);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tC_TUNE_FREQUENCY_LABEL);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tR_TUNE_FREQUENCY_LABEL);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tC_PLAY_PSID);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tR_PLAY_PSID);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tC_QUALITY_CONFIG);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tR_QUALITY_CONFIG);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tC_LEARN);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tR_LEARN);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tC_SCAN);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tR_SCAN);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tC_SERV_FOLLOW_SET_MODE);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tR_SERV_FOLLOW_SET_MODE);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tC_SERV_FOLLOW_SET_ONESHOT_MODE);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tR_SERV_FOLLOW_SET_ONESHOT_MODE);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tR_SERV_FOLLOW_ACTIVE);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tC_SET_MODE);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tR_SET_MODE);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tC_SEQUENCE);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tR_SEQUENCE);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tC_GET_FREQUENCY);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tR_GET_FREQUENCY);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tC_GET_FREQUENCY_LABEL);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tR_GET_FREQUENCY_LABEL);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tC_STATION_PLAY);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tR_STATION_PLAY);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tC_STATION_STORE);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tR_STATION_STORE);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tC_STATION_SET_USER);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tR_STATION_SET_USER);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tC_STATION_AUTO_COMPARE);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tR_STATION_AUTO_COMPARE);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tC_STATION_GET_PRESET_STATION);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tR_STATION_GET_PRESET_STATION);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tC_GET_RDM_STATUS);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tR_GET_RDM_STATUS);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tC_GET_RDM_INFO);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tR_GET_RDM_INFO);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tC_GET_SIGNAL_QUALITY);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tR_GET_SIGNAL_QUALITY);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tR_GET_DAB_DECODER_STATUS);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tC_AUDIO_GET_PSID);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tR_AUDIO_GET_PSID);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tC_AUDIO_GET_SCIDI);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tR_AUDIO_GET_SCIDI);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tC_GET_DAB_AUDIO_QUALITY);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tR_GET_DAB_AUDIO_QUALITY);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tC_AUDIO_PLAY_SERVICE);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tR_AUDIO_PLAY_SERVICE);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tC_SET_DAB_FREQUENCY_TABLE);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tR_SET_DAB_FREQUENCY_TABLE);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tC_AUDIO_COMPONENT_PLAY);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tR_AUDIO_COMPONENT_PLAY);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tC_AUDIO_PLAY_COMPONENT);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tR_AUDIO_PLAY_COMPONENT);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tC_EXTJOB_CONFIGURE);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tR_EXTJOB_CONFIGURE);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tC_EXTJOB_TUNE);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tR_EXTJOB_TUNE);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tC_EXTJOB_SELECT_AUDIO);
        MACRO_AARSDABLIB_API_MSG_CREATOR(RDM,tR_EXTJOB_SELECT_AUDIO);
        /*
         * DB
         */
        MACRO_AARSDABLIB_API_MSG_CREATOR(DB,tC_CONFIG);
        MACRO_AARSDABLIB_API_MSG_CREATOR(DB,tR_CONFIG);
        MACRO_AARSDABLIB_API_MSG_CREATOR(DB,tC_QUERY);
        MACRO_AARSDABLIB_API_MSG_CREATOR(DB,tR_QUERY);
        MACRO_AARSDABLIB_API_MSG_CREATOR(DB,tC_QUERY_TRIGGER);
        MACRO_AARSDABLIB_API_MSG_CREATOR(DB,tR_QUERY_TRIGGER);
        MACRO_AARSDABLIB_API_MSG_CREATOR(DB,tC_SET_AUTO_NOTIFICATION);
        MACRO_AARSDABLIB_API_MSG_CREATOR(DB,tR_SET_AUTO_NOTIFICATION);
        /*
         * EXP
         */
        MACRO_AARSDABLIB_API_MSG_CREATOR(EXP,tC_SELECT);
        MACRO_AARSDABLIB_API_MSG_CREATOR(EXP,tR_SELECT);
        MACRO_AARSDABLIB_API_MSG_CREATOR(EXP,tR_ID_VALUE_UINT32);
        MACRO_AARSDABLIB_API_MSG_CREATOR(EXP,tR_ID_DESCRIPTION);
        MACRO_AARSDABLIB_API_MSG_CREATOR(EXP,tR_ID_VALUE_LABEL);
        MACRO_AARSDABLIB_API_MSG_CREATOR(EXP,tR_ID_VALUE_BYTEARRAY);
        /*
         * AUD
         */
        MACRO_AARSDABLIB_API_MSG_CREATOR(AUD,tC_SET_CONCEALMENT_LEVEL);
        MACRO_AARSDABLIB_API_MSG_CREATOR(AUD,tR_SET_CONCEALMENT_LEVEL);
        /*
         * SYS
         */       
        MACRO_AARSDABLIB_API_MSG_CREATOR(SYS,tC_GET_VERSION_INFO);
        MACRO_AARSDABLIB_API_MSG_CREATOR(SYS,tR_GET_VERSION_INFO);
        MACRO_AARSDABLIB_API_MSG_CREATOR(SYS,tC_STORE);
        MACRO_AARSDABLIB_API_MSG_CREATOR(SYS,tR_STORE);
        MACRO_AARSDABLIB_API_MSG_CREATOR(SYS,tC_RESTORE);
        MACRO_AARSDABLIB_API_MSG_CREATOR(SYS,tR_RESTORE);
        MACRO_AARSDABLIB_API_MSG_CREATOR(SYS,tC_STORAGE_GET_FRAME);
        MACRO_AARSDABLIB_API_MSG_CREATOR(SYS,tR_STORAGE_GET_FRAME);
        MACRO_AARSDABLIB_API_MSG_CREATOR(SYS,tC_STORAGE_PUT_FRAME);
        MACRO_AARSDABLIB_API_MSG_CREATOR(SYS,tR_STORAGE_PUT_FRAME);
        MACRO_AARSDABLIB_API_MSG_CREATOR(SYS,tC_STORAGE_PUT_FRAME_SEGMENT);
        MACRO_AARSDABLIB_API_MSG_CREATOR(SYS,tR_STORAGE_PUT_FRAME_SEGMENT);
        MACRO_AARSDABLIB_API_MSG_CREATOR(SYS,tC_STORAGE_GET_FRAME_SEGMENT);
        MACRO_AARSDABLIB_API_MSG_CREATOR(SYS,tR_STORAGE_GET_FRAME_SEGMENT);
        /*
         * DDM
         */
        MACRO_AARSDABLIB_API_MSG_CREATOR(DDM,tC_RADIOTEXT_CURRENT);
        MACRO_AARSDABLIB_API_MSG_CREATOR(DDM,tR_RADIOTEXT_CURRENT);
        MACRO_AARSDABLIB_API_MSG_CREATOR(DDM,tR_RADIOTEXT_CURRENT_COMMAND);
        MACRO_AARSDABLIB_API_MSG_CREATOR(DDM,tC_SELECT_URI);
        MACRO_AARSDABLIB_API_MSG_CREATOR(DDM,tR_SELECT_URI);
        MACRO_AARSDABLIB_API_MSG_CREATOR(DDM,tR_TIMESTAMP);
        MACRO_AARSDABLIB_API_MSG_CREATOR(DDM,tC_DATAGROUP);
        MACRO_AARSDABLIB_API_MSG_CREATOR(DDM,tR_DATAGROUP);
        MACRO_AARSDABLIB_API_MSG_CREATOR(DDM,tC_PAD_DATAGROUP);
        MACRO_AARSDABLIB_API_MSG_CREATOR(DDM,tR_PAD_DATAGROUP);
        /*
         * ANS
         */
        MACRO_AARSDABLIB_API_MSG_CREATOR(ANS,tC_CONFIG_ANNO);
        MACRO_AARSDABLIB_API_MSG_CREATOR(ANS,tR_CONFIG_ANNO);
        MACRO_AARSDABLIB_API_MSG_CREATOR(ANS,tC_SELECT_ANNO);
        MACRO_AARSDABLIB_API_MSG_CREATOR(ANS,tR_SELECT_ANNO);
        MACRO_AARSDABLIB_API_MSG_CREATOR(ANS,tR_ANNO_ACTIVE_STATUS);
        }

        return AARSLIB_NULL;
    }
}; /* ... class tMsgFactory */

class SDXFHelper
{
public:
    /*
     * 0x21 = Structured Chunk
     * 0x
     */
#define RFC3072_FLAGS_ARRAY                     (1<<6)
#define RFC3072_FLAGS_SHORT                     (1<<5)
#define RFC3072_FLAGS_DATATYPE_MASK             (7)
#define RFC3072_FLAGS_DATATYPE_STRUCTURE        (1)
#define RFC3072_FLAGS_DATATYPE_BITSTRING        (2)
#define RFC3072_FLAGS_DATATYPE_NUMERIC          (3)
#define RFC3072_FLAGS_DATATYPE_CHARACTER        (4)

#define RFC3072_DATA_ID_HEADLINE                (0x0fff)
#define RFC3072_DATA_ID(_id_)                   ((_id_)&(0xfff))
#define RFC3072_TABLE_LEVEL(_id_)               (((_id_)>>12)&(0xf))

    /*some types*/
    typedef struct
    {
      tU16 chunkID;
      tU8 flags;
      tU32 length;
      tU8* content;
    } SDXFChunkInfo;

    typedef struct
    {
      tU32 length;
      tU8* content;
    } SDXFBlob;

  /*!
   *******************************************************************************
     @brief        <b>chunk_get_id</b>

     Returns chunk ID

     @param[in]    data, pointer to chunk
     @return       chunk identification
   *******************************************************************************
   */
  static tU16
  chunk_get_id(const tU8* sdxf_data )
  {
    tU16 id = 0;

    if (sdxf_data != NULL)
      {
        id = (tU16)((*sdxf_data << 8) | *(sdxf_data + 1));
      }

    return id;
  }

  /*!
   *******************************************************************************
     @brief        <b>chunk_get_flags</b>

     Returns chunk flags

     @param[in]    sdxf_data, pointer to chunk
     @return       chunk flags
   *******************************************************************************
   */
  static tU8
  chunk_get_flags(const tU8* sdxf_data)
  {
    tU8 flags = 0;

    if (sdxf_data != NULL)
      {
        flags = *(sdxf_data + 2);
      }

    return flags;
  }

  /*!
   *******************************************************************************
     @brief        <b>chunk_get_chunk_length</b>

     Returns the length of chunk

     @param[in]    sdxf_data, pointer to chunk
     @return       chunk length
   *******************************************************************************
   */
  static tU32
  chunk_get_chunk_length(tU8* sdxf_data)
  {
    tU32 length;

    if (sdxf_data == NULL)
      {
        return (0);
      }

    /*check for short chunk*/
    if (RFC3072_FLAGS_SHORT & (chunk_get_flags(sdxf_data)))
      {
        return 3+3;
      }
    else
      {
        length = ((*(sdxf_data + 3)) << 16) | ((*(sdxf_data + 4)) << 8)
                        | (*(sdxf_data + 5));
        return 3+3+length;
      }
  }

  /*!
   *******************************************************************************
     @brief        <b>chunk_get_chunk_body_length</b>

     Returns the length of chunk data

     @param[in]    sdxf_data, pointer to chunk
     @return       chunk body length
   *******************************************************************************
   */
  static tU32
  chunk_get_chunk_body_length(tU8* sdxf_data)
  {
    tU32 length;

    if (sdxf_data == NULL)
      {
        return (0);
      }

    /*check for short chunk*/
    if (RFC3072_FLAGS_SHORT & (chunk_get_flags(sdxf_data)))
      {
        return 3;
      }
    else
      {
        length = ((*(sdxf_data + 3)) << 16) | ((*(sdxf_data + 4)) << 8)
                        | (*(sdxf_data + 5));
        return length;
      }
  }

  /*!
   *******************************************************************************
     @brief        <b>sdxf_get_chunk_body_pointer</b>

     Returns a pointer to a chunk content

     @param[in]    sdxf_data, pointer to chunk
     @return       chunk body pointer
   *******************************************************************************
   */
  static tU8*
  sdxf_get_chunk_body_pointer(tU8* sdxf_data)
  {
    if (sdxf_data == NULL)
      {
        return (NULL);
      }

    /*check for short chunk*/
    if (RFC3072_FLAGS_SHORT & (chunk_get_flags(sdxf_data)))
      {
        return sdxf_data + 3;
      }
    else
      {
        return sdxf_data + 6;
      }
  }

  /*!
   *******************************************************************************
     @brief        <b>chunk_get_info</b>

     Returns a chunk

     @param[in]    sdxf_data, pointer to chunk
     @return       chunk info structure
   *******************************************************************************
   */
  static SDXFChunkInfo
  chunk_get_info(tU8* sdxf_data)
  {
    SDXFChunkInfo chunk;

    if (sdxf_data != NULL)
      {
        chunk.chunkID = chunk_get_id(sdxf_data);
        chunk.flags = chunk_get_flags(sdxf_data);
        chunk.length = chunk_get_chunk_body_length(sdxf_data);
        chunk.content = sdxf_get_chunk_body_pointer(sdxf_data);
      }
    else
      {
        chunk.chunkID = 0;
        chunk.flags = 0;
        chunk.length = 0;
        chunk.content = NULL;
      }
    return chunk;
  }

  /*!
   *******************************************************************************
     @brief        <b>chunk_get_datatype</b>

     Returns a chunk

     @param[in]    sdxf_data, pointer to chunk
     @return       data type of chunk
   *******************************************************************************
   */
  static int
  chunk_get_datatype(tU8* sdxf_data)
  {
    switch (chunk_get_flags(sdxf_data))
    {
    case (RFC3072_FLAGS_SHORT | RFC3072_FLAGS_DATATYPE_NUMERIC):
                return RFC3072_FLAGS_DATATYPE_NUMERIC;
    case (RFC3072_FLAGS_DATATYPE_NUMERIC):
                return RFC3072_FLAGS_DATATYPE_NUMERIC;
    case (RFC3072_FLAGS_DATATYPE_BITSTRING):
                return RFC3072_FLAGS_DATATYPE_BITSTRING;
    case (RFC3072_FLAGS_DATATYPE_CHARACTER):
                return RFC3072_FLAGS_DATATYPE_CHARACTER;
    case (RFC3072_FLAGS_DATATYPE_STRUCTURE):
                return RFC3072_FLAGS_DATATYPE_STRUCTURE;
    default:
      ;
    }
    return 0;
  }

  /*!
   *******************************************************************************
     @brief        <b>chunk_get_blob</b>

     Returns the blob (content) of the chunk

     @param[in]    sdxf_data, pointer to chunk
     @return       chunk blob pointer
   *******************************************************************************
   */
  static SDXFBlob
  chunk_get_blob(tU8 *chunk)
  {
    SDXFBlob the_blob;

    if (chunk == NULL)
      {
        the_blob.content = NULL;
        the_blob.length = 0;
      }
    else
      {
        the_blob.content = sdxf_get_chunk_body_pointer(chunk);
        the_blob.length = chunk_get_chunk_body_length(chunk);
      }

    return the_blob;
  }

  /*!
   *******************************************************************************
     @brief        <b>chunk_get_numeric_tS32</b>

     Returns the numeric value of the chunk

     @param[in]    sdxf_data, pointer to chunk
     @return       int32 numeric value
   *******************************************************************************
   */
  static tS32
  chunk_get_numeric_tS32(tU8 *chunk)
  {
    tU32 len;
    tU8 *content;
    tS32 value = 0;

    tU32 i;

    if (chunk == NULL)
      {
        return -1;
      }

    len = chunk_get_chunk_body_length(chunk);
    content = sdxf_get_chunk_body_pointer(chunk);

    if (len <= 4)
      {
        for (i = 0; i < len; i++)
          {
            value = (value << 8) | content[i];
          }
        return value;
      }
    return -1;
  }

  /*!
   *******************************************************************************
     @brief        <b>chunk_get_numeric_tU32</b>

     Returns the numeric value of the chunk

     @param[in]    sdxf_data, pointer to chunk
     @return       tU32 numeric value
   *******************************************************************************
   */
  static tU32
  chunk_get_numeric_tU32(tU8 *chunk)
  {
    return (tU32) chunk_get_numeric_tS32(chunk);
  }

  /*!
   *******************************************************************************
     @brief        <b>row_get_chunk</b>

     Return the pointer to the chunk of the sdxf row pointed
     by row identified by chunk_idx

     @param[in]    sdxf_data, pointer to table
     @param[in]    sdxf_length, table length
     @param[in]    row, pointer to row chunk
     @param[in]    column_idx, row number (0,1,2,3,4,...)
     @return       pointer to chunk
   *******************************************************************************
   */
  static tU8*
  row_get_chunk2(tU8* row, tU32 column_idx)
  {
      SDXFChunkInfo row_chunk, the_chunk;

      if( row == NULL )
      {
        return NULL;
      }

      row_chunk = chunk_get_info(row);

      /*now we have the requested row, check for the chunk*/
      if ((row_chunk.flags & RFC3072_FLAGS_DATATYPE_MASK)
              == RFC3072_FLAGS_DATATYPE_STRUCTURE)
      { /*do it only if we have a structured row*/
          tU32 the_chunk_pos = 6;

          /*go through the list of chunks*/
          while (the_chunk_pos < (6+row_chunk.length))
          {
              the_chunk = chunk_get_info(row + the_chunk_pos);

              /*check if this chunk contains the correct chunk id which least 12 bit are equal to chunk_column*/
              if (column_idx == (tU32) (the_chunk.chunkID & 0xfff))
              {
                  return ((tU8*) row + the_chunk_pos);
              }

              if (the_chunk.flags & RFC3072_FLAGS_SHORT)
              {
                  the_chunk_pos += 6;
              }
              else
              {
                  the_chunk_pos += (6 + the_chunk.length);
              }
          }
      }
      return NULL;
  }

  static tU8*
  row_get_chunk(const tU8* sdxf_data, tU32 sdxf_length, tU8* row,
                tU32 column_idx)
  {
      if (sdxf_data == NULL)
      {
          return (NULL);
      }
      if (sdxf_length < 6)
      {
          return (NULL);
      }

      if( row == NULL )
      {
        return NULL;
      }

      /*check ptr validity*/
      if ((sdxf_data < row) && (row < (sdxf_data + sdxf_length)))
      {
          return row_get_chunk2(row,column_idx);
      }
      return NULL;
  }

  /*!
   *******************************************************************************
     @brief        <b>table_get_chunk</b>

     Returns the ptr to chunk identified by row_idx and column_idx

     @param[in]    sdxf_data, pointer to table
     @param[in]    sdxf_length, table length
     @param[in]    row_idx, column number (0,1,2,3,4,...)
     @param[in]    column_idx, row number (0,1,2,3,4,...)
     @return       pointer to chunk
   *******************************************************************************
   */
  static tU8*
  table_get_chunk(tU8* sdxf_data, tU32 sdxf_length, tU32 row_idx,
      tU32 column_idx)
      {
    SDXFChunkInfo table_chunk, row_chunk, the_chunk;
    tU32 cur_row = 0;
    tU32 position;

    if (sdxf_length < 6)
      {
        return (NULL);
      }
    if (sdxf_data == NULL)
      {
        return (NULL);
      }

    table_chunk = chunk_get_info(sdxf_data);

    /*first: go through the rows*/
    if ((table_chunk.flags & RFC3072_FLAGS_DATATYPE_MASK)
        == RFC3072_FLAGS_DATATYPE_STRUCTURE)
      {
        position = 6;

        /*go through the rows*/
        do
          {
            if (position < sdxf_length)
              {
                /*get the row chunk*/
                row_chunk = chunk_get_info(sdxf_data + position);

                if (cur_row < row_idx)
                  {/*we need to step over this row*/
                    if (row_chunk.flags & RFC3072_FLAGS_SHORT)
                      position += 6;
                    else
                      position += (6 + row_chunk.length);

                    cur_row++;
                  }
                else
                  {/*we found the row indexed by row_idx, so leave the while loop*/
                    break;
                  }
              }
            else
              {/*maybe someone took the wrong sdxf ptr or to large row_idx*/
                return NULL;
              }
          }
        while (1);

        position += 6;

        /*now we have the requested row, check for the chunk*/
        if ((row_chunk.flags & RFC3072_FLAGS_DATATYPE_MASK)
            == RFC3072_FLAGS_DATATYPE_STRUCTURE)
          { /*do it only if we have a structured row*/
            tU32 the_chunk_pos = position;

            /*go through the list of chunks*/
            while (the_chunk_pos < (position + row_chunk.length))
              {
                the_chunk = chunk_get_info(sdxf_data + the_chunk_pos);

                /*check if this chunk contains the correct chunk id which least 12 bit are equal to chunk_column*/
                if (column_idx == (tU32) (the_chunk.chunkID & 0xfff))
                  return ((tU8*) sdxf_data + the_chunk_pos);

                if (the_chunk.flags & RFC3072_FLAGS_SHORT)
                  the_chunk_pos += 6;
                else
                  the_chunk_pos += (6 + the_chunk.length);
              }
          }
      }
    return NULL;
      }

  /*!
   *******************************************************************************
     @brief        <b>table_get_num_columns</b>

     Returns the number of comlumns

     @param[in]    sdxf_data, pointer to table
     @param[in]    sdxf_length, table length
     @return       number of columns in table
   *******************************************************************************
   */
  static tU32
  table_get_num_columns(tU8* sdxf_data, tU32 sdxf_length)
  {
    /*mask all chunk ids in all rows with 0x0fff*/
    /*and find the largest value. This is the number of columns*/
    SDXFChunkInfo table_chunk, row_chunk, the_chunk;
    tU32 num_colmn = 0;
    tU32 position = 0;

    if (sdxf_length < 6)
      {
        return (0);
      }
    if (sdxf_data == NULL)
      {
        return (0);
      }
    table_chunk = chunk_get_info(sdxf_data);

    if ((table_chunk.flags & RFC3072_FLAGS_DATATYPE_MASK)
        == RFC3072_FLAGS_DATATYPE_STRUCTURE)
      {
        position = 6;

        /*go through the list of chunks*/
        while (position < sdxf_length)
          {
            row_chunk = chunk_get_info(sdxf_data + position);

            position += 6;

            /*now we have the row, in this row go through all chunks an find largest column*/
            if ((row_chunk.flags & RFC3072_FLAGS_DATATYPE_MASK)
                == RFC3072_FLAGS_DATATYPE_STRUCTURE)
              { /*do it only if we have a structured row*/
                tU32 the_chunk_pos = position;

                /*go through the list of chunks*/
                while (the_chunk_pos < (position + row_chunk.length))
                  {
                    the_chunk = chunk_get_info(sdxf_data + the_chunk_pos);

                    if (num_colmn < (tU32) (the_chunk.chunkID & 0xfff))
                      {
                        num_colmn = the_chunk.chunkID & 0xfff;
                      }

                    if (the_chunk.flags & RFC3072_FLAGS_SHORT)
                      {
                        the_chunk_pos += 6;
                      }
                    else
                      {
                        the_chunk_pos += (6 + the_chunk.length);
                      }
                  }
              }

            if (RFC3072_DATA_ID(row_chunk.chunkID) != RFC3072_DATA_ID_HEADLINE)
              {
                /*
                 * After headline is processed, no further column counting is needed
                 */
                return num_colmn;
              }

            if ((row_chunk.flags & RFC3072_FLAGS_SHORT) == 0)
              {
                position += row_chunk.length;
              }

          }
      }
    return num_colmn;
  }

  /*!
   *******************************************************************************
     @brief        <b>table_get_num_rows</b>

     Returns the number of rows

     @param[in]    sdxf_data, pointer to table
     @param[in]    sdxf_length, table length
     @return       number of rows in table
   *******************************************************************************
   */
  static tU32
  table_get_num_rows(tU8* sdxf_data, tU32 sdxf_length)
  {
    SDXFChunkInfo table_chunk, row_chunk;
    tU32 num_rows = 0;
    tU32 position = 0;

    if (sdxf_length < 6)
      {
        return (0);
      }
    if (sdxf_data == NULL)
      {
        return (0);
      }

    table_chunk = chunk_get_info(sdxf_data);

    if ((table_chunk.flags & RFC3072_FLAGS_DATATYPE_MASK)
        == RFC3072_FLAGS_DATATYPE_STRUCTURE)
      {
        position = 6;

        /*go through the list of chunks*/
        while (position < sdxf_length)
          {
            row_chunk = chunk_get_info(sdxf_data + position);

            if (row_chunk.flags & RFC3072_FLAGS_SHORT)
              {
                position += 6;
              }
            else
              {
                position += (6 + row_chunk.length);
              }

            if (RFC3072_DATA_ID(row_chunk.chunkID) != RFC3072_DATA_ID_HEADLINE)
              {
                num_rows++;
              }
          }
      }
    return num_rows;
  }

  /*!
   *******************************************************************************
     @brief        <b>table_get_row</b>

     Return the pointer to the row of the sdxf table pointed
     by sdxf data

     @param[in]    sdxf_data, pointer to table
     @param[in]    sdxf_length, table length
     @param[in]    row_idx, row index
     @return       pointer to row chunk
   *******************************************************************************
   */
  static tU8*
  table_get_row(tU8* sdxf_data, tU32 sdxf_length, tU32 row_idx)
  {
    SDXFChunkInfo table_chunk, row_chunk;
    tU32 num_rows = 0;
    tU32 position = 0;

    if (sdxf_data == NULL)
      {
        return (NULL);
      }
    if (sdxf_length < 6)
      {
        return (NULL);
      }

    table_chunk = chunk_get_info(sdxf_data);

    if ((table_chunk.flags & RFC3072_FLAGS_DATATYPE_MASK)
        == RFC3072_FLAGS_DATATYPE_STRUCTURE)
      {
        position = 6;

        /*go through the list of chunks*/
        while (position < sdxf_length)
          {
            row_chunk = chunk_get_info(sdxf_data + position);

            /*
             * ignore headline rows
             */
            if (RFC3072_DATA_ID(row_chunk.chunkID) != RFC3072_DATA_ID_HEADLINE)
              {
                /*check if we have the wanted row*/
                if (row_idx == num_rows)
                  {
                    return (sdxf_data + position);
                  }
              }

            if (row_chunk.flags & RFC3072_FLAGS_SHORT)
              {
                position += 6;
              }
            else
              {
                position += (6 + row_chunk.length);
              }

            /*
             * ignore headline rows
             */
            if (RFC3072_DATA_ID(row_chunk.chunkID) != RFC3072_DATA_ID_HEADLINE)
              {
                num_rows++;
              }
          }
      }
    return NULL;
  }

  /*!
   *******************************************************************************
     @brief        <b>table_get_headline_row</b>

     Return the pointer to the headline row of the sdxf table pointed
     by sdxf data

     @param[in]    sdxf_data, pointer to table
     @param[in]    sdxf_length, table length
     @return       pointer to headline row chunk
   *******************************************************************************
   */
  static tU8*
  table_get_headline_row(tU8* sdxf_data, tU32 sdxf_length)
  {
    SDXFChunkInfo table_chunk, row_chunk;
    tU32 position = 0;

    if (sdxf_data == NULL)
      {
        return (NULL);
      }
    if (sdxf_length < 6)
      {
        return (NULL);
      }

    table_chunk = chunk_get_info(sdxf_data);

    if ((table_chunk.flags & RFC3072_FLAGS_DATATYPE_MASK)
        == RFC3072_FLAGS_DATATYPE_STRUCTURE)
      {
        position = 6;
        row_chunk = chunk_get_info(sdxf_data + position);

        if (RFC3072_DATA_ID(row_chunk.chunkID) == RFC3072_DATA_ID_HEADLINE)
          {
            return (sdxf_data + position);
          }
      }
    return NULL;
  }

}; /* ... class SDXFHelper */

class CharsetHelper
{
    /* This function converts some iso646 chars into latin1 chars.
     * iso646 is used in DAB system and defined in the FM RDS specification.
     * This implementation is just for demonstration and not complete for all
     * characters in iso646.*/
public:
    static void iso646_to_latin1 (tPU8 the_str, tU32 len)
	{
		tU32 i ;

		for (i=0;i<len;i++)
		{
			switch (the_str[i])
			{
			case 141:
                the_str[i]=0xdf; //ß
				break;
			case 145:
				the_str[i]=0xe4; //ä
				break;
			case 151:
				the_str[i]=0xf6; //ö
				break;
			case 153:
				the_str[i]=0xfc; //ü
				break;
			case 209:
				the_str[i]=0xc4; //Ä
				break;
			case 215:
				the_str[i]=0xd6; //Ö
				break;
			case 217:
				the_str[i]=0xdc; //Ü
				break;
			default:
				break;
			}
		}
	}
}; /* ... class CharsetHelper */

} /* ... namespace AaRSDABLib */

/*!
*******************************************************************************
 EOF
*******************************************************************************
*/
#endif // AARSDABLIB_H
