/******************************************************************************
 *
 * FILE: tclDSMApp.cpp
 * PROJECT: AaRS
 * SW-COMPONENT: Data Service Manager
 *
 * DESCRIPTION: This file contains the DSM class interface specification
 *
 * AUTHOR: CM-AI/ECB2-Scholz
 *
 * COPYRIGHT: (c) 2010 Robert Bosch Multimedia GmbH
 * HISTORY:
 * Date | Rev. | Author | Modification
 * ----------------------------------------------------------------------------
 * 23.04.2014 | 1.0 | CM-AI/ECB2-Scholz | Initial revision
 *
 *****************************************************************************/
#include <stdarg.h>  // for va_start, etc
#include <memory>    // for std::unique_ptr
#include "tclDSM.h"

using namespace dsm;

#ifdef CONFIG_DSM__ENABLE_DAB_JOURNALINE

/******************************************************************************
 * FUNCTION:
 * DESCRIPTION:
 * PARAMETER:
 * RETURNVALUE:
 * HISTORY:
 *****************************************************************************/
tclDSMDABJRLNApp::tclDSMDABJRLNApp(tclDSM* dsm, tU8 u8TunerIndex,AaRSDABLib::API::DDM::tR_SELECT_URI msg)
    : tclDSMDABApp(dsm,u8TunerIndex,msg.r_uri())
{
    //memset((void*)&prepared_statements,0,sizeof(prepared_statements));
    tclDSMDABApp::vHandleMsgR_SELECT_URI(msg);
}

/******************************************************************************
 * FUNCTION:
 * DESCRIPTION:
 * PARAMETER:
 * RETURNVALUE:
 * HISTORY:
 *****************************************************************************/
tclDSMDABJRLNApp::~tclDSMDABJRLNApp()
{
    if( _dsm->oDB()->pHandle() != NULL )
    {
        /*
        if( prepared_statements.pStmt_bTryDecodeEPGObject_01 != NULL )
        {
            _dsm->oDB()->dbReset( prepared_statements.pStmt_bTryDecodeEPGObject_01);
            prepared_statements.pStmt_bTryDecodeEPGObject_01 = NULL;
        }
        */
    }
}

/******************************************************************************
 * FUNCTION:
 * DESCRIPTION:
 * PARAMETER:
 * RETURNVALUE:
 * HISTORY:
 *****************************************************************************/
tVoid tclDSMDABJRLNApp::vInitializeTables(tclDSM* dsm)
{
    SQLITE_API int rc;
    /*
     * create tables dab_datagroup_jrnl*
     */
    rc = dsm->oDB()->dbExec(
                "CREATE TABLE IF NOT EXISTS "
                /**/ "dab_datagroup_jrnl ("
                /***/ "o INTEGER PRIMARY KEY,"
                /***/ "a NOT NULL REFERENCES dab_data_application(o) ON DELETE CASCADE,"
                /***/ "dgtype,"
                /***/ "objid,"
                /***/ "objtype,"
                /***/ "statfl,"
                /***/ "comprfl,"
                /***/ "revidx,"
                /***/ "comprmeth,"
                /***/ "contsize,"
                /***/ "content"
                /**/ ")",
                NULL,NULL,NULL);

    rc = dsm->oDB()->dbExec(
                "CREATE TABLE IF NOT EXISTS "
                /**/ "dab_datagroup_jrnl_toc ("
                /***/ "o INTEGER PRIMARY KEY,"
                /***/ "a NOT NULL REFERENCES dab_data_application(o) ON DELETE CASCADE,"
                /***/ "objid"

                /**/ ")",
                NULL,NULL,NULL);
    (void)rc;
}

/******************************************************************************
 * FUNCTION:
 * DESCRIPTION:
 * PARAMETER:
 * RETURNVALUE:
 * HISTORY:
 *****************************************************************************/
tVoid tclDSMDABJRLNApp::vHandleMsgR_DATACHANNEL_FRAME(AaRSDABLib::API::DC::tR_DATACHANNEL_FRAME msg)
{
    tclDSMDABApp::vHandleMsgR_DATACHANNEL_FRAME(msg);
}

/******************************************************************************
 * FUNCTION:
 * DESCRIPTION:
 * PARAMETER:
 * RETURNVALUE:
 * HISTORY:
 *****************************************************************************/
tVoid tclDSMDABJRLNApp::vHandleMsgR_TIMESTAMP(AaRSDABLib::API::DDM::tR_TIMESTAMP msg)
{
    tclDSMDABApp::vHandleMsgR_TIMESTAMP(msg);
}

/******************************************************************************
 * FUNCTION:
 * DESCRIPTION:
 * PARAMETER:
 * RETURNVALUE:
 * HISTORY:
 *****************************************************************************/
tVoid tclDSMDABJRLNApp::vHandleMsgR_SELECT_URI(AaRSDABLib::API::DDM::tR_SELECT_URI msg)
{
    tclDSMDABApp::vHandleMsgR_SELECT_URI(msg);
}

#endif /* CONFIG_DSM__ENABLE_DAB_JORNALINE */

/******************************************************************************
 * EOF
 *****************************************************************************/

