/******************************************************************************
 *
 * FILE: tclDSMApp.cpp
 * PROJECT: AaRS
 * SW-COMPONENT: Data Service Manager
 *
 * DESCRIPTION: This file contains the DSM class interface specification
 *
 * AUTHOR: CM-AI/ECB2-Scholz
 *
 * COPYRIGHT: (c) 2010 Robert Bosch Multimedia GmbH
 * HISTORY:
 * Date | Rev. | Author | Modification
 * ----------------------------------------------------------------------------
 * 23.04.2014 | 1.0 | CM-AI/ECB2-Scholz | Initial revision
 *
 *****************************************************************************/
#include <stdarg.h>  // for va_start, etc
#include <memory>    // for std::unique_ptr
#include "tclDSM.h"

using namespace dsm;

#ifdef CONFIG_DSM__ENABLE_DAB_BWS

/******************************************************************************
 * FUNCTION:
 * DESCRIPTION:
 * PARAMETER:
 * RETURNVALUE:
 * HISTORY:
 *****************************************************************************/
tclDSMDABBWSApp::tclDSMDABBWSApp(tclDSM* dsm, tU8 u8TunerIndex,AaRSDABLib::API::DDM::tR_SELECT_URI msg)
    : tclDSMDABMOTApp(dsm,u8TunerIndex,msg.r_uri())
{
    //memset((void*)&prepared_statements,0,sizeof(prepared_statements));
    vInitMOTDirectory();
    tclDSMDABMOTApp::vHandleMsgR_SELECT_URI(msg);
}

/******************************************************************************
 * FUNCTION:
 * DESCRIPTION:
 * PARAMETER:
 * RETURNVALUE:
 * HISTORY:
 *****************************************************************************/
tclDSMDABBWSApp::~tclDSMDABBWSApp()
{
}

/******************************************************************************
 * FUNCTION:
 * DESCRIPTION:
 * PARAMETER:
 * RETURNVALUE:
 * HISTORY:
 *****************************************************************************/
#ifdef CONFIG_DSM_ENABLE_MOT_DIRECTORY_PARAM_FILTER
tBool tclDSMDABBWSApp::bDirectoryParamFilter( tU8 u8ContentType, tU16 u16ContentSubType, tU8 u8ParamId)
{
    (void)u8ContentType;
    (void)u16ContentSubType;
    (void)u8ParamId;
    return TRUE;
}
#endif /* CONFIG_DSM_ENABLE_MOT_DIRECTORY_PARAM_FILTER */

/******************************************************************************
 * FUNCTION:
 * DESCRIPTION:
 * PARAMETER:
 * RETURNVALUE:
 * HISTORY:
 *****************************************************************************/
tVoid tclDSMDABBWSApp::vInitializeTables(tclDSM* dsm)
{
    (void)dsm;
}

/******************************************************************************
 * FUNCTION:
 * DESCRIPTION:
 * PARAMETER:
 * RETURNVALUE:
 * HISTORY:
 *****************************************************************************/
tVoid tclDSMDABBWSApp::vHandleMsgR_DATACHANNEL_FRAME(AaRSDABLib::API::DC::tR_DATACHANNEL_FRAME msg)
{
    tclDSMDABMOTApp::vHandleMsgR_DATACHANNEL_FRAME(msg);
}

/******************************************************************************
 * FUNCTION:
 * DESCRIPTION:
 * PARAMETER:
 * RETURNVALUE:
 * HISTORY:
 *****************************************************************************/
tVoid tclDSMDABBWSApp::vHandleMsgR_TIMESTAMP(AaRSDABLib::API::DDM::tR_TIMESTAMP msg)
{
    tclDSMDABMOTApp::vHandleMsgR_TIMESTAMP(msg);
}

/******************************************************************************
 * FUNCTION:
 * DESCRIPTION:
 * PARAMETER:
 * RETURNVALUE:
 * HISTORY:
 *****************************************************************************/
tVoid tclDSMDABBWSApp::vHandleMsgR_SELECT_URI(AaRSDABLib::API::DDM::tR_SELECT_URI msg)
{
    tclDSMDABMOTApp::vHandleMsgR_SELECT_URI(msg);
}

#endif /* CONFIG_DSM__ENABLE_DAB_BWS */

/******************************************************************************
 * EOF
 *****************************************************************************/

