/******************************************************************************
 *
 * FILE: tclDSMApp.cpp
 * PROJECT: AaRS
 * SW-COMPONENT: Data Service Manager
 *
 * DESCRIPTION: This file contains the DSM class interface specification
 *
 * AUTHOR: CM-AI/ECB2-Scholz
 *
 * COPYRIGHT: (c) 2010 Robert Bosch Multimedia GmbH
 * HISTORY:
 * Date | Rev. | Author | Modification
 * ----------------------------------------------------------------------------
 * 23.04.2014 | 1.0 | CM-AI/ECB2-Scholz | Initial revision
 *
 *****************************************************************************/
#include <stdarg.h>  // for va_start, etc
#include <memory>    // for std::unique_ptr
#include "tclDSM.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_DATASRVCS_DSM_APP
#include "trcGenProj/Header/tclDSMApp.cpp.trc.h"
#endif

using namespace dsm;

/******************************************************************************
 * FUNCTION:
 * DESCRIPTION:
 * PARAMETER:
 * RETURNVALUE:
 * HISTORY:
 *****************************************************************************/
tclDSMApp::tclDSMApp( tclDSM* dsm )
{
    _dsm = dsm;
    _doRollbackTransaction  = FALSE;
    _bErrorFlag             = FALSE;
    _bmaxObjectSizeViolated = FALSE;
}

/******************************************************************************
 * FUNCTION:
 * DESCRIPTION:
 * PARAMETER:
 * RETURNVALUE:
 * HISTORY:
 *****************************************************************************/
tVoid tclDSMApp::vInitializeTables(tclDSM* dsm)
{
    (void)dsm;
}

/******************************************************************************
 * FUNCTION:
 * DESCRIPTION:
 * PARAMETER:
 * RETURNVALUE:
 * HISTORY:
 *****************************************************************************/
int tclDSMApp::iBeginSavePoint()
{
	int rc;
    rc = _dsm->oDB()->dbExec(
			"SAVEPOINT tclDSMAppSavePoint",
			NULL,NULL,NULL);
    ETG_TRACE_USR1(("%p.iBeginSavePoint() SAVEPOINT tclDSMAppSavePoint rc=%d",
                    (void*)this,rc));
    return rc;
}

/******************************************************************************
 * FUNCTION:
 * DESCRIPTION:
 * PARAMETER:
 * RETURNVALUE:
 * HISTORY:
 *****************************************************************************/
int tclDSMApp::iCommitSavePoint()
{
	int rc = SQLITE_OK;
    if(_dsm->oDB()->dbGetAutoCommit() == 0)
    {
        rc = _dsm->oDB()->dbExec(
    			"RELEASE SAVEPOINT tclDSMAppSavePoint",
    			NULL,NULL,NULL);
        ETG_TRACE_USR1(("%p.iCommitSavePoint() RELEASE SAVEPOINT tclDSMAppSavePoint rc=%d",
                        (void*)this,rc));
    }
    else
    {
        ETG_TRACE_USR1(("%p.iCommitSavePoint() dbGetAutoCommit!=0 ",
                        (void*)this));
    }
	return rc;
}

/******************************************************************************
 * FUNCTION:
 * DESCRIPTION:
 * PARAMETER:
 * RETURNVALUE:
 * HISTORY:
 *****************************************************************************/
int tclDSMApp::iRoolbackSavePoint()
{
	int rc = SQLITE_OK;
    if(_dsm->oDB()->dbGetAutoCommit() == 0)
    {
    	rc = _dsm->oDB()->dbExec(
    			"ROLLBACK TO tclDSMAppSavePoint",
    			NULL,NULL,NULL);
        if( rc != SQLITE_OK )
    	{
            ETG_TRACE_FATAL(("%p.iRoolbackSavePoint() ROLLBACK/RELEASE SAVEPOINT tclDSMAppSavePoint",
                            (void*)this));
            return rc;
    	}
        ETG_TRACE_USR1(("%p.iRoolbackSavePoint() ROLLBACK SAVEPOINT tclDSMAppSavePoint rc=%d",
                        (void*)this,rc));

    	rc = _dsm->oDB()->dbExec(
    			"RELEASE SAVEPOINT tclDSMAppSavePoint",
    			NULL,NULL,NULL);

        ETG_TRACE_USR1(("%p.iRoolbackSavePoint() RELEASE SAVEPOINT tclDSMAppSavePoint rc=%d",
                        (void*)this,rc));
    }
	return rc;
}

/******************************************************************************
 * FUNCTION:
 * DESCRIPTION:
 * PARAMETER:
 * RETURNVALUE:
 * HISTORY:
 *****************************************************************************/
tU32 tclDSMApp::u32BitStreamValue( const tU8* bitstream, tU32 bitstreambytes, tU32 pos, tU32 bits )
{
    tU32 v = 0;
    if((pos+bits)>(bitstreambytes<<3))
    {
        return 0;
    }

    tU32 i = pos;
    while(i<(tU32)(pos+bits))
    {
        if(((i&7)==0)&&(((pos+bits)-i)>=8))
        {
            tU8 b = bitstream[i>>3];
            v = (v<<8)|(b);
            i+=8;
        }
        else
        {
            tU8 b = ((bitstream[i>>3])>>(7-(i&7)))&1;
            v = (v<<1)|(b);
            i++;
        }
    }
    return v;
}

/******************************************************************************
 * FUNCTION:
 * DESCRIPTION:
 * PARAMETER:
 * RETURNVALUE:
 * HISTORY:
 *****************************************************************************/
std::string tclDSMApp::string_sprintf(const std::string fmt, ...) {
    int size = 100;
    std::string str;
    va_list ap;
    while (1) {
        str.resize(size);
        va_start(ap, fmt);
        int n = vsnprintf((char *)str.c_str(), size, fmt.c_str(), ap);
        va_end(ap);
        if (n > -1 && n < size) {
            str.resize(n);
            return str;
        }
        if (n > -1)
            size = n + 1;
        else
            size *= 2;
    }
    return str;
}


/******************************************************************************
 * EOF
 *****************************************************************************/

