/************************************************************************
 * FILE:        fc_dabtuner_stl.h
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of fc_dabtuner_stl
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#ifndef DAB_STL_H
#define DAB_STL_H

//#include "string"
#include <string>
#include <map>
#include <set>
#include <list>
#include <vector>
#include <deque>

using namespace std;

#include "fc_dabtuner_assert.h"

namespace DAB {
    template<class T, int N>
        class DAB_SemFreeQ {
    public:
        DAB_SemFreeQ(tVoid):_nMax(N) {
            u32WritePos = 0;
            u32ReadPos = 0;
            aoT[0]=OSAL_NULL;
        };

            tVoid vPush(T poWrite) {
                aoT[u32WritePos] = poWrite;
                u32WritePos=(u32WritePos + 1) % _nMax;
            };
            tBool bPop(T *poElem) {
                tBool bRes = FALSE;
                if (u32GetNumEntries()) {
                    *poElem = aoT[u32ReadPos];
                    u32ReadPos=(u32ReadPos + 1) % _nMax;
                    bRes = TRUE;
                }
                return bRes;
            };

            tVoid vClear(tVoid) {
                u32WritePos = 0;
                u32ReadPos = 0;
            };

    private:
            const tU32 _nMax;
            tU32 u32WritePos;
            tU32 u32ReadPos;
            T aoT[N];

            tU32 u32GetNumEntries(tVoid) const {
                tU32 u32Res;
                if (u32WritePos >= u32ReadPos) {
                    u32Res = u32WritePos - u32ReadPos;
                }
                else {
                    u32Res = u32WritePos + _nMax - u32ReadPos;

                }
                return u32Res;
            };
    };

    //lint -esym(818, first2) Pointer parameter 'first2' could be declared as pointing to const
    template <class InputIterator1, class InputIterator2, class T>
        tVoid DAB_set_difference ( InputIterator1 first1, InputIterator1 const &last1,
                                   InputIterator2 first2, InputIterator2 const &last2,
                                   set<T> &setResult )
    {
        while (first1!=last1 && first2!=last2)
        {
            if (*first1<*first2) {
                setResult.insert(*first1);
                ++first1;
            }
            else if (*first2<*first1) {
                ++first2;
            }
            else { 
                ++first1; ++first2; 
            }

        }
        for (InputIterator1 iter =first1; iter!=last1;++iter) {
            setResult.insert(*iter);
        }
    }

    template <typename OutContainer, typename InContainer>
        void DAB_removeFromSet ( OutContainer &contOut, InContainer const &contIn)
    {
        typename OutContainer::iterator firstOut=contOut.begin();
        typename OutContainer::iterator lastOut=contOut.end();
        typename InContainer::const_iterator firstIn=contIn.begin();
        typename InContainer::const_iterator lastIn=contIn.end();
        while (firstOut!=lastOut && firstIn!=lastIn)
        {
            if (*firstOut<*firstIn) {
                ++firstOut;
            }
            else if (*firstIn<*firstOut) {
                ++firstOut;
            }
            else {
                typename OutContainer::iterator tmpOut=firstOut;
                firstOut++; firstIn++;
                contOut.erase(tmpOut);
        
            }
        }
    }
}
#endif
