/************************************************************************
 * FILE:        fc_dabtuner_serialize.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of fc_dabtuner_serialize
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#include "fc_dabtuner_serialize.hpp"

namespace DAB {

#define DAB_PARSER_CHECK(a) \
    if (_au8BinData==OSAL_NULL || bHasError() || _u32Index+(a) > _u32BinDateLen) { \
        vSetError();                                      \
        return;                                                 \
    }

    DAB_Parser::DAB_Parser(tU8 u8VerMaj, tU8 u8VerMin):
        _u32Index(0),
        _u8VerMaj(u8VerMaj),
        _u8VerMin(u8VerMin),
        _u8VerMajParsed(0),
        _u8VerMinParsed(0),
        _u32BinDateLen(0),
        _au8BinData(0)
    {};

    tBool DAB_Parser::bRead(tPCU8 pcu8Buf,  tU32 u32Length) {
        _au8BinData=NULL;
        if (u32Length<2) {
            return false;
        }

        _u8VerMajParsed=pcu8Buf[0];
        _u8VerMinParsed=pcu8Buf[1];
        if (_u8VerMaj != _u8VerMajParsed) {
            return false;
        }
        if (_u8VerMin < _u8VerMinParsed) {
            return false;
        }
        _u32Index=0;
        _au8BinData=&pcu8Buf[2];
        _u32BinDateLen=u32Length-2;
        return true;
    }


    tVoid DAB_Parser::vParse(bool &rBoolVal) {
        rBoolVal=false;
        DAB_PARSER_CHECK(1);
        rBoolVal=_au8BinData[_u32Index++] ? true : false;
    }

#if 0
    tVoid DAB_Parser::vParse(tBool &rBoolVal) {
        rBoolVal=false;
        DAB_PARSER_CHECK(1);
        rBoolVal=_au8BinData[_u32Index++] ? true : false;
    }
#endif

    tVoid DAB_Parser::vParse(tU8 &ru8Val) {
        ru8Val=0;
        DAB_PARSER_CHECK(1);
        ru8Val=_au8BinData[_u32Index++];
    }



    tVoid DAB_Parser::vParse(tU16 &ru16Val) {
        ru16Val=0;
        DAB_PARSER_CHECK(2);
        ru16Val = (tU16)(ru16Val | _au8BinData[_u32Index++]);
        ru16Val = (tU16)(ru16Val << 8);
        ru16Val = (tU16)(ru16Val | _au8BinData[_u32Index++]);
    }


    tVoid  DAB_Parser::vParse(tU32 &ru32Val) {
        ru32Val=0;
        DAB_PARSER_CHECK(4);
        ru32Val |=_au8BinData[_u32Index++];
        ru32Val<<=8;
        ru32Val |=_au8BinData[_u32Index++];
        ru32Val<<=8;
        ru32Val |=_au8BinData[_u32Index++];
        ru32Val<<=8;
        ru32Val |=_au8BinData[_u32Index++];
    }


    tVoid DAB_Parser::vParseCString(tChar *pStr, tU8 u8MaxLen) {
        u8ParseBytes((tU8 *)pStr, u8MaxLen);
        if (bHasError()) {
            pStr[0]=0;
        }
        pStr[u8MaxLen]=0;
    }


    tU8 DAB_Parser::u8ParseBytes(tU8 *pu8Bytes, tU8 u8MaxNumBytes) {
        tU8 u8NumBytes;
        vParse(u8NumBytes);

        if (bHasError() || _u32Index+(u8NumBytes) > _u32BinDateLen) {
            vSetError();
            return 0;
        }

        tU8 u8BytesLeft=0;
        if (u8MaxNumBytes<u8NumBytes) {
            u8NumBytes=u8MaxNumBytes;
            u8BytesLeft= (tU8)(u8NumBytes-u8MaxNumBytes);
        }
        for (tU32 i=0; i<u8NumBytes;i++) {
            vParse(pu8Bytes[i]);
        }
        _u32Index+=u8BytesLeft;
        return u8NumBytes;
    }


    tVoid DAB_Parser::vParse(string &oString) {
        tU32 u32Size;
        vParse(u32Size);
        DAB_PARSER_CHECK(u32Size);
     
        for (tU32 i=0; i < u32Size; i++)
        {
            oString.push_back((tU8)(_au8BinData[_u32Index++]));
        }
    }


    DAB_Serializer::DAB_Serializer(tU8 u8VerMaj, tU8 u8VerMin):
        _u8VerMaj(u8VerMaj),
        _u8VerMin(u8VerMin)
    {
        _au8BinData.push_back(_u8VerMaj);
        _au8BinData.push_back(_u8VerMin);
    };


    tVoid DAB_Serializer::vSerialize(bool bValue) {
        _au8BinData.push_back(bValue ? 1:0);
    }

#if 0
    tVoid DAB_Serializer::vSerialize(tBool bValue) {
        _au8BinData.push_back(bValue ? 1:0);
    }
#endif


    tVoid DAB_Serializer::vSerialize(tU8 u8Value) {
        _au8BinData.push_back(u8Value);
    }

    tVoid DAB_Serializer::vSerialize(tU16 u16Value) {
        _au8BinData.push_back((tU8)(((u16Value)>>8)& 0xFF));
        _au8BinData.push_back((tU8)(((u16Value))));
    }

    tVoid DAB_Serializer::vSerialize(tU32 u32Value) {
        _au8BinData.push_back((tU8)(((u32Value)>>24)& 0xFF));
        _au8BinData.push_back((tU8)(((u32Value)>>16)& 0xFF));
        _au8BinData.push_back((tU8)(((u32Value)>>8)& 0xFF));
        _au8BinData.push_back((tU8)(((u32Value))));
    }


    tVoid DAB_Serializer::vSerializeCString(tChar const *pStr) {
        vSerializeBytes((tU8 const *)pStr, (tU8)(strlen(pStr)+1));
    }


    tVoid DAB_Serializer::vSerializeBytes(tU8 const *pu8Bytes, tU8 u8NumBytes) {
        vSerialize(u8NumBytes);
        
        for (tU32 i=0; i < u8NumBytes; i++)
        {
            _au8BinData.push_back((tU8)(pu8Bytes[i]));
        }
    }


    tVoid DAB_Serializer::vSerialize(string &oString) {
        tU32 u32StrLen=(tU32)oString.size();
        vSerialize(u32StrLen);
        for (tU32 i=0; i < u32StrLen; i++)
        {
            _au8BinData.push_back((tU8)(oString[i]));
        }
    }







} // namespace DAB
