/************************************************************************
 * FILE:        fc_dabtuner_sem.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of fc_dabtuner_sem
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#include "fc_dabtuner_dispatcher.hpp"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_UTIL
#include "trcGenProj/Header/fc_dabtuner_sem.cpp.trc.h"
#endif

dab_sem::dab_sem(tVoid) {
    _hSem = OSAL_C_INVALID_HANDLE;
}

dab_sem::~dab_sem(tVoid) {
    vClose();
    _hSem = OSAL_C_INVALID_HANDLE;
}

tVoid dab_sem::vOpen(char const *sName, tU32 u32InitVal) {
    oSemName = sName;
    if (_hSem != OSAL_C_INVALID_HANDLE) {
        return;
    }
    if(OSAL_ERROR  == OSAL_s32SemaphoreCreate(/*tCString*/        sName,
                                              /*OSAL_tSemHandle*/ &_hSem,
                                              /*uCount*/          (tU32)u32InitVal))
    {
        ETG_TRACE_FATAL(("dab_sem:vOpen: OSAL_s32SemaphoreCreate (%s) ERROR", sName));
        _hSem = OSAL_C_INVALID_HANDLE;	
    }

        
}
tVoid dab_sem::vClose(tVoid) {
    if (_hSem == OSAL_C_INVALID_HANDLE) {
        return;
    }
        
    if(OSAL_ERROR  == OSAL_s32SemaphoreClose(_hSem))
    {
            
        ETG_TRACE_ERR(("dab_sem:vClose:OSAL_s32SemaphoreClose (%s) ERROR", oSemName.c_str()));
        _hSem = OSAL_C_INVALID_HANDLE;
        return;
    }
    _hSem = OSAL_C_INVALID_HANDLE;

    if(OSAL_ERROR  == OSAL_s32SemaphoreDelete(oSemName.c_str()))
    {               
        ETG_TRACE_ERR(("dab_sem:vClose:OSAL_s32SemaphoreDelete (%s) ERROR", oSemName.c_str()));	
            
    }
}
tVoid dab_sem::vGet() {
    if (_hSem == OSAL_C_INVALID_HANDLE) {
        return;
    }
    tS32 s32Ret = OSAL_s32SemaphoreWait( _hSem, OSAL_C_U32_INFINITE );
    if (OSAL_OK != s32Ret) {
        ETG_TRACE_ERR(("dab_sem:vGet: failed for Sem %s", oSemName.c_str()));
    }
}

tVoid dab_sem::vPost() {
    if (_hSem == OSAL_C_INVALID_HANDLE) {
        return;
    }
    tS32 s32Ret = OSAL_s32SemaphorePost( _hSem );
    if (OSAL_OK != s32Ret) {
        ETG_TRACE_ERR(("dab_sem:vPost: failed for Sem %s", oSemName.c_str()));
    }     
}
    

