/************************************************************************
 * FILE:        fc_dabtuner_messageHandlerCommon.hpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of fc_dabtuner_messageHandlerCommon
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/
 
// allow method-interface to dispatcher- and timer-functions
#ifndef DAB_MESSAGE_HANDLER_COMMON_HPP
#define DAB_MESSAGE_HANDLER_COMMON_HPP


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_UTIL_DISP
#include "trcGenProj/Header/fc_dabtuner_messageHandlerCommon.hpp.trc.h"
#endif

namespace DAB {

    /*
      Base-class that can be used for all message handlers instead of using
      DAB_MessageHandlerBase directly.
      The advantage of hiding the own class (MH) as template-paramter 
      when using dispatcher-functionality for
      - sending of messages
      - subscription of messages
      - creating events
      All Methods are templates using the actual message-type as parameter and will only be 
      instantiated if the method is realy used for a particular message.
    */    
    template <class MH>
    class DAB_MessageHandlerCommon:
        public DAB_MessageHandlerBase
    {
    protected:


    public:


    // #### interfaces to call decicated message-handler with message directly ####
    template<class D, class M>
    inline tVoid DAB_vCallMsg(D* pMh, M *pMsg) const {
        if (poGetDispatcher() != pMh->poGetDispatcher()) {
            return;
        }
        DAB_vTracePreCall(pMh, pMsg, DAB_enCallMode_Call);
        pMh->vProcess(pMsg);
        DAB_vTracePostCall(pMh);
    }

    template<class D, class M>
    inline tVoid DAB_vCallMsg(D* pMh, M &oMsg) const {
        DAB_vCallMsg(pMh, &oMsg);
    }

    // format that works on nucleus when the constructor of the message is used as argument
    template<class D, class M>
    inline tVoid DAB_vCallMsgCtor(D* pMh, M oMsg) const  {
        DAB_vCallMsg(pMh, &oMsg);
    }

    // #### interfaces to call subscribed message-handlers with message directly ####
    // handle msg directly
    template<class M>
    inline tVoid DAB_vCallMsg(M *pMsg) const {
        poGetDispatcher()->vNotify(poGetDispatcher(), pMsg);
    }

    inline tVoid DAB_vCallMsg(DAB_Message &roMsg) const {
        poGetDispatcher()->vNotify(poGetDispatcher(), &roMsg);
    }

    template<class M>
    inline tVoid DAB_vCallMsgCtor(M oMsg) const {
        poGetDispatcher()->vNotify(poGetDispatcher(), &oMsg);
    }



    // #### interface to post message to  decicated message-handler (only interface to communcate with MH in another thread) ####
    template<class D, class M>
    inline static void DAB_vPostMsg(D const *pMh, M *pMsg, DAB_tenMsgPrio enPrio=DAB_eMsgPrioNormal) {
        (tVoid)pMh;
        DAB_tclDispatcher* poDispatcher= pMh->poGetDispatcher();
        if (OSAL_NULL != poDispatcher) {
            pMh->poGetDispatcher()->vPostMsg(DAB_poGetMsgCaller<D,M>(), pMsg, enPrio);
        }
    }

    template<class D, class M>
    inline static void DAB_vPostMsgNoCopy(D const * pMh, M *pMsg, DAB_tenMsgPrio enPrio=DAB_eMsgPrioNormal) {
        (tVoid)pMh;
        pMh->poGetDispatcher()->vPostMsgNoCopy(DAB_poGetMsgCaller<D,M>(), pMsg, enPrio);
    }


    // #### interfaces to post message to all subsrcribed message handlers ####
    template<class M>
    inline void DAB_vPostMsg(M *pMsg, DAB_tenMsgPrio enPrio=DAB_eMsgPrioNormal) const {
        poGetDispatcher()->vPostMsg((DAB_MsgCallerBase *)OSAL_NULL, pMsg, enPrio);
    }

    // memory for pMsg has to be allocated by caller
    template<class M>
    inline void DAB_vPostMsgNoCopy(M *pMsg, DAB_tenMsgPrio enPrio) const {
        poGetDispatcher()->vPostMsgNoCopy((DAB_MsgCallerBase *)OSAL_NULL, pMsg, enPrio);
    }


        template<class M>
        static tVoid vSubscribe(tBool bFirst=FALSE) {
            DAB_vSubscribe<MH,M>(bFirst);
        }

        template<class M>
        static tVoid vUnSubscribe() {
            DAB_vUnSubscribe<MH,M>();
        }


#if 0
class DAB_tMsgPostCaller {
    list<DAB_tCallQEntry> lCalls;


    ~DAB_tMsgPostCaller() {
        vEmit();
    }

    template<class D, class M>
    tVoid vAdd()

    tVoid vClear() {
        DAB_FOREACH(list<DAB_tCallQEntry>, iter, lCalls) {
            OSAL_DELETE iter->pMsg;
        }
        lCalls.clear(); 
    }

    tVoid vEmit() {
        DAB_FOREACH(list<DAB_tCallQEntry>, iter, lCalls) {
            DAB_tCallQEntry &entry = *iter;
            DAB_vCallMsg(entry->poCaller);
            OSAL_DELETE entry.pMsg;
        }
        lCalls.clear();
     }
};
#endif

    protected:

        template<class M>
        DAB_tclEvent oRegisterEvent(M oMsg) {
            DAB_tclEvent oEvt;
            // GCC doesnt like the following statement
            //oEvt=poGetDispatcher()->poGetEvtMgr()->oRegister<MH,M>(&oMsg);

            DAB_tclDispatcher *poDispatcher=poGetDispatcher();
            DAB_tclEventMgr *pEvtMgr=poDispatcher->poGetEvtMgr();
            oEvt=pEvtMgr->oRegister<MH,M>(&oMsg);
            return oEvt;
        }


    };
}
#endif
