/************************************************************************
 * FILE:        fc_dabtuner_messageHandler.h
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of fc_dabtuner_messageHandler
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#ifndef FC_DABTUNER_MESSAGE_HANDLER_H
#define FC_DABTUNER_MESSAGE_HANDLER_H

#include "fc_dabtuner_assert.h"
#include "fc_dabtuner_message.h"

namespace DAB {
    class DAB_tclDispatcher; 
    extern  DAB_tclDispatcher *DAB_poDefaultDispatcher;

    extern tU32 DAB_u32CurTraceCheck;
    struct DAB_MhTraceInfo{
        tU16 u16TraceClass;
        tU32 u32LastTraceCheck;
        tBool bTraceActiveUsr1;
        tBool bTraceActiveUsr4;
        DAB_MhTraceInfo(tU16 u16TraceClass_=0):
            u16TraceClass(u16TraceClass_),
            u32LastTraceCheck(0xFFFFFFFF),
            bTraceActiveUsr1(FALSE),
            bTraceActiveUsr4(FALSE) 
        {}
    };


    class DAB_MessageHandlerBase {
    public:
        virtual ~DAB_MessageHandlerBase(){};
        virtual tVoid vInit() {};
        virtual tVoid vDeInit() {};
        virtual char const *pcGetName() const {return "unknown";};
        virtual tVoid vTraceState(tVoid) const {};
        virtual DAB_tclDispatcher *poGetDispatcher() const;
         

#if 0
        virtual DAB_MhTraceInfo &rGetTraceInfo() const { // todo: make pure virtual when all MHs are updated
            static DAB_MhTraceInfo rTraceInfo;
            return rTraceInfo;
        };
#else
        virtual DAB_MhTraceInfo &rGetTraceInfo() const =0;
#endif



        DAB_MhTraceInfo rCheckTraceLevel() const {
            DAB_MhTraceInfo &rTraceInfo=rGetTraceInfo();
            if (DAB_u32CurTraceCheck!=rTraceInfo.u32LastTraceCheck) {
                rTraceInfo.u32LastTraceCheck=DAB_u32CurTraceCheck;
                rTraceInfo.bTraceActiveUsr1=FALSE;
                rTraceInfo.bTraceActiveUsr4=FALSE;
                if (etg_bIsTraceActive(rTraceInfo.u16TraceClass, (tU16)TR_LEVEL_USER_1)) {
                    rTraceInfo.bTraceActiveUsr1=TRUE;
                    if (etg_bIsTraceActive(rTraceInfo.u16TraceClass, (tU16)TR_LEVEL_USER_4)) {
                        rTraceInfo.bTraceActiveUsr4=TRUE;
                    }
                }
            }
            return rTraceInfo;
        }

        tBool bDoTraceUsr1() const {
            return rCheckTraceLevel().bTraceActiveUsr1;
        }

        tBool bDoTraceUsr4() const {
            return rCheckTraceLevel().bTraceActiveUsr4;
        }





    };
}


#define DAB_TRACE_INFO_IMPL(TRACE_CLASS)                \
    virtual DAB::DAB_MhTraceInfo &rGetTraceInfo() const {   \
        static DAB::DAB_MhTraceInfo rTraceInfo(TRACE_CLASS);    \
        return rTraceInfo;                              \
    }

#endif
