/************************************************************************
 * FILE:        fc_dabtuner_message.h
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of fc_dabtuner_message
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#ifndef FC_DABTUNER_MESSAGE_H
#define FC_DABTUNER_MESSAGE_H

#include "fc_dabtuner_stl.h"

namespace DAB {
typedef enum {
    DAB_enCallMode_Call,
    DAB_enCallMode_CallAll,
    DAB_enCallMode_Post,
    DAB_enCallMode_PostAll,
    DAB_enCallMode_PostNoCopy,
    DAB_enCallMode_PostAllNoCopy,
    DAB_enCallMode_ExecPost,
    DAB_enCallMode_ExecPostAll
} DAB_tenCallMode;

class DAB_MessageHandlerBase;
class DAB_Message;
extern tVoid DAB_vTracePreCall(DAB_MessageHandlerBase const *pMh, DAB_Message const *pMsg, DAB_tenCallMode enCallMode);
extern tVoid DAB_vTracePostCall(DAB_MessageHandlerBase const *pMh);
 extern tBool DAB_bDoDispTraceUsr1();
 extern tBool DAB_bDoDispTraceUsr4();

#define DAB_DISPATCH_IMPL                                           \
    virtual list<DAB_MsgCallerBase *> *poGetSubscriberList() {return DAB::DAB_poGetSubscriberList(this);}; \


#define DAB_CLONE_IMPL(CLASS,BASE)              \
    virtual list<DAB_MsgCallerBase *> *poGetSubscriberList() {return DAB::DAB_poGetSubscriberList(this);}; \
    virtual tVoid vTrace(tVoid) const {               \
        DAB_vTraceClone(#CLASS);                \
        BASE::vTrace();                         \
    };                                          \
    CLASS(BASE const &oBaseMsg):BASE(oBaseMsg){};    \
    CLASS():BASE(){}


class DAB_MsgCallerBase;
class DAB_tclDispatcher;
class DAB_Message {
//Required changes for LCN2Kai Porting Start (SYA2HI)
    friend class DAB_tclDispatcher;
//Required changes for LCN2Kai Porting End (SYA2HI)
public:
    virtual ~DAB_Message(){};
    virtual tVoid vTrace() const {};

    //    virtual list<DAB_MsgCallerBase *> *poGetSubscriberList() {return &oDefaultSubscriberList; };
    virtual list<DAB_MsgCallerBase *> *poGetSubscriberList() =0;
 private:
    static list<DAB_MsgCallerBase *>oDefaultSubscriberList;
};

class DAB_MsgCallerBase {
public:
    DAB_MsgCallerBase() {
        _bActive=TRUE;
    }
    tVoid vCall(DAB_Message *pMsg, DAB_tenCallMode enCallMode=DAB_enCallMode_Call) {
        DAB_MessageHandlerBase *poMh=poGetTarget();
        tBool bDoTrace=DAB_bDoDispTraceUsr1();
        if (bDoTrace) {
            DAB_vTracePreCall(poMh, pMsg, enCallMode);
        }
        vCallShort(pMsg);
        if (bDoTrace) {
            DAB_vTracePostCall(poMh);
        }
    }
    virtual tVoid vCallShort(DAB_Message *pMsg)=0;
    virtual DAB_MessageHandlerBase *poGetTarget()=0;
    tBool _bActive;
};

template<class D, class M>
class DAB_MsgCaller: public DAB_MsgCallerBase {
 public:
    virtual tVoid vCallShort(DAB_Message *pMsg) {
        D::instance()->vProcess((M *)pMsg);
    }
    virtual DAB_MessageHandlerBase *poGetTarget() {
        return D::instance();
    }
};

template<class D, class M>
inline DAB_MsgCallerBase *DAB_poGetMsgCaller(tVoid) {
    static DAB_MsgCaller<D,M> oCaller;
    return &oCaller;
}


tVoid DAB_vTraceClone(char const *name);


template<class M>
inline list<DAB_MsgCallerBase *> *DAB_poGetSubscriberList() {
    static list<DAB_MsgCallerBase *> oSubscriberList;
    return &oSubscriberList;
}

template<class M>
list<DAB_MsgCallerBase *> *DAB_poGetSubscriberList(M* pMsg) {
    (tVoid)pMsg;
    return DAB::DAB_poGetSubscriberList<M>();
}

}
#endif
