/************************************************************************
 * FILE:        fc_dabtuner_gpio.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of fc_dabtuner_gpio
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#include "fc_dabtuner_trace.h"
#include "fc_dabtuner_gpio.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_UTIL
#include "trcGenProj/Header/fc_dabtuner_gpio.cpp.trc.h"
#endif

tBool DAB_tclGpio::_bDevGpioCreated = FALSE;

DAB_tclGpio::DAB_tclGpio(OSAL_tGPIODevID devId, char const *sMsg) {
        _sMsg =sMsg;
        _hGpio = OSAL_ERROR;
        _bOutput = FALSE;
        _s32ErrorCode = OSAL_OK;
        _rGpio.tId = 0;
        if (!(bCreateDevGpio())) {
            return;
        }
        _rGpio.tId = devId;
    }
    DAB_tclGpio::~DAB_tclGpio() {
        vClose();
        _hGpio = OSAL_ERROR;
        _sMsg = 0;

        _s32ErrorCode = static_cast<tS32>(OSAL_s32IOClose(_s32ErrorCode));
    }

    tBool DAB_tclGpio::bOpen() {
        _hGpio = OSAL_IOOpen("/dev/gpio",        /* tCString szName         */
                             OSAL_EN_READWRITE); /* OSAL_tenAccess enAccess */
        if (OSAL_ERROR == _hGpio)
        {
            ETG_TRACE_ERR(("DAB_tclGpio:%10s(%d): OSAL_IOOpen FAILED", _sMsg, _rGpio.tId));
            return FALSE;
        }
        return TRUE;
    }
    
    tBool DAB_tclGpio::bSet(tBool bHigh) {
        tBool bRes = FALSE;
        if (_hGpio == OSAL_ERROR) {
            return bRes;
        }
        _rGpio.unData.bState = bHigh;
        _s32ErrorCode = OSAL_s32IOControl (_hGpio, (tS32)OSAL_C_32_IOCTRL_GPIO_SET_STATE, (intptr_t)&_rGpio);
        if (OSAL_OK != _s32ErrorCode) {
            ETG_TRACE_ERR(("DAB_tclGpio:%10s(%d) bSet(bHigh=%d) FAILED", _sMsg, _rGpio.tId, bHigh));
        } 
        else {
            ETG_TRACE_ERR(("DAB_tclGpio:%10s(%d) bSet(bHigh=%d) OK", _sMsg, _rGpio.tId, bHigh));
            if (!_bOutput) {
                bRes = bSetDir(TRUE);
            }
        }
        return bRes;
    }

    tBool DAB_tclGpio::bSetDir(tBool bOut) {
        tBool bRes = FALSE;
        if (_hGpio == OSAL_ERROR) {
            return bRes;
        }
        if (OSAL_OK == _s32ErrorCode) {
            _s32ErrorCode = OSAL_s32IOControl(_hGpio, 
                                              bOut ? (tS32) OSAL_C_32_IOCTRL_GPIO_SET_OUTPUT : (tS32)OSAL_C_32_IOCTRL_GPIO_SET_INPUT,
                                              (intptr_t)&_rGpio);
            if (OSAL_OK != _s32ErrorCode) {
                ETG_TRACE_ERR(("DAB_tclGpio:%10s(%d) bSetDir(_bOutput=%d) FAILED", _sMsg, _rGpio.tId, _bOutput));
            }
            else {
                ETG_TRACE_ERR(("DAB_tclGpio:%10s(%d) bSetDir(_bOutput=%d) OK", _sMsg, _rGpio.tId, _bOutput));
                _bOutput = bOut; 
                bRes = TRUE;
            }
        } 
        return bRes;
    }

    tVoid DAB_tclGpio::vClose() {
        if (_hGpio == OSAL_ERROR) {
            return;
        }
        _s32ErrorCode = OSAL_s32IOClose(_hGpio); 
        if (OSAL_OK != _s32ErrorCode) {
            ETG_TRACE_ERR(("DAB_tclGpio:%10s(%d): OSAL_IOClose FAILED", _sMsg, _rGpio.tId));
        }
        _hGpio = OSAL_ERROR;
        _bOutput = FALSE;
    }


// private
tBool DAB_tclGpio::bCreateDevGpio() {
//        if (_bDevGpioCreated == TRUE) {
//            return TRUE;
//        }
        /*=========================================================================*/
        /* open device: /dev/gpio                                                  */
        /*-------------------------------------------------------------------------*/
        _s32ErrorCode = (tS32)(OSAL_IOCreate("/dev/gpio",
                                      OSAL_EN_READWRITE));
        
        if (OSAL_OK == _s32ErrorCode)
        {
            _bDevGpioCreated = TRUE;
        } 
        else {
            ETG_TRACE_ERR(("DAB_tclGpio:bCreateDevGpio FAILED"));
        }
        return _bDevGpioCreated;
    }

