/************************************************************************
 * FILE:        fc_dabtuner_dispatcher.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of fc_dabtuner_dispatcher
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#include "fc_dabtuner_dispatcher.hpp"
#ifdef DIE
#error
#endif
#include "fc_dabtuner_messageHandlerCommon.hpp"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_UTIL_DISP 
#include "trcGenProj/Header/fc_dabtuner_dispatcher.cpp.trc.h"
#endif


using namespace DAB;
DAB_TraceChecker<FC_DABTUNER_TR_UTIL_DISP> DAB_tclDispatcher::_oTraceChecker;
namespace DAB {
    DAB_tclDispatcher *DAB_poDefaultDispatcher=OSAL_NULL;
    tU32 DAB_tclDispatcher::_u32NumInstances=0;
    dab_sem DAB_tclDispatcher::_oSubscrQSem;
	tU32 DAB_u32CurTraceCheck=0;


    tBool DAB_bDoDispTraceUsr1() {
        return DAB_tclDispatcher::_oTraceChecker.bDoTraceUsr1();
    }

    tBool DAB_bDoDispTraceUsr4() {
        return DAB_tclDispatcher::_oTraceChecker.bDoTraceUsr4();
    }


    tVoid DAB_vTracePreCall(DAB_MessageHandlerBase const *pMh, DAB_Message const *pMsg, DAB_tenCallMode enCallMode) {
        if (DAB_tclDispatcher::_oTraceChecker.bDoTraceUsr1()) {
            if (OSAL_NULL != pMh) {
                if (pMh->bDoTraceUsr4()) {
                    ETG_TRACE_USR1(("calling(%d) %s with msg:", 
                                    ETG_CENUM(DAB_tenCallMode, enCallMode),
                                    pMh->pcGetName()));
                    pMh->vTraceState();
                    pMsg->vTrace();            
                }
            }        
        
            else {
                ETG_TRACE_USR1(("calling(%d) with msg:", 
                                ETG_CENUM(DAB_tenCallMode, enCallMode)));
                pMsg->vTrace();            
            }
        }
    }

    tVoid DAB_vTracePostCall(DAB_MessageHandlerBase const *pMh) {
        if (OSAL_NULL != pMh) {
            if (DAB_tclDispatcher::_oTraceChecker.bDoTraceUsr1()) {
                if (pMh->bDoTraceUsr4()) {
                    pMh->vTraceState();
                }
            }
        }
    }

    // todo: move to fc_dabtuner_messageHandler.hpp
    DAB_tclDispatcher *DAB_MessageHandlerBase::poGetDispatcher() const {
        DAB_ASSERT_RETURN_VAL(DAB_poDefaultDispatcher, OSAL_NULL);
        ETG_TRACE_USR4(("poGetDispatcher[%d] of %s",
                        DAB_poDefaultDispatcher->u32GetInstanceId(),
                        pcGetName()));
        return DAB_poDefaultDispatcher;
    }

}
