/************************************************************************
 * FILE:        fc_dabtuner_MhQ.h
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of fc_dabtuner_MhQ
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#ifndef FC_DABTUNER_MH_Q_HPP
#define FC_DABTUNER_MH_Q_HPP
#include "fc_dabtuner_assert.h"
#include "fc_dabtuner_stl.h"
#include "../srv/fc_dabtuner_trace.h"
#include "fc_dabtuner_messageHandler.h"
#include "fc_dabtuner_profiler.h"
namespace DAB {
class MhQ {
    
 public:
    //lint -esym(1551, DAB::MhQ::~MhQ) prio3 Function may throw exception '...' in destructor
    ~MhQ() {
        vClear();
    };
    tVoid vClear(tVoid) {
        //lint -save -esym(1702, operator!=) both member and non-member ops
        DAB_Profiler rProfiler("MhQClear");
        for (deque<DAB_MessageHandlerBase*>::reverse_iterator iter = _oMhQ.rbegin(); iter!=_oMhQ.rend();++iter) {
            if (OSAL_NULL != *iter) {
                vTrace(enMhQAction_Delete, *iter);
                                       rProfiler.u32GetMs();

                OSAL_DELETE *iter;
                rProfiler.u32GetMs();

            }
        }
        //lint -restore
        _oMhQ.clear();   
    };
    
    tVoid vInit() {
        //lint -save -esym(1702, operator!=) both member and non-member ops
        for (deque<DAB_MessageHandlerBase*>::iterator iter = _oMhQ.begin(); iter!=_oMhQ.end();++iter) {
            if (OSAL_NULL != *iter) {
                DAB_Profiler rProfiler((*iter)->pcGetName());
                vTrace(enMhQAction_Init, *iter);
                (*iter)->vInit();
                rProfiler.u32GetMs();

            }
        }
        //lint -restore
    }

    tVoid vDeInit() {
        //lint -save -esym(1702, operator!=) both member and non-member ops
        for (deque<DAB_MessageHandlerBase*>::reverse_iterator iter = _oMhQ.rbegin(); iter!=_oMhQ.rend();++iter) {
            if (OSAL_NULL != *iter) {
                DAB_Profiler rProfiler((*iter)->pcGetName());
                vTrace(enMhQAction_DeInit, *iter);
                (*iter)->vDeInit();
                rProfiler.u32GetMs();
            }
        }
        //lint -restore
    }

    tVoid poAdd(DAB_MessageHandlerBase *pMh) {
        static DAB_Profiler rProfiler("MhqAdd");
        vTrace(enMhQAction_Add, pMh);
        _oMhQ.push_back(pMh);
        rProfiler.u32GetMs();

    };
 private:
    typedef enum {
        enMhQAction_Add,
        enMhQAction_Init,
        enMhQAction_DeInit,
        enMhQAction_Delete
    } tenMhQAction;
    tVoid vTrace(tenMhQAction enAction, DAB_MessageHandlerBase const *pMh) const;
    deque<DAB_MessageHandlerBase*>_oMhQ;
    
};

} // namespace DAB

#endif
