/************************************************************************
* FILE:         fc_dabtuner_ServiceBase.h
* PROJECT:      g3g
* SW-COMPONENT: FC_DABTUNER
*----------------------------------------------------------------------
*
* DESCRIPTION: Definition of generic handlers to send method result,
 *         service handlers, update clients, send status message to clients.
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      	| Author                      | Modification
* 06.11.2009    | Ruchi Mishra(RBEI/ECG3)      |  Original version
*
*************************************************************************/



// todo remove lint, should work from fc_dabtuner_config.h
//lint -e1712 "default constructor not defined for class"
//lint -e1704 "Constructor ... has private access specification"
#ifndef DAB_SERVICE_BASE_H_
#define DAB_SERVICE_BASE_H_

#include "fc_dabtuner_util.h"
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"  // empty message U8-message etc.

#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#include "fc_dabtuner_cca.h"


// ############## macros to be used in message-map ##############
// fid that only supports GET

#define ON_DAB_PGET(fid, fiPGet) \
    case fid:\
    pClass->DAB_SrvGetFn<className, fiPGet>(pMsg); \
    break;

// fid that supports GET, UPREG, RELUPREG
#define ON_DAB_PUPRGET(fid, fiPGet) \
    case fid:\
    pClass->DAB_SrvUprGetFn<className, fiPGet>(pMsg); \
    break;

// fid that supports GET, SET,  UPREG, RELUPREG
#define ON_DAB_PUPRGETSET(fid, fiPGet) \
    case fid:\
    pClass->DAB_SrvUprGetSetFn<className, fiPGet, fiPSet>(pMsg); \
    break;

// fid only supports upreg
#define ON_DAB_PUPR(fid)                                   \
    case fid:\
    pClass->DAB_SrvUprFn(pMsg); \
    break;

// fid only supports upreg with dedicated handlers for the upreg and the relUpReg Msg
#define ON_DAB_PUPR_LONG(fid, fiPUpr, fiPRelUpr)                                   \
    case fid:\
    pClass->DAB_SrvUprLongFn<className, fiPUpr, fiPRelUpr>(pMsg); \
    break;

#define ON_DAB_PUPR_GET_LONG(fid, fiPUpr, fiPRelUpr, fiPGet)               \
    case fid:\
    pClass->DAB_SrvUprGetLongFn<className, fiPUpr, fiPRelUpr, fiPGet>(pMsg);   \
    break;

// fid only supports method start.
#define ON_DAB_MSTART(fid, fiMStart) \
    case fid:\
    pClass->DAB_SrvMStartFn<className, fiMStart>(pMsg);   \
    break;

#define DAB_APPID_ALL 0xFFFF
/*
for methods the will send a result later, the requestDetails have to be stored.
You may 

*/

namespace DAB {

        






    
    //lint -esym(1712, trSrvFidData) prio3 prio3: default constructor not defined
    // for each fid a list of clients registered via upreg can be stored.
    struct trSrvFidData {
        list<trAdressing> _lClients;
    };

    //lint -esym(1712, trAppIdFinder) prio3 prio3: default constructor not defined
    struct trAppIdFinder {
        trAppIdFinder(tU16 u16AppId) {_u16AppId=u16AppId;};
        bool operator()(const trAdressing &roAdressing) const {
            return _u16AppId==roAdressing._u16AppId;
        }
        private:
        tU16 _u16AppId; 
    };

    //lint -esym(1712, trRegIdFinder) prio3 prio3: default constructor not defined
    struct trRegIdFinder {
        trRegIdFinder(tU16 u16RegId) {_u16RegId=u16RegId;};
        bool operator()(const trAdressing &roAdressing) const {
            return _u16RegId==roAdressing._u16RegId;
        }
        private:
        tU16 _u16RegId; 
    };


    // struct that has to be provided by derived class
    struct trServerConfig {
        trServerConfig(tU16 u16ServiceId, 
                       tU16 u16AppId, 
                       char const *pcName,
                       tU16 u16MajorVersion, 
                       tU16 u16MinorVersion=0,
                       tU16 u16PatchVersion=0);
        
        tU16 _u16ServiceId;
        tU16 _u16AppId;
        char const *_pcName;
        dab_sem _oNotSem;
        tU16 _u16MajorVersion;
        tU16 _u16MinorVersion;
        tU16 _u16PatchVersion;
        tBool _bAvail;

        map<tU16, trSrvFidData> _mapFidData;
    };


    class DAB_ServiceBase:public ahl_tclBaseWork {
public:
   DAB_ServiceBase();
   virtual ~DAB_ServiceBase();

   virtual tBool bGetServiceVersion (tU16& rfu16MajorVersion, tU16& rfu16MinorVersion, tU16& rfu16PatchVersion);
   tVoid vUnregisterRegId(tU16 u16RegId);
   virtual tVoid vInit();
   virtual tU16 u16GetServiceId();
   virtual tVoid vOnNewAppState(tU32 u32AppState)=0;

   virtual tVoid vDispatchMessage_(amt_tclServiceData *pMsg) = 0;


   // #### templates for function-id-handler
   // ### fid handles only GET
    template<class S, class MGET>
        tVoid DAB_SrvGetFn(amt_tclServiceData* poMessage) {
        trAdressing rAdressing(poMessage);
        switch(poMessage->u8GetOpCode()) {
            case AMT_C_U8_CCAMSG_OPCODE_GET: {
                MGET oRxFIObj;
                fi_tclVisitorMessage oMsg( poMessage );
                oMsg.s32GetData( oRxFIObj );
                S::instance()->vHandleFi(rAdressing,&oRxFIObj);
                break;
            }
        default:
            vSendError(&rAdressing,CCA_C_U16_ERROR_OPCODE_NOT_SUPPORTED);
            break;
        }
    }

    // ### fid handles only UPREG und RELUPREG
    // no handlers have to be provided.
    //lint -esym(818, poMessage)
    tVoid DAB_SrvUprFn(amt_tclServiceData* poMessage) {
        trAdressing rAdressing(poMessage);
        switch(poMessage->u8GetOpCode()) {
            case AMT_C_U8_CCAMSG_OPCODE_UPREG: {
                vStoreNotification(&rAdressing);
                break;
            }
            case AMT_C_U8_CCAMSG_OPCODE_RELUPREG: {
                vReleaseNotification(rAdressing._u16AppId, rAdressing._u16Fid);
            }
                break;
            default:
                vSendError(&rAdressing,CCA_C_U16_ERROR_OPCODE_NOT_SUPPORTED);
                break;

        }
    }

    // ### fid handles only UPREG und RELUPREG
    // handlers for UPREG and RELUPREG have to be provided.
    template<class S, class MUPR, class MRELUPR>
        tVoid DAB_SrvUprLongFn(amt_tclServiceData* poMessage) {
        trAdressing rAdressing(poMessage);
        switch(poMessage->u8GetOpCode()) {
            case AMT_C_U8_CCAMSG_OPCODE_UPREG: {
                vStoreNotification(&rAdressing);
                MUPR oRxFIObj;
                fi_tclVisitorMessage oMsg( poMessage );
                oMsg.s32GetData( oRxFIObj );
                S::instance()->vHandleFi(rAdressing,&oRxFIObj);
                break;
            }
            case AMT_C_U8_CCAMSG_OPCODE_RELUPREG: {
                vReleaseNotification(rAdressing._u16AppId, rAdressing._u16Fid);
                MRELUPR oRxFIObj;
                fi_tclVisitorMessage oMsg( poMessage );
                oMsg.s32GetData( oRxFIObj );
                S::instance()->vHandleFi(rAdressing,&oRxFIObj);
                break;
            }
            default:
                vSendError(&rAdressing,CCA_C_U16_ERROR_OPCODE_NOT_SUPPORTED);
                break;

        }
    }

    // ### fid handles only UPREG und RELUPREG and GET
    // handlers for UPREG and RELUPREG and GET have to be provided.
    template<class S, class MUPR, class MRELUPR, class MGET>
        tVoid DAB_SrvUprGetLongFn(amt_tclServiceData* poMessage) {
        trAdressing rAdressing(poMessage);
        switch(poMessage->u8GetOpCode()) {
            case AMT_C_U8_CCAMSG_OPCODE_UPREG: {
                vStoreNotification(&rAdressing);
                MUPR oRxFIObj;
                fi_tclVisitorMessage oMsg( poMessage );
                oMsg.s32GetData( oRxFIObj );
                S::instance()->vHandleFi(rAdressing,&oRxFIObj);
                break;
            }
            case AMT_C_U8_CCAMSG_OPCODE_RELUPREG: {
                vReleaseNotification(rAdressing._u16AppId, rAdressing._u16Fid);
                MRELUPR oRxFIObj;
                fi_tclVisitorMessage oMsg( poMessage );
                oMsg.s32GetData( oRxFIObj );
                S::instance()->vHandleFi(rAdressing,&oRxFIObj);
                break;
            }
            case AMT_C_U8_CCAMSG_OPCODE_GET: {
                MGET oRxFIObj;
                fi_tclVisitorMessage oMsg( poMessage );
                oMsg.s32GetData( oRxFIObj );
                S::instance()->vHandleFi(rAdressing,&oRxFIObj);
                break;
            }

            default:
                vSendError(&rAdressing,CCA_C_U16_ERROR_OPCODE_NOT_SUPPORTED);
                break;

        }
    }


    // ### fid handles GET and UPREG
    template<class S, class MGET>
        tVoid DAB_SrvUprGetFn(amt_tclServiceData* poMessage) {
        trAdressing rAdressing(poMessage);
        switch(poMessage->u8GetOpCode()) {
            case AMT_C_U8_CCAMSG_OPCODE_UPREG:
			case AMT_C_U8_CCAMSG_OPCODE_GET: {
				if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_UPREG) {
					vStoreNotification(&rAdressing);
				}
				MGET oRxFIObj;
				fi_tclVisitorMessage oMsg(poMessage);
				oMsg.s32GetData(oRxFIObj);
				S::instance()->vHandleFi(rAdressing, &oRxFIObj);
				break;
            }
            case AMT_C_U8_CCAMSG_OPCODE_RELUPREG: {
                vReleaseNotification(rAdressing._u16AppId, rAdressing._u16Fid);
                break;
            }
            default:
                vSendError(&rAdressing,CCA_C_U16_ERROR_OPCODE_NOT_SUPPORTED);
                break;

        }
    }

    // ### fid handles GET, SET and UPREG
template<class S, class MGET, class MSET>
        tVoid DAB_SrvUprGetSetFn(amt_tclServiceData* poMessage) {
        trAdressing rAdressing(poMessage);
        switch(poMessage->u8GetOpCode()) {
            case AMT_C_U8_CCAMSG_OPCODE_UPREG: {
                vStoreNotification(&rAdressing);
                // no break
            }
            case AMT_C_U8_CCAMSG_OPCODE_GET: {
                MGET oRxFIObj;
                fi_tclVisitorMessage oMsg( poMessage );
                oMsg.s32GetData( oRxFIObj );
                S::instance()->vHandleFi(rAdressing,&oRxFIObj);
                break;
            }
            case AMT_C_U8_CCAMSG_OPCODE_SET: {
                MSET oRxFIObj;
                fi_tclVisitorMessage oMsg( poMessage );
                oMsg.s32GetData( oRxFIObj );
                S::instance()->vHandleFi(rAdressing,&oRxFIObj);
                break;
            }
            case AMT_C_U8_CCAMSG_OPCODE_RELUPREG: {
                vReleaseNotification(rAdressing._u16AppId, rAdressing._u16Fid);
                break;
            }
            default:
                vSendError(&rAdressing,CCA_C_U16_ERROR_OPCODE_NOT_SUPPORTED);
                break;

        }
    }

    // ### fid handles METHODSTART
    template<class S, class MSTART>
        tVoid DAB_SrvMStartFn(amt_tclServiceData* poMessage) {
        trAdressing rAdressing(poMessage);
        switch(poMessage->u8GetOpCode()) {
            case AMT_C_U8_CCAMSG_OPCODE_METHODSTART: {
                MSTART oRxFIObj;
                fi_tclVisitorMessage oMsg( poMessage );
                oMsg.s32GetData( oRxFIObj );
                S::instance()->vHandleFi(rAdressing,&oRxFIObj);
                break;
            }
        default:
            vSendError(&rAdressing,CCA_C_U16_ERROR_OPCODE_NOT_SUPPORTED);
            break;
        }
    }


protected:
   virtual DAB::trServerConfig &roGetConfig()=0;

   tVoid vDeInitServiceBase();
   virtual tVoid vOnUnknownMessage(amt_tclBaseMessage* poMessage);

   ail_tenCommunicationError enSendFiMessage(trAdressing const *prAdressing, fi_tclMessageBase const & roSendFiObj);
   tVoid vNotify(fi_tclMessageBase const & roSendFiObj);
   tVoid vNotifyOnce(fi_tclMessageBase const & roSendFiObj);
   tVoid vStoreNotification(trAdressing const *prAdressing);
   tVoid vReleaseNotification(tU16 u16AppId, tU16 u16Fid=0);
   tVoid vSetAvailability(tBool bAvail);
   tVoid vSendError(trAdressing const *prAdressing, tU8 u8ErrorCode);

 private:
   tVoid  vTraceRequest(tPCChar name, trAdressing const *prAdressing);

};

} // namespace DAB

#endif
