/************************************************************************
* FILE:         fc_dabtuner_mainProxy.cpp
* PROJECT:      g3g
* SW-COMPONENT: FC_DABTUNER
*----------------------------------------------------------------------
*
* DESCRIPTION:  Implementation of fc_dabtuner_mainProxy
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author                      | Modification

*
*************************************************************************/

#include "fc_dabtuner_mainProxy.h"
#include "fc_dabtuner_main.h"
namespace DAB {

    tU16 DAB_mainProxy::u16RegisterService(tU16 u16ServiceId,
                                               tU16 u16MajorVersion,
                                           tU16 u16MinorVersion,
                                           tU16 u16ServerAppId) {
        return fc_dabtuner_tclApp::instance()->u16RegisterService(u16ServiceId, u16MajorVersion, u16MinorVersion, 0, u16ServerAppId);
    }
    tVoid DAB_mainProxy::vUnregisterService(tU16 u16ServiceId,
                                            tU16 u16ServerAppId) {
        return fc_dabtuner_tclApp::instance()->vUnregisterService(u16ServiceId, u16ServerAppId);
    }

    ail_tenCommunicationError DAB_mainProxy::enPostMsg(amt_tclServiceData* poMessage) {
        return fc_dabtuner_tclApp::instance()->enPostMsg(poMessage);

    }

    tVoid DAB_mainProxy::vServiceAvailabilityChanged(tU16 u16ServiceId, tU8 u8ServiceState) {
        fc_dabtuner_tclApp::instance()->vServiceAvailabilityChanged(u16ServiceId, u8ServiceState);
    }

    // in fc_dabtuner_tclApp we only send messages to self, so reg-id can always be 0
    tU16 DAB_mainProxy::u16GetRegId(tU16 /*u16ServiceId*/) {
        return 0;
        //       return fc_dabtuner_tclApp::instance()->u16GetRegId(u16ServiceId);
    }
    tBool DAB_mainProxy::bRegisterAsync(tU16 u16ServiceId, tU16 u16ServiceMajorVersion, tU16 u16ServiceMinorVersion,tU16 u16ServerAppId )
    {
    	return fc_dabtuner_tclApp::instance()->bRegisterAsync(u16ServiceId,u16ServiceMajorVersion,u16ServiceMinorVersion,0,u16ServerAppId);
    }

}
