/************************************************************************
* FILE:         fc_dabtuner_main.h
* PROJECT:      g3g
* SW-COMPONENT: FC_DABTUNER
*----------------------------------------------------------------------
*
* DESCRIPTION: DABTuner main application class
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author                      | Modification
* 14.06.07  | CM-DI/PJ-VW36-Liebanas      | initial version
*
*************************************************************************/

#ifndef _DABTUNER_MAIN_H_
#define _DABTUNER_MAIN_H_

#define VARIANT_S_FTR_ENABLE_DABTUNER
#ifndef VARIANT_S_FTR_ENABLE_DABTUNER
#include "fc_dabtuner_mainDummy.h"
#else 
//------------------------------------------------------------------------------
// defines
//------------------------------------------------------------------------------
#define FC_DABTUNER_FUNCARRAY_SIZE    60 //TODO: how many functions offered by this server
#define FC_DABTUNER_NOTARRAY_SIZE     120 //TODO: how many registrations are accepted

//#ifndef CCA_C_U16_APP_FC_DABTUNER
//#define CCA_C_U16_APP_FC_DABTUNER 0x2e //-> actually defined somewhere else
//#endif //CCA_C_U16_APP_FC_DABTUNER

//#ifndef FC_DABTUNER_FILE_NUMBER
//  #define FC_DABTUNER_FILE_NUMBER 0x00ff // should be overwritten on cpp-Files, else error
//#endif

//-----------------------------------------------------------------------------
// includes
//-----------------------------------------------------------------------------
#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"         // use AIL template with MessageMaps

#define AHL_S_IMPORT_INTERFACE_NOTIFICTABLE
#include "ahl_if.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "../util/fc_dabtuner_singleton.h"
#include "../util/fc_dabtuner_MhQ.h"
#include "../util/fc_dabtuner_sem.h"



#define DABTUNER_NOTTABLE_SEM_NAME      "DABTUNER_NOTTABLESEM"
#define DABTUNER_PROCESSMSG_SEM_NAME    "DABTUNER_PROCESSMSGSEM"

#ifdef VARIANT_S_FTR_ENABLE_AARSPROXY
class tuner_gio_dbus_handler;
class tuner_gio_dbus_aarsproc_proxy;
#endif

namespace DAB {
    //fc_dabtuner_tclCCAService is server for hmi 
    class fc_dabtuner_tclCCAService;
    //fc_dabtuner is client of VD_diaglog 
    class fc_dabtuner_clientDiagLog;
    //send wire msg command to radiounit
    class fc_dabtuner_tclTrace;
    class DAB_ServiceBase;
    class DAB_ClientBase;
}

// message-dispatching utility
//lint -esym(763, DAB_tclDispatcher) prio3 Redundantly declared symbol
namespace DAB {
    //class DAB_tclDispatcher;
}
//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------
class fc_dabtuner_tclApp : 
public ail_tclAppInterface,
    public DAB_Singleton <fc_dabtuner_tclApp>
{
private:
   
        friend class DAB_Singleton<fc_dabtuner_tclApp>;

	static tBool m_bAppClosed;

    //lint -esym(1704, fc_dabtuner_tclApp::fc_dabtuner_tclApp) prio3 constructor has private access specification
	fc_dabtuner_tclApp& operator=(const fc_dabtuner_tclApp& c); //this function must not be used, therefore it is private
	fc_dabtuner_tclApp(const fc_dabtuner_tclApp& c); //this function must not be used, therefore it is private


    tVoid vFreeMem();

    DAB::MhQ _oMhQ;
    deque<DAB::DAB_ServiceBase *> _qServices;
    deque<DAB::DAB_ClientBase *> _qClients;

    dab_sem _oProcessingSem;

#ifdef VARIANT_S_FTR_ENABLE_AARSPROXY
   tuner_gio_dbus_handler*	m_pGioDbusHandler;
#endif

protected:
	virtual tBool bGetServiceVersion (tU16 u16ServiceID,tU16& rfu16MajorVersion,
										tU16& rfu16MinorVersion,tU16& rfu16PatchVersion);
public:

	// construction/destruction
	fc_dabtuner_tclApp(); // constructor
	virtual ~fc_dabtuner_tclApp(); // destructor
    virtual char const *pcGetName() const {return "fc_dabtuner_tclApp";};

	static OSAL_tSemHandle    m_hProcessingSem;
    tBool _bDabEnable;

	// method to create server object - called by SPM
	static fc_dabtuner_tclApp* theServer(); 
   
	//standard functions
    virtual tBool bOnInit();
    virtual tVoid vOnServiceState (tU16 u16ServiceId,tU16 u16ServerId,tU16 u16RegisterId,
									tU8 u8ServiceState,tU16 u16SubId);
	virtual tVoid vOnNewAppState (tU32 u32OldAppState,tU32 u32AppState);  
	virtual tVoid vOnNewMessage (amt_tclBaseMessage* poMessage);
	
	virtual tBool bOnWatchdog();
	virtual tVoid vOnApplicationClose();

    virtual tVoid vOnUnregister (tU16 u16ServiceId, tU16 u16RegisterId);

    tVoid vOnAppStateReached(tU32 u32AppState);
   
    ail_tenCommunicationError enPostMsg(amt_tclServiceData* poMessage) const;
	/* +++ Enter your public Data and functions here +++ */
	
    tU32 _u32OldAppState; 
    tU32 _u32AppState;  

#ifdef VARIANT_S_FTR_ENABLE_AARSPROXY
	tuner_gio_dbus_handler*	poDBus() {return m_pGioDbusHandler;}
#endif
}; 

#endif
#endif //_DABTUNER_MAIN_H_

