
/************************************************************************
* FILE:         fc_dabtuner_clientSpm.h
* PROJECT:      g3g
* SW-COMPONENT: DAB Tuner
*----------------------------------------------------------------------
*
* DESCRIPTION:  Implementation of fc_dabtuner_clientSpm
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author             | Modification

*
*************************************************************************/

#ifndef FC_DABTUNER_CLIENT_SPM_H
#define FC_DABTUNER_CLIENT_SPM_H

#include "fc_dabtuner_clientBase.h"
#include "dabdrv_adrIf.hpp"
#ifdef VARIANT_S_FTR_ENABLE_NEW_SPM_CORE_FI
	#define SPM_SYSTEM_STATE_STANDBY                    spm_fi_tcl_SPM_e32_TUNER_STATE::FI_EN_SPM_U32_TUNER_LANDSCAPE_SCAN
	#define SPM_SYSTEM_STATE_OFF                        spm_fi_tcl_SPM_e32_TUNER_STATE::FI_EN_SPM_U32_TUNER_OFF
	#define SPM_SYSTEM_STATE_ON                         spm_fi_tcl_SPM_e32_TUNER_STATE::FI_EN_SPM_U32_TUNER_ON
	
	#define CVM_CRITICAL_LOW_VOLTAGE_START				spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_CRITICAL_LOW_VOLTAGE_START
	#define CVM_CRITICAL_LOW_VOLTAGE_END				spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_CRITICAL_LOW_VOLTAGE_END
	#define CVM_LOW_VOLTAGE_START						spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_LOW_VOLTAGE_START
	#define CVM_LOW_VOLTAGE_END							spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_LOW_VOLTAGE_END
	#define CVM_HIGH_VOLTAGE_START						spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_HIGH_VOLTAGE_START
	#define CVM_HIGH_VOLTAGE_END						spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_HIGH_VOLTAGE_END
	#define CVM_CRITICAL_HIGH_VOLTAGE_START				spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_CRITICAL_HIGH_VOLTAGE_START
	#define CVM_CRITICAL_HIGH_VOLTAGE_END				spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_CRITICAL_HIGH_VOLTAGE_END
	#define CVM_NO_EVENT								spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_NO_EVENT
	class spm_corefi_tclMsgCvmEventStatus;
	class spm_corefi_tclMsgTunerStateStatus;
	class spm_corefi_tclMsgRestartProcessMethodResult;
#else
	#define SPM_SYSTEM_STATE_STANDBY                    cfc_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_STANDBY
	#define SPM_SYSTEM_STATE_OFF                        cfc_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_OFF
	#define SPM_SYSTEM_STATE_ON                         cfc_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_ON
	
	#define CVM_CRITICAL_LOW_VOLTAGE_START				cfc_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_CRITICAL_LOW_VOLTAGE_START
	#define CVM_CRITICAL_LOW_VOLTAGE_END				cfc_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_CRITICAL_LOW_VOLTAGE_END
	#define CVM_LOW_VOLTAGE_START						cfc_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_LOW_VOLTAGE_START
	#define CVM_LOW_VOLTAGE_END							cfc_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_LOW_VOLTAGE_END
	#define CVM_HIGH_VOLTAGE_START						cfc_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_HIGH_VOLTAGE_START
	#define CVM_HIGH_VOLTAGE_END						cfc_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_HIGH_VOLTAGE_END
	#define CVM_CRITICAL_HIGH_VOLTAGE_START				cfc_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_CRITICAL_HIGH_VOLTAGE_START
	#define CVM_CRITICAL_HIGH_VOLTAGE_END				cfc_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_CRITICAL_HIGH_VOLTAGE_END
	#define CVM_NO_EVENT								cfc_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_NO_EVENT
	class cfc_spmfi_tclMsgCvmEventStatus;
#endif

namespace DAB {

class fc_dabtuner_clientSpm : 
    public DAB_Singleton <fc_dabtuner_clientSpm>,
    public DAB_MessageHandlerCommon<fc_dabtuner_clientSpm>,
    public DAB::DAB_ClientBase
{
        friend class DAB_Singleton<fc_dabtuner_clientSpm>;


 public:
        DAB_TRACE_INFO_IMPL(FC_DABTUNER_TR_CLIENT);
        virtual char const *pcGetName() const {return "fc_dabtuner_clientSpm";};
        virtual tVoid vDispatchMessage_(amt_tclServiceData *pMsg);
#ifdef VARIANT_S_FTR_ENABLE_NEW_SPM_CORE_FI
        tVoid vHandleFi(DAB::trAdressing const &roAdressing, spm_corefi_tclMsgCvmEventStatus *pMsg);
		tVoid vHandleFi(DAB::trAdressing const &roAdressing, spm_corefi_tclMsgRestartProcessMethodResult *pMsg);
		virtual tVoid vProcess(DAB::trMsgRestartSBRProcess *potrMsgRestartSBRProcess);
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
		tVoid vHandleFi(trAdressing const &roAdressing, spm_corefi_tclMsgTunerStateStatus *pMsg);
#endif
#else
		tVoid vHandleFi(DAB::trAdressing const &roAdressing, cfc_spmfi_tclMsgCvmEventStatus *pMsg);
#endif


 protected:
        virtual DAB::trClientConfig &roGetConfig();
        DAB::trClientConfig oClientConfig;
        static tU16 _cau16FIDs[];
 private:
        fc_dabtuner_clientSpm();
        tBool _bCritLowVoltageDetected;
};
}
#endif
