
/************************************************************************
* FILE:         fc_dabtuner_clientSpm.cpp
* PROJECT:      g3g
* SW-COMPONENT: DAB Tuner
*----------------------------------------------------------------------
*
* DESCRIPTION:  Implementation of fc_dabtuner_clientSpm
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author             | Modification

*
*************************************************************************/

#include "fc_dabtuner_util.h"
#include "fc_dabtuner_clientSpm.h"
#include "dabdrv_types.hpp"
#include "dabdrv_mecaIf.h"
#include "dabdrv_learn.hpp"

#ifdef VARIANT_S_FTR_ENABLE_NEW_SPM_CORE_FI
	#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
	#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_TYPES
	#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_FUNCTIONIDS
	#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_SERVICEINFO
	#include "spm_fi_if.h"
#else	
	#define CFC_FI_S_IMPORT_INTERFACE_CFC_SPMFI_STDVISITORS
	#define CFC_FI_S_IMPORT_INTERFACE_CFC_SPMFI_FUNCTIONIDS
	#define CFC_FI_S_IMPORT_INTERFACE_CFC_SPMFI_SERVICEINFO
	#include "cfc_fi_if.h"
#endif

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_CLIENT
#include "trcGenProj/Header/fc_dabtuner_clientSpm.cpp.trc.h"
#endif

using namespace DAB;

//lint -esym(1762, fc_dabtuner_clientSpm::vHandle*)
tU16 fc_dabtuner_clientSpm::_cau16FIDs[] = 
{
#ifdef VARIANT_S_FTR_ENABLE_NEW_SPM_CORE_FI
	SPM_COREFI_C_U16_TUNERSTATE,
	SPM_COREFI_C_U16_CVMEVENT,
	SPM_COREFI_C_U16_RESTARTPROCESS
#else
	CFC_SPMFI_C_U16_SYSTEMSTATE,
	CFC_SPMFI_C_U16_CVMEVENT
#endif
};

//BEGIN_MSG_MAP(fc_dabtuner_clientSpm, ahl_tclBaseWork)
DAB_BEGIN_MSG_MAP(fc_dabtuner_clientSpm)
#ifdef VARIANT_S_FTR_ENABLE_NEW_SPM_CORE_FI
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
	ON_DAB_PSTATUS( SPM_COREFI_C_U16_TUNERSTATE,  spm_corefi_tclMsgTunerStateStatus)
#endif
	ON_DAB_MRESULT( SPM_COREFI_C_U16_RESTARTPROCESS, spm_corefi_tclMsgRestartProcessMethodResult)
	ON_DAB_PSTATUS( SPM_COREFI_C_U16_CVMEVENT, spm_corefi_tclMsgCvmEventStatus)
#else
	ON_DAB_PSTATUS( CFC_SPMFI_C_U16_CVMEVENT, cfc_spmfi_tclMsgCvmEventStatus)
#endif

DAB_END_MSG_MAP()

#ifdef VARIANT_S_FTR_ENABLE_NEW_SPM_CORE_FI
fc_dabtuner_clientSpm::fc_dabtuner_clientSpm():
    oClientConfig(CCA_C_U16_SRV_SPM,
                  CCA_C_U16_APP_SPM,
                  CCA_C_U16_APP_FC_DABTUNER,
                  "DAB_SpmClient",
                  sizeof(_cau16FIDs)/sizeof(_cau16FIDs[0]),
                  _cau16FIDs,
                  SPM_COREFI_C_U16_SERVICE_MAJORVERSION, 
                  SPM_COREFI_C_U16_SERVICE_MINORVERSION){
    _bCritLowVoltageDetected=FALSE;
    vSubscribe<trMsgRestartSBRProcess>();
};
#else

fc_dabtuner_clientSpm::fc_dabtuner_clientSpm():
    oClientConfig(CCA_C_U16_SRV_SPM,
                  CCA_C_U16_APP_SPM,
                  CCA_C_U16_APP_FC_DABTUNER,
                  "DAB_SpmClient",
                  sizeof(_cau16FIDs)/sizeof(_cau16FIDs[0]),
                  _cau16FIDs,
                  CFC_SPMFI_C_U16_SERVICE_MAJORVERSION, 
                  CFC_SPMFI_C_U16_SERVICE_MINORVERSION){
    _bCritLowVoltageDetected=FALSE;
};
#endif

trClientConfig &fc_dabtuner_clientSpm::roGetConfig() {
    return oClientConfig;
}
#ifdef VARIANT_S_FTR_ENABLE_NEW_SPM_CORE_FI
	tVoid fc_dabtuner_clientSpm::vHandleFi(trAdressing const &roAdressing, spm_corefi_tclMsgCvmEventStatus *pMsg)
#else
	tVoid fc_dabtuner_clientSpm::vHandleFi(trAdressing const &roAdressing, cfc_spmfi_tclMsgCvmEventStatus *pMsg)
#endif
	{
    (tVoid)roAdressing;
    (tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_clientSpm: cvmEvent=%d _bCritLowVoltageDetected=%d",
                    pMsg->CvmEvent.enType,
                    _bCritLowVoltageDetected));
    switch (pMsg->CvmEvent.enType) {
        case CVM_CRITICAL_LOW_VOLTAGE_START:
        {
            if (!_bCritLowVoltageDetected) {
                ETG_TRACE_USR1(("fc_dabtuner_clientSpm: _bCritLowVoltageDetected -->TRUE"));
                _bCritLowVoltageDetected=TRUE;
                DAB_vCallMsgCtor(trMsgSrvCmdCriticalVoltage(TRUE));
            }
            break;
        }
        case CVM_CRITICAL_LOW_VOLTAGE_END:
        {
            if (_bCritLowVoltageDetected) {
                ETG_TRACE_USR1(("fc_dabtuner_clientSpm: _bCritLowVoltageDetected -->FALSE"));
                _bCritLowVoltageDetected=FALSE;
                DAB_vCallMsgCtor(trMsgSrvCmdCriticalVoltage(FALSE));
            }

            break;
        }
        case CVM_LOW_VOLTAGE_START:
        case CVM_LOW_VOLTAGE_END:
        case CVM_HIGH_VOLTAGE_START:
        case CVM_HIGH_VOLTAGE_END:
        case CVM_CRITICAL_HIGH_VOLTAGE_START:
        case CVM_CRITICAL_HIGH_VOLTAGE_END:
        case CVM_NO_EVENT:
        default:
            break;
    }
}

#ifdef VARIANT_S_FTR_ENABLE_NEW_SPM_CORE_FI
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
tVoid fc_dabtuner_clientSpm::vHandleFi(trAdressing const &roAdressing, spm_corefi_tclMsgTunerStateStatus *pMsg)  {

	(tVoid)roAdressing;

	tBool tunermode = dabdrv_learn::instance()->bGetTunerMode();
	ETG_TRACE_USR1(("tunermode =%d", tunermode));

	if((dabdrv_learn::instance()->bGetTunerMode()) && (dabdrv_main::instance()->enGetSourceState() == DAB_enSourceState_FG))
	{
		 if(pMsg->TunerState.enType == SPM_SYSTEM_STATE_STANDBY)
		 {
			 //NCG3D-38368 - In case of IVI, when the target goes to standby mode learn should start.
			 ETG_TRACE_USR1(("fc_dabtuner_clientSpm: FI_EN_SPM_SYSTEM_STANDBY"));
			trMsgSrvCmdLearn oCmdLearn(enLearnType_UPDATE,TRUE,FALSE);
			DAB_vCallMsg(oCmdLearn);

		 }

		 else
		 {
			 //NCG3D-38368 - In case of IVI, when the target comes to Normal mode, learn should be aborted and LSM should be restored.
			 ETG_TRACE_USR1(("fc_dabtuner_clientSpm: SPM State = %d",pMsg->TunerState.enType ));
			 trMsgSrvCmdLearn oCmdLearn(enLearnType_OFF);
			 DAB_vCallMsg(oCmdLearn);

		 }
	}
}
#endif
tVoid fc_dabtuner_clientSpm::vHandleFi(trAdressing const &roAdressing,
		spm_corefi_tclMsgRestartProcessMethodResult *pMsg)
{
	(tVoid)roAdressing;
    (tVoid)pMsg;
    ETG_TRACE_USR4(("fc_dabtuner_clientSpm: RestartProcessMethodResult s32ReturnVal=%d",
                    pMsg->s32ReturnVal));

}
tVoid fc_dabtuner_clientSpm::vProcess(trMsgRestartSBRProcess *potrMsgRestartSBRProcess) {
	if(potrMsgRestartSBRProcess!=nullptr)
	{
		if(potrMsgRestartSBRProcess->bEnable)
		{
			spm_corefi_tclMsgRestartProcessMethodStart oMsg;
			std::string sProcessName = "rbcm-ars-radio.service";
			oMsg.strLocation.bSet(sProcessName.c_str() ,spm_fi_tclString::FI_EN_UTF8);
			vSendFiMessage(oMsg);
		}
	}
}
#endif
