/************************************************************************
* FILE:         fc_dabtuner_clienthandler_diaglog.h
* PROJECT:      g3g
* SW-COMPONENT: DAB Tuner
*----------------------------------------------------------------------
*
* DESCRIPTION: Client Handler for DiagLog
*              
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date      | Author             | Modification
* 20.04.06  | CM-DI/ESA2 Fiebing | initial version
* 15.06.07  | CM-DI/PJ-VW36-Liebanas | adapted for fc_dabtuner
*
*************************************************************************/

#ifndef FC_DABTUNER_CLIENT_HANDLER_DIAGLOG_H_
#define FC_DABTUNER_CLIENT_HANDLER_DIAGLOG_H_

//-----------------------------------------------------------------------------
// includes
//-----------------------------------------------------------------------------

#include "fc_dabtuner_clientBase.h"


#include "fc_dabtuner_util.h"

//lint -esym(763, fc_dabtuner_tclApp)  Redundant declaration for symbol
class fc_dabtuner_tclApp;
/* --- the application has one client message handler for each service --- */
class midw_diaglogfi_tclMsgSaveTestResultMethodResult;
class midw_diaglogfi_tclMsgSendNextTestResultStatus;


namespace DAB {


//-----------------------------------------------------------------------------
// defines
//-----------------------------------------------------------------------------

//service id
#define FCDABTUNER_C_U16_SERVICE_DIAGLOG_MAJOR_VERSION 1 
#define FCDABTUNER_C_U16_SERVICE_DIAGLOG_MINOR_VERSION 0

//-----------------------------------------------------------------------------
// class definition
//-----------------------------------------------------------------------------

struct DAB_trErrLogProperty;

class fc_dabtuner_clientDiagLog : 
    public DAB_Singleton <fc_dabtuner_clientDiagLog>,
    public DAB_MessageHandlerCommon<fc_dabtuner_clientDiagLog>,
    public DAB::DAB_ClientBase

{
        friend class DAB_Singleton<fc_dabtuner_clientDiagLog>;

 public:
        DAB_TRACE_INFO_IMPL(FC_DABTUNER_TR_CLIENT);

        virtual char const *pcGetName() const {return "fc_dabtuner_clientDiagLog";};
        virtual tVoid vDispatchMessage_(amt_tclServiceData *pMsg);

        tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_diaglogfi_tclMsgSaveTestResultMethodResult *pMsg) const;
        tVoid vHandleFi(DAB::trAdressing const &roAdressing, midw_diaglogfi_tclMsgSendNextTestResultStatus *pMsg);

        tVoid vProcess(DAB_trErrLogProperty const *poPropertyErrLog);

 protected:
        virtual DAB::trClientConfig &roGetConfig();
        DAB::trClientConfig oClientConfig;
        static tU16 _cau16FIDs[];

 private:
        tVoid vSendMethodStartSaveTestResult(DAB::DAB_tenTestResult enAdrDiagState);
        fc_dabtuner_clientDiagLog();

};
}
#endif // _DABTUNER_CLIENT_HANDLER_DIAGLOG_H_
