/*******************************************************************************
* FILE:           fc_dabtuner_DiagLibSysSetListener.cpp
* PROJECT:        g3g
* SW-COMPONENT:   FC_DABTUNER
*-------------------------------------------------------------------------------
*
* DESCRIPTION:    definition of diagnosis system set default listener
* 
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:
* Date      | Author              | Modification
* 05.06.09  | PJ-VW33 Hassmann    | initial version
*
*******************************************************************************/

#include "fc_dabtuner_util.h"
#include "fc_dabtuner_main.h"
#include "fc_dabtuner_trace.h"
#include "dabdrv_main.hpp"
#include "dabdrv_chnInfo.hpp"
#include "fc_dabtuner_DiagLibSysSetListener.h"
#include "fc_dabtuner_DiagLibIoControlListener.h"
#include "fc_dabtuner_config.hpp"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_SERVICE 
#include "trcGenProj/Header/fc_dabtuner_DiagLibSysSetListener.cpp.trc.h"
#endif

using namespace DAB;

fc_dabtuner_DiagLibSysSetListener::fc_dabtuner_DiagLibSysSetListener
(
diaglib::tclSystemSetIF* poSystemSetIF,
fc_dabtuner_tclApp* poMain
) :

m_poSystemSetIF(poSystemSetIF),
_MsgContext(0),
m_poGWMain(poMain),
_enSySetsetStatus(DAB_SYSET_None)
{
    ETG_TRACE_USR4(("fc_dabtuner_DiagLibSysSetListener:fc_dabtuner_DiagLibSysSetListener"));

}

fc_dabtuner_DiagLibSysSetListener::~fc_dabtuner_DiagLibSysSetListener
()
{
    ETG_TRACE_USR4(("fc_dabtuner_DiagLibSysSetListener:~fc_dabtuner_DiagLibSysSetListener"));
	
    m_poSystemSetIF = OSAL_NULL;

    m_poGWMain = OSAL_NULL;
}

tU32 fc_dabtuner_DiagLibSysSetListener::vOnSystemSet
(
tU32 u32SystemSetID, 
diaglib::tenSystemSetType u32SystemSetType,
diaglib::tContext MsgContext
)
{
	tU32 _u32RetValue = 0;
    // todo: wait for dianosis-declaration for dab

	ETG_TRACE_USR4(("fc_dabtuner_DiagLibSysSetListener:vOnSystemSet: u32SystemSetID=%u u32SystemSetType=%u",
                    u32SystemSetID, u32SystemSetType));
	

    DAB_ASSERT_RETURN_VAL(OSAL_NULL != m_poSystemSetIF, _u32RetValue);

    DAB_ASSERT_RETURN_VAL(OSAL_NULL != m_poGWMain, _u32RetValue);

    if (!DAB_GET_CONFIG().bDabEnable){
    	ETG_TRACE_ERR(("fc_dabtuner_DiagLibSysSetListener:vOnSystemSet Dab Disabled"));
    	return diaglib::EN_SYSTEMSET_OK;
    }
	_MsgContext=MsgContext;
    _u32RetValue = u32HandleSysSet(u32SystemSetType,MsgContext);


    ETG_TRACE_USR4(("fc_dabtuner_DiagLibSysSetListener:vOnSystemSet: u32RetValue=%u", _u32RetValue));

    return _u32RetValue;
}

tVoid fc_dabtuner_DiagLibSysSetListener::vOnSysSetResult(trMsgSrvResultRsp const *poSrvRspDefSet) {
    if (_enSySetsetStatus == DAB_SYSSET_DEFSET_RUNNING || _enSySetsetStatus == DAB_SYSSET_CODING_RUNNIG) {
    	_enSySetsetStatus=DAB_SYSET_None;
        vSendResult(poSrvRspDefSet->enRes);
    }
}

tVoid fc_dabtuner_DiagLibSysSetListener::vSendResult(DAB_tenResult enRes) {
	
    diaglib::tenSystemSetResult enSysSetResult = diaglib::EN_SYSTEMSET_OK;
    if (enRes== DAB_enResult_OK) {
        enSysSetResult = diaglib::EN_SYSTEMSET_OK;
    }
    ETG_TRACE_USR4(("fc_dabtuner_DiagLibSysSetListener:vSendResult: %d",
                    ETG_CENUM(DAB_tenResult, enRes)));
    // send result to diaglib
    diaglib::tclParameterVector _oErrorList;

    if ( !m_poSystemSetIF->bSendSystemSetResult( enSysSetResult,
                                                 _oErrorList,
                                                 _MsgContext) )
    {
        ETG_TRACE_USR2(("fc_dabtuner_DiagLibSysSetListener:vSendResult: could not bSendSystemSetResult"));
    }

}

tU32 fc_dabtuner_DiagLibSysSetListener::vOnSystemSetFinished
(
tU32 u32SystemSetID, 
diaglib::tenSystemSetType u32SystemSetType,
diaglib::tContext MsgContext
)
{
    (tVoid)MsgContext;
    tU32 _u32RetValue = diaglib::U32_DIAGLIB_RETURN_OK;
	
	if (m_poSystemSetIF->bAcknowledgeSystemSetFinished(MsgContext))
	{
    ETG_TRACE_USR4(("fc_dabtuner_DiagLibSysSetListener:vOnSystemSetFinished: u32SystemSetID=%u u32SystemSetType=%u",
                    u32SystemSetID, u32SystemSetType));
	}
	trMsgSrvCmdDiagStatus diagStaus(enDiagAction_FINISH);
	DAB_vCallMsg(&diagStaus);
    return _u32RetValue;
}

// handler method for preparing of system setting
tU32 fc_dabtuner_DiagLibSysSetListener::vOnSystemSetPrepare
(
tU32 u32SystemSetID, 
diaglib::tenSystemSetType u32SystemSetType,
diaglib::tContext MsgContext
)
{
    tU32 _u32RetValue =	diaglib::U32_DIAGLIB_RETURN_OK;
    diaglib::tenSystemSetResult _enSysSetPrepareResult = diaglib::EN_SYSTEMSET_OK;
	diaglib::tclParameterVector _oErrorList;


	 if (!DAB_GET_CONFIG().bDabEnable) {
		 ETG_TRACE_ERR(("fc_dabtuner_DiagLibSysSetListener:vOnSystemSetPrepare Dab Disabled"));
		 m_poSystemSetIF->bSendSystemSetPrepareResult( _enSysSetPrepareResult, _oErrorList, MsgContext );
		 return _u32RetValue;
	 }

	trMsgSrvCmdDiagStatus diagStaus(enDiagAction_PREPARE);
	DAB_vCallMsg(&diagStaus);

    switch (u32SystemSetID)
    {
       case SYSSETID_TUNE_DAB:
       {
    	   _u32RetValue = u32HandleSysSetPrepare(u32SystemSetType,_enSysSetPrepareResult);
       }
       break;

       case IOCONTROLID_DAB_TUNER_FREQUENCY_SET:
       case IOCONTROLID_DAB_TUNER_SERVICEID_SET:
       {
       }
       break;
       default:
       {
           ETG_TRACE_ERR(("fc_dabtuner_DiagLibSysSetListener:vOnSystemSetPrepare: u32SystemSetID=%u u32SystemSetType=%u", u32SystemSetID, u32SystemSetType));
       }
    } // switch (u32SystemSetID)

    m_poSystemSetIF->bSendSystemSetPrepareResult( _enSysSetPrepareResult, _oErrorList, MsgContext );

    return _u32RetValue;
}


tU32 fc_dabtuner_DiagLibSysSetListener::u32HandleSysSetPrepare(diaglib::tenSystemSetType u32SystemSetType,diaglib::tenSystemSetResult& systemSetResult)
{
	 ETG_TRACE_USR1(("fc_dabtuner_DiagLibSysSetListener:u32HandleSysSetPrepare: u32SystemSetType=%u ", u32SystemSetType));
	tU32 _u32RetValue = diaglib::EN_SYSTEMSET_OK;
	switch(u32SystemSetType){

#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
		case diaglib::EN_TYPE_UM_RESET_ALL:
#endif
		case diaglib::EN_TYPE_DEFAULT_HMI:
		case diaglib::EN_TYPE_DEFAULT_TEF:
		{
		   trMsgSrvCmdClearPresets rSrvCmdClearPresets;
		   DAB_vCallMsg(&rSrvCmdClearPresets);
		   systemSetResult=diaglib::EN_SYSTEMSET_OK;
		   _u32RetValue = diaglib::U32_DIAGLIB_RETURN_OK;
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
		   dabdrv_chnInfo::instance()->vSetFactoryResetStatus(TRUE);
		   trMsgDrvCmdSetChnInfoPsid rDrvCmdSetChnInfoPsid;
		   DAB_vCallMsg(&rDrvCmdSetChnInfoPsid);
#endif

		    break;
		}
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
		case diaglib::EN_TYPE_UM_RESET_USER:
		case diaglib::EN_TYPE_UM_SWITCH_USER:
		{
			 systemSetResult=diaglib::EN_SYSTEMSET_OK;
			 _u32RetValue = diaglib::U32_DIAGLIB_RETURN_OK;
			break;
		}
#endif
		default:
			break;

	}
	return _u32RetValue;
}


tU32 fc_dabtuner_DiagLibSysSetListener::u32HandleSysSet(diaglib::tenSystemSetType u32SystemSetType,diaglib::tContext MsgContext)
{
	ETG_TRACE_USR1(("fc_dabtuner_DiagLibSysSetListener:u32HandleSysSet_SysSetID_DAB: u32SystemSetType=%u ", u32SystemSetType));
	trMsgSrvCmdDiagStatus diagStaus(enDiagAction_SET);
	DAB_vCallMsg(&diagStaus);

	DAB_tenResult result= DAB_enResult_OK;

	switch(u32SystemSetType){
	case diaglib::EN_TYPE_DEFAULT_HMI:
	case diaglib::EN_TYPE_DEFAULT_TEF:
	{
		return u32HandleDefaultSettings(u32SystemSetType,MsgContext);
	}
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
	case diaglib::EN_TYPE_UM_RESET_ALL:
	{
		trMsgDrvDeleteMemory deleteAllPresets(enMeca_DbConfig_ValueId_delete_presets);
		DAB_vCallMsg(&deleteAllPresets);
		break;
	}
	case diaglib::EN_TYPE_UM_RESET_USER:
	{
		trMsgSrvCmdClearPresets rClrPresets;//Default DAB_enPresetListDelete_AllElems
		DAB_vCallMsg(&rClrPresets);
		break;
	}
	case diaglib::EN_TYPE_UM_SWITCH_USER:
	{
		return u32HandleSwitchUser();
	}
#endif
	//case diaglib::EN_TYPE_CODING:
	//{
	/*
		trMsgSrvCmdCoding cmdCoding;
		DAB_vCallMsg(&diagStaus);
		break; */
	//}
	default:
		result= DAB_enResult_FAILED;
		break;
	}
	vSendResult(result);
	return diaglib::EN_SYSTEMSET_OK;
}

tU32 fc_dabtuner_DiagLibSysSetListener::u32HandleSwitchUser()
{
#ifndef DABTUNER_UTEST
	ETG_TRACE_USR1(("fc_dabtuner_DiagLibSysSetListener:HandleSwitchUser "));
	dp_tclSrvIf objUserInfo;
	tU8 userId;

	tS32 s32Status = objUserInfo.s32GetEndUser(userId);
	ETG_TRACE_USR1(("fc_dabtuner_DiagLibSysSetListener:HandleSwitchUser s32Status=%d userId=%d",s32Status,userId));
	if(s32Status != DP_S32_NO_ERR){
		vSendResult(DAB_enResult_FAILED);
		return diaglib::EN_SYSTEMSET_OK;
	}

	trMsgSrvCmdSetUser rSetUser(userId);
	DAB_vCallMsg(&rSetUser);
	vSendResult(DAB_enResult_OK);

	return diaglib::EN_SYSTEMSET_OK;
#endif
}


tU32 fc_dabtuner_DiagLibSysSetListener::u32HandleDefaultSettings(diaglib::tenSystemSetType u32SystemSetType,diaglib::tContext MsgContext)
{
	_enSySetsetStatus=DAB_SYSSET_DEFSET_RUNNING;
	_MsgContext=MsgContext;
	tenDefsetType enDefsetType=enDefsetType_INVALID;
	if (diaglib::EN_TYPE_DEFAULT_TEF == u32SystemSetType) {
		enDefsetType=enDefsetType_TEF;
	}
	else if (diaglib::EN_TYPE_DEFAULT_HMI == u32SystemSetType) {
		enDefsetType=enDefsetType_USER;
	}
	trMsgSrvCmdDefSet rSrvCmdDefSet(enDefsetType);
	DAB_vCallMsg(&rSrvCmdDefSet);

	//presets are not getting deleted in defset
	trMsgDrvDeleteMemory deleteAllPresets(enMeca_DbConfig_ValueId_delete_presets);
	DAB_vCallMsg(&deleteAllPresets);
	vHandleDefaultSettingsExt();
	if (rSrvCmdDefSet.enRes== DAB_enResult_OK) {
		ETG_TRACE_USR4(("fc_dabtuner_DiagLibSysSetListener:vOnSystemSet: OK"));
		vSendResult(DAB_enResult_OK);
		return diaglib::EN_SYSTEMSET_OK;
	} else {
		ETG_TRACE_ERR(("fc_dabtuner_DiagLibSysSetListener:vOnSystemSet: FAILED"));
		vSendResult(DAB_enResult_FAILED);
		return diaglib::EN_SYSTEMSET_OK;
	}
}
tVoid fc_dabtuner_DiagLibSysSetListener::vHandleDefaultSettingsExt()
{
#ifdef FEATURE_PSA_RCC
	/* RDS,FM<->DAB, TA*/
	fc_dabtuner_config *poConfig=fc_dabtuner_config::instance();	
	if (OSAL_NULL!= poConfig) {	
		trMsgSrvCmdSetup _rCurrentSetup;
		_rCurrentSetup.bUseServiceLinkingMode= TRUE;		
		_rCurrentSetup.e8ServiceLinkingMode = (DAB_tenServiceLinkingMode)poConfig->bGetRdsFollowStatus();
		trMsgSrvCmdMtcMode rMsgMtcMode(poConfig->enReadMtcMode());

		if((poConfig->u8GetCountryZone()== enConfigCountryZone_SA || 
			poConfig->u8GetCountryZone() == enConfigCountryZone_CAN)||
			/*DAB follow up ,MTC mode has to be off if BTEL RDS followup is OFF*/
			(!poConfig->bGetRdsFollowStatus()))
		{
			_rCurrentSetup.e8ServiceLinkingMode = DAB_enServiceLinkingMode_OFF;
			rMsgMtcMode.enMtcMode=DAB_enMtcMode_Off;
		}

		DAB_vCallMsg(&_rCurrentSetup);
		DAB_vCallMsg(&rMsgMtcMode);
	}
	//TA Config default settings is handled by  ACL tuner
#endif
}
