/*******************************************************************************
* FILE:           fc_dabtuner_DiagLibIoControlListener.h
* PROJECT:        g3g
* SW-COMPONENT:   DABTUNER
*-------------------------------------------------------------------------------
*
* DESCRIPTION:    definition of diagnosis system set default listener
* 
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:
* Date      | Author              | Modification
* 05.06.09  | PJ-VW33 Hassmann     | initial version
*
*******************************************************************************/
#include "fc_dabtuner_serviceBase.h"

#ifndef DAB_DIAGLIBIOCONTROLLISTENER_H
#define DAB_DIAGLIBIOCONTROLLISTENER_H

// +++ Specify what part of diaglib you need in this file +++
#define DIAGLIB_INCLUDE_GENERIC
#include "diaglib_if.h"

#define DAB_CONCEALMENT_LEVEL_MAX 7

#ifndef IOCONTROLID_DAB_TUNER_FREQUENCY_SET
#define IOCONTROLID_DAB_TUNER_FREQUENCY_SET 1
#endif
#ifndef IOCONTROLID_DAB_TUNER_SERVICEID_SET
#define IOCONTROLID_DAB_TUNER_SERVICEID_SET 2
#endif
#ifndef IOCONTROLID_DIAG_REMOTE_CONTROL
#define IOCONTROLID_DIAG_REMOTE_CONTROL 3
#endif
#ifndef IOCONTROLID_DAB_TUNER_REMOTE_SF_ON_OFF
#define IOCONTROLID_DAB_TUNER_REMOTE_SF_ON_OFF 4
#endif
#ifndef IOCONTROLID_DAB_TUNER_REMOTE_MANUAL_TUNE
#define IOCONTROLID_DAB_TUNER_REMOTE_MANUAL_TUNE 5
#endif
#ifndef IOCONTROLID_DAB_TUNER_REMOTE_CONCEALMENT_LEVEL
#define IOCONTROLID_DAB_TUNER_REMOTE_CONCEALMENT_LEVEL 6
#endif

#ifndef IOCONTROLID_DAB_TUNER_REMOTE_TEST_EXECUTION_SEEK
#define IOCONTROLID_DAB_TUNER_REMOTE_TEST_EXECUTION_SEEK 7
#endif

#ifndef IOCONTROLID_DAB_TUNER_REMOTE_SELECT_SERVICE
#define IOCONTROLID_DAB_TUNER_REMOTE_SELECT_SERVICE 8
#endif

#ifndef IOCONTROLID_DAB_TUNER_REMOTE_UPDATE_LEARN
#define IOCONTROLID_DAB_TUNER_REMOTE_UPDATE_LEARN 9
#endif

#ifndef IOCONTROLID_DAB_TUNER_REMOTE_SERVICE_SELECT
#define IOCONTROLID_DAB_TUNER_REMOTE_SERVICE_SELECT 10
#endif

#ifndef IOCONTROLID_DAB_TUNER_REMOTE_SECONDARY_SERVICE_SELECT
#define IOCONTROLID_DAB_TUNER_REMOTE_SECONDARY_SERVICE_SELECT 11
#endif

#ifndef IOCONTROLID_DAB_TUNER_ADAPTATION_SHIFT_FREQUENCY_START
#define IOCONTROLID_DAB_TUNER_ADAPTATION_SHIFT_FREQUENCY_START 12
#endif

#ifndef IOCONTROLID_DAB_TUNER_ADAPTATION_SHIFT_FREQUENCY_STOP
#define IOCONTROLID_DAB_TUNER_ADAPTATION_SHIFT_FREQUENCY_STOP 13
#endif

#ifndef IOCONTROLID_DAB_TUNER_ADAPTATION_SEEK_START
#define IOCONTROLID_DAB_TUNER_ADAPTATION_SEEK_START 14
#endif

#ifndef IOCONTROLID_DAB_TUNER_ADAPTATION_SEEK_STOP
#define IOCONTROLID_DAB_TUNER_ADAPTATION_SEEK_STOP 25
#endif

#ifndef IOCONTROLID_DAB_ENSEMBLE_TUNER_L_BAND_START
#define IOCONTROLID_DAB_ENSEMBLE_TUNER_L_BAND_START 26
#endif

#ifndef IOCONTROLID_DAB_ENSEMBLE_TUNER_L_BAND_STOP
#define IOCONTROLID_DAB_ENSEMBLE_TUNER_L_BAND_STOP 27
#endif


#ifndef IOCONTROLID_DAB_TUNER_SERVICE_SEEK_START
#define IOCONTROLID_DAB_TUNER_SERVICE_SEEK_START 18
#endif

#ifndef IOCONTROLID_DAB_TUNER_SERVICE_SEEK_STOP
#define IOCONTROLID_DAB_TUNER_SERVICE_SEEK_STOP 19
#endif

#ifndef IOCONTROLID_DAB_TUNER_AUDIO_SERVICE_SELECTION_START
#define IOCONTROLID_DAB_TUNER_AUDIO_SERVICE_SELECTION_START 20
#endif

#ifndef IOCONTROLID_DAB_TUNER_AUDIO_SERVICE_SELECTION_STOP
#define IOCONTROLID_DAB_TUNER_AUDIO_SERVICE_SELECTION_STOP 21
#endif

enum entypeTuneMode
{
EN_NONE = 0,
EN_STOP,
EN_TUNE_ONE_STEP,
EN_TUNE_SEARCH,
EN_TUNE_SEARCH_ENDLESS,
EN_TUNE_ENSEMBLE
};


// +++ Specify what part of diaglib you need in this file +++
#define DIAGLIB_INCLUDE_GENERIC
#include "diaglib_if.h"

// forward definition of own application class
//lint -esym(763, fc_dabtuner_tclApp)  Redundant declaration for symbol
class fc_dabtuner_tclApp;

namespace DAB {

// class definition
class fc_dabtuner_DiagLibIoControlListener : public diaglib::tclIoControlListenerIF
{
public:
    // +++ Depending on the type of listener you need the associated interface to send responses +++
    fc_dabtuner_DiagLibIoControlListener( diaglib::tclIoControlIF* poIoControlIF,
                                                 fc_dabtuner_tclApp* poMain );

    // default destructor
    virtual ~fc_dabtuner_DiagLibIoControlListener();
private:
    // default constructor
    fc_dabtuner_DiagLibIoControlListener(); //lint !e1704 prio3 reviewed: constructor has private access specification: its use is forbidden
    // copy constructor
    fc_dabtuner_DiagLibIoControlListener(const fc_dabtuner_DiagLibIoControlListener& rhs); //lint !e1704 prio3 reviewed: constructor has private access specification: its use is forbidden
    // assignment operator
    fc_dabtuner_DiagLibIoControlListener& operator=(const fc_dabtuner_DiagLibIoControlListener& rhs);

    // attribute: reference to system set interface
    diaglib::tclIoControlIF* m_poIoControlIF;

    // attribute: reference of own application object
    fc_dabtuner_tclApp* m_poGWMain;

    tVoid vSendResult(diaglib::tContext MsgContext, diaglib::tenIoControlAction enAction, DAB_tenTestOperation enTestOperation, diaglib::tenInternalError enError=diaglib::EN_ERROR_NO_ERROR) const;
    diaglib::tContext _MsgContext;
    tBool _bIoControlRunning;


public:
    // handler method for system setting
    virtual tU32 vOnIoControl (
                               tU32 u32IoControlId, 
                               diaglib::tenIoControlAction enActionId, 
                               const diaglib::tclParameterVector& oParameterVector,
                               diaglib::tContext MsgContext
                              );

    // handler method for finaling of system setting

	virtual tU32 vOnIoControlFreeze (
                                     tU32 u32IoControlId,
                                     diaglib::tContext MsgContext
                                   );
	virtual tU32 vOnIoControlUnfreeze (
                                       tU32 u32IoControlId,
                                       diaglib::tContext MsgContext
                                           );

    tVoid vOnIoControlResult(trMsgSrvRspTestOperation const *poSrvRspTestOperation);
    tU32 _u32serviceIDPresent;
    tU8 _u8dabFrequencyTable;
};
}
#endif

