/*******************************************************************************
* FILE:           fc_dabtuner_DiagLibIoControlListener.cpp
* PROJECT:        g3g
* SW-COMPONENT:   FC_DABTUNER
*-------------------------------------------------------------------------------
*
* DESCRIPTION:    definition of diagnosis system set default listener
* 
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:
* Date      | Author              | Modification
* 05.06.09  | PJ-VW33 Hassmann    | initial version
*
*******************************************************************************/

#include "fc_dabtuner_util.h"
#include "fc_dabtuner_main.h"
#include "fc_dabtuner_trace.h"
#include "dabdrv_main.hpp"
#include "fc_dabtuner_DiagLibIoControlListener.h"
#include "fc_dabtuner_config.hpp"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_SERVICE 
#include "trcGenProj/Header/fc_dabtuner_DiagLibIoControlListener.cpp.trc.h"
#endif

#define FC_DABTUNER_S_IMPORT_INTERFACE_MSG
#include "fc_dabtuner_if.h"

using namespace DAB;

#ifndef IOCONTROLID_DIAG_REMOTE_CONTROL_SET_bMode
#define IOCONTROLID_DIAG_REMOTE_CONTROL_SET_bMode 0
#endif
fc_dabtuner_DiagLibIoControlListener::fc_dabtuner_DiagLibIoControlListener
(
diaglib::tclIoControlIF* poIoControlIF,
fc_dabtuner_tclApp* poMain
) :
m_poIoControlIF(poIoControlIF),
m_poGWMain(poMain),
_MsgContext(0),
_bIoControlRunning(FALSE),
_u32serviceIDPresent(0),
_u8dabFrequencyTable(0)
{
    ETG_TRACE_USR4(("fc_dabtuner_DiagLibIoControlListener:fc_dabtuner_DiagLibIoControlListener"));

}

fc_dabtuner_DiagLibIoControlListener::~fc_dabtuner_DiagLibIoControlListener
()
{
    ETG_TRACE_USR4(("fc_dabtuner_DiagLibIoControlListener:~fc_dabtuner_DiagLibIoControlListener"));
    m_poIoControlIF = OSAL_NULL;
    m_poGWMain = OSAL_NULL;
}


tU32 fc_dabtuner_DiagLibIoControlListener::vOnIoControlFreeze (
                                                               tU32 u32IoControlId,
                                                               diaglib::tContext MsgContext
                                                               ) {

    ETG_TRACE_USR4(("fc_dabtuner_DiagLibIoControlListener::vOnIoControlFreeze u32IoControlId= %d _bIoControlRunning=%d",u32IoControlId,_bIoControlRunning));
    (tVoid)u32IoControlId;
    tU32 u32Ret=0;
    if (_bIoControlRunning) {
        vSendResult(MsgContext, diaglib::EN_ACTION_FREEZE, DAB_enTestOperation_REMOTE_CTRL_ENTER, diaglib::EN_ERROR_ROUTINE_STILL_RUNNING);
        return u32Ret;
    }
    trMsgSrvCmdTestOperation rTestOp;
    rTestOp.enTestOperation=DAB_enTestOperation_REMOTE_CTRL_ENTER;
    DAB_vCallMsg(&rTestOp);
    if (rTestOp.bRejected) {
        vSendResult(MsgContext, diaglib::EN_ACTION_FREEZE, DAB_enTestOperation_REMOTE_CTRL_ENTER, diaglib::EN_ERROR_FATAL_INTERNAL);
        return u32Ret;
    }
    _MsgContext=MsgContext;
    _bIoControlRunning=TRUE;
        return u32Ret;
}

tU32 fc_dabtuner_DiagLibIoControlListener::vOnIoControlUnfreeze (
                                                               tU32 u32IoControlId,
                                                               diaglib::tContext MsgContext
                                                               ) {
  ETG_TRACE_USR4(("fc_dabtuner_DiagLibIoControlListener::vOnIoControlUnfreeze u32IoControlId= %d _bIoControlRunning=%d",u32IoControlId,_bIoControlRunning));
    (tVoid)u32IoControlId;
    tU32 u32Ret=0;
    if (_bIoControlRunning) {
        vSendResult(MsgContext, diaglib::EN_ACTION_UNFREEZE, DAB_enTestOperation_REMOTE_CTRL_LEAVE, diaglib::EN_ERROR_ROUTINE_STILL_RUNNING);
        return u32Ret;
    }
    trMsgSrvCmdTestOperation rTestOp;
    rTestOp.enTestOperation=DAB_enTestOperation_REMOTE_CTRL_LEAVE;
    DAB_vCallMsg(&rTestOp);
    if (rTestOp.bRejected) {
        vSendResult(MsgContext, diaglib::EN_ACTION_UNFREEZE, DAB_enTestOperation_REMOTE_CTRL_LEAVE, diaglib::EN_ERROR_FATAL_INTERNAL);
        return u32Ret;
    }
    _MsgContext=MsgContext;
    _bIoControlRunning=TRUE;
    return u32Ret;
}


tU32 fc_dabtuner_DiagLibIoControlListener::vOnIoControl
(
 tU32 u32IoControlId, 
 diaglib::tenIoControlAction enActionId, 
 const diaglib::tclParameterVector& oParameterVector,
 diaglib::tContext MsgContext
)
{
    ETG_TRACE_USR4(("fc_dabtuner_DiagLibIoControlListener:vOnIoControl u32IoControlId= %d",u32IoControlId));
    (tVoid)oParameterVector;
    (tVoid)MsgContext;
    tU32 _u32RetValue = diaglib::U32_DIAGLIB_RETURN_OK;

    switch (u32IoControlId)
    {
        case IOCONTROLID_DAB_TUNER_FREQUENCY_SET:
        {
            ETG_TRACE_USR4(("fc_dabtuner_DiagLibIoControlListener:vOnIoControl IOCONTROLID_DAB_TUNER_FREQUENCY_SET"));
            trMsgSrvCmdTestOperation rTestOp;
            rTestOp.enTestOperation=DAB_enTestOperation_TUNE_FREQUENCY;
            rTestOp.u32Value1 = oParameterVector[0].u32Value;
			_MsgContext=MsgContext;
			_bIoControlRunning=TRUE;
            DAB_vCallMsg(&rTestOp); 
            //vSendResult(MsgContext, diaglib::EN_ACTION_SET, DAB_enTestOperation_TUNE_ENSEMBLE, diaglib::EN_ERROR_NO_ERROR);
        }
        break;

        case IOCONTROLID_DAB_TUNER_SERVICEID_SET:
        {
            ETG_TRACE_USR4(("fc_dabtuner_DiagLibIoControlListener:vOnIoControl IOCONTROLID_DAB_TUNER_SERVICEID_SET"));
            trMsgSrvCmdTestOperation rTestOp;
            rTestOp.enTestOperation=DAB_enTestOperation_PLAY_ASID;
            rTestOp.u32Value1 = oParameterVector[0].u32Value;
			_MsgContext=MsgContext;
			_bIoControlRunning=TRUE;
            DAB_vCallMsg(&rTestOp); 
            //vSendResult(MsgContext, diaglib::EN_ACTION_SET, DAB_enTestOperation_TUNE_SERVICE, diaglib::EN_ERROR_NO_ERROR);
        }
        break;
        case IOCONTROLID_DIAG_REMOTE_CONTROL:
        {
            tBool bMode = oParameterVector[IOCONTROLID_DIAG_REMOTE_CONTROL_SET_bMode].u8Value; //1=enable, 0=dissable 

            ETG_TRACE_USR4(("fc_dabtuner_DiagLibIoControlListener:vOnIoControl IOCONTROLID_DIAG_REMOTE_CONTROL Mode:%d",bMode));

            trMsgSrvCmdTestOperation rTestOp;
            _MsgContext=MsgContext;
            _bIoControlRunning=TRUE;
            rTestOp.enTestOperation= (bMode==TRUE)? DAB_enTestOperation_REMOTE_CTRL_ENTER : DAB_enTestOperation_REMOTE_CTRL_LEAVE;
            DAB_vCallMsg(&rTestOp);
        }
        break;
        case IOCONTROLID_DAB_TUNER_REMOTE_SF_ON_OFF:
        {
            trMsgDrvCmdEnableDabSrvFollow rMsgEnableSrvFollow;
            rMsgEnableSrvFollow.bEnable = oParameterVector[0].u8Value;
            DAB_vCallMsg(&rMsgEnableSrvFollow);
            vSendResult(MsgContext, diaglib::EN_ACTION_SET, DAB_enTestOperation_SF_ON_OFF, diaglib::EN_ERROR_NO_ERROR);
        }
        break;
        case IOCONTROLID_DAB_TUNER_REMOTE_MANUAL_TUNE:
        {
            trMsgSrvCmdTestOperation rSrvCmdTestOperation;
            rSrvCmdTestOperation.enTestOperation=DAB_enTestOperation_TUNE_ENSEMBLE;
            rSrvCmdTestOperation.u32Value1=EN_TUNE_ONE_STEP;
            rSrvCmdTestOperation.u32Value2=0;
            rSrvCmdTestOperation.u32Value3=oParameterVector[0].u32Value;
            DAB_vCallMsg(&rSrvCmdTestOperation);
            vSendResult(MsgContext, diaglib::EN_ACTION_SET, DAB_enTestOperation_TUNE_ENSEMBLE, diaglib::EN_ERROR_NO_ERROR);
        }
        break;
        case IOCONTROLID_DAB_TUNER_REMOTE_CONCEALMENT_LEVEL:
        {
           trMsgSrvCmdSetup oCmdSetup;
           if(oParameterVector[0].u8Value)
           {
              oCmdSetup.bUseConcealmentLevel = true;
              oCmdSetup.u8ConcealmentLevel = DAB_CONCEALMENT_LEVEL_MAX;
           }
           else
           {
              oCmdSetup.bUseConcealmentLevel = true;
              oCmdSetup.u8ConcealmentLevel = 0;
           }
           DAB_vCallMsg (&oCmdSetup);
           vSendResult(MsgContext, diaglib::EN_ACTION_SET, DAB_enTestOperation_CONCEALMENT_LEVEL, diaglib::EN_ERROR_NO_ERROR);
        }
        break;
        case IOCONTROLID_DAB_TUNER_REMOTE_SERVICE_SELECT:
        {
            trMsgSrvCmdTestOperation rMsg;
            rMsg.enTestOperation=DAB_enTestOperation_TUNE_SERVICE;
            if (oParameterVector[0].u8Value == midw_ext_fi_tcl_e8_DAB_TuneCmd::FI_EN_DAB_TUNE_NEXT) {
                rMsg.u32Value1= (tU32)enMeca_RdmServiceCommand_PLAY_NEXT;
            }
            else {
                rMsg.u32Value1= (tU32)enMeca_RdmServiceCommand_PLAY_PREVIOUS;
            }
            DAB_vCallMsg(&rMsg);
            vSendResult(MsgContext, diaglib::EN_ACTION_SET, DAB_enTestOperation_TUNE_SERVICE, diaglib::EN_ERROR_NO_ERROR);
        }
        break;
        case IOCONTROLID_DAB_TUNER_REMOTE_SECONDARY_SERVICE_SELECT:
        {
            trMsgSrvCmdCompSelect rSrvCmdCompSelect;
            rSrvCmdCompSelect.enChnSelectMode=enChnSelectMode_Relative;
            rSrvCmdCompSelect.u32Value=1;   //One step seek
            rSrvCmdCompSelect.bNegative=oParameterVector[0].u8Value ;
            DAB_vCallMsg(&rSrvCmdCompSelect);
            vSendResult(MsgContext, diaglib::EN_ACTION_SET, DAB_enTestOperation_SECONDARY_SERVICE_SELECT, diaglib::EN_ERROR_NO_ERROR);
        }
        break;
        case IOCONTROLID_DAB_TUNER_ADAPTATION_SHIFT_FREQUENCY_START:
        case IOCONTROLID_DAB_TUNER_ADAPTATION_SHIFT_FREQUENCY_STOP:
        {
            trMsgSrvCmdTestOperation rSrvCmdTestOperation;
            rSrvCmdTestOperation.enTestOperation=DAB_enTestOperation_TUNE_ENSEMBLE;
            if(u32IoControlId == IOCONTROLID_DAB_TUNER_ADAPTATION_SHIFT_FREQUENCY_START){
               rSrvCmdTestOperation.u32Value1=EN_TUNE_SEARCH;
               rSrvCmdTestOperation.u32Value3=oParameterVector[0].u32Value ;}
            else {
                rSrvCmdTestOperation.u32Value1=EN_STOP;
                rSrvCmdTestOperation.u32Value3=EN_NONE;}
            rSrvCmdTestOperation.u32Value2=EN_NONE;
            DAB_vCallMsg(&rSrvCmdTestOperation);
            vSendResult(MsgContext, diaglib::EN_ACTION_SET, DAB_enTestOperation_TUNE_ENSEMBLE, diaglib::EN_ERROR_NO_ERROR);
        }
        break;
        case IOCONTROLID_DAB_TUNER_ADAPTATION_SEEK_STOP:
        case IOCONTROLID_DAB_TUNER_ADAPTATION_SEEK_START:
        {

            trMsgSrvCmdTestOperation rSrvCmdTestOperation;
           rSrvCmdTestOperation.enTestOperation=DAB_enTestOperation_TUNE_ENSEMBLE;
           if(u32IoControlId==IOCONTROLID_DAB_TUNER_ADAPTATION_SEEK_START){
              rSrvCmdTestOperation.u32Value1=EN_TUNE_ENSEMBLE;
              }
           else {
              rSrvCmdTestOperation.u32Value1=EN_STOP;
              }
           rSrvCmdTestOperation.u32Value2=EN_NONE;
           rSrvCmdTestOperation.u32Value3=oParameterVector[0].u32Value ;
           DAB_vCallMsg(&rSrvCmdTestOperation);
           vSendResult(MsgContext, diaglib::EN_ACTION_SET, DAB_enTestOperation_TUNE_ENSEMBLE, diaglib::EN_ERROR_NO_ERROR);
        }
        break;
        case IOCONTROLID_DAB_ENSEMBLE_TUNER_L_BAND_START:
        case IOCONTROLID_DAB_ENSEMBLE_TUNER_L_BAND_STOP:
        {
        	 trMsgSrvCmdTestOperation rSrvCmdTestOperation;

        	if(u32IoControlId == IOCONTROLID_DAB_ENSEMBLE_TUNER_L_BAND_START)
        	{
				DAB_trChnInfoProperty rProperty=dabdrv_properties::instance()->oChnInfoProperty.oGet();
				_u32serviceIDPresent =  rProperty.rMecaId.u16GetSID();
				fc_dabtuner_config *poConfig=fc_dabtuner_config::instance();
				if(poConfig != NULL){
				   _u8dabFrequencyTable= poConfig->enGetFrequencyTable();}
			   trMeca_RRdmSetDabFrequencyTable rSetDabFrequencyTable;
			   rSetDabFrequencyTable.enFrequencyTable = enMeca_RdmFrequencyTable_FREQUENCY_TABLE_EUROPE_LBAND;
			   DAB_vCallMsg(&rSetDabFrequencyTable);

			   rSrvCmdTestOperation.u32Value1=EN_TUNE_SEARCH;
			   rSrvCmdTestOperation.u32Value3=oParameterVector[0].u32Value;
			}
        	else
        	{
               trMeca_RRdmSetDabFrequencyTable rSetDabFrequencyTable ;
               rSetDabFrequencyTable.enFrequencyTable =(tenMeca_RdmFrequencyTable)_u8dabFrequencyTable;
               DAB_vCallMsg(&rSetDabFrequencyTable);

               rSrvCmdTestOperation.u32Value1=_u32serviceIDPresent;
               rSrvCmdTestOperation.u32Value3= 0;
        	}

           rSrvCmdTestOperation.u32Value2=EN_NONE;
           rSrvCmdTestOperation.enTestOperation=DAB_enTestOperation_PLAY_ASID;
           DAB_vCallMsg(&rSrvCmdTestOperation);
           vSendResult(MsgContext, diaglib::EN_ACTION_SET, DAB_enTestOperation_TUNE_ENSEMBLE, diaglib::EN_ERROR_NO_ERROR);
        }
        break;
        case IOCONTROLID_DAB_TUNER_SERVICE_SEEK_START:
        {
            trMsgSrvCmdChnSelect rSrvCmdChnSelect;
            rSrvCmdChnSelect.enChnSelectMode=enChnSelectMode_Relative;
            rSrvCmdChnSelect.u32Value=1;
            rSrvCmdChnSelect.bNegative=oParameterVector[0].u8Value;
            DAB_vCallMsg(&rSrvCmdChnSelect);
        }
        break;
        case IOCONTROLID_DAB_TUNER_REMOTE_UPDATE_LEARN:
        {
            trMsgSrvCmdLearn oCmdLearn((tenLearnType)oParameterVector[0].u8Value , 0);
            DAB_vCallMsg(&oCmdLearn);
        }
        break;
        case IOCONTROLID_DAB_TUNER_AUDIO_SERVICE_SELECTION_START:
        case IOCONTROLID_DAB_TUNER_AUDIO_SERVICE_SELECTION_STOP:
        {
        	trMsgSrvCmdTestOperation rSrvCmdTestOperation;
        	if(u32IoControlId == IOCONTROLID_DAB_TUNER_AUDIO_SERVICE_SELECTION_START)
        	{
				DAB_trChnInfoProperty rProperty=dabdrv_properties::instance()->oChnInfoProperty.oGet();
				_u32serviceIDPresent = rProperty.rMecaId.u16GetSID();
				rSrvCmdTestOperation.u32Value1=oParameterVector[0].u32Value;
        	}
        	else
        	{
        		rSrvCmdTestOperation.u32Value1=_u32serviceIDPresent;
        	}

            rSrvCmdTestOperation.enTestOperation=DAB_enTestOperation_PLAY_ASID;
            rSrvCmdTestOperation.u32Value2=EN_NONE;
            rSrvCmdTestOperation.u32Value3= 0;
            DAB_vCallMsg(&rSrvCmdTestOperation);
            vSendResult(MsgContext, diaglib::EN_ACTION_SET, DAB_enTestOperation_PLAY_ASID, diaglib::EN_ERROR_NO_ERROR);
        }
        break;
        default:
        {
            NORMAL_M_ASSERT_ALWAYS();
            ETG_TRACE_ERR(("fc_dabtuner_DiagLibIoControlListener:vOnIoControl: u32IoControlID=%u enActionId=%u", u32IoControlId, enActionId));
            vSendResult(MsgContext, diaglib::EN_ACTION_SET, DAB_enTestOperation_INVALID, diaglib::EN_ERROR_ID_NOT_SUPPORTED);
            _u32RetValue = diaglib::U32_DIAGLIB_RETURN_NOT_OK;
        }
        break;
    } // switch (u32IoControlId)

    return _u32RetValue;
}

tVoid fc_dabtuner_DiagLibIoControlListener::vOnIoControlResult(trMsgSrvRspTestOperation const *poSrvRspTestOperation) {
    if (_bIoControlRunning) {
		ETG_TRACE_USR4(("fc_dabtuner_DiagLibIoControlListener:vOnIoControl"));
        _bIoControlRunning=FALSE;
        vSendResult(_MsgContext, diaglib::EN_ACTION_SET, poSrvRspTestOperation->enTestOperation, poSrvRspTestOperation->enResult==DAB_enResult_OK ?
                    diaglib::EN_ERROR_NO_ERROR :
                    diaglib::EN_ERROR_FATAL_INTERNAL);
    }
}

tVoid fc_dabtuner_DiagLibIoControlListener::vSendResult(diaglib::tContext MsgContext, diaglib::tenIoControlAction enAction, DAB_tenTestOperation enTestOperation, diaglib::tenInternalError enError) const {
	ETG_TRACE_USR4(("fc_dabtuner_DiagLibIoControlListener:vSendResult: enError=%d",enError));
    diaglib::tenIoCtrlResult enIoControlResult = diaglib::EN_IO_CONTROL_NOT_OK;
    diaglib::tclParameterVector oResultList;
    if (enError == diaglib::EN_ERROR_NO_ERROR) {
        enIoControlResult = diaglib::EN_IO_CONTROL_OK;

        diaglib::trParameter rParameter;
		rParameter.enType = diaglib::EN_PARAMETER_TYPE_U8;

        switch (enTestOperation) {
            case DAB_enTestOperation_REMOTE_CTRL_ENTER:
            case DAB_enTestOperation_REMOTE_CTRL_LEAVE:
            {
                rParameter.enType = diaglib::EN_PARAMETER_TYPE_U8;
                rParameter.u8Value = enTestOperation == DAB_enTestOperation_REMOTE_CTRL_ENTER ? 1:0;

                tBool bTestActive = enTestOperation == DAB_enTestOperation_REMOTE_CTRL_ENTER ? TRUE:FALSE;
                trMsgDrvSetTestMode rMsg(bTestActive);
                DAB_vCallMsg(&rMsg);

                ETG_TRACE_USR2(("fc_dabtuner_DiagLibIoControlListener:vSendResult: rParameter.u8Value = %x",rParameter.u8Value));
            }
            break;
            case DAB_enTestOperation_SF_ON_OFF:
            case DAB_enTestOperation_TUNE_ENSEMBLE:
            case DAB_enTestOperation_TUNE_SERVICE:
            case DAB_enTestOperation_TUNE_FREQUENCY:
            case DAB_enTestOperation_PLAY_ASID:
            case DAB_enTestOperation_VERIFY_FREQ_ASID_AUDIO:
            case DAB_enTestOperation_TESTMODE_ACTIVE:
            case DAB_enTestOperation_SECONDARY_SERVICE_SELECT:
            default:
            {
                ETG_TRACE_ERR(("fc_dabtuner_DiagLibIoControlListener:vSendResult: DAB_enTestOperation"));
            }
        }
        oResultList.push_back(rParameter);
    } 
    else {
        diaglib::trParameter rParameter;
        rParameter.enType=diaglib::EN_PARAMETER_TYPE_U8ERROR;
        rParameter.u8ErrorValue=enError;
        oResultList.push_back(rParameter);
    }
    ETG_TRACE_USR4(("fc_dabtuner_DiagLibIoControlListener:vSendResult: OK=%d, enError=0x%04x",
        (enIoControlResult == diaglib::EN_IO_CONTROL_OK) ? 1 : 0,
                    enError));
    // send result to diaglib
    if ( !m_poIoControlIF->bSendIoCtrlMethodResult( enIoControlResult,
                                                    enAction,
                                                    oResultList,
                                                    MsgContext) )
    {
        ETG_TRACE_USR2(("fc_dabtuner_DiagLibIoControlListener:vSendResult: could not bSendIoControlResult"));
    }
}


