/************************************************************************
 * FILE:        dabmeca_ans.hpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of dabmeca_ans
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      	| Author                       | Modification
				  
				
 *************************************************************************/

#ifndef DABMECA_ANS_HPP
#define DABMECA_ANS_HPP

#include "fc_dabtuner_util.h"
#include "dabdrv_meca.h"
#include "dabmeca_db.hpp"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_UTIL_MSG
#include "trcGenProj/Header/dabmeca_ans.hpp.trc.h"
#endif

namespace DAB {

    typedef enum {
        enMeca_AnsType_Alarm                = 1,
        enMeca_AnsType_RoadTrafficFlash     = 2,
        enMeca_AnsType_TransportFlash       = 3,
        enMeca_AnsType_WarningService       = 4,
        enMeca_AnsType_NewsFlash            = 5,
        enMeca_AnsType_AreaWeatherFlash     = 6,
        enMeca_AnsType_EventAnnouncement    = 7,
        enMeca_AnsType_SpecialEvent         = 8,
        enMeca_AnsType_ProgrammeInformation = 9,
        enMeca_AnsType_SportReport          = 10,
        enMeca_AnsType_FinancialReport      = 11,
        enMeca_AnsType_12                   = 12,
        enMeca_AnsType_13                   = 13,
        enMeca_AnsType_14                   = 14,
        enMeca_AnsType_15                   = 15,
        enMeca_AnsType_16                   = 16
    } tenMeca_AnsType;

    inline tVoid vSetAnsTypeBit(tenMeca_AnsType enBit, tU16 *pu16Mask) {
        *pu16Mask = (tU16)(*pu16Mask | (tU16)(1U<<(tU8)((tU8)enBit-1)));
    }

    struct trAnnoFlags {
        tBool bNew;
        tBool bOtherCluster;
        tBool bInterruptible;

        tVoid vParse(tU8 u8AnnoFlags) {
            bNew= DAB_BOOL_FROM_BIT(u8AnnoFlags, DAB_b0);
            bOtherCluster = DAB_BOOL_FROM_BIT(u8AnnoFlags, DAB_b1);
            bInterruptible = DAB_BOOL_FROM_BIT(u8AnnoFlags, DAB_b2);
        }
        
        tVoid vSerialize(tU8 *pu8AnnoFlags) const{
            *pu8AnnoFlags=(tU8)((bNew?1:0) | 
                           (bOtherCluster?2:0) | 
                           (bInterruptible?4:0));
        }
        
        
        tVoid vTrace() const {
            ETG_TRACE_USR1(("    trAnnoFlags:bNew=%d bOtherCluster=%d bInterruptible=%d",
                            bNew, bOtherCluster, bInterruptible));            
        }
    };

    // _DAB_C_ANS_ENABLE_ANNO
    struct trMeca_CAnsEnableAnno:
        public  trMsgMecaOut {
        DAB_DISPATCH_IMPL

        virtual tVoid vSerialize(trMsgMecaRawOutput *pRawOutput) const {
            pRawOutput->u16FBlockId = DAB_FBLOCK_ID;
            pRawOutput->u16MsgType = MECA_DISPATCHER_C_ANS_ENABLE_ANNO;
            pRawOutput->enOpType = enOpType_SET;
            pRawOutput->u16DataLen = 2;
            pRawOutput->au8Data[0]= (tU8)enAnsType;
            pRawOutput->au8Data[1]= (tU8)((bMask ? 1: 0) | (bFilter ? 2: 0));
        }

        virtual tVoid vTrace() const {
            ETG_TRACE_USR1(("  trMeca_CAnsEnableAnno:enAnsType=%x bMask=%d bFilter=%d",
                            ETG_CENUM(tenMeca_AnsType, enAnsType),
                            bMask,
                            bFilter));
        };
    
        tenMeca_AnsType enAnsType;
        tBool bMask;
        tBool bFilter;

    };


    // DAB_*_R_ANS_ENABLE_ANNO
    struct trMeca_RAnsEnableAnno:
        public trMsgMecaInput {
        DAB_DISPATCH_IMPL
    
        virtual tBool bParse(trMostHdr const &rMostHdr, tU8 const *pu8Data) {
            if (rMostHdr._u16MecaLen != 2) {
                return FALSE;
            }
            _rMostHdr=rMostHdr;
            enAnsType=(tenMeca_AnsType)pu8Data[0];
            bMask = DAB_BOOL_FROM_BIT(pu8Data[0], DAB_b0);
            bFilter = DAB_BOOL_FROM_BIT(pu8Data[0], DAB_b1);
            return TRUE;
        }
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1(("  trMeca_RAnsEnableAnno:enAnsType=%x bMask=%d bFilter=%d",
                            ETG_CENUM(tenMeca_AnsType, enAnsType),
                            bMask,
                            bFilter));
        };
    
        tenMeca_AnsType enAnsType;
        tBool bMask;
        tBool bFilter;
    };

    typedef enum {
        enMeca_AnsAnnoActiveStatus_Start    = 0x01,
        enMeca_AnsAnnoActiveStatus_End      = 0x02,
        enMeca_AnsAnnoActiveStatus_Escaped  = 0x03,
        enMeca_AnsAnnoActiveStatus_Switched = 0x04
    } tenMeca_AnsAnnoActiveStatus;

    typedef enum {
        enMeca_AnsAnnoSourceInfo_CE = 0x00, 
        enMeca_AnsAnnoSourceInfo_OE = 0x01, // not supported
        enMeca_AnsAnnoSourceInfo_FM = 0x02 // not supported
    } tenMeca_AnsAnnoSourceInfo;

    // DAB_*_R_ANS_ANNO_ACTIVE_STATUS
    struct trMeca_RAnsAnnoActiveStatus:
        public trMsgMecaInput {
        DAB_DISPATCH_IMPL
    
#if 0
        trMeca_RAnsAnnoActiveStatus &operator=(trMeca_RAnsAnnoActiveStatus const &rhs) {
            if (this == &rhs)  {
                return *this;  // Same object
            }
            enActiveStatus=rhs.enActiveStatus;
            enAnnoSourceInfo=rhs.enAnnoSourceInfo;
            u16AnnoMask=rhs.u16AnnoMask;
            u8ClusterId=rhs.u8ClusterId;
            u8SubRegionId=rhs.u8SubRegionId;
            u8SubChId=rhs.u8SubChId;
            rAnnoFlags=rhs.rAnnoFlags;
            return *this;
        }
#endif 

		trMeca_RAnsAnnoActiveStatus():
		enActiveStatus(DAB::enMeca_AnsAnnoActiveStatus_End),
        enAnnoSourceInfo(DAB::enMeca_AnsAnnoSourceInfo_CE),
        u16AnnoMask(0),
        u8ClusterId(0),
        u8SubRegionId(0),
        u8SubChId(0),
        rAnnoFlags()
        {
        	
        }
        virtual tBool bParse(trMostHdr const &rMostHdr, tU8 const *pu8Data) {
            if (rMostHdr._u16MecaLen != 14) {
                return FALSE;
            }
            _rMostHdr=rMostHdr;
            enActiveStatus=(tenMeca_AnsAnnoActiveStatus)pu8Data[0];
            enAnnoSourceInfo=(tenMeca_AnsAnnoSourceInfo)pu8Data[1];
            if (enMeca_AnsAnnoSourceInfo_CE != enAnnoSourceInfo) {
                return FALSE;
            }
            u16AnnoMask = DABDRV_GET_U16(&pu8Data[2]);
            rAnnoFlags.vParse(pu8Data[4]);
            u8ClusterId = pu8Data[5];
            u8SubRegionId = pu8Data[6];
            u8SubChId =pu8Data[7];
                
            return TRUE;
        }

        virtual tVoid vTrace() const {
            ETG_TRACE_USR1(("  trMeca_RAnsAnnoActiveStatus:enActiveStatus=%x enAnnoSourceInfo=%d u16AnnoMask=0x%x ..."
                            "u8ClusterId=0x%x u8SubRegionId=0x%x u8SubChId=0x%x",
                            ETG_CENUM(tenMeca_AnsAnnoActiveStatus, enActiveStatus),
                            ETG_CENUM(tenMeca_AnsAnnoSourceInfo, enAnnoSourceInfo),
                            u16AnnoMask,
                            u8ClusterId,
                            u8SubRegionId,
                            u8SubChId));
            rAnnoFlags.vTrace();
        };
    
        tenMeca_AnsAnnoActiveStatus enActiveStatus;
        tenMeca_AnsAnnoSourceInfo enAnnoSourceInfo;
        tU16 u16AnnoMask;
        tU8 u8ClusterId;
        tU8 u8SubRegionId;
        tU8 u8SubChId;
        trAnnoFlags rAnnoFlags;
    };



    // _DAB_C_ANS_SELECT_ANNO
    struct trMeca_CAnsSelectAnno:
        public  trMsgMecaOut {
        DAB_DISPATCH_IMPL

        virtual tVoid vSerialize(trMsgMecaRawOutput *pRawOutput) const {
            pRawOutput->u16FBlockId = DAB_FBLOCK_ID;
            pRawOutput->u16MsgType = MECA_DISPATCHER_C_ANS_SELECT_ANNO;
            pRawOutput->enOpType = enOpType_SET;
            pRawOutput->u16DataLen = 14;
            OSAL_pvMemorySet(pRawOutput->au8Data,0,pRawOutput->u16DataLen);

            pRawOutput->au8Data[0]= bSelect ? 1:0;
            pRawOutput->au8Data[1]= (tU8)enAnnoSourceInfo;
            DABDRV_SET_U16(&pRawOutput->au8Data[2],u16AnnoMask);
            rAnnoFlags.vSerialize(&pRawOutput->au8Data[4]);
            pRawOutput->au8Data[5]=u8ClusterId;
            pRawOutput->au8Data[6]=u8SubRegionId;
            pRawOutput->au8Data[7]=u8SubChId;
        }

        trMeca_CAnsSelectAnno(trMeca_RAnsAnnoActiveStatus const &rActiveStatus, tBool bSelect_=TRUE) {
            bSelect=bSelect_;
            enAnnoSourceInfo=rActiveStatus.enAnnoSourceInfo ;
            u16AnnoMask=rActiveStatus.u16AnnoMask;
            rAnnoFlags=rActiveStatus.rAnnoFlags;
            u8ClusterId=rActiveStatus.u8ClusterId;
            u8SubRegionId=rActiveStatus.u8SubRegionId;
            u8SubChId=rActiveStatus.u8SubChId;
        }
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1(("  trMeca_CAnsSelectAnno:bSelect=%x enAnnoSourceInfo=%d u16AnnoMask=0x%x ..."
                            "u8ClusterId=0x%x u8SubRegionId=0x%x u8SubChId=0x%x",
                            bSelect,
                            ETG_CENUM(tenMeca_AnsAnnoSourceInfo, enAnnoSourceInfo),
                            u16AnnoMask,
                            u8ClusterId,
                            u8SubRegionId,
                            u8SubChId));
            rAnnoFlags.vTrace();
        };

        tBool bSelect;
        tenMeca_AnsAnnoSourceInfo enAnnoSourceInfo;
        tU16 u16AnnoMask;
        trAnnoFlags rAnnoFlags;
        tU8 u8ClusterId;
        tU8 u8SubRegionId;
        tU8 u8SubChId;
    };

    typedef enum {
        enMeca_AnsAnnoSelectedStatus_Deselected = 0x00, 
        enMeca_AnsAnnoSelectedStatus_Selected = 0x01, 
        enMeca_AnsAnnoSelectedStatus_NoActiveAnno = 0xe1, 
        enMeca_AnsAnnoSelectedStatus_NoPermissionToSwitch = 0xe2, 
        enMeca_AnsAnnoSelectedStatus_SelectError = 0xef
    } tenMeca_AnsAnnoSelectedStatus;


    // DAB_*_R_ANS_SELECT_ANNO
    struct trMeca_RAnsSelectAnno:
        public trMsgMecaInput {
        DAB_DISPATCH_IMPL
    
        virtual tBool bParse(trMostHdr const &rMostHdr, tU8 const *pu8Data) {
            if (rMostHdr._u16MecaLen != 14) {
                return FALSE;
            }
            _rMostHdr=rMostHdr;
            enAnnoSelectedStatus = (tenMeca_AnsAnnoSelectedStatus)pu8Data[0];
            enAnnoSourceInfo=(tenMeca_AnsAnnoSourceInfo)pu8Data[1];
            if (enMeca_AnsAnnoSourceInfo_CE != enAnnoSourceInfo) {
                return FALSE;
            }
            u16AnnoMask = DABDRV_GET_U16(&pu8Data[2]);
            rAnnoFlags.vParse(pu8Data[4]);
            u8ClusterId = pu8Data[5];
            u8SubRegionId = pu8Data[6];
            u8SubChId =pu8Data[7];
        
            return TRUE;
        }

        virtual tVoid vTrace() const {
            ETG_TRACE_USR1(("  trMeca_RAnsSelectAnno:enAnnoSelectedStatus=%d enActiveStatus=%x u16AnnoMask=0x%x ..."
                            "u8ClusterId=0x%x u8SubRegionId=0x%x u8SubChId=0x%x",
                            ETG_CENUM(tenMeca_AnsAnnoSelectedStatus, enAnnoSelectedStatus),
                            ETG_CENUM(tenMeca_AnsAnnoSourceInfo, enAnnoSourceInfo),
                            u16AnnoMask,
                            u8ClusterId,
                            u8SubRegionId,
                            u8SubChId));
            rAnnoFlags.vTrace();
        };

        tenMeca_AnsAnnoSelectedStatus enAnnoSelectedStatus;
        tenMeca_AnsAnnoSourceInfo enAnnoSourceInfo;
        tU16 u16AnnoMask;
        trAnnoFlags rAnnoFlags;
        tU8 u8ClusterId;
        tU8 u8SubRegionId;
        tU8 u8SubChId;
    };


    typedef enum {
        enMeca_AnsRegionFilter_NoRegionSetting = 0x00, 
        enMeca_AnsRegionFilter_NoRegionsValid = 0x01, 
        enMeca_AnsRegionFilter_CurrentRegionsValid = 0x02, 
        enMeca_AnsRegionFilter_CurrentRegionsOrGlobalValid = 0x03
    } tenMeca_AnsRegionFilter;


    // _DAB_C_ANS_SET_ANNO_MODE
    struct trMeca_CAnsSetAnnoMode:
        public  trMsgMecaOut {
        DAB_DISPATCH_IMPL

        virtual tVoid vSerialize(trMsgMecaRawOutput *pRawOutput) const {
            pRawOutput->u16FBlockId = DAB_FBLOCK_ID;
            pRawOutput->u16MsgType = MECA_DISPATCHER_C_ANS_SET_ANNO_MODE;
            pRawOutput->enOpType = enOpType_SET;
            pRawOutput->u16DataLen = 3;
            pRawOutput->au8Data[0]= (tU8)((bFilterActive ? 1: 0) | (bOtherClusterSignalling ? 2: 0)  | (bInterruptible ? 4: 0));
            pRawOutput->au8Data[1]= (tU8)enRegionFilter;
            pRawOutput->au8Data[2]= 0;
        }

        virtual tVoid vTrace() const {
            ETG_TRACE_USR1(("  trMeca_CAnsSetAnnoMode:bFilterActive=%d bOtherClusterSignalling=%d bInterruptible=%d "
                            "enRegionFilter=%x",
                            bFilterActive,
                            bOtherClusterSignalling,
                            bInterruptible,
                            ETG_CENUM(tenMeca_AnsRegionFilter, enRegionFilter)));
        };
    
        tBool bFilterActive;
        tBool bOtherClusterSignalling;
        tBool bInterruptible;
        tenMeca_AnsRegionFilter enRegionFilter;
    
    };


    // DAB_*_R_ANS_SET_ANNO_MODE
    struct trMeca_RAnsSetAnnoMode:
        public trMsgMecaInput {
        DAB_DISPATCH_IMPL
    
        virtual tBool bParse(trMostHdr const &rMostHdr, tU8 const *pu8Data) {
            if (rMostHdr._u16MecaLen != 3) {
                return FALSE;
            }
            _rMostHdr=rMostHdr;
            bFilterActive =           DAB_BOOL_FROM_BIT(pu8Data[0], DAB_b0);
            bOtherClusterSignalling = DAB_BOOL_FROM_BIT(pu8Data[0], DAB_b1);
            bInterruptible =          DAB_BOOL_FROM_BIT(pu8Data[0], DAB_b2);
            enRegionFilter = (tenMeca_AnsRegionFilter)pu8Data[1];
            return TRUE;
        }
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1(("  trMeca_RAnsSetAnnoMode:bFilterActive=%d bOtherClusterSignalling=%d bInterruptible=%d enRegionFilter=%x",
                            bFilterActive,
                            bOtherClusterSignalling,
                            bInterruptible,
                            ETG_CENUM(tenMeca_AnsRegionFilter, enRegionFilter)));
        };
    
        tBool bFilterActive;
        tBool bOtherClusterSignalling;
        tBool bInterruptible;
        tenMeca_AnsRegionFilter enRegionFilter;
    };


    // _DAB_C_ANS_GET_ANNO_INFO
    struct trMeca_CAnsGetAnnoInfo:
        public  trMsgMecaOut {
        DAB_DISPATCH_IMPL

        trMeca_CAnsGetAnnoInfo() {}
        virtual tVoid vSerialize(trMsgMecaRawOutput *pRawOutput) const {
            pRawOutput->u16FBlockId = DAB_FBLOCK_ID;
            pRawOutput->u16MsgType = MECA_DISPATCHER_C_ANS_GET_ANNO_INFO;
            pRawOutput->enOpType = enOpType_GET;
            pRawOutput->u16DataLen = 0;
        }

        virtual tVoid vTrace() const {
            ETG_TRACE_USR1(("  trMeca_CAnsGetAnnoInfo"));
        };
    
    };





    // DAB_*_R_ANS_GET_ANNO_INFO
    struct trMeca_RAnsGetAnnoInfo:
        public trMsgMecaInput {
        DAB_DISPATCH_IMPL
    
        virtual tBool bParse(trMostHdr const &rMostHdr, tU8 const *pu8Data) {
            if (rMostHdr._u16MecaLen != 17) {
                return FALSE;
            }
            _rMostHdr=rMostHdr;
            u16AnnoEnabled = DABDRV_GET_U16(&pu8Data[0]);
            u16AnnoFilterEnabled = DABDRV_GET_U16(&pu8Data[2]);
            u16AnnoActive = DABDRV_GET_U16(&pu8Data[4]);
            u16AnnoSelected = DABDRV_GET_U16(&pu8Data[6]);
            rAnnoFlags.vParse(pu8Data[8]);
            enRegionFilter = (tenMeca_AnsRegionFilter)pu8Data[9];

            return TRUE;
        }
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1(("  trMeca_RAnsGetAnnoInfo:u16AnnoEnabled=0x%x u16AnnoFilterEnabled=0x%x "
                            "u16AnnoActive=0x%x u16AnnoSelected=0x%x enRegionFilter=%x ...",
                            u16AnnoEnabled,
                            u16AnnoFilterEnabled,
                            u16AnnoActive,
                            u16AnnoSelected,
                            ETG_CENUM(tenMeca_AnsRegionFilter, enRegionFilter)));
            rAnnoFlags.vTrace();
        };
    
        tU16 u16AnnoEnabled;
        tU16 u16AnnoFilterEnabled;
        tU16 u16AnnoActive;
        tU16 u16AnnoSelected;
        trAnnoFlags rAnnoFlags;
        tenMeca_AnsRegionFilter enRegionFilter;
    };


    // _DAB_C_ANS_CONFIG_ANNO
    struct trMeca_CAnsConfigAnno:
        public  trMsgMecaOut {
        DAB_DISPATCH_IMPL

        trMeca_CAnsConfigAnno():
            bSet(TRUE),
            u16AnnoTypesMask(0),
            u16AnnoFilterMask(0)
        {}
        virtual tVoid vSerialize(trMsgMecaRawOutput *pRawOutput) const {
            pRawOutput->u16FBlockId = DAB_FBLOCK_ID;
            pRawOutput->u16MsgType = MECA_DISPATCHER_C_ANS_CONFIG_ANNO;
            pRawOutput->enOpType = bSet ? enOpType_SET : enOpType_GET;
            pRawOutput->u16DataLen = 8;
            OSAL_pvMemorySet(pRawOutput->au8Data,0,pRawOutput->u16DataLen);
            pRawOutput->au8Data[0]= bSet ? 0x01 : 0xFF;
            DABDRV_SET_U16(&pRawOutput->au8Data[2],u16AnnoTypesMask);
            DABDRV_SET_U16(&pRawOutput->au8Data[4],u16AnnoFilterMask);
        }

        virtual tVoid vTrace() const {
            ETG_TRACE_USR1(("  trMeca_CAnsConfigAnno:bSet=%d u16AnnoTypesMask=0x%x u16AnnoFilterMask=0x%x",
                            bSet,
                            u16AnnoTypesMask,
                            u16AnnoFilterMask));
        };
        tBool bSet;
        tU16 u16AnnoTypesMask;
        tU16 u16AnnoFilterMask;

    };


    // DAB_*_R_ANS_CONFIG_ANNO
    struct trMeca_RAnsConfigAnno:
        public trMsgMecaInput {
        DAB_DISPATCH_IMPL
    
        virtual tBool bParse(trMostHdr const &rMostHdr, tU8 const *pu8Data) {
            if (rMostHdr._u16MecaLen != 6) {
                return FALSE;
            }
            _rMostHdr=rMostHdr;
            u16AnnoTypesMask = DABDRV_GET_U16(&pu8Data[0]);
            u16AnnoFilterMask = DABDRV_GET_U16(&pu8Data[2]);
            return TRUE;
        }
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1(("  trMeca_RAnsConfigAnno:u16AnnoTypesMask=0x%x u16AnnoFilterMask=0x%x",
                            u16AnnoTypesMask,
                            u16AnnoFilterMask));
        };
    
        tU16 u16AnnoTypesMask;
        tU16 u16AnnoFilterMask;
    };

	struct trAnnoElement{
		trAnnoElement():
	u16AnnoTypesMask(0),
		enAnnoStatus(DAB::enMeca_AnsAnnoActiveStatus_End),
		u8SubChId(0)
	{
	}
	tVoid vTrace() const {
		ETG_TRACE_USR1((" trAnnoElement:u16AnnoTypesMask=%d enAnnoStatus=%d u8SubChId=%d",
			u16AnnoTypesMask,
			ETG_CENUM(tenMeca_AnsAnnoActiveStatus, enAnnoStatus),
			u8SubChId));            
	}
	bool operator!=(trAnnoElement const& b) const
	{
		DAB_RET_1_IF_NEQ(u16AnnoTypesMask);
		DAB_RET_1_IF_NEQ(enAnnoStatus);
		DAB_RET_1_IF_NEQ(u8SubChId);
	    return FALSE;
	}
	bool operator==(trAnnoElement const& b) const
	{
		DAB_RET_0_IF_NEQ(u16AnnoTypesMask);
		DAB_RET_0_IF_NEQ(enAnnoStatus);
		DAB_RET_0_IF_NEQ(u8SubChId);
	    return TRUE;
	}
	tU16 u16AnnoTypesMask;
	DAB::tenMeca_AnsAnnoActiveStatus enAnnoStatus;
	tU8 u8SubChId;
	};
} // namespace DAB


#endif
