/************************************************************************
 * FILE:         dabdrv_typeEnums.h
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of dabdrv_typeEnums
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      	| Author                       | Modification
				  
				
 *************************************************************************/

#ifndef DABDRV_TYPE_ENUMS_H
#define DABDRV_TYPE_ENUMS_H

namespace DAB {
     //lint -esym(793,*identifiers in one block*)
    //midw_ext_fi_tcl_e8_DAB_Response
    typedef enum {
        DAB_enResult_OK,
        DAB_enResult_FAILED,
        DAB_enResult_NOT_AVAILABLE,
        DAB_enResult_INPROCESS
    } DAB_tenResult;

    //midw_ext_fi_tcl_e8_DAB_ServiceLinkingMode
    typedef enum {
        DAB_enServiceLinkingMode_OFF = 0x0UL,
        DAB_enServiceLinkingMode_DAB = 0x1UL,
        DAB_enServiceLinkingMode_DAB_FM = 0x2UL,
        DAB_enServiceLinkingMode_FM = 0x3UL
    } DAB_tenServiceLinkingMode;

    typedef enum {
        DAB_enDrvActivity_Idle,
        DAB_enDrvActivity_TuneComp,
        DAB_enDrvActivity_TuneSrv,
        DAB_enDrvActivity_Learn,
        DAB_enDrvActivity_Anno,
        DAB_enDrvActivity_SrvFollowTsu,
        DAB_enDrvActivity_TmcLearn,
        DAB_enDrvActivity_TmcRead,
        DAB_enDrvActivity_SysStore,
        DAB_enDrvActivity_TestOperation
    } DAB_tenDrvActivity;

    typedef enum {
        DAB_enDrvActivityState_Idle,
        DAB_enDrvActivityState_Pending,
        DAB_enDrvActivityState_Running,
        DAB_enDrvActivityState_Terminating
    } DAB_tenDrvActivityState;

    typedef enum {
        DAB_enDrvActivityListState_Idle,
        DAB_enDrvActivityListState_Pending,
        DAB_enDrvActivityListState_Terminating,
        DAB_enDrvActivityListState_Interruptible,
        DAB_enDrvActivityListState_NonInterruptible
    } DAB_tenDrvActivityListState;

    // midw_ext_fi_tcl_e8_DAB_FrequencyTableType
    typedef enum {
        DAB_enFrequencyTableType_EUROPE = 17,
        DAB_enFrequencyTableType_CANADA = 18,
        DAB_enFrequencyTableType_EUROPE_NEW = 19,
        DAB_enFrequencyTableType_EUROPE_BAND3 = 20,
        DAB_enFrequencyTableType_EUROPE_BAND3_NEW = 21,
        DAB_enFrequencyTableType_EUROPE_LBAND = 22,
        DAB_enFrequencyTableType_EUROPE_KOREA = 23,
        DAB_enFrequencyTableType_EUROPE_CHINA = 24,
        DAB_enFrequencyTableType_EUROPE_CHINA_BAND3 = 25,
        DAB_enFrequencyTableType_EUROPE_CHINA_LBAND = 26
    } DAB_tenFrequencyTableType;

    typedef enum {
        DAB_enSourceState_BG,
        DAB_enSourceState_FG,
        DAB_enSourceState_SrvFollow,
        DAB_enSourceState_FG_TA,
		DAB_enSourceState_ALARM,
		DAB_enSourceState_BG_ANNO_SURVEILLANCE,
		DAB_enSourceState_FG_ANNO_SURVEILLANCE,
		DAB_enSourceState_DAB_LEARN_FOREVER,
		DAB_enSourceState_DAB_BG_LEARN_FOREVER
    } DAB_tenSourceState;



    // midw_ext_fi_tcl_e8_DAB_TunerActivityType

    typedef enum {
        DAB_enMtcMode_Off = 0,
        DAB_enMtcMode_DAB_FM_On = 1,
        DAB_enMtcMode_FM_DAB_On = 2,
		DAB_enMtcMode_BOTH_On = 3
    } DAB_tenMtcMode;

	typedef enum {
        DAB_enMtcRequestSwitch_DAB = 0,
        DAB_enMtcRequestSwitch_FM = 1
    } DAB_tenMtcRequestSwitch;

	typedef enum {
        DAB_enMtcTunerSwitchStatus_Main_DAB = 0,
        DAB_enMtcTunerSwitchStatus_Main_FM = 1,
		DAB_enMtcTunerSwitchStatus_Main_Unknown = 2
    } DAB_tenMtcTunerSwitchStatus;


	typedef enum {
        DAB_enMtcActivityState_Stop = 0,
        DAB_enMtcActivityState_FM = 1,
		DAB_enMtcActivityState_DAB = 2
    } DAB_tenMtcActivityState;


	typedef enum {
        DAB_enMtcStationType_DAB = 0,
        DAB_enMtcStationType_FM = 1
    } DAB_tenMtcStationType;


	typedef enum {
        DAB_enMtcTPState_No_TP = 0,
        DAB_enMtcSTPState_TP = 1
    } DAB_tenMtcTPState;

    typedef enum {
        DAB_enTunerActivityType_NORMAL = 0,
        DAB_enTunerActivityType_LEARN = 1,
        DAB_enTunerActivityType_SEEK = 2,
        DAB_enTunerActivityType_SCAN = 3,
        DAB_enTunerActivityType_SERVICESEEK = 4,
	    DAB_enTunerActivityType_TAFOLLOWING = 5,
	    DAB_enTunerActivityType_SERVICEFOLLOWING = 6,
	    DAB_enTunerActivityType_TPMONITOR = 7,
	    DAB_enTunerActivityType_INVALID = 8
    } DAB_tenTunerActivityType;

    // midw_fi_tcl_e8_TestResult
    typedef enum {
        DAB_tenTestResult_PASSED = 0,
        DAB_tenTestResult_FAILED = 1,
        DAB_tenTestResult_NORESULT = 2,
		DAB_tenTestResult_PASSEDDIAGNOSTIC = 3,
		DAB_tenTestResult_FAILEDDIAGNOSTIC = 4,
		DAB_tenTestResult_NORESULTDIAGNOSTIC = 5,
		DAB_tenTestResult_DISABLE = 6,
		DAB_tenTestResult_ENABLE = 7
    } DAB_tenTestResult;

    // midw_fi_tcl_e8_TestResult
    typedef enum {
        DAB_enTestOperation_INVALID = 0,
        DAB_enTestOperation_TUNE_ENSEMBLE ,
        DAB_enTestOperation_TUNE_SERVICE ,
        DAB_enTestOperation_TUNE_FREQUENCY ,
        DAB_enTestOperation_PLAY_ASID ,
        DAB_enTestOperation_VERIFY_FREQ_ASID_AUDIO ,
        DAB_enTestOperation_REMOTE_CTRL_ENTER,
        DAB_enTestOperation_REMOTE_CTRL_LEAVE,
        DAB_enTestOperation_TESTMODE_ACTIVE,
        DAB_enTestOperation_SF_ON_OFF,
        DAB_enTestOperation_CONCEALMENT_LEVEL,
        DAB_enTestOperation_SECONDARY_SERVICE_SELECT
    } DAB_tenTestOperation;


    // midw_ext_fi_tcl_b16_DAB_TunerStatusFlags 
    typedef enum {
        DAB_enTunerStatusFlagBitPos_SYNC = 0,
        DAB_enTunerStatusFlagBitPos_ENS_VALID = 1,
        DAB_enTunerStatusFlagBitPos_AUDIO_SERVICE_VALID =2,
        DAB_enTunerStatusFlagBitPos_SERVICE_COMP_VALID = 3,
        DAB_enTunerStatusFlagBitPos_MUTE = 4,
        DAB_enTunerStatusFlagBitPos_TUNING = 5,
        DAB_enTunerStatusFlagBitPos_LEARN = 8
    } DAB_tenTunerStatusFlagBitPos;

    typedef enum {
        tenListOperation_OPEN,
        tenListOperation_CLOSE,
        tenListOperation_GET,
        tenListOperation_INVALID
    } tenListOperation;

    typedef enum {
		enChnList_Global,
		enChnList_CurrentEnsemble,
		enChnList_INVALID
	} tenChnListType;

	typedef enum {
		enFrozenList_Ensemble,
		enFrozenList_Service,
		enFrozenList_INVALID
	} tenFrozenListType;

    typedef enum {
        enAnnoSource_NONE=0,
        enAnnoSource_CURRENT_SUBCHANNEL=1,
        enAnnoSource_CURRENT_SERVICE=2,
        enAnnoSource_CURRENT_ENSEMBLE=3
    } tenAnnoSource;

    typedef enum {
        enAnnoSelectState_IDLE=0,
        enAnnoSelectState_PENDING=1,
        enAnnoSelectState_SELECTING=2,
        enAnnoSelectState_SELECTED=3,
        enAnnoSelectState_DESELECTING=4
    } tenAnnoSelectState;



    typedef enum {
        enChnSelectMode_Psid,
        enChnSelectMode_ListId,
        enChnSelectMode_Relative,
        enChnSelectMode_Invalid
    }tenChnSelectMode;

	typedef enum {
        enEnsSelectMode_Eid,
        enEnsSelectMode_ListId,
        enEnsSelectMode_Relative,
        enEnsSelectMode_Invalid
    }tenEnsSelectMode;

    typedef enum {
        enChnSelectSource_ChnSelect,
        enChnSelectSource_RecallPreset,
        enChnSelectSource_Lsm,
        enChnSelectSource_Internal,
        enChnSelectSource_None
    }tenChnSelectSource;

    typedef enum {
        enSourceActivity_Inactive,
        enSourceActivity_DemuteRunning,
        enSourceActivity_Play
    } tenSourceActivity;

    //midw_ext_fi_tcl_e8_DAB_LearnType
    typedef enum {
        enLearnType_OFF = 0UL,
        enLearnType_UPDATE = 1UL,
        enLearnType_VIRGIN = 2UL
    } tenLearnType;

    typedef enum {
        enDefsetType_TEF,
        enDefsetType_USER,
        enDefsetType_INVALID
    } tenDefsetType;

    typedef enum {
    	enDiagAction_NONE,
    	enDiagAction_PREPARE,
    	enDiagAction_SET,
    	enDiagAction_FINISH
    } tenDiagAction;

    typedef enum{
    	enPresetListToHMI_None,
    	enPresetListToHMI_INPROGRESS,
    	enPresetListToHMI_NOTUPDATED,
    	enPresetListHMI_UPDATEDONE
    } tenPresetListToHMIStatus;

    typedef enum {
        enLinkType_DAB_HARDLINK,
        enLinkType_DAB_SOFTLINK,
        enLinkType_DAB_NOLINK,
        enLinkType_FM_HARDLINK,
        enLinkType_FM_SOFTLINK,
        enLinkType_FM_NOLINK,
		enLinkType_DAB_DBLINK
    } tenLinkType;


    typedef enum {
        enChnState_Stable,
        enChnState_Selecting, // chnInfo shall already show new channel
        enChnState_SelectingWait, // advisory "Waiting" shall be added
        enChnState_SelectingSearch, // advisory "Search" shall be added, chanName shall be cleard
        enChnState_Unavail, // advisory "not Available" shall be added, chanName shall be shown if avail
        enChnState_Invalid
    } tenChnState;

    
    typedef enum {
        enRdmNotifyMode_Normal, 
        enRdmNotifyMode_TestMode, 
        enRdmNotifyMode_Off,
        enRdmNotifyMode_Learn,
        enRdmNotifyMode_FreqInfo,
        enRdmNotifyMode_Invalid // used to switch back to setting before testmode
    } tenRdmNotifyMode;

    typedef enum {
        enDbNotifyMode_Normal, 
        enDbNotifyMode_TestMode, 
        enDbNotifyMode_Off,
        enDbNotifyMode_Invalid // used to switch back to setting before testmode
    } tenDbNotifyMode;

    // midw_ext_fi_tcl_e8_DAB_ComponentType
    typedef enum {
        DAB_enComponentType_PRIMARY = 0,
        DAB_enComponentType_SECONDARY = 1
    } DAB_tenComponentType;

    // midw_ext_fi_tcl_e8_DAB_TMIdType
    typedef enum {
        DAB_enTMIdType_MSC_AUDIO_STREAM = 0,
        DAB_enTMIdType_MSC_DATA_STREAM = 1,
        DAB_enTMIdType_FIDC = 2,
        DAB_enTMIdType_MSC_DATA_PACKET = 3
    } DAB_tenTMIdType;

    // midw_ext_fi_tcl_e8_DAB_ServiceType
    typedef enum {
        DAB_enServiceType_UNKNOWN = 0,
        DAB_enServiceType_AUDIO = 1,
        DAB_enServiceType_DATA = 2
    } DAB_tenServiceType;

    // midw_ext_fi_tcl_e8_DAB_SampleRate
    typedef enum {
        DAB_enSampleRate_48KHZ = 0,
        DAB_enSampleRate_24KHZ = 1
    } DAB_tenSampleRate;
    
    // midw_ext_fi_tcl_e8_DAB_AudioMode
    typedef enum {
        DAB_enAudioMode_STEREO = 0,
        DAB_enAudioMode_JOINT_STEREO = 1,
        DAB_enAudioMode_DUAL_CHANNEL = 2,
        DAB_enAudioMode_MONO = 3
    } DAB_tenAudioMode;

    // midw_ext_fi_tcl_e8_DAB_AudioCodec
    typedef enum {
        DAB_enAudioCodec_NOT_RECOGNIZED = 0,
        DAB_enAudioCodec_MUSICAM = 1,
        DAB_enAudioCodec_DABPLUS = 2,
        DAB_enAudioCodec_DMB_AUDIO = 3
    } DAB_tenAudioCodec; 


    typedef enum {
        enSrvFollowClass_Off,
        enSrvFollowClass_ChnSelect,
        enSrvFollowClass_Normal,
        enSrvFollowClass_Skip,
        enSrvFollowClass_Last
    } tenSrvFollowClass;

     typedef enum {
        enTmcMediumType_RESERVED = 0x0UL,
        enTmcMediumType_FM = 0x1UL,
        enTmcMediumType_DAB = 0x2UL,
        enTmcMediumType_SAT = 0x3UL
    } tenTmcMediumType;

     typedef enum {
        enDabDbFilterId_None = 0,
        enDabDbFilterId_Default = 1,
        enDabDbFilterId_TMC = 2,
        enDabDbFilterId_AudioService = 3,
        enDabDbFilterId_AudioComponent = 4
    } tenDabDbFilterId;

      // midw_ext_fi_tcl_e8_DAB_TuneCmd
    typedef enum {
        DAB_enTuneCmd_Next = 0,
        DAB_enTuneCmd_Previous = 1
    } tenTuneCmd;

    typedef enum {
        DAB_enExpApiRequest_Description = 0x01,
        DAB_enExpApiRequest_Value = 0x02
    } tenExpApiRequest;

    typedef enum {
        enARLMuteState_Muted,
        enARLMuteState_Demuted, // chnInfo shall already show new channel
        enARLMuteState_Demute_Running
    } tenARLMuteState;

    typedef enum {
        enDabSource_Dab = 0,
        enDabSource_DabTa = 1
    } tenDabSource;


typedef enum {
        enAutostore_Normal = 0,
        enAutostore_Initial = 1,
		enAutostore_InValid =2
    } tenAutostoreType;

typedef enum {
        enAutostoreAction_Stop = 0,
        enAutostoreAction_Start = 1,
		enAutostoreAction_InValid =2
    } tenAutostoreAction;

    typedef enum {
	   enDLPlusContentType_Dummy = 0,
	   enDLPlusContentType_Title = 1,
	   enDLPlusContentType_Artist = 4
   } tenDLPlusContentType;

   typedef enum {
          enLinkingSetupMask_None = 0x01,
          enLinkingSetupMask_DAB_FM_LINKING_Threshold = 0x02,
          enLinkingSetupMask_DAB_FM_LINKING_BACK_Threshold = 0x04,
          enLinkingSetupMask_DAB_FM_LINKING_BACK_Validation_Time = 0x08,
          enLinkingSetupMask_DAB_FM_Link_Back_Delay = 0x10
      } tenLinkingSetupMask;
 typedef enum {
	   enEnsembleListSortingType_LABEL = 0,
	   enEnsembleListSortingType_Freq = 1,
	   enEnsembleListSortingType_EID = 2
	   
   } tenEnsembleListSortingType;
//lint -esym(793,*identifiers in one block*)
 typedef enum {
	  enServiceListSortingType_LABEL = 0,	
	  enServiceListSortingType_SID = 1
	    
   } tenServiceListSortingType;
}
typedef enum {
        DAB_enPresetListDelete_OneElem = 0,
        DAB_enPresetListDelete_AllElems = 1,
        DAB_enPresetListDelete_None = 2
    } DAB_tenPresetListDeleteAction;

typedef enum{
	DAB_tenChnlPresetNumber_Highest,
	DAB_tenChnlPresetNumber_Least
}DAB_tenChnlPresetNumberType;

    typedef enum {
  		 DAB_enTuneType_INVALID = 0,
  		 DAB_enTuneType_TUNE_ENSEMBLE = 1,
  		 DAB_enTuneType_TUNE_SERVICE = 2
    }DAB_tenTuneType;

    typedef enum {
    	 DAB_tenEnsThreshold_LevelMin1 = 0x04UL,
    	 DAB_tenEnsThreshold_LevelMax1 = 0x06UL,
    	 DAB_tenEnsThreshold_LevelMin2 = 0x08UL,
    	 DAB_tenEnsThreshold_LevelMax2 = 0x0FUL
    }DAB_tenEnsThreshold;

    typedef enum {
     		 DAB_enEnsSetupType_INVALID = 0,
     		 DAB_enEnsSetupType_INSERTION = 1,
     		 DAB_enEnsSetupType_DELETION = 2
    }DAB_tenEnsembleSetupType;

    typedef enum {
        enRDMQualityConfigCmd_ERROR = 0x00,
        enRDMQualityConfigCmd_OK = 0x01
    } tenRDMQualityConfig;
	typedef enum{
		Query_InitialAutostore,
		Query_SelfLearnedLinkInfo,
		Query_EnsembleList_Prepare,
		Query_EnsembleList_Evaluate,
		Query_GlobalList_Prepare,
		Query_GlobalList_Evaluate,
		Query_AltFreqInformation,
		Query_PresetInfo_All,
		Query_PresetInfo
	}tenDbQueryType;
	typedef enum{
			QueryTrigger_EnsembleList,
			QueryTrigger_GlobalList
	}tenDbQueryTriggerType;

typedef enum{
			PresetOrChannelRecallInvalid = 0,
			PresetRecall = 1,
			ChannelRecall = 2
	}ten_PresetOrChannelRecall;

#ifdef MUTE_ACTIVE
    typedef enum {
    	enMuteOperation_None,
        enMuteOperation_EnsembleSeek,
        enMuteOperation_ServiceSeek,
        enMuteOperation_ManualTune,
        enMuteOperation_PresetLoad,
        enMuteOperation_LoadFromList,
        enMuteOperation_LearnUpdate,
        enMuteOperation_TuneFreqLabel
    } tenMuteOperation;

    typedef enum {
    	enRequiredMuteState_Mute,
    	enRequiredMuteState_Demute,
    	enRequiredMuteState_None
    } tenRequiredMuteState;
#endif
    typedef enum {
        enSysStore
    } tenCmdProcessed;

    typedef enum {
        DAB_enUriSelectState_OK                             = 0x00UL,
        DAB_enUriSelectState_NOT_VALID                      = 0x01UL,
        DAB_enUriSelectState_NO_RESOURCES                   = 0x04UL,
        DAB_enUriSelectState_URI_NOT_VALID                  = 0x05UL,
        DAB_enUriSelectState_ALREADY_SELECTED               = 0x11UL,
        DAB_enUriSelectState_NOT_SELECTED                   = 0x12UL,
        DAB_enUriSelectState_URI_PROCESSING                 = 0x20UL,
        DAB_enUriSelectState_URI_ACTIVATED                  = 0x21UL,
        DAB_enUriSelectState_URI_ACIVATE_FAIL_SCHEDULER     = 0x22UL,
        DAB_enUriSelectState_URI_ACIVATE_FAIL_RECEPTION     = 0x23UL,
        DAB_enUriSelectState_URI_DEACIVATED_BY_SCHEDULER    = 0x24UL,
        DAB_enUriSelectState_URI_DEACIVATED_BY_SYNC_LOSS    = 0x25UL,
        DAB_enUriSelectState_ERROR                          = 0xffffUL
    } DAB_tenUriSelectState;

	typedef enum {
        Bank_DAB1 = 13,
		Bank_DAB2 = 14,
		Bank_DAB3 = 15,
		Bank_DAB4 = 16
    } DAB_tenBankList;


#endif
