/************************************************************************
 * FILE:         dabdrv_tsu.hpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of dabdrv_tsu
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      	| Author                       | Modification
				  
				
 *************************************************************************/

#ifndef DABDRV_TSU_HPP
#define DABDRV_TSU_HPP
#include "fc_dabtuner_util.h"
#include "dabdrv_types.hpp"
#include "dabdrv_main.hpp"
#include "dabdrv_activity.hpp"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_DRV_TSU 
#include "trcGenProj/Header/dabdrv_tsu.hpp.trc.h"
#endif

namespace DAB {

    class dabdrv_tsu:
        public DAB_Singleton<dabdrv_tsu>,
        public DAB_MessageHandlerCommon<dabdrv_tsu>
    {
        friend class DAB_Singleton<dabdrv_tsu>;

    public:
        DAB_TRACE_INFO_IMPL(FC_DABTUNER_TR_DRV_TSU);
        virtual tVoid vInit();
        virtual char const *pcGetName() const {return "dabdrv_tsu";};
        virtual tVoid vTraceState() const;
        virtual tVoid vProcess(trMsgDrvStartComponent* poStart);

        // commands from server
        virtual tVoid vProcess(trMsgDrvCmdMtcConfig* poMtcConfig);

        // responses from adr3
        virtual tVoid vProcess(trMeca_RMtcSetMode* poRSetMode);
        virtual tVoid vProcess(trMeca_RMtcSetConfig* poRSetConfig);
        virtual tVoid vProcess(trMeca_RMtcTunerStatus* poRTunerStatus);
        virtual tVoid vProcess(trMeca_RMtcSfRestart* poMtcSfRestart);
        virtual tVoid vProcess(trMsgSrvCmdMtcMode* poMtcMode);
        virtual tVoid vProcess(trMsgSrvCmdCriticalVoltage* poCriticalVoltage);
        virtual tVoid vProcess(trMsgSrvCmdMtcTunerstatus *poTunerStatus);
		
		//virtual tVoid vProcess(DAB::trMeca_RMtcRequestSwitch* poRRequestSwitch);
		//virtual tVoid vProcess(trMsgSrvCmdMtcRequestSwitch* poMtcRequestSwitch);

		//virtual tVoid vProcess(DAB::trMeca_RMtcAnnouncementState* poRRequestSwitch);

		virtual tVoid vProcess(DAB::trMeca_RMtcSurveillanceMonitor* poRSurveillanceMonitor); 
	virtual tVoid vProcess(DAB::trMeca_RFMSurveillanceInfos* poRFMSurveillanceInfos);
		//virtual tVoid vProcess(trMsgSrvCmdMtcTuner_ActivityState* poMtcActivity_State);

        tBool bRunActivity() const;
        tBool bTerminateActivity() const;

        tBool bIsSrvFollowActive() const {return bSrvFollowActive; }
        tVoid vValidateFMDABLinking(tU16 &value);
        //tBool vSetSrvFollowActive(const tBool bStatus){bSrvFollowActive = bStatus;}
        tVoid vForceDisbaleServiceLinking();
        tVoid vRestoreMtcServiceLinking();
        tBool isDABFMLinkingActive(DAB::trMeca_RMtcTunerStatus* poRTunerStatus);
        tBool isFMDABLinkingActive(DAB::trMeca_RMtcTunerStatus* poRTunerStatus);
    private:
        dabdrv_tsu();
        tVoid vSendSfMode();
        

        tBool _bTsuOn;
		tBool _bStartComponent;
        tU8 _u8FmQuality;
        tenMeca_TsuTunerId _enTunerId;
        trMecaId _rProgrammeService;
        trMecaId _rMonitoredFmProg;
        tBool _bTsuDisabled;
        tBool _bChnSelectActive;
        dabdrv_activityIr<dabdrv_tsu, (int)DAB_enDrvActivity_SrvFollowTsu> _oSrvFollowTsuActivity;
        trMeca_CMtcSetMode _rMtcSetMode;
        tBool bSrvFollowActive;
        tBool bForceDisableMtcSetMode;
        tVoid vUpdateTunerStatus(tenMeca_MtcTuner enMtcTuner);
    };

} //namespace DAB 

#endif
