/************************************************************************
 * FILE:         dabdrv_tsu.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of dabdrv_tsu
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      	| Author                       | Modification
				  
				
 *************************************************************************/

#include "fc_dabtuner_util.h"
#include "dabdrv_main.hpp"
#include "dabdrv_mecaIf.h"
#include "fc_dabtuner_config.hpp"
#include "dabdrv_tsu.hpp"
#include "dabdrv_testmode.hpp"
#include "dabdrv_chnSelect.hpp"

#ifndef DABTUNER_UTEST
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_fc_dabtuner_if.h"
#include "dp_generic_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_DRV_TSU 
#include "trcGenProj/Header/dabdrv_tsu.cpp.trc.h"
#endif

/**vnd4kor : Commented to solve prio2 lint*/
//#define DAB_TSU_USE_CONFIG

using namespace DAB;
// todo:handle bUserRequest
dabdrv_tsu::dabdrv_tsu(tVoid):
    _bTsuOn(FALSE),
	_bStartComponent(FALSE),
    _u8FmQuality(0),
    _enTunerId(enMeca_TsuTunerId_INVALID),
    _rProgrammeService(),
    _bTsuDisabled(FALSE),
    _bChnSelectActive(FALSE),
    bSrvFollowActive(0),
    bForceDisableMtcSetMode(FALSE)
{
    _rMtcSetMode.enTsuMode = DAB_enMtcMode_Off;
}

tVoid dabdrv_tsu::vInit(tVoid) {
    // subscribe
    vSubscribe<trMsgDrvStartComponent>();
    vSubscribe<trMsgDrvCmdMtcConfig>();
    vSubscribe<trMsgSrvCmdMtcTunerstatus>();

    vSubscribe<trMsgSrvCmdMtcMode>();
    vSubscribe<trMeca_RMtcSetMode>();
    vSubscribe<trMeca_RMtcSetConfig>();
    vSubscribe<trMeca_RMtcTunerStatus>();
    vSubscribe<trMeca_RMtcSfRestart>();
    vSubscribe<trMsgSrvCmdCriticalVoltage>();
	//vSubscribe<trMeca_RMtcRequestSwitch>();
	//vSubscribe<trMsgSrvCmdMtcRequestSwitch>();
	//vSubscribe<trMsgSrvCmdMtcTuner_ActivityState>();
	//vSubscribe<trMeca_RMtcAnnouncementState>();
    vSubscribe<trMeca_RMtcSurveillanceMonitor>();
    fc_dabtuner_config *poConfig=fc_dabtuner_config::instance();
    if((poConfig != nullptr) && poConfig->bIsSBRVariant())
    {
        vSubscribe<trMeca_RFMSurveillanceInfos>();
    }

    _bTsuDisabled=! (dabdrv_main::instance()->enGetServiceLinkingMode());
    _oSrvFollowTsuActivity.vSetPrio(enActivityPrio_Low); 

    dabdrv_main::instance()->vRegisterActivity(&_oSrvFollowTsuActivity);
	#ifndef DABTUNER_UTEST
		tU16 u16MTCState = 0;
		dp_tclDABTunerDPMTCMode dpMTC_mode;
		tU32 status = dpMTC_mode.s32GetData(u16MTCState);
		vValidateFMDABLinking(u16MTCState);   
		if(!status 
        #ifdef FEATURE_PSA_RCC
        && fc_dabtuner_config::instance()->bGetRdsFollowStatus()
        #endif
        ) //Read from KDS only if it is enabled in EOL
			_rMtcSetMode.enTsuMode = (DAB_tenMtcMode)u16MTCState;

		ETG_TRACE_USR1(("dabdrv_tsu::vInit : u16MTCState = %d  status %d", u16MTCState,status));
		
	#endif
}

tVoid dabdrv_tsu::vTraceState() const {
    ETG_TRACE_USR1(("  dabdrv_tsu STATE:_bTsuOn=%d _enTunerId=%d _rProgrammeService=0x%08x _rMonitoredFmProg=0x%08x _u8FmQuality=%d",
                    _bTsuOn,
                    ETG_CENUM(tenMeca_TsuTunerId, _enTunerId),
                    _rProgrammeService.u32GetSID(),
                    _rMonitoredFmProg.u32GetSID(),
                    _u8FmQuality));
}

tBool dabdrv_tsu::bRunActivity() const {
    return TRUE;
}

tBool dabdrv_tsu::bTerminateActivity() const {
    trMecaId rMecaId;
    // todo: add timer-tv
    ETG_TRACE_USR1(("dabdrv_tsu::bTerminateActivity START"));

    ETG_TRACE_USR1(("dabdrv_tsu::bTerminateActivity END"));
    return TRUE;
}

tVoid dabdrv_tsu::vProcess(trMsgDrvStartComponent* poStart) {
    (tVoid)poStart;
   
    fc_dabtuner_config *poConfig=fc_dabtuner_config::instance();
    if (OSAL_NULL ==poConfig) {
        return;
    }
    ETG_TRACE_USR4(( "\n"
                     " ****************************************************************************************\n"
                     " * M T C    trMeca_CMtcSetConfig \n"
                     " ****************************************************************************************"
                     ));

    _bStartComponent=TRUE;
    if (!poConfig->bIsSBRVariant())
    {
        trMeca_CMtcSetConfig rMtcCfg( poConfig->pcu8GetTsuMatrixDabFm(),
                                  poConfig->pcu8GetTsuMatrixFmDab(),
                                  poConfig->pcu8GetTsuConstantsDabFm(),
                                  poConfig->pcu8GetTsuConstantsFmDab());
        dabdrv_mecaIf::instance()->vSendMecaCommand(rMtcCfg);

        _bTsuOn=FALSE;
    }
    else
    {
        trMeca_CMtcNotification rMtcNotification;
        rMtcNotification.enMtcNotifyCtrl = /*enMeca_MtcNotify_SET_FUNCTION*/enMeca_MtcNotify_SET_ALL;
        rMtcNotification.u16MtcClientId = DAB_CLIENT_ID;
        dabdrv_mecaIf::instance()->vSendMecaCommand(rMtcNotification);

        if(_bStartComponent){
            vSendSfMode();
            _bStartComponent=FALSE;
        }
    }
}


tVoid dabdrv_tsu::vForceDisbaleServiceLinking(){
	ETG_TRACE_USR1(("  dabdrv_tsu::vForceDisbaleServiceLinking"));
	bForceDisableMtcSetMode=TRUE;
	dabdrv_mecaIf::instance()->vSendMecaCommand(trMeca_CMtcSetMode());
}

tVoid dabdrv_tsu::vRestoreMtcServiceLinking(){
	ETG_TRACE_USR1(("  dabdrv_tsu::vRestoreMtcServiceLinking"));
	vSendSfMode();
}

tVoid dabdrv_tsu::vProcess(DAB::trMsgDrvCmdMtcConfig* poMtcConfig) {
    (tVoid)poMtcConfig;
    _bTsuDisabled=(_rMtcSetMode.enTsuMode == DAB_enMtcMode_Off) ? TRUE:FALSE;

    ETG_TRACE_USR1(("  dabdrv_tsu::vProcess(trMsgDrvCmdMtcConfig) bTsuOn=%d",
                        _bTsuDisabled));


    //check the config for DAB to FM SF, and based on this update TsuMode of MtcSetMode

    vSendSfMode();

}

tVoid dabdrv_tsu::vProcess(DAB::trMeca_RMtcSetMode* poRSetMode) {
    (tVoid)poRSetMode;


    if(bForceDisableMtcSetMode){
    	bForceDisableMtcSetMode=FALSE;
    	return;
    }

     ETG_TRACE_USR4(( "\n"
                      " ****************************************************************************************\n"
                      " * M T C    trMeca_RMtcSetMode (%d)  \n"
                      " ****************************************************************************************",
                    poRSetMode->enTsuMode));
	DAB_tenServiceLinkingMode e8ServLinkingMode = dabdrv_main::instance()->enGetServiceLinkingMode();
	 ETG_TRACE_USR4(("dabdrv_tsu::vProcess(trMeca_RMtcSetMode):e8 (%d) ",
                        e8ServLinkingMode));


    DAB_trSetupStatusProperty oSetupStatus = dabdrv_properties::instance()->oSetupStatusProperty.oGet();
	

	if((poRSetMode->enTsuMode == DAB_enMtcMode_DAB_FM_On)||
		(poRSetMode->enTsuMode ==DAB_enMtcMode_BOTH_On)){
    	 oSetupStatus.e8ServiceLinkingMode = (e8ServLinkingMode == DAB_enServiceLinkingMode_DAB_FM || e8ServLinkingMode == DAB_enServiceLinkingMode_DAB)?
    	        											DAB_enServiceLinkingMode_DAB_FM:(e8ServLinkingMode == DAB_enServiceLinkingMode_OFF)? DAB_enServiceLinkingMode_OFF:DAB_enServiceLinkingMode_FM;
    }
  	else if(poRSetMode->enTsuMode == DAB_enMtcMode_Off){
    	oSetupStatus.e8ServiceLinkingMode = ((e8ServLinkingMode == DAB_enServiceLinkingMode_DAB_FM) ||
    										(e8ServLinkingMode == DAB_enServiceLinkingMode_DAB))?
    											DAB_enServiceLinkingMode_DAB:DAB_enServiceLinkingMode_OFF;
	
								
    }
	else if(poRSetMode->enTsuMode == DAB_enMtcMode_FM_DAB_On){
		oSetupStatus.e8ServiceLinkingMode = (e8ServLinkingMode == DAB_enServiceLinkingMode_OFF)?
    											DAB_enServiceLinkingMode_OFF:DAB_enServiceLinkingMode_DAB;
	}
if(!dabdrv_testmode::instance()->bIsTestmodeActive()){
//#ifndef DABTUNER_UTEST
#ifndef DABTUNER_UTEST
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
	dp_tclDABTunerDPServiceLinkingMode oServiceLinking;
#else
	dp_tclDABTunerUsrDPServiceLinkingMode oServiceLinking;
#endif
	tU32 status = oServiceLinking.s32SetData(oSetupStatus.e8ServiceLinkingMode);
	ETG_TRACE_USR1(("dabdrv_tsu::trMeca_RMtcSetMode : dp Set status %d linking mode %d", status,oSetupStatus.e8ServiceLinkingMode));

#endif

}

    //dabdrv_main::instance()->enSetServiceLinkingMode(oSetupStatus.e8ServiceLinkingMode);
	//fc_dabtuner_config *poConfig=fc_dabtuner_config::instance();
 //   if (OSAL_NULL ==poConfig) {
	//	ETG_TRACE_FATAL(("dabdrv_main::vProcess(trMsgSrvCmdSetup) config not available !!!"));
	//	return;
	//}
	//poConfig->vSetSfDabFmEnable(DAB_bDoSrvLinkingFm(oSetupStatus.e8ServiceLinkingMode));
	
    dabdrv_properties::instance()->oSetupStatusProperty.vSet(oSetupStatus);
	DAB_vCallMsg(oSetupStatus); // Sending forced update
    //vUpdateConfig(poRSetMode->enTsuMode);

	DAB_trMTCSetModeProperty rProperty= dabdrv_properties::instance()->oMTCSetModeProperty.oGet();
	rProperty.enMtcMode = poRSetMode->enTsuMode;

	dabdrv_properties::instance()->oMTCSetModeProperty.vSet(rProperty);

	//During DAB-FM linking if we disable the option unavailable status is not getting updated.
	dabdrv_mecaIf::instance()->vSendMecaCommandCtor(trMeca_CRdmGetRdmInfo());
}

//Sets the oMTCSwitchStatusProperty property and sends message to all the subscribers. 
//tVoid dabdrv_tsu::vProcess(DAB::trMeca_RMtcRequestSwitch* poRRequestSwitch) 
//{
//	ETG_TRACE_USR4(( "\n"
//                      " ****************************************************************************************\n"
//                      " * M T C    trMeca_RMtcRequestSwitch (%d)  \n"
//                      " ****************************************************************************************",
//                    poRRequestSwitch->enSwitchMode));
//
//	DAB_trMTCSwitchStatusProperty rProperty= dabdrv_properties::instance()->oMTCSwitchStatusProperty.oGet();
//	rProperty.enMtcRequestSwitch = (DAB_tenMtcRequestSwitch)poRRequestSwitch->enSwitchMode;
//	dabdrv_properties::instance()->oMTCSwitchStatusProperty.vSet(rProperty);
//}

//Sets the oMTCAnnouncementProperty property and sends message to all the subscribers. 
//tVoid dabdrv_tsu::vProcess(DAB::trMeca_RMtcAnnouncementState* poRRequestSwitch) 
//{
//	ETG_TRACE_USR4(( "\n"
//                      " ****************************************************************************************\n"
//                      " * M T C    trMeca_RMtcAnnouncementState (%d)  \n"
//                      " ****************************************************************************************",
//                    poRRequestSwitch->enAnno_State));
//
//	DAB_trMTCAnnouncementProperty rProperty= dabdrv_properties::instance()->oMTCAnnouncementProperty.oGet();
//	rProperty.enMtcActivityState = (DAB_tenMtcActivityState)poRRequestSwitch->enAnno_State;
//	dabdrv_properties::instance()->oMTCAnnouncementProperty.vSet(rProperty);
//}

//Sets the oMTCSurveillanceMonitorProperty property and sends message to all the subscribers. 
tVoid dabdrv_tsu::vProcess(DAB::trMeca_RMtcSurveillanceMonitor* poRSurveillanceMonitor) 
{
	ETG_TRACE_USR4(( "\n"
                      " ****************************************************************************************\n"
                      " * M T C    trMeca_RMtcSurveillanceMonitor   \n"
                      " ****************************************************************************************"));
	ETG_TRACE_USR4(("  DAB_trMTCSurveillanceMonitorProperty: e8MtcMtcStationType =%d "
			"  e8MtcStationFreq=%d  e8MtcStationId=%d  e8MtcEnsID=%d"
            "  e8MtcTPState=%d  sMtcStationNameFM=%s ",
             ETG_CENUM(DAB_tenMtcStationType, poRSurveillanceMonitor->enMtcStationType), poRSurveillanceMonitor->u32MtcStationFreq,
			 poRSurveillanceMonitor->u32MtcStationId, poRSurveillanceMonitor->u32MtcEnsID, 
			 ETG_CENUM(DAB_tenMtcTPState, poRSurveillanceMonitor->enMtcTPState), poRSurveillanceMonitor->u8MtcStationNameFM));
	ETG_TRACE_USR4(("sStationNameDAB=%s", poRSurveillanceMonitor->u8StationNameDAB));

	DAB_trMTCSurveillanceMonitorProperty rProperty= dabdrv_properties::instance()->oMTCSurveillanceMonitorProperty.oGet();

	rProperty.enMtcStationType = (DAB_tenMtcStationType)poRSurveillanceMonitor->enMtcStationType;
	rProperty.u32MtcStationFreq = poRSurveillanceMonitor->u32MtcStationFreq;
	rProperty.u32MtcStationId = poRSurveillanceMonitor->u32MtcStationId;
	rProperty.u32MtcEnsID = poRSurveillanceMonitor->u32MtcEnsID;
	rProperty.enMtcTPState = (DAB_tenMtcTPState)poRSurveillanceMonitor->enMtcTPState;

	for(tU8 i=0; i<8; i++)
		rProperty.sMtcStationNameFM[i] = poRSurveillanceMonitor->u8MtcStationNameFM[i];

	for(tU8 j=0; j<16; j++)
		rProperty.sStationNameDAB[j] = poRSurveillanceMonitor->u8StationNameDAB[j];


	dabdrv_properties::instance()->oMTCSurveillanceMonitorProperty.vSet(rProperty);
}

tVoid dabdrv_tsu::vProcess(DAB::trMeca_RFMSurveillanceInfos* poRFMSurveillanceInfos)
{
    ETG_TRACE_USR4(( "\n"
                      " ****************************************************************************************\n"
                      " * M T C    trMeca_RFMSurveillanceInfos   \n"
                      " ****************************************************************************************"));
    ETG_TRACE_USR4(("  enMtcAudibleModulation =%d u32MtcFreq=%d  u16MtcPI=%d " ,
                       ETG_CENUM(tenMeca_MtcTuner, poRFMSurveillanceInfos->enMtcAudibleModulation), poRFMSurveillanceInfos->u32MtcFreq,
                       poRFMSurveillanceInfos->u16MtcPI));

    trMeca_RMtcTunerStatus mtcTunerStatus;
    mtcTunerStatus.enMtcTuner = poRFMSurveillanceInfos->enMtcAudibleModulation;
    vProcess(&mtcTunerStatus );

    DAB_trMTCSurveillanceMonitorProperty rProperty= dabdrv_properties::instance()->oMTCSurveillanceMonitorProperty.oGet();
    tU8 u8AudibleModulation = poRFMSurveillanceInfos->enMtcAudibleModulation;
    rProperty.enMtcStationType = static_cast<DAB_tenMtcStationType>(u8AudibleModulation);
    tU8 u8DabSrc = enMeca_MtcTuner_MAIN_DAB_TUNER;
    if (rProperty.enMtcStationType != static_cast<DAB_tenMtcStationType>(u8DabSrc))
    {
        rProperty.u32MtcStationFreq = poRFMSurveillanceInfos->u32MtcFreq;
        rProperty.u32MtcStationId = poRFMSurveillanceInfos->u16MtcPI;
    }
    else
    {
        rProperty.u32MtcStationFreq = 0;
        rProperty.u32MtcStationId = 0;
    }

    dabdrv_properties::instance()->oMTCSurveillanceMonitorProperty.vSet(rProperty);
}
tVoid dabdrv_tsu::vProcess(DAB::trMeca_RMtcSetConfig* poRSetConfig) {
    (tVoid)poRSetConfig;
     ETG_TRACE_USR4(( "\n"
                      " ****************************************************************************************\n"
                      " * M T C    trMeca_RMtcSetConfig  \n"
                      " ****************************************************************************************"
                      ));

    ETG_TRACE_USR1(("  dabdrv_tsu::vProcess(DAB::trMeca_RMtcSetConfig) bConfigOk=%d ",
                    poRSetConfig->bConfigOk));

    
    ETG_TRACE_USR4(( "\n"
                     " ****************************************************************************************\n"
                     " * M T C    trMeca_CMtcSetMode \n"
                     " ****************************************************************************************"
                     ));




    ETG_TRACE_USR4(( "\n"
                     " ****************************************************************************************\n"
                     " * M T C    trMeca_CMtcNotification \n"
                     " ****************************************************************************************"
                     ));

    trMeca_CMtcNotification rMtcNotification;
    rMtcNotification.enMtcNotifyCtrl = /*enMeca_MtcNotify_SET_FUNCTION*/enMeca_MtcNotify_SET_ALL;
    rMtcNotification.u16MtcClientId = DAB_CLIENT_ID;
    dabdrv_mecaIf::instance()->vSendMecaCommand(rMtcNotification);

	if(_bStartComponent){
		vSendSfMode();
		_bStartComponent=FALSE;
	}

    ETG_TRACE_USR4((  " * M T C    trMeca_CMtcSfRestart"));
    trMeca_CMtcSfRestart rSrvCmdMtcSfRestart;
    dabdrv_mecaIf::instance()->vSendMecaCommand(rSrvCmdMtcSfRestart);
}

//As the we are not relieing ADR mtc tuner status resetting the value when DAB is in foreground.
tVoid dabdrv_tsu::vProcess(trMsgSrvCmdMtcTunerstatus* poTunerStaus) {

    //Invalidate the mtc survillance if Mtctunerstatus is called explicitly.
    fc_dabtuner_config *poConfig=fc_dabtuner_config::instance();
    if (poConfig != nullptr)
    {
        if(!poConfig->bIsSBRVariant())
        {
            DAB_trMTCSurveillanceMonitorProperty rProperty= dabdrv_properties::instance()->oMTCSurveillanceMonitorProperty.oGet();
            rProperty.u32MtcStationId=0;
            dabdrv_properties::instance()->oMTCSurveillanceMonitorProperty.vSet(rProperty);

            trMeca_RMtcTunerStatus mtcTunerStatus;
            mtcTunerStatus.enMtcTuner = poTunerStaus->enTunerStatus;
            vProcess(&mtcTunerStatus );
        }
        else
        {
            trMeca_RFMSurveillanceInfos mtcFMSurvInf;
            mtcFMSurvInf.enMtcAudibleModulation = poTunerStaus->enTunerStatus;
            vProcess(&mtcFMSurvInf);
        }
    }
}

tBool dabdrv_tsu::isDABFMLinkingActive(DAB::trMeca_RMtcTunerStatus* poRTunerStatus){

	DAB_trMTCSurveillanceMonitorProperty rProperty= dabdrv_properties::instance()->oMTCSurveillanceMonitorProperty.oGet();
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
	return (rProperty.enMtcStationType == DAB_enMtcStationType_FM && rProperty.u32MtcStationId !=0
			&& poRTunerStatus->enMtcTuner == enMeca_MtcTuner_MAIN_FM_TUNER);
#else
	return (poRTunerStatus->enMtcTuner == enMeca_MtcTuner_MAIN_FM_TUNER);
#endif
}

tBool dabdrv_tsu::isFMDABLinkingActive(DAB::trMeca_RMtcTunerStatus* poRTunerStatus){

	DAB_trMTCSurveillanceMonitorProperty rProperty= dabdrv_properties::instance()->oMTCSurveillanceMonitorProperty.oGet();
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
	return (rProperty.enMtcStationType == DAB_enMtcStationType_DAB && rProperty.u32MtcStationId !=0
			&& poRTunerStatus->enMtcTuner == enMeca_MtcTuner_MAIN_DAB_TUNER);
#else
	return (poRTunerStatus->enMtcTuner == enMeca_MtcTuner_MAIN_DAB_TUNER);
#endif
}

tVoid dabdrv_tsu::vProcess(DAB::trMeca_RMtcTunerStatus* poRTunerStatus) {
    (tVoid)poRTunerStatus;

    ETG_TRACE_USR4(( "\n"
                     " ****************************************************************************************\n"
                     " * M T C    trMeca_RMtcTunerStatus (%d) \n"
                     " ****************************************************************************************",

                     ETG_CENUM(tenMeca_MtcTuner, poRTunerStatus->enMtcTuner)));




	//if(dabdrv_main::instance()->enGetSourceState() == DAB_enSourceState_FG)
	{
		//tBool bStatus = (enMeca_MtcTuner_MAIN_FM_TUNER==poRTunerStatus->enMtcTuner) ? TRUE:FALSE;
		tBool bStatus = dabdrv_main::instance()->enGetSourceState() == DAB_enSourceState_FG ?
								isDABFMLinkingActive(poRTunerStatus) : !(isFMDABLinkingActive(poRTunerStatus));
		/*avoid multiple rel upreg of tune rp[roperty G_radiotext due to continuous tuner status as unknown*/
			if(bSrvFollowActive != bStatus)
		{

			//PSARCC21-3068 when selected preset is not available and the same is available in FM
			//Then DAB-FM linking happens but audio is muted due delayed response from stationPlay.
			dabdrv_chnSelect::instance()->vCheckForMute(bStatus && (dabdrv_main::instance()->enGetSourceState() == DAB_enSourceState_FG));

			bSrvFollowActive = bStatus;
			/*PSARCCB-4375 Radiotext to be cleared here due to sync issues in chn info prop updates*/
			trMsgDrvFmServiceFollow rFmServiceFollow(bSrvFollowActive);
			DAB_vCallMsg(rFmServiceFollow);
		}
	}

    DAB_trMtcServiceFollowingProperty rProperty= dabdrv_properties::instance()->oMtcServiceFollowingProperty.oGet();
    rProperty.enMtcTuner = poRTunerStatus->enMtcTuner;
    dabdrv_properties::instance()->oMtcServiceFollowingProperty.vSet(rProperty);
    vUpdateTunerStatus(poRTunerStatus->enMtcTuner);
	DAB_trMTCTunerStatusProperty rstatusProperty= dabdrv_properties::instance()->oMTCTunerStatusProperty.oGet();
	rstatusProperty.e8MtcTunerSwitchStatus = (DAB_tenMtcTunerSwitchStatus)poRTunerStatus->enMtcTuner;
	dabdrv_properties::instance()->oMTCTunerStatusProperty.vSet(rstatusProperty);

}

tVoid dabdrv_tsu::vProcess(trMsgSrvCmdMtcMode* poMtcMode) {
    fc_dabtuner_config *poConfig=fc_dabtuner_config::instance();
	 ETG_TRACE_USR4(("dabdrv_tsu::vProcess(trMsgSrvCmdMtcMode* poMtcMode):DAB->FM (%d) FM->DAB %d  ReqMode %d ",
                        poConfig->bGetSfDabFmEnable(),
						poConfig->bGetSfFmDabEnable(),
						poMtcMode->enMtcMode));   

	 tU16 u16MtcMode = poMtcMode->enMtcMode;
	 vValidateFMDABLinking(u16MtcMode);
	 _rMtcSetMode.enTsuMode = (DAB_tenMtcMode)u16MtcMode;


#ifndef DABTUNER_UTEST
	dp_tclDABTunerDPMTCMode dpMTC_mode;
	tU32 status_mtcmode = dpMTC_mode.s32SetData(_rMtcSetMode.enTsuMode);
	ETG_TRACE_USR1(("dabdrv_tsu::vProcess : status_mtcmode = %d enTsuMode %d",status_mtcmode, _rMtcSetMode.enTsuMode));
#endif
        vSendSfMode();
   
    }

tVoid dabdrv_tsu::vValidateFMDABLinking(tU16 &value){

	if (value < 3){
		return;
	}

	fc_dabtuner_config *poConfig=fc_dabtuner_config::instance();
	tBool bitValue = poConfig->bGetSfFmDabEnable();
	DAB_SET_BIT_U16(bitValue,value,(tU16)1);
}

tVoid dabdrv_tsu::vProcess(trMeca_RMtcSfRestart* /*poMtcSfRestart*/) {
    ETG_TRACE_USR4(( "\n"
                     " ****************************************************************************************\n"
                     " * M T C    trMeca_RMtcSfRestart \n"
                     " ****************************************************************************************" ));
    }
tVoid dabdrv_tsu::vProcess(trMsgSrvCmdCriticalVoltage* poCriticalVoltage) {
    ETG_TRACE_USR1(("dabdrv_tsu:poCriticalVoltage: bIsCritical=%d",
                    poCriticalVoltage->bIsCritical));
    if (poCriticalVoltage->bIsCritical) {
    } else {
        vSendSfMode();
    }
    }
tVoid dabdrv_tsu::vSendSfMode() {

	//bForceDisableMtcSetMode - when TA is putthrough don't allow to set mtc setmode.
    if (dabdrv_main::instance()->bIsAdrUp() && !bForceDisableMtcSetMode) {
        ETG_TRACE_USR4(( "\n"
                         " ****************************************************************************************\n"
                         " * M T C    trMeca_CMtcSetMode (%d) \n"
                         " ****************************************************************************************",
                         _rMtcSetMode.enTsuMode));
        dabdrv_mecaIf::instance()->vSendMecaCommand(_rMtcSetMode);
    }
}

//Send message to ADR for the service to happen.
//tVoid dabdrv_tsu::vProcess(trMsgSrvCmdMtcRequestSwitch* poMtcRequestSwitch) {
//    ETG_TRACE_USR1(("dabdrv_tsu:trMsgSrvCmdMtcRequestSwitch: enMtcRequestSwitch=%d",
//                    poMtcRequestSwitch->enMtcRequestSwitch));
//
//	trMeca_CMtcRequestSwitch rMtcRequestSwitch;
//	rMtcRequestSwitch.enSwitchMode = (DAB_tenMtcRequestSwitch)poMtcRequestSwitch->enMtcRequestSwitch;
//	dabdrv_mecaIf::instance()->vSendMecaCommand(rMtcRequestSwitch);
//
//}


//Send message to ADR with service switching mode.
//tVoid dabdrv_tsu::vProcess(trMsgSrvCmdMtcTuner_ActivityState* poMtcActivity_State) {
//    ETG_TRACE_USR1(("dabdrv_tsu:trMsgSrvCmdMtcTuner_ActivityState: poMtcActivity_State=%d",
//                    poMtcActivity_State->enMtcActivityState));
//
//	trMeca_CMtcAnnouncementState rMtcAnnouncementState;
//	rMtcAnnouncementState.enAnno_State = (DAB_tenMtcActivityState)poMtcActivity_State->enMtcActivityState;
//	dabdrv_mecaIf::instance()->vSendMecaCommand(rMtcAnnouncementState);
//
//}

//To Improve the Maintainability of the code
tVoid dabdrv_tsu::vUpdateTunerStatus(tenMeca_MtcTuner enMtcTuner)
{
	DAB_tenSourceState enState = dabdrv_main::instance()->enGetSourceState();
	/*dont update tuner, availability status when DAB is in BG*/
	if(enState != DAB_enSourceState_FG){
	   return;
	   }
	DAB_trTunerStatusProperty oTunerStatus = dabdrv_properties::instance()->oTunerStatusProperty.oGet();
	DAB_trAvailabilityProperty oAvailabilityStatus = dabdrv_properties::instance()->oAvailabilityProperty.oGet();
	if((oTunerStatus.enTunerActivityType != DAB_enTunerActivityType_SEEK)&&
		(oTunerStatus.enTunerActivityType != DAB_enTunerActivityType_SCAN)&&
		(oTunerStatus.enTunerActivityType != DAB_enTunerActivityType_SERVICESEEK)&&
		(oTunerStatus.enTunerActivityType != DAB_enTunerActivityType_LEARN)){
		//Change the status only if service follow is active.
	if(enMtcTuner==enMeca_MtcTuner_MAIN_FM_TUNER && bSrvFollowActive){
		oTunerStatus.enTunerActivityType = DAB_enTunerActivityType_SERVICEFOLLOWING;
		oAvailabilityStatus.enSourceState = DAB_enSourceState_SrvFollow;
	}
	else if(enMtcTuner==enMeca_MtcTuner_MAIN_DAB_TUNER){
				oTunerStatus.enTunerActivityType = DAB_enTunerActivityType_NORMAL;
		oAvailabilityStatus.enSourceState = DAB_enSourceState_FG;
    }
    dabdrv_properties::instance()->oAvailabilityProperty.vSet(oAvailabilityStatus);
			dabdrv_properties::instance()->oTunerStatusProperty.vSet(oTunerStatus);
	}
}
