/************************************************************************
 * FILE:         dabdrv_tpeg.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of dabdrv_tpeg
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      	| Author                       | Modification
				  
				
 *************************************************************************/

#ifndef DABDRV_TPEG_HPP
#define DABDRV_TPEG_HPP

#include "fc_dabtuner_util.h"
#include "dabdrv_main.hpp"
#include "dabmeca_db.hpp"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_DRV_TPEG 
#include "trcGenProj/Header/dabdrv_tpeg.hpp.trc.h"
#endif

namespace DAB {

    struct dabdrv_msgTpegMsgUpdate;
    struct dabdrv_msgTpegUriActivatedTimer;
    struct dabdrv_msgTpegSupervisionTimer;

    class dabdrv_filereader
    {
    public:
        dabdrv_filereader();
        std::vector<DAB_trTpegDataListElement> oLoadFile(std::string sFileLocation);

    private:
        tU32 u32Position;
        
        tU32  u32GetFileSize(OSAL_tIODescriptor oInputFile);
        tString vReadFileIntoBuffer(tU32 lSize, OSAL_tIODescriptor oInputFile);
        std::vector<DAB_trTpegDataListElement> vProcessFile(OSAL_tIODescriptor oInputFile);

        DAB_trTpegDataListElement oGetTpegFrameFromBuffer(tString cBuffer);
        OSAL_tIODescriptor oOpenFileLocation(std::string sPatternType, std::string sLanguage);
    };


    class dabdrv_tpeg:
        public DAB_Singleton <dabdrv_tpeg>,
        public DAB_MessageHandlerCommon<dabdrv_tpeg>
    {
        friend class DAB_Singleton<dabdrv_tpeg>;

    public:
        DAB_TRACE_INFO_IMPL(FC_DABTUNER_TR_DRV_TPEG);
        virtual char const *pcGetName() const {return "dabdrv_tpeg";};
        virtual tVoid vTraceState() const;

        virtual tVoid vInit();
        virtual tVoid vDeInit();

        tVoid vSetTpegActivity(tBool bTpegActive );
        tVoid vUpdateTpegReceiveTime();
        tBool bCompareTpegReceivedUriList(vector<string> &vcTpegUriList);
        tBool bIsSelectStateActivated();

        virtual tVoid vProcess(trMsgDrvStartComponent *poStartComponent);
        virtual tVoid vProcess(trMsgDrvStopComponent *poStopComponent);

        virtual tVoid vProcess(dabdrv_msgTpegMsgUpdate *poTpegMsgUpdate);
        virtual tVoid vProcess(dabdrv_msgTpegUriActivatedTimer *poTimeOutMsg);
        virtual tVoid vProcess(dabdrv_msgTpegSupervisionTimer *poTimeOutMsg);

        virtual tVoid vProcess(trMsgSrvCmdSelectTpegUri* poSelectTpegUri);
        virtual tVoid vProcess(trMsgSrvCmdGetTpegUriList* poGetTpegUriList);
        virtual tVoid vProcess(trMeca_RDbQuery* poQuery);
        virtual tVoid vProcess(trMeca_RDdmSelectUri* poDdmSelectUri);
        virtual tVoid vProcess(trMeca_RDdmDataChannel* poDdmDatachannel);
        virtual tVoid vProcess(trMsgDrvSetTpegMode* poMsgDrvSetTpegMode);
        virtual tVoid vProcess(trMsgDrvLoadTpegSimFile* poMsgDrvLoadTpegSimFile);

        DAB_tclTimer _oTpegMsgUpdateTmr;
        DAB_tclTimer _oTpegUriActivatedTimer;
        DAB_tclTimer _oTpegSupervisionTimer;

        dabdrv_tpeg();   

        tBool _bTpegActive;
        DAB_trTpegDataListProperty oTpegDataList;

        // for simulation
        dabdrv_filereader ofilereader;
        std::vector<DAB_trTpegDataListElement> m_oTpegDataList;
        std::vector<DAB_trTpegUriListElement> m_oTpegUriList;
        tBool bUseSimulationData;
        tBool bSendTpegData;
        tBool _bTpegDataReceived;
        std::string _sSelectUri;

    };
} //namespace DAB 

#endif
