/************************************************************************
 * FILE:           dabdrv_tmcParse.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of dabdrv_tmcParse
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      	| Author                       | Modification
				  
				
 *************************************************************************/
 
 
#include "dabdrv_tmcParse.hpp"
#include "dabdrv_main.hpp"



#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_DRV_TMC 
#include "trcGenProj/Header/dabdrv_tmcParse.cpp.trc.h"
#endif


namespace DAB{

    struct trMsgTmcStatusTimeOut:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL
            virtual tVoid vTrace() const {
                ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                    "trMsgTmcStatusTimeOut"));
        };
    };
}

using namespace DAB;

dabdrv_tmcParse::dabdrv_tmcParse() {

    _bTmcActive = FALSE;
}

tVoid dabdrv_tmcParse::vInit() {
    ETG_TRACE_USR1(("dabdrv_tmcParse::vInit"));
}

tVoid dabdrv_tmcParse::vDeInit() {
    ETG_TRACE_USR1(("dabdrv_tmcParse::vDeInit"));

    std::vector < trTmcDataElement * >::iterator it ;
    tU32 u32Size = (tU32)(oTMCList.size());  

    if ( u32Size > 0 ) {
		/**Vnd4kor : To solve complier warning*/
        for ( tU32 u32Count = 0; u32Count < u32Size; u32Size--) {
            it = oTMCList.begin();
            
            if(*it != NULL) {
                OSAL_DELETE (*it);   
                oTMCList.erase( it );
            }
        }
        oTMCList.clear();
    }

    vector<DAB_trTmcRdbId*>::iterator iter;
    u32Size = (tU32)(_vecRdbIdWishList.size());  

    if ( u32Size > 0 ) {
		/**Vnd4kor: To solve compiler warning*/
        for ( tU32 u32Count = 0; u32Count < u32Size; u32Size--) {
            iter = _vecRdbIdWishList.begin();
            
            if(*iter != NULL) {
                OSAL_DELETE (*iter);   
                _vecRdbIdWishList.erase( iter );
            }
        }
        _vecRdbIdWishList.clear();
    }
}

tVoid dabdrv_tmcParse::vTraceState() const {

}

tVoid dabdrv_tmcParse::vSetTmcActivity(tBool bTmcActive ) {
    _bTmcActive = bTmcActive;
}

tVoid dabdrv_tmcParse::vHandle3aGroup(vector<trTmcDataElement*>::const_iterator it, tU8 const *pTmcData) const
{
    ETG_TRACE_USR4(("dabdrv_tmcParse::vHandle3aGroup"));

    if ((!( (*it)->_u8Valid & TMC_C_U8_VALID_SID ))||   
        (!( (*it)->_u8Valid & TMC_C_U8_VALID_LTN ))) {

        tU16 u16Variant = DABDRV_GET_U16(&pTmcData[1]);

        if( u16Variant & TMC_C_U16_MASK_VARIANT_SID ) {
            u16Variant = (tU16)(u16Variant << 2);
            u16Variant = (tU16)(u16Variant >> 6);
            // save SID
            (*it)->_u8Sid = (tU8)u16Variant;
            // set SID as valid
            (*it)->_u8Valid |= TMC_C_U8_VALID_SID;
            (*it)->_u16Aid = DABDRV_GET_U16(&pTmcData[3]);
            (*it)->_u8Valid |= TMC_C_U8_VALID_AID;
            
            ETG_TRACE_USR4(("dabdrv_tmcParse::vHandle3aGroup _u8Sid=%x _u16Aid=%x", (*it)->_u8Sid,(*it)->_u16Aid));

        }
        else {
            u16Variant = (tU16)(u16Variant << 2);
            u16Variant = (tU16)(u16Variant >> 6);
            // save LTN
            (*it)->_u8Ltn = (tU8)u16Variant;
            // set LTN as valid
            (*it)->_u8Valid |= TMC_C_U8_VALID_LTN;
            ETG_TRACE_USR4(("dabdrv_tmcParse::vHandle3aGroup _u8Ltn=%x", (*it)->_u8Ltn));
        }
    }
}



tBool dabdrv_tmcParse::bParseTmcMsg(tU8 u8TmcGroup, tU8* pTmc, tU32 u32Psid, tU16 u16Scidi, tS16 s16Ecc, DAB_trTmcDataListElement *_rTmcData)
{
    tBool bRetVal = FALSE;
    ETG_TRACE_USR4(("dabdrv_tmcParse::vParseTmcMsg oTMCList.size=%d", (tU16)(oTMCList.size())));

    if ( _bTmcActive != TRUE )
        return bRetVal;

    /*
      -for tmc-read tmc-data should only be stored for the channel requested by tuner-master.
       here only parsing should be done. storage of information in tmc-read
      - for tmc-learn the parsed information should be returned


    */
    // get RDBID for match of (SCIDI & ECC & SID)
    if (u8TmcGroup == (tU8)enMeca_DdmResponse_TMC_GROUP_3A)
    {
        // parse 3A
        dabdrv_tmcParse::instance()->vParse3aMsg( pTmc, u32Psid, u16Scidi, s16Ecc);

    }
    else
    {
        // parse 8A
        bRetVal = bCheckTmcScidiSidEcc( u32Psid, u16Scidi, s16Ecc, _rTmcData);
        if (bRetVal == TRUE)
            bRetVal = bParseTmcMsg(_rTmcData, pTmc);
    }

    return bRetVal;

}

tVoid dabdrv_tmcParse::vParse3aMsg(tU8* pTmc, tU32 u32Psid, tU16 u16Scidi, tS16 s16Ecc)
{
    tBool bElementFound = FALSE;
    ETG_TRACE_USR4(("dabdrv_tmcParse::vParse3aMsg oTMCList.size=%d", (tU16)(oTMCList.size())));

    /*
      -for tmc-read tmc-data should only be stored for the channel requested by tuner-master.
       here only parsing should be done. storage of information in tmc-read
      - for tmc-learn the parsed information should be returned
    */

    if (oTMCList.size() == 0)
    {
        //lint --e{429} "Custodial pointer 'poTmcDataElement' (line ...) has not been freed or returned"
        trTmcDataElement* poTmcDataElement = OSAL_NEW trTmcDataElement;  // will be freed in vDeInit()
        if (poTmcDataElement != NULL)
        {
            poTmcDataElement->_u16Scidi = u16Scidi;
            poTmcDataElement->_u32Psid = u32Psid;
            oTMCList.push_back(poTmcDataElement);

            // recursion, cause same handling like above
            vParse3aMsg(pTmc, u32Psid, u16Scidi, s16Ecc);
        }
    }

    std::vector<trTmcDataElement*>::iterator it;
    for( it = oTMCList.begin() ; it < oTMCList.end() ; it ++ ) 
    {
        if( ( (*it)->_u32Psid == u32Psid) && ( (*it)->_u16Scidi == u16Scidi) )// check PSID and SCIDI
        {
            bElementFound = TRUE;
            if (s16Ecc != -1) {
                (*it)->_u16Ecc = (tU16)s16Ecc;
                (*it)->_u8Valid |= TMC_C_U8_VALID_ECC;
            }
            vHandle3aGroup(it, pTmc);
        }
    }

    if (bElementFound == FALSE) 
    {
        //lint --e{429} "Custodial pointer 'poTmcDataElement' (line ...) has not been freed or returned"
        trTmcDataElement* poTmcDataElement = OSAL_NEW trTmcDataElement; // will be freed in vDeInit()
        if (OSAL_NULL != poTmcDataElement)
        {
            poTmcDataElement->_u16Scidi = u16Scidi;
            poTmcDataElement->_u32Psid = u32Psid;
            oTMCList.push_back(poTmcDataElement);

            // recursion, cause same handling like above
            vParse3aMsg(pTmc, u32Psid, u16Scidi, s16Ecc);
        }
    }

}

//todo: first step only one SCIDI with one SID is implemented 
// -> has to be adapted, when we get the data from ADR3 
tVoid dabdrv_tmcParse::vAddRdbid2Wishlist(DAB_trTmcRdbId const *poTmcRdbid)
{
    //lint --e{429} "Custodial pointer 'poTmcRdbIdElem' (line ...) has not been freed or returned"
    DAB_trTmcRdbId* poTmcRdbIdElem = OSAL_NEW DAB_trTmcRdbId;       // will be freed in vDeInit()

    if (poTmcRdbIdElem == NULL)
        return;

    poTmcRdbIdElem->u8Cc       = poTmcRdbid->u8Cc;
    poTmcRdbIdElem->u8Ltn      = poTmcRdbid->u8Ltn;
    poTmcRdbIdElem->u8Sid      = poTmcRdbid->u8Sid;
    poTmcRdbIdElem->u16Bsa     = poTmcRdbid->u16Bsa;
    poTmcRdbIdElem->bEncrypted = poTmcRdbid->bEncrypted;
    _vecRdbIdWishList.push_back(poTmcRdbIdElem);
}

tVoid dabdrv_tmcParse::vCleanRdbidWishlist()
{
    _vecRdbIdWishList.clear();
}

tBool dabdrv_tmcParse::bCheckTmcScidiSidEcc(tU32 u32Psid, tU16 u16Scidi, tS16 s16Ecc, DAB_trTmcDataListElement *_rTmcData)
{
    tBool bRetVal = FALSE;

    std::vector<trTmcDataElement*>::iterator it;

    for( it = oTMCList.begin() ; it < oTMCList.end() ; it ++ ) 
    {
        if( ( (*it)->_u32Psid == u32Psid) && ( (*it)->_u16Scidi == u16Scidi) )// check PSID and SCIDI
        {
            bRetVal = TRUE;
            _rTmcData->s16Ecc = s16Ecc;
            _rTmcData->RdbId.u8Cc = (tU8)s16Ecc;
            _rTmcData->RdbId.u8Ltn = (*it)->_u8Ltn;
            _rTmcData->RdbId.u8Sid = (*it)->_u8Sid;
            _rTmcData->u16Aid =    (*it)->_u16Aid;
            _rTmcData->u16ProgramId = (tU16)u32Psid;
        }
    }
    return bRetVal;
}


tBool dabdrv_tmcParse::bParseTmcMsg(DAB_trTmcDataListElement *_rTmcData, tU8 const *pTmc) const
{
    tBool bRetVal = FALSE;

    for (tU8 i= 0; i<5; i++)
        _rTmcData->au8TmcData[i] = pTmc[i];

    ETG_TRACE_USR4(("dabdrv_tmcParse::vParseTmcMsg  RDBID=0x00%02x%02x%02x Tmc-Data:=%*p", 
                                        _rTmcData->RdbId.u8Cc,
                                        _rTmcData->RdbId.u8Ltn, 
                                        _rTmcData->RdbId.u8Sid,
                                        ETG_LIST_LEN(5),ETG_LIST_PTR_T8(_rTmcData->au8TmcData)));
    return bRetVal;
}
