/************************************************************************
 * FILE:           dabdrv_testOperation.hpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of dabdrv_testOperation
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      	| Author                       | Modification
				  
				
 *************************************************************************/

#ifndef DABDRV_TEST_OPERATION_HPP
#define DABDRV_TEST_OPERATION_HPP

#include "fc_dabtuner_util.h"
//#include "dabdrv_types.hpp"
#include "dabdrv_main.hpp"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_DRV_MAIN 
#include "trcGenProj/Header/dabdrv_testOperation.hpp.trc.h"
#endif

namespace DAB {
    struct trMsgSrvCmdTestOperation;
    struct trMsgTestOpSupervision;
	struct trMsgDeMuteTimer;
	struct trMsgRspPlayServiceSupervisionTimer;


    class dabdrv_testOperation:
        public DAB_Singleton <dabdrv_testOperation>,
        public DAB_MessageHandlerCommon<dabdrv_testOperation>
    {
        friend class DAB_Singleton<dabdrv_testOperation>;

    public:
        DAB_TRACE_INFO_IMPL(FC_DABTUNER_TR_DRV_MAIN);
        virtual char const *pcGetName() const {return "dabdrv_testOperation";};
        virtual tVoid vTraceState() const;

        virtual tVoid vInit();
        virtual tVoid vDeInit();

        tBool bEnterRemoteControlIO();
        tBool bLeaveRemoteControlIO();

        virtual tVoid vProcess(trMsgTestOpSupervision* poTestOpSupervision);
		virtual tVoid vProcess(trMsgDeMuteTimer* poDemuteHandler);
        virtual tVoid vProcess(trMsgSrvCmdTestOperation* poMsgSrvCmdTestOperation);

        virtual tVoid vProcess(trMeca_RRdmTune* poRRdmTune);
        virtual tVoid vProcess(trMeca_RRdmAudioPlayService* poRRdmAudioPlayService);
        virtual tVoid vProcess(trMeca_RRdmTuneFrequency* poRRdmTuneFrequency);
        virtual tVoid vProcess(trMeca_RRdmAudioPlayAsid* poRRdmAudioPlayAsid);
        virtual tVoid vProcess(trMeca_RRdmGetRdmInfo* poRRdmGetRdmInfo);
		virtual tVoid vProcess(trMsgRspPlayServiceSupervisionTimer* /*poRspPlayServiceSupervisionTimer*/);

		tVoid vTuneEnsemble(tenMeca_RdmTuneCmd enCmd, tU32 u32Freq, DAB_tenDir enDir);

		tVoid vRestartSupervisionTimer();
        DAB_tenTestOperation enGetCurTestOp() const {
            return _rCurTestOp.enTestOperation;
        }
    private:
        dabdrv_testOperation();
        tVoid vTestOpDone(DAB_tenResult enResult=DAB_enResult_OK);
        tVoid vClear();
        tVoid vRestore();
        tVoid vSetMute();

        typedef enum {
            enRemoteCtrlState_Idle,
            enRemoteCtrlState_WaitGo,
            enRemoteCtrlState_Running
        } tenRemoteCtrlState;

        typedef enum {
            enTestOpSubState_Idle,
            enTestOpSubState_WaitRdmInfoFreq,
            enTestOpSubState_WaitRdmInfoFreqAndAudio
        } tenTestOpSubState;

        
		DAB_tclTimer _otrMsgRspPlaySericeSupervisionTimer;
        tenRemoteCtrlState _enRemoteCtrlState;
        trMsgSrvCmdTestOperation _rCurTestOp;
        trMsgSrvCmdSetup _rStoredSetup;
        DAB_tclTimer _oSupervisionTimer;
		DAB_tclTimer _oMuteHandlingTimer;
        trMainUsrData _oStoredLsmData;
        tBool _bTestModeIsActive;
        tBool _bSendTunereq ;
        tBool _bRdmStatus;
		tBool bRDMSync;
    };
} //namespace DAB 

#endif
