/************************************************************************
 * FILE:    dabdrv_testOperation.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  header of dabdrv_testOperation
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/
 
#include "dabdrv_testOperation.hpp"
#include "dabdrv_main.hpp"
#include "dabdrv_mute.hpp"
#include "dabdrv_chnInfo.hpp"
#include "dabdrv_presets.hpp"
#include "dabdrv_chnSelect.hpp"
//#define ETG_I_TEST

#ifdef ETG_I_TEST
#include "etgTest.h"
#endif

using namespace DAB;
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN

#ifdef ETG_I_TEST
//#define ETG_I_TRACE_CHANNEL TR_TTFIS_FC_DABTUNER
#define ETG_I_TTFIS_CMD_PREFIX "DAB_"
//lint -esym(528, vTraceTestETGI*) "Symbol not referenced ..."

typedef enum {
    etgi_enTestEnum1_Elem1,
    etgi_enTestEnum1_Elem2
} etgi_tenTestEnum1;

typedef enum {
    etgi_enTestEnum2_Elem1,
    etgi_enTestEnum2_Elem2
} etgi_tenTestEnum2;

static tVoid vTraceTestETGIPar10(tCString thisStr);
static tVoid vTraceTestETGIPar11(tCString thisStr, tU8 thisu8Value);
static tVoid vTraceTestETGIPar12(tU8 thisu8Value, tCString thisStr);
static tVoid vTraceTestETGIPar13(tU8 thisu8Value, tCString thisStr, tU8 thatu8Value);
static tVoid vTraceTestETGIPar20(tPCU8 thiscu8Array);
static tVoid vTraceTestETGIPar21(tPCU8 thiscu8Array, tU8 thisu8Value);
static tVoid vTraceTestETGIPar22(tU8 thisu8Value, tPCU8 thiscu8Array);
static tVoid vTraceTestETGIPar23(tU8 thisu8Value, tPCU8 thiscu8Array, tU8 thatu8Value);
static tVoid vTraceTestETGIPar30(tU32 thisu32Value);
static tVoid vTraceTestETGIPar31(tU32 thisu32Value, tU32 thatu32Value);
static tVoid vTraceTestETGIPar40(tS32 thiss32Value);
static tVoid vTraceTestETGIPar41(tS32 thiss32Value, tS32 thats32Value);
static tVoid vTraceTestETGIPar50(tU16 thisu16Value);
static tVoid vTraceTestETGIPar51(tU16 thisu16Value, tU16 thatu16Value);
static tVoid vTraceTestETGIPar52(tU16 thisu16Value, tU16 thatu16Value, tU16 thoseu16Value);
static tVoid vTraceTestETGIPar53(tU16 thisu16Value, tU32 thatu32Value, tU16 thoseu16Value);
static tVoid vTraceTestETGIPar60(tS16 thiss16Value);
static tVoid vTraceTestETGIPar61(tS16 thiss16Value, tS16 thats16Value);
static tVoid vTraceTestETGIPar62(tS16 thiss16Value, tS16 thats16Value, tS16 thoses16Value);
static tVoid vTraceTestETGIPar63(tS16 thiss16Value, tS32 thats32Value, tS16 thoses16Value);
static tVoid vTraceTestETGIPar70(tU8 thisu8Value);
static tVoid vTraceTestETGIPar71(tU8 thisu8Value, tU8 thatu8Value);
static tVoid vTraceTestETGIPar72(tU8 thisu8Value, tU8 thatu8Value, tU8 thoseu8Value);
static tVoid vTraceTestETGIPar73(tU8 thisu8Value, tU32 thatu32Value, tU8 thoseu8Value);
static tVoid vTraceTestETGIPar80(tS8 thiss8Value);
static tVoid vTraceTestETGIPar81(tS8 thiss8Value, tS8 thats8Value);
static tVoid vTraceTestETGIPar82(tS8 thiss8Value, tS8 thats8Value, tS8 thoses8Value);
static tVoid vTraceTestETGIPar83(tS8 thiss8Value, tS32 thats32Value, tS8 thoses8Value);
static tVoid vTraceTestETGIPar84(tS8 thiss8Value, tS32 thats32Value, tS8 thoses8Value);
static tVoid vTraceTestETGIPar90(etgi_tenTestEnum1 en1, etgi_tenTestEnum2 en2);
static tVoid vTraceTestETGIPar91(tU32 u32OsalErrorCode);

#endif

#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_DRV_MAIN 
#include "trcGenProj/Header/dabdrv_testOperation.cpp.trc.h"
#endif

#define DAB_TESTOP_SUPERV_DEFAULT_MS 30000 
namespace DAB {
    struct trMsgTestOpSupervision:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "trMsgTestOpSupervision"));
        };
    };
	 struct trMsgDeMuteTimer:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "trMsgDeMuteTimer"));
        };
    };

struct trMsgRspPlayServiceSupervisionTimer:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "trMsgRspPlayAsidSupervisionTimer"));
        };
    };
}

static inline  tBool  DAB_bCheckBitsSet(tU32 u32Val, tU32 u32Bits) {
    return ((u32Val & u32Bits) != u32Bits);
}

static inline  tBool  DAB_bCheckBitsNotSet(tU32 u32Val, tU32 u32Bits) {
    return ((~u32Val & u32Bits) != u32Bits);
}

dabdrv_testOperation::dabdrv_testOperation() {
    vSubscribe<trMsgTestOpSupervision>();
	vSubscribe<trMsgDeMuteTimer>();
    vSubscribe<trMsgSrvCmdTestOperation>();
	vSubscribe<trMsgRspPlayServiceSupervisionTimer>();

    vSubscribe<trMeca_RRdmTune>();
    vSubscribe<trMeca_RRdmAudioPlayService>();
    vSubscribe<trMeca_RRdmTuneFrequency>();
    vSubscribe<trMeca_RRdmAudioPlayAsid>();
    vSubscribe<trMeca_RRdmGetRdmInfo>();

    _enRemoteCtrlState=enRemoteCtrlState_Idle;
    _bTestModeIsActive = FALSE;
    _bSendTunereq = FALSE;
	_bRdmStatus = FALSE;
	bRDMSync = FALSE;

}

tVoid dabdrv_testOperation::vTraceState() const {
    ETG_TRACE_USR1(("  dabdrv_testOperation STATE: CurTestOp=%d _enRemoteCtrlState=%d tmrRunning=%d",
                    ETG_CENUM(DAB_tenTestOperation, enGetCurTestOp()),
                    ETG_CENUM(tenRemoteCtrlState, _enRemoteCtrlState),
                    _oSupervisionTimer.bIsRunning()));
}

tVoid dabdrv_testOperation::vInit() {
    ETG_TRACE_USR1(("dabdrv_testOperation::vInit"));
#ifdef ETG_I_TEST
    ETG_I_REGISTER_FILE();
#endif
    _oSupervisionTimer.vInit(instance(), trMsgTestOpSupervision());
	_oMuteHandlingTimer.vInit(instance(), trMsgDeMuteTimer());
	_otrMsgRspPlaySericeSupervisionTimer.vInit(instance(),trMsgRspPlayServiceSupervisionTimer());

}

tVoid dabdrv_testOperation::vDeInit() {
    ETG_TRACE_USR1(("dabdrv_testOperation::vDeInit"));
#ifdef ETG_I_TEST
    ETG_I_UNREGISTER_FILE();
#endif
    vClear();
    _oSupervisionTimer.vDeInit();
	_oMuteHandlingTimer.vDeInit();
	_otrMsgRspPlaySericeSupervisionTimer.vDeInit();
}



tBool dabdrv_testOperation::bEnterRemoteControlIO()  {
    ETG_TRACE_USR1(("dabdrv_testOperation::bEnterRemoteControlIO"));

    if (_enRemoteCtrlState==enRemoteCtrlState_WaitGo) {
        _enRemoteCtrlState=enRemoteCtrlState_Running;
        dabdrv_main::instance()->vGetUserData(&_oStoredLsmData);
        ETG_TRACE_USR1(("dabdrv_testOperation::bEnterRemoteControlIO: sid=0x%08x",
                        _oStoredLsmData.rLastSrv.u32GetSID()));

        _rStoredSetup=dabdrv_main::instance()->rGetCurrentSetup();
        trMsgSrvCmdSetup rSetup;
        rSetup.bUseConcealmentLevel=FALSE;

        fc_dabtuner_config *poConfig=fc_dabtuner_config::instance();
        if (OSAL_NULL == poConfig) {
            ETG_TRACE_FATAL(("dabdrv_testOperation::bRun config not available !!!"));
            rSetup.e8ServiceLinkingMode= DAB_enServiceLinkingMode_DAB_FM;
        }
        else {
            ETG_TRACE_FATAL(("CONCEALMENT (%d)!!!", rSetup.u8ConcealmentLevel));
            rSetup.bUseConcealmentLevel=TRUE;
            rSetup.u8ConcealmentLevel = poConfig->u8GetConcealmentLevel();
            rSetup.e8ServiceLinkingMode= (DAB_tenServiceLinkingMode)poConfig->enReadSfMode();
        }

        rSetup.bUseServiceLinkingMode=TRUE;
        DAB_vCallMsg(rSetup);
        DAB_vCallMsgCtor(trMsgDrvIndRemoteCtrl(TRUE));
        vTestOpDone();
        return TRUE;
    }

    ETG_TRACE_USR1(("dabdrv_testOperation::bRunActivity: wrong state"));
    return FALSE;
}

tBool dabdrv_testOperation::bLeaveRemoteControlIO() {
    ETG_TRACE_USR1(("dabdrv_testOperation::bLeaveRemoteControlIO"));
    vTraceState();
    if (_enRemoteCtrlState==enRemoteCtrlState_Running) {
        vRestore();
    }
    if (_enRemoteCtrlState==enRemoteCtrlState_Idle) {
        ETG_TRACE_USR1(("dabdrv_testOperation::bLeaveRemoteControlIO"));
        DAB_vCallMsgCtor(trMsgDrvIndRemoteCtrl(FALSE));
    }
    return TRUE;
}
tVoid dabdrv_testOperation::vRestore() {
    ETG_TRACE_USR1(("dabdrv_testOperation::vRestore: sid=0x%08x",
                    _oStoredLsmData.rLastSrv.u32GetSID()));
    DAB_vCallMsg(_rStoredSetup);
    dabdrv_main::instance()->vSetUserData(_oStoredLsmData);
    DAB_vCallMsgCtor(dabdrv_main::instance(), trMsgDrvCmdApplyUsrData());
}


tVoid dabdrv_testOperation::vProcess(trMsgRspPlayServiceSupervisionTimer* /*poRspPlayServiceSupervisionTimer*/) {

	ETG_TRACE_USR1(("trMsgRspPlayServiceSupervisionTimer Expired"));
	trMsgDrvDbQuery rDbQueryAltFreq(Query_AltFreqInformation);
	DAB_vCallMsg(rDbQueryAltFreq);

}

void dabdrv_testOperation::vProcess(trMsgSrvCmdTestOperation* poMsgSrvCmdTestOperation) {
    tBool &bRejected=poMsgSrvCmdTestOperation->bRejected;
    bRejected=FALSE;
    ETG_TRACE_USR1(("dabdrv_testOperation::trMsgSrvCmdTestOperation START: testOp=%d",
                    ETG_CENUM(DAB_tenTestOperation, poMsgSrvCmdTestOperation->enTestOperation)));

        // busy
    tU32 u32SvTimeOutMs=DAB_TESTOP_SUPERV_DEFAULT_MS;
    _rCurTestOp=*poMsgSrvCmdTestOperation;
    dabdrv_presets::instance()->vResetSelectSource();
    dabdrv_chnSelect::instance()->vResetChnSelectState();
    //PSARCCB-10638 sometimes not cleared and wrong update is going from dabdrv_main::vProcess(trMeca_RRdmGetAudioStatus)
    //reset the source state.
    dabdrv_main::instance()->vSetPresetOrChannelRecallRequested(PresetOrChannelRecallInvalid);

    switch(_rCurTestOp.enTestOperation) {
        case DAB_enTestOperation_TUNE_ENSEMBLE:
        {
            if (_rCurTestOp.u32Value1==0 || _rCurTestOp.u32Value1>(tU32)enMeca_RdmTuneCmd_SKIM) {
                bRejected=TRUE;
                break;                
            }

			vTuneEnsemble((tenMeca_RdmTuneCmd)_rCurTestOp.u32Value1,
											  _rCurTestOp.u32Value2,
								  (DAB_tenDir)_rCurTestOp.u32Value3 );

            break;
        }

        case DAB_enTestOperation_TUNE_SERVICE:
        {
            if (_rCurTestOp.u32Value1==0 || _rCurTestOp.u32Value1>(tU8)enMeca_RdmServiceCommand_PLAY_NEXT) {
                bRejected=TRUE;
                break;
            }
        	DAB_trEnsembleInfoProperty rProperty=dabdrv_properties::instance()->oEnsembleInfoProperty.oGet();
        	rProperty.rEnsembleLabel.bLabelValid = FALSE;
        	dabdrv_properties::instance()->oEnsembleInfoProperty.vSet(rProperty);
            dabdrv_mecaIf::instance()->vSendMecaCommandCtor(trMeca_CRdmAudioPlayService((tenMeca_RdmServiceCommand)_rCurTestOp.u32Value1));
			/*if timer is running for an older prev/next operation and if a new request comes,stop timer*/
			if(_oMuteHandlingTimer.bIsRunning()){
				_oMuteHandlingTimer.vStop();
			}
            break;
        }

        case DAB_enTestOperation_TUNE_FREQUENCY:
        {
            dabdrv_mecaIf::instance()->vSendMecaCommandCtor(trMeca_CRdmTuneFrequency(_rCurTestOp.u32Value1));
            break;
        }
        case DAB_enTestOperation_PLAY_ASID:
        {
			if (dabdrv_main::instance()->enGetSourceState() == DAB_enSourceState_BG && _rCurTestOp.u32Value1 > 0)
			{
				trMsgSrvCmdStorePreset rStorePreset;
        		rStorePreset.rPSID._u32Id = _rCurTestOp.u32Value1; //PSID
        		rStorePreset.u32EnsFrequency = _rCurTestOp.u32Value2; //Frequency
        		dabdrv_presets::instance()->vMovePresetToLSM(&rStorePreset);	
			}
			else if(_rCurTestOp.u32Value1 > 0){
				trMeca_CRdmAudioPlayAsid rRdmAudioPlayAsid;
				rRdmAudioPlayAsid.rMecaProgrammeService=trMecaProgrammeService(_rCurTestOp.u32Value1);
				dabdrv_mecaIf::instance()->vSendMecaCommand(rRdmAudioPlayAsid);
        	}else{
				tU8 u8Options = dabdrv_main::instance()->bIsCompMode()? 2 : 0;
				dabdrv_presets::instance()->vPLayLSM(u8Options);
        	}

			break;
        }


        case DAB_enTestOperation_VERIFY_FREQ_ASID_AUDIO:
        {
            dabdrv_mecaIf::instance()->vSendMecaCommandCtor(trMeca_CRdmGetRdmInfo());
            break;
        }
        
        case DAB_enTestOperation_REMOTE_CTRL_ENTER:
        {
            trMsgSrvCmdMtcMode rMsgMtc(DAB_enMtcMode_Off);
            DAB_vCallMsg(rMsgMtc);
            _enRemoteCtrlState=enRemoteCtrlState_WaitGo;
            bEnterRemoteControlIO();
            break;
        }

        case DAB_enTestOperation_REMOTE_CTRL_LEAVE:
        {
			fc_dabtuner_config *poConfig=fc_dabtuner_config::instance();
			if (OSAL_NULL ==poConfig) {
			ETG_TRACE_FATAL(("dabdrv_main::vProcess(trMsgSrvCmdTestOperation) config not available !!!"));
				return;
			}			
			//trMsgSrvCmdMtcMode rMsgMtc(DAB_enMtcMode_DAB_FM_On/*(DAB_tenMtcMode)poConfig->enReadSfMode()*/);
			trMsgSrvCmdMtcMode rMsgMtc(poConfig->enReadMtcMode());
			DAB_vCallMsg(rMsgMtc);

            if ( TRUE ==_bTestModeIsActive ) {
                _bTestModeIsActive = FALSE;
            } else {
                vRestore();
            }
            _enRemoteCtrlState=enRemoteCtrlState_Idle;
            vTestOpDone();
            if (_enRemoteCtrlState==enRemoteCtrlState_Idle) {
                ETG_TRACE_USR1(("dabdrv_testOperation::vClear: RemoteCtrl Terminated"));
                DAB_vCallMsgCtor(trMsgDrvIndRemoteCtrl(FALSE));
                bLeaveRemoteControlIO();
            }
            break;
        }
        case DAB_enTestOperation_TESTMODE_ACTIVE:
        {
            _bTestModeIsActive = TRUE;
            break;
        }
        case DAB_enTestOperation_INVALID:
        default:
            bRejected=TRUE;
            break;
            
    }
    
    if (bRejected) {
        ETG_TRACE_USR1(("dabdrv_testOperation::trMsgSrvCmdTestOperation REJECTED"));
        _rCurTestOp=trMsgSrvCmdTestOperation();
    }
    
    if (enGetCurTestOp()!=DAB_enTestOperation_INVALID) {
        _oSupervisionTimer.vStart(u32SvTimeOutMs);
    }

}


void dabdrv_testOperation::vProcess(trMsgTestOpSupervision* poTestOpSupervision) {
    (tVoid)poTestOpSupervision;
    ETG_TRACE_USR1(("dabdrv_testOperation::trMsgTestOpSupervision _bRdmStatus = %d, Current Test Operation = %d",_bRdmStatus,enGetCurTestOp()));
    if ((enGetCurTestOp()!=DAB_enTestOperation_INVALID)&&
    		_bRdmStatus){
        ETG_TRACE_USR1(("dabdrv_testOperation::trMsgTestOpSupervision"));
        vTestOpDone(DAB_enResult_FAILED);
    }    
}

void dabdrv_testOperation::vProcess(trMsgDeMuteTimer* poDemuteHandler){
	(tVoid)poDemuteHandler;
	ETG_TRACE_USR1(("dabdrv_testOperation:: De mute being sent")); 
	vSetMute();
}

void dabdrv_testOperation::vProcess(trMeca_RRdmTune* poRRdmTune) {
    ETG_TRACE_USR1(("dabdrv_testOperation::trMeca_RRdmTune"));

    if (enGetCurTestOp() != DAB_enTestOperation_TUNE_ENSEMBLE) {
        return;
    }
    DAB_trTunerStatusProperty oTunerStatus = dabdrv_properties::instance()->oTunerStatusProperty.oGet();

	ETG_TRACE_USR1(("u32LastTunedFrequency= %d oTunerStatus.u32Frequency = %d bRDMSync=%d",dabdrv_chnInfo::instance()->u32GetLastTunedFrequency(), oTunerStatus.u32Frequency, bRDMSync ));
    
    if (poRRdmTune->enTuneState== enMeca_RdmTuneState_SEARCHING_DONE ||
		poRRdmTune->enTuneState== enMeca_RdmTuneState_TUNING_DONE) {

	// If signals are not available and a seek is performed, on seek completion the last tuned channel should be tuned
		if ((dabdrv_chnInfo::instance()->u32GetLastTunedFrequency() == oTunerStatus.u32Frequency)
				&& (!bRDMSync) && !(dabdrv_chnInfo::instance()->rGetChnInfo().u16Scids))
		{
			ETG_TRACE_USR1(("dabdrv_testOperation::PlayLSM"));
			dabdrv_presets::instance()->vPLayLSM(0);
			oTunerStatus.enTunerActivityType = DAB_enTunerActivityType_NORMAL;
			dabdrv_properties::instance()->oTunerStatusProperty.vSet(oTunerStatus);
			vSetMute();
		}
		else
		{

    		ETG_TRACE_USR1(("  dabdrv_testOperation:trMeca_RRdmTune TUNING DONE "));
    		vRestartSupervisionTimer();
			_rCurTestOp.enTestOperation=DAB_enTestOperation_TUNE_SERVICE;
			/*if next ensemble is seeked, tune to first service of next ensemble,
			  if previous ensemble is seeked, tune to last service of previous ensemble*/
			trMeca_CRdmAudioPlayService rPlayService;
//NCG3D-46970 - In IVI for up or down ensemble seek, first service should be played. 			
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
			tenMeca_RdmServiceCommand enCmnd=enMeca_RdmServiceCommand_PLAY_FIRST;
#else
			tenMeca_RdmServiceCommand enCmnd= ((DAB_tenDir)_rCurTestOp.u32Value3==DAB_enDir_UP)?enMeca_RdmServiceCommand_PLAY_NEXT:enMeca_RdmServiceCommand_PLAY_PREVIOUS;
#endif
			rPlayService.enServiceCommand = enCmnd;		
			dabdrv_mecaIf::instance()->vSendMecaCommandCtor(rPlayService);
    		/*not required as always Tuning to an ensemble will tune first service and setmute,testopdone is done in rRdmAudioPlayservice*/
			//vSetMute();
    		//vTestOpDone();		
			//Activity type will be set once channel play is completed.
			//oTunerStatus.enTunerActivityType = DAB_enTunerActivityType_NORMAL;
			//dabdrv_properties::instance()->oTunerStatusProperty.vSet(oTunerStatus);
		}

    }
    else if (poRRdmTune->enTuneState== enMeca_RdmTuneState_TUNING ||
        poRRdmTune->enTuneState== enMeca_RdmTuneState_SEARCHING ||
        poRRdmTune->enTuneState== enMeca_RdmTuneState_SEARCHING_ENS||
		poRRdmTune->enTuneState== enMeca_RdmTuneState_SKIMMING) {

    	ETG_TRACE_USR4(("  dabdrv_testOperation:trMeca_RRdmTune TUNING going on "));
		oTunerStatus.enTunerActivityType =(poRRdmTune->enTuneState== enMeca_RdmTuneState_SKIMMING)? DAB_enTunerActivityType_SCAN:DAB_enTunerActivityType_SEEK;

		dabdrv_properties::instance()->oTunerStatusProperty.vSet(oTunerStatus);
    }
    else if((poRRdmTune->enTuneState== enMeca_RdmTuneState_STOP)||(poRRdmTune->enTuneState== enMeca_RdmTuneState_NO_ENS_AVAILABLE))
	{
		oTunerStatus.enTunerActivityType = DAB_enTunerActivityType_NORMAL;
		//Reset the chninfo Property to make channel state unavailable.
		//As STOP is received in between SERACH, due to some reasons and previous channel state is stable,
		//then it is displaying the previously played channel info.
		dabdrv_chnSelect::instance()->vResetChnInfoProperty();
		dabdrv_properties::instance()->oTunerStatusProperty.vSet(oTunerStatus);
		vSetMute();
	}
}

void dabdrv_testOperation::vProcess(trMeca_RRdmAudioPlayService* poRRdmAudioPlayService) {
    ETG_TRACE_USR1(("dabdrv_testOperation::trMeca_RRdmAudioPlayService"));
	poRRdmAudioPlayService->vTrace();
	DAB_trTunerStatusProperty oTunerStatus = dabdrv_properties::instance()->oTunerStatusProperty.oGet();
    if (enGetCurTestOp() != DAB_enTestOperation_TUNE_SERVICE) {
        return;
    }
	if (poRRdmAudioPlayService->enServiceState== enMeca_RdmServiceState_WAITING_FOR_SERVICE) {
        ETG_TRACE_USR4(("  dabdrv_testOperation:trMeca_RRdmAudioPlayService Service Seek going on "));
		if(_otrMsgRspPlaySericeSupervisionTimer.bIsRunning()){
			_otrMsgRspPlaySericeSupervisionTimer.vStop();
		}
		oTunerStatus.enTunerActivityType = DAB_enTunerActivityType_SERVICESEEK;
		dabdrv_properties::instance()->oTunerStatusProperty.vSet(oTunerStatus);
    }
    else if (poRRdmAudioPlayService->enServiceState== enMeca_RdmServiceState_SERVICE_SELECTION_DONE) {
    	_bSendTunereq = FALSE;
		/*vSetMute called in _oMuteHandlingTimer expiry function, but tuner status is sent immediately to show label in HMi */
    	//vSetMute();
		oTunerStatus.enTunerActivityType = DAB_enTunerActivityType_NORMAL;
		dabdrv_properties::instance()->oTunerStatusProperty.vSet(oTunerStatus);
		
		_oMuteHandlingTimer.vStart(DAB_MUTE_SUPERVISION_TIMER_MS);
		
		trMsgDrvCmdSetChnInfoPsid rDrvCmdSetChnInfoPsid;
		rDrvCmdSetChnInfoPsid.rProgService=poRRdmAudioPlayService->rMecaProgrammeService;
        DAB_vCallMsg(rDrvCmdSetChnInfoPsid);
        //Reset Preset select source
        dabdrv_presets::instance()->vResetSelectSource();
		_otrMsgRspPlaySericeSupervisionTimer.vStart(DAB_PLAY_ASID_SUPERVISION_TIMER_MS);
    	vTestOpDone();
    }
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
	else if((poRRdmAudioPlayService->enServiceState== enMeca_RdmServiceState_SERVICE_NO_NEXTSERVICE)||
			(poRRdmAudioPlayService->enServiceState== enMeca_RdmServiceState_SERVICE_NO_PREVIOUSSERVICE))
	{
			vRestartSupervisionTimer();
			DAB_tenDir enDirection = ((tenMeca_RdmServiceCommand)_rCurTestOp.u32Value1==enMeca_RdmServiceCommand_PLAY_NEXT)?DAB_enDir_UP:DAB_enDir_DOWN;
			_rCurTestOp.enTestOperation = DAB_enTestOperation_TUNE_ENSEMBLE;
			_rCurTestOp.u32Value1 = (tU32)enMeca_RdmTuneCmd_SEARCH;
			_rCurTestOp.u32Value2 = oTunerStatus.u32Frequency;
			_rCurTestOp.u32Value3 = (tU32)enDirection;
			vTuneEnsemble(enMeca_RdmTuneCmd_SEARCH,oTunerStatus.u32Frequency,enDirection);				
	}else if(poRRdmAudioPlayService->enServiceState== enMeca_RdmServiceState_SERVICE_INVALID ||
			poRRdmAudioPlayService->enServiceState== enMeca_RdmServiceState_PSID_NOT_AVAILABLE){
				oTunerStatus.enTunerActivityType = DAB_enTunerActivityType_NORMAL;
				dabdrv_properties::instance()->oTunerStatusProperty.vSet(oTunerStatus);
				
				//No signal is available and DAB FM linking happened the SKIM and release.
				//It comes to the same point now do seek up and it displays Frequency only.
				//Because no channel info property update is going.
				dabdrv_chnSelect::instance()->vResetChnInfoProperty();

				//PSARCC30-1446 - De-mute should be done if invalid service response is recieved from ADR.
				vSetMute();
				vTestOpDone();
	}
#endif

}

void dabdrv_testOperation::vSetMute()
{
#ifdef MUTE_ACTIVE
	DAB_trTunerStatusProperty oTunerStatus = dabdrv_properties::instance()->oTunerStatusProperty.oGet();
	if(dabdrv_main::instance()->enGetMuteOperation() == enMuteOperation_ManualTune)
	{
		tenMuteOperation enNextMuteOp=dabdrv_main::instance()->enGetNextMuteOperation();
		if(enNextMuteOp != enMuteOperation_None){
			dabdrv_main::instance()->enSetMuteOperation(enNextMuteOp);
			dabdrv_main::instance()->enSetNextMuteOperation(enMuteOperation_None);
			trMsgDrvMuteState rMsg;
			rMsg.enDabSource = enDabSource_Dab;
			rMsg.enMuteState= enRequiredMuteState_Mute;
			DAB_vCallMsg(rMsg);
		}
		else{
			dabdrv_main::instance()->enSetMuteOperation(enMuteOperation_None);
			trMsgDrvCmdTunerOpMuteReq rMuteReq;
			rMuteReq.enRequiredMuteState=enRequiredMuteState_Demute;
			rMuteReq.enMuteOperation=enMuteOperation_ManualTune;
			DAB_vCallMsg(rMuteReq);

			oTunerStatus.enTunerActivityType = DAB_enTunerActivityType_NORMAL;
			vTestOpDone();
			dabdrv_properties::instance()->oTunerStatusProperty.vSet(oTunerStatus);
		}
	}
	else
	{
		oTunerStatus.enTunerActivityType = DAB_enTunerActivityType_NORMAL;
		dabdrv_properties::instance()->oTunerStatusProperty.vSet(oTunerStatus);
		vTestOpDone();
	}
#endif
}

void dabdrv_testOperation::vProcess(trMeca_RRdmTuneFrequency* poRRdmTuneFrequency) {
    ETG_TRACE_USR1(("dabdrv_testOperation::trMeca_RRdmTuneFrequency"));
    if (enGetCurTestOp() != DAB_enTestOperation_TUNE_FREQUENCY) {
        return;
    }
	
	if(dabdrv_main::instance()->enGetSourceState() != DAB_enSourceState_FG)
	{
		vTestOpDone(DAB_enResult_FAILED);
	}	
    else if (poRRdmTuneFrequency->enFrequencyState== enMeca_RdmFrequencyState_FREQUENCY_INVALID) {
#ifdef DAB_ENABLE_MUTE_HANDLING
    	vSetMute();
#else
    	vTestOpDone(DAB_enResult_FAILED);
#endif
    }
	else if (poRRdmTuneFrequency->enFrequencyState== enMeca_RdmFrequencyState_TUNING_DONE)
	{
		vTestOpDone(DAB_enResult_OK);
		_rCurTestOp.enTestOperation=DAB_enTestOperation_TUNE_SERVICE;
		trMeca_CRdmAudioPlayService rPlayService;
		tenMeca_RdmServiceCommand enCmnd= enMeca_RdmServiceCommand_PLAY_NEXT;
		rPlayService.enServiceCommand = enCmnd;		
		dabdrv_mecaIf::instance()->vSendMecaCommandCtor(rPlayService);
		//vTestOpDone(DAB_enResult_OK);
	}
	else
	{
		ETG_TRACE_USR1(("dabdrv_testOperation::Waiting for Tuning Response"));
	}
}


void dabdrv_testOperation::vProcess(trMeca_RRdmAudioPlayAsid* poRRdmAudioPlayAsid) {
    ETG_TRACE_USR1(("dabdrv_testOperation::trMeca_RRdmAudioPlayAsid %d",enGetCurTestOp()));
    if (enGetCurTestOp() != DAB_enTestOperation_PLAY_ASID) {
        return;
    }
	if (poRRdmAudioPlayAsid->rMecaProgrammeService.u32GetSID() == _rCurTestOp.u32Value1){
	    //This will be invoked from presets only when RRdmStationPlay is received
	    //so the only posibilty for poRRdmAudioPlayAsid->enServiceState are SELECTION_DONE/SERVICE_INVALID
	    //WAITING_FOR_SERVICE will never come.

		 if(poRRdmAudioPlayAsid->enServiceState!=enMeca_RdmServiceState_WAITING_FOR_SERVICE){
			 vSetMute();
			 DAB_tenResult result = (poRRdmAudioPlayAsid->enServiceState==
										 enMeca_RdmServiceState_SERVICE_SELECTION_DONE) ? DAB_enResult_OK : DAB_enResult_FAILED;
			 vTestOpDone(result);

		}
		 //PSARCCB-9999 - While tuning is going on user presses Seek Up/Down PLASY ASID will be called
		 //and by that time tuning is stopped, so send tuner Activity type as NORMAL in all cases.
		 DAB_trTunerStatusProperty oTunerStatus = dabdrv_properties::instance()->oTunerStatusProperty.oGet();
		 oTunerStatus.enTunerActivityType = DAB_enTunerActivityType_NORMAL;
		 dabdrv_properties::instance()->oTunerStatusProperty.vSet(oTunerStatus);
	}
}


void dabdrv_testOperation::vProcess(trMeca_RRdmGetRdmInfo* poRRdmGetRdmInfo) {
    ETG_TRACE_USR1(("dabdrv_testOperation::trMeca_RRdmGetRdmInfo"));
	 tU8 u8Status=poRRdmGetRdmInfo->rRdmStatus.u8Status;
	 bRDMSync = ((u8Status & (tU8)enRdmStatusBits_SYNC)!=0);
	 _bRdmStatus = (((u8Status & (tU8)enRdmStatusBits_SYNC)!=0)&&((u8Status & (tU8)enRdmStatusBits_ENS_VALID)!=0)&& (!((u8Status & (tU8)enRdmStatusBits_AUDIO_SRV_VALID)!=0)));
	 ETG_TRACE_USR1(("dabdrv_testOperation::trMeca_RRdmGetRdmInfo :- _bSendTunereq = %d _bRdmStatus = %d",_bSendTunereq,_bRdmStatus));
    if (enGetCurTestOp() == DAB_enTestOperation_VERIFY_FREQ_ASID_AUDIO ) {
        if (poRRdmGetRdmInfo->u32Frequency==_rCurTestOp.u32Value1 &&
            poRRdmGetRdmInfo->rProgrammeService==trMecaId(_rCurTestOp.u32Value2)) {
            
            if (DAB_bCheckBitsSet(u8Status, (tU8)enRdmStatusBits_SYNC | (tU8)enRdmStatusBits_ENS_VALID | (tU8)enRdmStatusBits_AUDIO_SRV_VALID) &&
                DAB_bCheckBitsNotSet(u8Status, (tU8)enRdmStatusBits_MUTE | (tU8)enRdmStatusBits_TUNING)) {
                vTestOpDone();
            }
        }
    }
	 if (enGetCurTestOp() == DAB_enTestOperation_TUNE_SERVICE ) {
		  ETG_TRACE_USR1(("dabdrv_testOperation::testop %d",enGetCurTestOp()));
		if(_bRdmStatus && (!_bSendTunereq)){
		_bSendTunereq = TRUE;
		trMeca_CRdmAudioPlayService rPlayService;		
		tenMeca_RdmServiceCommand enCmnd= ((DAB_tenDir)_rCurTestOp.u32Value3==DAB_enDir_UP)?enMeca_RdmServiceCommand_PLAY_NEXT:enMeca_RdmServiceCommand_PLAY_PREVIOUS;
		rPlayService.enServiceCommand = enCmnd;		
		dabdrv_mecaIf::instance()->vSendMecaCommandCtor(rPlayService);
		}
	 }
}

tVoid dabdrv_testOperation::vRestartSupervisionTimer(){
    tU32 u32SvTimeOutMs=DAB_TESTOP_SUPERV_DEFAULT_MS;
    ETG_TRACE_USR1(("dabdrv_testOperation::vRestartSupervisionTimer"));
	if(_oSupervisionTimer.bIsRunning()){
		ETG_TRACE_USR1(("dabdrv_testOperation::vRestartSupervisionTimer: Inside If condition"));
		_oSupervisionTimer.vStop();
		_oSupervisionTimer.vStart(u32SvTimeOutMs);
	}
}



tVoid dabdrv_testOperation::vTestOpDone(DAB_tenResult enResult) {
    ETG_TRACE_USR1(("dabdrv_testOperation::vTestOpDone(%d)",
                    ETG_CENUM(DAB_tenResult, enResult)));

    if (enGetCurTestOp()!=DAB_enTestOperation_INVALID) {
        DAB_vCallMsgCtor(trMsgSrvRspTestOperation(enGetCurTestOp(), enResult));
        _rCurTestOp=trMsgSrvCmdTestOperation();
        vClear();
    }
}

tVoid dabdrv_testOperation::vClear() {
    ETG_TRACE_USR1(("dabdrv_testOperation::vClear"));

    if (enGetCurTestOp()!=DAB_enTestOperation_INVALID) {
        ETG_TRACE_USR1(("dabdrv_testOperation::vClear: TestOp FAILED"));
    
        DAB_vCallMsgCtor(trMsgSrvRspTestOperation(enGetCurTestOp(), DAB_enResult_FAILED));
        _rCurTestOp=trMsgSrvCmdTestOperation();
    }
    
    _oSupervisionTimer.vStop();
}

tVoid dabdrv_testOperation::vTuneEnsemble(tenMeca_RdmTuneCmd enCmd,
										  tU32 u32Freq,
										  DAB_tenDir enDir){
	  ETG_TRACE_USR1(("dabdrv_testOperation::vTuneEnsemble Cmd =%d , Freq = %x , Dir =%d",enCmd,u32Freq,enDir));

	  //If Previously Tuned Service Mute timer is not expired and if TUNE_Ensmble is received
	  //then previously started mute timer may expire and resets the states.
	  if(_oMuteHandlingTimer.bIsRunning()){
		  _oMuteHandlingTimer.vStop();
	  	}
	 
	  trMeca_CRdmTune oMsgMecaTune;
	  oMsgMecaTune.enTuneCmd = enCmd;
	  oMsgMecaTune.u32StartFrequency = u32Freq;
	  oMsgMecaTune.enDir = enDir;
	  dabdrv_mecaIf::instance()->vSendMecaCommand(oMsgMecaTune);
	  //Coverity 16363
	  //DAB_vCallMsgCtor(trMsgDrvIndRadioText(trRadioText()));
	  trRadioText rRadioText;
	  trMsgDrvIndRadioText oMsgDrvIndRadioText;
	  oMsgDrvIndRadioText.rRadioText = rRadioText;
	  DAB_vCallMsg(oMsgDrvIndRadioText);
}

#ifdef ETG_I_TEST

ETG_I_CMD_DEFINE((vTraceTestETGIPar10, "ETG_I_test_10 %s", ETG_I_STRING ))
static tVoid vTraceTestETGIPar10(tCString thisStr) {
   ETG_TRACE_USR1(("    FC_DEMO_ETG_I_test_10 %s", thisStr ));
}
ETG_I_CMD_DEFINE((vTraceTestETGIPar11, "ETG_I_test_11 %10s %u", ETG_I_STRING, tU8 ))
static tVoid vTraceTestETGIPar11(tCString thisStr, tU8 thisu8Value) {
   ETG_TRACE_USR1(("    FC_DEMO_ETG_I_test_11 %10s %u", thisStr,  thisu8Value));
}
ETG_I_CMD_DEFINE((vTraceTestETGIPar12, "ETG_I_test_12 %u %s", tU8, ETG_I_STRING ))
static tVoid vTraceTestETGIPar12(tU8 thisu8Value, tCString thisStr) {
   ETG_TRACE_USR1(("    FC_DEMO_ETG_I_test_12 %u %s", thisu8Value, thisStr ));
}
ETG_I_CMD_DEFINE((vTraceTestETGIPar13, "ETG_I_test_13 %u %10s %u", tU8, ETG_I_STRING, tU8 ))
static tVoid vTraceTestETGIPar13(tU8 thisu8Value, tCString thisStr, tU8 thatu8Value) {
   ETG_TRACE_USR1(("    FC_DEMO_ETG_I_test_13 %u %10s %u", thisu8Value, thisStr, thatu8Value ));
}
ETG_I_CMD_DEFINE((vTraceTestETGIPar20, "ETG_I_test_20 %x", ETG_I_ARRAY_U8 ))
static tVoid vTraceTestETGIPar20(tPCU8 thiscu8Array) {
   if (thiscu8Array) {
      ETG_TRACE_USR1(("    FC_DEMO_ETG_I_test_20 %x", ETG_LIST_LEN(thiscu8Array[0]), ETG_LIST_PTR_T8(thiscu8Array) ));
   } else {
      ETG_TRACE_USR1(("    FC_DEMO_ETG_I_test_20 ERROR string empty!"));
   }
}
ETG_I_CMD_DEFINE((vTraceTestETGIPar21, "ETG_I_test_21 %10x %u", ETG_I_ARRAY_U8, tU8 ))
static tVoid vTraceTestETGIPar21(tPCU8 thiscu8Array, tU8 thisu8Value) {
   if (thiscu8Array) {
      ETG_TRACE_USR1(("    FC_DEMO_ETG_I_test_21 %x", ETG_LIST_LEN(thiscu8Array[0]), ETG_LIST_PTR_T8(thiscu8Array) ));
      ETG_TRACE_USR1(("    FC_DEMO_ETG_I_test_21 %u", thisu8Value )); // TODO error in list print
   } else {
      ETG_TRACE_USR1(("    FC_DEMO_ETG_I_test_21 ERROR string empty!"));
   }
}
ETG_I_CMD_DEFINE((vTraceTestETGIPar22, "ETG_I_test_22 %u %x", tU8, ETG_I_ARRAY_U8 ))
static tVoid vTraceTestETGIPar22(tU8 thisu8Value, tPCU8 thiscu8Array) {
   if (thiscu8Array && thiscu8Array[0]) {
      ETG_TRACE_USR1(("    FC_DEMO_ETG_I_test_22 %u %x", thisu8Value, ETG_LIST_LEN(thiscu8Array[0]), ETG_LIST_PTR_T8(&thiscu8Array[1]) ));
   } else {
      ETG_TRACE_USR1(("    FC_DEMO_ETG_I_test_22 ERROR string empty!"));
   }
}
ETG_I_CMD_DEFINE((vTraceTestETGIPar23, "ETG_I_test_23 %u %10x %u", tU8, ETG_I_ARRAY_U8, tU8 ))
static tVoid vTraceTestETGIPar23(tU8 thisu8Value, tPCU8 thiscu8Array, tU8 thatu8Value) {
   if (thiscu8Array) {
      ETG_TRACE_USR1(("    FC_DEMO_ETG_I_test_23 %u %x", thisu8Value, ETG_LIST_LEN(thiscu8Array[0]), ETG_LIST_PTR_T8(thiscu8Array) ));
      ETG_TRACE_USR1(("    FC_DEMO_ETG_I_test_23 %u", thatu8Value )); // TODO error in print list
   } else {
      ETG_TRACE_USR1(("    FC_DEMO_ETG_I_test_23 ERROR string empty!"));
   }
}
ETG_I_CMD_DEFINE((vTraceTestETGIPar30, "ETG_I_test_30 %u", tU32 ))
static tVoid vTraceTestETGIPar30(tU32 thisu32Value) {
   ETG_TRACE_USR1(("    FC_DEMO_ETG_I_test_30 %u", thisu32Value ));
}
ETG_I_CMD_DEFINE((vTraceTestETGIPar31, "ETG_I_test_31 %u %u", tU32, tU32 ))
static tVoid vTraceTestETGIPar31(tU32 thisu32Value, tU32 thatu32Value) {
   ETG_TRACE_USR1(("    FC_DEMO_ETG_I_test_31 %u %u", thisu32Value, thatu32Value ));
}
ETG_I_CMD_DEFINE((vTraceTestETGIPar40, "ETG_I_test_40 %d", tS32 ))
ETG_I_CMD_DEFINE((vTraceTestETGIPar40, "ETG_I_test_40_1 %i", tS32 ))
static tVoid vTraceTestETGIPar40(tS32 thiss32Value) {
   ETG_TRACE_USR1(("    FC_DEMO_ETG_I_test_40 %d", thiss32Value ));
}
ETG_I_CMD_DEFINE((vTraceTestETGIPar41, "ETG_I_test_41 %d %d", tS32, tS32 ))
static tVoid vTraceTestETGIPar41(tS32 thiss32Value, tS32 thats32Value) {
   ETG_TRACE_USR1(("    FC_DEMO_ETG_I_test_41 %d %d", thiss32Value, thats32Value ));
}
ETG_I_CMD_DEFINE((vTraceTestETGIPar50, "ETG_I_test_50 %u", tU16 ))
static tVoid vTraceTestETGIPar50(tU16 thisu16Value) {
   ETG_TRACE_USR1(("    FC_DEMO_ETG_I_test_50 %u", thisu16Value ));
}
ETG_I_CMD_DEFINE((vTraceTestETGIPar51, "ETG_I_test_51 %u %u", tU16, tU16 ))
ETG_I_CMD_DEFINE((vTraceTestETGIPar51, "ETG_I_test_51_1 %i %u", tU16, tU16 ))
static tVoid vTraceTestETGIPar51(tU16 thisu16Value, tU16 thatu16Value) {
   ETG_TRACE_USR1(("    FC_DEMO_ETG_I_test_51 %u %u", thisu16Value, thatu16Value ));
}
ETG_I_CMD_DEFINE((vTraceTestETGIPar52, "ETG_I_test_52 %u %u %u", tU16, tU16, tU16 ))
static tVoid vTraceTestETGIPar52(tU16 thisu16Value, tU16 thatu16Value, tU16 thoseu16Value) {
   ETG_TRACE_USR1(("    FC_DEMO_ETG_I_test_52 %u %u %u", thisu16Value, thatu16Value, thoseu16Value ));
}
ETG_I_CMD_DEFINE((vTraceTestETGIPar53, "ETG_I_test_53 %u %u %u", tU16, tU32, tU16 ))
static tVoid vTraceTestETGIPar53(tU16 thisu16Value, tU32 thatu32Value, tU16 thoseu16Value) {
   ETG_TRACE_USR1(("    FC_DEMO_ETG_I_test_53 %u %u %u", thisu16Value, thatu32Value, thoseu16Value ));
}
ETG_I_CMD_DEFINE((vTraceTestETGIPar60, "ETG_I_test_60 %d", tS16 ))
static tVoid vTraceTestETGIPar60(tS16 thiss16Value) {
   ETG_TRACE_USR1(("    FC_DEMO_ETG_I_test_60 %d", thiss16Value ));
}
ETG_I_CMD_DEFINE((vTraceTestETGIPar61, "ETG_I_test_61 %d %d", tS16, tS16 ))
static tVoid vTraceTestETGIPar61(tS16 thiss16Value, tS16 thats16Value) {
   ETG_TRACE_USR1(("    FC_DEMO_ETG_I_test_61 %d %d", thiss16Value, thats16Value ));
}
ETG_I_CMD_DEFINE((vTraceTestETGIPar62, "ETG_I_test_62 %d %d %d", tS16, tS16, tS16 ))
static tVoid vTraceTestETGIPar62(tS16 thiss16Value, tS16 thats16Value, tS16 thoses16Value) {
   ETG_TRACE_USR1(("    FC_DEMO_ETG_I_test_62 %d %d %d", thiss16Value, thats16Value, thoses16Value ));
}
ETG_I_CMD_DEFINE((vTraceTestETGIPar63, "ETG_I_test_63 %d %d %d", tS16, tS32, tS16 ))
static tVoid vTraceTestETGIPar63(tS16 thiss16Value, tS32 thats32Value, tS16 thoses16Value) {
   ETG_TRACE_USR1(("    FC_DEMO_ETG_I_test_63 %d %d %d", thiss16Value, thats32Value, thoses16Value ));
}
ETG_I_CMD_DEFINE((vTraceTestETGIPar70, "ETG_I_test_70 %u", tU8 ))
static tVoid vTraceTestETGIPar70(tU8 thisu8Value) {
   ETG_TRACE_USR1(("    FC_DEMO_ETG_I_test_70 %u", thisu8Value ));
}
ETG_I_CMD_DEFINE((vTraceTestETGIPar71, "ETG_I_test_71 %u %u", tU8, tU8 ))
static tVoid vTraceTestETGIPar71(tU8 thisu8Value, tU8 thatu8Value) {
   ETG_TRACE_USR1(("    FC_DEMO_ETG_I_test_71 %u %u", thisu8Value, thatu8Value ));
}
ETG_I_CMD_DEFINE((vTraceTestETGIPar72, "ETG_I_test_72 %u %u %u", tU8, tU8, tU8 ))
static tVoid vTraceTestETGIPar72(tU8 thisu8Value, tU8 thatu8Value, tU8 thoseu8Value) {
   ETG_TRACE_USR1(("    FC_DEMO_ETG_I_test_72 %u %u %u", thisu8Value, thatu8Value, thoseu8Value ));
}
ETG_I_CMD_DEFINE((vTraceTestETGIPar73, "ETG_I_test_73 %u %u %u", tU8, tU32, tU8 ))
static tVoid vTraceTestETGIPar73(tU8 thisu8Value, tU32 thatu32Value, tU8 thoseu8Value) {
   ETG_TRACE_USR1(("    FC_DEMO_ETG_I_test_73 %u %u %u", thisu8Value, thatu32Value, thoseu8Value ));
}
ETG_I_CMD_DEFINE((vTraceTestETGIPar80, "ETG_I_test_80 %d", tS8 ))
static tVoid vTraceTestETGIPar80(tS8 thiss8Value) {
   ETG_TRACE_USR1(("    FC_DEMO_ETG_I_test_80 %d", thiss8Value ));
}
ETG_I_CMD_DEFINE((vTraceTestETGIPar81, "ETG_I_test_81 %d %d", tS8, tS8 ))
static tVoid vTraceTestETGIPar81(tS8 thiss8Value, tS8 thats8Value) {
   ETG_TRACE_USR1(("    FC_DEMO_ETG_I_test_81 %d %d", thiss8Value, thats8Value ));
}
ETG_I_CMD_DEFINE((vTraceTestETGIPar82, "ETG_I_test_82 %d %d %d", tS8, tS8, tS8 ))
static tVoid vTraceTestETGIPar82(tS8 thiss8Value, tS8 thats8Value, tS8 thoses8Value) {
   ETG_TRACE_USR1(("    FC_DEMO_ETG_I_test_82 %d %d %d", thiss8Value, thats8Value, thoses8Value ));
}
ETG_I_CMD_DEFINE((vTraceTestETGIPar83, "ETG_I_test_83 %d %d %d", tS8, tS32, tS8 ))
static tVoid vTraceTestETGIPar83(tS8 thiss8Value, tS32 thats32Value, tS8 thoses8Value) {
   ETG_TRACE_USR1(("    FC_DEMO_ETG_I_test_83 %d %d %d", thiss8Value, thats32Value, thoses8Value ));
}
ETG_I_CMD_DEFINE((vTraceTestETGIPar84, "ETG_I_test_84 %d", ETG_I_CONST_ARG(84), ETG_I_CONST_ARG(0x0a), tS8 ))
ETG_I_CMD_DEFINE((vTraceTestETGIPar84, "ETG_I_test_85 %d", ETG_I_CONST_ARG(85), ETG_I_CONST_ARG(0x0a), tS8 ))
static tVoid vTraceTestETGIPar84(tS8 thiss8Value, tS32 thats32Value, tS8 thoses8Value) {
   ETG_TRACE_USR1(("    FC_DEMO_ETG_I_test_84/5 %d %d %d", thiss8Value, thats32Value, thoses8Value ));
}

ETG_I_CMD_DEFINE((vTraceTestETGIPar90, "ETG_I_test_90_0 %d %d", 
                  ETG_I_CENUM(etgi_tenTestEnum1),
                  ETG_I_CENUM(etgi_tenTestEnum2)))

ETG_I_CMD_DEFINE((vTraceTestETGIPar90, "ETG_I_test_90_1 %d", 
                  ETG_I_CENUM(etgi_tenTestEnum1),
                  ETG_I_CONST_ARG(etgi_enTestEnum2_Elem2)))

ETG_I_CMD_DEFINE((vTraceTestETGIPar90, "ETG_I_test_90_2 %d", 
                  ETG_I_CONST_ARG(etgi_enTestEnum1_Elem1),
                  ETG_I_CENUM(etgi_tenTestEnum2)))

ETG_I_CMD_DEFINE((vTraceTestETGIPar90, "ETG_I_test_90_3", 
                  ETG_I_CONST_ARG(etgi_enTestEnum1_Elem2),
                  ETG_I_CONST_ARG(etgi_enTestEnum2_Elem1)))



static tVoid vTraceTestETGIPar90(etgi_tenTestEnum1 en1, etgi_tenTestEnum2 en2) {
    ETG_TRACE_USR1(("  FC_DEMO_ETG_I_test_90: TestOp=%d enRemoteCtrlState=%d",
                    ETG_CENUM(etgi_tenTestEnum1, en1),
                    ETG_CENUM(etgi_tenTestEnum2, en2)));

    // for lint
    (tVoid)etgi_enTestEnum1_Elem1;
    (tVoid)etgi_enTestEnum1_Elem2;
    (tVoid)etgi_enTestEnum2_Elem1;
    (tVoid)etgi_enTestEnum2_Elem2;
}

ETG_I_CMD_DEFINE((vTraceTestETGIPar91, "ETG_I_test_91 %u", 
                  (tU8)ETG_I_ENUM(OSAL_ERROR_CODE)))
static tVoid vTraceTestETGIPar91(tU32 u32OsalErrorCode) {
    ETG_TRACE_USR1(("  FC_DEMO_ETG_I_test_91: u32OsalErrorCode=%u",
                    ETG_ENUM(OSAL_ERROR_CODE, u32OsalErrorCode)));
}

#endif
