/************************************************************************
 * FILE:  dabdrv_rdm.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  header of dabdrv_rdm
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#include "dabdrv_main.hpp"
#include "dabdrv_mecaIf.h"
#include "dabmeca_rdm.hpp"
#include "dabdrv_rdm.hpp"
#include "dabdrv_presets.hpp"
#include "dabdrv_chnInfo.hpp"

#ifndef DABTUNER_UTEST
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_fc_dabtuner_if.h"
#include "dp_generic_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_DRV_MECA 
#include "trcGenProj/Header/dabdrv_rdm.cpp.trc.h"
#endif

using namespace DAB;
#define DAB_RDM_WAIT_NOTIFY_MS (2000 * DAB_TIME_FACTOR)
namespace DAB {

    struct trMsgRdmSetNotifyWaitTimeOut:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "  trMsgRdmSetNotifyWaitTimeOut"));
        };

    };

    struct trMsgRdmSetSrvFollowClassWaitTimeOut:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "  trMsgRdmSetSrvFollowClassWaitTimeOut"));
        };

    };

}

dabdrv_rdm::dabdrv_rdm() {
    vSubscribe<trMsgDrvStartComponent>();
    vSubscribe<trMsgDrvStopComponent>();
    vSubscribe<trMsgDrvCmdSetRdmNotifyMode>();
    vSubscribe<trMsgDrvCmdSetDabSrvFollowClass>();
    vSubscribe<trMsgDrvCmdConfigDabSrvFollow>();
    vSubscribe<trMsgDrvCmdEnableDabSrvFollow>();
	 vSubscribe<trMsgSrvGetTIIList>();
	vSubscribe<trMeca_RRdmGetCurrTiiList>();
    vSubscribe<trMeca_RRdmGetSignalQuality>();
    vSubscribe<trMeca_RRdmGetRdmInfo>();
    vSubscribe<trMeca_RRdmGetDabFrequencyTable>();
    vSubscribe<trMeca_RRdmSetDabFrequencyTable>();
    vSubscribe<trMeca_RRdmAudioGetScidi>();
    vSubscribe<trMeca_RRdmGetEid>();
    vSubscribe<trMeca_RRdmQualityConfig>();
    vSubscribe<trMeca_RRdmServFollowSetMode>();
    vSubscribe<trMeca_RRdmLearn>();
    vSubscribe<trMeca_RRdmAudioGetAsid>();
    vSubscribe<trMeca_RRdmGetAudioStatus>();
	 vSubscribe<trMsgDrvCmdDabFrequencyTable>();
	vSubscribe<trMeca_RRdmScan>();
	vSubscribe<trMeca_RRdmGetCurrTiiList>();

    _enNotifyMode=enRdmNotifyMode_Normal;
    _bTestMode=FALSE;
    _enSrvFollowClass=enSrvFollowClass_Normal;
    _aenSrvFollowModes[enSrvFollowClass_Off] = 0;
    _aenSrvFollowModes[enSrvFollowClass_ChnSelect] = ((tU8)enMeca_RdmServFollowMode_ALT_FREQUENCY | (tU8)enMeca_RdmServFollowMode_ALT_HARD_LINKING | (tU8)enMeca_RdmServFollowMode_ALT_ENSEMBLE | (tU8)enMeca_RdmServFollowMode_ALT_SEARCH | (tU8)enMeca_RdmServFollowMode_ALT_STICKYCOMPONENT);
    _aenSrvFollowModes[enSrvFollowClass_Skip] = ((tU8)enMeca_RdmServFollowMode_ALT_FREQUENCY | (tU8)enMeca_RdmServFollowMode_ALT_ENSEMBLE); 
    _aenSrvFollowModes[enSrvFollowClass_Normal] = ((tU8)enMeca_RdmServFollowMode_ALT_FREQUENCY | (tU8)enMeca_RdmServFollowMode_ALT_HARD_LINKING | (tU8)enMeca_RdmServFollowMode_ALT_ENSEMBLE) | (tU8)enMeca_RdmServFollowMode_ALT_SEARCH | (tU8)enMeca_RdmServFollowMode_ALT_STICKYCOMPONENT;
    _bEnableSrvFollow = TRUE;
    _u8LastSendSrvFollowMode=0;
    _bCorrectSrvFollowModeReceived=FALSE;
    _bTunerStatusLearn = FALSE;
    _bRdmScan = FALSE;
	_bServiceChanged = FALSE;
	_bNewServiceReceived = FALSE;
	_u8ECC = 0;
}

void dabdrv_rdm::vInit() {
    _oNotifyWaitTimer.vInit(instance(),trMsgRdmSetNotifyWaitTimeOut());  
    _oSrvFollowWaitTimer.vInit(instance(),trMsgRdmSetSrvFollowClassWaitTimeOut());  
    _bEnableSrvFollow = DAB_bDoSrvLinkingDab(dabdrv_main::instance()->enGetServiceLinkingMode());
}

void dabdrv_rdm::vDeInit() {
    _oNotifyWaitTimer.vDeInit();  
    _oSrvFollowWaitTimer.vDeInit();  
}

tVoid dabdrv_rdm::vTraceState() const {

    ETG_TRACE_USR1(("  dabdrv_rdm STATE: _rRdmEnsemble=0x%08x _enNotifyMode=%d _bTestMode=%d "
                    "_bEnableSrvFollow=%d _oNotifyWaitTimerRunning=%d oSrvFollowWaitTimerRunning=%d _bCorrectSrvFollowModeReceived=%d "
                    "_enSrvFollowClass=%d srvFollowMask=0x%02x",
                    _rRdmEnsemble.u32GetID(),
                    ETG_CENUM(tenRdmNotifyMode, _enNotifyMode),
                    _bTestMode,
                    _bEnableSrvFollow,
                    _oNotifyWaitTimer.bIsRunning(),
                    _oSrvFollowWaitTimer.bIsRunning(),
                    _bCorrectSrvFollowModeReceived,
                    ETG_CENUM(tenSrvFollowClass, _enSrvFollowClass),
                    _aenSrvFollowModes[(tU8)_enSrvFollowClass]));
}


void dabdrv_rdm::vProcess(trMsgRdmSetNotifyWaitTimeOut*) {
    trMsgDrvRspSetRdmNotifyMode rRsp(_enNotifyMode);
    DAB_vCallMsg(rRsp);
}

void dabdrv_rdm::vProcess(trMsgRdmSetSrvFollowClassWaitTimeOut*) {
    trMsgDrvRspSetDabSrvFollowClass rRsp(_enSrvFollowClass);
    DAB_vCallMsg(rRsp);
}



void dabdrv_rdm::vProcess(trMsgDrvStartComponent*) {
	fc_dabtuner_config *poConfig=fc_dabtuner_config::instance();

    trMeca_CRdmSetDabFrequencyTable oFrequencyTable;
    oFrequencyTable.enFrequencyTable =(tenMeca_RdmFrequencyTable) poConfig->enGetFrequencyTable(); /*enMeca_RdmFrequencyTable_FREQUENCY_TABLE_EUROPE;*/
    dabdrv_mecaIf::instance()->vSendMecaCommand(oFrequencyTable);
    _u8LastSendSrvFollowMode=0;

	/*Send Concealment Level to ADR required for Suzuki as 2, based on road test*/
	trMeca_CAudSetConcealmentLevel rAudSetConcealmentLevel(poConfig->u8GetConcealmentLevel());
	dabdrv_mecaIf::instance()->vSendMecaCommand(rAudSetConcealmentLevel);		
	
    vSetRdmQualityConfig();
    bConfigRdmSrvFollowing();
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
	vSendOneShotServFollowMode();
#endif

    vSetNotifications(_enNotifyMode);
}

tVoid dabdrv_rdm::vProcess(trMsgDrvStopComponent *) {
    _oLastRdmInfo=trMeca_RRdmGetRdmInfo();
    
    _oNotifyWaitTimer.vStop();
    _oSrvFollowWaitTimer.vStop();
}

tVoid dabdrv_rdm::vProcess(trMsgDrvCmdEnableDabSrvFollow *poDrvCmdEnableDabSrvFollow) {
	_bEnableSrvFollow=poDrvCmdEnableDabSrvFollow->bEnable;

	ETG_TRACE_USR4(("dabdrv_rdm::trMsgDrvCmdEnableDabSrvFollow EnableSrvFollow : %d" ,_bEnableSrvFollow));

	if(!bConfigRdmSrvFollowing()){
		DAB_tenServiceLinkingMode e8ServLinkingMode = dabdrv_main::instance()->enGetServiceLinkingMode();
		ETG_TRACE_USR4(("dabdrv_rdm::trMsgDrvCmdEnableDabSrvFollow e8ServLinkingMode : %d" ,e8ServLinkingMode));
		vSetDABFMLinking(e8ServLinkingMode);
	}
}

tVoid dabdrv_rdm::vProcess(trMsgDrvCmdSetDabSrvFollowClass *prMsgSetDabSrvFollowClass ) {
    if (prMsgSetDabSrvFollowClass->enSrvFollowClass >= enSrvFollowClass_Last) {
        return;
    }

    _enSrvFollowClass=prMsgSetDabSrvFollowClass->enSrvFollowClass;
    if (bConfigRdmSrvFollowing()) {
        // meca-command has been sent, start timer to supervise answer from dab-module
        _oSrvFollowWaitTimer.vStart(DAB_RDM_WAIT_SRV_FOLLOW_TIMER_MS);
    } else if (_oSrvFollowWaitTimer.bIsRunning()) {
            // do nothing, still waiting for answer            
    } 
    else if (!_bCorrectSrvFollowModeReceived){
        // force resending of service-follow-mode
        _u8LastSendSrvFollowMode=0xFF;
            // meca-command will always be sent now
        bConfigRdmSrvFollowing();
        //start timer to supervise answer from dab-module
        _oSrvFollowWaitTimer.vStart(DAB_RDM_WAIT_SRV_FOLLOW_TIMER_MS);
    }
    else {
        // settings already ok, direct response
        trMsgDrvRspSetDabSrvFollowClass rRsp(_enSrvFollowClass);
        DAB_vCallMsg(rRsp);  
    }
}

tVoid dabdrv_rdm::vProcess(trMsgDrvCmdConfigDabSrvFollow *prMsgConfigDabSrvFollow ) {
    if (prMsgConfigDabSrvFollow->enSrvFollowClass >= enSrvFollowClass_Last) {
        return;
    }
    if (_aenSrvFollowModes[prMsgConfigDabSrvFollow->enSrvFollowClass] != prMsgConfigDabSrvFollow->u8ServFollowMode) {
        // if value has changed
        _aenSrvFollowModes[prMsgConfigDabSrvFollow->enSrvFollowClass] = prMsgConfigDabSrvFollow->u8ServFollowMode;
        if (_enSrvFollowClass==prMsgConfigDabSrvFollow->enSrvFollowClass) {
            // if the given class is currently activated
            bConfigRdmSrvFollowing();
        }
    }
}

tVoid dabdrv_rdm::vSetRdmQualityConfig() const {

    fc_dabtuner_config *poConfig=fc_dabtuner_config::instance();
    if (OSAL_NULL ==poConfig) {
        return;
    }

	/*Send Quality Config Speed factor required by Suzuki*/
	trMeca_CRdmQualityConfig rQualityConfig;
    rQualityConfig.enMecaQualityConfigCmd = tenMeca_RdmQualityConfigCmd_SET;
    rQualityConfig.u8QualityStrategy = 0x00;
    rQualityConfig.u8DataFieldLen = 2;
    OSAL_pvMemoryCopy(rQualityConfig.au8DataField, (poConfig->pcu8GetRdmQualitySpeedFactor()), rQualityConfig.u8DataFieldLen);

    ETG_TRACE_USR4(("dabdrv_rdm::vSetRdmQualityConfig(trMeca_CRdmQualityConfig) Speed factor : %*p" ,ETG_LIST_LEN(rQualityConfig.u8DataFieldLen),ETG_LIST_PTR_T8(rQualityConfig.au8DataField)));
    dabdrv_mecaIf::instance()->vSendMecaCommand(rQualityConfig);

    trMeca_CRdmQualityConfig rQualityConfig1;
    rQualityConfig1.enMecaQualityConfigCmd = tenMeca_RdmQualityConfigCmd_SET;
    rQualityConfig1.u8QualityStrategy = *poConfig->pcu8GetRdmQualityStrategy();
    rQualityConfig1.u8DataFieldLen = *poConfig->pcu8GetRdmQualityConfigDataLength();
    OSAL_pvMemoryCopy(rQualityConfig1.au8DataField, (poConfig->pcu8GetRdmQualityConfig()), sizeof(rQualityConfig1.au8DataField));

    ETG_TRACE_USR4(("dabdrv_rdm::vSetRdmQualityConfig(trMeca_CRdmQualityConfig) : %*p" ,ETG_LIST_LEN(rQualityConfig1.u8DataFieldLen),ETG_LIST_PTR_T8(rQualityConfig1.au8DataField)));
    dabdrv_mecaIf::instance()->vSendMecaCommand(rQualityConfig1);
}

// returns if meca-command has been sent
tBool dabdrv_rdm::bConfigRdmSrvFollowing() {
	/*Disable only hardlinking when DAB-DAB off is sent from HMI*/
    tU8 u8NewSrvFollowMode;
    ETG_TRACE_USR4(("dabdrv_main::bGetTestModeState %d", dabdrv_main::instance()->bGetTestModeState()));
    if (dabdrv_main::instance()->bGetTestModeState())
    {
        u8NewSrvFollowMode =  _bEnableSrvFollow ? _aenSrvFollowModes[_enSrvFollowClass]:0x00;
    }
    else
    {
//PSARCC30-1055 - u8NewSrvFollowMode set to 0, as it should not go for oneshotmode in case Service follow is off.
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
		u8NewSrvFollowMode =  _bEnableSrvFollow ? _aenSrvFollowModes[_enSrvFollowClass]:0x00;
#else
		u8NewSrvFollowMode =  _bEnableSrvFollow ? _aenSrvFollowModes[_enSrvFollowClass]:0x0b;
#endif
    }

    if((((u8NewSrvFollowMode == 0) || (_u8LastSendSrvFollowMode != u8NewSrvFollowMode))
    		&& dabdrv_main::instance()->bIsAdrUp())) {
        _bCorrectSrvFollowModeReceived=FALSE;
        _u8LastSendSrvFollowMode = u8NewSrvFollowMode;
        trMeca_CRdmServFollowSetMode rSrvFollowSetMode;
        rSrvFollowSetMode.u8ServFollowMode=_u8LastSendSrvFollowMode; 
        dabdrv_mecaIf::instance()->vSendMecaCommand(rSrvFollowSetMode);
        return TRUE;
    }
    return FALSE;
}

tU16 dabdrv_rdm::u16GetTunerStatusFlags() const {
    
    tU16 u16Flags=0;
    u16Flags =0;
    //    DAB_SET_BIT(_bTunerStatusLearn, u16Flags, (tU16)DAB_enTunerStatusFlag__LEARN);
    if (_bTunerStatusLearn) {                                          
        u16Flags = (tU16)(u16Flags & (~(1<<((tU16)DAB_enTunerStatusFlagBitPos_LEARN))));                          
    } else {                                              
        u16Flags |= (1<<((tU16)DAB_enTunerStatusFlagBitPos_LEARN));                          
    }


    u16Flags = (tU16)(u16Flags | _oLastRdmInfo.rRdmStatus.u8Status);

    return  u16Flags;
}

tVoid dabdrv_rdm::vSetNotifications(tenRdmNotifyMode enNotifyMode) {
    if (_bTestMode) {
        if (enNotifyMode == enRdmNotifyMode_Invalid) {
            // leave test-mode and apply old notify-mode
            _bTestMode=FALSE;
            enNotifyMode=_enNotifyMode;
        } else{
            // store new mode and apply it when we leave test-mode
            _enNotifyMode=enNotifyMode;
            trMsgDrvRspSetRdmNotifyMode rRsp(_enNotifyMode);
            DAB_vCallMsg(rRsp);
            return;
        }
    }
    else if (enNotifyMode == enRdmNotifyMode_TestMode) {
        // enter test-mode
        _bTestMode=TRUE;
    }
    else {
        // normal case: jutst apply new test-mode
        _enNotifyMode = enNotifyMode;
    }

    if (!dabdrv_main::instance()->bIsAdrUp()) {
        trMsgDrvRspSetRdmNotifyMode rRsp(_enNotifyMode);
        DAB_vCallMsg(rRsp);
        return;
    }

    trMeca_CRdmSetAutoNotification oAutoNotify;
    oAutoNotify.enNotifyCommand = enMeca_RdmNotifyCommand_SET;
    tU8 u8RdmMask=0;
    tU8 u8DabMask=0;
    tU8 u8AudioMask=0;
    switch(enNotifyMode) {
        case enRdmNotifyMode_Off:
            // do nothing
            break;
        case enRdmNotifyMode_Normal:
            u8RdmMask= (tU8)(enMeca_RdmNotifyMessageMask_GET_DAB_EID) | (tU8)(enMeca_RdmNotifyMessageMask_GET_RDM_INFO)| (tU8)(enMeca_RdmNotifyMessageMask_GET_RDM_STATUS);
            u8AudioMask = (tU8)(enMeca_RdmNotifyMessageMask_GET_AUDIO_STATUS) | (tU8)(enMeca_RdmNotifyMessageMask_GET_AUDIO_SCIDI) | (tU8)(enMeca_RdmNotifyMessageMask_GET_AUDIO_PSID);
            break;
        case enRdmNotifyMode_Learn:
        	u8DabMask=(tU8)(enMeca_RdmNotifyMessageMask_GET_AUDIO_SCIDI);
            u8RdmMask=(tU8)(enMeca_RdmNotifyMessageMask_GET_DAB_EID);
#ifdef DAB_RDM_NOTIFY_INFO_DURING_LEARN
            u8RdmMask|=(tU8)(enMeca_RdmNotifyMessageMask_GET_RDM_INFO);
#endif
            //            u8AudioMask = (tU8)(enMeca_RdmNotifyMessageMask_GET_AUDIO_STATUS) | (tU8)(enMeca_RdmNotifyMessageMask_GET_AUDIO_SCIDI);
            break;
        case enRdmNotifyMode_TestMode:
            u8RdmMask=(tU8)(enMeca_RdmNotifyMessageMask_GET_RDM_INFO);
            u8AudioMask = (tU8)(enMeca_RdmNotifyMessageMask_GET_AUDIO_STATUS) | (tU8)(enMeca_RdmNotifyMessageMask_GET_AUDIO_SCIDI) | (tU8)(enMeca_RdmNotifyMessageMask_GET_AUDIO_PSID);
            break;
        case enRdmNotifyMode_Invalid:
        case enRdmNotifyMode_FreqInfo:
        default:// for lint
            break;
    }

    oAutoNotify.enNotifyClass = enMeca_RdmNotifyClass_DAB;
    oAutoNotify.u8NotifyMask = u8DabMask; 
    dabdrv_mecaIf::instance()->vSendMecaCommand(oAutoNotify);

    oAutoNotify.enNotifyClass = enMeca_RdmNotifyClass_AUDIO;
    oAutoNotify.u8NotifyMask = u8AudioMask;
    dabdrv_mecaIf::instance()->vSendMecaCommand(oAutoNotify);
    _oNotifyWaitTimer.vStart(DAB_RDM_WAIT_NOTIFY_MS);

    oAutoNotify.enNotifyClass = enMeca_RdmNotifyClass_RDM;
    oAutoNotify.u8NotifyMask = u8RdmMask;
    dabdrv_mecaIf::instance()->vSendMecaCommand(oAutoNotify, en_MecaSendMode_WaitAnswer);

}

void dabdrv_rdm::vProcess(trMeca_RRdmSetAutoNotification *poRRdmSetAutoNotification) {
    if (_oNotifyWaitTimer.bIsRunning()) {
        if (poRRdmSetAutoNotification->enNotifyClass==enMeca_RdmNotifyClass_AUDIO) {
            _oNotifyWaitTimer.vStop();
            trMsgDrvRspSetRdmNotifyMode rRsp(_enNotifyMode);
            DAB_vCallMsg(rRsp);
        }
    }
}

tVoid dabdrv_rdm::vProcess(trMeca_RRdmServFollowSetMode *poRRdmServFollowSetMode) {
    ETG_TRACE_USR4(("dabdrv_rdm::vProcess(trMeca_RRdmServFollowSetMode)"));
    if (poRRdmServFollowSetMode->u8ServFollowMode == _u8LastSendSrvFollowMode) {
        _bCorrectSrvFollowModeReceived=TRUE;
        ETG_TRACE_USR4(("dabdrv_rdm::vProcess(trMeca_RRdmServFollowSetMode):received expected answer (%d)",
                        _u8LastSendSrvFollowMode));
        if (_oSrvFollowWaitTimer.bIsRunning()) {
            _oSrvFollowWaitTimer.vStop();
            trMsgDrvRspSetDabSrvFollowClass rRsp(_enSrvFollowClass);
            DAB_vCallMsg(rRsp);            
        }

		fc_dabtuner_config *poConfig=fc_dabtuner_config::instance();
		if (OSAL_NULL ==poConfig) {
			ETG_TRACE_FATAL(("dabdrv_main::vProcess(trMsgSrvCmdSetup) config not available !!!"));
			return;
		}

		DAB_tenServiceLinkingMode e8ServLinkingMode = dabdrv_main::instance()->enGetServiceLinkingMode();
		 ETG_TRACE_USR4(("dabdrv_rdm::vProcess(trMeca_RRdmServFollowSetMode):e8ServLinkingMode (%d) ",
                        e8ServLinkingMode));
        DAB_trSetupStatusProperty oSetupStatus = dabdrv_properties::instance()->oSetupStatusProperty.oGet();		

		if(poRRdmServFollowSetMode->u8ServFollowMode != 0){
			if(e8ServLinkingMode == DAB_enServiceLinkingMode_DAB_FM){
				// enable service following DAB-FM in MTC
				vSetDABFMLinking(e8ServLinkingMode);
			}
			if(e8ServLinkingMode == DAB_enServiceLinkingMode_DAB)
        		oSetupStatus.e8ServiceLinkingMode = DAB_enServiceLinkingMode_DAB; 
				//dabdrv_main::instance()->enSetServiceLinkingMode(oSetupStatus.e8ServiceLinkingMode);				
				dabdrv_properties::instance()->oSetupStatusProperty.vSet(oSetupStatus);
        }
		else{
			if(e8ServLinkingMode == DAB_enServiceLinkingMode_OFF){
				oSetupStatus.e8ServiceLinkingMode = DAB_enServiceLinkingMode_OFF; 
				// disable service following DAB-FM in MTC
				vSetDABFMLinking(e8ServLinkingMode);
			}
			else
			{
				oSetupStatus.e8ServiceLinkingMode = DAB_enServiceLinkingMode_FM;
			}
			//dabdrv_main::instance()->enSetServiceLinkingMode(oSetupStatus.e8ServiceLinkingMode);				
			dabdrv_properties::instance()->oSetupStatusProperty.vSet(oSetupStatus);

		}
    } else {
        ETG_TRACE_USR4(("dabdrv_rdm::vProcess(trMeca_RRdmServFollowSetMode):wrong answer: requested=%d rcv=%d",
                        _u8LastSendSrvFollowMode, poRRdmServFollowSetMode->u8ServFollowMode));        
    }
}

tVoid dabdrv_rdm::vSetDABFMLinking(DAB_tenServiceLinkingMode e8ServLinkingMode,tBool bitValue){

	tU16 u16MTCState = 0;
//PSARCC30-3770
	fc_dabtuner_config *poConfig=fc_dabtuner_config::instance();
#ifndef DABTUNER_UTEST
	dp_tclDABTunerDPMTCMode dpMTC_mode;
if(poConfig->bGetRdsFollowStatus()){
		tU32 status = dpMTC_mode.s32GetData(u16MTCState);
		ETG_TRACE_USR4(("Status : %d",status));
#endif
	if(DAB_bDoSrvLinkingFm(e8ServLinkingMode) && (poConfig->bGetSfDabFmEnable()))
	{
		DAB_SET_BIT_U16(bitValue,u16MTCState,(tU16)0);
	}
	else
	{
		DAB_SET_BIT_U16(!bitValue,u16MTCState,(tU8)0);
	}

#ifndef DABTUNER_UTEST
	}
	dpMTC_mode.s32SetData(u16MTCState);
#endif
	trMsgSrvCmdMtcMode rMsgMtcMode((DAB_tenMtcMode)u16MTCState);
	DAB_vCallMsg(rMsgMtcMode);
}

tVoid dabdrv_rdm::vProcess(trMeca_RRdmLearn* poRRdmLearn) {

	DAB_trTunerStatusProperty oTunerStatus = dabdrv_properties::instance()->oTunerStatusProperty.oGet();
    switch(poRRdmLearn->enLearnCommand) {
        case enMeca_RdmLearnCommand_UPDATE_START:
        case enMeca_RdmLearnCommand_NORMAL_START:
            oTunerStatus.enTunerActivityType = DAB_enTunerActivityType_LEARN;
            _bTunerStatusLearn = TRUE;
            break;
        case enMeca_RdmLearnCommand_NORMAL_STOP:
        case enMeca_RdmLearnCommand_UPDATE_STOP:
			oTunerStatus.enTunerActivityType = DAB_enTunerActivityType_NORMAL;
            _bTunerStatusLearn = FALSE;
            break;
        case enMeca_RdmLearnCommand_INVALID:
        case enMeca_RdmLearnCommand_REJECTED:
        default:
			oTunerStatus.enTunerActivityType = DAB_enTunerActivityType_NORMAL;
            break;
    }
    
    oTunerStatus.u16TunerStatusFlags = u16GetTunerStatusFlags();
    dabdrv_properties::instance()->oTunerStatusProperty.vSet(oTunerStatus);
}

void dabdrv_rdm::vProcess(trMsgDrvCmdSetRdmNotifyMode *poNotifyMode) {
    vSetNotifications(poNotifyMode->enNotifyMode);
}

tVoid dabdrv_rdm::vProcess(trMeca_RRdmGetSignalQuality *poRRdmGetSignalQuality) {
    ETG_TRACE_USR4(("dabdrv_rdm::vProcess(trMeca_RRdmGetSignalQuality):enQualityIndicator=%x",
                    ETG_CENUM(tenMeca_RdmSignalQualityIndicator, poRRdmGetSignalQuality->enQualityIndicator)));
    DAB_trTunerStatusProperty oTunerStatus = dabdrv_properties::instance()->oTunerStatusProperty.oGet();
    // todo use correct type for signalQuality
    oTunerStatus.u8SignalQuality=(tU8)poRRdmGetSignalQuality->enQualityIndicator;
    dabdrv_properties::instance()->oTunerStatusProperty.vSet(oTunerStatus);
}

tVoid dabdrv_rdm::vProcess(trMeca_RRdmGetFrequency *poRRdmGetFrequency) {
    ETG_TRACE_USR4(("dabdrv_rdm::vProcess(trMeca_RRdmGetFrequency):u32Frequency=%d", poRRdmGetFrequency->u32Frequency));
    DAB_trTunerStatusProperty oTunerStatus = dabdrv_properties::instance()->oTunerStatusProperty.oGet();
    oTunerStatus.u32Frequency = poRRdmGetFrequency->u32Frequency;
    dabdrv_properties::instance()->oTunerStatusProperty.vSet(oTunerStatus);
}

tVoid dabdrv_rdm::vProcess(trMeca_RRdmTuneEid *poRRdmTuneEid) {
    ETG_TRACE_USR4(("dabdrv_rdm::vProcess(trMeca_RRdmTuneEid):rEnsemble.eid=0x%08x", poRRdmTuneEid->rEnsemble.u32GetID()));
    DAB_trTunerStatusProperty oTunerStatus = dabdrv_properties::instance()->oTunerStatusProperty.oGet();
    oTunerStatus.u32CurrentEnsembleId = poRRdmTuneEid->rEnsemble.u32GetID();
    dabdrv_properties::instance()->oTunerStatusProperty.vSet(oTunerStatus);
}

tVoid dabdrv_rdm::vProcess(trMeca_RRdmAudioGetScidi *poRRdmAudioGetScidi) {
    ETG_TRACE_USR4(("dabdrv_rdm::vProcess(trMeca_RRdmAudioGetScidi):u16SCIDI=%d", poRRdmAudioGetScidi->u16SCIDI));
    DAB_trTunerStatusProperty oTunerStatus = dabdrv_properties::instance()->oTunerStatusProperty.oGet();
    oTunerStatus.u16CurrentSCIDI = poRRdmAudioGetScidi->u16SCIDI;
    dabdrv_properties::instance()->oTunerStatusProperty.vSet(oTunerStatus);
}

tVoid dabdrv_rdm::vProcess(trMeca_RRdmAudioGetAsid *poRRdmAudioGetAsid) {
    ETG_TRACE_USR4(("dabdrv_rdm::vProcess(trMeca_RRdmAudioGetAsid):rMecaProgrammeService.sid=0x%08x", poRRdmAudioGetAsid->rMecaProgrammeService.u32GetSID()));
    //Once learn is completed sid becomes zero, to avoid that do the NULL check
    if(!poRRdmAudioGetAsid->rMecaProgrammeService.u32GetSID()){
    	_bNewServiceReceived=FALSE;
    	return;
    }
    DAB_trTunerStatusProperty oTunerStatus = dabdrv_properties::instance()->oTunerStatusProperty.oGet();
    oTunerStatus.u32CurrentServiceId = poRRdmAudioGetAsid->rMecaProgrammeService.u32GetSID();
    dabdrv_properties::instance()->oTunerStatusProperty.vSet(oTunerStatus);
	_bNewServiceReceived = TRUE;	
/*	_bServiceChanged=TRUE;

	 ETG_TRACE_USR4(("dabdrv_rdm::vProcess(trMeca_RRdmAudioGetAsid): sid %d scids %d",dabdrv_chnInfo::instance()->rGetChnInfo().rMecaId._u32Id,dabdrv_chnInfo::instance()->rGetChnInfo().u16Scids));
	 ETG_TRACE_USR4(("dabdrv_rdm::vProcess(trMeca_RRdmAudioGetAsid) bispresetrecall:%d",dabdrv_presets::instance()->bIsPresetRecall(poRRdmAudioGetAsid->rMecaProgrammeService.u32GetSID())));
// Fix for SUZUKI-23475	
//vic5kor 23-3-2016 Since trMeca_RRdmAudioGetAsid is not having scids it is taken from chninfo.(to support secondry comp in presets)
//Suzuki MACRO added so that last played service is palyed on source change to DAB during FM-DAB linking
	if (((dabdrv_chnInfo::instance()->rGetChnInfo().u16Scids) == 0
			&& dabdrv_presets::instance()->bIsPresetRecall(poRRdmAudioGetAsid->rMecaProgrammeService.u32GetSID()))
    #ifdef VARIANT_S_FTR_ENABLE_FEATURE_SUZUKI
	    && (dabdrv_presets::instance()->u8GetPresetNumber(trMecaId(poRRdmAudioGetAsid->rMecaProgrammeService._u32Id)))
    #endif
    )
	{
		dabdrv_chnInfo::instance()->vUpdateProperty(poRRdmAudioGetAsid->rMecaProgrammeService ,FALSE);
	}
*/
}

tVoid dabdrv_rdm::vProcess(trMeca_RRdmGetAudioStatus *poRRdmGetAudioStatus) {
    
    ETG_TRACE_USR4(("dabdrv_rdm::vProcess(trMeca_RRdmGetAudioStatus):u16BitRateKbps=%d", poRRdmGetAudioStatus->rAudioStatus.u16BitRateKbps));

    // fill audio-status property-structure
    _rAudioStatus.bDataValid=FALSE;
    _rAudioStatus.enDabMode = poRRdmGetAudioStatus->enRdmMode;
    _rAudioStatus.enDrcMode = poRRdmGetAudioStatus->rAudioStatus.enDrcMode;
    _rAudioStatus.enMusicSpeech = poRRdmGetAudioStatus->rAudioStatus.enMusicSpeech;
    _rAudioStatus.enAudioMode = poRRdmGetAudioStatus->rAudioStatus.enAudioMode;
    _rAudioStatus.enDrcInfo = poRRdmGetAudioStatus->rAudioStatus.enDrcInfo;
    _rAudioStatus.enAlgorithm = poRRdmGetAudioStatus->rAudioStatus.enAlgorithm;
    _rAudioStatus.u16BitRateKbps = poRRdmGetAudioStatus->rAudioStatus.u16BitRateKbps;
    _rAudioStatus.bOriginal = poRRdmGetAudioStatus->rAudioStatus.bOriginal;
    _rAudioStatus.bCopyRight = poRRdmGetAudioStatus->rAudioStatus.bCopyRight; 
    _rAudioStatus.bDataValid = TRUE;
    dabdrv_properties::instance()->oAudioStatusProperty.vSet(_rAudioStatus);
}

tVoid dabdrv_rdm::vNotifyEid(trMecaEnsemble const &rEnsemble) {
    if (_rRdmEnsemble != rEnsemble) {
        _rRdmEnsemble = rEnsemble;
        trMsgDrvRspCurrentEnsemble rMsg(rEnsemble);
        DAB_vCallMsg(rMsg);
    }
}


tVoid dabdrv_rdm::vProcess(trMeca_RRdmGetEid *poRRdmGetEid) {
    ETG_TRACE_USR4(("dabdrv_rdm::vProcess(trMeca_RRdmGetEid)"));
    vNotifyEid(poRRdmGetEid->rEnsemble);
}

tVoid dabdrv_rdm::vProcess(trMeca_RRdmQualityConfig *poRRdmQualityConfig) {
    (tVoid)poRRdmQualityConfig;
    ETG_TRACE_USR4(("dabdrv_rdm::vProcess(trMeca_RRdmQualityConfig)"));

    fc_dabtuner_config *poConfig=fc_dabtuner_config::instance();
	if (OSAL_NULL ==poConfig) {
		ETG_TRACE_FATAL(("dabdrv_main::vProcess(trMeca_RRdmQualityConfig) config not available !!!"));
	}
	else if((tenRDMQualityConfig)poRRdmQualityConfig->u8QualityStrategyCmd==enRDMQualityConfigCmd_OK)
	{
		DAB_trSetupStatusProperty oSetupStatusProperty = dabdrv_properties::instance()->oSetupStatusProperty.oGet();
		oSetupStatusProperty.u8EnsInsertThreshold = (poConfig->pcu8GetRdmQualityConfig()[INDEX_EIGHT] & 0x0F);
		oSetupStatusProperty.u8EnsDeleteThreshold = ((poConfig->pcu8GetRdmQualityConfig()[INDEX_EIGHT] & 0xF0)>>4);
		dabdrv_properties::instance()->oSetupStatusProperty.vSet(oSetupStatusProperty);
		ETG_TRACE_USR1(("dabdrv_main::vProcess(trMeca_RMtcSetConfig) u8EnsInsertThreshold=%d u8EnsDeleteThreshold=%d",
				oSetupStatusProperty.u8EnsInsertThreshold,
				oSetupStatusProperty.u8EnsDeleteThreshold));
	}
}



tVoid dabdrv_rdm::vProcess(trMeca_RRdmGetRdmInfo *poRRdmGetRdmInfo) {
    ETG_TRACE_USR4(("dabdrv_rdm::vProcess(trMeca_RRdmGetRdmInfo enQualityIndicator=%d enAudioQuality=%d)",
        ETG_CENUM(tenMeca_RdmSignalQualityIndicator, poRRdmGetRdmInfo->enQualityIndicator),
        ETG_CENUM(tenMeca_RdmAudioQualityIndicator, poRRdmGetRdmInfo->enAudioQuality)));
    _oLastRdmInfo=*poRRdmGetRdmInfo;
	
	if(poRRdmGetRdmInfo->rEnsemble.u8GetECC() !=0){
		_u8ECC = poRRdmGetRdmInfo->rEnsemble.u8GetECC();
	}
	
    DAB_trTunerStatusProperty oTunerStatus = dabdrv_properties::instance()->oTunerStatusProperty.oGet();
    // todo needs to change when meca is updated (dabmeca_rdm.hpp -> DAB_*_R_RDM_GET_RDM_INFO)
    
    oTunerStatus.u8SignalQuality = (tU8)poRRdmGetRdmInfo->enQualityIndicator;
    oTunerStatus.u8AudioQuality = (tU8)poRRdmGetRdmInfo->enAudioQuality;

    oTunerStatus.u32Frequency = poRRdmGetRdmInfo->u32Frequency;
    oTunerStatus.u16CurrentSCIDI = poRRdmGetRdmInfo->u16SCIDI;
    oTunerStatus.u32CurrentEnsembleId = poRRdmGetRdmInfo->rEnsemble.u32GetID();
    oTunerStatus.u32CurrentServiceId = poRRdmGetRdmInfo->rProgrammeService.u32GetSID();
    oTunerStatus.u16TunerStatusFlags = u16GetTunerStatusFlags();

    // set Freq-label for example "12A"
    OSALUTIL_szSaveStringNCopy(oTunerStatus.sFreqLabel,poRRdmGetRdmInfo->sFrequencyLabel, DABTUN_FREQLABEL_BUFFER);

    dabdrv_properties::instance()->oTunerStatusProperty.vSet(oTunerStatus);
    vNotifyEid(poRRdmGetRdmInfo->rEnsemble);

    //RDmInfo sid should be  compared with ChninfoProperty SID not the _preselectChninfo.sid.
    //Because incase invalid SID is received in Rdminfo, then _rpreselectChninfo will not be updated
    //it will be updated only in chninfo property. ref:PSARCC30-1145
    //and when next time if the update come for the SID which is in _rPreseselectChninfo the updatw will not go properly.
	DAB_trChnInfoProperty rChnInfoProperty=dabdrv_properties::instance()->oChnInfoProperty.oGet();


    ETG_TRACE_USR4(("dabdrv_rdm::trMeca_RRdmGetRdmInfo _bRdmScan=%d sid=0x%08x",_bRdmScan,
    		poRRdmGetRdmInfo->rProgrammeService.u32GetSID()));
    //Fix PSARCCB-9705 Once BAND is switched to DAB still it is updating the old channel info even RDM info gives the new information.
    trMecaId rMecaId(poRRdmGetRdmInfo->rProgrammeService.u32GetSID());
    tBool bUpdateChnl = (rMecaId.bIsValid() && (poRRdmGetRdmInfo->rProgrammeService.u32GetSID()  != rChnInfoProperty.rMecaId._u32Id
    		|| rMecaId != dabdrv_chnInfo::instance()->rGetCurrentSid())
    		&& dabdrv_presets::instance()->bIsPresetRecall(poRRdmGetRdmInfo->rProgrammeService.u32GetSID()));

	ETG_TRACE_USR4(("_bNewServiceReceived outside = %d", _bNewServiceReceived));

	//The update is not required for channle select and preset select it will be updated prior to this
	//This update is required only during SEEK, TUNE_FREQ,TUNE_FREQ_LABEL,TUNE etc.
		if(_bRdmScan || (_bNewServiceReceived && bUpdateChnl))
		{
		#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
			fc_dabtuner_config *poConfig=fc_dabtuner_config::instance();
			if((dabdrv_main::instance()->enGetSourceState()!=DAB_enSourceState_BG || dabdrv_main::instance()->enGetSourceState()!=DAB_enSourceState_FG_ANNO_SURVEILLANCE|| dabdrv_main::instance()->enGetSourceState()!=DAB_enSourceState_DAB_LEARN_FOREVER) && 
				(!poConfig->bGetSfFmDabEnable())) //NCG3D-86195
		#endif
			{
				ETG_TRACE_USR4(("_bNewServiceReceived inside  = %d", _bNewServiceReceived));
				//_bNewServiceReceived, consider the return of bUpdateProperty, if update fails for some reason it tries to update in the next Rdminfo update.
				_bNewServiceReceived = !(dabdrv_chnInfo::instance()->bUpdateProperty(poRRdmGetRdmInfo->rProgrammeService,TRUE)); //TRUE PSARCCB-10300
				_bRdmScan=FALSE;	
			}
		}

		//if received rdminfo and preselect channelinfo are same then no need to update preselct property
		//and reset the _bNewServiceReceived to zero otherwise it may lead to wrong updates.
		if(_bNewServiceReceived){
			_bNewServiceReceived = !(dabdrv_chnInfo::instance()->rGetCurrentSid()== poRRdmGetRdmInfo->rProgrammeService.u32GetSID());
		}
}


tVoid dabdrv_rdm::vProcess(trMeca_RRdmGetDabFrequencyTable *poRRdmGetDabFrequencyTable) {
    ETG_TRACE_USR4(("dabdrv_rdm::vProcess(trMeca_RRdmGetDabFrequencyTable):enFrequencyTable=%x", poRRdmGetDabFrequencyTable->enFrequencyTable));
    
    DAB_trTunerStatusProperty oTunerStatus = dabdrv_properties::instance()->oTunerStatusProperty.oGet();

    tU8 u8FrequencyTableType = poRRdmGetDabFrequencyTable->enFrequencyTable;
    oTunerStatus.enFrequencyTable = (DAB_tenFrequencyTableType)u8FrequencyTableType;
    
    dabdrv_properties::instance()->oTunerStatusProperty.vSet(oTunerStatus);
}

tVoid dabdrv_rdm::vProcess(trMeca_RRdmSetDabFrequencyTable *poRRdmSetDabFrequencyTable) {
    ETG_TRACE_USR4(("dabdrv_rdm::vProcess(trMeca_RRdmSetDabFrequencyTable):enFrequencyTable=%x", poRRdmSetDabFrequencyTable->enFrequencyTable));
    
    DAB_trTunerStatusProperty oTunerStatus = dabdrv_properties::instance()->oTunerStatusProperty.oGet();

    tU8 u8FrequencyTable = poRRdmSetDabFrequencyTable->enFrequencyTable;
    oTunerStatus.enFrequencyTable = (DAB_tenFrequencyTableType)u8FrequencyTable;
    
    dabdrv_properties::instance()->oTunerStatusProperty.vSet(oTunerStatus);
}
tVoid dabdrv_rdm::vProcess(trMsgDrvCmdDabFrequencyTable *poDrvCmdDabFrequencyTable){
	trMeca_CRdmSetDabFrequencyTable oFrequencyTable;
    oFrequencyTable.enFrequencyTable =(tenMeca_RdmFrequencyTable)poDrvCmdDabFrequencyTable->u8FrequencyTable;
    dabdrv_mecaIf::instance()->vSendMecaCommand(oFrequencyTable);
}
tVoid dabdrv_rdm::vProcess(trMeca_RRdmScan *poRRdmScan){
	if(poRRdmScan->enCmd==enMeca_RdmScanState_PLAYING_SERVICE)
		_bRdmScan=TRUE;
	else
		_bRdmScan=FALSE;
		
	ETG_TRACE_USR4(("dabdrv_rdm::trMeca_RRdmScan _bRdmScan=%d",_bRdmScan));

	DAB_trTunerStatusProperty oTunerStatus = dabdrv_properties::instance()->oTunerStatusProperty.oGet();
	trMsgSrvRspScan rSrvRsp;
    switch(poRRdmScan->enCmd) {
			case enMeca_RdmScanState_STARTED:
			case enMeca_RdmScanState_SCANNING_ENSEMBLE:
			case enMeca_RdmScanState_SKIPPING_ENSEMBLE:
			case enMeca_RdmScanState_SEARCHING_ENSEMBLE:
			case enMeca_RdmScanState_PLAYING_SERVICE:
				oTunerStatus.enTunerActivityType = DAB_enTunerActivityType_SCAN;
				rSrvRsp.enRes=DAB_enResult_INPROCESS;
				break;
			case enMeca_RdmScanState_DONE:

				oTunerStatus.enTunerActivityType = DAB_enTunerActivityType_NORMAL;
				_bTunerStatusLearn = FALSE;
				break;
			case enMeca_RdmScanState_ABORT :
				break;
			default:
				oTunerStatus.enTunerActivityType = DAB_enTunerActivityType_INVALID;
				break;
    }
	DAB_vCallMsg(rSrvRsp);
    oTunerStatus.u16TunerStatusFlags = u16GetTunerStatusFlags();
    dabdrv_properties::instance()->oTunerStatusProperty.vSet(oTunerStatus);
}
tVoid dabdrv_rdm::vProcess(trMsgSrvGetTIIList *poSrvCmdGetTIIList){
	 (tVoid)poSrvCmdGetTIIList;
	ETG_TRACE_USR4(("dabdrv_rdm::vProcess(trMsgSrvGetTIIList)"));
	trMeca_CRdmGetCurrTiiList oGetTIIList;   
    dabdrv_mecaIf::instance()->vSendMecaCommand(oGetTIIList);
}
tVoid dabdrv_rdm::vProcess(trMeca_RRdmGetCurrTiiList *poRRdmCurrTiiList){
	ETG_TRACE_USR4(("dabdrv_rdm::trMeca_RRdmGetCurrTiiList numberOfTiiInfos=%d",(tU16)(poRRdmCurrTiiList->lTiiInfos.size())));
	poRRdmCurrTiiList->vTrace();

	trMsgSrvRspGetTIIList rRspGetTIIList;
	rRspGetTIIList.vecTiiList=poRRdmCurrTiiList->lTiiInfos;
	DAB_vCallMsg(rRspGetTIIList);
}
tVoid dabdrv_rdm::vSendOneShotServFollowMode()
{
	trMeca_CRdmServFollowSetOneShotMode cOneShotServFollowMode;
	cOneShotServFollowMode.u8OneShotServFollowMode = ((tU8)enMeca_RdmServFollowMode_ALT_FREQUENCY | (tU8)enMeca_RdmServFollowMode_ALT_HARD_LINKING | (tU8)enMeca_RdmServFollowMode_ALT_ENSEMBLE | (tU8)enMeca_RdmServFollowMode_ALT_SEARCH | (tU8)enMeca_RdmServFollowMode_ALT_STICKYCOMPONENT);
	//Set the flag to 1 suggested by Mike to support Fast frequency switching
	// during the preset select from different ensembles and different sources.
	//ref Tkts: PSARCC30-2718,
	cOneShotServFollowMode.u8b_rfu = 1;
	cOneShotServFollowMode.u16WStartTrigger = 3;
	cOneShotServFollowMode.u16WEndTrigger = 4;
	cOneShotServFollowMode.u16W_rfu = 0;
	dabdrv_mecaIf::instance()->vSendMecaCommand(cOneShotServFollowMode);
}