/************************************************************************
 * FILE:   dabdrv_radioText.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  header of dabdrv_radioText
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/
 
 
#include "dabdrv_radioText.hpp"
#include "dabdrv_main.hpp"
#include "dabdrv_learn.hpp"
#include "dabdrv_chnInfo.hpp"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_DRV_SRV 
#include "trcGenProj/Header/dabdrv_radioText.cpp.trc.h"
#endif


// todo: text-conversion

namespace DAB {
    // a timer-event
    struct dabdrv_msgRadioTextWaitTimeOut:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "  msgRadioTextWaitTimeOut"));
        };
    };

}

using namespace DAB;
dabdrv_radioText::dabdrv_radioText():
    _bChnStable(FALSE),
    _rActiveRadioText(),
    _bFmRTRegistered(FALSE),
    _bSyncStatus(FALSE)
 {
    // commands from dabdrv_main
    vSubscribe<trMsgDrvStartComponent>();
    vSubscribe<trMsgDrvStopComponent>();
    vSubscribe<trMsgDrvFmServiceFollow>();


    vSubscribe<trMsgDrvCmdChnSelectState>();
    vSubscribe<trMsgDrvIndPreChnSelect>();

    vSubscribe<trMsgSrvRspFmRT>();

    vSubscribe<trMeca_RDdmRadioTextCurrent>();
    vSubscribe<trMsgSrvCmdSourceState>();
    vSubscribe<trMeca_RRdmGetRdmInfo>();
    vSubscribe<trMeca_RDdmRadioTextCurrentCmd>();
}


dabdrv_radioText::~dabdrv_radioText() {
}

tVoid dabdrv_radioText::vInit() {
    _oRadioTextWaitTmr.vInit(instance(),dabdrv_msgRadioTextWaitTimeOut());

}

tVoid dabdrv_radioText::vDeInit() {
    _oRadioTextWaitTmr.vDeInit();
}

tVoid dabdrv_radioText::vTraceState() const {
    ETG_TRACE_USR1(("  dabdrv_radioText STATE: _bFmRTRegistered=%d _bChnStable=%d rRadioText.bValid follows:",
                    _bFmRTRegistered,
                    _bChnStable));
    _rActiveRadioText.vTrace();
}

tVoid dabdrv_radioText::vUpdate(tBool bInvalidate) {
    if (bInvalidate) {
        _rActiveRadioText=trRadioText();
    }
    
	//Coverity 16363
	//DAB_vCallMsgCtor(trMsgDrvIndRadioText(_rActiveRadioText));
	trMsgDrvIndRadioText oMsgDrvIndRadioText(_rActiveRadioText);
    DAB_vCallMsg(oMsgDrvIndRadioText);
    
    #ifndef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
        _oRadioTextWaitTmr.vStart(_rActiveRadioText.bValid ? DAB_RADIO_TEXT_WAIT_TIMER_MS : 0);
    #endif
}

tVoid dabdrv_radioText::vProcess(dabdrv_msgRadioTextWaitTimeOut *poWaitTimeOut) {
    (tVoid)poWaitTimeOut;
    vUpdate(TRUE);
}


tVoid dabdrv_radioText::vSubsribeRtCurrent() const {
    ETG_TRACE_USR4(("  dabdrv_radioText::vSubsribeRtCurrent"));
    trMeca_CDdmRadioTextCurrent oRTConfig;
    oRTConfig.enCommand=enMeca_DdmCommand_START;
    oRTConfig.bExtractControlChars=FALSE; //todo: change for RT+?
    oRTConfig.bAutoMode=TRUE;
// NCG3D-38683, PSARCC30-1572 - Activating 	repeat mode for getting the radio text in every 5 secs from ADR.
	oRTConfig.bRepeatMode=TRUE;
    oRTConfig.u8StartPos=0;
    oRTConfig.u8SegmentLength=128;
    dabdrv_mecaIf::instance()->vSendMecaCommand(oRTConfig);
}

tVoid dabdrv_radioText::vUnSubsribeRtCurrent() const {
    ETG_TRACE_USR4(("  dabdrv_radioText::vUnSubsribeRtCurrent"));
    trMeca_CDdmRadioTextCurrent oRTConfig;
    oRTConfig.enCommand=enMeca_DdmCommand_STOP;
    oRTConfig.bExtractControlChars=FALSE; //todo: change for RT+?
    oRTConfig.bAutoMode=TRUE;
	oRTConfig.bRepeatMode=TRUE;
    oRTConfig.u8StartPos=0;
    oRTConfig.u8SegmentLength=128;
    dabdrv_mecaIf::instance()->vSendMecaCommand(oRTConfig);
}

// todo: make rt-reception configurable?
tVoid dabdrv_radioText::vProcess(trMsgDrvStartComponent* StartComponent) {
    (tVoid)StartComponent;
    vSubsribeRtCurrent();
}

// we get informed that dab-module is down
tVoid dabdrv_radioText::vProcess(trMsgDrvStopComponent* StopComponent) {
    (tVoid)StopComponent;
    if (_bChnStable!=FALSE) {
        _bChnStable = FALSE;
        vUpdate(TRUE);
    }
}
tVoid dabdrv_radioText::vProcess(trMsgDrvFmServiceFollow* poFmServiceFollow) {
	//In case of background MtcTunerStaus is FM don't subscribe to FM Radio text.
	//Added Because, when DAB is changed BG, Mtc_TunerStatusFM is received and subscribing FM radio text.
	//But The real source switch not happened in the HMI and as result it shows FM radio text for a moment.
	if(dabdrv_main::instance()->enGetSourceState() == DAB_enSourceState_BG && poFmServiceFollow->bFmSrvFollowActive)
	{
		return;
	}
    tBool bRegister= poFmServiceFollow->bFmSrvFollowActive;
    ETG_TRACE_USR4(("  dabdrv_radioText::vProcess(trMsgDrvFmServiceFollow) bRegister=%d _bFmRTRegistered=%d",
                    bRegister,
                    _bFmRTRegistered));

    trMsgDrvCmdRegisterFmRT rRegisterFmRt(bRegister);
    DAB_vCallMsg(rRegisterFmRt);

	_bFmRTRegistered =bRegister;

    if (!bRegister) {
        vSubsribeRtCurrent();
    }
	else{
        vUnSubsribeRtCurrent();
		trMsgDrvIndRadioTextPlus rRsp;
		DAB_vCallMsg(rRsp);
	}
    vUpdate(TRUE);
}

// an activity changed the channel, invalidate radio-text
tVoid dabdrv_radioText::vProcess(trMsgDrvIndPreChnSelect* poIndPreChnSelect ) {
    (tVoid)poIndPreChnSelect;
    _rActiveRadioText=trRadioText();
    _bChnStable=FALSE;
    // no call of update, radio-text will be reset in chnInfo/compInfo
}

// we get informed if a stable channel is selected by dab-module
tVoid dabdrv_radioText::vProcess(trMsgDrvCmdChnSelectState* poChnSelectState) {
    _bChnStable = (enChnState_Selecting != poChnSelectState->enChnState);
}

tVoid dabdrv_radioText::vProcess(trMsgSrvRspFmRT* poFmRT) {
    if (!_bFmRTRegistered) {
        ETG_TRACE_USR1(("  dabdrv_radioText::vProcess(trMsgSrvRspFmRT) _bFmRTRegistered=FALSE"));
        return;
    }
    // todo: (utf8-)conversion according to char-set
    _rActiveRadioText=poFmRT->rRadioText;
    ETG_TRACE_USR1(("  dabdrv_radioText::vProcess(trMsgSrvRspFmRT) received"));
    vUpdate();
}


tVoid dabdrv_radioText::vProcess(trMeca_RDdmRadioTextCurrentCmd* poRadioTextPlus) {

	ETG_TRACE_USR1(("  dabdrv_radioText::vProcess(trMeca_RDdmRadioTextCurrentCmd)  %d ",
			poRadioTextPlus->enDlCommand ));

	if((poRadioTextPlus->enDlCommand == enMeca_DdlCommand_DLPlus) && (poRadioTextPlus->rDLPlusCH.IRBit) && (_rActiveRadioText.u8RadioTextLen!=0) && (poRadioTextPlus->rDLPlusCH.NumOfTags != 0))
	{
		trMsgDrvIndRadioTextPlus rRsp;

		DAB_FOREACH(vector<trDLPlusTag>, iterTags, poRadioTextPlus->lDLPlusTag)
		{
			ETG_TRACE_USR1(("  dabdrv_radioText::vProcess(trMeca_RDdmRadioTextCurrentCmd) u8ContentType = %d ",iterTags->u8ContentType));

			if((iterTags->u8ContentType != enDLPlusContentType_Dummy) &&
			  (iterTags->u8LengthMarker <= _rActiveRadioText.u8RadioTextLen) &&
			  (iterTags->u8StartMarker < _rActiveRadioText.u8RadioTextLen))
			{
				trRTPlusInfo oRTPlusListElem;
				oRTPlusListElem.sContent.u8RadioTextLen = iterTags->u8LengthMarker;
				oRTPlusListElem.u8ContentType = iterTags->u8ContentType;

				ETG_TRACE_USR1(("  dabdrv_radioText::vProcess(trMeca_RDdmRadioTextCurrentCmd) u8ContentType = %d u8RadioTextLen=%d ",oRTPlusListElem.u8ContentType, oRTPlusListElem.sContent.u8RadioTextLen));

				tString cDLPContent=(tString) OSAL_pvMemoryAllocate(oRTPlusListElem.sContent.u8RadioTextLen);
				string content_text = ((string)_rActiveRadioText.sRadioText).substr(iterTags->u8StartMarker,iterTags->u8LengthMarker);

				if(cDLPContent != NULL)
				{
					(tVoid)OSAL_pvMemoryCopy(cDLPContent, content_text.c_str(), content_text.length());
				}

				OSAL_s32PrintFormat(oRTPlusListElem.sContent.sRadioText, "%s", cDLPContent);
				OSAL_vMemoryFree(cDLPContent);

				oRTPlusListElem.sContent.bValid = TRUE;
				ETG_TRACE_USR1(("  dabdrv_radioText::vProcess(trMeca_RDdmRadioTextCurrentCmd) sContent = %s ",oRTPlusListElem.sContent.sRadioText));

				rRsp.vRDTextPlus.push_back(oRTPlusListElem);
			}
		}
		DAB_vCallMsg(rRsp);
	}

}

tVoid dabdrv_radioText::vProcess(trMeca_RDdmRadioTextCurrent* poRadioText) {

    ETG_TRACE_USR1(("  dabdrv_radioText::vProcess(trMeca_RDdmRadioTextCurrent) %d enCharSet=%x poRadioText->u8Length = %d _bFmRTRegistered %d",
        poRadioText->u8RadioTextSegment[0],
        ETG_CENUM(tenMeca_CharSet, poRadioText->enCharSet),
		poRadioText->u8Length,_bFmRTRegistered));

    if (poRadioText->u8Length > 128 || _bFmRTRegistered) {
        return;
    }

    /*if (!_bChnStable) {
        return;
    }*/

    if ( poRadioText->u8Length > 0 ) {
    _rActiveRadioText.u8RadioTextLen=poRadioText->u8Length;
    _rActiveRadioText.bValid=TRUE;
        _rActiveRadioText.enMeca_CharSet = poRadioText->enCharSet;
        if (poRadioText->enCharSet == enMeca_CharSet_ISO_UCS_2) {        
            DAB_stringUtil::u32ConvertUnicodeStringToUtf8((const tChar*)poRadioText->u8RadioTextSegment, (poRadioText->u8Length),(tU8*)_rActiveRadioText.sRadioText, DABTUN_RADIOTEXT_BUFFER-1);
            _rActiveRadioText.enMeca_CharSet = enMeca_CharSet_ISO_UTF_8;
        }
        else {
    (tVoid)OSAL_pvMemoryCopy(_rActiveRadioText.sRadioText, poRadioText->u8RadioTextSegment, poRadioText->u8Length);
    
    _rActiveRadioText.sRadioText[poRadioText->u8Length]=0;
        }
    ETG_TRACE_USR1(("  dabdrv_radioText::vProcess(trMeca_RDdmRadioTextCurrent) enCharSet=%x textLen:%d Radiotext: %17s",
                          ETG_CENUM(tenMeca_CharSet, _rActiveRadioText.enMeca_CharSet),
                          _rActiveRadioText.u8RadioTextLen,
                      _rActiveRadioText.sRadioText)); 
	vUpdate();
    }
	else {  //if RT from ADR is empty , then Empty RT should be updated to HMI. PSARCC-3215
	vUpdate(TRUE);
	}
}

tVoid dabdrv_radioText::vProcess(trMsgSrvCmdSourceState *poSourceState) {
    if (/*!fc_dabtuner_config::instance()->bGetSfFmDabEnable()
    		&&*/ poSourceState->enSourceState == DAB_enSourceState_BG) {
        vUnSubsribeRtCurrent();
        //vUpdate(TRUE);
    }
    else if (poSourceState->enSourceState == DAB_enSourceState_FG) {
        vSubsribeRtCurrent();

    }
    if((poSourceState->enSourceState != DAB_enSourceState_DAB_LEARN_FOREVER) && (poSourceState->enSourceState !=DAB_enSourceState_DAB_BG_LEARN_FOREVER))
    {
	vUpdate(TRUE);
    }
}

tVoid dabdrv_radioText::vProcess(trMeca_RRdmGetRdmInfo *poRRdmGetRdmInfo) {
    tBool bSyncStatus = DAB_BOOL_FROM_BIT(poRRdmGetRdmInfo->rRdmStatus.u8Status, (tU8)enRdmStatusBits_SYNC)?1:0;

    if (bSyncStatus == _bSyncStatus) {
        return;
    }
    _bSyncStatus = bSyncStatus;
	
	//For IVI, PSA, radio text shouldnot be cleared immediately after signal loss
	if (!_bSyncStatus && !_bFmRTRegistered) {
		_oRadioTextWaitTmr.vStart(DAB_RADIO_TEXT_WAIT_TIMER_MS);
	}
	else
	{
		if(_oRadioTextWaitTmr.bValid())
			_oRadioTextWaitTmr.vStop();
	}

	// /*PSA doesnt need clearing of radio text immediately after signal loss*/
	// #ifndef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
	// //Radio text not to be cleared during DAB-FM linking
    // if (!_bSyncStatus && !_bFmRTRegistered) {
        // vUpdate(TRUE);
    // }
	// //PSARCC30-3339 - Radio text to be cleared when signals go unavailable and come back.
	// #else
	// if (!_bSyncStatus)
	// {
		// _oRadioTextWaitTmr.vStart(DAB_RADIO_TEXT_WAIT_TIMER_MS);
	// }
	// else
	// {
		// if(_oRadioTextWaitTmr.bValid())
			// _oRadioTextWaitTmr.vStop();
	// }
	// #endif
}
