/************************************************************************
 * FILE:    dabdrv_presets.hpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  header of dabdrv_presets
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#ifndef DABDRV_PRESETS_HPP
#define DABDRV_PRESETS_HPP
/*
mirror preset-list of adr3
provide auto-compare by psid

todo: can preset be changed in frozenChnList: no!

*/
#include "fc_dabtuner_util.h"
#include "dabdrv_types.hpp"
#include "dabdrv_main.hpp"
#include "dabdrv_learn.hpp"
#include "dabdrv_advisory.hpp"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_DRV_PRESETS 
#include "trcGenProj/Header/dabdrv_presets.hpp.trc.h"
#endif

namespace DAB {
    struct trMsgPresetStoreSupervisionTimer;

    struct trActivePreset {
        trActivePreset():
            u8PresetNr(0),
            u32Frequency(0)
        {}

        tU8 u8PresetNr;
        trMecaProgrammeService rPsid;
        tU32 u32Frequency;

        // persistant data serialization
        tVoid vSerialize(DAB_Serializer &rSerializer) const {
            rSerializer.vSerialize(u8PresetNr);
            rSerializer.vSerialize(rPsid);
            rSerializer.vSerialize(u32Frequency);
        }
        
        tVoid vParse(DAB_Parser &rParser) {
            rParser.vParse(u8PresetNr);
            rParser.vParse(rPsid);
            rParser.vParse(u32Frequency);
        }

    };
    struct trPresetsUsrData {
        trPresetsUsrData():
            rActivePreset()
        {}
        trActivePreset rActivePreset;

        // persistant data serialization
        tVoid vSerialize(DAB_Serializer &rSerializer) const {
            rSerializer.vSerialize(rActivePreset);
        }
        
        tVoid vParse(DAB_Parser &rParser) {
            rParser.vParse(rActivePreset);
        }

        tVoid vTrace() {
            ETG_TRACE_USR4(("  trPresetsUsrData:u8PresetNr=%d rPsid=%d u32Frequency=%d",
                            rActivePreset.u8PresetNr,
                            rActivePreset.rPsid.u32GetSID(),
                            rActivePreset.u32Frequency));
        }
    };

class dabdrv_presets:
    public DAB_Singleton <dabdrv_presets>,
    public DAB_MessageHandlerCommon<dabdrv_presets>
{
    friend class DAB_Singleton<dabdrv_presets>;

public:
    DAB_TRACE_INFO_IMPL(FC_DABTUNER_TR_DRV_PRESETS);
    virtual tVoid vInit();
    virtual tVoid vDeInit();
    virtual char const *pcGetName() const {return "dabdrv_presets";};
    virtual tVoid vTraceState() const;

    virtual tVoid vProcess(trMsgPresetStoreSupervisionTimer *poStoreSupervisionTimer);
    virtual tVoid vProcess(trMsgDrvStartComponent* poStart);
    
    virtual tVoid vProcess(trMsgDrvIndPreChnSelect* poDrvIndPreChnSelect);

    // commands from server
    virtual tVoid vProcess(trMsgSrvCmdStorePreset* poStorePreset);  // async result
    virtual tVoid vProcess(trMsgSrvCmdRecallPreset* poRecallPreset); // syncronous result
    virtual tVoid vProcess(trMsgSrvCmdSetPresetBank* poSetPresetBank);
    virtual tVoid vProcess(trMsgSrvCmdGetPresetList* poGetPresetList);
	virtual tVoid vProcess(trMsgSrvCmdAutoStore* poAutostore);

#ifndef VARIANT_S_FTR_ENABLE_FEATURE_SUZUKI //multi-user preset
	virtual tVoid vProcess(trMsgSrvCmdSetUser* povSetUser);
	virtual tVoid vProcess(trMeca_RRdmStationTravelStore* poTravelStore);
	virtual tVoid vProcess(DAB::trMsgSrvCmdDiagStatus* poDiagStatus);
	virtual tVoid vProcess(DAB::trMeca_RRdmStationSetUser* poRRdmSetUser);
#endif
    virtual tVoid vProcess(trMsgSrvCmdClearPresets* poClearPreset);

    // responses from adr3
    virtual tVoid vProcess(trMeca_RRdmStationSetPresetStation* poRRdmSetPresetStation);
    virtual tVoid vProcess(trMeca_RRdmStationStore* poRRdmStationStore);
    virtual tVoid vProcess(trMeca_RRdmStationPlay* poRRdmStationPlay);
    virtual tVoid vProcess(trMeca_RDbQuery* poRDbQuery);
	virtual tVoid vProcess(trMsgSrvSavePresetList* poSavePresetList);

    tVoid vGetUserData(trPresetsUsrData *rPresetsUsrData) const;
    tVoid vSetUserData(trPresetsUsrData const &rPresetsUsrData);

	tU8 u8GetAutoStoreType() const	{return _enAutoStoreType;};
	tVoid vSetAutoStoreType(tenAutostoreType AutoStoreType){_enAutoStoreType = AutoStoreType;};
	tVoid vPLayLSM(tU8 u8Options);
	tBool bIsPresetRecall(tU32 sid);
    tU8 u8GetPresetNumber(trMecaId const &rPSID,tU8 u8Scids=0);
    trMecaLabel rGetPresetLabel(tU8 u8PresetNr) const;
    tU8 bIsPresetInBank(tU8 u8PresetNr) const;
    tVoid vSendRecallPreset(tU8 u8PresetNumber,tU8 u8OptionVal=0) const;
    tBool bStorePresettoLSM(tU8 u8PresetNr);
	tVoid vSetPreset(tU8 u8PresetNr,trPresetInfo &rPrstInfo)const;
	tVoid vResetSelectSource()
	{
		ETG_TRACE_USR1(("in vResetSelectSource"));
		_enChnSelectSource = enChnSelectSource_None;
	}

	tVoid vUpdateUnavailablePresetInfo(trMeca_RRdmAudioPlayAsid* poMecaRRdmPlayPsid);
	tU8 _u8PresetDeleteCounter;
	tVoid vAutoStoreResponse();
	tVoid vUpdatePresetInfo(trPresetInfo& rRcvPreset,DAB_trPresetListProperty& rProperty,tBool bDoSysStore=FALSE);
	tVoid vUpdatePresetProperty(trPresetInfo& rRcvPreset,tU8 u8StationNumber, tBool bUpdate,DAB_trPresetListProperty& rProperty);
	tBool vGetPresetValidity(tU8 uPresetNumber);
	tVoid vSendSpecialPresetSave(trMsgSrvCmdStorePreset* poStorePreset);
	tVoid vMovePresetToLSM(trMsgSrvCmdStorePreset* poStorePreset);
	tVoid vSendSetPresetStation(trMsgSrvCmdStorePreset* poStorePreset);
	tVoid vSendServiceInfo(trMecaProgrammeService mecaPrgService);
	tU8  u8GetRecalledPresetinBG(){return _u8PresetRecalledFromBG;};
	tVoid vResetRecallPresetFromBG(){_u8PresetRecalledFromBG=0;};

	tU8 u8GetUserId(){return u8UserId;}

#ifdef DABTUNER_UTEST
public:
	    dabdrv_presets();
#else
private:
	    dabdrv_presets();
#endif

private:

    typedef set<tU8> tPresetNrSet;
    tBool bPresetNumberValid(tU16 u16PresetNumber) const;
    tVoid vFinalizeStorePreset(tU8 u8StationNumber, tenMeca_RdmStationState enStationState);
    tVoid vOnPresetListQueryResponse(trMeca_RDbQuery* poRDbQuery,DAB_trPresetListProperty& rProperty);
    tVoid vExtractPresetInfo(trMeca_RDbQuery* poRDbQuery,vector<trPresetInfo>& vecPresetListInfo);
    tVoid vPrepareVectorPresetList(tU8 rowCount,vector<trPresetInfo>& vecPresetListInfo,tU8* pu8Data,tU32 u32DataLength);
    tVoid vUpdateAllPresetList(vector<trPresetInfo>& vecPresetListInfo,DAB_trPresetListProperty& rProperty);
    tBool bIsPresetRecalledFromBG(tU8 u8PresetNr);
    trMeca_CRdmStationSetPresetStation vSendSetPresetStationList(tU8 u8vecPresetInfosIndex);
#ifndef VARIANT_S_FTR_ENABLE_FEATURE_SUZUKI //multi-user preset
    trMeca_CRdmStationSetUser vSendMecaCmdSetUser(tU8 _u8UserId);
    trMeca_CRdmStationTravelStore vSendMeaCommandDeleteProfile(tU8 _u8UserId);
    trMeca_CRdmStationTravelStore vSendMeaCommandCopyProfile(tU8 sourcdUserId, tU8 destUserId);
#endif
    vector<trPresetInfo>_vPresetInfos;
    map<trMecaProgrammeService,set<tU8> > _mapPresetsByPSID;
	multimap<tU8, trPresetInfo,greater<tU8> >_mapASTListByQuality;
    // the current preset-bank. by now only one preset bank is tested
    tU8 _u8PresetBank;
    // supervision of response from DAB-Module on Cmd StorePreset
    DAB_tclTimer _oPresetStoreSuperVisionTimer;
    tU8 _u8ActiveRecallPreset;
    trPresetsUsrData _rPersUsrData;
    tU8 _u8ActiveStorePreset;
    tenChnSelectSource _enChnSelectSource;
	tenAutostoreType _enAutoStoreType;
	DAB_tenBankList  _enBankType;
	DAB_tenPresetListDeleteAction _enDeleteAction;
	tenDiagAction _enDiagAction;
	DAB_trPresetListProperty _rProperty;
	tenPresetListToHMIStatus _enPresetListToHMIStatus;
    tU8 u8NumberofPresets;
    tU8 u8NumberofPresetsPerBank;
    tU8 _u8PresetRecalledFromBG;
	tBool _bStartup;
	tU8 u8UserId;
	tU8 u8DestUserId;
	tU8 u8UserUpdate;
	tU8 u8Index;
    vector<trPresetInfo> vecPresetInfo;
};

}
#endif
