/************************************************************************
 * FILE:    dabdrv_persData.hpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  header of dabdrv_persData
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/
 
#ifndef DABDRV_PERS_DATA_H
#define DABDRV_PERS_DATA_H


#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"

#include "fc_dabtuner_util.h"

namespace DAB {

const tU8      cu8DataFileVersion = 1;
    const tU32 DAB_cPersDataMagic=0x12345608;

struct trCompPersData {
    virtual ~trCompPersData() {};
    virtual tVoid vSet()=0;
    virtual tVoid vGet()=0;
    virtual tVoid vGetDefault()=0;
    virtual tVoid vTrace()=0;
    virtual tVoid vParse(DAB_Parser &rParser)=0;
    virtual tVoid vSerialize(DAB_Serializer &rSerializer)=0;
};

template<class C, class M>
struct trCompMachineData: 
public trCompPersData
{

    virtual tVoid vSet() {
        C::instance()->vSetMachineData(rData);
    }
    virtual tVoid vGet() {
        C::instance()->vGetMachineData(&rData);
    }
    virtual tVoid vGetDefault() {
        rData=M();
    }
    virtual tVoid vTrace() {
        rData.vTrace();
    }

    virtual tVoid vParse(DAB_Parser &rParser) {
        rParser.vParse(rData);
    }
    virtual tVoid vSerialize(DAB_Serializer &rSerializer) {
        rSerializer.vSerialize(rData);
    }

    trCompMachineData():
        rData()
    {};
    M rData;

};

template<class C, class M>
struct trCompUserData: 
public trCompPersData
{

    virtual tVoid vSet() {
        C::instance()->vSetUserData(rData);
    }
    virtual tVoid vGet() {
        C::instance()->vGetUserData(&rData);
    }
    virtual tVoid vGetDefault() {
        rData=M();

    }
    virtual tVoid vTrace() {
        rData.vTrace();
    }

    virtual tVoid vParse(DAB_Parser &rParser) {
        rParser.vParse(rData);
    }
    virtual tVoid vSerialize(DAB_Serializer &rSerializer) {
        rSerializer.vSerialize(rData);
    }

    trCompUserData():
        rData()
    {};
    M rData;
};

class dabdrv_persData : 
    public ahl_tclBaseConfigStore,
    public DAB_Singleton <dabdrv_persData>,
    public DAB_MessageHandlerCommon<dabdrv_persData>
{
        friend class DAB_Singleton<dabdrv_persData>;

public:
    DAB_TRACE_INFO_IMPL(FC_DABTUNER_TR_DRV_PERSDAT);

    dabdrv_persData();

    virtual ~dabdrv_persData();

    virtual tVoid vInit();
    virtual tVoid vDeInit();

    virtual char const *pcGetName() const {return "dabdrv_persData";};

    static tU8 u8GetVerMin();
    virtual tVoid vProcess(trMsgSrvCmdStorePersData* pSrvCmdStorePersData);

      // -------------------------------
      // ---   Diagnosis interface   ---
      
      tVoid vSetDefaultSettings(tBool bResetAllUsers);

      // -------------------------------------
      // ---   Property Access Functions   ---
      
      // -------------------------------------------------------
      // ----------------------------------
      // ---   Data storage functions   ---

      tVoid vLoadData();

      tVoid vSaveData();

      virtual tVoid vSetMachineData(tPCU8 pcu8Buf, tU32 u32Length);

	   virtual tVoid vGetMachineData( tPCU8 &rpcu8Buf,  tU32 &ru32Length);
	   virtual tVoid vGetMachineDefaultData(tPCU8 &rpcu8Buf, tU32 &ru32Length);

	   virtual tVoid vSetUserData(tPCU8 pcu8Buf, tU32 u32Length);

      virtual tVoid vGetUserData(tPCU8 &rpcu8Buf, tU32 &ru32Length);

      virtual tVoid vGetUserDefaultData(tPCU8 &rpcu8Buf, tU32 &ru32Length);


private:
    virtual tVoid vGetMachineData_(DAB_Serializer &rSerializer, tBool bGetDefault);
    virtual tVoid vGetUserData_(DAB_Serializer &rSerializer, tBool bGetDefault);


};
}

#endif


