/************************************************************************
 * FILE:    dabdrv_persData.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  header of dabdrv_persData
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/
// System includes
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"   
   // implicitly links osal_if.h

// link Application Help Library
#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         

// dab includes
#include "fc_dabtuner_util.h"
#include "dabdrv_main.hpp"
#include "dabdrv_persData.hpp"

// headers of objects with persistant data
#include "dabdrv_chnInfo.hpp"
#include "dabdrv_compInfo.hpp"
#include "dabdrv_chnList.hpp"
#include "dabdrv_presets.hpp"
#include "fc_dabtuner_config.hpp"



#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_DRV_PERSDAT 
#include "trcGenProj/Header/dabdrv_persData.cpp.trc.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
    #define DAB_FFS_DIR "/dev/ffs2/persistent/"
#else
    #define DAB_FFS_DIR "/dev/ffs/"
#endif
#define DAB_LMM_DIR "dab"
tCString cszDabDataFileName      = DAB_FFS_DIR DAB_LMM_DIR "/" "lmm_";

using namespace DAB;

struct trUserConfig {     
    trCompUserData<dabdrv_presets, trPresetsUsrData> rPresetsUsrData;
    trCompUserData<dabdrv_main, trMainUsrData> rMainUsrData;
    trCompUserData<dabdrv_chnInfo, trChnInfoUsrData> rChnInfoUsrData;
    trCompUserData<dabdrv_compInfo, trCompInfoUsrData> rCompInfoUsrData;
    trUserConfig() {
         _vMembers.push_back(&rPresetsUsrData);
         _vMembers.push_back(&rMainUsrData);
         _vMembers.push_back(&rChnInfoUsrData);
         _vMembers.push_back(&rCompInfoUsrData);
    }
    vector<trCompPersData *> _vMembers;
};


struct trMachineConfig {
    trCompMachineData<dabdrv_chnList, dabdrv_chnList::trChnListMachineData> rChnListMachineData;
    vector<trCompPersData *> _vMembers;
    trMachineConfig() {
        _vMembers.push_back(&rChnListMachineData);
    }

};


const tU16    cu16DataFileVersionMaj   = 5;
const tU8     cu8DataFileVersionMin    = 2;

static DAB_Serializer rMachineSerializer;
static DAB_Serializer rMachineDefaultSerializer;
static DAB_Serializer rUserSerializer;
static DAB_Serializer rUserDefaultSerializer;

static tVoid vClearStaticData() {
    rMachineSerializer=DAB_Serializer();
    rMachineDefaultSerializer=DAB_Serializer();
    rUserSerializer=DAB_Serializer();
    rUserDefaultSerializer=DAB_Serializer();
}
// ****************************************************************************




// ****************************************************************************
// ***			C l a s s   I n t e r f a c e   F u n c t i o n s				 ***
// ****************************************************************************

dabdrv_persData::dabdrv_persData():
    ahl_tclBaseConfigStore(cszDabDataFileName, 
                           cu16DataFileVersionMaj, 
                           cu8DataFileVersionMin)
{};

// ****************************************************************************

dabdrv_persData::~dabdrv_persData()
{
};

tU8 dabdrv_persData::u8GetVerMin() {
    return cu8DataFileVersionMin;
}
// ****************************************************************************

tVoid  dabdrv_persData::vInit()
{
    ETG_TRACE_USR4(("dabdrv_persData: vInit"));

    OSAL_trIOCtrlDir *prDir=OSALUTIL_prOpenDir(DAB_FFS_DIR DAB_LMM_DIR);
    if (OSAL_NULL == prDir) {
        prDir=OSALUTIL_prOpenDir(DAB_FFS_DIR);
        if (OSAL_NULL != prDir) {
            tS32 s32OsalRes = OSALUTIL_s32CreateDir(prDir->fd, 
                                                    DAB_LMM_DIR);
            if (OSAL_ERROR == s32OsalRes) {
                ETG_TRACE_ERR(("dabdrv_persData::vInit:could not create dir %s",
                               DAB_LMM_DIR));
            }
            
        }
    }
    if (OSAL_NULL != prDir) {
        OSALUTIL_s32CloseDir(prDir);
    }


    vLoadData();
    vClearStaticData();
    vSubscribe<trMsgSrvCmdStorePersData>();
};

tVoid  dabdrv_persData::vDeInit()
   // free ressources
{
};

tVoid dabdrv_persData::vProcess(trMsgSrvCmdStorePersData* pSrvCmdStorePersData) {
    (tVoid)pSrvCmdStorePersData;
    vSaveData();
}

// ****************************************************************************

tVoid  dabdrv_persData::vSetDefaultSettings(tBool bResetAllUsers)
{
    ETG_TRACE_USR4(("dabdrv_persData: vSetDefaultSettings START"));

   vRemoveMachineData();
   if (bResetAllUsers)
   {
       ETG_TRACE_USR1(("vSetDefaultSettings:removing all user data"));
      vRemoveAllUserData();
   }
   else
   {
       ETG_TRACE_USR1(("vSetDefaultSettings:removing current user data"));
      vRemoveUserData();
   }

   if (DAB_GET_CONFIG().bDabEnable) {

       // reload
       ETG_TRACE_USR1(("vSetDefaultSettings:reloading data"));
       vLoadData();
       
       ETG_TRACE_USR1(("vSetDefaultSettings:saving data"));
       
       vSaveData();
       vClearStaticData();
       
       ETG_TRACE_USR4(("dabdrv_persData: vSetDefaultSettings DONE"));
   }


};



// ****************************************************************************

tVoid  dabdrv_persData::vLoadData()
{
    ETG_TRACE_USR4(("dabdrv_persData: vLoadData"));

      vLoadMachineData();
      vLoadUserData();
};

// ****************************************************************************

tVoid  dabdrv_persData::vSaveData()
{
    ETG_TRACE_USR4(("dabdrv_persData: vSaveData"));

    // Write data into file
    vStoreMachineData();
    vStoreUserData();
};


// ****************************************************************************


// ****************************************************************************


// ****************************************************************************

tVoid  dabdrv_persData::vSetMachineData( tPCU8 pcu8Buf,  tU32 u32Length)
{
    ETG_TRACE_USR4(("dabdrv_persData: vSetMachineData pcu8Buf=%p u32Length=%d START",
                    pcu8Buf,u32Length));
    if (!DAB_GET_CONFIG().bDabEnable || OSAL_NULL == pcu8Buf) {
        ETG_TRACE_COMP(("dabdrv_persData: DAB Disabled"));
        return;
    }

    DAB_Parser rParser(cu16DataFileVersionMaj, cu8DataFileVersionMin);
    if (!rParser.bRead(pcu8Buf, u32Length)) {
        ETG_TRACE_COMP(("dabdrv_persData: Invalid MachineData"));
        // todo: apply default data?
        return;
    }

    // only copy the data-part, otherwise we overwrite the vtable
    trMachineConfig DAB_rMachineConfig;

    DAB_FOREACH(vector<trCompPersData *>,cfgIter,DAB_rMachineConfig._vMembers) {
        (*cfgIter)->vParse(rParser);
        if (rParser.bHasError()) {
            ETG_TRACE_COMP(("dabdrv_persData: Could not parse MachineData"));
            // todo: apply default data?
            return;
        }
    }

    DAB_FOREACH(vector<trCompPersData *>,cfgIter2,DAB_rMachineConfig._vMembers) {
        (*cfgIter2)->vTrace();
        (*cfgIter2)->vSet();
    }

    ETG_TRACE_USR4(("dabdrv_persData: vSetMachineData END"));
}

// ****************************************************************************

tVoid  dabdrv_persData::vGetMachineData_(DAB_Serializer &rSerializer, tBool bGetDefault)
{
    ETG_TRACE_USR4(("dabdrv_persData: vGetMachineData_ START"));
    trMachineConfig rMachineConfig;
    rSerializer=DAB_Serializer(cu16DataFileVersionMaj, cu8DataFileVersionMin);
    DAB_FOREACH(vector<trCompPersData *>,cfgIter,rMachineConfig._vMembers) {
        if (DAB_GET_CONFIG().bDabEnable && !bGetDefault) {
            (*cfgIter)->vGet();
        }
        (*cfgIter)->vSerialize(rSerializer);
        (*cfgIter)->vTrace();
    }


   ETG_TRACE_USR4(("dabdrv_persData: vGetMachineData_ END"));

}

tVoid  dabdrv_persData::vGetMachineData(tPCU8 &rpcu8Buf, tU32  &ru32Length)
{

    ETG_TRACE_USR4(("dabdrv_persData: vGetMachineData START"));
    vGetMachineData_(rMachineSerializer, FALSE);
    rpcu8Buf = rMachineSerializer.pu8GetData();
    ru32Length =rMachineSerializer.u32GetLen();
    ETG_TRACE_USR4(("dabdrv_persData: vGetMachineData END rpcu8Buf=%p ru32Length=%d",
                    rpcu8Buf,ru32Length));
}

// ****************************************************************************

tVoid  dabdrv_persData::vGetMachineDefaultData(tPCU8& rpcu8Buf, tU32&  ru32Length)
{

    ETG_TRACE_USR4(("dabdrv_persData: vGetMachineDefaultData START"));

    vGetMachineData_(rMachineDefaultSerializer, TRUE);
    rpcu8Buf = rMachineDefaultSerializer.pu8GetData();
    ru32Length =rMachineDefaultSerializer.u32GetLen();

    ETG_TRACE_USR4(("dabdrv_persData: vGetMachineDefaultData END rpcu8Buf=%p ru32Length=%d",
                    rpcu8Buf,ru32Length));
}

// ****************************************************************************

tVoid  dabdrv_persData::vSetUserData(tPCU8 pcu8Buf, tU32 u32Length)
{
    ETG_TRACE_USR1(("dabdrv_persData::vSetUserData START pcu8Buf=%p u32Length=%d",
                    pcu8Buf, u32Length));
    if (!DAB_GET_CONFIG().bDabEnable || OSAL_NULL == pcu8Buf) {
        ETG_TRACE_COMP(("dabdrv_persData: DAB Disabled"));
        return;
    }

    DAB_Parser rParser(cu16DataFileVersionMaj, cu8DataFileVersionMin);
    if (!rParser.bRead(pcu8Buf, u32Length)) {
        ETG_TRACE_COMP(("dabdrv_persData: Invalid UserData"));
        // todo: apply default data?
        return;
    }
    // parse config-data
    trUserConfig DAB_rUsrConfig;

    DAB_FOREACH(vector<trCompPersData *>,cfgIter,DAB_rUsrConfig._vMembers) {
        (*cfgIter)->vParse(rParser);
        if (rParser.bHasError()) {
            ETG_TRACE_COMP(("dabdrv_persData: Could not parse UserData"));
        // todo: apply default data?
            return;
        }    
    }

    // apply config-data
    DAB_FOREACH(vector<trCompPersData *>,cfgIter2,DAB_rUsrConfig._vMembers) {
        (*cfgIter2)->vTrace();
        (*cfgIter2)->vSet();
    }

    ETG_TRACE_USR1(("dabdrv_persData::vSetUserData END"));

}

// ****************************************************************************

tVoid  dabdrv_persData::vGetUserData_(DAB_Serializer &rSerializer, tBool bGetDefault)
{  
    ETG_TRACE_USR1(("dabdrv_persData::vGetUserData_ START"));

    trUserConfig rUserConfig;
    rSerializer=DAB_Serializer(cu16DataFileVersionMaj, cu8DataFileVersionMin);
    DAB_FOREACH(vector<trCompPersData *>,cfgIter,rUserConfig._vMembers) {
        if (DAB_GET_CONFIG().bDabEnable && !bGetDefault) {
            (*cfgIter)->vGet();
        }
        (*cfgIter)->vSerialize(rSerializer);
        (*cfgIter)->vTrace();
    }

    ETG_TRACE_USR1(("dabdrv_persData::vGetUserData_ END"));
}

tVoid  dabdrv_persData::vGetUserData(tPCU8& rpcu8Buf, tU32&  ru32Length)
{  

    ETG_TRACE_USR1(("dabdrv_persData::vGetUserData START"));
    vGetUserData_(rUserSerializer, FALSE);
    rpcu8Buf = rUserSerializer.pu8GetData();
    ru32Length =rUserSerializer.u32GetLen();
    ETG_TRACE_USR4(("dabdrv_persData::vGetUserData END rpcu8Buf=%p ru32Length=%d",
                    rpcu8Buf,ru32Length));
}

// ****************************************************************************

tVoid  dabdrv_persData::vGetUserDefaultData( tPCU8& rpcu8Buf, tU32&  ru32Length)
{

    ETG_TRACE_USR1(("dabdrv_persData::vGetUserDefaultData START"));
    vGetUserData_(rUserDefaultSerializer, TRUE);
    rpcu8Buf = rUserDefaultSerializer.pu8GetData();
    ru32Length =rUserDefaultSerializer.u32GetLen();
    ETG_TRACE_USR4(("dabdrv_persData::vGetUserDefaultData END rpcu8Buf=%p ru32Length=%d",
                    rpcu8Buf,ru32Length));
}

// ****************************************************************************
