/************************************************************************
 * FILE:    dabdrv_mute.hpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  header of dabdrv_mute
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#ifndef DABDRV_MUTE_HPP
#define DABDRV_MUTE_HPP

#include "fc_dabtuner_util.h"
//#include "dabdrv_types.hpp"
#include "dabdrv_main.hpp"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_DRV_MUTE 
#include "trcGenProj/Header/dabdrv_mute.hpp.trc.h"
#endif

namespace DAB {

    struct trMsgDrvCmdSetChnInfoPsid;

    struct trMsgBlockAnnoMuteTimeOut;

    struct trMsgDrvCmdRequestMute:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL


        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "trMsgDrvCmdRequestMute"));
        }
    };

    struct trMsgDrvCmdUpdateMute:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL


        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "trMsgDrvCmdUpdateMute"));
        }
    };

	/**vnd4kor: supressing prio2 lint warning*/
	
     typedef enum {
        enMuteRequest_NONE         = 0x00,
        enMuteRequest_ANNO_START   = 0x01,
		//lint -esym(793,*identifiers in one block*)
        enMuteRequest_ANNO_END     = 0x02,
        enMuteRequest_DAB_AUDIO    = 0x03
    } tenMuteRequest;

    struct trMsgDrvCmdMuteRequest:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL

        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "trMsgDrvCmdMuteRequest"));
        }
        tenMuteRequest enMuteRequest;
    };

    struct trMsgDrvRspMuteDone:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL

        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "trMsgDrvRspMuteDone"));
        }
    };


#ifdef MUTE_ACTIVE
        struct trMsgDrvCmdTunerOpMuteReq:
            public DAB_Message
        {
            DAB_DISPATCH_IMPL

            virtual tVoid vTrace() const {
                ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG,
                                    "trMsgDrvCmdTunerOpMuteReq"));
            }

            tenRequiredMuteState enRequiredMuteState;
            tU8 u8Attenuation;
            tenMuteOperation enMuteOperation;
        };
#endif
            struct trMsgDrvRspAudioMuted:
                public DAB_Message
            {
                DAB_DISPATCH_IMPL

                virtual tVoid vTrace() const {
                    ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG,
                                        "trMsgDrvRspAudioMuted"));
                }
            };

    typedef enum {
        enMuteState_muted,
        enMuteState_demuting,
        enMuteState_demuted,
        enMuteState_muting
    } tenMuteState;


    class dabdrv_mute:
        public DAB_Singleton <dabdrv_mute>,
        public DAB_MessageHandlerCommon<dabdrv_mute>
    {
        friend class DAB_Singleton<dabdrv_mute>;

    public:
        DAB_TRACE_INFO_IMPL(FC_DABTUNER_TR_DRV_MUTE);
        virtual char const *pcGetName() const {return "dabdrv_mute";};
        virtual tVoid vTraceState() const;

        virtual tVoid vInit();
        virtual tVoid vDeInit();


        virtual tVoid vProcess(trMsgDrvStopComponent* StopComponent);

        virtual tVoid vProcess(trMsgDrvCmdChnSelectState* poChnSelectState);
        virtual tVoid vProcess(trMsgDrvIndActivityChangesChannel* poActivityChangesChannel);
        virtual tVoid vProcess(trMsgDrvIndRemoteCtrl *poIndRemoteCtrl);
        virtual tVoid vProcess(trMsgDrvCmdRequestMute* poRequestMute);
        virtual tVoid vProcess(trMsgDrvCmdUpdateMute* poRequestMute);
        virtual tVoid vProcess(DAB_trAnnoStatusProperty* poAnnoStatus);

        virtual tVoid vProcess(trMsgBlockAnnoMuteTimeOut* poBlockAnnoMuteTimeOut);



        virtual tVoid vProcess(trMsgDrvCmdSourceState* poSourceState);
        virtual tVoid vProcess(trMsgDrvCmdSourceActivity* poSourceActivity);
        virtual tVoid vProcess(trMsgDrvCmdSetChnInfoPsid* prChnInfoPsid);

        virtual tVoid vProcess(trMeca_RRdmGetRdmInfo* poRdmInfo);
        virtual tVoid vProcess(trMsgDrvSetMuteStatus* prSetMuteStatus);
        virtual tVoid vProcess(trMsgDrvCmdMuteRequest* poMuteRequest);
#ifdef MUTE_ACTIVE
        virtual tVoid vProcess(trMsgDrvCmdTunerOpMuteReq* poMuteRequest);
#endif

        tBool bIsDabAudioMuted() const;
        tBool bIsDabTaMuted() const;


    private:
        dabdrv_mute(); 
        tBool bIsAudioDemuteOK() const;
        tBool bIsAudioDemuteDabOK() const;
        tBool bIsAudioDemuteDabTaOK() const;
        void vUpdate();
        tVoid vUpdate(tBool bDemuteOk, tBool bAudioMuted, tenMuteState *penMuteStatus)const;


        DAB_tclTimer _oBlockAnnoMuteTimer;

        tBool _bChnStable;
        tBool _bMuteRequested;
        tBool _bDabModuleMuted;

        trMsgDrvCmdSourceActivity _rSourceActivity;
        tBool _bTaSameSubChannel;
        tenAnnoSelectState _enAnnoSelectState;
        DAB_tenSourceState _enSourceState;
        tenMuteState _enMuteStateDab;
        tenMuteState _enMuteStateDabTa;
        trMecaId _rRdmSid;
        trMecaId _rChnInfoSid;
        tBool _bRemoteCtrlActive;

        tBool _bDabAudioMuted;
        tBool _bDabTaMuted;
    };
} //namespace DAB 

#endif
