/************************************************************************
 * FILE:     dabdrv_mecaMsgIds.h
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  header of dabdrv_mecaMsgIds
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/
 
#ifndef _MECA_DISPATCHER_H_
#define _MECA_DISPATCHER_H_
/*** INCLUDES ******************************************************************
*/
/*** DEFINES *******************************************************************
*/
// SYS-PI
typedef enum {
// special function-ids
    enMecaFktId_ConStartup=0x0f01,
    enMecaFktId_ConRegistration=0x0f02,
    enMecaFktId_ConDeRegistration=0x0f03,
    enMecaFktId_ConPing=0x0f04,
    enMecaFktId_Min=0xe000,
    enMecaFktId_ConSetWatchDog=0xEF01,

    // special invalid id to tell mecaIf to block msgs to adr until deblocked from outside
    enMecaFktId_WaitAnswerBlocking=0xFFFF, 


    MECA_DISPATCHER_C_SYS_POWER = 0x0000,
    MECA_DISPATCHER_R_SYS_POWER = 0x0001,
    MECA_DISPATCHER_R_SYS_REJECT = 0x000B,
// DB-API
    MECA_DISPATCHER_R_DB_REJECT = 0xE101,
    MECA_DISPATCHER_C_DB_GET_DB_ENSEMBLE_LIST = 0xE102,
    MECA_DISPATCHER_R_DB_GET_DB_ENSEMBLE_LIST = 0xE103,
    MECA_DISPATCHER_C_DB_GET_DB_SERVICE_LIST = 0xE120,
    MECA_DISPATCHER_R_DB_GET_DB_SERVICE_LIST = 0xE121,

    MECA_DISPATCHER_C_DB_ENSEMBLE_GET_LABEL = 0xE104,
    MECA_DISPATCHER_R_DB_ENSEMBLE_GET_LABEL = 0xE105,
    MECA_DISPATCHER_C_DB_ENSEMBLE_GET_SHORT_LABEL = 0xE106,
    MECA_DISPATCHER_R_DB_ENSEMBLE_GET_SHORT_LABEL = 0xE107,
    MECA_DISPATCHER_C_DB_ENSEMBLE_GET_TIME = 0xE128,
    MECA_DISPATCHER_R_DB_ENSEMBLE_GET_TIME = 0xE129,
    MECA_DISPATCHER_C_DB_ENSEMBLE_GET_INFO = 0xE10a,
    MECA_DISPATCHER_R_DB_ENSEMBLE_GET_INFO = 0xE10b,
    MECA_DISPATCHER_C_DB_ENSEMBLE_GET_SERVICE_LIST = 0xE10c,
    MECA_DISPATCHER_R_DB_ENSEMBLE_GET_SERVICE_LIST = 0xE10d,
    MECA_DISPATCHER_C_DB_ENSEMBLE_GET_REGION_LIST = 0xE160,
    MECA_DISPATCHER_R_DB_ENSEMBLE_GET_REGION_LIST = 0xE161,
    MECA_DISPATCHER_C_DB_ENSEMBLE_GET_REGION_LABEL = 0xE162,
    MECA_DISPATCHER_R_DB_ENSEMBLE_GET_REGION_LABEL = 0xE163,
    MECA_DISPATCHER_C_DB_ENSEMBLE_GET_FREQUENCY_LIST = 0xE164,
    MECA_DISPATCHER_R_DB_ENSEMBLE_GET_FREQUENCY_LIST = 0xE165,

    MECA_DISPATCHER_C_DB_PROGRAMME_SERVICE_GET_SHORT_LABEL = 0xE154,
    MECA_DISPATCHER_R_DB_PROGRAMME_SERVICE_GET_SHORT_LABEL = 0xE155,

    MECA_DISPATCHER_C_DB_SERVICE_GET_LABEL = 0xE122,
    MECA_DISPATCHER_R_DB_SERVICE_GET_LABEL = 0xE123,
    MECA_DISPATCHER_C_DB_SERVICE_GET_ANNOUNCEMENT_SUPPORT = 0xE12A,
    MECA_DISPATCHER_R_DB_SERVICE_GET_ANNOUNCEMENT_SUPPORT = 0xE12B,
    MECA_DISPATCHER_C_DB_SERVICE_GET_TIME = 0xE108,
    MECA_DISPATCHER_R_DB_SERVICE_GET_TIME = 0xE109,
    MECA_DISPATCHER_C_DB_SERVICE_GET_PTY = 0xE12C,
    MECA_DISPATCHER_R_DB_SERVICE_GET_PTY = 0xE12D,
    MECA_DISPATCHER_C_DB_SERVICE_GET_AF = 0xE132,
    MECA_DISPATCHER_R_DB_SERVICE_GET_AF = 0xE133,
    MECA_DISPATCHER_C_DB_SERVICE_COMPONENT_GET_LABEL = 0xE124,
    MECA_DISPATCHER_R_DB_SERVICE_COMPONENT_GET_LABEL = 0xE125,
    MECA_DISPATCHER_C_DB_SERVICE_COMPONENT_GET_USER_APPLICATION_LIST = 0xE144,
    MECA_DISPATCHER_R_DB_SERVICE_COMPONENT_GET_USER_APPLICATION_LIST = 0xE145,
    MECA_DISPATCHER_C_DB_SERVICE_COMPONENT_GET_USER_APPLICATION_DATA = 0xE146,
    MECA_DISPATCHER_R_DB_SERVICE_COMPONENT_GET_USER_APPLICATION_DATA = 0xE147,
    MECA_DISPATCHER_C_DB_SERVICE_COMPONENT_GET_INFO = 0xE148,
    MECA_DISPATCHER_R_DB_SERVICE_COMPONENT_GET_INFO = 0xE149,
    MECA_DISPATCHER_C_DB_SERVICE_COMPONENT_GET_PS_STATUS = 0xE14A,
    MECA_DISPATCHER_R_DB_SERVICE_COMPONENT_GET_PS_STATUS = 0xE14B,
    MECA_DISPATCHER_C_DB_SERVICE_COMPONENT_GET_SCIDI = 0xE142,
    MECA_DISPATCHER_R_DB_SERVICE_COMPONENT_GET_SCIDI = 0xE143,
    MECA_DISPATCHER_C_DB_SERVICE_GET_COMPONENT_LIST = 0xE126,
    MECA_DISPATCHER_R_DB_SERVICE_GET_COMPONENT_LIST = 0xE127,
    MECA_DISPATCHER_C_DB_SERVICE_GET_INFO = 0xE12E,
    MECA_DISPATCHER_R_DB_SERVICE_GET_INFO = 0xE12F,
    MECA_DISPATCHER_C_DB_SERVICE_GET_LINK_INFO = 0xE170,
    MECA_DISPATCHER_R_DB_SERVICE_GET_LINK_INFO = 0xE171,
    MECA_DISPATCHER_C_DB_COMPONENT_GET_INFO = 0xE140,
    MECA_DISPATCHER_R_DB_COMPONENT_GET_INFO = 0xE141,
    MECA_DISPATCHER_C_DB_SUBCHANNEL_GET_INFO = 0xE150,
    MECA_DISPATCHER_R_DB_SUBCHANNEL_GET_INFO = 0xE151,

    MECA_DISPATCHER_C_DB_SET_AUTO_NOTIFICATION = 0xE152,
    MECA_DISPATCHER_R_DB_SET_AUTO_NOTIFICATION = 0xE153,

    MECA_DISPATCHER_C_DB_ENSEMBLE_GET_INT_TABLE_ID = 0xE156,
    MECA_DISPATCHER_R_DB_ENSEMBLE_GET_INT_TABLE_ID = 0xE157,

    MECA_DISPATCHER_C_DB_FILTERID = 0xE158,
    MECA_DISPATCHER_R_DB_FILTERID = 0xE159,

    MECA_DISPATCHER_C_DB_CONFIG = 0xE166,
    MECA_DISPATCHER_R_DB_CONFIG = 0xE167,

    MECA_DISPATCHER_C_DB_QUERY = 0xE168,
    MECA_DISPATCHER_R_DB_QUERY = 0xE169,

    MECA_DISPATCHER_C_DB_QUERY_TRIGGER = 0xE16A,
    MECA_DISPATCHER_R_DB_QUERY_TRIGGER = 0xE16B,

// RDM-API
    MECA_DISPATCHER_C_RDM_GET_DAB_STATUS = 0xE302,
    MECA_DISPATCHER_R_RDM_GET_DAB_STATUS = 0xE303,
    MECA_DISPATCHER_C_RDM_GET_RDM_STATUS = 0xE304,
    MECA_DISPATCHER_R_RDM_GET_RDM_STATUS = 0xE305,
    MECA_DISPATCHER_C_RDM_GET_EID = 0xE306,
    MECA_DISPATCHER_R_RDM_GET_EID = 0xE307,
    MECA_DISPATCHER_C_RDM_GET_FREQUENCY = 0xE308,
    MECA_DISPATCHER_R_RDM_GET_FREQUENCY = 0xE309,
    MECA_DISPATCHER_C_RDM_GET_FREQUENCY_LABEL = 0xE30A,
    MECA_DISPATCHER_R_RDM_GET_FREQUENCY_LABEL = 0xE30B,

    MECA_DISPATCHER_C_RDM_GET_DAB_FREQUENCY_TABLE = 0xE30C,
    MECA_DISPATCHER_R_RDM_GET_DAB_FREQUENCY_TABLE = 0xE30D,

    MECA_DISPATCHER_R_RDM_PREVIEW_EID = 0xE30F,

    MECA_DISPATCHER_C_RDM_AUDIO_GET_ASID = 0xE310,
    MECA_DISPATCHER_R_RDM_AUDIO_GET_ASID = 0xE311,
    MECA_DISPATCHER_C_RDM_AUDIO_GET_SCIDI = 0xE312,
    MECA_DISPATCHER_R_RDM_AUDIO_GET_SCIDI = 0xE313,
    MECA_DISPATCHER_C_RDM_AUDIO_PLAY_SERVICE = 0xE314,
    MECA_DISPATCHER_R_RDM_AUDIO_PLAY_SERVICE = 0xE315,
    MECA_DISPATCHER_C_RDM_AUDIO_PLAY_ASID = 0xE316,
    MECA_DISPATCHER_R_RDM_AUDIO_PLAY_ASID = 0xE317,
    MECA_DISPATCHER_C_RDM_GET_DAB_AUDIO_QUALITY = 0xE318,
    MECA_DISPATCHER_R_RDM_GET_DAB_AUDIO_QUALITY = 0xE319,

    MECA_DISPATCHER_C_RDM_SET_MODE = 0xE320,
    MECA_DISPATCHER_R_RDM_SET_MODE = 0xE321,
    MECA_DISPATCHER_C_RDM_SET_DAB_FREQUENCY_TABLE = 0xE322,
    MECA_DISPATCHER_R_RDM_SET_DAB_FREQUENCY_TABLE = 0xE323,
    MECA_DISPATCHER_C_RDM_SET_FILTER = 0xE324,
    MECA_DISPATCHER_R_RDM_SET_FILTER = 0xE325,

    MECA_DISPATCHER_C_RDM_TUNE = 0xE330,
    MECA_DISPATCHER_R_RDM_TUNE = 0xE331,
    MECA_DISPATCHER_C_RDM_TUNE_FREQUENCY = 0xE332,
    MECA_DISPATCHER_R_RDM_TUNE_FREQUENCY = 0xE333,
    MECA_DISPATCHER_C_RDM_TUNE_FREQUENCY_LABEL = 0xE334,
    MECA_DISPATCHER_R_RDM_TUNE_FREQUENCY_LABEL = 0xE335,
    MECA_DISPATCHER_C_RDM_GET_SIGNAL_QUALITY = 0xE338,
    MECA_DISPATCHER_R_RDM_GET_SIGNAL_QUALITY = 0xE339,

    MECA_DISPATCHER_C_RDM_QUALITY_CONFIG = 0xE33A,
    MECA_DISPATCHER_R_RDM_QUALITY_CONFIG = 0xE33B,

    MECA_DISPATCHER_C_RDM_TUNE_EID = 0xE340,
    MECA_DISPATCHER_R_RDM_TUNE_EID = 0xE341,
    MECA_DISPATCHER_C_RDM_GET_AUDIO_STATUS = 0xE342,
    MECA_DISPATCHER_R_RDM_GET_AUDIO_STATUS = 0xE343,
    MECA_DISPATCHER_C_RDM_AUDIO_PLAY_COMPONENT = 0xE344,
    MECA_DISPATCHER_R_RDM_AUDIO_PLAY_COMPONENT = 0xE345,
    MECA_DISPATCHER_C_RDM_AUDIO_COMPONENT_PLAY = 0xE346,
    MECA_DISPATCHER_R_RDM_AUDIO_COMPONENT_PLAY = 0xE347,
    MECA_DISPATCHER_C_RDM_SET_DYNAMIC_RANGE_CONTROL = 0xE348,
    MECA_DISPATCHER_R_RDM_SET_DYNAMIC_RANGE_CONTROL = 0xE349,

    MECA_DISPATCHER_C_RDM_GET_RDM_INFO = 0xE34A,
    MECA_DISPATCHER_R_RDM_GET_RDM_INFO = 0xE34B,
    MECA_DISPATCHER_C_RDM_SET_AUTO_NOTIFICATION = 0xE34C,
    MECA_DISPATCHER_R_RDM_SET_AUTO_NOTIFICATION = 0xE34D,

    MECA_DISPATCHER_C_RDM_LEARN = 0xE350,
    MECA_DISPATCHER_R_RDM_LEARN = 0xE351,

    MECA_DISPATCHER_C_RDM_GET_FREQUENCY_INFO = 0xE300,
    MECA_DISPATCHER_R_RDM_GET_FREQUENCY_INFO = 0xE301,

    MECA_DISPATCHER_C_RDM_SERV_FOLLOW_SET_MODE = 0xE352,
    MECA_DISPATCHER_R_RDM_SERV_FOLLOW_SET_MODE = 0xE353,
    MECA_DISPATCHER_R_RDM_SERV_FOLLOW_ACTIVE = 0xE355,
	MECA_DISPATCHER_C_RDM_SCAN = 0xE356,
	MECA_DISPATCHER_R_RDM_SCAN = 0xE357,

	MECA_DISPATCHER_C_RDM_SERV_FOLLOW_SET_ONESHOT_MODE = 0xE358,
	MECA_DISPATCHER_R_RDM_SERV_FOLLOW_SET_ONESHOT_MODE = 0xE359,
    MECA_DISPATCHER_C_RDM_GET_CURR_REGIONS = 0xE360,
    MECA_DISPATCHER_R_RDM_GET_CURR_REGIONS = 0xE361,
    MECA_DISPATCHER_C_RDM_GET_COARSE_POSITION = 0xE362,
    MECA_DISPATCHER_R_RDM_GET_COARSE_POSITION = 0xE363,
    MECA_DISPATCHER_C_RDM_GET_CURR_TII_LIST = 0xE364,
    MECA_DISPATCHER_R_RDM_GET_CURR_TII_LIST = 0xE365,

    MECA_DISPATCHER_C_RDM_STATION_PLAY = 0xE370,
    MECA_DISPATCHER_R_RDM_STATION_PLAY = 0xE371,
    MECA_DISPATCHER_C_RDM_STATION_STORE = 0xE372,
    MECA_DISPATCHER_R_RDM_STATION_STORE = 0xE373,

    MECA_DISPATCHER_C_RDM_STATION_SET_PRESET_STATION = 0xE376,
    MECA_DISPATCHER_R_RDM_STATION_SET_PRESET_STATION = 0xE377,
    MECA_DISPATCHER_C_RDM_STATION_GET_PRESET_STATION = 0xE378,
    MECA_DISPATCHER_R_RDM_STATION_GET_PRESET_STATION = 0xE379,
    MECA_DISPATCHER_C_RDM_STATION_TRAVELSTORE = 0xE37a,
    MECA_DISPATCHER_R_RDM_STATION_TRAVELSTORE = 0xE37b,

    MECA_DISPATCHER_C_RDM_STATION_SET_AUX_DATA = 0xE37c,
    MECA_DISPATCHER_R_RDM_STATION_SET_AUX_DATA = 0xE37d,
    MECA_DISPATCHER_C_RDM_STATION_GET_AUX_DATA = 0xE37e,
    MECA_DISPATCHER_R_RDM_STATION_GET_AUX_DATA = 0xE37f,
    MECA_DISPATCHER_C_RDM_STATION_SET_USER = 0xE380,
    MECA_DISPATCHER_R_RDM_STATION_SET_USER = 0xE381,

// ANS-API
    MECA_DISPATCHER_C_ANS_ENABLE_ANNO = 0xE500,
    MECA_DISPATCHER_R_ANS_ENABLE_ANNO = 0xE501,
    MECA_DISPATCHER_R_ANS_ANNO_ACTIVE_STATUS = 0xE503,
    MECA_DISPATCHER_C_ANS_SELECT_ANNO = 0xE504,
    MECA_DISPATCHER_R_ANS_SELECT_ANNO = 0xE505,
    MECA_DISPATCHER_C_ANS_SET_ANNO_MODE = 0xE506,
    MECA_DISPATCHER_R_ANS_SET_ANNO_MODE = 0xE507,
    MECA_DISPATCHER_C_ANS_GET_ANNO_INFO = 0xE508,
    MECA_DISPATCHER_R_ANS_GET_ANNO_INFO = 0xE509,
    MECA_DISPATCHER_C_ANS_CONFIG_ANNO = 0xE50A,
    MECA_DISPATCHER_R_ANS_CONFIG_ANNO = 0xE50B,
// PTY-API
    MECA_DISPATCHER_R_PTY_REJECT = 0xE601,
    MECA_DISPATCHER_C_PTYM_GET_LABEL = 0xE602,
    MECA_DISPATCHER_R_PTYM_GET_LABEL = 0xE603,
    MECA_DISPATCHER_C_PTYM_GET_LABEL_BY_SERVICE = 0xE604,
    MECA_DISPATCHER_R_PTYM_GET_LABEL_BY_SERVICE = 0xE605,
    MECA_DISPATCHER_C_PTYM_FILTER = 0xE606,
    MECA_DISPATCHER_R_PTYM_FILTER = 0xE607,
    MECA_DISPATCHER_C_PTYM_FILTER_GET_STATUS = 0xE608,
    MECA_DISPATCHER_R_PTYM_FILTER_GET_STATUS = 0xE609,
    MECA_DISPATCHER_C_PTYM_WATCH_MODE = 0xE610,
    MECA_DISPATCHER_R_PTYM_WATCH_MODE = 0xE611,
    MECA_DISPATCHER_C_PTYM_WATCH_MODE_GET_STATUS = 0xE612,
    MECA_DISPATCHER_R_PTYM_WATCH_MODE_GET_STATUS = 0xE613,
    MECA_DISPATCHER_R_PTYM_WATCH_MODE_EVENT = 0xE615,
// DDM-API
    MECA_DISPATCHER_C_DDM_DATAGROUP = 0xE700,
    MECA_DISPATCHER_R_DDM_DATAGROUP = 0xE701,

    MECA_DISPATCHER_C_DDM_PACKET = 0xE702,
    MECA_DISPATCHER_R_DDM_PACKET = 0xE703,

    MECA_DISPATCHER_C_DDM_DMB_STREAM = 0xE704,
    MECA_DISPATCHER_R_DDM_DMB_STREAM = 0xE705,
    MECA_DISPATCHER_C_DDM_STREAM = 0xE706,
    MECA_DISPATCHER_R_DDM_STREAM = 0xE707,

    MECA_DISPATCHER_C_DDM_COMPLEX_DATAGROUP = 0xE708,
    MECA_DISPATCHER_R_DDM_COMPLEX_DATAGROUP = 0xE709,

    MECA_DISPATCHER_C_DDM_IP = 0xE70a,
    MECA_DISPATCHER_R_DDM_IP = 0xE70b,

    MECA_DISPATCHER_C_DDM_PAD = 0xE720,
    MECA_DISPATCHER_R_DDM_PAD = 0xE721,
    MECA_DISPATCHER_C_DDM_APP_TYPE_PAD = 0xE722,
    MECA_DISPATCHER_R_DDM_APP_TYPE_PAD = 0xE723,
    MECA_DISPATCHER_C_DDM_PAD_DATAGROUP = 0xE724,
    MECA_DISPATCHER_R_DDM_PAD_DATAGROUP = 0xE725,

    MECA_DISPATCHER_C_DDM_TMC_SC = 0xE730,
    MECA_DISPATCHER_R_DDM_TMC_SC = 0xE731,
    MECA_DISPATCHER_C_DDM_TMC_CURRENT = 0xE732,
    MECA_DISPATCHER_R_DDM_TMC_CURRENT = 0xE733,
    MECA_DISPATCHER_R_DDM_TMC_EVENT = 0xE735,

    MECA_DISPATCHER_C_DDM_RDI_ALL = 0xE740,
    MECA_DISPATCHER_R_DDM_RDI_ALL = 0xE741,
    MECA_DISPATCHER_C_DDM_RDI_CURRENT = 0xE742,
    MECA_DISPATCHER_R_DDM_RDI_CURRENT = 0xE743,
    MECA_DISPATCHER_C_DDM_RDI_SUBCH = 0xE744,
    MECA_DISPATCHER_R_DDM_RDI_SUBCH = 0xE745,

    MECA_DISPATCHER_C_DDM_RADIOTEXT_SC = 0xE750,
    MECA_DISPATCHER_R_DDM_RADIOTEXT_SC = 0xE751,
    MECA_DISPATCHER_R_DDM_RADIOTEXT_SC_CMD = 0xE757,
    MECA_DISPATCHER_C_DDM_RADIOTEXT_CURRENT = 0xE752,
    MECA_DISPATCHER_R_DDM_RADIOTEXT_CURRENT = 0xE753,
    MECA_DISPATCHER_R_DDM_RADIOTEXT_CUR_CMD = 0xE755,

    MECA_DISPATCHER_C_DDM_TDC = 0xE70c,
    MECA_DISPATCHER_R_DDM_TDC = 0xE70d,

    MECA_DISPATCHER_C_DDM_MOT = 0xE760,
    MECA_DISPATCHER_R_DDM_MOT = 0xE761,
    MECA_DISPATCHER_C_DDM_MOT_CAROUSEL_FOUND = 0xE762,
    MECA_DISPATCHER_R_DDM_MOT_CAROUSEL_FOUND = 0xE763,
    MECA_DISPATCHER_C_DDM_MOT_CAROUSEL_SET_TIMEOUT_FLAG = 0xE764,
    MECA_DISPATCHER_R_DDM_MOT_CAROUSEL_SET_TIMEOUT_FLAG = 0xE765,
    MECA_DISPATCHER_C_DDM_MOT_CAROUSEL_GARBAGE_COLLECTION = 0xE766,
    MECA_DISPATCHER_R_DDM_MOT_CAROUSEL_GARBAGE_COLLECTION = 0xE767,
    MECA_DISPATCHER_C_DDM_MOT_CAROUSEL_INFO = 0xE768,
    MECA_DISPATCHER_R_DDM_MOT_CAROUSEL_INFO = 0xE769,
    MECA_DISPATCHER_C_DDM_MOT_CAROUSEL_CHANGE_MODE = 0xE76a,
    MECA_DISPATCHER_R_DDM_MOT_CAROUSEL_CHANGE_MODE = 0xE76b,
    MECA_DISPATCHER_C_DDM_MOT_CAROUSEL_FIRST_OBJ = 0xE76c,
    MECA_DISPATCHER_R_DDM_MOT_CAROUSEL_FIRST_OBJ = 0xE76d,
    MECA_DISPATCHER_C_DDM_MOT_CAROUSEL_NEXT_OBJ = 0xE76e,
    MECA_DISPATCHER_R_DDM_MOT_CAROUSEL_NEXT_OBJ = 0xE76f,
    MECA_DISPATCHER_C_DDM_MOT_CAROUSEL_OBJ_LIST = 0xE770,
    MECA_DISPATCHER_R_DDM_MOT_CAROUSEL_OBJ_LIST = 0xE771,

    MECA_DISPATCHER_C_DDM_MOT_CAROUSEL_LOCATE_OBJ = 0xE772,
    MECA_DISPATCHER_R_DDM_MOT_CAROUSEL_LOCATE_OBJ = 0xE773,
    MECA_DISPATCHER_C_DDM_MOT_CAROUSEL_LOCATE_DIR_INDEX = 0xE774,
    MECA_DISPATCHER_R_DDM_MOT_CAROUSEL_LOCATE_DIR_INDEX = 0xE775,
    MECA_DISPATCHER_C_DDM_MOT_CAROUSEL_MATCH_OBJ = 0xE776,
    MECA_DISPATCHER_R_DDM_MOT_CAROUSEL_MATCH_OBJ = 0xE777,
    MECA_DISPATCHER_C_DDM_MOT_OBJSTREAM_SET_TIMEOUT_FLAG = 0xE778,
    MECA_DISPATCHER_R_DDM_MOT_OBJSTREAM_SET_TIMEOUT_FLAG = 0xE779,
    MECA_DISPATCHER_C_DDM_MOT_OBJSTREAM_GARBAGE_COLLECTION = 0xE77a,
    MECA_DISPATCHER_R_DDM_MOT_OBJSTREAM_GARBAGE_COLLECTION = 0xE77b,
    MECA_DISPATCHER_C_DDM_MOT_OBJECT_OPEN = 0xE77c,
    MECA_DISPATCHER_R_DDM_MOT_OBJECT_OPEN = 0xE77d,
    MECA_DISPATCHER_C_DDM_MOT_OBJECT_HEADER = 0xE77e,
    MECA_DISPATCHER_R_DDM_MOT_OBJECT_HEADER = 0xE77f,
    MECA_DISPATCHER_C_DDM_MOT_OBJECT_BODY = 0xE780,
    MECA_DISPATCHER_R_DDM_MOT_OBJECT_BODY = 0xE781,
    MECA_DISPATCHER_C_DDM_MOT_OBJECT_HEADER_DC = 0xE782,
    MECA_DISPATCHER_R_DDM_MOT_OBJECT_HEADER_DC = 0xE783,
    MECA_DISPATCHER_C_DDM_MOT_OBJECT_BODY_DC = 0xE784,
    MECA_DISPATCHER_R_DDM_MOT_OBJECT_BODY_DC = 0xE785,
    MECA_DISPATCHER_C_DDM_MOT_OBJECT_INFO = 0xE786,
    MECA_DISPATCHER_R_DDM_MOT_OBJECT_INFO = 0xE787,
    MECA_DISPATCHER_C_DDM_MOT_OBJECT_CLOSE = 0xE788,
    MECA_DISPATCHER_R_DDM_MOT_OBJECT_CLOSE = 0xE789,
    MECA_DISPATCHER_R_DDM_MOT_RESPONSE = 0xE78a,

    MECA_DISPATCHER_C_DDM_MOT_OBJSTREAM_CHANGE_MODE = 0xE78b,
    MECA_DISPATCHER_R_DDM_MOT_OBJSTREAM_CHANGE_MODE = 0xE78c,

    MECA_DISPATCHER_C_DDM_MOT_CAROUSEL_DIRECTORY = 0xE78f,
    MECA_DISPATCHER_R_DDM_MOT_CAROUSEL_DIRECTORY = 0xE790,

    MECA_DISPATCHER_C_DDM_SELECT_URI = 0xE7E0,
    MECA_DISPATCHER_R_DDM_SELECT_URI = 0xE7E1,
	MECA_DISPATCHER_R_DDM_TIMESTAMP  =0XE7E3,


// EXP-API
    MECA_DISPATCHER_C_EXP_SELECT = 0xE900,
    MECA_DISPATCHER_R_EXP_SELECT = 0xE901,

    MECA_DISPATCHER_R_EXP_ID_DESCRIPTION = 0xE903,
    MECA_DISPATCHER_R_EXP_ID_VALUE_LABEL = 0xE905,
    MECA_DISPATCHER_R_EXP_ID_VALUE_UINT32 = 0xE907,
    MECA_DISPATCHER_C_EXP_ID_SET_VALUE_UINT32 = 0xE908,
    MECA_DISPATCHER_R_EXP_ID_VALUE_BYTEARRAY = 0xE909,
    MECA_DISPATCHER_R_EXP_ID_VALUE_UINT32_FUNC = 0xE90b,

// AUD-API
    MECA_DISPATCHER_C_AUD_CHANGE_AUDIO = 0xE916,
    MECA_DISPATCHER_R_AUD_CHANGE_AUDIO = 0xE917,
    MECA_DISPATCHER_C_AUD_GET_AUDIO_INFO = 0xE918,
    MECA_DISPATCHER_R_AUD_GET_AUDIO_INFO = 0xE919,
    MECA_DISPATCHER_C_AUD_GET_MUTE_INFO = 0xE91a,
    MECA_DISPATCHER_R_AUD_GET_MUTE_INFO = 0xE91b,
    MECA_DISPATCHER_C_AUD_SET_MUTE = 0xE91c,
    MECA_DISPATCHER_R_AUD_SET_MUTE = 0xE91d,

    MECA_DISPATCHER_C_AUD_GET_EQUALIZER_INFO = 0xE920,
    MECA_DISPATCHER_R_AUD_GET_EQUALIZER_INFO = 0xE921,
    MECA_DISPATCHER_C_AUD_SET_EQUALIZER_MODE = 0xE922,
    MECA_DISPATCHER_R_AUD_SET_EQUALIZER_MODE = 0xE923,
    MECA_DISPATCHER_C_AUD_SET_EQUALIZER = 0xE924,
    MECA_DISPATCHER_R_AUD_SET_EQUALIZER = 0xE925,

    MECA_DISPATCHER_C_AUD_SET_MODE = 0xE930,
    MECA_DISPATCHER_R_AUD_SET_MODE = 0xE931,
    MECA_DISPATCHER_C_AUD_SRC_CONTROL = 0xE932,
    MECA_DISPATCHER_R_AUD_SRC_CONTROL = 0xE933,
    MECA_DISPATCHER_C_AUD_SET_CONCEALMENT_LEVEL = 0xE934,
    MECA_DISPATCHER_R_AUD_SET_CONCEALMENT_LEVEL = 0xE935,
    MECA_DISPATCHER_C_AUD_SET_AUDIO_PARAMS = 0xE936,
    MECA_DISPATCHER_R_AUD_SET_AUDIO_PARAMS = 0xE937,

// SYS-API
    MECA_DISPATCHER_C_SYS_STORE = 0xEB00,
    MECA_DISPATCHER_R_SYS_STORE = 0xEB01,
    MECA_DISPATCHER_C_SYS_RESTORE = 0xEB02,
    MECA_DISPATCHER_R_SYS_RESTORE = 0xEB03,
    MECA_DISPATCHER_C_SYS_GET_VERSION_INFO = 0xEB04,
    MECA_DISPATCHER_R_SYS_GET_VERSION_INFO = 0xEB05,
    MECA_DISPATCHER_C_SYS_STORAGE_GET_FRAME = 0xEB06,
    MECA_DISPATCHER_R_SYS_STORAGE_GET_FRAME = 0xEB07,
    MECA_DISPATCHER_C_SYS_STORAGE_PUT_FRAME = 0xEB08,
    MECA_DISPATCHER_R_SYS_STORAGE_PUT_FRAME = 0xEB09,
    MECA_DISPATCHER_C_SYS_STORAGE_FORMAT = 0xEB0a,
    MECA_DISPATCHER_R_SYS_STORAGE_FORMAT = 0xEB0b,
    MECA_DISPATCHER_C_SYS_DIAG = 0xEB0c,
    MECA_DISPATCHER_R_SYS_DIAG = 0xEB0d,
    MECA_DISPATCHER_C_SYS_STORAGE_GET_FRAME_SEGMENT = 0xEB0e,
    MECA_DISPATCHER_R_SYS_STORAGE_GET_FRAME_SEGMENT = 0xEB0f,
    MECA_DISPATCHER_C_SYS_STORAGE_PROTECT = 0xEB10,
    MECA_DISPATCHER_R_SYS_STORAGE_PROTECT = 0xEB11,
    MECA_DISPATCHER_C_SYS_TIME = 0xEB12,
    MECA_DISPATCHER_R_SYS_TIME = 0xEB13,
    MECA_DISPATCHER_C_SYS_MEMORY = 0xEB14,
    MECA_DISPATCHER_R_SYS_MEMORY = 0xEB15,

// TSU-API
    MECA_DISPATCHER_C_TSU_SET_MODE = 0xED00,
    MECA_DISPATCHER_R_TSU_SET_MODE = 0xED01,
    MECA_DISPATCHER_C_TSU_SWITCH_TUNER = 0xED02,
    MECA_DISPATCHER_R_TSU_SWITCH_TUNER = 0xED03,
    MECA_DISPATCHER_R_TSU_SWITCH_RECOMMENDATION = 0xED05,
    MECA_DISPATCHER_C_TSU_SET_CONFIG = 0xED06,
    MECA_DISPATCHER_R_TSU_SET_CONFIG = 0xED07,
    MECA_DISPATCHER_C_TSU_SELECT_PSID = 0xED08,
    MECA_DISPATCHER_R_TSU_SELECT_PSID = 0xED09,
    MECA_DISPATCHER_C_TSU_GET_PSID = 0xED0a,
    MECA_DISPATCHER_R_TSU_GET_PSID = 0xED0b,
    MECA_DISPATCHER_C_TSU_GET_QUALITY = 0xED0c,
    MECA_DISPATCHER_R_TSU_GET_QUALITY = 0xED0d,
    MECA_DISPATCHER_R_TSU_PLAY_BEST_OF_LIST = 0xED0f,
    MECA_DISPATCHER_R_DDM_DATACHANNEL = 0xffff
} DAB_tenMecaMsgId;

// TSU-API
typedef enum {
// special function-ids
    MECA_DISPATCHER_C_MTC_NOTIFICATION = 0x0001,
    MECA_DISPATCHER_C_MTC_SET_MODE = 0x0F10,
    MECA_DISPATCHER_C_MTC_TUNER_STATUS = 0x0F11,
    MECA_DISPATCHER_C_MTC_SET_AUDIO = 0x0F12,       // not used in Nissan LCN2kai
    MECA_DISPATCHER_C_MTC_SET_CONFIG = 0x0F13,
	MECA_DISPATCHER_C_MTC_SF_RESTART = 0x0F14,
	MECA_DISPATCHER_C_MTC_REQUEST_SWITCH = 0x0F15,
	MECA_DISPATCHER_C_MTC_ANNOUNCEMENT = 0x0f30,
	MECA_DISPATCHER_C_MTC_SURVEILLANCE = 0x0f21,
    MECA_DISPATCHER_C_MTC_TESTMODE     = 0x0F20,
    MECA_DISPATCHER_C_MTC_STARTUP      = 0xFFF4
} DAB_tenMecaTsuMsgId;

#endif

