/************************************************************************
 * FILE:      dabdrv_meca.h
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of dabdrv_meca
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#ifndef DABDRV_MECA_H
#define DABDRV_MECA_H
#include "fc_dabtuner_util.h"

#define CONFIG_COMPONENT_API_GENERIC_TMC_AUSPUFF
#define CONFIG_COMPONENT_API_DSM
#define CONFIG_COMPONENT_API_DB
#define CONFIG_COMPONENT_API_RDM
#define CONFIG_COMPONENT_API_ANS
#define CONFIG_COMPONENT_API_DDM
#define CONFIG_COMPONENT_API_EXP
#define CONFIG_COMPONENT_API_TSU
#define CONFIG_COMPONENT_API_CMR
#include "dabdrv_mecaMsgIds.h"

#define DAB_CLIENT_ID (tU16)0x0010
#define DAB_FBLOCK_ID (tU16)0x0043
#define DAB_INSTANCE_ID (tU8)0x01
#define DAB_MTC_FBLOCK_ID (tU16)0x00F0
#define DAB_MTC_INSTANCE_ID (tU8)0xFF

// todo check if we need to send longer meca-messages
#define DABDRV_MAX_MECA_OUT_LEN 600
namespace DAB {


typedef enum {
    enOpType_SET = 0x00,
    enOpType_GET = 0x01,
    enOpType_SETGET = 0x02,
    enOpType_STATUS = 0x0c,
    enOpType_STATUSREQ = 0x10,
    enOpType_ERROR = 0x0f,
    enOpType_INVALID = 0xff
} tenOpType;


 typedef enum {
    enIpnError_OK = 0x00,
    enIpnError_FBLOCK_ID_NOT_AVAIL = 0x01,
    enIpnError_INSTANCE_ID_NOT_AVAIL = 0x02,
    enIpnError_FUNCTION_ID_NOT_AVAIL = 0x03,
    enIpnError_OPTYPE_NOT_AVAIL = 0x04,
    enIpnError_INVALID_LENGTH = 0x05,
    enIpnError_PARAMETER_WRONG = 0x06,
    enIpnError_CLIENT_REGISTRATION = 0xf0,
    enIpnError_CLIENT_UNREGISTRATION = 0xf1,
    enIpnError_CLIENT_NOT_REGISTERED = 0xf2,
    enIpnError_CLIENT_ALREADY_REGISTERED = 0xf3
} tenIpnErrorType;
 typedef enum {
     enIpnMsgType_DATA_CON=0x41,
     enIpnMsgType_DATA_IND=0x45
 } tenIpnMsgTypes;

#define DAB_IPN_CONTEXT_WORD 0x41
#define DAB_IPN_SUB_CONTEXT  0x01
#define DAB_IPN_MSG_TYPE_DATA_CON 0x41
#define DAB_IPN_MSG_TYPE_DATA_IND 0x45
#define DAB_IPN_DATA_CON_RES_OK 0x01

typedef enum {
    enIpnMsgOffset_CONTEXT_WORD   = 0,
    enIpnMsgOffset_SUB_CONTEXT   = 1,
    enIpnMsgOffset_IPN_MSG_TYPE   = 2,
    enIpnMsgOffset_IND_DATA   = 3,
    enIpnMsgOffset_CON_RES   = 8
} tenIpnMsgOffsets;

typedef enum {
    enAdrMsgOffset_CLIENT_ID   = 0,
    enAdrMsgOffset_FBLOCK_ID   = 2,
    enAdrMsgOffset_INSTANCE_ID = 4,
    enAdrMsgOffset_FKT_ID      = 5,
    enAdrMsgOffset_OP_TYPE     = 7,
    enAdrMsgOffset_MECA_LEN    = 8,
    enAdrMsgOffset_MECA_DATA   = 10
} tenAdrMsgOffsets;

#define DABDRV_MAX_ADR_OUT_LEN ((tU16)enAdrMsgOffset_MECA_DATA + DABDRV_MAX_MECA_OUT_LEN)
#define DABDRV_IPN_HDR_LEN 3
#define DABDRV_IPN_CONTEXT_POS 0
#define DABDRV_IPN_SUB_CONTEXT_POS 1
#define DABDRV_IPN_SRV_POS 2
#define DABDRV_IPN_SSI_RES_POS 3
#define DABDRV_IPN_CONTEXT 0x41
#define DABDRV_IPN_SUB_CONTEXT 0xc1
#define DABDRV_IPN_SRV_DATA_CON 0x41
#define DABDRV_IPN_SRV_DATA_IND 0x45
#define DABDRV_IPN_SRV_DATA_REQ 0x40
#define DABDRV_IPN_SSI_OK 0x01
#define DABDRV_IPN_SSI_FAULT 0x00
#define DABDRV_IPN_MIN_RX_LEN 4

#define DABMECA_CLIENT_ID_STARTUP 0xFFFF
#define DABMECA_CLIENT_ID_DAB     0x0010
#define DABMECA_FBLOCK_ID_DAB     0x0043
#define DABMECA_INSTANCE_ID_DAB1  0x01
#define DABMECA_FBLOCK_ID_DAB_MTC 0x00F0
#define DABMECA_INSTANCE_ID_MTC   0xFF

struct trMostHdr{
    tU16 _u16ClientId;
    tU16 _u16FBlockId;
    tU8  _u8InstanceId;
    tU16 _u16FktId;
    tenOpType _enOpType;
    tU16 _u16MecaLen;

    trMostHdr() {
        _u16ClientId = DAB_CLIENT_ID;
        _u16FBlockId = DAB_FBLOCK_ID;
        _u8InstanceId = DAB_INSTANCE_ID;
        _u16FktId = 0;
        _enOpType = enOpType_INVALID;
        _u16MecaLen = 0;
    }
    trMostHdr(tU8 const *pu8MostFrame) {
        _u16ClientId = DABDRV_GET_U16(&pu8MostFrame[enAdrMsgOffset_CLIENT_ID]);
        _u16FBlockId = DABDRV_GET_U16(&pu8MostFrame[enAdrMsgOffset_FBLOCK_ID]);
        _u8InstanceId = pu8MostFrame[enAdrMsgOffset_INSTANCE_ID];
        _u16FktId = DABDRV_GET_U16(&pu8MostFrame[enAdrMsgOffset_FKT_ID]);
        _enOpType = (tenOpType)pu8MostFrame[enAdrMsgOffset_OP_TYPE];
        _u16MecaLen = DABDRV_GET_U16(&pu8MostFrame[enAdrMsgOffset_MECA_LEN]);
    }
    tBool bIsStartUp() const {
        return (_u16ClientId == DABMECA_CLIENT_ID_STARTUP);
    }
    tBool bIsValid() const {
        tBool bRes= TRUE;
        tU32 u16ClientId = (_u16FktId == (tU16)enMecaFktId_ConStartup) ? DABMECA_CLIENT_ID_STARTUP : DABMECA_CLIENT_ID_DAB;
        tU32 u16ClientId2 = (_u16FktId == (tU16)MECA_DISPATCHER_C_MTC_STARTUP) ? DABMECA_CLIENT_ID_STARTUP : DABMECA_CLIENT_ID_DAB;
        bRes = bRes && ((_u16ClientId == u16ClientId)||(_u16ClientId == u16ClientId2));
        bRes = bRes && ((_u16FBlockId == DAB_FBLOCK_ID)||(_u16FBlockId == DAB_MTC_FBLOCK_ID));
        bRes = bRes && ((_u8InstanceId == DAB_INSTANCE_ID)||(_u8InstanceId == DAB_MTC_INSTANCE_ID));
        return bRes;
    }

};

// Base-Class for all Meca-Input, 
// adding bParse to DAB_Message
// Parsing in constructor is not possible because we need information
// if parsing was successful.
struct trMsgMecaInput:
    public DAB_Message 
{
    virtual tBool bParse(trMostHdr const &rMostHdr, tU8 const *pu8Data)=0;
    trMostHdr _rMostHdr;
};


// meca message, serialized except msgType
// for the current implementation derivation from DAB_Message could be removed
struct trMsgMecaRawOutput:
    public DAB_Message 
{
    DAB_DISPATCH_IMPL
    tU16 u16FBlockId;
    tenOpType enOpType;
    DAB_tenMecaMsgId u16MsgType; // todo:rename to enMecaMsgId
    DAB_tenMecaTsuMsgId enMecaTsuMsgId;
    tU16 u16DataLen;
    tU8 au8Data[DABDRV_MAX_MECA_OUT_LEN];
    virtual tVoid vTrace() const;

};

// base-type for all sendable meca-messages
struct trMsgMecaOut:
    public DAB_Message 
{
    virtual tVoid vSerialize(trMsgMecaRawOutput *pRawOutput) const =0;
};


} // namespace DAB

#endif
