/************************************************************************
 * FILE:      dabdrv_main.hpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of dabdrv_main
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#ifndef DABDRV_MAIN_HPP
#define DABDRV_MAIN_HPP

#include "fc_dabtuner_util.h"
#include "fc_dabtuner_MhQ.h"

#include "dabdrv_types.hpp"
#include "dabdrv_mecaIf.h"
#include "dabdrv_adrIf.hpp"
#include "dabmeca_rdm.hpp"
#include "dabdrv_properties.hpp"
#include "dabdrv_persData.hpp"
#include "dabdrv_activityList.h"
#include "dabdrv_typeEnums.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_DRV_MAIN 
#include "trcGenProj/Header/dabdrv_main.hpp.trc.h"
#endif
#define NUMBER_OF_USERS 7
namespace DAB {


    //lint -esym(763, DAB::dabdrv_activityBase)  Redundant declaration for symbol
    class dabdrv_activityBase;
    //lint -esym(763, DAB::dabdrv_activityList)  Redundant declaration for symbol
    class dabdrv_activityList;

    struct trMainUsrData {
        trMainUsrData():
            bCompMode(FALSE)
        {}
        tBool bCompMode;
        trMecaProgrammeService rLastSrv;
        trMecaId rLastComp;

        // persistant data serialization
        tVoid vSerialize(DAB_Serializer &rSerializer) const {
            rSerializer.vSerialize(bCompMode);
            rSerializer.vSerialize(rLastSrv);
            rSerializer.vSerialize(rLastComp);
        }
            
        tVoid vParse(DAB_Parser &rParser) {
            rParser.vParse(bCompMode);
            rParser.vParse(rLastSrv);
            rParser.vParse(rLastComp);
        }

        tVoid vTrace() {
            ETG_TRACE_USR4(("  trMainUsrData:bCompMode=%d rLastSrv=%d rLastComp=%d scids=%d",
                            bCompMode,
                            rLastSrv.u32GetSID(),
                            rLastComp.u16GetScidi(),
                            rLastSrv._u16Scids
                            ));
        }
    };

    typedef enum {
        DAB_enDrvState_NULL,
        DAB_enDrvState_
    } DAB_tenDrvState;

    typedef enum {
        DAB_enTuneMode_Off,
        DAB_enTuneMode_Psid,
        DAB_enTuneMode_Component,
        DAB_enTuneMode_Freq
    } DAB_tenTuneMode;


    struct trMsgSrvCmdOpen:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "  trMsgSrvCmdOpen"));
        };
    };

    struct trMsgDrvEvt1SecondTick:
        public DAB_Message
    {
        tU32 u32Seconds;
        tBool bAdrUp;
        trMsgDrvEvt1SecondTick(tU32 u32Seconds_=0, tBool bAdrUp_=0):
            u32Seconds(u32Seconds_),
            bAdrUp(bAdrUp_)
        {}
        DAB_DISPATCH_IMPL
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "  trMsgDrvEvt1SecondTick: u32Seconds=%d bAdrUp=%d",
                                u32Seconds,
                                bAdrUp));
        };
    };

    struct trMsgSrvCmdClose:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "  trMsgSrvCmdClose"));
        };
    };

    struct trMsgSrvCmdCvStart:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "  trMsgSrvCmdCvStart"));
        };
    };

    struct trMsgSrvCmdCvEnd:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "  trMsgSrvCmdCvEnd"));
        };
    };

    // todo:add clone, this one should only be used in dabdrv_main
    struct trMsgSrvCmdNewAppState:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL

        tU32 u32OldAppState;
        tU32 u32NewAppState;

        trMsgSrvCmdNewAppState(tU32 u32OldAppState_=AMT_C_U32_STATE_OFF, tU32 u32NewAppState_=AMT_C_U32_STATE_OFF):
            u32OldAppState(u32OldAppState_),
            u32NewAppState(u32NewAppState_)
        {}
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "trMsgSrvCmdNewAppState %d->%d",
                                u32OldAppState, u32NewAppState));
        }

    };

    struct trMsgSrvRspAppStateReached:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL

        tU32 u32AppState;

        trMsgSrvRspAppStateReached(tU32 u32AppState_=AMT_C_U32_STATE_OFF):
            u32AppState(u32AppState_)
        {}
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "trMsgSrvRspAppStateReached %d",
                                u32AppState));
        }

    };

    struct trMsgSrvCmdSourceState:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL
        trMsgSrvCmdSourceState(DAB_tenSourceState enSourceState_=DAB_enSourceState_BG) {
            enSourceState = enSourceState_;
        }
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "  trMsgSrvCmdSourceState:enSourceState=%d",
                                ETG_CENUM(DAB_tenSourceState, enSourceState)));
        };
        DAB_tenSourceState enSourceState;
    };

    struct trMsgSrvCmdMtcMode:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL
        trMsgSrvCmdMtcMode(DAB_tenMtcMode enMtcMode_=DAB_enMtcMode_Off) {
            enMtcMode = enMtcMode_;
        }
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "  trMsgSrvCmdMtcMode:enMtcMode=%d",
                                ETG_CENUM(DAB_tenMtcMode, enMtcMode)));
        };
        DAB_tenMtcMode enMtcMode;
    };



	/*struct trMsgSrvCmdMtcRequestSwitch:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL
        trMsgSrvCmdMtcRequestSwitch(DAB_tenMtcRequestSwitch enMtcRequestSwitch_=DAB_enMtcRequestSwitch_DAB) {
            enMtcRequestSwitch = enMtcRequestSwitch_;
        }
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "  trMsgSrvCmdMtcRequestSwitch:enMtcRequestSwitch=%d",
                                ETG_CENUM(DAB_tenMtcRequestSwitch, enMtcRequestSwitch)));
        };
        DAB_tenMtcRequestSwitch enMtcRequestSwitch;
    };
*/


	/*struct trMsgSrvCmdMtcTuner_ActivityState:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL
        trMsgSrvCmdMtcTuner_ActivityState(DAB_tenMtcActivityState enMtcActivityState_=DAB_enMtcActivityState_Stop) {
            enMtcActivityState = enMtcActivityState_;
        }
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "  trMsgSrvCmdMtcTuner_ActivityState:enMtcActivityState=%d",
                                ETG_CENUM(DAB_tenMtcActivityState, enMtcActivityState)));
        };
        DAB_tenMtcActivityState enMtcActivityState;
    };*/


#if 1
    struct trMsgDrvCmdSourceState: public trMsgSrvCmdSourceState {
        DAB_CLONE_IMPL(trMsgDrvCmdSourceState,trMsgSrvCmdSourceState);

    };
#endif

     struct trMsgDrvCmdProcessed:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL
        tenCmdProcessed enCmdProcessed;
        trMsgDrvCmdProcessed(tenCmdProcessed enCmdProcessed_):
            enCmdProcessed(enCmdProcessed_)
        {}
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "trMsgDrvCmdNewAppState %d",
                                ETG_CENUM(tenCmdProcessed, enCmdProcessed)));
        }
    };


    struct trMsgDrvSetTuneMode:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL
        trMsgDrvSetTuneMode(DAB_tenTuneMode enTuneMode_) {
            enTuneMode = enTuneMode_;
        }
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "  trMsgDrvSetTuneMode: enTuneMode=0x%x", 
                                ETG_CENUM(DAB_tenTuneMode, enTuneMode)));
        };
        DAB_tenTuneMode enTuneMode;
    };


    struct trMsgDrvAdrUp:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL

        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "  trMsgDrvAdrUp"));
        };
    };

    struct trMsgDrvAdrDown:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL

        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "  trMsgDrvAdrDown"));
        };
    };


    struct trMsgDrvStartComponent:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL

        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "  trMsgDrvStartComponent"));
        };
    };

    struct trMsgDrvStartComponentFirst:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL

        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "  trMsgDrvStartComponentFirst"));
        };
    };

    struct trMsgDrvStopComponent:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL

        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "  trMsgDrvStopComponent"));
        };
    };

    typedef enum {
        DAB_enSeekType_Off,
        DAB_enSeekType_Up,
        DAB_enSeekType_Down,
        DAB_enSeekType_Start_Target_Up,
        DAB_enSeekType_Start_Target_Down,
        DAB_enSeekType_Stop_Target
    } DAB_tenSeekType;

    struct trMsgSrvCmdSeek:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL

        trMsgSrvCmdSeek() {
            enSeekType=DAB_enSeekType_Off;
        };
        trMsgSrvCmdSeek(DAB_tenSeekType enSeekType_ ) {
            enSeekType = enSeekType_;
        }

        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "  trMsgSrvCmdSeek: enSeekType=0x%x", 
                                ETG_CENUM(DAB_tenSeekType, enSeekType)));
        };
        DAB_tenSeekType enSeekType;
    };

    struct trMsgDrvCmdSeek: public trMsgSrvCmdSeek {
        DAB_CLONE_IMPL(trMsgDrvCmdSeek,trMsgSrvCmdSeek);

    };

    struct dabdrv_msg1SecondTick;
    struct dabdrv_msgDeBlockActivities;
    struct dabdrv_msgSysStoreWaitTimeOut;
    struct dabdrv_msgSrcChngRspDealyTimeout;
#ifdef DAB_DRV_ENABLE_BG_DELAY
    struct dabdrv_msgSrcStateBgDelay;
#endif

class dabdrv_main:
        public DAB_Singleton <dabdrv_main>,
        public DAB_MessageHandlerCommon<dabdrv_main>
    {
        friend class DAB_Singleton<dabdrv_main>;

    public:
        DAB_TRACE_INFO_IMPL(FC_DABTUNER_TR_DRV_MAIN);
        virtual ~dabdrv_main();
        virtual char const *pcGetName() const {return "dabdrv_main";};
        virtual tVoid vTraceState() const;
        virtual tVoid vInit();
        virtual tVoid vDeInit();
        virtual tVoid vProcess(trMsgDrvAdrUp* poDrvAdrUp);
        virtual tVoid vProcess(trMsgDrvAdrDown* poDrvAdrDown);

        virtual tVoid vProcess(dabdrv_msg1SecondTick *poTickTmr);
        virtual tVoid vProcess(dabdrv_msgDeBlockActivities *poDeBlockActivities);
        virtual tVoid vProcess(dabdrv_msgSysStoreWaitTimeOut *poSysStoreWaitTimeOut);
        virtual tVoid vProcess(dabdrv_msgSrcChngRspDealyTimeout *poSrcChngRspDealyTimeout);
#ifdef DAB_DRV_ENABLE_BG_DELAY
        virtual tVoid vProcess(dabdrv_msgSrcStateBgDelay *poSrcStateBgDelay);
#endif
        virtual tVoid vProcess(trMsgDrvCmdChnSelectState *poChnSelectState);
        virtual tVoid vProcess(trMsgDrvCmdApplyUsrData *poApplyUsrData);



        virtual tVoid vProcess(trMsgSrvCmdNewAppState* poSrvCmdNewAppState);
        virtual tVoid vProcess(trMsgSrvCmdSourceState* poSrvCmdSourceState);

		virtual tVoid vProcess(trMsgSrvCmdEnsSelect* poSrvCmdEnsSelect);
        virtual tVoid vProcess(trMsgSrvCmdChnSelect* poSrvCmdChnSelect);
        virtual tVoid vProcess(trMsgSrvCmdCompSelect* poSrvCmdCompSelect);
        virtual tVoid vProcess(trMsgSrvCmdSetup* poCmdSetup);
        virtual tVoid vProcess(trMeca_RMtcSetConfig* poRMtcSetConfig);

        virtual tVoid vProcess(trMsgDrvIndCompModeFailed* poCompModeFailed); 
        virtual tVoid vProcess(trMsgSrvCmdRecallPreset* poCmdRecallPreset); 




        virtual tVoid vProcess(trMeca_RAudSetConcealmentLevel* poRAudSetConcealmentLevel);
        tVoid enSetServiceLinkingMode(DAB_tenServiceLinkingMode enServiceLinkingMode)  { _rCurrentSetup.e8ServiceLinkingMode = enServiceLinkingMode;};
        virtual tVoid vProcess(trMsgDrvIndPreChnSelect* poCmdPreChnSelect);
		
		
		
		virtual tVoid vProcess(trMsgDrvCmdNotifyLearnComplete* );
#ifdef DAB_ENABLE_MUTE_HANDLING
		virtual tVoid vProcess(trMsgSrvCmdEnsSeek* poSrvCmdEnsSeek);
#endif

#ifdef MUTE_ACTIVE
		virtual tVoid vProcess(trMsgSrvCmdManualModeOp*  poSrvCmdManualModeOp);
		virtual tVoid vProcess(trMsgDrvMuteState*  poDrvMuteStatus);
		virtual tVoid vProcess(trMsgSrvCmdLoadPreset*  poSrvCmdLoadPreset);
		virtual tVoid vProcess(trMsgSrvCmdSrvSelect*  poSrvCmdSrvSelect);
		virtual tVoid vProcess(trMsgSrvCmdManualLearnOp*  poSrvCmdSrvLearn);
		virtual tVoid vProcess(trMsgSrvCmdTuneFreqlabel* poSrvCmdTuneFreqlabel);
#endif
		virtual tVoid vProcess(trMeca_RDbConfig* poRDbConfig);
		virtual tVoid vProcess(trMsgDrvDeleteMemory* poCmdDelMemory);
        virtual tVoid vProcess(trMeca_RRdmSetMode* poRRdmSetMode);
        virtual tVoid vProcess(trMsgDrvCmdProcessed* poCmdProcessed);
		virtual tVoid vProcess(trMeca_RRdmGetAudioStatus *poRRdmGetAudioStatus);
		virtual tVoid vProcess(trMsgSrvCmdCoding *poCmdCoding);
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
		virtual tVoid vProcess(trMeca_RRdmStationSetUser* povSetUser);
		virtual tVoid vProcess(trMeca_RRdmStationTravelStore* poTravelStore);
#endif


        tVoid vRegisterActivity(dabdrv_activityBase *poActivity);
        tVoid vOnActivityRequest(DAB_tenDrvActivity enActivity=DAB_enDrvActivity_Idle);
        tVoid vOnActivityDone(DAB_tenDrvActivity enActivity, tBool bSuccess=TRUE);
#if defined  VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI || defined VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
		tVoid vSetLinkingMode(tBool bRdsFollowStatus);
#endif

        tBool bIsAdrUp() const {return _bAdrUp;};
        DAB_tenSourceState enGetSourceState() const {return _enSourceState;};
        tenSourceActivity enGetSourceActivity() const {return _enSourceActivity;};
        tBool bTaActive() const {return _bTA;};
        tBool bIsCompMode() const {return _bCompMode;};
		tVoid bSetCompMode(tBool bCompMode_)  {_bCompMode=bCompMode_;};
        tBool bActivityChangedChannel() const { return _bActivityChangedChannel;};
        DAB_tenServiceLinkingMode enGetServiceLinkingMode() const {return _rCurrentSetup.e8ServiceLinkingMode;};
        tBool bIsAppStateNormal() const { return _u32AppState== AMT_C_U32_STATE_NORMAL;};
		tVoid vSetSrcFlag(tBool bSrcFlag_){bSrcFlag = bSrcFlag_;};  //NCG3D-82174
		tBool bGetSrcFlag(){return bSrcFlag;};  //NCG3D-82174

        trMsgSrvCmdSetup const &rGetCurrentSetup() const {
            return _rCurrentSetup;
        }

        tVoid vGetUserData(trMainUsrData *prMainUsrData) const;
        tVoid vSetUserData(trMainUsrData const &rMainUsrData);
        tU8 u8GetBgLearnUpdateTime() const { return _rCurrentSetup.u8BgLearnUpdateTime; }

         tVoid vEnable1sTickTimer() {
             _o1SecondTickTmr.vStart(1000, TRUE);
            _u32Num1sTickSubsribers++;
        };

        tVoid vDisable1sTickTimer() {
            if (_u32Num1sTickSubsribers) {
                _u32Num1sTickSubsribers--;
            }
            if (!_u32Num1sTickSubsribers) {
                _o1SecondTickTmr.vStop();
            }
        };
        tVoid vSetStartupLearn(tBool startupLearn);
        tBool bGetStartupLearn();

		tVoid vSetPresetOrChannelRecallRequested(ten_PresetOrChannelRecall PresetOrChannelRecallRequested) {_enPresetOrChannelRecallRequested = PresetOrChannelRecallRequested;};
        ten_PresetOrChannelRecall enGetPresetOrChannelRecallRequested() const {return _enPresetOrChannelRecallRequested;};

        tVoid vSetupEnsembleThreshold(DAB_tenEnsembleSetupType u8EnsembleSetupType,tU8 u8EnsembleThValue) const;
        tVoid vSetupMeasureMode(tBool bMeasurementMode);
#ifdef MUTE_ACTIVE
		tenMuteOperation enGetMuteOperation() const {return _enMuteOperation;};
        tenMuteOperation enGetNextMuteOperation() const {return _enNextMuteOperation;};
        void enSetMuteOperation(tenMuteOperation enMuteOp) {_enMuteOperation=enMuteOp;};
		void enSetNextMuteOperation(tenMuteOperation enMuteOp) {_enNextMuteOperation=enMuteOp;};
#endif
		tVoid vClearDatabase(tenMeca_DbConfig_ValueId enDelAction) const;	
		tVoid vClearDatabase() const;
		tVoid vSetupLinkingConfig(trMsgSrvCmdSetup* poCmdSetup) const;
        tBool bGetTestModeState() const {return _bTestModeState;};
        tVoid vsetOldChnInfo(trChnListChnInfo &_oldChninfo){ rOldChnListChnInfo=_oldChninfo; };	//Coverity 80477
        trChnListChnInfo getOldChnInfo(){ return rOldChnListChnInfo;};
        tBool bGetSourceChangingToFG(){return _bSourceChangingToFG;};
        tVoid vResetSourceChangingToFG(){_bSourceChangingToFG=FALSE;};
        tVoid vSendDelayedSourceChangeRsp();
		//PSARCC30-3968
		tVoid vResetOldChninfo()
		{
			rOldChnListChnInfo = trChnListChnInfo();
		}
		
#ifdef DABTUNER_UTEST
protected:
	dabdrv_main();
#else 
private:
	dabdrv_main();
#endif
    private:

       
        trMainUsrData _rUsrData;
        tBool _bAdrUp;
        DAB_tenSourceState _enSourceState;
        tenMeca_RdmMode _enRdmMode;
        
        tVoid vRunActivity(dabdrv_activityBase *poActivity);
        tBool bRestoreLsm(tBool bStartup = FALSE) const;
        MhQ _oMhQ;
        tBool _bTA;
        tenSourceActivity _enSourceActivity;
        tU32 _u32AppState;
        tBool _bCompMode;
        DAB_tclTimer _o1SecondTickTmr;
        DAB_tclTimer _oDeblockActivitiesTmr;
        DAB_tclTimer _oSysStoreWaitTmr;
        DAB_tclTimer _oSrcChngRspDelayTmr;
		tBool bSrcFlag;
#ifdef DAB_DRV_ENABLE_BG_DELAY
        DAB_tclTimer _oSrcStateBgDelayTmr;
#endif
        tU32 _u32OneSecondTickCount;

        tVoid vSendAvailabilityProperty() const;
		//vnd44kor : made const to solve prio 2 lint warning
        tVoid vSetRdmMode(DAB_tenSourceState enSourceState);
        tVoid vSetExpertApi();
        tVoid vCheckIfCountryZoneChnaged();

        dabdrv_activityList oActivityList;
        tBool _bBlockActivities;

        tU32 _u32Num1sTickSubsribers;
        tBool _bActivityChangedChannel;
        tBool _bGoingOFF;
        tBool _bSysRestoreDone;

        trMsgSrvCmdSetup _rCurrentSetup;

		  tBool _bSendTuneCommand;
		  tBool _bStartupLearn;

		  ten_PresetOrChannelRecall _enPresetOrChannelRecallRequested;
          tBool _bTestModeState;
		  trChnListChnInfo rOldChnListChnInfo;
		  tBool _bSourceChangingToFG;
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
		  virtual tVoid vSetServiceLinkingFromDP();
#endif
#ifdef MUTE_ACTIVE
		  tenMuteOperation _enMuteOperation;
		  tenMuteOperation _enNextMuteOperation;
		  trMsgDrvCmdRdmTune oMsgDrvTune;
		  trMsgSrvCmdChnSelect oMsgSrvSelect;
		  trMsgSrvCmdRecallPreset oMsgSrvRecallPreset;
		  trMsgSrvCmdTestOperation oMsgSrvTestOp;
		  trMsgSrvCmdLearn oMsgSrvLearnUpdate;
		  trMsgDrvCmdTuneFreqlabel oMsgTuneFreqLabel;
		  tBool vSendMuteRequest();
#endif
};

    // todo: move tick-timer to dispatcher to make in available in other threads
    template <class RECEIVER, class MSG, int SECONDS=1>
    class dabdrv_trTickTimer:
        public DAB_Singleton <dabdrv_trTickTimer<RECEIVER, MSG, SECONDS> >,
        public DAB_MessageHandlerCommon<dabdrv_trTickTimer<RECEIVER, MSG, SECONDS> >
    {
        friend class DAB_Singleton<dabdrv_trTickTimer<RECEIVER, MSG, SECONDS> >;

    public:
        DAB_TRACE_INFO_IMPL(FC_DABTUNER_TR_DRV_UTIL);

        dabdrv_trTickTimer():
            _bRunning(FALSE),
            _u32PassedSeconds(0)
        {};
        virtual char const *pcGetName() const {return RECEIVER::instance()->pcGetName();};
        tVoid vStart() {
            if (!_bRunning) {
                _bRunning=TRUE;
                DAB_vSubscribe<dabdrv_trTickTimer<RECEIVER, MSG, SECONDS> ,trMsgDrvEvt1SecondTick>();
                dabdrv_main::instance()->vEnable1sTickTimer();
            }
            _u32PassedSeconds=0;
        };
        tVoid vStop() {
            if (_bRunning) {
                _bRunning=FALSE;
                DAB_vUnSubscribe<dabdrv_trTickTimer<RECEIVER, MSG, SECONDS> ,trMsgDrvEvt1SecondTick>();
                dabdrv_main::instance()->vDisable1sTickTimer();
            }
        }
        tVoid vProcess(trMsgDrvEvt1SecondTick *) {
            if (!_bRunning) {
                return;
            }
            _u32PassedSeconds++;
            if (_u32PassedSeconds>SECONDS) {
                _u32PassedSeconds=1;
                MSG rMsg;
                this->DAB_vCallMsg(RECEIVER::instance(),&rMsg);
            }
        }

    private:
        tBool _bRunning;
        tU32 _u32PassedSeconds;
    };
} //namespace DAB 

#endif
