
/************************************************************************
 * FILE:      dabdrv_main.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of dabdrv_main
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#include "dabdrv_main.hpp"
#include "dabdrv_testOperation.hpp" // for testing
#include "dabdrv_mecaIf.h"
#include "dabdrv_db.hpp"
#include "dabdrv_rdm.hpp"
#include "dabdrv_properties.hpp"
#include "dabdrv_testmode.hpp"
#include "dabdrv_chnList.hpp"
#include "dabdrv_chnSelect.hpp"
#include "dabdrv_chnInfo.hpp"
#include "dabdrv_compList.hpp"
#include "dabdrv_compSelect.hpp"
#include "dabdrv_compInfo.hpp"
#include "dabdrv_advisory.hpp"
#include "dabdrv_presets.hpp"
#include "dabdrv_anno.hpp"
#include "dabdrv_tsu.hpp"
#include "dabdrv_persData.hpp"
#include "dabdrv_mute.hpp"
#include "dabdrv_learn.hpp"
#include "dabdrv_tmcLearn.hpp"
#include "dabdrv_tmcParse.hpp"
#include "dabdrv_tmcRead.hpp"
#include "dabdrv_tpeg.hpp"
#include "dabdrv_radioText.hpp"
#include "dabdrv_activity.hpp"
#include "dabdrv_sysStore.hpp"
#include "fc_dabtuner_config.hpp"
#include "fc_dabtuner_DiagLibSysSetListener.h"
#include "dabdrv_presets.hpp"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_DRV_MAIN 
#include "trcGenProj/Header/dabdrv_main.cpp.trc.h"
//#else
//#error
#endif

#ifndef DABTUNER_UTEST
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_fc_dabtuner_if.h"
#include "dp_generic_if.h"
#endif

//#define DAB_SINGLE_TUNER_MODE() dabdrv_learn::instance()->bGetTunerMode()

//#define DAB_ENABLE_MUTE_HANDLING
/*
CCA-State and Under-Voltage Questions

CCA-States
Prefer: 
Start Adr in bOnInit (mecaIf)
Stop Adr in bOnClose (mecaIf)
mecaIf will open Connection and Configure Everything?

OFF: start off-learn


CV: 
adr only affected by CriticalUnderVoltage?
Shall Adr be reset in this case or only if a "Ping" is not answered.

todo: timer-supervision of compMonitor


*/

namespace DAB {
    // a timer-event
    struct dabdrv_msg1SecondTick:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "  msg1SecondTick"));
        };

    };

    struct dabdrv_msgDeBlockActivities:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "  dabdrv_msgDeBlockActivities"));
        };

    };
    struct dabdrv_msgSysStoreWaitTimeOut:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "  dabdrv_msgSysStoreWaitTimeOut"));
        };

    };

	struct dabdrv_msgSrcChngRspDealyTimeout:
		public DAB_Message
	{
		DAB_DISPATCH_IMPL
		virtual tVoid vTrace() const {
			ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG,
								"  dabdrv_msgSrcChngRspDealyTimeout"));
		};

	};

#ifdef DAB_DRV_ENABLE_BG_DELAY
    struct dabdrv_msgSrcStateBgDelay:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "  dabdrv_msgSrcStateBgDelay"));
        };

    };
#endif

}


using namespace DAB;
dabdrv_main::dabdrv_main() {
    DAB_Profiler rProfiler("dabdrv_main");

    _bCompMode=FALSE;
    _bAdrUp=FALSE;
    _enSourceState=DAB_enSourceState_BG;
    _enRdmMode = enMeca_RdmMode_DAB_INACTIVE;
    _bTA = FALSE;
    _enSourceActivity = enSourceActivity_Inactive;
    _u32AppState=AMT_C_U32_STATE_INVALID;
    _u32OneSecondTickCount = 0;
    _bBlockActivities=TRUE;
    _u32Num1sTickSubsribers=0;
    _bActivityChangedChannel=FALSE;
    _bGoingOFF=FALSE;
    _bSysRestoreDone=FALSE;
    _bSendTuneCommand=TRUE;
    _bStartupLearn=FALSE;
	_enPresetOrChannelRecallRequested = PresetOrChannelRecallInvalid;
    _bTestModeState=FALSE;
    _bSourceChangingToFG = FALSE;
	bSrcFlag = FALSE;
#ifdef MUTE_ACTIVE
    _enMuteOperation=enMuteOperation_None;
    _enNextMuteOperation=enMuteOperation_None;
#endif
	


    vSubscribe<trMsgSrvCmdNewAppState>();
    vSubscribe<trMsgSrvCmdSourceState>();
    vSubscribe<trMsgSrvCmdChnSelect>();
    vSubscribe<trMsgSrvCmdCompSelect>();
    vSubscribe<trMsgSrvCmdSetup>();
    vSubscribe<trMsgDrvIndCompModeFailed>();
    vSubscribe<trMsgSrvCmdRecallPreset>();
    vSubscribe<trMsgDrvCmdChnSelectState>();
    vSubscribe<trMsgDrvCmdApplyUsrData>();
    vSubscribe<trMeca_RAudSetConcealmentLevel>();
    vSubscribe<trMsgDrvIndPreChnSelect>();
    vSubscribe<trMeca_RRdmSetMode>();
    vSubscribe<trMsgDrvCmdProcessed>();
	 vSubscribe<trMsgSrvCmdEnsSelect>();
  //vSubscribe<trMeca_RRdmSetMode>();
  vSubscribe<trMeca_RMtcSetConfig>();
  vSubscribe<trMsgDrvCmdNotifyLearnComplete>();
  vSubscribe<trMeca_RRdmGetAudioStatus>();
#ifdef DAB_ENABLE_MUTE_HANDLING
  vSubscribe<trMsgSrvCmdEnsSeek>();
#endif
#ifdef MUTE_ACTIVE
  vSubscribe<trMsgDrvMuteState>();
  vSubscribe<trMsgSrvCmdManualModeOp>();
  vSubscribe<trMsgSrvCmdLoadPreset>();
  vSubscribe<trMsgSrvCmdSrvSelect>();
  vSubscribe<trMsgSrvCmdManualLearnOp>();
  vSubscribe<trMsgSrvCmdTuneFreqlabel>();
#endif
  vSubscribe<trMeca_RDbConfig>();
  vSubscribe<trMsgDrvDeleteMemory>();	  
  vSubscribe<trMsgSrvCmdCoding>();

#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI //multi-user Simulcast
    vSubscribe<trMeca_RRdmStationSetUser>();
	vSubscribe<trMeca_RRdmStationTravelStore>();
#endif
    _oMhQ.poAdd(dabdrv_adrIf::instance());
    _oMhQ.poAdd(dabdrv_mecaIf::instance());
    _oMhQ.poAdd(dabdrv_testOperation::instance());
    _oMhQ.poAdd(dabdrv_db::instance());
    _oMhQ.poAdd(dabdrv_rdm::instance());
	_oMhQ.poAdd(dabdrv_testmode::instance());// Moved down to rdm.cpp because when rdmInfo is received Tunerstatus(frequency label) should go first and then ensemble info which is being sent from testmode.cpp
    _oMhQ.poAdd(dabdrv_properties::instance());
    _oMhQ.poAdd(dabdrv_mute::instance());
    _oMhQ.poAdd(dabdrv_chnList::instance());
    _oMhQ.poAdd(dabdrv_chnSelect::instance());
    _oMhQ.poAdd(dabdrv_chnInfo::instance());
    _oMhQ.poAdd(dabdrv_compList::instance());
    _oMhQ.poAdd(dabdrv_compSelect::instance());
    _oMhQ.poAdd(dabdrv_compInfo::instance());
    _oMhQ.poAdd(dabdrv_advisory::instance());
    _oMhQ.poAdd(dabdrv_presets::instance());
    _oMhQ.poAdd(dabdrv_anno::instance());
    _oMhQ.poAdd(dabdrv_tsu::instance());
    _oMhQ.poAdd(dabdrv_learn::instance());
    _oMhQ.poAdd(dabdrv_tmcLearn::instance());
    _oMhQ.poAdd(dabdrv_tmcParse::instance());
    _oMhQ.poAdd(dabdrv_tmcRead::instance());
    _oMhQ.poAdd(dabdrv_tpeg::instance());
    _oMhQ.poAdd(dabdrv_radioText::instance());
    _oMhQ.poAdd(dabdrv_sysStore::instance());

    /* pers-data has to be the last one, all other components should be initialized to 
       to received their persistant data */
    _oMhQ.poAdd(dabdrv_persData::instance());
    rProfiler.u32GetMs();

}

dabdrv_main::~dabdrv_main() {
    _oMhQ.vClear();
}
tVoid dabdrv_main::vTraceState() const {
    ETG_TRACE_USR1(("  dabdrv_main STATE:  _bCompMode=%d _bAdrUp=%d _enSourceState=%d _bTA=%d _enSourceActivity=%d _u32AppState=%u _u32OneSecondTickCount=%u "
                    "_bActivityChangedChannel=%d _bBlockActivities=%d _bGoingOFF=%d" ,
                    _bCompMode,
                    _bAdrUp,
                    ETG_CENUM(DAB_tenSourceState, _enSourceState),
                    _bTA,
                    ETG_CENUM(tenSourceActivity, _enSourceActivity),
                    _u32AppState,
                    _u32OneSecondTickCount,
                    _bActivityChangedChannel,
                    _bBlockActivities,
                    _bGoingOFF));



}
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
tVoid dabdrv_main::vSetLinkingMode(tBool bRdsFollowStatus) {

    if(bRdsFollowStatus){    	
		tU16 u16ServiceLinkingMode = 0;
		#ifndef DABTUNER_UTEST
			dp_tclDABTunerDPRdsStatus dpPrevRdsStatus;
	    	tU8 prvRdsStatus=0;
	    	tU32 status_rds = dpPrevRdsStatus.s32GetData(prvRdsStatus);
	    	ETG_TRACE_USR1(("dabdrv_main::vInit : status %d prvRds value = %d ",dpPrevRdsStatus.s32GetData(prvRdsStatus), prvRdsStatus));
			dp_tclDABTunerDPServiceLinkingMode oServiceLinking;
			tU32 status = oServiceLinking.s32GetData(u16ServiceLinkingMode);
			ETG_TRACE_USR1(("Status : %d",status));
			if(!status){
				//If RDS ON and service linking is stored as zero the make it as 1 (The scenario arises when RDS is disabled and enabled through CAN device)
			_rCurrentSetup.e8ServiceLinkingMode = ((u16ServiceLinkingMode == 0) && (prvRdsStatus == 0)) ?
								DAB_enServiceLinkingMode_DAB:(DAB_tenServiceLinkingMode)u16ServiceLinkingMode;
			}

			ETG_TRACE_USR1(("dabdrv_main::vInit : Startup dpservielinking value = %d ", u16ServiceLinkingMode));
		#else
			_rCurrentSetup.e8ServiceLinkingMode = u16ServiceLinkingMode ?
								(DAB_tenServiceLinkingMode)u16ServiceLinkingMode:DAB_enServiceLinkingMode_DAB;
	   #endif

    }
}
#else
#ifdef  VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
tVoid dabdrv_main::vSetLinkingMode(tBool bRdsFollowStatus) {

    if(bRdsFollowStatus){
		tU16 u16ServiceLinkingMode = 0;
		#ifndef DABTUNER_UTEST
			dp_tclDABTunerUsrDPServiceLinkingMode oServiceLinking;
			tU32 status = oServiceLinking.s32GetData(u16ServiceLinkingMode);
			ETG_TRACE_USR1(("Status : %d",status));
			if(!status){
				//If RDS ON and service linking is stored as zero the make it as 1 (The scenario arises when RDS is disabled and enabled through CAN device)
				_rCurrentSetup.e8ServiceLinkingMode = u16ServiceLinkingMode ?
									(DAB_tenServiceLinkingMode)u16ServiceLinkingMode:DAB_enServiceLinkingMode_DAB;
			}

			ETG_TRACE_USR1(("dabdrv_main::vInit : Startup dpservielinking value = %d ", u16ServiceLinkingMode));
		#else
			_rCurrentSetup.e8ServiceLinkingMode = u16ServiceLinkingMode ?
								(DAB_tenServiceLinkingMode)u16ServiceLinkingMode:DAB_enServiceLinkingMode_DAB;
		#endif
    }

}
#endif
#endif

tVoid dabdrv_main::vInit() {
    ETG_TRACE_USR1(("dabdrv_main::vInit"));

    fc_dabtuner_config *poConfig=fc_dabtuner_config::instance();
    if (OSAL_NULL ==poConfig) {
        ETG_TRACE_FATAL(("dabdrv_main::vInit config not available !!!"));
        return;
    }

    _rCurrentSetup.u32SetupMask=0;
    _rCurrentSetup.u32SetupFlags=0;
    _rCurrentSetup.bUseConcealmentLevel=TRUE;
    _rCurrentSetup.u8ConcealmentLevel= poConfig->u8GetConcealmentLevel();
    _rCurrentSetup.bUseServiceLinkingMode= poConfig->bGetSfDabFmEnable();

    vCheckIfCountryZoneChnaged();

	#if defined  VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI || defined VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
		vSetLinkingMode(poConfig->bGetRdsFollowStatus());
	#else
		_rCurrentSetup.e8ServiceLinkingMode=DAB_enServiceLinkingMode_DAB;
	#endif
    _rCurrentSetup.bUseEnsInsertThreshold=TRUE;
    _rCurrentSetup.u8EnsInsertThreshold=(poConfig->pcu8GetRdmQualityConfig()[INDEX_EIGHT] & 0x0F);
    _rCurrentSetup.bUseEnsDeleteThreshold=TRUE;
    _rCurrentSetup.u8EnsDeleteThreshold=((poConfig->pcu8GetRdmQualityConfig()[INDEX_EIGHT] & 0xF0)>>4);
    _rCurrentSetup.u8LinkingSetupMask=enLinkingSetupMask_None;
    _rCurrentSetup.u8DABFMLinkingThreshold= poConfig->pcu8GetTsuConstantsDabFm()[INDEX_FIVE];
    _rCurrentSetup.u8DABFMLinkingBackThreshold = poConfig->pcu8GetTsuConstantsFmDab()[INDEX_FIVE];
    _rCurrentSetup.u8DABFMLinkingBackValidationTime=poConfig->pcu8GetTsuConstantsDabFm()[INDEX_THREE];
    _rCurrentSetup.u8DABFMLinkBackDelay=poConfig->pcu8GetTsuConstantsFmDab()[INDEX_ZERO];
    _rCurrentSetup.bSwitchMeasurementMode=FALSE;

    _oMhQ.vInit();
    _u32OneSecondTickCount=0;

    _o1SecondTickTmr.vInit(instance(),dabdrv_msg1SecondTick());
    _oDeblockActivitiesTmr.vInit(instance(),dabdrv_msgDeBlockActivities());
    _oSysStoreWaitTmr.vInit(instance(),dabdrv_msgSysStoreWaitTimeOut());
    _oSrcChngRspDelayTmr.vInit(instance(),dabdrv_msgSrcChngRspDealyTimeout());
#ifdef DAB_DRV_ENABLE_BG_DELAY
    _oSrcStateBgDelayTmr.vInit(instance(),dabdrv_msgSrcStateBgDelay());
#endif

    DAB_vCallMsgCtor(this, trMsgDrvCmdApplyUsrData());
}

tVoid dabdrv_main::vProcess(trMsgDrvCmdApplyUsrData *poApplyUsrData) {
    (tVoid)poApplyUsrData;
    ETG_TRACE_USR1(("dabdrv_main::vProcess(trMsgDrvCmdApplyUsrData):sid=0x%08x scids=%d",
                    _rUsrData.rLastSrv.u32GetSID(),_rUsrData.rLastSrv._u16Scids));
#ifdef DAB_ENABLE_COMP_MODE_PERSISTANT
    _bCompMode=_rUsrData.bCompMode;
#else
    _bCompMode=_rUsrData.bCompMode;
#endif
    // todo: remove next line and uncomment previous line, if last-mode for component shall be enabled
    //    _bCompMode=FALSE;

    // restore chn-info
    DAB_vCallMsgCtor(trMsgDrvCmdSetChnInfoPsid(_rUsrData.rLastSrv));

    tU16 u16Scids=_rUsrData.rLastSrv._u16Scids;
    // restore comp-info
    DAB_vCallMsgCtor(trMsgDrvCmdSetCompInfoScidi(_rUsrData.rLastComp,(tBool)u16Scids,u16Scids));


    if (!_bBlockActivities) {
        bRestoreLsm();
    }

}


tVoid dabdrv_main::vDeInit() {
    ETG_TRACE_USR1(("dabdrv_main::vDeInit"));
    _o1SecondTickTmr.vDeInit();
    _oDeblockActivitiesTmr.vDeInit();
//lint -esym(793,*identifiers in one block*)
    _oSysStoreWaitTmr.vDeInit();
    _oMhQ.vDeInit();
}

tVoid dabdrv_main::vProcess(dabdrv_msg1SecondTick *poTickTmr) {
    (tVoid)poTickTmr;
    DAB_vCallMsgCtor(trMsgDrvEvt1SecondTick(_u32OneSecondTickCount++, _bAdrUp));
}

tVoid dabdrv_main::vProcess(dabdrv_msgDeBlockActivities *poDeBlockActivities) {
    (tVoid)poDeBlockActivities;

    _bBlockActivities=FALSE;
    vOnActivityRequest();

}
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
tVoid dabdrv_main::vSetServiceLinkingFromDP() {

#ifndef DABTUNER_UTEST	
	tU16 u16ServiceLinkingMode = 0;
	dp_tclDABTunerUsrDPServiceLinkingMode oServiceLinking;
	tU32 status = oServiceLinking.s32GetData(u16ServiceLinkingMode);
	ETG_TRACE_USR1(("Status : %d",status));
	if(!status){
		_rCurrentSetup.e8ServiceLinkingMode = (DAB_tenServiceLinkingMode)u16ServiceLinkingMode;
		ETG_TRACE_USR1(("dabdrv_main::vSetServiceLinkingFromDP : %d ", u16ServiceLinkingMode));
		vProcess(&_rCurrentSetup);
	}
#else
	vProcess(&_rCurrentSetup);
#endif
}
#endif

//lint -esym(793,*identifiers in one block*)
tVoid dabdrv_main::vProcess(dabdrv_msgSysStoreWaitTimeOut *poSysStoreWaitTimeOut) {
    (tVoid)poSysStoreWaitTimeOut;
    // now take source-state also internaly
    ETG_TRACE_ERR(("dabdrv_main::vProcess(dabdrv_msgSysStoreWaitTimeOut) SYS_STORE response not received"));

    trMsgSrvRspAppStateReached rAppStateReached(AMT_C_U32_STATE_OFF);
    DAB_vCallMsg(rAppStateReached);
    _bGoingOFF=FALSE;
}

tVoid dabdrv_main::vProcess(dabdrv_msgSrcChngRspDealyTimeout */*poSrcChngRspDealyTimeout*/) {

	ETG_TRACE_ERR(("dabdrv_main::vProcess(dabdrv_msgSrcChngRspDealyTimeout"));
	trMsgSrvRspSrcState rSrcRsp;
	rSrcRsp.enSourceState=DAB_enSourceState_FG;
	DAB_vCallMsg(rSrcRsp);
}
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
tVoid dabdrv_main::vProcess(DAB::trMeca_RRdmStationSetUser* povSetUser) {
	tU8 currentUserId=0;
#ifndef DABTUNER_UTEST
	dp_tclSrvIf objUserInfo;
	tS32 s32Status = objUserInfo.s32GetEndUser(currentUserId);
	ETG_TRACE_USR4(("dabdrv_main::vProcess(trMeca_RRdmStationSetUser s32Status=%d",s32Status));
#endif
	if(currentUserId == povSetUser->u8UserId)
	{
		ETG_TRACE_ERR(("dabdrv_main::vProcess(trMeca_RRdmStationSetUser"));
		vSetServiceLinkingFromDP();
	}
}


tVoid dabdrv_main::vProcess(trMeca_RRdmStationTravelStore* poTravelStore){
	ETG_TRACE_USR1(("dabdrv_main::vProcess(trMeca_RRdmStationTravelStore"));

	switch(poTravelStore->enTravelStoreState){
	case enMeca_RdmTravelStoreState_DONE:
	case enMeca_RdmTravelStoreState_STARTED:
		{
			tU8 currentUserId=0;
#ifndef DABTUNER_UTEST
			dp_tclSrvIf objUserInfo;
			tS32 s32Status = objUserInfo.s32GetEndUser(currentUserId);
			ETG_TRACE_USR1(("dabdrv_main::vProcess(trMeca_RRdmStationTravelStore) s32Status =%d",s32Status));
#endif
			if((poTravelStore->u8Mode == (tU8) DAB_enProfile_Delete) && (dabdrv_presets::instance()->u8GetUserId() == currentUserId)){// Update ADR only when the delete profile is the current profile
				vSetServiceLinkingFromDP();			
			}
			break;
		}
	case enMeca_RdmTravelStoreState_COMMAND_REJECTED:
	case enMeca_RdmTravelStoreState_STOPPED:
	default:
		break;
	}
}
#endif

tVoid dabdrv_main::vSendAvailabilityProperty() const {
    DAB_trAvailabilityProperty oAvailabilityProperty = dabdrv_properties::instance()->oAvailabilityProperty.oGet();
    oAvailabilityProperty.bIsDABAvailable=_bAdrUp;
    oAvailabilityProperty.enSourceState=_enSourceState;
    dabdrv_properties::instance()->oAvailabilityProperty.vSet(oAvailabilityProperty);
}

tVoid dabdrv_main::vProcess(trMsgDrvAdrUp*) {
    if (!_bAdrUp) {
        _bAdrUp=TRUE;
        DAB_vCallMsgCtor(trMsgDrvStartComponentFirst());
         vProcess(&_rCurrentSetup);
        tU32 u32Sid=dabdrv_chnInfo::instance()->rGetCurrentSid().u32GetSID();
        tU8 u8Options= _bCompMode ? 2 : 0;
        ETG_TRACE_USR1(("dabdrv_main(trMsgDrvAdrUp) SID=0x%08x scids %d u8Options = %d _enSourceState=%d", u32Sid,dabdrv_chnInfo::instance()->rGetChnInfo().u16Scids,u8Options,_enSourceState));
#ifdef DAB_DRV_ENABLE_PRESET_0
		tU8 currentUserId=0;
		#ifndef DABTUNER_UTEST	
			dp_tclSrvIf objUserInfo;
			tS32 s32Status = objUserInfo.s32GetEndUser(currentUserId);
			ETG_TRACE_USR1(("dabdrv_presets::trMsgDrvStartComponent retvalue %d currentUserId=%d",s32Status,currentUserId));
			if( s32Status == DP_S32_NO_ERR && currentUserId<NUMBER_OF_USERS){
				DAB_vCallMsgCtor(trMsgDrvCmdSysReStore(currentUserId));
			}else{
    			ETG_TRACE_USR4(("dabdrv_presets::trMsgDrvStartComponent Data pool read error %d ",s32Status));
			}
		#else
			if(currentUserId<NUMBER_OF_USERS){
				DAB_vCallMsgCtor(trMsgDrvCmdSysReStore(currentUserId));
			}
		#endif
//During ADR reset source if source is foreground, rRdmSetMode should be foreground audio.
	    trMeca_CRdmSetMode rRdmSetMode;

        if(_enSourceState == DAB_enSourceState_FG){
        	rRdmSetMode.enRdmMode = enMeca_RdmMode_DAB_FG_AUDIO;
			dabdrv_mecaIf::instance()->vSendMecaCommand(rRdmSetMode);
        	dabdrv_mecaIf::instance()->vSendMecaCommandCtor(trMeca_CRdmStationPlay(0,u8Options));
        }
		else
		{
			rRdmSetMode.enRdmMode = enMeca_RdmMode_DAB_BG_AUDIO;
			dabdrv_mecaIf::instance()->vSendMecaCommand(rRdmSetMode);
        }
        dabdrv_mecaIf::instance()->vSendMecaCommandCtor(trMeca_CRdmGetRdmInfo());
#endif
        vSendAvailabilityProperty();
        DAB_vCallMsgCtor(trMsgDrvStartComponent());
        // set LSM
        bRestoreLsm(TRUE);
        _oDeblockActivitiesTmr.vStart(3000);

        // workaround cause ADR3 starts initial in foreground mode
       // vSetRdmMode( _enSourceState );
		
		
        trMsgDrvCmdSetRdmNotifyMode rRdmNotifyMode(enRdmNotifyMode_Normal);
        DAB_vCallMsg(rRdmNotifyMode);

        //Send the coding command response once all the components are started.
        DAB_vCallMsgCtor(trMsgSrvResultRsp(DAB_enResult_OK));

    }

}

tVoid dabdrv_main::vProcess(trMsgDrvAdrDown*) {
    if (_bAdrUp) {
        _bAdrUp=FALSE;
        _bBlockActivities=TRUE;
        _bCompMode=FALSE;
        _oDeblockActivitiesTmr.vStop();
        vSendAvailabilityProperty();
         DAB_vCallMsgCtor(trMsgDrvStopComponent());
    }
}


tVoid dabdrv_main::vProcess(trMsgSrvCmdSourceState* poSrvCmdSourceState) {
	if((poSrvCmdSourceState->enSourceState == DAB_enSourceState_DAB_LEARN_FOREVER) || (poSrvCmdSourceState->enSourceState == DAB_enSourceState_DAB_BG_LEARN_FOREVER))
	{
		trMeca_CRdmLearn oCRdmLearn;
		oCRdmLearn.enLearnCommand = poSrvCmdSourceState->enSourceState == DAB_enSourceState_DAB_LEARN_FOREVER ? enMeca_RdmLearnCommand_LEARN_FOREVER_START : enMeca_RdmLearnCommand_BG_FOREVER_LEARN_START;
		dabdrv_mecaIf::instance()->vSendMecaCommand(oCRdmLearn);
		return;
	}
	_enSourceState=poSrvCmdSourceState->enSourceState;
    ETG_TRACE_USR1(("dabdrv_main::vProcess(trMsgSrvCmdSourceState) enSourceState=%d",
                    ETG_CENUM(DAB_tenSourceState, _enSourceState)));
        vSendAvailabilityProperty();
	#ifdef MUTE_ACTIVE
		/*when DAB is going to BG running rdmtune command tobe stopped*/
	if((_enSourceState== DAB_enSourceState_BG)&&
	   (_enMuteOperation == enMuteOperation_ManualTune)){
		oMsgSrvTestOp.enTestOperation=DAB_enTestOperation_TUNE_ENSEMBLE;
		oMsgSrvTestOp.u32Value1=1;
		oMsgSrvTestOp.u32Value2=0;
		oMsgSrvTestOp.u32Value3=1;	
		DAB_vCallMsg(oMsgSrvTestOp);	
// PSARCC30-1872 - If band change is done before the response is recieved for staion selection, Mute operation
// should not be changed to None as in the demute function method result will not be sent.			
	}else if(_enSourceState== DAB_enSourceState_FG){
		bSrcFlag = TRUE;  //NCG3D-82174
		_enMuteOperation = enMuteOperation_None;
	}

	#endif
	//Clear ensemble label
	DAB_trEnsembleInfoProperty rProperty=dabdrv_properties::instance()->oEnsembleInfoProperty.oGet();
	rProperty.rEnsembleLabel.bLabelValid = FALSE;
	dabdrv_properties::instance()->oEnsembleInfoProperty.vSet(rProperty);

	//Send the Mtctu8nerstatus only in case of FG and BG to reset Mtc Tuner status
	trMsgSrvCmdMtcTunerstatus rTunerstaus;
	fc_dabtuner_config* poConfig = fc_dabtuner_config::instance();
	if(_enSourceState ==  DAB_enSourceState_FG){
		//if condition to check empty channel is not required anymore.
		//it will be initiated from Persistent data
		//in one use case: During the first startup when DAB is in background DAB will be tuned to some station and
		//it will be update in _rPreselectChannelInfo when it comes to DAB FG it tries to play BG tuned channel.
		//So Better make it NULL
		rOldChnListChnInfo.vTrace();
		//poConfig->bGetSfFmDabEnable()  NCG3D-55828
		//In case of continues station select press if it goes to FM back to DAB
		//old channel info is replacing and leading to Wrong channel info
		if(poConfig->bGetSfFmDabEnable() && rOldChnListChnInfo.rMecaId.bIsValid())
		{
			dabdrv_chnInfo::instance()->vSetPreselectChnInfo(rOldChnListChnInfo);		
		}
		rTunerstaus.enTunerStatus = enMeca_MtcTuner_MAIN_DAB_TUNER;
		DAB_vCallMsg(rTunerstaus);
	}else if(_enSourceState !=  DAB_enSourceState_FG){//can be BG or BG_ANNO
		//NCG3D-55828
		if(poConfig->bGetSfFmDabEnable()){
		rOldChnListChnInfo = dabdrv_chnInfo::instance()->vGetPreselectChnInfo();
		rOldChnListChnInfo.vTrace();
	}
		rTunerstaus.enTunerStatus = enMeca_MtcTuner_MAIN_FM_TUNER;
				DAB_vCallMsg(rTunerstaus);
	}
	// For DAB_LEARN_FOREVER and DAB_BG_LEARN_FOREVER, rdm mode should not be updated.

    vSetRdmMode( _enSourceState );

}


    
tVoid dabdrv_main::vProcess(trMsgSrvCmdEnsSelect *poSrvCmdEnsSelect)
{
	 trMsgDrvCmdEnsSelect rDrvCmdEnsSelect(*poSrvCmdEnsSelect);
	 DAB_vCallMsg(rDrvCmdEnsSelect);
	 trMsgSrvRspEnsSelect rSrvRsp(rDrvCmdEnsSelect.enRes);
    DAB_vCallMsg(rSrvRsp);
}


tVoid dabdrv_main::vProcess(trMsgSrvCmdChnSelect *poSrvCmdChnSelect) {
    trMsgDrvCmdChnSelect rDrvCmdChnSelect(*poSrvCmdChnSelect);
    DAB_vCallMsg(rDrvCmdChnSelect);

	_enPresetOrChannelRecallRequested = ChannelRecall;

	//Clear ensemble label
	DAB_trEnsembleInfoProperty rProperty=dabdrv_properties::instance()->oEnsembleInfoProperty.oGet();
	rProperty.rEnsembleLabel.bLabelValid = FALSE;
	dabdrv_properties::instance()->oEnsembleInfoProperty.vSet(rProperty);

    //trMsgSrvRspChnSelect rSrvRsp(rDrvCmdChnSelect.enRes);
    //DAB_vCallMsg(rSrvRsp);
}

tVoid dabdrv_main::vProcess(trMsgSrvCmdCompSelect *poSrvCmdCompSelect) {
    trMsgDrvCmdCompSelect rDrvCmdCompSelect(*poSrvCmdCompSelect);
    DAB_vCallMsg(rDrvCmdCompSelect);
    trMsgSrvRspCompSelect rSrvRsp(rDrvCmdCompSelect.enRes);
    DAB_vCallMsg(rSrvRsp);
}


tVoid dabdrv_main::vProcess(trMsgSrvCmdSetup* poCmdSetup) {

    poCmdSetup->enRes=DAB_enResult_OK;
    _bTestModeState = poCmdSetup->bIsTestMode;

    ETG_TRACE_USR1(("dabdrv_main::vProcess(trMsgSrvCmdSetup)"));


    fc_dabtuner_config *poConfig=fc_dabtuner_config::instance();

    if (OSAL_NULL ==poConfig) {
		ETG_TRACE_FATAL(("dabdrv_main::vProcess(trMsgSrvCmdSetup) config not available !!!"));
		return;
	}

    /* Concealment Level */
    if (poCmdSetup->bUseConcealmentLevel) {
        ETG_TRACE_USR1(("dabdrv_main::vProcess(trMsgSrvCmdSetup) concealment level %d ", 
                        poCmdSetup->u8ConcealmentLevel));


        
        _rCurrentSetup.u8ConcealmentLevel = poConfig->u8GetConcealmentLevel();

        trMeca_CAudSetConcealmentLevel rAudSetConcealmentLevel(_rCurrentSetup.u8ConcealmentLevel);
        dabdrv_mecaIf::instance()->vSendMecaCommand(rAudSetConcealmentLevel);
     }
if(!dabdrv_testmode::instance()->bIsTestmodeActive()){

#ifndef DABTUNER_UTEST
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
	dp_tclDABTunerDPServiceLinkingMode oServiceLinking;
#else
	dp_tclDABTunerUsrDPServiceLinkingMode oServiceLinking;
#endif
	tU32 status = oServiceLinking.s32SetData(poCmdSetup->e8ServiceLinkingMode);
	ETG_TRACE_USR1(("Status : %d",status));
	ETG_TRACE_USR1(("dabdrv_main:trMsgSrvCmdSetup User Set ServicelinkinghModeValue %d ", poCmdSetup->e8ServiceLinkingMode));
	dp_tclDABTunerDPRdsStatus dpPrevRdsStatus;
	status = dpPrevRdsStatus.s32SetData(poConfig->bGetRdsFollowStatus());

#endif

}

    /* Service Linking Mode */
    if (poCmdSetup->bUseServiceLinkingMode) {
		ETG_TRACE_USR1(("dabdrv_main::vProcess(trMsgSrvCmdSetup) service linking %d",
                        ETG_CENUM(DAB_tenServiceLinkingMode, poCmdSetup->e8ServiceLinkingMode)));
              
        ETG_TRACE_USR1(("dabdrv_main::vProcess(trMsgSrvCmdSetup) SET_SF DAB %d  FM %d", 
                            DAB_bDoSrvLinkingDab(poCmdSetup->e8ServiceLinkingMode),
                            DAB_bDoSrvLinkingFm(poCmdSetup->e8ServiceLinkingMode)));
		_rCurrentSetup.e8ServiceLinkingMode = poCmdSetup->e8ServiceLinkingMode;               
		
        // enable/disable service linking DAB-DAB in RDM
		if((_rCurrentSetup.e8ServiceLinkingMode == DAB_enServiceLinkingMode_DAB)
			|| (_rCurrentSetup.e8ServiceLinkingMode == DAB_enServiceLinkingMode_DAB_FM)
		){
			trMsgDrvCmdEnableDabSrvFollow rMsgEnableSrvFollow(TRUE);
			DAB_vCallMsg(rMsgEnableSrvFollow);
		}
		else {
			trMsgDrvCmdEnableDabSrvFollow rMsgEnableSrvFollow(FALSE);
			DAB_vCallMsg(rMsgEnableSrvFollow);
		}
        
		/*if((poCmdSetup->e8ServiceLinkingMode != DAB_enServiceLinkingMode_DAB_FM) && 
			(poCmdSetup->e8ServiceLinkingMode != DAB_enServiceLinkingMode_OFF)){
			// enable/disable service following DAB-FM in MTC
			trMsgSrvCmdMtcMode rMsgMtcConfig((DAB_tenMtcMode)DAB_bDoSrvLinkingFm(poCmdSetup->e8ServiceLinkingMode));
			DAB_vCallMsg(rMsgMtcConfig);
		}*/
    }

    /* Ensemble Insertion/Deletion Threshold */
    DAB_tenEnsembleSetupType u8EnsembleSetupType=DAB_enEnsSetupType_INVALID;
    if (poCmdSetup->bUseEnsInsertThreshold)
    {
    	u8EnsembleSetupType=DAB_enEnsSetupType_INSERTION;
    	_rCurrentSetup.u8EnsInsertThreshold=poCmdSetup->u8EnsInsertThreshold;
    	vSetupEnsembleThreshold(u8EnsembleSetupType,_rCurrentSetup.u8EnsInsertThreshold);
    }
    else if(poCmdSetup->bUseEnsDeleteThreshold)
    {
    	u8EnsembleSetupType=DAB_enEnsSetupType_DELETION;
    	_rCurrentSetup.u8EnsDeleteThreshold=poCmdSetup->u8EnsDeleteThreshold;
    	vSetupEnsembleThreshold(u8EnsembleSetupType,_rCurrentSetup.u8EnsDeleteThreshold);
    }

    //BG Learn Update Time
    if(poCmdSetup->bBgLearnUpdateTime && poCmdSetup->u8BgLearnUpdateTime<=100)
    {
    	_rCurrentSetup.u8BgLearnUpdateTime=poCmdSetup->bBgLearnUpdateTime;
    	DAB_trSetupStatusProperty oSetupStatusProperty = dabdrv_properties::instance()->oSetupStatusProperty.oGet();
    	oSetupStatusProperty.u8BgLearnUpdateTime=_rCurrentSetup.u8BgLearnUpdateTime;
    	ETG_TRACE_USR1(("dabdrv_main::vProcess(trMsgSrvCmdSetup) u8BgLearnUpdateTime=%d",
    	    					poCmdSetup->u8BgLearnUpdateTime));
    }
    else
    {
    	ETG_TRACE_USR1(("dabdrv_main::vProcess(trMsgSrvCmdSetup) Invalid u8BgLearnUpdateTime=%d",
    	    	    					poCmdSetup->u8BgLearnUpdateTime));
    }

    //DAB Scan Threshold
	if(poCmdSetup->bDABScanThreshold)
	{
		_rCurrentSetup.u8DABScanThreshold=poCmdSetup->u8DABScanThreshold;
		DAB_trSetupStatusProperty oSetupStatusProperty = dabdrv_properties::instance()->oSetupStatusProperty.oGet();
		oSetupStatusProperty.u8DABScanThreshold=_rCurrentSetup.u8DABScanThreshold;
		ETG_TRACE_USR1(("dabdrv_main::vProcess(trMsgSrvCmdSetup) u8DABScanThreshold=%d",
								poCmdSetup->u8DABScanThreshold));
		poConfig->vSetDABScanThreshold(poCmdSetup->u8DABScanThreshold);
	}

    /* Measurement mode */
	_rCurrentSetup.bSwitchMeasurementMode = poCmdSetup->bSwitchMeasurementMode;
	vSetupMeasureMode(poCmdSetup->bSwitchMeasurementMode);

	_rCurrentSetup.u8LinkingSetupMask = poCmdSetup->u8LinkingSetupMask;
	vSetupLinkingConfig(poCmdSetup);
	if((poCmdSetup->u8LinkingSetupMask) && (poCmdSetup->u8LinkingSetupMask != enLinkingSetupMask_None))
	{
		trMeca_CMtcSetConfig rMtcCfg( poConfig->pcu8GetTsuMatrixDabFm(),
													  poConfig->pcu8GetTsuMatrixFmDab(),
													  poConfig->pcu8GetTsuConstantsDabFm(),
													  poConfig->pcu8GetTsuConstantsFmDab());
		dabdrv_mecaIf::instance()->vSendMecaCommand(rMtcCfg);
		}
	}
tVoid dabdrv_main::vSetupLinkingConfig(trMsgSrvCmdSetup* poCmdSetup) const{
	fc_dabtuner_config *poConfig=fc_dabtuner_config::instance();
	ETG_TRACE_USR1(("dabdrv_main::vProcess(trMsgSrvCmdSetup) poCmdSetup->u8LinkingSetupMask=0x%x",
				poCmdSetup->u8LinkingSetupMask));
	if (OSAL_NULL ==poConfig) {
		ETG_TRACE_FATAL(("dabdrv_main::vProcess(trMsgSrvCmdSetup) config not available !!!"));
		return;
	}

	 /* Linking Setup */
	if(poCmdSetup->u8LinkingSetupMask)
	{
	switch(poCmdSetup->u8LinkingSetupMask)
	{
		case enLinkingSetupMask_None:
		{
			ETG_TRACE_USR4(("dabdrv_main::vProcess(trMsgSrvCmdSetup): poCmdSetup->u8LinkingSetupMask=%d",
					poCmdSetup->u8LinkingSetupMask));
			break;
		}

		case enLinkingSetupMask_DAB_FM_LINKING_Threshold:
		{
			poConfig->vSetDabFmLinkingThreshold(poCmdSetup->u8DABFMLinkingThreshold); //DAB-FM

			break;
		}

		case enLinkingSetupMask_DAB_FM_Link_Back_Delay:
		{
			poConfig->vSetDabFmLinkBackDelay(poCmdSetup->u8DABFMLinkBackDelay);  //FM-DAB

			break;
		}

		case enLinkingSetupMask_DAB_FM_LINKING_BACK_Threshold:
		{
			poConfig->vSetDabFmLinkBackThreshold(poCmdSetup->u8DABFMLinkingBackThreshold);  //FM-DAB

			break;
		}

		case enLinkingSetupMask_DAB_FM_LINKING_BACK_Validation_Time:
		{
			poConfig->vSetDABFMLinkingBackValidationTime(poCmdSetup->u8DABFMLinkingBackValidationTime);  //DAB-FM

			break;
		}

		default:
			break;


		}
	}
}

tVoid dabdrv_main::vSetupMeasureMode(tBool bMeasurementMode){
	fc_dabtuner_config *poConfig=fc_dabtuner_config::instance();

	if (OSAL_NULL ==poConfig) {
		ETG_TRACE_FATAL(("dabdrv_main::vProcess(trMsgSrvCmdSetup) config not available !!!"));
		return;
	}

   if(bMeasurementMode && !_rCurrentSetup.bSwitchMeasurementMode)
   {
		_rCurrentSetup.bSwitchMeasurementMode=bMeasurementMode;
		ETG_TRACE_USR1(("dabdrv_main::vProcess(trMsgSrvCmdSetup) bSwitchMeasurementMode=%d",
				bMeasurementMode));

		poConfig->vSetSfDabDabEnable(DAB_bDoSrvLinkingDab(DAB_enServiceLinkingMode_OFF));
		poConfig->vSetSfDabFmEnable(DAB_bDoSrvLinkingFm(DAB_enServiceLinkingMode_OFF));

		// disable service following DAB-DAB in RDM
		trMsgDrvCmdEnableDabSrvFollow rMsgEnableSrvFollow(DAB_bDoSrvLinkingDab(DAB_enServiceLinkingMode_OFF));
		ETG_TRACE_USR1(("dabdrv_main::vProcess(trMsgSrvCmdSetup) rMsgEnableSrvFollow.bEnable=%d",
				rMsgEnableSrvFollow.bEnable));
		DAB_vCallMsg(rMsgEnableSrvFollow);
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_SUZUKI
		// disable service following DAB-FM in MTC
		trMsgSrvCmdMtcMode rMsgMtcConfig((DAB_tenMtcMode)DAB_bDoSrvLinkingFm(DAB_enServiceLinkingMode_OFF));
		DAB_vCallMsg(rMsgMtcConfig);
#endif
		//Switch off learn
		trMsgSrvCmdLearn oCmdLearn(enLearnType_OFF);
		ETG_TRACE_USR4(("dabdrv_main::vProcess(trMsgSrvCmdSetup): enLearnType=%u",
						ETG_CENUM(tenLearnType, oCmdLearn.enLearnType)));
		DAB_vCallMsg(oCmdLearn);

	}
	else if(!bMeasurementMode && _rCurrentSetup.bSwitchMeasurementMode)
	{
		_rCurrentSetup.bSwitchMeasurementMode=bMeasurementMode;

		poConfig->vSetSfDabDabEnable(DAB_bDoSrvLinkingDab(_rCurrentSetup.e8ServiceLinkingMode));
		poConfig->vSetSfDabFmEnable(DAB_bDoSrvLinkingFm(_rCurrentSetup.e8ServiceLinkingMode));
		 // enable/disable service following DAB / DAB-FM in RDM
		trMsgDrvCmdEnableDabSrvFollow rMsgEnableSrvFollow(DAB_bDoSrvLinkingDab((DAB_tenServiceLinkingMode)poConfig->enReadSfMode()));
		DAB_vCallMsg(rMsgEnableSrvFollow);

#ifdef VARIANT_S_FTR_ENABLE_FEATURE_SUZUKI

		// enable/disable service following DAB-FM in MTC
		trMsgSrvCmdMtcMode rMsgMtcConfig((DAB_tenMtcMode)DAB_bDoSrvLinkingFm(_rCurrentSetup.e8ServiceLinkingMode));
		DAB_vCallMsg(rMsgMtcConfig);
#endif
		//Switch on learn
		trMsgSrvCmdLearn oCmdLearn(enLearnType_UPDATE);
		ETG_TRACE_USR4(("dabdrv_main::vProcess(trMsgSrvCmdSetup): enLearnType=%u",
						ETG_CENUM(tenLearnType, oCmdLearn.enLearnType)));
		DAB_vCallMsg(oCmdLearn);
	}
}

tVoid dabdrv_main::vSetupEnsembleThreshold(DAB_tenEnsembleSetupType u8EnsembleSetupType,tU8 u8EnsembleThValue) const
{
	fc_dabtuner_config *poConfig=fc_dabtuner_config::instance();
	if (OSAL_NULL ==poConfig) {
		ETG_TRACE_FATAL(("dabdrv_main::vSetupEnsembleThreshold config not available !!!"));
		return;
	}

	if(u8EnsembleSetupType!=DAB_enEnsSetupType_INVALID)
	{
		if((((DAB_tenEnsThreshold)u8EnsembleThValue>=DAB_tenEnsThreshold_LevelMin1) &&
				((DAB_tenEnsThreshold)u8EnsembleThValue<=DAB_tenEnsThreshold_LevelMax1)) ||
				(((DAB_tenEnsThreshold)u8EnsembleThValue>=DAB_tenEnsThreshold_LevelMin2) &&
				((DAB_tenEnsThreshold)u8EnsembleThValue<=DAB_tenEnsThreshold_LevelMax2)))
		{
			tU8 u8QualityConfig = poConfig->pcu8GetRdmQualityConfig()[8];

			if (u8EnsembleSetupType==(tU8)DAB_enEnsSetupType_INSERTION) {
				tU8 u8FinalEnsThValue=(tU8)(((u8QualityConfig & 0xF0)|u8EnsembleThValue));
				ETG_TRACE_USR1(("dabdrv_main::vSetupEnsembleThreshold u8FinalEnsThValue=0x%x",
						u8FinalEnsThValue));
				poConfig->vSetEnsembleQuality(u8FinalEnsThValue);
			}
			else if(u8EnsembleSetupType==(tU8)DAB_enEnsSetupType_DELETION){
				tU8 u8FinalEnsThValue=(tU8)(((u8QualityConfig & 0x0F)|(u8EnsembleThValue<<4)));
				ETG_TRACE_USR1(("dabdrv_main::vSetupEnsembleThreshold u8FinalEnsThValue=0x%x",
						u8FinalEnsThValue));
				poConfig->vSetEnsembleQuality(u8FinalEnsThValue);
			}

			trMeca_CRdmQualityConfig rQualityConfig;
			rQualityConfig.enMecaQualityConfigCmd = tenMeca_RdmQualityConfigCmd_SET;
			rQualityConfig.u8QualityStrategy = *poConfig->pcu8GetRdmQualityStrategy();
			rQualityConfig.u8DataFieldLen = *poConfig->pcu8GetRdmQualityConfigDataLength();
			OSAL_pvMemoryCopy(rQualityConfig.au8DataField, (poConfig->pcu8GetRdmQualityConfig()), sizeof(rQualityConfig.au8DataField));

			ETG_TRACE_USR4(("dabdrv_rdm::vSetRdmQualityConfig(trMeca_CRdmQualityConfig) : %*p" ,ETG_LIST_LEN(rQualityConfig.u8DataFieldLen),ETG_LIST_PTR_T8(rQualityConfig.au8DataField)));
			dabdrv_mecaIf::instance()->vSendMecaCommand(rQualityConfig);
		}
		else
		{
			ETG_TRACE_USR1(("dabdrv_main::vSetupEnsembleThreshold Invalid Threshold Value u8EnsembleThValue=0x%x",
					u8EnsembleThValue));
		}
	}
}

tVoid dabdrv_main::vProcess(trMeca_RMtcSetConfig* poRMtcSetConfig) {

    fc_dabtuner_config *poConfig=fc_dabtuner_config::instance();
    if (OSAL_NULL ==poConfig) {
        ETG_TRACE_FATAL(("dabdrv_main::vProcess(trMeca_RMtcSetConfig) config not available !!!"));
    }
    else if(poRMtcSetConfig->bConfigOk)
    {
		DAB_trSetupStatusProperty oSetupStatusProperty = dabdrv_properties::instance()->oSetupStatusProperty.oGet();
		oSetupStatusProperty.u8DABFMLinkingThreshold=poConfig->pcu8GetTsuConstantsDabFm()[INDEX_FIVE];
		oSetupStatusProperty.u8DABFMLinkBackDelay=poConfig->pcu8GetTsuConstantsFmDab()[INDEX_ZERO];
		oSetupStatusProperty.u8DABFMLinkingBackThreshold=poConfig->pcu8GetTsuConstantsFmDab()[INDEX_FIVE];
		oSetupStatusProperty.u8DABFMLinkingBackValidationTime=poConfig->pcu8GetTsuConstantsDabFm()[INDEX_THREE];
		dabdrv_properties::instance()->oSetupStatusProperty.vSet(oSetupStatusProperty);

		ETG_TRACE_USR1(("dabdrv_main::vProcess(trMeca_RMtcSetConfig) u8DABFMLinkingThreshold=%d u8DABFMLinkBackDelay=%d"
				"u8DABFMLinkingBackThreshold=%d u8DABFMLinkingBackValidationTime=%d",
				oSetupStatusProperty.u8DABFMLinkingThreshold,
				oSetupStatusProperty.u8DABFMLinkBackDelay,
				oSetupStatusProperty.u8DABFMLinkingBackThreshold,
			    oSetupStatusProperty.u8DABFMLinkingBackValidationTime));
    }
    else
    {
    	ETG_TRACE_USR1(("dabdrv_main::vProcess(trMeca_RMtcSetConfig) bConfigOk=%d",poRMtcSetConfig->bConfigOk));
    }

}


tVoid dabdrv_main::vProcess(trMsgDrvIndCompModeFailed* ) {
    if (!_bCompMode) {
        return;
    }
    // component is no longer available, try primary componentt
    _bCompMode=FALSE;
    bRestoreLsm();
}


tVoid dabdrv_main::vProcess(trMsgSrvCmdRecallPreset* poCmdRecallPreset) {
    (tVoid)poCmdRecallPreset;

	//Clear ensemble label
	DAB_trEnsembleInfoProperty rProperty=dabdrv_properties::instance()->oEnsembleInfoProperty.oGet();
	rProperty.rEnsembleLabel.bLabelValid = FALSE;
	dabdrv_properties::instance()->oEnsembleInfoProperty.vSet(rProperty);

}



tVoid dabdrv_main::vProcess(trMeca_RAudSetConcealmentLevel* poRAudSetConcealmentLevel) {

    ETG_TRACE_USR1(("dabdrv_main::vProcess(trMeca_RAudSetConcealmentLevel) Concealment=%d",
                        poRAudSetConcealmentLevel->u8ConcealmentLevel));

    fc_dabtuner_config *poConfig=fc_dabtuner_config::instance();
    if (OSAL_NULL ==poConfig) {
        ETG_TRACE_FATAL(("dabdrv_main::vProcess(trMeca_RAudSetConcealmentLevel) config not available !!!"));
    }
    else {
        poConfig->vSetConcealmentLevel(poRAudSetConcealmentLevel->u8ConcealmentLevel);
    }

    DAB_trSetupStatusProperty oSetupStatusProperty = dabdrv_properties::instance()->oSetupStatusProperty.oGet();
    oSetupStatusProperty.u8ConcealmentLevel=poRAudSetConcealmentLevel->u8ConcealmentLevel;
    dabdrv_properties::instance()->oSetupStatusProperty.vSet(oSetupStatusProperty);
}

tVoid dabdrv_main::vProcess(trMsgDrvIndPreChnSelect* poCmdPreChnSelect) {
    _bCompMode=poCmdPreChnSelect->bCompMode;
}


tVoid dabdrv_main::vProcess(trMsgDrvCmdChnSelectState *poChnSelectState) {
    (tVoid)poChnSelectState;
#if 0
    if (!poChnSelectState->bCompMode && _bCompMode && poChnSelectState->enChnState==enChnState_Stable) {
        // register monitor to get informed when channel becomes available
        trMsgDrvCmdCompListScidiMonitor rMonitor(trMecaId(dabdrv_compInfo::instance()->rGetCompInfo().rMecaId));
        DAB_vCallMsg(rMonitor);
    }
#endif
}
tBool dabdrv_main::bRestoreLsm(tBool bStartup) const {
    tU32 u32Sid=dabdrv_chnInfo::instance()->rGetCurrentSid().u32GetSID();
    ETG_TRACE_USR1(("dabdrv_main::bRestoreLsm SID=0x%08x",
                    u32Sid));

	tBool bAutoStorePending = dabdrv_db::instance()->bGetAutoStorePendingStatus();
    if((!u32Sid)&&
		(!bAutoStorePending))
	{
		dabdrv_presets::instance()->vSetAutoStoreType(enAutostore_Initial);

    	 ETG_TRACE_USR1(("dabdrv_main::bRestoreLsm SID=0x%08x",
    	                    u32Sid));    
		/*delete ensemble+services+components memory*/
		vClearDatabase(enMeca_DbConfig_ValueId_delete_All);
		/*delete preset memory*/
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_VW_MIBE
		vClearDatabase(enMeca_DbConfig_ValueId_delete_presets);
#endif
    
		return TRUE;
	}

    else if((u32Sid)&&(!bStartup))
    {
        tU16 u16Scids=dabdrv_chnInfo::instance()->vGetPreselectChnInfo().u16Scids;
        ETG_TRACE_USR1(("dabdrv_main::bRestoreLsm u16Scids=%d",
    	                    u16Scids)); 
		trMsgDrvCmdChnSelect oChnSelect;
		oChnSelect.enChnSelectSource=enChnSelectSource_Lsm;
		oChnSelect.enChnSelectMode= enChnSelectMode_Psid;
		oChnSelect.u32Value=u32Sid;
        oChnSelect.u16scids = u16Scids;
		DAB_vCallMsg(oChnSelect);




		/*if (_bCompMode) {
			trMecaId rScidi;
			tU16 u16Scidi= dabdrv_compInfo::instance()->rGetCompInfo().rMecaId.u16GetScidi();
			ETG_TRACE_USR1(("dabdrv_main::bRestoreLsm rScidi=0x%04x",
							u16Scidi));
			trMsgDrvCmdCompSelect oCompSelect;
			oCompSelect.enChnSelectSource=enChnSelectSource_Lsm;
			oCompSelect.enChnSelectMode= enChnSelectMode_Psid;
			oCompSelect.u32Value=u16Scidi;
			DAB_vCallMsg(oCompSelect);

		}*/

		return (oChnSelect.enRes==DAB_enResult_OK || oChnSelect.enRes==DAB_enResult_INPROCESS);
    }
	else
	{
		ETG_TRACE_USR1(("dabdrv_main::bRestoreLsm Initial Autostore still Running"));
		return FALSE;
    }
}



tVoid dabdrv_main::vProcess(trMeca_RRdmSetMode* poRRdmSetMode) {

    if ( _enRdmMode != poRRdmSetMode->enRdmMode )
    {
        ETG_TRACE_ERR(("dabdrv_main::vProcess(trMeca_RRdmSetMode)different SourceState= %d RdmMode: %u != %u",
                                ETG_CENUM(DAB_tenSourceState, _enSourceState),
                                ETG_CENUM(tenMeca_RdmMode, _enRdmMode),
                                ETG_CENUM(tenMeca_RdmMode, poRRdmSetMode->enRdmMode)));
        //vSetRdmMode( _enSourceState );
    }
    else {
        ETG_TRACE_USR1(("dabdrv_main::vProcess(trMeca_RRdmSetMode) SourceState= %d RdmMode: %u",
                                ETG_CENUM(DAB_tenSourceState, _enSourceState),
                                ETG_CENUM(tenMeca_RdmMode, poRRdmSetMode->enRdmMode)));
    }
	// Send Source State notification after set mode response from ADR



    //For FG it is being handled when WAITING_FOR_STATIONPLAY is received from ADR to prevent audio flickering PSARCC30-2295
    //poConfig->bGetSfFmDabEnable() will be enabled in PSA and disabled in IVI.
    //in PSA source change response should go only if _enSourceState != DAB_enSourceState_FG
    //in IVI the reponse should go if poConfig->bGetSfFmDabEnable() is false
    fc_dabtuner_config *poConfig=fc_dabtuner_config::instance();
    if(!(poConfig->bGetSfFmDabEnable()) || _enSourceState != DAB_enSourceState_FG){
		trMsgSrvRspSrcState rSrcRsp;
		rSrcRsp.enSourceState=_enSourceState;
		DAB_vCallMsg(rSrcRsp);
    }
}


tVoid dabdrv_main::vProcess(trMsgSrvCmdNewAppState* poSrvCmdNewAppState) {
    tU32 u32OldAppState=_u32AppState;
    _u32AppState=poSrvCmdNewAppState->u32NewAppState;
    ETG_TRACE_USR1(("dabdrv_main::vProcess(trMsgSrvCmdNewAppState) %d-->%d (PAUSE=%d)",
                    u32OldAppState, _u32AppState, AMT_C_U32_STATE_PAUSE));

    _bGoingOFF=FALSE;
    if (AMT_C_U32_STATE_NORMAL == _u32AppState){
		//PSARCC30-3828 - vLoadData is called to load the user data when partial shutdown is performed.
		// Calling vLoadData invokes setmachindata from chnlist which in turn calls vResetSelectSource().
		dabdrv_persData::instance()->vLoadData();
		//When tune freq label is not completed and System went to Sleep and again normal state.
		//so need to reset the state as below.
		dabdrv_chnSelect::instance()->vResetChnSelectState();
        if ( (_bActivityChangedChannel)&&(DAB_enSourceState_FG == _enSourceState) ){
            ETG_TRACE_USR4(("dabdrv_main::bRestoreLsm --> STATE NORMAL"));			
            bRestoreLsm();
        }
        if (_bAdrUp) {
            ETG_TRACE_USR4(( " * M T C    trMeca_CMtcSfRestart"));
            trMeca_CMtcSfRestart rSrvCmdMtcSfRestart;
            dabdrv_mecaIf::instance()->vSendMecaCommand(rSrvCmdMtcSfRestart);
        }
    } else if (AMT_C_U32_STATE_OFF == _u32AppState){
        if (!_oSysStoreWaitTmr.bIsRunning()) {
            ETG_TRACE_USR4(("dabdrv_main:: --> trMsgDrvCmdSysStore"));
            _oSysStoreWaitTmr.vStart(9000);
        _bGoingOFF=TRUE;
		ETG_TRACE_USR4(("dabdrv_presets::instance()->u8GetUserId() = %d", dabdrv_presets::instance()->u8GetUserId()));
            DAB_vCallMsgCtor(trMsgDrvCmdSysStore(dabdrv_presets::instance()->u8GetUserId())); // u8UsrId=1;
    }
    }
}

tVoid dabdrv_main::vProcess(trMsgDrvCmdProcessed* poCmdProcessed) {
    ETG_TRACE_USR4(("dabdrv_main::vProcess(trMsgDrvCmdProcessed)"));
    if ( (enSysStore==poCmdProcessed->enCmdProcessed) && (TRUE == _bGoingOFF) ){
        _oSysStoreWaitTmr.vStop();
        trMsgSrvRspAppStateReached rAppStateReached(AMT_C_U32_STATE_OFF);
        DAB_vCallMsg(rAppStateReached);
        _bGoingOFF=FALSE;
    }
}

tVoid dabdrv_main::vGetUserData(trMainUsrData *prMainUsrData) const {
    trMainUsrData rUsrData;
    rUsrData.bCompMode=_bCompMode;
   rUsrData.rLastSrv=trMecaProgrammeService(dabdrv_chnInfo::instance()->rGetChnInfo().rMecaId._u32Id,
    		enMeca_ServiceType_AUDIO_SERVICE,dabdrv_chnInfo::instance()->rGetChnInfo().u16Scids);
   // rUsrData.rLastSrv=dabdrv_chnInfo::instance()->rGetCurrentSid().rGetProgService();
    rUsrData.rLastComp=dabdrv_compInfo::instance()->rGetCompInfo().rMecaId;
    ETG_TRACE_USR1(("dabdrv_main::vGetUserData::sid=0x%08x",
                    rUsrData.rLastSrv.u32GetSID()));
    *prMainUsrData=rUsrData;
    prMainUsrData->vTrace();
}

tVoid dabdrv_main::vSetUserData(trMainUsrData const &rMainUsrData) {
    ETG_TRACE_USR1(("dabdrv_main::vSetUserData::sid=0x%08x scids=%d",
                    rMainUsrData.rLastSrv.u32GetSID(),rMainUsrData.rLastSrv._u16Scids));
    _rUsrData=rMainUsrData;

    _rUsrData.vTrace();
}


tVoid dabdrv_main::vRegisterActivity(dabdrv_activityBase *poActivity) {
    oActivityList.vAddActivity(poActivity);
}

tVoid dabdrv_main::vRunActivity(dabdrv_activityBase *poActivity) {
    if (OSAL_NULL ==poActivity) {
        return;
    }
    if (_bBlockActivities) {
        ETG_TRACE_USR4(("dabdrv_main::vRunActivity(%d): BLOCKED",
                    ETG_CENUM(DAB_tenDrvActivity, poActivity->enGetActivity())));
        return;
    }
    ETG_TRACE_USR4(("dabdrv_main::vRunActivity(%d)",
                    ETG_CENUM(DAB_tenDrvActivity, poActivity->enGetActivity())));
    if (poActivity->bGetSetsChannel()) {
        // this activity restores the channel
        _bActivityChangedChannel=FALSE;
        ETG_TRACE_USR4(("dabdrv_main::_bActivityChangedChannel-->FALSE (SetsChannel)"));
    }
    else if (!_bActivityChangedChannel) {
        _bActivityChangedChannel=poActivity->bGetChangesChannel();
        if (_bActivityChangedChannel) {
            ETG_TRACE_USR4(("dabdrv_main::_bActivityChangedChannel-->TRUE"));
            /* inform subscribers that channel is no longer stable,
               because the activity will change the channel
            */
            DAB_vCallMsgCtor(trMsgDrvIndActivityChangesChannel());
            //            DAB_vCallMsgCtor(dabdrv_mute::instance(), trMsgDrvCmdChnSelectState(enChnState_Unavail));
        }
    }
    poActivity->bRun();
}

tVoid dabdrv_main::vOnActivityRequest(DAB_tenDrvActivity enActivity) {
    (tVoid)enActivity;
    ETG_TRACE_USR4(("dabdrv_main::vOnActivityRequest(%d)",
                    ETG_CENUM(DAB_tenDrvActivity, enActivity)));
    
    if (oActivityList.enGetState()==DAB_enDrvActivityListState_Pending) {
        dabdrv_activityBase *poActivity = oActivityList.poGetPendingActivity();
        if (OSAL_NULL != poActivity) {
            ETG_TRACE_USR4(("dabdrv_main::vOnActivityRequest(%d):call Run (blocked=%d)",
                            ETG_CENUM(DAB_tenDrvActivity, poActivity->enGetActivity()),
                            _bBlockActivities));
            vRunActivity(poActivity);
        }
    } 
    else if (oActivityList.enGetState()==DAB_enDrvActivityListState_Interruptible) {
        ETG_TRACE_USR4(("dabdrv_main::vOnActivityRequest(%d):Interrupting",
                        ETG_CENUM(DAB_tenDrvActivity, enActivity)));
        oActivityList.bInterrupt();
    }
}
tVoid dabdrv_main::vOnActivityDone(DAB_tenDrvActivity enActivity, tBool bSuccess) {
    DAB_tenDrvActivityListState enActivityListState=oActivityList.enGetState();
    if (!bSuccess) {
        _bActivityChangedChannel=TRUE;
    }
    
    ETG_TRACE_USR4(("dabdrv_main::vOnActivityDone(%d) activityListState=%d",
                    ETG_CENUM(DAB_tenDrvActivity, enActivity),
                    ETG_CENUM(DAB_tenDrvActivityListState, enActivityListState)));
    if (enActivityListState==DAB_enDrvActivityListState_Pending) {
        dabdrv_activityBase *poActivity = oActivityList.poGetPendingActivity();
        if (OSAL_NULL != poActivity) {
            vRunActivity(poActivity);
        }
    }
    else if (enActivityListState==DAB_enDrvActivityListState_Idle) {
        if (_bActivityChangedChannel) {
            ETG_TRACE_USR4(("dabdrv_main::_bActivityChangedChannel-->FALSE"));
            _bActivityChangedChannel=FALSE;
            //bRestoreLsm();
				//PSARCC21-3402 - If siganls are not available and refresh is done and cancelled in between, tuner should tune to the last selected station.
				// PSARCC30-1669 - Block PlayLSM when learn is cancelled by preset recall
			if (PresetRecall != dabdrv_main::instance()->enGetPresetOrChannelRecallRequested())
			{
				tU8 u8Options= _bCompMode ? 2 : 0;
				dabdrv_presets::instance()->vPLayLSM(u8Options);
			}
        } else {
            trMsgDrvCmdUpdateMute rUpdateMute;
            DAB_vCallMsg(rUpdateMute);
        }
    }
} 

tVoid dabdrv_main::vSetRdmMode( DAB_tenSourceState enSourceState) {

    ETG_TRACE_USR1(("dabdrv_main::vSetRdmMode() SourceState: %d",
                                        ETG_CENUM(DAB_tenSourceState, enSourceState)));
    //Stop the FG_Sourcestate response timer if it is active.
    if(!_oSrcChngRspDelayTmr.bIsRunning()){
    	_oSrcChngRspDelayTmr.vStop();
	}
    //Reset the value during every source change.
    _bSourceChangingToFG=FALSE;

    //inform ADR about FG-/BG State
	fc_dabtuner_config *poConfig=fc_dabtuner_config::instance();
    trMeca_CRdmSetMode rRdmSetMode;
    rRdmSetMode.enRdmMode = enMeca_RdmMode_DAB_FG_AUDIO;
	trMeca_CMtcSetAudio rMTCSetAudio;
	rMTCSetAudio.u8AudioSrc1 =0;
	rMTCSetAudio.u8AudioSrc2 =0;
    if (enSourceState == DAB_enSourceState_BG ) {
        _bSendTuneCommand = TRUE;
		rRdmSetMode.enRdmMode = enMeca_RdmMode_DAB_BG_AUDIO;

		// MTCSetAudio 0 means DAB controlled by MTC
		//MTCSetAudio 1 means controlled by FC_DAB.
		//In all the projects set MtcSetAudio to 0
		rMTCSetAudio.u8AudioSrc1 = 0;

      //Reset the select source when source is changed using preset recall and chninfo is not getting updated.
      //Fix for PSARCC21-2712
      dabdrv_presets::instance()->vResetSelectSource();
    }
	//not required as we are not using the SURVEIlance
	else if(enSourceState == DAB_enSourceState_BG_ANNO_SURVEILLANCE) {
		rRdmSetMode.enRdmMode = enMeca_RdmMode_DAB_BG_ANNO_SURVEILLANCE;
		rMTCSetAudio.u8AudioSrc1 =0;
	}
	else if(enSourceState == DAB_enSourceState_FG_ANNO_SURVEILLANCE) {
		rRdmSetMode.enRdmMode = enMeca_RdmMode_DAB_FG_ANNO_SURVEILLANCE;

		//Removed the feature switch and if FM-DAB linking is enabled the make it 1.		
		rMTCSetAudio.u8AudioSrc1 = 0;

	}
    else if ((enSourceState == DAB_enSourceState_FG )||(enSourceState == DAB_enSourceState_FG_TA)) {
        rRdmSetMode.enRdmMode = enMeca_RdmMode_DAB_FG_AUDIO;
		rMTCSetAudio.u8AudioSrc1 =1;
		//not required as we are not using the SURVEIlance
		if (enSourceState == DAB_enSourceState_FG ){

			//Send the Tuner Activity type as normal when switched to fore ground w.r.tPSARCCB-10059
			DAB_trTunerStatusProperty oTunerStatusProperty = dabdrv_properties::instance()->oTunerStatusProperty.oGet();
			oTunerStatusProperty.enTunerActivityType=DAB_enTunerActivityType_NORMAL;
			dabdrv_properties::instance()->oTunerStatusProperty.vSet(oTunerStatusProperty);

			trChnListChnInfo rChnListChnInfo = dabdrv_chnInfo::instance()->vGetPreselectChnInfo();
			trChnListKey rtrChnListKey(rChnListChnInfo.rMecaId, rChnListChnInfo.u16Scids);
			dabdrv_chnInfo::instance()->bUpdateProperty(rtrChnListKey, TRUE);
			//Clear service label if secondary component
			DAB_trChnInfoProperty rChnInfoProperty=dabdrv_properties::instance()->oChnInfoProperty.oGet();

			//To introduce a delay of 500ms after Waiting for station play in case of source change foreground
			//For IVI FM-DAB is disabled, and the delay is not required.
			if(poConfig->bGetSfFmDabEnable())
			{
				_bSourceChangingToFG = TRUE;
			}
			else
			{
				_bSourceChangingToFG = FALSE;
			}

			if(rChnInfoProperty.bComponentMode){


#ifdef VARIANT_S_FTR_ENABLE_FEATURE_SUZUKI
				rChnInfoProperty.rLabel.bLabelValid=FALSE;
				rChnInfoProperty.bComponentMode=FALSE;
				dabdrv_properties::instance()->oChnInfoProperty.vSet(rChnInfoProperty);

				//And send rMecaCServiceGetInfo for new service label
				trMeca_CDbServiceGetInfo rMecaCServiceGetInfo;

				rMecaCServiceGetInfo.rProgrammeService._u32Id=dabdrv_chnInfo::instance()->rGetCurrentSid()._u32Id;
				rMecaCServiceGetInfo.rProgrammeService._enServiceType=dabdrv_chnInfo::instance()->rGetCurrentSid()._enServiceType;
				rMecaCServiceGetInfo.rProgrammeService._u16Scids=0;
				rMecaCServiceGetInfo.enServiceType=rMecaCServiceGetInfo.rProgrammeService._enServiceType;

				trMecaId rMecaId;
				rMecaId._u32Id = rMecaCServiceGetInfo.rProgrammeService._u32Id;
				rMecaId._enServiceType = rMecaCServiceGetInfo.rProgrammeService._enServiceType;
				trChnListChnInfo rPreselectChnInfo=dabdrv_chnInfo::instance()->rGetChnInfo();
				rPreselectChnInfo.u16Scids=0; //Update the Scids in the preselectchninfo
				ETG_TRACE_USR1(("dabdrv_main::vSetRdmMode() u16Scids=%d",dabdrv_chnInfo::instance()->rGetChnInfo().u16Scids));
				ETG_TRACE_USR1(("dabdrv_main::vSetRdmMode() _preselectchannelinfo.u16FrozenListId=0x%x",dabdrv_chnInfo::instance()->rGetChnInfo().u16FrozenListId));
				dabdrv_mecaIf::instance()->vSendMecaCommand(rMecaCServiceGetInfo);
#endif
				tU16 u16FrozenListId=dabdrv_chnList::instance()->u16GetActivatedElemId(enFrozenList_Service);
				ETG_TRACE_USR1(("dabdrv_main::vSetRdmMode() u16FrozenListId=0x%x",u16FrozenListId));
			}
		}
    }
    
    _enRdmMode = rRdmSetMode.enRdmMode;

	/**Already handled in the "DAB_vCallMsgCtor(trMsgDrvStartComponent());" hence this is blocked 
	to avoid sending same command twice.*/

    #ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
        _enSourceState = enSourceState;
        DAB_vCallMsgCtor(trMsgDrvCmdSourceState(enSourceState));
    #endif

    if (_bAdrUp) 
	{
		dabdrv_mecaIf::instance()->vSendMecaCommand(rRdmSetMode);
		//When DAB preset is recalled if DAB is in background
		//MTC set audio is set in preset recall function, so no need to set it for second time.
		dabdrv_mecaIf::instance()->vSendMecaCommand(rMTCSetAudio);
		rMTCSetAudio.vTrace();

		if(enSourceState == DAB_enSourceState_FG)
		{

			//If preset is recalled when DAB is not in FG.
			//Save the preset number temporarily and recall the preset number when it comes to FG.
			if(dabdrv_presets::instance()->u8GetRecalledPresetinBG())
			{

				trMsgSrvCmdRecallPreset rMsg(dabdrv_presets::instance()->u8GetRecalledPresetinBG());
				dabdrv_presets::instance()->vResetRecallPresetFromBG();
				DAB_vCallMsg(rMsg);
				return;
			}

			tU8 u8Options= _bCompMode ? 2 : 0;
			ETG_TRACE_USR1(("dabdrv_main::vSetRdmMode() options %d",u8Options));
			dabdrv_presets::instance()->vPLayLSM(u8Options);
		}
		//Send the source change response immediately for IVI.
		//Because IVI it is taking more time when switched to back ground
		//As SetRdmMode Response is taking 500ms, which is not required.
	}
	else if(!fc_dabtuner_config::instance()->bGetSfFmDabEnable())
	{
    	trMsgSrvRspSrcState rSrcRsp;
		rSrcRsp.enSourceState=enSourceState;
		DAB_vCallMsg(rSrcRsp);
    }
}
//This method will be called once Waiting_for_station play is received.
//Then timer will be started for 500ms, after timer expire Sourcechange Foreground response will be sent.
tVoid dabdrv_main::vSendDelayedSourceChangeRsp(){

	_bSourceChangingToFG=FALSE;
	if(!_oSrcChngRspDelayTmr.bIsRunning())
		_oSrcChngRspDelayTmr.vStart(500);//500ms after StationPlay_WAITING.
}

tVoid dabdrv_main::vSetExpertApi() {
    ETG_TRACE_USR1(("dabdrv_main::vSetExpertApi()"));
    trMeca_CExpSelect oCExpSelect_FREQ;
    oCExpSelect_FREQ.enAction=enMeca_ExpAction_ENABLE_AUTO_UPDATE;
    oCExpSelect_FREQ.enValueId=enMeca_ExpValueId_Frequency;
    dabdrv_mecaIf::instance()->vSendMecaCommand(oCExpSelect_FREQ);
    trMeca_CExpSelect oCExpSelect_BER;
    oCExpSelect_BER.enAction=enMeca_ExpAction_ENABLE_AUTO_UPDATE;
    oCExpSelect_BER.enValueId=enMeca_ExpValueId_FICBER;
    dabdrv_mecaIf::instance()->vSendMecaCommand(oCExpSelect_BER);
    trMeca_CExpSelect oCExpSelect_SYNC;
    oCExpSelect_SYNC.enAction=enMeca_ExpAction_ENABLE_AUTO_UPDATE;
    oCExpSelect_SYNC.enValueId=enMeca_ExpValueId_SYNC;
    dabdrv_mecaIf::instance()->vSendMecaCommand(oCExpSelect_SYNC);
    trMeca_CExpSelect oCExpSelect_FREQ_BG;
    oCExpSelect_FREQ_BG.enAction=enMeca_ExpAction_ENABLE_AUTO_UPDATE;
    oCExpSelect_FREQ_BG.enValueId=enMeca_ExpValueId_Bg_Frequency;
    dabdrv_mecaIf::instance()->vSendMecaCommand(oCExpSelect_FREQ_BG);
    trMeca_CExpSelect oCExpSelect_INFO;
    oCExpSelect_INFO.enAction=enMeca_ExpAction_ENABLE_AUTO_UPDATE;
    oCExpSelect_INFO.enValueId=enMeca_ExpValueId_Modul_Info;
    dabdrv_mecaIf::instance()->vSendMecaCommand(oCExpSelect_INFO);
    trMeca_CExpSelect oCExpSelect_INFO_BG;
    oCExpSelect_INFO_BG.enAction=enMeca_ExpAction_ENABLE_AUTO_UPDATE;
    oCExpSelect_INFO_BG.enValueId=enMeca_ExpValueId_Modul_Info_Bg;
    dabdrv_mecaIf::instance()->vSendMecaCommand(oCExpSelect_INFO_BG);
    trMeca_CExpSelect oCExpSelect_MTD_0;
    oCExpSelect_MTD_0.enAction=enMeca_ExpAction_ENABLE_AUTO_UPDATE;
    oCExpSelect_MTD_0.enValueId=enMeca_ExpValueId_Mtd_0;
    dabdrv_mecaIf::instance()->vSendMecaCommand(oCExpSelect_MTD_0);
    trMeca_CExpSelect oCExpSelect_MTD_1;
    oCExpSelect_MTD_1.enAction=enMeca_ExpAction_ENABLE_AUTO_UPDATE;
    oCExpSelect_MTD_1.enValueId=enMeca_ExpValueId_Mtd_1;
    dabdrv_mecaIf::instance()->vSendMecaCommand(oCExpSelect_MTD_1);
    trMeca_CExpSelect oCExpSelect_MTD_2;
    oCExpSelect_MTD_2.enAction=enMeca_ExpAction_ENABLE_AUTO_UPDATE;
    oCExpSelect_MTD_2.enValueId=enMeca_ExpValueId_Mtd_2;
    dabdrv_mecaIf::instance()->vSendMecaCommand(oCExpSelect_MTD_2);
    trMeca_CExpSelect oCExpSelect_MTD_3;
    oCExpSelect_MTD_3.enAction=enMeca_ExpAction_ENABLE_AUTO_UPDATE;
    oCExpSelect_MTD_3.enValueId=enMeca_ExpValueId_Mtd_3;
    dabdrv_mecaIf::instance()->vSendMecaCommand(oCExpSelect_MTD_3);
    trMeca_CExpSelect oCExpSelect_MTD_4;
    oCExpSelect_MTD_4.enAction=enMeca_ExpAction_ENABLE_AUTO_UPDATE;
    oCExpSelect_MTD_4.enValueId=enMeca_ExpValueId_Mtd_4;
    dabdrv_mecaIf::instance()->vSendMecaCommand(oCExpSelect_MTD_4);
    trMeca_CExpSelect oCExpSelect_MTD_5;
    oCExpSelect_MTD_5.enAction=enMeca_ExpAction_ENABLE_AUTO_UPDATE;
    oCExpSelect_MTD_5.enValueId=enMeca_ExpValueId_Mtd_5;
    dabdrv_mecaIf::instance()->vSendMecaCommand(oCExpSelect_MTD_5);
}

tVoid dabdrv_main::vProcess(trMsgDrvCmdNotifyLearnComplete*) {

	ETG_TRACE_USR1(("dabdrv_main::trMsgDrvCmdNotifyLearnComplete"));

		trMsgDrvCmdChnSelect oChnSelect;
		oChnSelect.enChnSelectSource=enChnSelectSource_ChnSelect;
		oChnSelect.enChnSelectMode= enChnSelectMode_Psid;
		oChnSelect.u32Value=dabdrv_chnList::instance()->rGetFirstListElement().rMecaId._u32Id;
		oChnSelect.bNegative=FALSE;

		ETG_TRACE_USR1(("dabdrv_main::trMsgDrvCmdNotifyLearnComplete oChnSelect.u32Value=%d",
			    		oChnSelect.u32Value));
		DAB_vCallMsg(oChnSelect);


		if (_bCompMode) {
			trMecaId rScidi;
			tU16 u16Scidi= dabdrv_compInfo::instance()->rGetCompInfo().rMecaId.u16GetScidi();
			ETG_TRACE_USR1(("dabdrv_main::bRestoreLsm rScidi=0x%04x",
							u16Scidi));
			trMsgDrvCmdCompSelect oCompSelect;
			oCompSelect.enChnSelectSource=enChnSelectSource_Lsm;
			oCompSelect.enChnSelectMode= enChnSelectMode_Psid;
			oCompSelect.u32Value=u16Scidi;
			DAB_vCallMsg(oCompSelect);
		}
}

tVoid dabdrv_main::vSetStartupLearn(tBool startupLearn)
{
	_bStartupLearn=startupLearn;
	ETG_TRACE_USR4(("dabdrv_main::vSetStartupLearn _startupLearn=%d",
			_bStartupLearn));
}
tBool dabdrv_main::bGetStartupLearn()
{
	ETG_TRACE_USR4(("dabdrv_main::bGetStartupLearn _startupLearn=%d",
			_bStartupLearn));
	return _bStartupLearn;
}

#ifdef DAB_ENABLE_MUTE_HANDLING
tVoid dabdrv_main::vProcess(trMsgSrvCmdEnsSeek*  poSrvCmdEnsSeek) {
	ETG_TRACE_USR1(("dabdrv_main::trMsgSrvCmdEnsSeek"));

	((_enMuteOperation==enMuteOperation_PresetLoad) || (_enMuteOperation==enMuteOperation_LoadFromList))?
					(_enNextMuteOperation=enMuteOperation_EnsembleSeek):(_enMuteOperation = enMuteOperation_EnsembleSeek);

	ETG_TRACE_USR1(("dabdrv_main::trMsgSrvCmdEnsSeek _enMuteOperation=%d , _enNextMuteOperation=%d",ETG_CENUM(tenMuteOperation ,_enMuteOperation),
																											 ETG_CENUM(tenMuteOperation ,_enNextMuteOperation)));

	oMsgDrvTune.enTuneType= DAB_enTuneType_TUNE_ENSEMBLE;
	oMsgDrvTune.enDirection = poSrvCmdEnsSeek->enDirection;
	poSrvCmdEnsSeek->enRes = DAB_enResult_OK;
}

#endif

#ifdef MUTE_ACTIVE
tVoid dabdrv_main::vProcess(trMsgSrvCmdManualModeOp*  poSrvCmdManualModeOp) {

	((_enMuteOperation==enMuteOperation_PresetLoad) || (_enMuteOperation==enMuteOperation_LoadFromList))?
			(_enNextMuteOperation=enMuteOperation_ManualTune):(_enMuteOperation = enMuteOperation_ManualTune);

	ETG_TRACE_USR1(("dabdrv_main::trMsgSrvCmdManualModeOp _enMuteOperation=%d , _enNextMuteOperation=%d",ETG_CENUM(tenMuteOperation ,_enMuteOperation),
																										 ETG_CENUM(tenMuteOperation ,_enNextMuteOperation)));

	oMsgSrvTestOp.enTestOperation=poSrvCmdManualModeOp->enTestOperation;
	oMsgSrvTestOp.u32Value1=poSrvCmdManualModeOp->u32Value1;
	oMsgSrvTestOp.u32Value2=poSrvCmdManualModeOp->u32Value2;
	oMsgSrvTestOp.u32Value3=poSrvCmdManualModeOp->u32Value3;
	if(vSendMuteRequest()){
		DAB_vCallMsg(oMsgSrvTestOp);
	}
}

tVoid dabdrv_main::vProcess(trMsgSrvCmdLoadPreset*  poSrvCmdLoadPreset) {
	ETG_TRACE_USR1(("dabdrv_main::trMsgSrvCmdLoadPreset"));

	((_enMuteOperation==enMuteOperation_PresetLoad) || (_enMuteOperation==enMuteOperation_LoadFromList))?
			(_enNextMuteOperation=enMuteOperation_PresetLoad):(_enMuteOperation = enMuteOperation_PresetLoad);

	ETG_TRACE_USR1(("dabdrv_main::trMsgSrvCmdLoadPreset _enMuteOperation=%d , _enNextMuteOperation=%d",ETG_CENUM(tenMuteOperation ,_enMuteOperation),
																											 ETG_CENUM(tenMuteOperation ,_enNextMuteOperation)));

	oMsgSrvRecallPreset.u8PresetNumber=poSrvCmdLoadPreset->u8PresetNumber;
	oMsgSrvRecallPreset.enRes=DAB_enResult_OK;
	//To support SDS Mixed preset recall, If DAB is in Background Murequest is not required.
	//Not working in AM source, so handling DAB_enSourceState_BG_ANNO_SURVEILLANCE as well.
	if((_enSourceState != DAB_enSourceState_FG) || (vSendMuteRequest())){
		DAB_vCallMsg(oMsgSrvRecallPreset);
	}
}

tVoid dabdrv_main::vProcess(trMsgSrvCmdSrvSelect*  poSrvCmdSrvSelect) {
	ETG_TRACE_USR1(("dabdrv_main::trMsgSrvCmdSrvSelect"));

	((_enMuteOperation==enMuteOperation_PresetLoad) || (_enMuteOperation==enMuteOperation_LoadFromList))?
				(_enNextMuteOperation=poSrvCmdSrvSelect->enMuteOp):(_enMuteOperation=poSrvCmdSrvSelect->enMuteOp);

	ETG_TRACE_USR1(("dabdrv_main::trMsgSrvCmdSrvSelect _enMuteOperation=%d , _enNextMuteOperation=%d",ETG_CENUM(tenMuteOperation ,_enMuteOperation),
																											 ETG_CENUM(tenMuteOperation ,_enNextMuteOperation)));

	oMsgSrvSelect.enChnSelectMode=poSrvCmdSrvSelect->enChnSelectMode;
	oMsgSrvSelect.bNegative=poSrvCmdSrvSelect->bNegative;
	oMsgSrvSelect.u32Value=poSrvCmdSrvSelect->u32Value;
	oMsgSrvSelect.u16Scids=poSrvCmdSrvSelect->u16Scids;

	if(vSendMuteRequest()){
		DAB_vCallMsg(oMsgSrvSelect);
	}


}
tVoid dabdrv_main::vProcess(trMsgSrvCmdManualLearnOp*  poSrvCmdSrvLearn) {
	ETG_TRACE_USR1(("dabdrv_main::trMsgSrvCmdManualLearnOp"));

	((_enMuteOperation==enMuteOperation_PresetLoad) || (_enMuteOperation==enMuteOperation_LoadFromList))?
				(_enNextMuteOperation=enMuteOperation_LearnUpdate):(_enMuteOperation=enMuteOperation_LearnUpdate);

	ETG_TRACE_USR1(("dabdrv_main::trMsgSrvCmdManualLearnOp _enMuteOperation=%d , _enNextMuteOperation=%d",ETG_CENUM(tenMuteOperation ,_enMuteOperation),
																											 ETG_CENUM(tenMuteOperation ,_enNextMuteOperation)));

	oMsgSrvLearnUpdate.enLearnType=poSrvCmdSrvLearn->enLearnType;
	oMsgSrvLearnUpdate.bRollback=poSrvCmdSrvLearn->bRollback;
	if(vSendMuteRequest()){
		DAB_vCallMsg(oMsgSrvLearnUpdate);
	}
}

tVoid dabdrv_main::vProcess(trMsgDrvMuteState*  poDrvMuteStatus) {
	ETG_TRACE_USR1(("dabdrv_main::trMsgDrvMuteState _enMuteOperation=%d",ETG_CENUM(tenMuteOperation ,_enMuteOperation)));
	ETG_TRACE_USR1(("dabdrv_main::trMsgDrvMuteState enDabSource=%d enMuteState=%d",ETG_CENUM(tenDabSource ,poDrvMuteStatus->enDabSource),
			ETG_CENUM(tenRequiredMuteState ,(tenRequiredMuteState)poDrvMuteStatus->enMuteState)));

    if ( (poDrvMuteStatus->enDabSource == enDabSource_Dab) && (poDrvMuteStatus->enMuteState == enRequiredMuteState_Mute) ) {
    	switch(_enMuteOperation)
    	{
    		case enMuteOperation_EnsembleSeek:
    			DAB_vCallMsg(oMsgDrvTune);
    			break;
    		case enMuteOperation_ServiceSeek:
    		case enMuteOperation_LoadFromList:
    			ETG_TRACE_USR1(("dabdrv_main::trMsgDrvMuteState enChnSelectMode=%d",ETG_CENUM(tenChnSelectMode ,oMsgSrvSelect.enChnSelectMode)));
				DAB_vCallMsg(oMsgSrvSelect);
				break;
    		case enMuteOperation_PresetLoad:
    			DAB_vCallMsg(oMsgSrvRecallPreset);
				break;
    		case enMuteOperation_ManualTune:
				DAB_vCallMsg(oMsgSrvTestOp);
				break;
    		case enMuteOperation_LearnUpdate:
    			DAB_vCallMsg(oMsgSrvLearnUpdate);
    			break;
    		case enMuteOperation_TuneFreqLabel:
    			DAB_vCallMsg(oMsgTuneFreqLabel);
    			break;
    		default:
    			ETG_TRACE_USR1(("dabdrv_main::trMsgDrvMuteState _enMuteOperation=%d",ETG_CENUM(tenMuteOperation ,_enMuteOperation)));
    			break;
    	}
    }
}

tVoid dabdrv_main::vProcess(trMsgSrvCmdTuneFreqlabel* poSrvCmdTuneFreqlabel){
	((_enMuteOperation==enMuteOperation_PresetLoad) || (_enMuteOperation==enMuteOperation_LoadFromList))?
			(_enNextMuteOperation=enMuteOperation_TuneFreqLabel):(_enMuteOperation = enMuteOperation_TuneFreqLabel);

	ETG_TRACE_USR1(("dabdrv_main::trMsgSrvCmdTuneFreqlabel _enMuteOperation=%d , _enNextMuteOperation=%d",ETG_CENUM(tenMuteOperation ,_enMuteOperation),
																												 ETG_CENUM(tenMuteOperation ,_enNextMuteOperation)));

	//PSARCC30-3341 - clear the ensemble label. After Direct tune freq, need to clear 
	//the ensemble label so that the old info is not displayed.
	DAB_trEnsembleInfoProperty rProperty=dabdrv_properties::instance()->oEnsembleInfoProperty.oGet();
	rProperty.rEnsembleLabel.bLabelValid = FALSE;
	dabdrv_properties::instance()->oEnsembleInfoProperty.vSet(rProperty);
	
	oMsgTuneFreqLabel.sfreqlabel = poSrvCmdTuneFreqlabel->sfreqlabel;

	if(vSendMuteRequest()){
		DAB_vCallMsg(oMsgTuneFreqLabel);
	}
}

#endif

tVoid dabdrv_main::vProcess(trMeca_RDbConfig* poRDbConfig){
	ETG_TRACE_USR1(("dabdrv_main::vProcess(trMeca_RDbConfig*) enCmd=%x enValueId=%x",
		poRDbConfig->u8Cmd,
		ETG_CENUM(tenMeca_DbConfig_ValueId, poRDbConfig->enValueId)));
	if((poRDbConfig->u8Cmd==1)&&
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_VW_MIBE
		(poRDbConfig->enValueId==enMeca_DbConfig_ValueId_delete_presets)
#else
		(poRDbConfig->enValueId==enMeca_DbConfig_ValueId_delete_All)
#endif
		){
			if(dabdrv_sysStore::instance()->enGetSysStoreAction()== dabdrv_sysStore::enSysStoreAction_DefSet){
				ETG_TRACE_USR1(("dabdrv_main::vProcess(trMeca_RDbConfig*) SysStore def set state clear"));
				dabdrv_sysStore::instance()->vClear();
				DAB_vCallMsgCtor(trMsgDrvCmdSysStore(1, TRUE));
			}
			else if(dabdrv_presets::instance()->u8GetAutoStoreType() == enAutostore_Initial)
			{
		_bStartupLearn=TRUE;
		trMsgSrvCmdLearn oCmdLearn(enLearnType_VIRGIN);
		DAB_vCallMsg(oCmdLearn);
			}
	}
#ifndef VARIANT_S_FTR_ENABLE_FEATURE_VW_MIBE
	else if((poRDbConfig->u8Cmd==1) &&
				(poRDbConfig->enValueId==enMeca_DbConfig_ValueId_delete_presets)){
			DAB_vCallMsgCtor(trMsgDrvCmdSysStore(1, TRUE));
			//ETG_TRACE_USR1(("dabdrv_main::vProcess(trMeca_RDbConfig*) SysStore delete_presets"));
		}
#endif

}
tVoid dabdrv_main::vClearDatabase(tenMeca_DbConfig_ValueId enDelAction) const{	
	trMeca_CDbConfig oCmdDbConfig;
	oCmdDbConfig.u8Cmd =1;
	oCmdDbConfig.enValueId= enDelAction;
	dabdrv_mecaIf::instance()->vSendMecaCommand(oCmdDbConfig);
}
tVoid dabdrv_main::vProcess(trMsgDrvDeleteMemory* poCmdDelMemory){
	if(poCmdDelMemory->enDeleteAction==enMeca_DbConfig_ValueId_delete_All){	
		vClearDatabase(enMeca_DbConfig_ValueId_delete_All);		
	}
	else{
		vClearDatabase(enMeca_DbConfig_ValueId_delete_presets);
	}
}
tVoid dabdrv_main::vProcess(trMeca_RRdmGetAudioStatus *poRRdmGetAudioStatus) {
	if(poRRdmGetAudioStatus->enRdmMode == enMeca_RdmMode_DAB_FG_AUDIO){

		trChnListElem rPendingChnListElem = dabdrv_chnSelect::instance()->rGetPendingChnListElem();
		DAB_trChnInfoProperty rChnInfoProperty=dabdrv_properties::instance()->oChnInfoProperty.oGet();
		if(!rChnInfoProperty.bComponentMode){
			rPendingChnListElem.u16Scids=0;
		}
		if((rPendingChnListElem.bPSFlag) && (ChannelRecall == _enPresetOrChannelRecallRequested)){
			/*Fetch the Preset info and take the SCIDs and SID*/
			_enPresetOrChannelRecallRequested = PresetOrChannelRecallInvalid;
			trMecaProgrammeService rMecaProgrammeService(rPendingChnListElem.rMecaId._u32Id, rPendingChnListElem.rMecaId._enServiceType, rPendingChnListElem.u16Scids);

			ETG_TRACE_USR4(("dabdrv_main::trMeca_RRdmGetAudioStatus _enPresetOrChannelRecallRequested=%d rPendingChnListElem.rMecaId._u32Id = %x, rPendingChnListElem.rMecaId._enServiceType = %d, rPendingChnListElem.u16Scids =%d",_enPresetOrChannelRecallRequested,
				rPendingChnListElem.rMecaId._u32Id, rPendingChnListElem.rMecaId._enServiceType, rPendingChnListElem.u16Scids));
			
			if (strcmp(rChnInfoProperty.rLabel.pcGetCString(), "") != 0) {
				if (!dabdrv_chnSelect::instance()->bIsTimerRunning()) {
					ETG_TRACE_USR4(("dabdrv_main::trMeca_RRdmGetAudioStatus bUpdateProperty called"));
					dabdrv_chnInfo::instance()->bUpdateProperty(rMecaProgrammeService, FALSE);
				}
			}
		}
	}
}

tVoid dabdrv_main::vProcess(trMsgSrvCmdCoding *poCmdCoding){
	(tVoid)poCmdCoding;
	ETG_TRACE_USR1(("dabdrv_main::vProcess(trMsgSrvCmdCoding START)"));
	 DAB_vCallMsgCtor(this, trMsgDrvAdrDown());
	fc_dabtuner_config::instance()->vReloadConfigration();
	DAB_vCallMsgCtor(this, trMsgDrvAdrUp());
	ETG_TRACE_USR1(("dabdrv_main::vProcess(trMsgSrvCmdCoding END)"));
}

tVoid dabdrv_main::vCheckIfCountryZoneChnaged(){

#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
	tU8 currentCountryzone = fc_dabtuner_config::instance()->u8GetCountryZone();
	tU16 prevCountryZone=0;
	#ifndef DABTUNER_UTEST
	dp_tclDABTunerDPCountryZone dpCountryZone;
	tU32 status = dpCountryZone.s32GetData(prevCountryZone);
	status = dpCountryZone.s32SetData(currentCountryzone);
	ETG_TRACE_USR1(("dabdrv_main::vCheckIfCountryZoneChnaged status=%d currentCountryzone=%d prevCountryZone=%d",status,currentCountryzone,prevCountryZone));
	if(currentCountryzone != prevCountryZone){
		dp_tclDABTunerDPServiceLinkingMode oServiceLinking;
		dp_tclDABTunerDPMTCMode dpMTC_mode;

		//Hard code the default values of serviceLinkingMode and MtcMode
		//in the below condition
		//When changed the Country zone using CANOE.
		if((currentCountryzone != enConfigCountryZone_EU ||
				currentCountryzone != enConfigCountryZone_UAE)||
				/*DAB follow up ,MTC mode has to be off if BTEL RDS followup is OFF*/
				(!fc_dabtuner_config::instance()->bGetRdsFollowStatus())){
			//Default values for SouthAmerica and Canada option is OFF.
			tU32 status = oServiceLinking.s32SetData(0);
			status = dpMTC_mode.s32SetData(0);
		}else{
			tU32 status = oServiceLinking.s32SetData(2);
			status = dpMTC_mode.s32SetData(3);
		}
	}
#endif
#endif

}


#ifdef MUTE_ACTIVE
tBool dabdrv_main::vSendMuteRequest(){

	DAB_trMuteRequestProperty oPropVal=dabdrv_properties::instance()->oMuteRequestProperty.oGet();
	tBool bMuteActive = oPropVal.bMuteRequest;
	if(!bMuteActive){
		trMsgDrvCmdTunerOpMuteReq rMuteReq;
		rMuteReq.enRequiredMuteState=enRequiredMuteState_Mute;
		DAB_vCallMsg(rMuteReq);
		return bMuteActive;
	}
	return bMuteActive;
}
#endif
