
/************************************************************************
 * FILE:      dabdrv_learn.hpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of dabdrv_learn
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#ifndef DABDRV_LEARN_HPP
#define DABDRV_LEARN_HPP

#include "fc_dabtuner_util.h"
//#include "dabdrv_types.hpp"
#include "dabdrv_main.hpp"
#include "dabdrv_activity.hpp"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_DRV_LEARN 
#include "trcGenProj/Header/dabdrv_learn.hpp.trc.h"
#endif

namespace DAB {
    struct trMsgStopLearnTimeOut;
    struct trMsgStartLearnTimeOut;

    class dabdrv_learn:
        public DAB_Singleton <dabdrv_learn>,
        public DAB_MessageHandlerCommon<dabdrv_learn>
    {
        friend class DAB_Singleton<dabdrv_learn>;

    public:
        DAB_TRACE_INFO_IMPL(FC_DABTUNER_TR_DRV_LEARN);
        virtual char const *pcGetName() const {return "dabdrv_learn";};
        virtual tVoid vTraceState() const;

        virtual tVoid vInit();
        virtual tVoid vDeInit();

        virtual tVoid vProcess(trMsgDrvStartComponent *poStartComponent);
        virtual tVoid vProcess(trMsgDrvStopComponent *poStopComponent);

        virtual tVoid vProcess(trMsgStartLearnTimeOut *poStartLearnTimeOut);
        virtual tVoid vProcess(trMsgStopLearnTimeOut *pStopLearnTimeOut);

        virtual tVoid vProcess(trMsgDrvCmdSourceState* poDrvCmdSourceState);
        virtual tVoid vProcess(trMsgSrvCmdLearn* poSrvCmdLearn);
        virtual tVoid vProcess(trMeca_RRdmLearn* poRRdmLearn);
        virtual tVoid vProcess(trMeca_RRdmFrequencyInfo* poRdmFrequencyInfo);

		virtual tU8 bGetTunerMode() const{
			fc_dabtuner_config *poConfig=fc_dabtuner_config::instance();
			if (OSAL_NULL ==poConfig) {
					ETG_TRACE_FATAL(("dabdrv_main::vProcess(trMsgSrvCmdSetup) config not available !!!"));
					return 0;
			}
			/**the 1.5 is available only with the below configuration*/
			tU8 u8TunMode = ((poConfig->enGetFmDabHdTunerMode() != enFmDabHdTunerMode_TunVar39_3FE_AM_1FE_DAB) && 
			 (poConfig->enGetFmDabHdTunerMode() != enFmDabHdTunerMode_TunVar20_3FE_DDA_DDS_DAB))?1:0;
			return u8TunMode; //return 1 if single tuner, 0 if double tuner
		}
		virtual tVoid bSetManualLearn(tBool bManualLearn) {
			_bManualLearn = bManualLearn;
		}

		virtual tVoid vSetAutostoreAction(tenAutostoreAction enAutostoreAction) {
			_enAutostoreAction = enAutostoreAction;
		}

		virtual tenAutostoreAction vGetAutostoreAction() {
			return _enAutostoreAction;
		}

		tBool vGetupdateCompleteStatus() {
			return _bUpdateComplete;
		}

		tVoid vSetupdateCompleteStatus(tBool bUpdateComplete) {
			 _bUpdateComplete = bUpdateComplete;
		}


#if 0
        tBool bLearnActive() const;
#endif
        tBool bRunActivity();
        tBool bTerminateActivity();

    private:
        typedef enum {
            enLearnState_Idle,
            enLearnState_Pending,
            enLearnState_Running,
            enLearnState_Stopping
        } tenLearnState;
        dabdrv_learn();   

        tVoid vHandleLearn(DAB_tenSourceState enSourceState);
        tVoid vStopLearn();
        tVoid vStartLearn(tenLearnType enLearnType=enLearnType_UPDATE, tBool bRollback=FALSE);
        tVoid vStartLearnTimerConditional();

        tVoid vOnLearnDone();
        tVoid vSetMute();

        DAB_tclTimer _oStopLearnTmr;
        tU32 _u32StopLearnTmrValMs;
        DAB_tclTimer _oStartLearnTmr;
        tU32 _u32StartLearnTmrValMs;
        tBool _bForcedLearn;
        tenLearnState _enLearnState;
        dabdrv_activityIr<dabdrv_learn, (int)DAB_enDrvActivity_Learn> _oLearnActivity;
        tenLearnType _enRequestedLearnType;
        tBool _bLearnInterrupted;
		tBool _bManualLearn;
		tenAutostoreAction _enAutostoreAction;
		tU8 u8PreviousFreqIndex;
		tU8 u8CurrFreqIndex;
		tU8 u8FreqIndexdiff;
		tBool _bUpdateComplete;

        
    };
} //namespace DAB 

#endif
