/************************************************************************
 * FILE:       dabdrv_dataSrvList.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of dabdrv_dataSrvList
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#include "dabdrv_main.hpp"
#include "dabdrv_mecaIf.h"
#include "dabdrv_presets.hpp"
#include "dabdrv_dataSrvList.hpp"
#include "dabdrv_chnInfo.hpp"
#include "dabdrv_presets.hpp"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_DRV_DATALST 
#include "trcGenProj/Header/dabdrv_dataSrvList.cpp.trc.h"
#endif

// this class maintains a list of all data-services in current ensemble using meca_db

/* 1.) get service-list per ensemble:
   1.a.) audio-services with tmc-component
   1.b.) tmc-data services
   - done via db-auto-nofification? or manualy receiving for data- and audio-services:
     trMeca_RDbEnsembleGetServiceList and according filter
   2.) request component-list for each "tmc-service" using
   trMeca_CDbServiceGetComponentList (PROG or DATA according to serviceListType)
   result: list of scidi for each service
   Only possible in background except current ensemble
   simple solution: only check current ensemble
   4.) check for duplicates (using DAB_R_DB_SERVICE_COMPONENT_GET_INFO->b_id) 
   5.) reveive tmc-data, wait for 3A-group to get RDBID

*/




using namespace DAB;

namespace DAB {

    // Timer
    // a timer-event
    struct trMsgDataListUpdateTimer:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "trMsgDataListUpdateTimer"));
        };
    };


}

dabdrv_dataSrvList::dabdrv_dataSrvList(tVoid)
{

    _u32DataListUpdateTimerValMs = DAB_DATA_LIST_UPDATE_TIMER_MS;
    _bFilterValid = FALSE;
    _bTmcActive = FALSE;

    // commands from dabdrv_main
    vSubscribe<trMsgDrvStartComponent>();
    vSubscribe<trMsgDrvStopComponent>();

    //vSubscribe<trMsgDrvSetTmcMode>();

    // meca-responses
    vSubscribe<trMeca_RDbEnsembleGetServiceList>();
    //    vSubscribe<trMeca_RDbServiceGetInfo>();
    //    vSubscribe<trMeca_RDbServiceGetComponentList>();

    //vSubscribe<trMeca_RDbFilterId>();
    //vSubscribe<trMeca_RDdmTmcSc>();
    //vSubscribe<trMeca_RDdmTmcEvent>();


}

dabdrv_dataSrvList::~dabdrv_dataSrvList() {
}

#if 0
// moved to dabdrv_tmclearn.cpp
// enable or disable tmc-mode
tVoid dabdrv_dataSrvList::vProcess(trMsgDrvSetTmcMode* poMsgDrvSetTmcMode) {
    if (poMsgDrvSetTmcMode->bEnable) {
        // enable TMC
        _bTmcActive = TRUE;

        _oDataListUpdateTimer.vStart(_u32DataListUpdateTimerValMs);

    } else {
        // disable TMC
        _oDataListUpdateTimer.vStop();
        _bTmcActive = FALSE;
    }
}
#endif

tVoid dabdrv_dataSrvList::vProcess(trMeca_RDbEnsembleGetServiceList* poServiceList) {
    //    if (poServiceList->enServiceType == enMeca_ServiceType_AUDIO_SERVICE) {
        // list should only contain services with tmc-components
        _mapEnsembleInfo[poServiceList->rRefEnsemble].lServiceList=poServiceList->lServiceList;
#if 0
        set<trMecaProgrammeService> &lNewServiceList=poServiceList->lServiceList;
        ETG_TRACE_USR4(("dabdrv_dataSrvList::vProcess(trMeca_RDbEnsembleGetServiceList:lNewServiceList)"));


        DAB_FOREACH_CONST(set<trMecaProgrammeService>, iter, lNewServiceList) {
            (*iter).vTrace();
            // request component-list with tmc-filter for each service
            trMeca_CDbServiceGetComponentList oCDbServiceGetComponentList;
            oCDbServiceGetComponentList.enServiceType = iter->_enServiceType;
            oCDbServiceGetComponentList.u8FilterId = (tU8)enDabDbFilterId_TMC;
            oCDbServiceGetComponentList.rRefProgrammeService = (*iter);
            dabdrv_mecaIf::instance()->vSendMecaCommand(oCDbServiceGetComponentList);
        }
        #endif
}

#if 0
// moved to dabdrv_tmclearn.cpp
tVoid dabdrv_dataSrvList::vProcess(trMeca_RDbServiceGetComponentList* poComponentList) {
    
    if ( _bTmcActive == TRUE ) {
        // list should contain all tmc-components of a service. store them.
        if ( poComponentList->u8FilterId == (tU8)enDabDbFilterId_TMC ) {
            ETG_TRACE_USR4(("dabdrv_dataSrvList::vProcess(trMeca_RDbServiceGetComponentList)"));
            // set bFoundInSrvList and store reception-quality map for all services received in list
            for(tU8 u8Index=0; u8Index<poComponentList->lu16SCIDI.size(); u8Index++) {        
                trMecaId rMecaId(poComponentList->lu16SCIDI[u8Index]);

                trMeca_CDdmTmcSc oCDdmTmcSc;
                oCDdmTmcSc.enCommand = enMeca_DdmCommand_START;
                oCDdmTmcSc.u8Flags = 0;
                //oCDdmTmcSc.enServiceType = enMeca_ServiceType_DAB_DATA_SERVICE;
                oCDdmTmcSc.enServiceType = poComponentList->enServiceType;//enMeca_ServiceType_AUDIO_SERVICE;
                oCDdmTmcSc.rMecaProgrammeService = poComponentList->rRefProgrammeService;// rMecaId.rGetProgService();
                oCDdmTmcSc.u16SCIDI = rMecaId.u16GetScidi();
                oCDdmTmcSc.vTrace();
                dabdrv_mecaIf::instance()->vSendMecaCommand(oCDdmTmcSc);
            }
        }
    }
}
#endif

#if 0
// moved to dabdrv_tmclearn.cpp
tVoid dabdrv_dataSrvList::vProcess(trMeca_RDdmTmcSc* poTmcSc) {

    if ( _bTmcActive == TRUE ) {
        if ( poTmcSc->enResponse == enMeca_DdmResponse_OK) {
            poTmcSc->vTrace();
        }
        else {
            //  TMC not enabled
        }
    }
}
#endif

#if 0
// moved to dabdrv_tmclearn.cpp
tVoid dabdrv_dataSrvList::vProcess(trMeca_RDdmTmcEvent* poTmcEvent) {

    if ( _bTmcActive == TRUE ) {
        if ( poTmcEvent->enServiceType == enMeca_ServiceType_DAB_DATA_SERVICE) {

            DAB_trTmcDataListProperty _rTmcData;
            _rTmcData.enTmcGroup = poTmcEvent->enTmcGroup;
            for (tU8 i= 0; i<5; i++)
                _rTmcData.au8TMCData[i] = poTmcEvent->u8TmcData[i];
            
            dabdrv_properties::instance()->oTmcDataProperty.vSet(_rTmcData);
        }
        else {
            //  no data service
        }
    }
}
#endif

tVoid dabdrv_dataSrvList::vTraceAll() const {

}   


tVoid dabdrv_dataSrvList::vInit() {
    // timer can not be created in constructor
    _oDataListUpdateTimer.vInit(instance(),trMsgDataListUpdateTimer());
}

tVoid dabdrv_dataSrvList::vDeInit() {
    _oDataListUpdateTimer.vDeInit();
}

tVoid dabdrv_dataSrvList::vProcess(trMsgDrvStartComponent*) {

    _oDataListUpdateTimer.vStart(_u32DataListUpdateTimerValMs);

}


tVoid dabdrv_dataSrvList::vProcess(trMsgDrvStopComponent*) {
}


tVoid dabdrv_dataSrvList::vProcess(trMsgDataListUpdateTimer *) {
    /* tune to next ensemble and request list of audio-tmc-services and tmc-data-services
       tune to each tmc-service to fetch RDBID from 3A-group
    */
    if ( _bTmcActive == TRUE ) {
        _oDataListUpdateTimer.vStart(_u32DataListUpdateTimerValMs);
    }
}


#if 0
// moved to dabdrv_tmclearn.cpp
tVoid dabdrv_dataSrvList::vProcess(trMeca_RDbServiceGetInfo* poSrvLabel) {
    
    if ( _bTmcActive == TRUE ) {
        if (poSrvLabel->rProgrammeService._enServiceType != enMeca_ServiceType_DAB_DATA_SERVICE) {
            return;
        }
    }
    // maybe not needed
}
#endif

tVoid dabdrv_dataSrvList::vProcess(trMeca_RDbGetDbEnsembleList* /*poEnsembleList*/) {
    /* store list of receivable ensembles
       start timer
    */
    if ( _bTmcActive == TRUE ) {
        _oDataListUpdateTimer.vStart(_u32DataListUpdateTimerValMs);
    }
}

#if 0
// moved to dabdrv_tmclearn.cpp
tVoid dabdrv_dataSrvList::vProcess(trMeca_RDbFilterId* poRFilterId) {

    if ( _bTmcActive == TRUE ) {    
        if ( poRFilterId->u8FilterId == (tU8)enDabDbFilterId_TMC){
            ETG_TRACE_USR4(("dabdrv_dataSrvList::vProcess(trMeca_RDbFilterId) enFilterResponse %x ", poRFilterId->enFilterResponse));

            if ( poRFilterId->enFilterResponse == enMeca_DbFilterResponse_NEW_OK ){
                poRFilterId->vTrace();
                _bFilterValid = TRUE;
            }
            else {
                _bFilterValid = FALSE;
            }
        }
    }
}
#endif

tBool dabdrv_dataSrvList::bGetEnsembleInfo(trMecaEnsemble const &rRefEnsemble, set<trMecaProgrammeService>&lServiceList) {
    tBool bRes=FALSE;
    lServiceList.clear();
    
    DAB_IF_FIND_MAP(trMecaEnsemble, trDataListEnsembleInfo, iterSrvMap,  _mapEnsembleInfo, rRefEnsemble) {
        lServiceList=iterSrvMap->second.lServiceList;
        bRes=TRUE;
    }
    return bRes;
}

