/************************************************************************
 * FILE:       dabdrv_compSelect.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of dabdrv_compSelect
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#include "dabdrv_main.hpp"
#include "dabdrv_mecaIf.h"
#include "dabdrv_compList.hpp"
#include "dabdrv_chnInfo.hpp"
#include "dabdrv_compInfo.hpp"
#include "dabdrv_compSelect.hpp"
#include "dabdrv_mute.hpp"
#include "dabdrv_rdm.hpp"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_DRV_COMP 
#include "trcGenProj/Header/dabdrv_compSelect.cpp.trc.h"
#endif

using namespace DAB;

namespace DAB {
    // Timer
    // a timer-event
    struct trMsgCompSelectSupervision:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "trMsgCompSelectSupervision"));
        };
    };
	
	#ifdef MUTE_ACTIVE
    // Timer
    // a timer-event
    struct trMsgMuteSupervision:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "trMsgMuteSupervision"));
        };
    };
#endif

}


dabdrv_compSelect::dabdrv_compSelect(tVoid):
    _enCompSelectState(enCompSelectState_Idle),
    _bSupervisionEscalation(FALSE),
    _enChnState(enChnState_Invalid),
	_u16CurrScidi(0xffff),
	bChnSelectFlag(TRUE)
 {
    vSubscribe<trMeca_RRdmAudioComponentPlay>();
    vSubscribe<trMsgDrvCmdCompSelect>();
    vSubscribe<trMsgDrvRspMuteDone>();
    vSubscribe<trMsgDrvRspCompListScidiMonitor>();
    vSubscribe<trMsgDrvCmdChnSelectState>();
    vSubscribe<trMsgDrvCmdCompSelectFromSrvList>();
	vSubscribe<trMeca_RRdmAudioGetScidi>();


    
}

dabdrv_compSelect::~dabdrv_compSelect(tVoid) {}

tVoid dabdrv_compSelect::vTraceState() const {
    ETG_TRACE_USR1(("  dabdrv_compSelect STATE:_enCompSelectState=%d _activeChnSelect:source=%d mode=%d value=0x%08x bNegative=%d "
                    "_rPendingChnListElem: u16Id=%d u16Scidi=0x%04x "
                    "_bSupervisionEscalation=%d tmrRunning=%d",
                    ETG_CENUM(tenCompSelectState, _enCompSelectState),
                    ETG_CENUM(tenChnSelectSource, _activeChnSelect.enChnSelectSource),
                    ETG_CENUM(tenChnSelectMode, _activeChnSelect.enChnSelectMode),
                    _activeChnSelect.u32Value,
                    _activeChnSelect.bNegative,
                    _rPendingChnListElem.u16Id,
                    _rPendingChnListElem.rMecaId.u16GetScidi(),
                    _bSupervisionEscalation,
                    _oCompSelectSupervisionTimer.bIsRunning()));
    ETG_TRACE_USR1(("  dabdrv_compSelect STATE (cont): _enChnState=%d",
                    ETG_CENUM(tenChnState, _enChnState)));
    
}


tVoid dabdrv_compSelect::vInit() {
    _oCompSelectSupervisionTimer.vInit(instance(), trMsgCompSelectSupervision()); 
#ifdef MUTE_ACTIVE
    _oMuteSupervisionTimer.vInit(instance(), trMsgMuteSupervision());
#endif
 
}

tVoid dabdrv_compSelect::vDeInit() {
    _oCompSelectSupervisionTimer.vDeInit();
#ifdef MUTE_ACTIVE
    _oMuteSupervisionTimer.vDeInit();
#endif
}

trChnListElem dabdrv_compSelect::rValidateRequest(trMsgDrvCmdCompSelect const *poDrvCmdCompSelect) const {
        switch (poDrvCmdCompSelect->enChnSelectMode) {
            case enChnSelectMode_Psid:
            {
                trMecaProgrammeService rProgService(poDrvCmdCompSelect->u32Value);
                return dabdrv_compList::instance()->rGetCompInfo(rProgService);
            }
            case enChnSelectMode_ListId:
                return dabdrv_compList::instance()->rGetElemFromFrozenList((tU16)poDrvCmdCompSelect->u32Value);
            case enChnSelectMode_Relative:
            {
                tS32 s32Steps=(tS16)(poDrvCmdCompSelect->u32Value) * (tS8)(poDrvCmdCompSelect->bNegative ? -1 : 1);
                return dabdrv_compList::instance()->rGetElemRelative((tS16)s32Steps);
            }
            case enChnSelectMode_Invalid:
            default:
                break;

        }
        trChnListElem rChnListElem;
        return rChnListElem;
}

tVoid dabdrv_compSelect::vPropagateNewScidi() {
    // set new channel-info
    trMsgDrvIndPreChnSelect rChnIndPreChnSelect(TRUE);
    DAB_vCallMsg(rChnIndPreChnSelect);
		ETG_TRACE_USR1(("dabdrv_compSelect::vPropagateNewScidi _rPendingChnListElem.bPSFlag=%d _rPendingChnListElem.u16Scids=%d",_rPendingChnListElem.bPSFlag,_rPendingChnListElem.u16Scids));
	trMsgDrvCmdSetCompInfoScidi rDrvCmdSetCompInfoScidi(_rPendingChnListElem.rMecaId, _rPendingChnListElem.bPSFlag, _rPendingChnListElem.u16Scids, _enChnState);
    DAB_vCallMsg(rDrvCmdSetCompInfoScidi);
    trMsgDrvIndPostChnSelect rChnIndPostChnSelect(TRUE);
    DAB_vCallMsg(rChnIndPostChnSelect);
	
	trMecaProgrammeService rProgService(_rPendingChnListElem.rMecaId._u32Id,_rPendingChnListElem.rMecaId._enServiceType,_rPendingChnListElem.u16Scids);
	ETG_TRACE_USR1(("dabdrv_compSelect::vPropagateNewScidi"));
	trMsgDrvCmdSetChnInfoPsid rDrvCmdSetChnInfoPsid(rProgService);
    DAB_vCallMsg(rDrvCmdSetChnInfoPsid);
}

tVoid dabdrv_compSelect::vSendSelectScidi() {
	ETG_TRACE_USR1(("dabdrv_compSelect::vSendSelectScidi"));
    //trMsgDrvCmdSetDabSrvFollowClass rSetSrvFollowClass(enSrvFollowClass_Off);//jab4kor:shd be removed??
    //DAB_vCallMsg(rSetSrvFollowClass);

    trMeca_CRdmAudioComponentPlay rCRdmAudioPlay;
	rCRdmAudioPlay.rMecaProgrammeService=_rPendingChnListElem.rMecaId.rGetProgService();
	rCRdmAudioPlay.u8SCIDS=(tU8)_rPendingChnListElem.u16Scids;
    rCRdmAudioPlay.u16SCIDI=0xffff;
    dabdrv_mecaIf::instance()->vSendMecaCommand(rCRdmAudioPlay);

    _bSupervisionEscalation=FALSE;
    _oCompSelectSupervisionTimer.vStart(DAB_COMP_SELECT_WAIT_TIMER_MS);

}

#ifdef MUTE_ACTIVE
void dabdrv_compSelect::vSetMute()
{
	DAB_trTunerStatusProperty oTunerStatus = dabdrv_properties::instance()->oTunerStatusProperty.oGet();
	tenMuteOperation enMuteOp=dabdrv_main::instance()->enGetMuteOperation();
	ETG_TRACE_USR1(("  dabdrv_compSelect:vSetMute enMuteOp(%d)",enMuteOp));

	if((enMuteOp==enMuteOperation_ServiceSeek) ||
			(enMuteOp==enMuteOperation_LoadFromList) ||
			(enMuteOp==enMuteOperation_PresetLoad) ||
			(enMuteOp==enMuteOperation_EnsembleSeek)){
		ETG_TRACE_USR1(("  dabdrv_compSelect:vSetMute enMuteOp(%d)",enMuteOp));
	}
	else{
			return;
	}

	tenMuteOperation enNextMuteOp=dabdrv_main::instance()->enGetNextMuteOperation();
	if(enNextMuteOp != enMuteOperation_None){
		/*As mute actions are no more sequential, next mute operation would already be handled if it comes */
		dabdrv_main::instance()->enSetNextMuteOperation(enMuteOperation_None);
		
	}
	
		trMsgDrvCmdTunerOpMuteReq rMuteReq;
		rMuteReq.enRequiredMuteState=enRequiredMuteState_Demute;
		//rMuteReq.enMuteOperation=enMuteOp;
		DAB_vCallMsg(rMuteReq);


		if (enMuteOp == enMuteOperation_LoadFromList|| enMuteOp == enMuteOperation_ServiceSeek)
        {
            trMsgSrvRspChnSelect rSrvRsp;
            rSrvRsp.enRes = bChnSelectFlag ? DAB_enResult_OK : DAB_enResult_NOT_AVAILABLE;
            DAB_vCallMsg(rSrvRsp);
            bChnSelectFlag = TRUE;            
        }

		dabdrv_main::instance()->enSetMuteOperation(enMuteOperation_None);
		oTunerStatus.enTunerActivityType = DAB_enTunerActivityType_NORMAL;
		dabdrv_properties::instance()->oTunerStatusProperty.vSet(oTunerStatus);
		ETG_TRACE_USR1(("dabdrv_compSelect:vSetMute Sent Demute"));
}
#endif


tVoid dabdrv_compSelect::vUpdate(tenCompSelectState enCompSelectState, tenChnState enChnState) {
    ETG_TRACE_USR1(("  dabdrv_compSelect vUpdate: _enChnState=%d enChnState=%d enChnSelectSource=%d",
                    ETG_CENUM(tenChnState, _enChnState),
                    ETG_CENUM(tenChnState, enChnState),
                    ETG_CENUM(tenChnSelectSource, _activeChnSelect.enChnSelectSource)));

	ETG_TRACE_USR1(("  dabdrv_compSelect vUpdate: enCompSelectState=%d _enCompSelectState=%d",
                    ETG_CENUM(tenCompSelectState, enCompSelectState),
                    ETG_CENUM(tenCompSelectState, _enCompSelectState)));

    if (_enCompSelectState !=enCompSelectState) {
        _enCompSelectState=enCompSelectState;
        // inform system about new activity
        if (_enCompSelectState==enCompSelectState_WaitGo) {
            vRequestCompMute();
        } else if (_enCompSelectState==enCompSelectState_Idle) {
            if (enChnState==enChnState_Unavail) {
                // the component is no longer available.
                DAB_vCallMsgCtor(trMsgDrvIndCompModeFailed());
            }
        }
    }
    
    if (_activeChnSelect.enChnSelectSource==enChnSelectSource_Lsm 
        && bIsChnStateSelecting(enChnState) 
        && _enChnState==enChnState_SelectingWait) {
        // selecting-wait was already entered during previous channel-selection
        ETG_TRACE_USR1(("Fix to enChnState_SelectingWait"));
        enChnState=enChnState_SelectingWait;
    }
    if (enChnState != _enChnState && enChnState != enChnState_Invalid) {
        _enChnState = enChnState;
        //        trMsgDrvCmdChnSelectState rCmdChnSelectState(enChnState, TRUE);
        DAB_vCallMsgCtor(trMsgDrvCmdChnSelectState(enChnState, TRUE));        
    }

}

tBool dabdrv_compSelect::vRequestCompMute() {
    if (_enCompSelectState==enCompSelectState_WaitGo) {
        _enCompSelectState=enCompSelectState_WaitMute;
        vPropagateNewScidi();
        trMsgDrvCmdRequestMute rRequestMute;
        DAB_vCallMsg(rRequestMute);
        return TRUE;
    }
    // todo: assert here
    return FALSE;
}

tVoid dabdrv_compSelect::vProcess(trMsgDrvRspMuteDone *poDrvRspMuteDone) {
    (tVoid)poDrvRspMuteDone;
    if (_enCompSelectState == enCompSelectState_WaitMute) {
        vUpdate(enCompSelectState_Sent, enChnState_Selecting);
        vSendSelectScidi();
    }
}

tVoid dabdrv_compSelect::vProcess(trMsgCompSelectSupervision* poCompSelectSupervision) {
    (tVoid)poCompSelectSupervision;
    ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                        "vProcess::trMsgCompSelectSupervision: _bSupervisionEscalation=%d",
                        _bSupervisionEscalation));
    if (!_bSupervisionEscalation) {
        vUpdate(_enCompSelectState, enChnState_SelectingWait);
        _bSupervisionEscalation=TRUE;
    } else {
        // fake failed selection;
        trMeca_RRdmAudioComponentPlay rPlayScidi;
        rPlayScidi.bComponentOk=FALSE;
        vProcess(&rPlayScidi);
    }
}

#ifdef MUTE_ACTIVE
tVoid dabdrv_compSelect::vProcess(trMsgMuteSupervision* poMuteSupervision) {
    (tVoid)poMuteSupervision;
    ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                        "vProcess::trMsgMuteSupervision: _bSupervisionEscalation=%d",
                        _bSupervisionEscalation));
    vSetMute();

}
#endif

tVoid dabdrv_compSelect::vProcess(trMsgDrvRspCompListScidiMonitor *poMonitor) {
    if (!dabdrv_main::instance()->bIsCompMode()) {
        return;
    }
    if (poMonitor->bNew) {
        tU16 u16Scidi= (tU16)dabdrv_compInfo::instance()->rGetCompInfo().rMecaId.u16GetScidi();
        ETG_TRACE_USR1(("dabdrv_compSelect::trMsgDrvCmdCompListScidiMonitor u16Scidi=0x%04x",
                        u16Scidi));
        trMsgDrvCmdCompSelect oCompSelect;
        oCompSelect.enChnSelectSource=enChnSelectSource_Lsm;
        oCompSelect.enChnSelectMode= enChnSelectMode_Psid;
        oCompSelect.u32Value=u16Scidi;
        DAB_vCallMsg(oCompSelect);
    } else if (poMonitor->bLost) {
        // the component is no longer available.
        DAB_vCallMsgCtor(trMsgDrvIndCompModeFailed());
    }
}

tVoid dabdrv_compSelect::vProcess(trMsgDrvCmdChnSelectState *poDrvCmdChnSelectState) {
    if (poDrvCmdChnSelectState->enChnState == enChnState_Invalid && _enCompSelectState!=enCompSelectState_Idle && !poDrvCmdChnSelectState->bCompMode) {
        // the component is no longer available: the service our component belongs to could not be selected, leave comp-mode
        vUpdate(enCompSelectState_Idle, enChnState_Unavail);
    }
    else if (_activeChnSelect.enChnSelectSource==enChnSelectSource_Lsm && !poDrvCmdChnSelectState->bCompMode && dabdrv_main::instance()->bIsCompMode()) {
        if (bIsChnStateSelecting(poDrvCmdChnSelectState->enChnState)) {
            // use chnSelectState of srv-selection for comp-selection
            trMsgDrvCmdChnSelectState rCmdChnSelectState(poDrvCmdChnSelectState->enChnState, TRUE);
            _enChnState=poDrvCmdChnSelectState->enChnState;
            DAB_vCallMsg(rCmdChnSelectState); 
        }
    }
}

tVoid dabdrv_compSelect::vProcess(trMsgDrvCmdCompSelect *poDrvCmdCompSelect) {
    _activeChnSelect = *poDrvCmdCompSelect;
    _oCompSelectSupervisionTimer.vStop();
#ifdef MUTE_ACTIVE
if(_oMuteSupervisionTimer.bIsRunning())
    _oMuteSupervisionTimer.vStop();
#endif

	_rPendingChnListElem= rValidateRequest(poDrvCmdCompSelect);
    if (!_rPendingChnListElem.bIsValid()) {
        if (poDrvCmdCompSelect->enChnSelectSource==enChnSelectSource_Lsm) {
            // enable monitor to get trigger when component is available
            DAB_vCallMsgCtor(trMsgDrvCmdCompListScidiMonitor(trMecaId((tU16)poDrvCmdCompSelect->u32Value)));
            _oCompSelectSupervisionTimer.vStart(DAB_COMP_SELECT_WAIT_TIMER_MS);
        }
		bChnSelectFlag = FALSE;
#ifdef MUTE_ACTIVE		
        vSetMute();
#endif
        //poDrvCmdCompSelect->enRes=DAB_enResult_NOT_AVAILABLE;
        return;
    }
    // enable monitor to get trigger when component is lost
    DAB_vCallMsgCtor(trMsgDrvCmdCompListScidiMonitor(trMecaId((tU16)poDrvCmdCompSelect->u32Value)));

    switch (_enCompSelectState) {
        case enCompSelectState_Idle:
            vUpdate(enCompSelectState_WaitGo);
            break;
        case enCompSelectState_WaitGo:
        case enCompSelectState_WaitMute:
            break;
        case enCompSelectState_Sent:
            vSendSelectScidi();
            vUpdate(enCompSelectState_Sent, enChnState_Selecting);
            break;
        default:
            break;
    }
}


tVoid dabdrv_compSelect::vProcess(trMsgDrvCmdCompSelectFromSrvList *poDrvCmdCompSelect) {
	ETG_TRACE_USR1(("dabdrv_compSelect::trMsgDrvCmdCompSelectFromSrvList poDrvCmdCompSelect->ochnListElem.rMecaId._u32Id=0x%08x poDrvCmdCompSelect->ochnListElem.u16Scids=%d",
		poDrvCmdCompSelect->ochnListElem.rMecaId._u32Id,poDrvCmdCompSelect->ochnListElem.u16Scids));

    _rPendingChnListElem= poDrvCmdCompSelect->ochnListElem;
    if (!_rPendingChnListElem.bIsValid()) {
        poDrvCmdCompSelect->enRes=DAB_enResult_NOT_AVAILABLE;
        return;
    }
    // enable monitor to get trigger when component is lost
    //DAB_vCallMsgCtor(trMsgDrvCmdCompListScidiMonitor(trMecaId((tU16)poDrvCmdCompSelect->u32Value)));

	ETG_TRACE_USR1(("dabdrv_compSelect::trMsgDrvCmdCompSelectFromSrvList _enCompSelectState=%d",
		ETG_CENUM(tenCompSelectState, _enCompSelectState)));

    switch (_enCompSelectState) {
        case enCompSelectState_Idle:
            vUpdate(enCompSelectState_WaitGo);
            break;
        case enCompSelectState_WaitGo:
        case enCompSelectState_WaitMute:
            break;
        case enCompSelectState_Sent:
            vSendSelectScidi();
            vUpdate(enCompSelectState_Sent, enChnState_Selecting);
            break;
        default:
            break;
    }
}

// todo: timer-supervision if we don't get the correct psid or the final result enMeca_RdmServiceState_SERVICE_SELECTION_DONE
// todo: timer-supervision for advisorys like "searching"
tVoid dabdrv_compSelect::vProcess(trMeca_RRdmAudioComponentPlay* poMecaRRdmPlayScidi) {
    _oCompSelectSupervisionTimer.vStop();
	trMsgSrvRspCompSelect rSrvRsp;
    if (poMecaRRdmPlayScidi->bComponentOk) {
        vUpdate(enCompSelectState_Idle, enChnState_Stable);
#ifdef MUTE_ACTIVE
        //vSetMute();
		/*if timer is running for an older service selection and if a new request comes,stop timer and start delay again*/
			if(_oMuteSupervisionTimer.bIsRunning()){
				_oMuteSupervisionTimer.vStop();
			}
        _oMuteSupervisionTimer.vStart(DAB_MUTE_SUPERVISION_TIMER_MS);
#endif
    }
    else {
        vUpdate(enCompSelectState_Idle, enChnState_Unavail);
		rSrvRsp.enRes = DAB_enResult_FAILED;
#ifdef MUTE_ACTIVE
        vSetMute();
#endif
    }
	DAB_vCallMsg(rSrvRsp);
}

tVoid dabdrv_compSelect::vProcess(trMeca_RRdmAudioGetScidi *poRRdmAudioGetScidi) {
    
    if (!dabdrv_main::instance()->bIsCompMode()) {
        return;
    }

	trChnListChnInfo rCurChnInfo = dabdrv_chnInfo::instance()->rGetChnInfo();	
	ETG_TRACE_USR4(("dabdrv_compSelect::vProcess(trMeca_RRdmAudioGetScidi):rCurChnInfo.rMecaId._u32Id=%x rCurChnInfo.u16Scids=%d",rCurChnInfo.rMecaId._u32Id,rCurChnInfo.u16Scids));
	DAB_trChnInfoProperty rChnInfoProperty=dabdrv_properties::instance()->oChnInfoProperty.oGet();
	
    ETG_TRACE_USR4(("dabdrv_compSelect::vProcess(trMeca_RRdmAudioGetScidi):rChnInfoProperty.bComponentMode=%d  current Scidi=%x recieved Scidi=%x",rChnInfoProperty.bComponentMode, _u16CurrScidi, poRRdmAudioGetScidi->u16SCIDI));

//NCG3D-40183 - On selection if the secondary service is not available, primary should play and primary service
// information should be updated in chninfo.
	if((poRRdmAudioGetScidi->u16SCIDI!=0xffff) &&  
		(
		(0 == (poRRdmAudioGetScidi->u16SCIDI & 0x0f00) ) || 
		(0x0f00 == (poRRdmAudioGetScidi->u16SCIDI & 0x0f00))
		)
		)
	{
		ETG_TRACE_USR4(("dabdrv_compSelect::vProcess(trMeca_RRdmAudioGetScidi):switch back to primary service"));
		dabdrv_main::instance()->bSetCompMode(FALSE);
		trChnListKey rchnListKey(rCurChnInfo.rMecaId);
		dabdrv_presets::instance()->vResetSelectSource();
		//Channel state should be updated when switching from Secondary to primary.
		dabdrv_chnInfo::instance()->bUpdateProperty(rchnListKey ,TRUE, FALSE);  //NCG3D-85694
	}

	/** Scholz Maik (CM-AI/ECB2) Do 20.11.2014 15:30
	In most situation, it is like this:
	SCIDI = 0xffff						=> no current component or component not in current ensemble
	SCIDI = 0x*0**						=> primary component
	SCIDI = 0x****, not 0x*0**, not 0x*f**		=> secondary component
	SCIDI = 0x*f**, not 0xffff				=> no SCIDS available (in your situation, assume primary component)

	*/
	if(poRRdmAudioGetScidi->u16SCIDI!=0xffff)
		_u16CurrScidi=poRRdmAudioGetScidi->u16SCIDI;
}


