/************************************************************************
 * FILE:       dabdrv_compList.hpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of dabdrv_compList
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#ifndef DABDRV_COMP_LIST_HPP
#define DABDRV_COMP_LIST_HPP

#include "fc_dabtuner_util.h"
#include "dabdrv_types.hpp"
#include "dabdrv_main.hpp"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_DRV_COMPLST
#include "trcGenProj/Header/dabdrv_compList.hpp.trc.h"
#endif

namespace DAB {

    struct trMsgCompList1sTick;
    struct trMsgCompListUpdateTimer;
    struct trMsgDrvCmdSetChnInfoPsid;
    struct trMsgDrvCmdChnSelect;
    struct trMsgDrvIndPreChnSelect;

    class dabdrv_compList:
        public DAB_Singleton <dabdrv_compList>,
        public DAB_MessageHandlerCommon<dabdrv_compList>
    {
        friend class DAB_Singleton<dabdrv_compList>;

    public:
        DAB_TRACE_INFO_IMPL(FC_DABTUNER_TR_DRV_COMPLST);
        virtual tVoid vInit();
        virtual tVoid vDeInit();
        
        virtual char const *pcGetName() const {return "dabdrv_compList";};
        virtual tVoid vTraceState() const;

        virtual tVoid vProcess(trMsgDrvStartComponent* poStart);
        virtual tVoid vProcess(trMsgDrvStopComponent* poStop);

        virtual tVoid vProcess(trMsgDrvCmdCompListScidiMonitor *poSetScidiMonitor);
        virtual tVoid vProcess(trMsgDrvCmdSourceState* poSourceState);

        virtual tVoid vProcess(DAB::trMsgSrvCmdSetCompList *poCmdOpenList);
        virtual tVoid vProcess(trMsgDrvCmdSetChnInfoPsid  *poSidPsid);
        virtual tVoid vProcess(trMsgDrvCmdChnSelect  *poDrvCmdChnSelect);
        virtual tVoid vProcess(trMsgDrvIndPreChnSelect *poIndPreChnSelect);

        virtual tVoid vProcess(trMeca_RDbServiceGetComponentList* poCompList);
        virtual tVoid vProcess(trMeca_RDbServiceComponentGetInfo* poCompInfo);


        // pseudo-private
        virtual tVoid vProcess(trMsgCompList1sTick* po1sTick);

        virtual tVoid vProcess(trMsgCompListUpdateTimer* poCompListUpdateTimer);

        trChnListElem rGetElemFromFrozenList(tU16 u16ElemId);

        trChnListChnInfo rGetCompInfo(trMecaId const &rMecaId);
        trMecaLabel rGetLabel(trMecaId const &rMecaId);
        tU16 u16GetFrozenListId(trMecaId const &rMecaId);
        trChnListElem rGetElemRelative(tS16 s16Steps);
        tU8 u8GetNumComponents(trMecaId const &rMecaId) const;

    private:
        typedef enum {
            enListElemUpdateState_Virgin,
            enListElemUpdateState_Changed,
            enListElemUpdateState_Ok
        } tenListElemUpdateState;

        typedef enum {
            enListCheckState_Virgin,
            enListCheckState_Changed,
            enListCheckState_Refresh,
            enListCheckState_Done
        } tenListCheckState;

        struct trCompListServiceInfo{
            trCompListServiceInfo():
                bServiceInfoPresent(FALSE),
                bFoundInSrvList(0),
                lEnsembles(),
                bLabelPresent(FALSE),
                enListElemUpdateState(enListElemUpdateState_Virgin),
                bNew(TRUE),
                rLabel(),
                u16Scidi(0),
                bPrim(FALSE),
                u32UpdateId(0)
            {};

            operator trChnListElem() {
                trChnListElem rRes;
                rRes.u16Id= 0;
                rRes.rMecaId=trMecaId(u16Scidi);
                rRes.rLabel=rLabel;
                return rRes;
            }

            tBool bServiceInfoPresent;
            tBool bFoundInSrvList;
            list<trMecaEnsemble>lEnsembles;
            tBool bLabelPresent;
            tenListElemUpdateState enListElemUpdateState;
            tBool bNew;
            trMecaLabel rLabel;
            tU16 u16Scidi;
            tBool bPrim;
            tU32 u32UpdateId;

        };

        struct trCompListServiceInfoCompare
        {
            bool operator()(const trCompListServiceInfo& srv1, const trCompListServiceInfo& srv2) const
            {
                return (srv1.rLabel < srv2.rLabel);
            }
        };
        tVoid vTraceAll() const ;
        tVoid vTraceCompInfo(trCompListServiceInfo const &rCompInfo) const;
        tVoid vTraceCompInfo(trChnListElem const &rCompInfo) const;
        tBool bDynSrvListUpToDate() const;
        tVoid vPrepareDynCompList();
        tVoid vOpenFrozenCompList();
        tU16 u16GetActivatedElemId() const;
        trMecaId rGetCurrentSid() const;
        tVoid vSendFrozenCompList(tBool bForced=FALSE);
        tVoid vClearCompList(tenListCheckState enListCheckState=enListCheckState_Done);
        tVoid vClearFrozenCompList();
        tVoid vUpdateNumComponents();
        tVoid vRequestNextCompInfo();
        tVoid vStartCompInfoCollect();
        tBool bIsFrozenCompListOpen() const {return _enFrozenCompListState==enFrozenCompListState_Open;};
        tBool bIsCompListValid() const {return (tU32)_enListCheckState>(tU32)enListCheckState_Virgin;};
        tVoid vSetPsid(trMecaProgrammeService const &rProgSrv=trMecaProgrammeService());

        dabdrv_compList();
        DAB_tclTimer _oCompListUpdateTimer;
  
        DAB_tclTimer _oCompListCollectTimer;
        map<trMecaId, trCompListServiceInfo >_mapCompInfo;
        map<trMecaId, trCompListServiceInfo >::iterator _iterUpdate;

        multimap<trMecaLabel, trMecaId>_mapDynSrvByLabel;

        typedef enum {
            enFrozenCompListState_Closed,
            enFrozenCompListState_ClosedSent,
            enFrozenCompListState_Pending,
            enFrozenCompListState_Open
        } tenFrozenCompListState;

        // frozen chnList
        map<trMecaId, tU16>_mapFrozenIndexBySrv;
        vector<trChnListElem>_vectorFrozenCompList;

        tBool _bCompListValid;

        struct trCompMonitor {
            trMecaId rScidi;
            tBool bPresent;

            trCompMonitor(trMecaId const &rScidi_=trMecaId()):
                rScidi(rScidi_),
                bPresent(FALSE)
            {}
            tVoid vInvalidate() {
                *this=trCompMonitor();
            }
            tBool bIsValid() const {return rScidi.bIsValid();}
        };

        trCompMonitor _rCompMonitor;
        tU32 _u32UpdateId;
        tenListCheckState _enListCheckState;
        tenFrozenCompListState _enFrozenCompListState;
        tU16 _u16LastUpdatedScidi;
        trMecaId _rCurSid;
        tBool _bWaitCompList;
        tU8 _u8NumComponents;

        dabdrv_trTickTimer<dabdrv_compList, trMsgCompList1sTick, 1> *poGet1sTickTimer() const {
            return dabdrv_trTickTimer<dabdrv_compList, trMsgCompList1sTick, 1>::instance(); 
        }


        
    };
} //namespace DAB 

#endif
