/************************************************************************
 * FILE:       dabdrv_compInfo.hpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of dabdrv_compInfo
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#ifndef DABDRV_COMP_INFO_HPP
#define DABDRV_COMP_INFO_HPP

#include "fc_dabtuner_config.h"
#include "dabdrv_meca.h"
#include "dabmeca_db.hpp"
#include "dabmeca_rdm.hpp"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_DRV_COMP
#include "trcGenProj/Header/dabdrv_compInfo.hpp.trc.h"
#endif

namespace DAB {

    //lint -esym(763, DAB::trMsgDrvCmdSetChnInfoPsid)  Redundant declaration for symbol
    struct trMsgDrvCmdSetChnInfoPsid;

    struct trCompInfoUsrData {
        trMecaId rSid;
        trMecaId rScidi;
        tBool bLabelPresent;
        trMecaLabel rLabel;

        trCompInfoUsrData():bLabelPresent(FALSE)
        {}
        // persistant data serialization
        tVoid vSerialize(DAB_Serializer &rSerializer) const {
            rSerializer.vSerialize(rSid);
            rSerializer.vSerialize(rScidi);
            rSerializer.vSerialize(bLabelPresent);
            rSerializer.vSerialize(rLabel);
        }
            
        tVoid vParse(DAB_Parser &rParser) {
            if (rParser.u8GetVerMin()>=2) {
                rParser.vParse(rSid);
                rParser.vParse(rScidi);
                rParser.vParse(bLabelPresent);
                rParser.vParse(rLabel);
            }
        }

        tVoid vTrace() {
            ETG_TRACE_USR4(("  trChnInfoUsrData:rMecaId=0x%08x u16Scidi=0x%04x bLabelPresent=%d label:%s",
                            rSid.u32GetSID(),
                            rScidi.u16GetScidi(),
                            bLabelPresent,
                            rLabel.pcGetCString()));
        }    };

    struct trMsgDrvCmdCompChangeFailed:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL

        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "trMsgDrvCmdCompChangeFailed"));
        }
    };
 
struct trMsgDrvCmdSetCompInfoScidi:
        public DAB_Message
{
    DAB_DISPATCH_IMPL
    trMsgDrvCmdSetCompInfoScidi(trMecaId const &rMecaId_=trMecaId(), tBool bPSFlag_=TRUE, tU16 u16Scids_ =0, tenChnState enChnState_=enChnState_Selecting):
        rMecaId(rMecaId_),
		bPSFlag(bPSFlag_),
		u16Scids(u16Scids_),
        enChnState(enChnState_)
    {}

    virtual tVoid vTrace() const {
        ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                            "trMsgDrvCmdSetCompInfoScidi:Scidi=0x%04x, bPSFlag=%d u16Scids=%d enChnState=%d",
                            rMecaId.u16GetScidi(),
							bPSFlag,
							u16Scids,
                            ETG_CENUM(tenChnState, enChnState)));
    }

    trMecaId rMecaId;
	tBool bPSFlag;
	tU16 u16Scids;
    tenChnState enChnState;
};


    class dabdrv_compInfo:
        public DAB_Singleton <dabdrv_compInfo>,
        public DAB_MessageHandlerCommon<dabdrv_compInfo>
    {
        friend class DAB_Singleton<dabdrv_compInfo>;

    public:
        DAB_TRACE_INFO_IMPL(FC_DABTUNER_TR_DRV_COMP);
        virtual ~dabdrv_compInfo(tVoid);    
        virtual tVoid vInit();

    
        virtual tVoid vDeInit();

        virtual char const *pcGetName() const {return "dabdrv_compInfo";};
        virtual tVoid vTraceState() const;

        virtual tVoid vProcess(DAB::trMsgDrvStartComponent* poStart);

        virtual tVoid vProcess(DAB::trMsgDrvStopComponent* poStop);

        virtual tVoid vProcess(DAB::trMsgDrvCmdSetCompInfoScidi *poSetScidi);

        virtual tVoid vProcess(DAB::trMsgDrvCmdSetChnInfoPsid *poSetPsid);

        virtual tVoid vProcess(trMsgDrvRspCompListScidiMonitor *poMonitor);

        virtual tVoid vProcess(DAB::trMsgDrvCmdCompChangeFailed *poCompChangeFailed);

        virtual tVoid vProcess(DAB::trMsgDrvCmdFrozenCompListStatus *poFrozenCompListStatus);

        tU8 u8GetSubChannelId() const;


        trChnListChnInfo const &rGetCompInfo() const;

        tVoid vGetUserData(trCompInfoUsrData *prCompInfoUsrData) const;
        tVoid vSetUserData(trCompInfoUsrData const &rCompInfoUsrData);

    private:

        dabdrv_compInfo(tVoid);
        
        trChnListChnInfo _rPreselectCompInfo; // todo rename by removing Preselect
        trMecaProgrammeService _rChnInfoProgService;

    };

}

#endif
