/************************************************************************
 * FILE:       dabdrv_chnSelect.hpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of dabdrv_chnSelect
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#ifndef DABDRV_CHN_SELECT_HPP
#define DABDRV_CHN_SELECT_HPP

#include "fc_dabtuner_config.h"
#include "dabdrv_meca.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_DRV_SRV 
#include "trcGenProj/Header/dabdrv_chnSelect.hpp.trc.h"
#endif

namespace DAB {

    struct trMsgChnSelectSupervision;
#ifdef MUTE_ACTIVE
    struct trMsgMuteSupervision;
#endif
    struct trMsgDrvRspMuteDone;
	struct trMsgRspPlayAsidSupervisionTimer;
	struct trMsgChnInfoUpdateTimer :
	public DAB_Message
{
	DAB_DISPATCH_IMPL
		virtual tVoid vTrace() const {
		ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG,
			"trMsgChnInfoUpdateTimer"));
	};
};



    class dabdrv_chnSelect:
        public DAB_Singleton <dabdrv_chnSelect>,
        public DAB_MessageHandlerCommon<dabdrv_chnSelect>
    {
        friend class DAB_Singleton<dabdrv_chnSelect>;

    public:
        DAB_TRACE_INFO_IMPL(FC_DABTUNER_TR_DRV_SRV);
        virtual ~dabdrv_chnSelect(tVoid);    
        virtual tVoid vInit();
        virtual tVoid vDeInit();

        virtual char const *pcGetName() const {return "dabdrv_chnSelect";};
        virtual tVoid vTraceState() const;

        virtual tVoid vProcess(trMsgDrvStopComponent *poStopComponent);
        virtual tVoid vProcess(trMsgChnSelectSupervision* poChnSelectSupervision); 
		virtual tVoid vProcess(trMsgChnInfoUpdateTimer *poMsgChnInfoUpdateTimerSupervisionTimer);//CRQ 431566
		tBool bIsTimerRunning()
		{
			return _oChnInfoUpdateSuperVisionTimer.bIsRunning();
		}//CRQ 431566
		
#ifdef MUTE_ACTIVE
        virtual tVoid vProcess(trMsgMuteSupervision* poMuteSupervision);
#endif
		virtual tVoid vProcess(trMsgDrvCmdEnsSelect* poDrvCmdEnsSelect); 
        virtual tVoid vProcess(trMsgDrvCmdChnSelect* poDrvCmdChnSelect); 
        virtual tVoid vProcess(trMsgDrvRspChnListPsidMonitor *poDrvRspChnListPsidMonitor);
        virtual tVoid vProcess(trMsgDrvRspMuteDone *poDrvRspMuteDone);
        virtual tVoid vProcess(trMsgDrvRspSetDabSrvFollowClass *poDrvRspSetDabSrvFollowClass); 

        virtual tVoid vProcess(trMeca_RRdmAudioPlayAsid* poMecaRRdmPlayPsid); 
        virtual tVoid vProcess(trMeca_RRdmGetRdmInfo *poRdmInfo); 
        virtual tVoid vProcess(trMsgDrvFmServiceFollow* poFmServiceFollow);
        virtual tVoid vProcess(trMeca_RRdmServFollowActive* poServFollowActive);
        virtual tVoid vProcess(trMsgDrvCmdSourceState *poSourceState);
		virtual tVoid vProcess(trMeca_RRdmTuneEid* poMecaRRdmTuneEid);
		virtual tVoid vProcess(trMsgDrvCmdRdmTune* poDrvCmdRdmTune);
		virtual tVoid vProcess(trMeca_RRdmTune* poRRdmTune);
		virtual tVoid vProcess(trMsgRspPlayAsidSupervisionTimer* poRspPlayAsidSupervisionTimer);
#ifdef MUTE_ACTIVE
		virtual tVoid vProcess(trMsgDrvCmdTuneFreqlabel* poTuneFreqLabel);
#endif
		virtual tVoid vProcess(trMeca_RRdmTuneFrequencyLabel* poRRdmTuneLabel);
		trChnListElem rGetPendingChnListElem() {return _rPendingChnListElem;} ;
		tVoid vCheckForMute(tBool bStatus);
		tVoid vResetChnInfoProperty();


        typedef enum {
            enChnSelectState_Idle,
            enChnSelectState_WaitGo,
            enChnSelectState_WaitRdmInfo,
            enChnSelectState_WaitMute,
            enChnSelectState_WaitSrvFollow,
            enChnSelectState_Sent,
            enChnSelectState_SentWait,
            enChnSelectState_Hardlinking,
            enChnSelectState_HardlinkingEnd,
            enChnSelectState_Failed,
            enChnSelectState_TuningFreqLabel
        } tenChnSelectState;
		tenChnSelectState enGetChnSelectState(){return _enChnSelectState;};
		tVoid vResetChnSelectState(){_enChnSelectState = enChnSelectState_Idle;};
    private:
		trEnsembleListElem rValidateRequest(trMsgDrvCmdEnsSelect const *poDrvCmdEnsSelect)const;
        trChnListElem rValidateRequest(trMsgDrvCmdChnSelect const *poDrvCmdChnSelect) const;
        tVoid vSendSelectPsid() ;
		tVoid vSendSelectEnsemble()const;
        tVoid vUpdate(tenChnSelectState enChnSelectState, tBool bDirectRetry=FALSE);
        dabdrv_chnSelect(tVoid);
        tVoid vStartSelect();
        tVoid vPropagateNewSid();
        tVoid vRequestServiceMute();
        tVoid vSetMute();  // Removed MUTE_ACTIVE Switch as we need keep the switch inside SetMute inside cpp.
        tVoid vSetAutoSkip();
        trMsgDrvCmdChnSelect _activeChnSelect;
        tenChnSelectState _enChnSelectState;
        tenChnSelectState _enChnSelectStateOrig;
        trChnListElem _rPendingChnListElem;
		trMecaProgrammeService rPgmService; //CRQ
        tU16 _u16NumSkips; 
        trMecaId _rUsrReqProgSrv;
        tBool _bRetry;
        tenChnState _enChnState;
        DAB_tclTimer _oChnSelectSupervisionTimer;
		DAB_tclTimer _otrMsgRspPlayAsidSupervisionTimer;
#ifdef MUTE_ACTIVE
        DAB_tclTimer _oMuteSupervisionTimer;
#endif
        tenMeca_RdmServFollowMode _enMaxSrvFollowMode;
        tBool _bHardLinkingActiv;
        tBool _bForcedActivityTerminate;
        trMecaId _rLastSentPlayAsid;
        DAB_tenTuneType _enTuneType;

		trEnsembleListElem _rPendingChnListEnsembleElem;
        tBool _bDabDabSrvFollowActive;
        DAB_tenSourceState _enSourceState;
        tBool bChnSelectFlag;
		//CRQ 431566
		DAB_tclTimer _oChnInfoUpdateSuperVisionTimer;
		
    };

}


#endif
