/************************************************************************
 * FILE:        dabdrv_chnList.hpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of dabdrv_chnList.hpp
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#ifndef DABDRV_CHN_LIST_HPP
#define DABDRV_CHN_LIST_HPP

#include "fc_dabtuner_util.h"
#include "dabdrv_types.hpp"
#include "dabdrv_main.hpp"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_DRV_SRVLST 
#include "trcGenProj/Header/dabdrv_chnList.hpp.trc.h"
#endif

#define COMP_SERV_LIST 1

#define DAB_MAX_NUM_ENS_FOR_SRV 15
#define DAB_MAX_NUM_SRV_FOR_ENS 30

#define ONE (tU8)1
#define TWO (tU8)2
#define THREE (tU8)3
#define FOUR (tU8)4
#define FIVE (tU8)5
#define SIX (tU8)6
#define SEVEN (tU8)7
#define EIGHT (tU8)8
#define NINE (tU8)9
#define TEN (tU8)10
#define ELEVEN (tU8)11
#define TWELVE (tU8)12
#define THIRTEEN (tU8)13

#define QUERY_LENGTH 512
#define FIELD_LENGTH 10
#define PTY_MASK 0x3fffffff

#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
#define DB_QUERY_EXCLUDE_ECC "SELECT rdm_sttnum(P.n), S.r_service, S.stype, S.label, C.label, C.scids, C.ps,(E.quality_word&0x40)!=0 AS not_rx, asuflags, s_intpty FROM dab_ensemble AS E, v1f1_dab_service AS S ON E.o=S.e, v1f1_dab_service_component AS C ON  S.o=C.s LEFT JOIN dab_service_preset AS P ON P.servecc=S.servecc AND S.sid=P.sid WHERE E.eid="
#define DB_QUERY_INCLUDE_ECC "SELECT rdm_sttnum(P.n), S.r_service, S.stype, S.label, C.label, C.scids, C.ps,(E.quality_word&0x40)!=0 AS not_rx, asuflags, s_intpty FROM dab_ensemble AS E, v1f1_dab_service AS S ON E.o=S.e, v1f1_dab_service_component AS C ON  S.o=C.s LEFT JOIN dab_service_preset AS P ON P.servecc=S.servecc AND S.sid=P.sid WHERE (E.ensecc="

#else
#define DB_QUERY_EXCLUDE_ECC "SELECT  (CASE WHEN P.n==0 THEN NULL ELSE P.n END) AS pn,S.r_service,S.stype,S.label,C.label,C.scids,C.ps,(E.quality_word&0x40)!=0 AS not_rx,asuflags,s_intpty FROM dab_ensemble AS E,v1f1_dab_service AS S ON E.o=S.e,v1f1_dab_service_component AS C ON  S.o=C.s LEFT JOIN dab_service_preset AS P ON P.servecc=S.servecc AND S.sid=P.sid WHERE E.eid="
#define DB_QUERY_INCLUDE_ECC "SELECT  (CASE WHEN P.n==0 THEN NULL ELSE P.n END) AS pn,S.r_service,S.stype,S.label,C.label,C.scids,C.ps,(E.quality_word&0x40)!=0 AS not_rx,asuflags,s_intpty FROM dab_ensemble AS E,v1f1_dab_service AS S ON E.o=S.e,v1f1_dab_service_component AS C ON  S.o=C.s LEFT JOIN dab_service_preset AS P ON P.servecc=S.servecc AND S.sid=P.sid WHERE (E.ensecc="
#endif

namespace DAB {

    struct trMsgChnListUpdateTimer;
    struct trMsgChnListAfterLearnTimer;
    struct trMsgChnList1sTick;


    typedef enum {
        enListElemUpdateState_Virgin,
        enListElemUpdateState_Changed,
        enListElemUpdateState_Ok
    } tenListElemUpdateState;

		struct trChnListServiceInfo{
            trChnListServiceInfo():
                rProgService(),
                bServiceInfoPresent(FALSE),
                u8ReceptionQuality(0),
                lEnsembles(),
                bLabelPresent(FALSE),
                enListElemUpdateState(enListElemUpdateState_Virgin),
                u32UpdateId(0),
                rLabel(),
				rEnsembleLabel(),
                u16AvailableAnnoTypesMask(0),
				u8NumberOfSecondaryComponents(0),
				u8PTY(0),
				bPSFlag(TRUE),
				u16Scids(0),
				u8PresetNumber(0),
				bReception(FALSE),
				sFreqLabel("")
            {};

            operator trChnListElem() {
                trChnListElem rRes;
                rRes.u16Id= 0;
                rRes.rMecaId=trMecaId(rProgService);
                //rRes.bReception=bIsReceptionOk(u8ReceptionQuality);
				rRes.bReception=bReception;
                rRes.rLabel=rLabel;
				rRes.rEnsembleLabel=rEnsembleLabel;
				rRes.u8PTY=u8PTY;
				rRes.u8NumberOfComponents=u8NumberOfSecondaryComponents;
				rRes.bPSFlag=bPSFlag;
				rRes.u8PresetNumber=u8PresetNumber;
				rRes.u16Scids=u16Scids;
				rRes.sFreqLabel=sFreqLabel;
                return rRes;
            }

            trMecaProgrammeService rProgService;
            tBool bServiceInfoPresent;
            tU8 u8ReceptionQuality;
            set<trMecaEnsemble>lEnsembles;
            tBool bLabelPresent;
            tenListElemUpdateState enListElemUpdateState;
            tU32 u32UpdateId;
            trMecaLabel rLabel;
			trMecaLabel rEnsembleLabel;
            tU16 u16AvailableAnnoTypesMask;
			tU8 u8NumberOfSecondaryComponents;	
			tU8 u8PTY;
			tBool bPSFlag;
			tU16 u16Scids;
			tU8 u8PresetNumber;
			tBool bReception;
			string sFreqLabel;

            // persistant data serialization
            tVoid vSerialize(DAB_Serializer &rSerializer) const {
                rSerializer.vSerialize(rProgService);
                rSerializer.vSerialize(bServiceInfoPresent);
                rSerializer.vSerialize(u8ReceptionQuality);
                rSerializer.vSerializeSet(lEnsembles);
                rSerializer.vSerialize(bLabelPresent);
                rSerializer.vSerializeEnum(enListElemUpdateState);
                rSerializer.vSerialize(u32UpdateId);
                rSerializer.vSerialize(rLabel);
				rSerializer.vSerialize(rEnsembleLabel);
                rSerializer.vSerialize(u16AvailableAnnoTypesMask);
				rSerializer.vSerialize(u8NumberOfSecondaryComponents);		
				rSerializer.vSerialize(u8PTY);
				rSerializer.vSerialize(bPSFlag);
				rSerializer.vSerialize(u16Scids);
				rSerializer.vSerialize(u8PresetNumber);
				rSerializer.vSerialize(bReception);
            }
            
            tVoid vParse(DAB_Parser &rParser) {
                rParser.vParse(rProgService);
                rParser.vParse(bServiceInfoPresent);
                rParser.vParse(u8ReceptionQuality);
                rParser.vParseSet(lEnsembles);
                rParser.vParse(bLabelPresent);
                rParser.vParseEnum(enListElemUpdateState);
                rParser.vParse(u32UpdateId);
                rParser.vParse(rLabel);
				rParser.vParse(rEnsembleLabel);
                rParser.vParse(u16AvailableAnnoTypesMask);
				rParser.vParse(u8NumberOfSecondaryComponents);
				rParser.vParse(u8PTY);
				rParser.vParse(bPSFlag);
				rParser.vParse(u16Scids);
				rParser.vParse(u8PresetNumber);
				rParser.vParse(bReception);
            }

            
            tVoid vTrace() const {
                ETG_TRACE_USR4(("   trChnListServiceInfo:rProgService=0x%x bServiceInfoPresent=%d u8PTY=%d"
                                "   bReception=%d u8NumEns=%d bLabelPresent=%d enListElemUpdateState=%d"
								"	u16AvailableAnnoTypesMask=0x%04x secondaryComponents=%d u8PresetNumber=%d",
                                rProgService.u32GetSID(),
                                bServiceInfoPresent,
								u8PTY,
                                bReception,
                                lEnsembles.size(),
                                bLabelPresent,
                                ETG_CENUM(tenListElemUpdateState, enListElemUpdateState),
                                u16AvailableAnnoTypesMask,
								u8NumberOfSecondaryComponents,
								u8PresetNumber));                

            };






        };



    struct trChnListEnsembleInfo{
                trMecaEnsemble rEnsemble;
                tU8 u8Quality;
                tU32 u32BestFreq;
                tenListElemUpdateState enUpdateState;
                set<trMecaProgrammeService>lServiceList;
    			DAB::trMecaLabel rLabel;
    			tU8 u8NumberOfAudioServices;
    			tU8 u8NumberOfDataServices;
    			tBool bReception;
    			string Sihash;
    			string sFreqLabel;

    			 operator trEnsembleListElem() {
                    trEnsembleListElem rRes;
                    rRes.u16Id=0;
    				rRes.rEnsemble=rEnsemble;
                    rRes.rEnsembleLabel=rLabel;
    				rRes.u32Frequency=u32BestFreq;
    				rRes.u8NumberOfAudioServices=u8NumberOfAudioServices;
    				rRes.u8NumberOfDataServices=u8NumberOfDataServices;
    				rRes.u8ReceptionQuality=u8Quality;
                    //rRes.bReception=bIsReceptionOk(u8Quality);
    				rRes.bReception=bReception;
    				rRes.sSihash = Sihash;
    				rRes.sFreqLabel = sFreqLabel;
    				return rRes;
                }


                // persistant data serialization
                tVoid vSerialize(DAB_Serializer &rSerializer) const {
                    rSerializer.vSerialize(rEnsemble);
                    rSerializer.vSerialize(u8Quality);
                    rSerializer.vSerialize(u32BestFreq);
                    rSerializer.vSerializeEnum(enUpdateState);
                    rSerializer.vSerializeSet(lServiceList);
    				rSerializer.vSerialize(rLabel);
    				rSerializer.vSerialize(u8NumberOfAudioServices);
    				rSerializer.vSerialize(u8NumberOfDataServices);
    				rSerializer.vSerialize(bReception);
                }

                tVoid vParse(DAB_Parser &rParser) {
                    rParser.vParse(rEnsemble);
                    rParser.vParse(u8Quality);
                    rParser.vParse(u32BestFreq);
                    rParser.vParseEnum(enUpdateState);
                    rParser.vParseSet(lServiceList);
    				rParser.vParse(rLabel);
    				rParser.vParse(u8NumberOfAudioServices);
    				rParser.vParse(u8NumberOfDataServices);
    				rParser.vParse(bReception);
                }

                trChnListEnsembleInfo():
                    rEnsemble(),
                    u8Quality(0),
                    u32BestFreq(0),
                    enUpdateState(enListElemUpdateState_Virgin),
                    lServiceList(),
    				u8NumberOfAudioServices(0),
    				u8NumberOfDataServices(0),
    				bReception(FALSE),
    				Sihash(""),
    				sFreqLabel(""){};

            };





    class dabdrv_chnList:
        public DAB_Singleton <dabdrv_chnList>,
        public DAB_MessageHandlerCommon<dabdrv_chnList>
    {
        friend class DAB_Singleton<dabdrv_chnList>;

    public:
        struct trChnListMachineData;
        DAB_TRACE_INFO_IMPL(FC_DABTUNER_TR_DRV_SRVLST);
        virtual tVoid vInit();
        virtual tVoid vDeInit();
        
        virtual char const *pcGetName() const {return "dabdrv_chnList";};

        virtual tVoid vProcess(trMsgDrvStartComponent* poStart);
        virtual tVoid vProcess(trMsgDrvStopComponent* poStop);
        virtual tVoid vProcess(trMsgChnList1sTick* );

        virtual tVoid vProcess(trMsgDrvCmdChnListPsidMonitor* poSetPsidMonitor);
        virtual tVoid vProcess(trMsgDrvCmdChnListSetCurrentSrv* poSetPsidMonitor);
        virtual tVoid vProcess(trMsgDrvRspCurrentEnsemble *poCurrentEnsemble);
        virtual tVoid vProcess(trMsgDrvEvtLearnDone *poDrvEvtLearnDone);
        virtual tVoid vProcess(trMsgDrvEvtForcedLearnStart *poDrvEvtForcedLearnStart);

        virtual tVoid vProcess(DAB::trMsgSrvCmdSetChnList *poCmdOpenList);
		
		virtual tVoid vProcess(DAB::trMsgSrvCmdSetEnsmbleList *poCmdOpenList);
		virtual tVoid vProcess(DAB::trMsgSrvCmdListUpdateStatus *poCmdListUpdateStatus);
#ifdef OLD_STYLE_LIST_IMPLEMENTATION
        virtual tVoid vProcess(trMeca_RDbGetDbEnsembleList* poEnsembleList);
        //virtual tVoid vProcess(trMeca_RDbEnsembleGetFrequencyList *poEnsFreqList);

        virtual tVoid vProcess(trMeca_RDbEnsembleGetServiceList* poServiceList);
        virtual tVoid vProcess(trMeca_RDbServiceGetInfo* poSrvInfo);

        virtual tVoid vProcess(trMeca_RDbEnsembleGetInfo* poEnsemble);
#endif

		virtual tVoid vProcess(trMeca_RPTYMSetFilter* poPTYMSetFilter);

		virtual tVoid vProcess(trMeca_RDbQuery* poRDbQuery);
		virtual tVoid vProcess(trMeca_RDbQueryTrigger* poRDbQueryTrigger);
		
		virtual tVoid vProcess(trMsgSrvDataList* poMsgSrvDatalist);

		virtual tVoid vOnEnsembleListQueryResponse(trMeca_RDbQuery* poRDbQuery);
		virtual tVoid vHandleEnsembleServiceInfo(trEnsembleServiceList* rEnsSrvInfo);
		virtual tVoid vHandleServiceInfo(trServiceInformation* poServiceInformation);
		virtual tVoid vHandleEnsembleInfo(trEnsembleInfo* poMsgDrvEnsembleInfo);
		//virtual tVoid vOnGlobalListQueryResponse(trMeca_RDbQuery* poRDbQuery);
		virtual tVoid vQueryEnsembleServiceList(tU8 u8ECC , tU16 u16EId, tU8 u8TagCounter);
		virtual tVoid vOnEnsembleServiceListQueryResponse(trMeca_RDbQuery* poRDbQuery);

        // pseudo-private
        virtual tVoid vProcess(trMsgChnListUpdateTimer* poChnListUpdateTimer);
        virtual tVoid vProcess(trMsgChnListAfterLearnTimer* poChnListAfterLearnTimer);
		virtual tVoid vProcess(trMeca_RRdmAudioPlayAsid* poMecaRRdmPlayPsid);
		virtual tVoid vProcess(trMsgSrvValidateEPGData *poMsgSrvValidateEPGData);


        trChnListElem rGetElemFromFrozenList(tU16 u16ElemId);
		trEnsembleListElem rGetEnsembleElemFromFrozenList(tU16 u16ElemId);

        trEnsembleListElem rGetEnsembleInfo(trMecaEnsemble const &rMecaEnsemble);
        trChnListElem rGetFirstListElement();
		trChnListChnInfo rGetChnInfo(trMecaId const &rMecaId);
		trChnListChnInfo rGetChnInfo(trMecaId const &rMecaId, tU16 u16Scids);
        trMecaLabel rGetChnLabel(trMecaId const &rMecaId);
        tU16 u16GetFrozenListId(trChnListKey const &rchnListKey);
		tU16 u16GetFrozenEnsembleListId(trMecaEnsemble const &rEnsemble);
        trChnListElem rGetElemRelative(tS16 s16Steps);
		trEnsembleListElem rGetEnsElemRelative(tS16 s16Steps);
		trEnsembleListElem rGetMapEnsElemRelative(tS16 s16Steps);
        tVoid vGetEnsemblesOfProgSrv(trMecaProgrammeService const &rRefProgSrv, set<trMecaEnsemble>&lEnsembles) const;
        tVoid vGetEnsemblesWithTP(list<trMecaEnsemble>&lEnsembles, tU16 u16AnnoMask=0) const;
        tU8 u8GetReceptionQualityOfEnsemble(trMecaEnsemble const &rRefEnsemble) const;
        tU32 u32GetFrequencyOfService(trMecaProgrammeService const &rProgSrv, tU32 u32RefFreq=0) const;
        tBool bGetEnsembleInfo(trMecaEnsemble const &rRefEnsemble, tU8 &u8Quality, set<trMecaProgrammeService>&lServiceList);
        tBool bIsEnsembleContainsService(trMecaEnsemble const &rRefEnsemble, trMecaProgrammeService const &rService);

		tU8 u8GetPtyCode(trMeca_RDbServiceGetInfo* poSrvInfo) const;
		tVoid vExtractPtyCodes(tU32 u32PtyMask);
		tVoid vSendPtyFilter(tU8 u8PtyCode, tenMeca_PtyCommand enPtyCommand) const;

		tVoid vSetChnList(DAB::trMsgSrvCmdSetChnList *poCmdOpenList);
        
        tVoid vGetMachineData(trChnListMachineData *prChnListMachineData);
        tVoid vSetMachineData(trChnListMachineData const &rChnListMachineData);

        tU32 u32GetPtyFilter(){ return _u32PtyFilter; };

        tBool bIsFrozenListOpen() const {
            return _bFrozenChnListOpen;
        }

		tBool bIsMapServiceInfoEmpty() const {
            return _mapServiceInfo.empty();
        }





		trMecaLabel vGetEnsembleinfofromid(trMecaId const &rMecaId)
		{
			trMecaLabel rResInfo;
			trChnListKey rchnListKey(rMecaId);
			DAB_IF_FIND_MAP(trChnListKey, trChnListServiceInfo, iter_ServiceInfo, _mapServiceInfo, rchnListKey){
				rResInfo = iter_ServiceInfo->second.rEnsembleLabel;
			}
			
			return rResInfo;
		}


        




    struct trChnListMachineData {
    private:
        map<trChnListKey, trChnListServiceInfo >_mapServiceInfo;
        map<trMecaEnsemble, trChnListEnsembleInfo>_mapEnsembleInfo;
        map<trChnListKey, trChnListServiceInfo > *_pmapServiceInfo;
        map<trMecaEnsemble, trChnListEnsembleInfo> *_pmapEnsembleInfo;

    public:
        map<trChnListKey, trChnListServiceInfo >&roGetSrvInfo() {
            //lint --e(1536) Exposing low access member
            return _pmapServiceInfo ? *_pmapServiceInfo : _mapServiceInfo;
        }

        map<trChnListKey, trChnListServiceInfo > const &roGetSrvInfoConst() const {
            return _pmapServiceInfo ? *_pmapServiceInfo : _mapServiceInfo;
        }


        map<trMecaEnsemble, trChnListEnsembleInfo >&roGetEnsInfo() {
            //lint --e(1536) Exposing low access member
            return _pmapEnsembleInfo ? *_pmapEnsembleInfo : _mapEnsembleInfo;
        }

        map<trMecaEnsemble, trChnListEnsembleInfo > const &roGetEnsInfoConst() const {
            return _pmapEnsembleInfo ? *_pmapEnsembleInfo : _mapEnsembleInfo;
        }

        trChnListMachineData() {
            _pmapServiceInfo=&_mapServiceInfo;
            _pmapEnsembleInfo=&_mapEnsembleInfo;
        }
        
        tVoid vLink(map<trChnListKey, trChnListServiceInfo > &rmapServiceInfo,
              map<trMecaEnsemble, trChnListEnsembleInfo> &rmapEnsembleInfo) {
            _pmapServiceInfo=&rmapServiceInfo;
            _pmapEnsembleInfo=&rmapEnsembleInfo;
        }


        tVoid vUnLink() {
            _pmapServiceInfo=&_mapServiceInfo;
            _pmapEnsembleInfo=&_mapEnsembleInfo;
        }

        tVoid vTrace() const {
            tU32 u32NumChannels=(tU32)(_mapServiceInfo.size());
            ETG_TRACE_USR4(("  trChnListMachineData:u8NumChannels=%u",
                            u32NumChannels));
            tU32 u32NumEns=(tU32)(_mapEnsembleInfo.size());
            ETG_TRACE_USR4(("  trChnListMachineData:u32NumEns=%u",
                            u32NumEns));

            ETG_TRACE_USR4(("  trChnListMachineData:END"));
        }

            // persistant data serialization
            tVoid vSerialize(DAB_Serializer &rSerializer) const {
                rSerializer.vSerializeMap(roGetSrvInfoConst());
                rSerializer.vSerializeMap(roGetEnsInfoConst());
            }
            
            tVoid vParse(DAB_Parser &rParser) {
                vUnLink();
                rParser.vParseMap(_mapServiceInfo);
                rParser.vParseMap(_mapEnsembleInfo);
            }
    };

	 tVoid vSetEnsListSortingType(tenEnsembleListSortingType enType){ m_enEnsListSortingType=enType;}
	 tVoid vSetReadSrvListSortingType(tenServiceListSortingType enType){m_enSrvListSortingType=enType;}
	 tBool isEnsmbleReceptionStatusUpdated(vector<trChnListEnsembleInfo> &oldChnlListEnsembleInfo, set<trMecaEnsembleListElement> &newEnsembleInfoSet);
	 map<trChnListKey, trChnListServiceInfo > roGetSrvMap() const {
            return _mapServiceInfo;
        }

	 tVoid setbFrozenChnListOpen(tBool bFrozenChnListOpen){
		 _bFrozenChnListOpen = bFrozenChnListOpen;
	 }

	 vector<trEnsembleListElem> getvectorFrozenEnsmbleList(){
		 return _vectorFrozenEnsmbleList;
	 }

	 tBool bIsServiceInMap(trChnListKey rChnListKey){	
		 DAB_IF_FIND_MAP(trChnListKey, trChnListServiceInfo, iter, _mapServiceInfo, rChnListKey) {
			return TRUE;		   
		 }
		 else
			return FALSE;
	 }
	 tU16 u16GetActivatedElemId(tenFrozenListType rListType) ;

	 string sGetLogoLink(tU32 u32ServiceId,tBool bRequireSmallLogo = FALSE);
	 tBool u8GetDSSupport(tU32 rService, tU8 u8Scid);
	 tU8 u8GetNumEnsembles() { return _u8NumEnsembles; }
	 tU8 u8GetTagCounter() { return _u8TagCounter; }
	 tSize GetSize_mapQueryTagInfo() { return _mapQueryTagInfo.size();}
	 tU8 u8GetEnsembleCounter() { return _u8EnsembleCounter;}

    private:
        struct trChnListServiceInfoCompare
        {
            bool operator()(const trChnListServiceInfo& srv1, const trChnListServiceInfo& srv2) const
            {
                return (srv1.rLabel < srv2.rLabel);
            }
        };
        tVoid vTraceAll() const ;
        tVoid vTraceSrvInfo(trChnListServiceInfo const &rSrvInfo) const;
		tVoid vTraceEnsembleInfo(trEnsembleListElem const &rEnsInfo) const;
        tVoid vTraceSrvInfo(trChnListElem const &rSrvInfo) const;
        tBool bDynSrvListUpToDate() const;

		 tVoid vPrepareDynEnsList();

        tVoid vPrepareDynChnList();

		tVoid vUpdateDynChnList(trChnListServiceInfo &rServiceInfo);
		tVoid vOpenFrozenChnList(tBool bUpadteSDSSrvList=FALSE);
		tVoid vUpdateFrozenChnListbyLabel(vector<trChnListElem>&_vectorSrvList);
		tVoid vUpdateFrozenChnListbySID();
		tVoid vOpenFrozenEnsmbleList();
		tVoid vUpdateFrozenEnsmbleListById();
		tVoid vUpdateFrozenEnsmbleListByLabel();
		tVoid vUpdateFrozenEnsmbleListByFreq();
        
        // todo: inline
        tBool bIsInDynChnList(trMecaId const &rMecaId, trMecaLabel const &rLabel);
		 tBool bIsInDynChnList(trMecaId const &rMecaId) const;
        // todo: inline
        tBool bIsChnOk(trChnListServiceInfo &rSrvInfo) const;
		tBool bIsEnsembleOk(trChnListEnsembleInfo &rEnsInfo) const;
        tVoid vRequestEnsFreqList(trMecaEnsemble const &rEns) const;
        tVoid vStartSrvInfoCollect();
        tVoid vRequestNextSrvInfo();
        tVoid vChangeSrvEnsList(trMecaProgrammeService const &rSrv, trMecaEnsemble const &rEns, tBool bDelete=FALSE);

		tVoid vUpdateFrozenEnsListQuality(trMecaEnsemble const &rEns,tU8 u8NewEnsQuality=0,tBool bNewReception=FALSE);
        tVoid vSendUpdateSDS();


        /* interface to frozen chn list */
        tVoid vUpdateChnListClear();
        tVoid vUpdateChnListAdd(trMecaProgrammeService const &rSrv, tBool bReception);
        tVoid vUpdateChnListEmit(tBool bForced=FALSE);
        trReceptionState rUpdateReceptionQuality(trChnListServiceInfo &rServiceInfo);

        tVoid vMarkChanged() {_u32NumChanges++;};

        typedef enum {
            enListState_CheckVirgin,
            enListState_CheckChanged,
            enListState_CheckRefresh,
            enListState_Done
        } tenListCheckState;

        typedef enum {
            enForcedUpdateState_Idle,
            enForcedUpdateState_LearnRunning,
            enForcedUpdateState_AfterLearnWait,
            enForcedUpdateState_AfterLearnWaitLabel
        } tenForcedUpdateState;

#ifdef DABTUNER_UTEST
		map<trMecaEnsemble, trChnListEnsembleInfo> const getmapEnsembleinfo(){
				        	return _mapEnsembleInfo;
				        }

		map<trChnListKey, trChnListServiceInfo> const getmapServiceinfo(){
				        	return _mapServiceInfo;
				        }

		vector<trEnsembleListElem> const getvectorfrozenEnsemblelist(){
				        	return _vectorFrozenEnsmbleList;
				        }
#endif

        tBool bFordedUpdateRunning() const {
            return _enForcedUpdateState != enForcedUpdateState_Idle;
        }

        dabdrv_chnList();   
        DAB_tclTimer _oChnListUpdateTimer;
        DAB_tclTimer _oAfterLearnTimer;
        tU32 _u32ChnListUpdateTimerValMs;
        map<trMecaEnsemble, trChnListEnsembleInfo>_mapEnsembleInfo;
        map<trChnListKey, trChnListServiceInfo >_mapServiceInfo;
        multimap<trMecaLabel, trChnListKey>_mapDynSrvByLabel;
		map<tU8,trMecaEnsemble>_mapQueryTagInfo;
		set<trMecaId>_setDynSrvById;
        trMecaEnsemble _rCurrentEnsemble; 

        // frozen chnList
        map<trChnListKey, tU16>_mapFrozenIndexBySrv;
        vector<trChnListElem>_vectorFrozenSrvList;
        vector<trChnListElem>_vectorSDSSrvList;
        tBool _bFrozenChnListOpen;

		

		// frozen EnsembleList
		map<trMecaEnsemble, tU16>_mapFrozenIndexByEnsemble;
        vector<trEnsembleListElem>_vectorFrozenEnsmbleList;
		multimap<trMecaLabel, trMecaEnsemble>_mapDynEnsByLabel;
		set<trMecaEnsemble>_setDynEnsById;
		map<tU32, trMecaEnsemble>_mapDynEnsByFreq;
        tBool _bFrozenEnsmbleListOpen;

        // marker of changes in srv-list
        tU16 _u32NumChanges;
        
        trMecaId _rMonitoredSrvId;
        trMecaId _rCurrentSrvId;
        trChnListKey _rLastUpdatedService;
        tenListCheckState _enListCheckState;
        map<trChnListKey, trChnListServiceInfo >::iterator _iterUpdate;
        map<trChnListKey, trChnListServiceInfo >::iterator _iterUpdateStart;
        dabdrv_trTickTimer<dabdrv_chnList, trMsgChnList1sTick, 1> *poGet1sTickTimer() const {
            return dabdrv_trTickTimer<dabdrv_chnList, trMsgChnList1sTick, 1>::instance(); 
        }

        trMsgSrvRspUpdateChnList _rMsgUpdateChnList;
        tenForcedUpdateState _enForcedUpdateState;
        tU32 _u32UpdateId;

		tenChnListType _enChnListType;
		tenEnsembleListSortingType m_enEnsListSortingType;
		tenServiceListSortingType m_enSrvListSortingType;
		tU16 m_u16EnsembleIndex;

		vector<tU8>_vectorPTYCode;
		trMsgSrvCmdSetChnList _rPreSetChnListCmd;
		tU32 _u32PtyFilter;
		tU8 _u8PtyFilterIndex;

		//marker of number of ensembles
		tU8 _u8NumEnsembles;
		//marker of ensemble number
		tU8 _u8EnsembleCounter;
		tU8 _u8TagCounter;

		map<tU32,string>_mapLogoList;
		multimap<tU32,tU8>_mapContentIDList;

		tBool _bQueryEnsembleList;
		tBool _bBlockEnsembleListQuery;
		tBool _bEnableSDS;
    };




} //namespace DAB 

#endif
