/************************************************************************
 * FILE:       dabdrv_anno.cpp
 * PROJECT:        g3g
 * SW-COMPONENT:   
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:  Implementation of dabdrv_anno
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		 | Author                       | Modification
   
				
 *************************************************************************/

#include "fc_dabtuner_util.h"
#include "dabdrv_main.hpp"
#include "dabdrv_mecaIf.h"
#include "dabdrv_compInfo.hpp"
#include "dabdrv_anno.hpp"
#include "dabdrv_mute.hpp"
#include "dabdrv_testOperation.hpp"
#include "dabdrv_tsu.hpp"
#include "dabdrv_presets.hpp"

#ifndef DABTUNER_UTEST
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_fc_dabtuner_if.h"
#include "dp_generic_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS FC_DABTUNER_TR_DRV_ANNO 
#include "trcGenProj/Header/dabdrv_anno.cpp.trc.h"
#endif
// todo: no select to dab-module if anno is on same subchannel to avoid mute of dab-module
using namespace DAB;

#define ANNOHANDLING_INTERRUPTIBLE

namespace DAB {
    struct trMsgAnnoStopSupervisionTimer:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "trMsgAnnoStopSupervisionTimer"));
        };
    };

    struct trMsgAnnoFlagTimer:
        public DAB_Message
    {
        DAB_DISPATCH_IMPL
        virtual tVoid vTrace() const {
            ETG_TRACE_USR1_CLS((FC_DABTUNER_TR_UTIL_MSG, 
                                "trMsgAnnoFlagTimer"));
        };
    };
}
/*
*/
dabdrv_anno::dabdrv_anno():
    _lastAnnoActiveStatus(),
    _selectedAnnoActiveStatus(),
    _enAnnoSelectState(enAnnoSelectState_IDLE),
    _u16CfgAnnoTypesMask(0),
    _enCfgValidAnnoSources(enAnnoSource_CURRENT_ENSEMBLE),
    _enActAnnoSource(enAnnoSource_NONE),
	_mapRAnsAnnoList()
{
    vSubscribe<trMsgDrvStartComponent>();
    vSubscribe<trMsgDrvStopComponent>();

    vSubscribe<trMsgDrvRspMuteDone>();

    vSubscribe<trMsgDrvCmdSourceState>();
    vSubscribe<trMsgSrvCmdAnnoConfig>();
    vSubscribe<trMsgSrvCmdStopAnno>();

    vSubscribe<trMsgDrvIndPostChnSelect>();
	vSubscribe<trMsgDrvCmdSelectAnno>();
    vSubscribe<DAB_trChnInfoProperty>();

    vSubscribe<trMeca_RAnsAnnoActiveStatus>();
    vSubscribe<trMeca_RAnsSelectAnno>();

    vSubscribe<trMeca_RAnsSetAnnoMode>();
    //vSubscribe<trMeca_RAnsGetAnnoInfo>();
    vSubscribe<trMeca_RAnsConfigAnno>();

#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI //multi-user announcement
    vSubscribe<trMeca_RRdmStationSetUser>();
	vSubscribe<trMeca_RRdmStationTravelStore>();
#endif
    //vSubscribe<trMeca_RAnsEnableAnno>();

	/*fc_dabtuner_config *poConfig=fc_dabtuner_config::instance();
	if(poConfig->bGetAlarmEnable())
	{
    vSetAnsTypeBit(enMeca_AnsType_Alarm, &_u16CfgAnnoTypesMask);
	}*/

#ifndef DABTUNER_UTEST
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
	dp_tclDABTunerUsrDPAnnoUserSetting oAnnoUserSetting; //New multiuser DP
#else
	dp_tclDABTunerDPAnnoUserSetting oAnnoUserSetting; 
#endif
	tS32 sStatus = oAnnoUserSetting.s32GetData(_u16CfgAnnoTypesMask);
	ETG_TRACE_USR2(("  dabdrv_anno::dabdrv_anno() datapool read status =%d",
						sStatus));
#endif


    ETG_TRACE_USR2(("  dabdrv_anno::dabdrv_anno(): _u16CfgAnnoTypesMask=%x",
                        _u16CfgAnnoTypesMask));

    _enAnnoChnState=enAnnoChnState_Bad;

}

tVoid dabdrv_anno::vInit() {
    _oAnnoActivity.vSetChangesChannel(FALSE);
    dabdrv_main::instance()->vRegisterActivity(&_oAnnoActivity);
    _oAnnoStopSuperVisionTimer.vInit(instance(),trMsgAnnoStopSupervisionTimer());
    _oAnnoFlagTimer.vInit(instance(),trMsgAnnoFlagTimer());
}

tVoid dabdrv_anno::vDeInit() {
    _oAnnoStopSuperVisionTimer.vDeInit();
    _oAnnoFlagTimer.vDeInit();

}

tVoid dabdrv_anno::vTraceState() const {
    ETG_TRACE_USR1(("  dabdrv_anno STATE: AnnoSelectState=%d u16CfgAnnoTypesMask=0x%04x ActAnnoSource=%d",
                    ETG_CENUM(tenAnnoSelectState, _enAnnoSelectState),
                    _u16CfgAnnoTypesMask,
                    ETG_CENUM(tenAnnoSource, _enActAnnoSource)));   
}

tVoid dabdrv_anno::vProcess(trMsgAnnoStopSupervisionTimer *poStopSupervisionTimer) {
    (tVoid)poStopSupervisionTimer;
    _enAnnoSelectState = enAnnoSelectState_IDLE;
    vUpdateAnnoStatusProperty(_lastAnnoActiveStatus);
    _oAnnoActivity.vTerminated();
}

tVoid dabdrv_anno::vProcess(trMsgAnnoFlagTimer *poFlagTimer) {
    (tVoid)poFlagTimer;
	DAB_trChnInfoProperty rProperty=dabdrv_properties::instance()->oChnInfoProperty.oGet();
	rProperty.u16AvailableAnnoTypesMask=0x00;
	dabdrv_properties::instance()->oChnInfoProperty.vSet(rProperty);
    _enAnnoChnState=enAnnoChnState_Bad;
    vUpdateAnnoStatusProperty(_lastAnnoActiveStatus);
}

tVoid dabdrv_anno::vProcess(trMsgDrvStartComponent* poStart) {
    (tVoid)poStart;
    vSendConfigAnno();
}

tVoid dabdrv_anno::vProcess(trMsgDrvStopComponent* poStop) {
    (tVoid)poStop;
    _enAnnoSelectState = enAnnoSelectState_IDLE;
    _enAnnoSelectState=enAnnoSelectState_IDLE;
    _lastAnnoActiveStatus=trMeca_RAnsAnnoActiveStatus ();
    _selectedAnnoActiveStatus=trMeca_RAnsAnnoActiveStatus(); 
    _enAnnoChnState=enAnnoChnState_Bad;

    vUpdateAnnoStatusProperty(_lastAnnoActiveStatus);
}

tVoid dabdrv_anno::vSelectAnno(tBool bSelect,tU16 u16AnnoMask){
	ETG_TRACE_USR2(("  dabdrv_anno::vSelectAnno(): bSelect=%d Anno=%d",
                        bSelect,
						u16AnnoMask));
    // todo: check if we need timer-supervision for missing end of anno
    if (bSelect) {
#ifdef ANNOHANDLING_INTERRUPTIBLE
	DAB_IF_FIND_MAP(tU16,trMeca_RAnsAnnoActiveStatus,iterAnno,_mapRAnsAnnoList,u16AnnoMask){
					_selectedAnnoActiveStatus=iterAnno->second;
				}
#else
        _selectedAnnoActiveStatus=_lastAnnoActiveStatus;
#endif
        if (_enAnnoSelectState == enAnnoSelectState_PENDING) {
            // inform system about new activity
            _oAnnoActivity.vRequest();
        }
    }
    else {
        if (_enAnnoSelectState == enAnnoSelectState_SELECTING || 
            _enAnnoSelectState == enAnnoSelectState_SELECTED) {
            _enAnnoSelectState = enAnnoSelectState_DESELECTING;
            trMeca_CAnsSelectAnno oCSelectAnno(_selectedAnnoActiveStatus, FALSE);
            dabdrv_mecaIf::instance()->vSendMecaCommand(oCSelectAnno);
            _oAnnoStopSuperVisionTimer.vStart(DAB_ANNO_STOP_SUPERVISION_TIMER_MS);
        } else if (_oAnnoActivity.enGetState()==DAB_enDrvActivityState_Pending) {
            _enAnnoSelectState = enAnnoSelectState_IDLE;
            _oAnnoActivity.vTerminated();
        }
    }
    vUpdateAnnoStatusProperty(_lastAnnoActiveStatus);
}

tBool dabdrv_anno::bRunActivity() {
    if (_enAnnoSelectState == enAnnoSelectState_PENDING) {
        _enAnnoSelectState = enAnnoSelectState_SELECTING;
        if (_enActAnnoSource == enAnnoSource_CURRENT_SUBCHANNEL) {
            vSendSelectAnno();
        } else {
            trMsgDrvCmdRequestMute rRequestMute;
            DAB_vCallMsg(rRequestMute);
        }
        return TRUE;
    }
    // todo: asssert or error handling
    return FALSE;
}

tVoid dabdrv_anno::vProcess(DAB_trChnStateProperty *poChnStateProperty) {

	if(poChnStateProperty->enChnState == enChnState_Unavail)
	{
		ETG_TRACE_USR2(("  dabdrv_anno::DAB_trChnStateProperty():start supervision"));
        _oAnnoFlagTimer.vStart(DAB_ANNO_FLAG_LOST_TIMER_MS); 
	}
		
}

tVoid dabdrv_anno::vProcess(trMsgDrvRspMuteDone *poDrvRspMuteDone) {
    (tVoid)poDrvRspMuteDone;
    if (_enAnnoSelectState == enAnnoSelectState_SELECTING) {
        vSendSelectAnno();
    }
    else if (_enAnnoSelectState == enAnnoSelectState_DESELECTING) {
        vSelectAnno(FALSE);
    }
}


tVoid dabdrv_anno::vSendSelectAnno(){
    // select Announcement
    trMeca_CAnsSelectAnno oCSelectAnno(_selectedAnnoActiveStatus, TRUE);
    dabdrv_mecaIf::instance()->vSendMecaCommand(oCSelectAnno);
    vUpdateAnnoStatusProperty(_lastAnnoActiveStatus);
}

tVoid dabdrv_anno::vUpdateAnnoStatusProperty(trMeca_RAnsAnnoActiveStatus const &rAnnoActiveStatus, tBool bChnChanged) {

    // read property-value
    DAB_trAnnoStatusProperty oAnnoStatusProperty = dabdrv_properties::instance()->oAnnoStatusProperty.oGet();
    // change property-value
    oAnnoStatusProperty.enAnnoSelectState=_enAnnoSelectState;
    oAnnoStatusProperty.enActiveAnnoStatus=rAnnoActiveStatus.enActiveStatus;
    oAnnoStatusProperty.u16ActiveAnnoTypesMask=rAnnoActiveStatus.u16AnnoMask;

    ETG_TRACE_USR2(("  dabdrv_anno::vUpdateAnnoStatusProperty():new Channel enAnnoSelectState:%d enActiveAnnoStatus=%d u16ActiveAnnoTypesMask=%x u16AvailableAnnoTypesMask=%x u16CfgAnnoTypesMask=%x u16SelectedAnnoTypesMask=%x",
    	                ETG_CENUM(tenAnnoSelectState, oAnnoStatusProperty.enAnnoSelectState),
                        ETG_CENUM(tenMeca_AnsAnnoActiveStatus, oAnnoStatusProperty.enActiveAnnoStatus),
                        oAnnoStatusProperty.u16ActiveAnnoTypesMask,
                        oAnnoStatusProperty.u16AvailableAnnoTypesMask,
                        oAnnoStatusProperty.u16CfgAnnoTypesMask,
                        oAnnoStatusProperty.u16SelectedAnnoTypesMask));
    // get actual service-label of channel --> later service label of TA-subchannel
    DAB_trChnInfoProperty rChnInfoProperty=dabdrv_properties::instance()->oChnInfoProperty.oGet();
    if (bChnChanged) {
        ETG_TRACE_USR2(("  dabdrv_anno::vUpdateAnnoStatusProperty():new Channel"));
        _oAnnoFlagTimer.vStart(DAB_ANNO_FLAG_NEW_TIMER_MS);       // start 5s Timer
        _enAnnoChnState=enAnnoChnState_New;
    }
    else if (rChnInfoProperty.enChnState==enChnState_Stable && _enAnnoChnState!=enAnnoChnState_Stable) 
    {
        ETG_TRACE_USR2(("  dabdrv_anno::vUpdateAnnoStatusProperty():now stable"));
        _oAnnoFlagTimer.vStop();
        _enAnnoChnState=enAnnoChnState_Stable;
    } 
    else if (rChnInfoProperty.enChnState!=enChnState_Stable && 
               _enAnnoChnState==enAnnoChnState_Stable && 
               !_oAnnoFlagTimer.bIsRunning()) 
    {
        ETG_TRACE_USR2(("  dabdrv_anno::vUpdateAnnoStatusProperty():start supervision"));
        _oAnnoFlagTimer.vStart(DAB_ANNO_FLAG_LOST_TIMER_MS);       // start 120s Timer        
    }

    ETG_TRACE_USR1(("  dabdrv_anno::vUpdateAnnoStatusProperty(): annoSubCh=%x curSubCh=%x",
                    rAnnoActiveStatus.u8SubChId, dabdrv_compInfo::instance()->u8GetSubChannelId()));

    oAnnoStatusProperty.enActiveAnnoSource=_enActAnnoSource;


    oAnnoStatusProperty.rAnnoServiceLabel = rChnInfoProperty.rLabel;
    if (_enAnnoChnState!=enAnnoChnState_Bad) {
        oAnnoStatusProperty.u16AvailableAnnoTypesMask=rChnInfoProperty.u16AvailableAnnoTypesMask;
    } else {
        oAnnoStatusProperty.u16AvailableAnnoTypesMask=0;
        oAnnoStatusProperty.u16SelectedAnnoTypesMask=0;
    }

    if (oAnnoStatusProperty.enAnnoSelectState==enAnnoSelectState_IDLE) {
        ETG_TRACE_USR1(("  dabdrv_anno::vUpdateAnnoStatusProperty(): resetting u16ActiveAnnoTypesMask"));
        oAnnoStatusProperty.u16ActiveAnnoTypesMask=0;
        oAnnoStatusProperty.u16SelectedAnnoTypesMask=0;
    }

	DAB::trAnnoElement rAnnoElem;
	rAnnoElem.u16AnnoTypesMask = rAnnoActiveStatus.u16AnnoMask;
	rAnnoElem.enAnnoStatus = rAnnoActiveStatus.enActiveStatus;
	rAnnoElem.u8SubChId = rAnnoActiveStatus.u8SubChId;

	vUpdateAnnoStatusPropertyVector(rAnnoElem,oAnnoStatusProperty);
	
    // write new property-value if the source is of interest
    dabdrv_properties::instance()->oAnnoStatusProperty.vSet(oAnnoStatusProperty);

}
tVoid  dabdrv_anno::vUpdateAnnoStatusPropertyVector(DAB::trAnnoElement const &rAnnoElem, DAB_trAnnoStatusProperty &oAnnoStatusProperty) const{

	#ifdef ANNOHANDLING_INTERRUPTIBLE	

	tBool bPresent =FALSE;
	vector<DAB::trAnnoElement>::iterator iter = oAnnoStatusProperty.vectorAnnoList.begin();
	for (; (iter != oAnnoStatusProperty.vectorAnnoList.end())&&(oAnnoStatusProperty.vectorAnnoList.size()>0);){
		ETG_TRACE_USR2(("  dabdrv_anno::vUpdateAnnoStatusPropertyVector: Anno loop size %d",(tU16)(oAnnoStatusProperty.vectorAnnoList.size())));		
		if (rAnnoElem.enAnnoStatus== enMeca_AnsAnnoActiveStatus_Start) {
			if(*iter==rAnnoElem){
				bPresent =TRUE;
			}
			iter++;
		}
	else if((rAnnoElem.enAnnoStatus== enMeca_AnsAnnoActiveStatus_End) || 
		(rAnnoElem.enAnnoStatus== enMeca_AnsAnnoActiveStatus_Escaped)){
			 if(((*iter).u16AnnoTypesMask==rAnnoElem.u16AnnoTypesMask)
				&&((*iter).u8SubChId==rAnnoElem.u8SubChId))
				{	
					(*iter).enAnnoStatus=rAnnoElem.enAnnoStatus;
					 // write new property-value if the source is of interest
					dabdrv_properties::instance()->oAnnoStatusProperty.vSet(oAnnoStatusProperty);
					ETG_TRACE_USR2(("  dabdrv_anno::vUpdateAnnoStatusPropertyVector: Anno to be deleted"));			
					iter=oAnnoStatusProperty.vectorAnnoList.erase(iter);
				}
				else
			 {
				 iter++;
			}
		}
		else{
			if(((*iter).u16AnnoTypesMask==rAnnoElem.u16AnnoTypesMask)
				&&((*iter).u8SubChId==rAnnoElem.u8SubChId))
			{
				(*iter).enAnnoStatus=rAnnoElem.enAnnoStatus;
			}
			iter++;
		}
	}	
	if((!bPresent)&&
		(rAnnoElem.enAnnoStatus== enMeca_AnsAnnoActiveStatus_Start)){
			oAnnoStatusProperty.vectorAnnoList.push_back(rAnnoElem);
	}
	for(tU8 i=0 ;i<oAnnoStatusProperty.vectorAnnoList.size();i++)
	{
		ETG_TRACE_USR2(("  dabdrv_anno::vUpdateAnnoStatusPropertyVector external after: Index: %d AnnoTypesMask=0%04x enAnnoStatus=%d",
			i,
			oAnnoStatusProperty.vectorAnnoList[i].u16AnnoTypesMask,
			ETG_CENUM(tenMeca_AnsAnnoActiveStatus, oAnnoStatusProperty.vectorAnnoList[i].enAnnoStatus)));
	}
#endif
}

tVoid dabdrv_anno::vProcess(trMeca_RAnsAnnoActiveStatus* poRAnsAnnoActiveStatus) {
    // update property. 
    // quit selected anno if it is over
    // todo:what happens with escaped anno?
	if(0 == poRAnsAnnoActiveStatus->u16AnnoMask)
	{
		ETG_TRACE_USR2(("  dabdrv_anno::vProcess(trMeca_RAnsAnnoActiveStatus): Received Anno Mask as ZERO from ADR, hence ignoring."));
		return;
	}

    ETG_TRACE_USR2(("  dabdrv_anno::vProcess(trMeca_RAnsAnnoActiveStatus): enActiveStatus=%d enAnnoSourceInfo=%d u16AnnoMask=%x",
                        ETG_CENUM(tenMeca_AnsAnnoActiveStatus, poRAnsAnnoActiveStatus->enActiveStatus),
                        ETG_CENUM(tenMeca_AnsAnnoSourceInfo, poRAnsAnnoActiveStatus->enAnnoSourceInfo),
                        poRAnsAnnoActiveStatus->u16AnnoMask));



    // Deselect Anno in case
    _lastAnnoActiveStatus=*poRAnsAnnoActiveStatus;
    trMsgDrvCmdMuteRequest rMuteRequest;
    switch (_enAnnoSelectState) {
        case enAnnoSelectState_SELECTING:
        case enAnnoSelectState_SELECTED:
            if (poRAnsAnnoActiveStatus->enActiveStatus== enMeca_AnsAnnoActiveStatus_End || 
                poRAnsAnnoActiveStatus->enActiveStatus== enMeca_AnsAnnoActiveStatus_Escaped) {
                ETG_TRACE_USR2(("******* A N N O U N C E M E N T   E N D E D ********"));
                rMuteRequest.enMuteRequest = enMuteRequest_ANNO_END;
				if(poRAnsAnnoActiveStatus->u16AnnoMask == _selectedAnnoActiveStatus.u16AnnoMask){
                vSelectAnno(FALSE);
				//PSARCC30-2199 - Enable dab-fm Linking when TA is over.
				dabdrv_tsu::instance()->vRestoreMtcServiceLinking();
                                //NCG3D-126334 -Announcement state should be set as Deselecting only when received anno mask matches with the selected one.
				_enAnnoSelectState=enAnnoSelectState_DESELECTING;
				}
				
            }
            break;
        case enAnnoSelectState_IDLE:
            if (poRAnsAnnoActiveStatus->enActiveStatus== enMeca_AnsAnnoActiveStatus_Start) {
                ETG_TRACE_USR2(("******* A N N O U N C E M E N T   S T A R T S ********"));
                rMuteRequest.enMuteRequest = enMuteRequest_ANNO_START;
                _enAnnoSelectState=enAnnoSelectState_PENDING;
            }
            else if (poRAnsAnnoActiveStatus->enActiveStatus== enMeca_AnsAnnoActiveStatus_Escaped) {
                ETG_TRACE_USR2(("******* A N N O U N C E M E N T   E N D E D ********"));
				// PSARCC30-3105 -- Announcement state should be changed to idle if some other announcement is in queue. 
				DAB_trAnnoStatusProperty oAnnoStatusProperty = dabdrv_properties::instance()->oAnnoStatusProperty.oGet();
				for(tU8 i = 0; i < oAnnoStatusProperty.vectorAnnoList.size(); i++)
				{
					if(oAnnoStatusProperty.vectorAnnoList[i].enAnnoStatus == enMeca_AnsAnnoActiveStatus_Start)
					{
						_enAnnoSelectState=enAnnoSelectState_PENDING;
					}
				}
                rMuteRequest.enMuteRequest = enMuteRequest_ANNO_END;
               /* trMeca_CAnsSelectAnno oCSelectAnno(_selectedAnnoActiveStatus, FALSE);
                dabdrv_mecaIf::instance()->vSendMecaCommand(oCSelectAnno);
                _oAnnoStopSuperVisionTimer.vStart(DAB_ANNO_STOP_SUPERVISION_TIMER_MS);
                _enAnnoSelectState = enAnnoSelectState_DESELECTING;*/
            }
            break;
        case enAnnoSelectState_PENDING:
            if (poRAnsAnnoActiveStatus->enActiveStatus== enMeca_AnsAnnoActiveStatus_End || 
                poRAnsAnnoActiveStatus->enActiveStatus== enMeca_AnsAnnoActiveStatus_Escaped) {
                ETG_TRACE_USR2(("******* A N N O U N C E M E N T   E N D E D ********"));
                rMuteRequest.enMuteRequest = enMuteRequest_ANNO_END;
                _enAnnoSelectState=enAnnoSelectState_DESELECTING;
            }
            break;
        case enAnnoSelectState_DESELECTING:
			{
				if (poRAnsAnnoActiveStatus->enActiveStatus== enMeca_AnsAnnoActiveStatus_Start) {
					ETG_TRACE_USR2(("******* A N N O U N C E M E N T   S T A R T S ********"));
					rMuteRequest.enMuteRequest = enMuteRequest_ANNO_START;
					_enAnnoSelectState=enAnnoSelectState_PENDING;
				}
				else
				{
					rMuteRequest.enMuteRequest = enMuteRequest_NONE;
					_enAnnoSelectState=enAnnoSelectState_IDLE;
				}
			}
			break;
        default:
            rMuteRequest.enMuteRequest = enMuteRequest_NONE;
            _enAnnoSelectState=enAnnoSelectState_IDLE;
            break;

    }
    _enActAnnoSource=enAnnoSource_NONE;
    //DAB_vCallMsg(rMuteRequest);
    if (poRAnsAnnoActiveStatus->u8SubChId) {
        _enActAnnoSource=enAnnoSource_CURRENT_SUBCHANNEL;
    }
    else {
        _enActAnnoSource=enAnnoSource_CURRENT_ENSEMBLE;
    }

    //Update Tuner activity
    DAB_trTunerStatusProperty oTunerStatus = dabdrv_properties::instance()->oTunerStatusProperty.oGet();
    if(poRAnsAnnoActiveStatus->enActiveStatus== enMeca_AnsAnnoActiveStatus_Switched){
    	oTunerStatus.enTunerActivityType = DAB_enTunerActivityType_TAFOLLOWING;
    	dabdrv_properties::instance()->oTunerStatusProperty.vSet(oTunerStatus);
    }
    else{
      if(dabdrv_testOperation::instance()->enGetCurTestOp() == DAB_enTestOperation_INVALID){ //Fix for PSARCCB-7871,PSARCCB-8564
    	oTunerStatus.enTunerActivityType = DAB_enTunerActivityType_NORMAL;
    	dabdrv_properties::instance()->oTunerStatusProperty.vSet(oTunerStatus);
      }
    }

	vUpdateAnnostatusList(_lastAnnoActiveStatus);
    vUpdateAnnoStatusProperty(_lastAnnoActiveStatus);
}

tVoid dabdrv_anno::vProcess(trMeca_RAnsSelectAnno* poRAnsSelectAnno) {
    _enAnnoSelectState=(poRAnsSelectAnno->enAnnoSelectedStatus==enMeca_AnsAnnoSelectedStatus_Selected) ?
        enAnnoSelectState_SELECTED : enAnnoSelectState_IDLE;

	trMsgSrvRspAnnoSelect rAnnoRsp;
	rAnnoRsp.enRes = DAB_enResult_OK;
    if (_enAnnoSelectState==enAnnoSelectState_IDLE) {
        _oAnnoStopSuperVisionTimer.vStop();
        // quit activity
        _oAnnoActivity.vTerminated();
		rAnnoRsp.enRes = DAB_enResult_FAILED;
    }
    // update property
    DAB_trAnnoStatusProperty oAnnoStatusProperty = dabdrv_properties::instance()->oAnnoStatusProperty.oGet();
    oAnnoStatusProperty.enAnnoSelectState=_enAnnoSelectState;
    oAnnoStatusProperty.u16SelectedAnnoTypesMask=poRAnsSelectAnno->u16AnnoMask;

	DAB_vCallMsg(rAnnoRsp);
    dabdrv_properties::instance()->oAnnoStatusProperty.vSet(oAnnoStatusProperty);
}


tVoid dabdrv_anno::vProcess(trMeca_RAnsSetAnnoMode* poRAnsSetAnnoMode) {
    (tVoid)poRAnsSetAnnoMode;
    // todo: check if values are as sent
    ETG_TRACE_USR2(("  dabdrv_anno::vProcess(trMeca_RAnsSetAnnoMode): bFilterActive=%d bInterruptible=%d bOtherClusterSignalling=%d",
                        poRAnsSetAnnoMode->bFilterActive,
                        poRAnsSetAnnoMode->bInterruptible,
                        poRAnsSetAnnoMode->bOtherClusterSignalling));
}

/*tVoid dabdrv_anno::vProcess(trMeca_RAnsGetAnnoInfo* poRAnsGetAnnoInfo) {
    (tVoid)poRAnsGetAnnoInfo;
    // todo: not used, delete?
    ETG_TRACE_USR2(("  dabdrv_anno::vProcess(trMeca_RAnsGetAnnoInfo): u16AnnoActive=%x u16AnnoEnabled=%x "
                    "  u16AnnoFilterEnabled=%x u16AnnoSelected=%x",
                       poRAnsGetAnnoInfo->u16AnnoActive,
                       poRAnsGetAnnoInfo->u16AnnoEnabled,
                       poRAnsGetAnnoInfo->u16AnnoFilterEnabled,
                       poRAnsGetAnnoInfo->u16AnnoSelected));
}*/


tVoid dabdrv_anno::vProcess(trMeca_RAnsConfigAnno* poRAnsConfigAnno) {

    ETG_TRACE_USR2(("  dabdrv_anno::vProcess(trMeca_RAnsConfigAnno): u16AnnoTypesMask=0%04x u16AnnoFilterMask=0%04x",
                        poRAnsConfigAnno->u16AnnoTypesMask, 
                        poRAnsConfigAnno->u16AnnoFilterMask));

    DAB_trAnnoStatusProperty oAnnoStatusProperty = dabdrv_properties::instance()->oAnnoStatusProperty.oGet();
    oAnnoStatusProperty.u16CfgAnnoTypesMask=poRAnsConfigAnno->u16AnnoTypesMask;
    dabdrv_properties::instance()->oAnnoStatusProperty.vSet(oAnnoStatusProperty);
	DAB_vCallMsg(oAnnoStatusProperty); //Sending Forced Update
}

/*tVoid dabdrv_anno::vProcess(trMeca_RAnsEnableAnno* poRAnsEnableAnno) {

    ETG_TRACE_USR2(("  dabdrv_anno::vProcess(trMeca_RAnsEnableAnno): u16AnnoTypesMask=%x enAnsType=%x",
                        poRAnsEnableAnno->bMask, 
                        poRAnsEnableAnno->enAnsType));
    
  if ( poRAnsEnableAnno->enAnsType == enMeca_AnsType_Alarm )
    {
        trMeca_CAnsEnableAnno oCMecaEnableAnno;
        oCMecaEnableAnno.bMask = 1; 
        oCMecaEnableAnno.bFilter = 1; 
        oCMecaEnableAnno.enAnsType = enMeca_AnsType_RoadTrafficFlash;
        dabdrv_mecaIf::instance()->vSendMecaCommand(oCMecaEnableAnno);
    }
}*/

tVoid dabdrv_anno::vSendConfigAnno() {

    ETG_TRACE_USR2(("  dabdrv_anno::vSendConfigAnno(): _u16CfgAnnoTypesMask=%x",
                        _u16CfgAnnoTypesMask));


	/*fc_dabtuner_config *poConfig=fc_dabtuner_config::instance();
	if(poConfig->bGetAlarmEnable())
	{
		vSetAnsTypeBit(enMeca_AnsType_Alarm, &_u16CfgAnnoTypesMask);
	}*/


    trMeca_CAnsConfigAnno oCMecaConfigAnno;
    oCMecaConfigAnno.bSet=TRUE;
    oCMecaConfigAnno.u16AnnoTypesMask=_u16CfgAnnoTypesMask;
    oCMecaConfigAnno.u16AnnoFilterMask=0;
    dabdrv_mecaIf::instance()->vSendMecaCommand(oCMecaConfigAnno);
//#ifndef DABTUNER_UTEST

#ifndef DABTUNER_UTEST
	/* read current user config*/ 
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
	dp_tclDABTunerUsrDPAnnoUserSetting oAnnoUserSetting;
#else
	dp_tclDABTunerDPAnnoUserSetting oAnnoUserSetting;
#endif
	tS32 s32Returnvalue = oAnnoUserSetting.s32SetData(_u16CfgAnnoTypesMask);

	s32Returnvalue=s32Returnvalue; //to solve lint warning
#endif

	

    // take all global annos and annos valid for current region
    trMeca_CAnsSetAnnoMode oCMecaSetAnnoMode;
    oCMecaSetAnnoMode.enRegionFilter=enMeca_AnsRegionFilter_CurrentRegionsOrGlobalValid; 
    oCMecaSetAnnoMode.bFilterActive=FALSE;
    oCMecaSetAnnoMode.bOtherClusterSignalling=FALSE;
#ifdef ANNOHANDLING_INTERRUPTIBLE
	oCMecaSetAnnoMode.bInterruptible=TRUE;
#else
    oCMecaSetAnnoMode.bInterruptible=FALSE;
#endif
    dabdrv_mecaIf::instance()->vSendMecaCommand(oCMecaSetAnnoMode);
}
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
tVoid dabdrv_anno::vSetAnnoConfigFromDP() {
#ifndef DABTUNER_UTEST	
	dp_tclDABTunerUsrDPAnnoUserSetting oAnnoUserSetting;
	tS32 sStatus = oAnnoUserSetting.s32GetData(_u16CfgAnnoTypesMask);
	ETG_TRACE_USR2(("  dabdrv_anno::vSetAnnoConfigFromDP() datapool read status =%d",
						sStatus));

	ETG_TRACE_USR2(("  dabdrv_anno::vSetAnnoConfigFromDP(): _u16CfgAnnoTypesMask=%x",
						_u16CfgAnnoTypesMask));

	if(!sStatus)
	{
		vSendConfigAnno();
	}
#else
	vSendConfigAnno();
#endif
}


tVoid dabdrv_anno::vProcess(DAB::trMeca_RRdmStationSetUser* povSetUser) {
		tU8 currentUserId=0;	
#ifndef DABTUNER_UTEST
	dp_tclSrvIf objUserInfo;
	tS32 s32Status = objUserInfo.s32GetEndUser(currentUserId);
	ETG_TRACE_USR1(("dabdrv_anno::vProcess(trMeca_RRdmStationSetUser) s32Status=%d",s32Status));
#endif
	if(currentUserId == povSetUser->u8UserId)
	{
		vSetAnnoConfigFromDP();
	}

}

tVoid dabdrv_anno::vProcess(trMeca_RRdmStationTravelStore* poTravelStore){
	ETG_TRACE_USR1(("dabdrv_anno::vProcess(trMeca_RRdmStationTravelStore)"));
	switch(poTravelStore->enTravelStoreState){
	case enMeca_RdmTravelStoreState_DONE:
	case enMeca_RdmTravelStoreState_STARTED:
		{
			tU8 currentUserId=0;
#ifndef DABTUNER_UTEST
			dp_tclSrvIf objUserInfo;
			tS32 s32Status = objUserInfo.s32GetEndUser(currentUserId);
			ETG_TRACE_USR1(("dabdrv_anno::vProcess(trMeca_RRdmStationTravelStore) s32Status=%d",s32Status));
#endif
			if((poTravelStore->u8Mode == (tU8) DAB_enProfile_Delete)&& (dabdrv_presets::instance()->u8GetUserId() == currentUserId)){// Update ADR only when the delete profile is the current profile
				vSetAnnoConfigFromDP();		
			}
			break;
		}
	case enMeca_RdmTravelStoreState_COMMAND_REJECTED:
	case enMeca_RdmTravelStoreState_STOPPED:
	default:
		break;
	}
}
#endif


tVoid dabdrv_anno::vProcess(trMsgDrvCmdSourceState *poSourceState) {
    if (poSourceState->enSourceState==DAB_enSourceState_BG) {
        vSelectAnno(FALSE);
    }
    else if (poSourceState->enSourceState==DAB_enSourceState_FG_TA) {
        if (_enAnnoSelectState==enAnnoSelectState_PENDING) {
            vSelectAnno(TRUE);
        }
    }
    else if (_enAnnoSelectState == enAnnoSelectState_SELECTING || 
             _enAnnoSelectState == enAnnoSelectState_SELECTED) {
        vSelectAnno(FALSE);
    }
}


tVoid dabdrv_anno::vProcess(trMsgDrvCmdSelectAnno *poSelectAnno) {
    if (poSelectAnno->bSelect) {

        //Disable dab-fm Linking when TA pops UP
		//Issue  FM audio in DAB during DAB TA
    	dabdrv_tsu::instance()->vForceDisbaleServiceLinking();

        if (_enAnnoSelectState==enAnnoSelectState_PENDING) {
			vSelectAnno(TRUE,poSelectAnno->u16AnnoMask );
        }
    }
    else{
			dabdrv_tsu::instance()->vRestoreMtcServiceLinking();

    	if (_enAnnoSelectState == enAnnoSelectState_SELECTING ||
             _enAnnoSelectState == enAnnoSelectState_SELECTED) {
        	vSelectAnno(FALSE);
    	}
    }
}

tVoid dabdrv_anno::vProcess(trMsgSrvCmdAnnoConfig *poAnnoConfig)
{
    // values have to be reestablished after reset-adr
    _enCfgValidAnnoSources=poAnnoConfig->enAnnoSource;

	_u16CfgAnnoTypesMask=poAnnoConfig->u16AnnoTypesMask;
    /*if(poAnnoConfig->bEnable)
    	_u16CfgAnnoTypesMask=_u16CfgAnnoTypesMask | poAnnoConfig->u16AnnoTypesMask;
    else
    	_u16CfgAnnoTypesMask=_u16CfgAnnoTypesMask & (~poAnnoConfig->u16AnnoTypesMask);*/
	if(!poAnnoConfig->bEnable)                                                          // Send Stop Anno to ADR on receiving Setconfig with TA option Disabled
	{
		ETG_TRACE_USR2(("  dabdrv_anno::vProcess(trMsgSrvCmdAnnoConfig):bEnable = %d",poAnnoConfig->bEnable));
		trMsgSrvCmdStopAnno rSrvCmdStopAnno;
		vProcess(&rSrvCmdStopAnno);
	}

    ETG_TRACE_USR2(("  dabdrv_anno::vProcess(trMsgSrvCmdAnnoConfig): _u16CfgAnnoTypesMask=0%04x _enCfgValidAnnoSources=%d",
    						_u16CfgAnnoTypesMask,
                            _enCfgValidAnnoSources));

    vSendConfigAnno();
    poAnnoConfig->enRes=DAB_enResult_OK;
}

tVoid dabdrv_anno::vProcess(trMsgSrvCmdStopAnno *poStopAnno)
{
	ETG_TRACE_USR2(("  dabdrv_anno::trMsgSrvCmdStopAnno"));

    (tVoid)poStopAnno;
    if (_enAnnoSelectState==enAnnoSelectState_PENDING || 
        _enAnnoSelectState==enAnnoSelectState_IDLE) {
        return;
    }
	//PSARCC30-2199 - Enable dab-fm Linking when TA is cancelled by user.
	dabdrv_tsu::instance()->vRestoreMtcServiceLinking();

	ETG_TRACE_USR2(("  dabdrv_anno::trMsgSrvCmdStopAnno: _enActAnnoSource = %d", ETG_CENUM(tenAnnoSource, _enActAnnoSource)));

    // if anno!=idle && !=pending
    if (_enActAnnoSource == enAnnoSource_CURRENT_SUBCHANNEL) {
        vSelectAnno(FALSE);
    }
    else {
        trMsgDrvCmdRequestMute rRequestMute;
        DAB_vCallMsg(rRequestMute);
    }
}

tVoid dabdrv_anno::vProcess(trMsgDrvIndPostChnSelect *poIndPostChnSelect) {
    (tVoid)poIndPostChnSelect;
    // todo: check if anno is also valid in comp-mode
    vUpdateAnnoStatusProperty(_lastAnnoActiveStatus, TRUE);
}

tVoid dabdrv_anno::vProcess(DAB_trChnInfoProperty const *poChnInfoProperty) {
    (tVoid)poChnInfoProperty;
    vUpdateAnnoStatusProperty(_lastAnnoActiveStatus);
}

tVoid dabdrv_anno::vUpdateAnnostatusList(trMeca_RAnsAnnoActiveStatus const &rAnnoActiveStatus){
	vTraceAnnoStatusList();
	if (rAnnoActiveStatus.enActiveStatus== enMeca_AnsAnnoActiveStatus_Start) {
		map<tU16,trMeca_RAnsAnnoActiveStatus>::iterator iterAnno = _mapRAnsAnnoList.find(rAnnoActiveStatus.u16AnnoMask);
		trMeca_RAnsAnnoActiveStatus &rAnnoStatus = (*iterAnno).second;
		if(iterAnno!= _mapRAnsAnnoList.end()){
			if(rAnnoStatus.u8SubChId!=rAnnoActiveStatus.u8SubChId){
				 ETG_TRACE_USR2(("  dabdrv_anno::vUpdateAnnostatusList: ADDED ANno"));
		_mapRAnsAnnoList.insert(pair<tU16,trMeca_RAnsAnnoActiveStatus>(rAnnoActiveStatus.u16AnnoMask,rAnnoActiveStatus));
			}			
		}
		else{
			 ETG_TRACE_USR2(("  dabdrv_anno::vUpdateAnnostatusList: ADDED ANno"));
			_mapRAnsAnnoList.insert(pair<tU16,trMeca_RAnsAnnoActiveStatus>(rAnnoActiveStatus.u16AnnoMask,rAnnoActiveStatus));
		}
	}
	else if(rAnnoActiveStatus.enActiveStatus== enMeca_AnsAnnoActiveStatus_End || 
		rAnnoActiveStatus.enActiveStatus== enMeca_AnsAnnoActiveStatus_Escaped){
			DAB_FOREACH_MAP(tU16,trMeca_RAnsAnnoActiveStatus,iterAnno,_mapRAnsAnnoList) {
				trMeca_RAnsAnnoActiveStatus &rAnnoStatus = (*iterAnno).second;
				if(((*iterAnno).first ==rAnnoActiveStatus.u16AnnoMask)&&
					(rAnnoStatus.u8SubChId == rAnnoActiveStatus.u8SubChId)){
						 ETG_TRACE_USR2(("  dabdrv_anno::vUpdateAnnostatusList: DELETED ANno"));
						_mapRAnsAnnoList.erase(iterAnno);
						break;
				}
			}
	}
	vTraceAnnoStatusList();
}
tVoid dabdrv_anno::vTraceAnnoStatusList(){
	DAB_FOREACH_MAP(tU16,trMeca_RAnsAnnoActiveStatus,iterAnno,_mapRAnsAnnoList) {
		trMeca_RAnsAnnoActiveStatus &rAnnoStatus = (*iterAnno).second;
		ETG_TRACE_USR2(("  dabdrv_anno::vTraceAnnoStatusList: Size %d enActiveStatus=%d enAnnoSourceInfo=%d u16AnnoMask=%x ",
			(tU16)(_mapRAnsAnnoList.size()),
			ETG_CENUM(tenMeca_AnsAnnoActiveStatus, rAnnoStatus.enActiveStatus),
			ETG_CENUM(tenMeca_AnsAnnoSourceInfo, rAnnoStatus.enAnnoSourceInfo),
			rAnnoStatus.u16AnnoMask));
	}
}
